import { ssrRenderAttrs } from 'vue/server-renderer';
import { b as useRuntimeConfig } from './server.mjs';
import { ref, useSSRContext } from 'vue';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'pinia';
import 'vue-router';
import 'click-outside-vue3';

const useProfile = () => {
  const config = useRuntimeConfig();
  const loading = ref(false);
  const error = ref(null);
  const user = ref(null);
  const getProfile = async () => {
    try {
      loading.value = true;
      error.value = null;
      const token = false ? localStorage.getItem("shop_token") : null;
      if (!token) {
        throw new Error("Token not found");
      }
      const response = await $fetch(`${config.public.apiBase}/getUser`, {
        headers: {
          Authorization: `Bearer ${token}`
        }
      });
      user.value = response.user;
      return response;
    } catch (err) {
      console.error("خطا در دریافت پروفایل:", err);
      error.value = err;
    } finally {
      loading.value = false;
    }
  };
  return {
    getProfile,
    user,
    loading,
    error
  };
};
const _sfc_main = {
  __name: "account-info",
  __ssrInlineRender: true,
  setup(__props) {
    useProfile();
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/account-info.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=account-info-BmrPHGVE.mjs.map
