import { _ as __nuxt_component_0 } from './nuxt-link-DWMZ_O5T.mjs';
import { t as toPersianDigits } from './toPersianDigits-DB2ZciTc.mjs';
import { mergeProps, ref, resolveDirective, unref, withCtx, createVNode, toDisplayString, createBlock, openBlock, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr, ssrGetDirectiveProps, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import { IconSearch, IconGridDots, IconArrowLeft, IconSearchOff, IconChevronLeft } from '@tabler/icons-vue';
import { _ as _export_sfc, a as useRouter, b as useRuntimeConfig } from './server.mjs';
import { w as watchDebounced } from './index-CSB2znCu.mjs';
import { Swiper, SwiperSlide } from 'swiper/vue';
import { Autoplay, Pagination } from 'swiper/modules';
import { _ as __nuxt_component_0$1 } from './CardSkeleton-DlzHsUMp.mjs';
import { _ as _sfc_main$5 } from './ProductCard-BvqNuvr3.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'pinia';
import 'vue-router';
import 'click-outside-vue3';
import './cart-BfofACZK.mjs';

const _sfc_main$4 = {
  __name: "SearchBar",
  __ssrInlineRender: true,
  setup(__props) {
    const config = useRuntimeConfig();
    useRouter();
    const searchQuery = ref("");
    const products = ref([]);
    const categories = ref([]);
    const loading = ref(false);
    const showResults = ref(false);
    const fetchSuggestions = async () => {
      const query = searchQuery.value.trim();
      loading.value = true;
      try {
        const response = await $fetch(
          `${config.public.apiBase}/products/searchProduct?q=${query}`,
          {
            headers: {
              Authorization: `Bearer ${localStorage.getItem("shop_token")}`
            }
          }
        );
        categories.value = response.categories || [];
        products.value = response.products || [];
      } catch (error) {
        console.error("خطا در جستجو:", error);
        products.value = [];
        categories.value = [];
      } finally {
        loading.value = false;
      }
    };
    watchDebounced(
      searchQuery,
      (value) => {
        if (!value || value.length < 2) {
          products.value = [];
          categories.value = [];
          showResults.value = false;
          return;
        }
        showResults.value = true;
        fetchSuggestions();
      },
      { debounce: 1e3 }
    );
    const closeResults = () => {
      showResults.value = false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_NuxtLink = __nuxt_component_0;
      const _directive_click_outside = resolveDirective("click-outside");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative w-full px-4" }, _attrs, ssrGetDirectiveProps(_ctx, _directive_click_outside, closeResults)))}><div class="relative"><input${ssrRenderAttr("value", unref(searchQuery))} type="text" placeholder="دنبال چه کالایی میگردی؟" class="w-full bg-white dark:bg-gray-800 text-gray-900 dark:text-white placeholder:text-gray-500 dark:placeholder:text-gray-400 rounded-xl py-3.5 px-4 pr-12 text-sm focus:outline-none focus:ring-2 focus:ring-primary/30 dark:focus:ring-primary/50 transition-all duration-200 shadow-sm border border-gray-200 dark:border-gray-700">`);
      _push(ssrRenderComponent(unref(IconSearch), { class: "absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400 dark:text-gray-500" }, null, _parent));
      _push(`</div>`);
      if (unref(showResults) && unref(searchQuery).length >= 2) {
        _push(`<div class="z-50 w-full mt-2 bg-white dark:bg-gray-800 rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700 overflow-hidden">`);
        if (!unref(loading) && (unref(categories).length > 0 || unref(products).length > 0)) {
          _push(`<div class="px-5 py-3.5 bg-gray-50 dark:bg-gray-750 border-b border-gray-200 dark:border-gray-700"><div class="flex items-center justify-between"><div class="flex items-center gap-2.5">`);
          _push(ssrRenderComponent(unref(IconGridDots), { class: "w-5 h-5 text-gray-500 dark:text-gray-400" }, null, _parent));
          _push(`<span class="text-sm font-semibold text-gray-800 dark:text-gray-200"> همه کالاهای &quot;${ssrInterpolate(unref(searchQuery))}&quot; </span></div>`);
          _push(ssrRenderComponent(_component_NuxtLink, {
            to: `/search?q=${unref(searchQuery)}`,
            class: "text-xs text-primary hover:text-primary/80 font-medium flex items-center gap-1 transition-colors",
            onClick: closeResults
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span${_scopeId}>مشاهده‌ی همه نتایج</span>`);
                _push2(ssrRenderComponent(unref(IconArrowLeft), { class: "w-3.5 h-3.5" }, null, _parent2, _scopeId));
              } else {
                return [
                  createVNode("span", null, "مشاهده‌ی همه نتایج"),
                  createVNode(unref(IconArrowLeft), { class: "w-3.5 h-3.5" })
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="max-h-[500px] overflow-y-auto">`);
        if (unref(loading)) {
          _push(`<div class="px-5 py-12 flex flex-col items-center justify-center"><div class="w-10 h-10 border-3 border-primary border-t-transparent rounded-full animate-spin mb-4"></div><p class="text-sm text-gray-500 dark:text-gray-400 font-medium"> در حال جستجو... </p></div>`);
        } else if (unref(categories).length > 0 || unref(products).length > 0) {
          _push(`<div>`);
          if (unref(categories).length > 0) {
            _push(`<div><!--[-->`);
            ssrRenderList(unref(categories), (category) => {
              _push(ssrRenderComponent(_component_NuxtLink, {
                key: category.id,
                to: `/search/${category.slug}?q=${unref(searchQuery)}`,
                class: "flex items-center justify-between px-5 py-3 hover:bg-gray-50 dark:hover:bg-gray-700/40 transition-all duration-150 group",
                onClick: closeResults
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="flex items-center gap-3.5 flex-1 min-w-0"${_scopeId}><div class="w-9 h-9 rounded-full bg-primary/10 dark:bg-primary/20 flex items-center justify-center shrink-0 group-hover:bg-primary/15 dark:group-hover:bg-primary/25 transition-colors"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(IconSearch), { class: "w-4 h-4 text-primary" }, null, _parent2, _scopeId));
                    _push2(`</div><div class="flex-1 min-w-0"${_scopeId}><p class="text-sm font-semibold text-gray-800 dark:text-gray-200 truncate"${_scopeId}>${ssrInterpolate(unref(searchQuery))}</p><p class="text-sm font-medium text-primary dark:text-primary/90 truncate mt-0.5"${_scopeId}> در دسته ${ssrInterpolate(category.name)}</p></div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center gap-3.5 flex-1 min-w-0" }, [
                        createVNode("div", { class: "w-9 h-9 rounded-full bg-primary/10 dark:bg-primary/20 flex items-center justify-center shrink-0 group-hover:bg-primary/15 dark:group-hover:bg-primary/25 transition-colors" }, [
                          createVNode(unref(IconSearch), { class: "w-4 h-4 text-primary" })
                        ]),
                        createVNode("div", { class: "flex-1 min-w-0" }, [
                          createVNode("p", { class: "text-sm font-semibold text-gray-800 dark:text-gray-200 truncate" }, toDisplayString(unref(searchQuery)), 1),
                          createVNode("p", { class: "text-sm font-medium text-primary dark:text-primary/90 truncate mt-0.5" }, " در دسته " + toDisplayString(category.name), 1)
                        ])
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(categories).length > 0 && unref(products).length > 0) {
            _push(`<div class="border-t border-gray-200 dark:border-gray-700"></div>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(products).length > 0) {
            _push(`<div><!--[-->`);
            ssrRenderList(unref(products), (product) => {
              _push(ssrRenderComponent(_component_NuxtLink, {
                key: product.id,
                to: `/products/${product.id}`,
                class: "flex items-center justify-between px-5 py-3 hover:bg-gray-50 dark:hover:bg-gray-700/40 transition-all duration-150 group",
                onClick: closeResults
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="flex items-center gap-3.5 flex-1 min-w-0"${_scopeId}><div class="aspect-square rounded-sm overflow-hidden w-12 h-12 bg-gray-100"${_scopeId}><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${product.primary_image}`)}${ssrRenderAttr("alt", product.name)} class="w-full h-full object-contain p-1 rounded-sm"${_scopeId}></div><p class="text-sm text-gray-700 dark:text-gray-300 truncate flex-1 font-medium"${_scopeId}>${ssrInterpolate(product.name)}</p></div><div class="flex flex-col items-end"${_scopeId}><div class="flex items-baseline gap-1.5"${_scopeId}><span class="text-base md:text-lg font-black text-gray-900 dark:text-white"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
                      product.variation.sale_price || product.variation.price
                    ))}</span><span class="text-[10px] text-gray-500 dark:text-gray-400 font-medium"${_scopeId}> تومان </span></div><div class="ml-7 flex items-center h-4"${_scopeId}><span class="text-xs text-gray-400 dark:text-gray-300 line-through font-medium"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.variation.price))}</span></div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center gap-3.5 flex-1 min-w-0" }, [
                        createVNode("div", { class: "aspect-square rounded-sm overflow-hidden w-12 h-12 bg-gray-100" }, [
                          createVNode("img", {
                            src: `${unref(config).public.mediaBase}/${product.primary_image}`,
                            alt: product.name,
                            class: "w-full h-full object-contain p-1 rounded-sm"
                          }, null, 8, ["src", "alt"])
                        ]),
                        createVNode("p", { class: "text-sm text-gray-700 dark:text-gray-300 truncate flex-1 font-medium" }, toDisplayString(product.name), 1)
                      ]),
                      createVNode("div", { class: "flex flex-col items-end" }, [
                        createVNode("div", { class: "flex items-baseline gap-1.5" }, [
                          createVNode("span", { class: "text-base md:text-lg font-black text-gray-900 dark:text-white" }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
                            product.variation.sale_price || product.variation.price
                          )), 1),
                          createVNode("span", { class: "text-[10px] text-gray-500 dark:text-gray-400 font-medium" }, " تومان ")
                        ]),
                        createVNode("div", { class: "ml-7 flex items-center h-4" }, [
                          createVNode("span", { class: "text-xs text-gray-400 dark:text-gray-300 line-through font-medium" }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.variation.price)), 1)
                        ])
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else if (!unref(loading) && unref(searchQuery).length >= 2) {
          _push(`<div class="px-5 py-12 text-center"><div class="w-20 h-20 rounded-full bg-gray-100 dark:bg-gray-700 flex items-center justify-center mx-auto mb-4">`);
          _push(ssrRenderComponent(unref(IconSearchOff), { class: "w-10 h-10 text-gray-300 dark:text-gray-600" }, null, _parent));
          _push(`</div><p class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2"> نتیجه‌ای یافت نشد </p><p class="text-xs text-gray-500 dark:text-gray-400"> لطفاً کلمات دیگری را امتحان کنید </p></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Home/SearchBar.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = {
  __name: "BannerSlider",
  __ssrInlineRender: true,
  setup(__props) {
    const config = useRuntimeConfig();
    const banners = ref([]);
    const loading = ref(true);
    ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full bg-background px-4" }, _attrs))} data-v-6dc13d68>`);
      if (unref(loading)) {
        _push(`<div class="w-full h-[180px] rounded-[20px] bg-gray-200 dark:bg-gray-700 animate-pulse 1024:h-[400px] 1024:rounded-none relative overflow-hidden" data-v-6dc13d68><div class="absolute inset-0 -translate-x-full animate-[shimmer_2s_infinite] bg-linear-to-r from-transparent via-white/20 to-transparent" data-v-6dc13d68></div><div class="absolute bottom-4 left-1/2 -translate-x-1/2 flex gap-2" data-v-6dc13d68><div class="w-2 h-2 rounded-full bg-gray-300/50" data-v-6dc13d68></div><div class="w-2 h-2 rounded-full bg-gray-300/50" data-v-6dc13d68></div><div class="w-2 h-2 rounded-full bg-gray-300/50" data-v-6dc13d68></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-full" data-v-6dc13d68>`);
      _push(ssrRenderComponent(unref(Swiper), {
        modules: [unref(Autoplay), unref(Pagination)],
        loop: unref(banners).length > 1,
        autoplay: { delay: 5e3 },
        pagination: { clickable: true },
        class: "mySwiper"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(unref(banners), (banner, index2) => {
              _push2(ssrRenderComponent(unref(SwiperSlide), { key: index2 }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<img${ssrRenderAttr("src", `${unref(config).public.uploadsBase}/${banner.image}`)}${ssrRenderAttr("alt", `بنر ${index2 + 1}`)} class="w-full h-[180px] rounded-[20px] mx-auto object-cover 1024:w-full 1024:h-[400px] 1024:rounded-none" data-v-6dc13d68${_scopeId2}>`);
                  } else {
                    return [
                      createVNode("img", {
                        src: `${unref(config).public.uploadsBase}/${banner.image}`,
                        alt: `بنر ${index2 + 1}`,
                        class: "w-full h-[180px] rounded-[20px] mx-auto object-cover 1024:w-full 1024:h-[400px] 1024:rounded-none"
                      }, null, 8, ["src", "alt"])
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(unref(banners), (banner, index2) => {
                return openBlock(), createBlock(unref(SwiperSlide), { key: index2 }, {
                  default: withCtx(() => [
                    createVNode("img", {
                      src: `${unref(config).public.uploadsBase}/${banner.image}`,
                      alt: `بنر ${index2 + 1}`,
                      class: "w-full h-[180px] rounded-[20px] mx-auto object-cover 1024:w-full 1024:h-[400px] 1024:rounded-none"
                    }, null, 8, ["src", "alt"])
                  ]),
                  _: 2
                }, 1024);
              }), 128))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Home/BannerSlider.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["__scopeId", "data-v-6dc13d68"]]);
const _sfc_main$2 = {
  __name: "AmazingSection",
  __ssrInlineRender: true,
  setup(__props) {
    const products = ref([]);
    const loading = ref(true);
    ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_CardSkeleton = __nuxt_component_0$1;
      const _component_ProductCard = _sfc_main$5;
      if (unref(products).length > 0) {
        _push(`<section${ssrRenderAttrs(mergeProps({ class: "w-full px-4 py-6 bg-linear-to-b from-red-50 to-white dark:from-gray-900 dark:to-gray-800" }, _attrs))}><div><div class="flex items-center justify-between mb-5"><div class="flex items-center gap-2"><div class="w-1 h-6 bg-red-600 dark:bg-red-500 rounded-full"></div><h2 class="text-xl md:text-2xl font-black text-gray-900 dark:text-white"> پیشنهاد شگفت‌انگیز </h2></div>`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: "products/AllAmazings",
          class: "text-sm font-bold text-red-600 dark:text-red-400 flex items-center gap-1"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>مشاهده همه</span>`);
              _push2(ssrRenderComponent(unref(IconChevronLeft), { class: "w-4 h-4" }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", null, "مشاهده همه"),
                createVNode(unref(IconChevronLeft), { class: "w-4 h-4" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
        if (unref(loading)) {
          _push(`<div class="overflow-x-auto pb-2 scrollbar-hide"><div class="flex gap-3 p-2"><!--[-->`);
          ssrRenderList(10, (i) => {
            _push(ssrRenderComponent(_component_CardSkeleton, {
              class: "shrink-0 w-40",
              key: i
            }, null, _parent));
          });
          _push(`<!--]--></div></div>`);
        } else {
          _push(`<div class="w-full flex gap-3 overflow-x-auto p-2 scrollbar-hide"><!--[-->`);
          ssrRenderList(unref(products), (product) => {
            _push(ssrRenderComponent(_component_ProductCard, {
              key: product.id,
              product
            }, null, _parent));
          });
          _push(`<!--]--></div>`);
        }
        _push(`</div></section>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Home/AmazingSection.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "NewestSection",
  __ssrInlineRender: true,
  setup(__props) {
    const products = ref([]);
    const loading = ref(true);
    ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_CardSkeleton = __nuxt_component_0$1;
      const _component_ProductCard = _sfc_main$5;
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "w-full px-4 py-6 dark:bg-linear-to-b dark:from-gray-900 dark:to-gray-800" }, _attrs))}><div><div class="flex items-center justify-between mb-5"><div class="flex items-center gap-2"><div class="w-1 h-6 bg-linear-to-b from-blue-500 to-blue-600 dark:from-blue-400 dark:to-blue-500 rounded-full"></div><h2 class="text-xl md:text-2xl font-black text-gray-900 dark:text-white"> جدیدترین محصولات </h2></div>`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: "/products",
        class: "text-sm font-bold text-blue-600 dark:text-blue-400 flex items-center gap-1"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span${_scopeId}>مشاهده همه</span>`);
            _push2(ssrRenderComponent(unref(IconChevronLeft), { class: "w-4 h-4" }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode("span", null, "مشاهده همه"),
              createVNode(unref(IconChevronLeft), { class: "w-4 h-4" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      if (unref(loading)) {
        _push(`<div class="overflow-x-auto pb-2 scrollbar-hide"><div class="flex gap-3 p-2"><!--[-->`);
        ssrRenderList(10, (i) => {
          _push(ssrRenderComponent(_component_CardSkeleton, {
            class: "shrink-0 w-40",
            key: i
          }, null, _parent));
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<div class="w-full flex gap-3 overflow-x-auto p-2 scrollbar-hide"><!--[-->`);
        ssrRenderList(unref(products), (product) => {
          _push(ssrRenderComponent(_component_ProductCard, {
            key: product.id,
            product
          }, null, _parent));
        });
        _push(`<!--]--></div>`);
      }
      _push(`</div></section>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Home/NewestSection.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  const _component_SearchBar = _sfc_main$4;
  const _component_BannerSlider = __nuxt_component_1;
  const _component_AmazingSection = _sfc_main$2;
  const _component_NewestSection = _sfc_main$1;
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col space-y-6" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_SearchBar, null, null, _parent));
  _push(ssrRenderComponent(_component_BannerSlider, null, null, _parent));
  _push(ssrRenderComponent(_component_AmazingSection, null, null, _parent));
  _push(ssrRenderComponent(_component_NewestSection, null, null, _parent));
  _push(`</div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const index = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);

export { index as default };
//# sourceMappingURL=index-DM0JnOBR.mjs.map
