import { _ as _sfc_main$1 } from './ErrorState-qff2oEvB.mjs';
import { _ as __nuxt_component_0 } from './nuxt-link-DWMZ_O5T.mjs';
import { _ as _sfc_main$2 } from './ProductsListPage-CQIB43-V.mjs';
import { t as toPersianDigits } from './toPersianDigits-DB2ZciTc.mjs';
import { ref, resolveDirective, mergeProps, unref, withCtx, createVNode, toDisplayString, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrGetDirectiveProps, ssrRenderComponent, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import { IconSearch, IconGridDots, IconArrowLeft, IconSearchOff } from '@tabler/icons-vue';
import { c as useState, d as useRoute, a as useRouter, b as useRuntimeConfig } from './server.mjs';
import { w as watchDebounced } from './index-CSB2znCu.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import './CardSkeleton-DlzHsUMp.mjs';
import './ProductCard-BvqNuvr3.mjs';
import './cart-BfofACZK.mjs';
import 'pinia';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'vue-router';
import 'click-outside-vue3';

const _sfc_main = {
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "جستجو در همه محصولات";
    const config = useRuntimeConfig();
    useRoute();
    useRouter();
    const searchQuery = ref("");
    const products = ref([]);
    const categories = ref([]);
    const loading = ref(false);
    const error = ref(false);
    const showSuggestions = ref(false);
    const showProductsList = ref(false);
    const fetchSuggestions = async () => {
      const query = searchQuery.value.trim();
      products.value = [];
      categories.value = [];
      showSuggestions.value = true;
      loading.value = true;
      try {
        const response = await $fetch(
          `${config.public.apiBase}/products/searchProduct?q=${query}`,
          {
            headers: {
              Authorization: `Bearer ${localStorage.getItem("shop_token")}`
            }
          }
        );
        categories.value = response.categories || [];
        products.value = response.products || [];
      } catch (err) {
        console.error("خطا در جستجو:", err);
        error.value = true;
        products.value = [];
        categories.value = [];
      } finally {
        loading.value = false;
      }
    };
    watchDebounced(
      searchQuery,
      (value) => {
        if (!value || value.length < 2) {
          products.value = [];
          categories.value = [];
          showSuggestions.value = false;
          showProductsList.value = false;
          return;
        }
        showProductsList.value = false;
        fetchSuggestions();
      },
      { debounce: 800 }
    );
    const closeSuggestions = () => {
      showSuggestions.value = false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ErrorState = _sfc_main$1;
      const _component_NuxtLink = __nuxt_component_0;
      const _component_ProductsListPage = _sfc_main$2;
      const _directive_click_outside = resolveDirective("click-outside");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative w-full px-4" }, _attrs, ssrGetDirectiveProps(_ctx, _directive_click_outside, closeSuggestions)))}><div class="relative"><input${ssrRenderAttr("value", unref(searchQuery))} type="search" placeholder="دنبال چه کالایی میگردی؟" class="w-full bg-white dark:bg-gray-800 text-gray-900 dark:text-white placeholder:text-gray-500 dark:placeholder:text-gray-400 rounded-xl py-3.5 px-4 pr-12 text-sm focus:outline-none focus:ring-2 focus:ring-primary/30 dark:focus:ring-primary/50 transition-all duration-200 shadow-sm border border-gray-200 dark:border-gray-700">`);
      _push(ssrRenderComponent(unref(IconSearch), { class: "absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400 dark:text-gray-500" }, null, _parent));
      _push(`</div>`);
      if (unref(showSuggestions) && unref(searchQuery).length >= 2) {
        _push(`<div class="z-50 w-full mt-2 bg-white dark:bg-gray-800 rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700 overflow-hidden">`);
        if (!unref(loading) && (unref(categories).length > 0 || unref(products).length > 0)) {
          _push(`<div class="px-5 py-3.5 bg-gray-50 dark:bg-gray-750 border-b border-gray-200 dark:border-gray-700"><div class="flex items-center justify-between"><div class="flex items-center gap-2.5">`);
          _push(ssrRenderComponent(unref(IconGridDots), { class: "w-5 h-5 text-gray-500 dark:text-gray-400" }, null, _parent));
          _push(`<span class="text-sm font-semibold text-gray-800 dark:text-gray-200"> همه کالاهای &quot;${ssrInterpolate(unref(searchQuery))}&quot; </span></div><button class="text-xs text-primary hover:text-primary/80 font-medium flex items-center gap-1 transition-colors"><span>مشاهده‌ی همه نتایج</span>`);
          _push(ssrRenderComponent(unref(IconArrowLeft), { class: "w-3.5 h-3.5" }, null, _parent));
          _push(`</button></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="max-h-[500px] overflow-y-auto">`);
        if (unref(loading)) {
          _push(`<div class="px-5 py-12 flex flex-col items-center justify-center"><div class="w-10 h-10 border-3 border-primary border-t-transparent rounded-full animate-spin mb-4"></div><p class="text-sm text-gray-500 dark:text-gray-400 font-medium"> در حال جستجو... </p></div>`);
        } else if (unref(error)) {
          _push(`<div class="py-10">`);
          _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchSuggestions }, null, _parent));
          _push(`</div>`);
        } else if (unref(categories).length > 0 || unref(products).length > 0) {
          _push(`<div>`);
          if (unref(categories).length > 0) {
            _push(`<div><!--[-->`);
            ssrRenderList(unref(categories), (category) => {
              _push(ssrRenderComponent(_component_NuxtLink, {
                key: category.id,
                to: `/search/${category.slug}?q=${unref(searchQuery)}`,
                class: "flex items-center justify-between px-5 py-3 hover:bg-gray-50 dark:hover:bg-gray-700/40 transition-all duration-150 group",
                onClick: closeSuggestions
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="flex items-center gap-3.5 flex-1 min-w-0"${_scopeId}><div class="w-9 h-9 rounded-full bg-primary/10 dark:bg-primary/20 flex items-center justify-center shrink-0 group-hover:bg-primary/15 dark:group-hover:bg-primary/25 transition-colors"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(IconSearch), { class: "w-4 h-4 text-primary" }, null, _parent2, _scopeId));
                    _push2(`</div><div class="flex-1 min-w-0"${_scopeId}><p class="text-sm font-semibold text-gray-800 dark:text-gray-200 truncate"${_scopeId}>${ssrInterpolate(unref(searchQuery))}</p><p class="text-sm font-medium text-primary dark:text-primary/90 truncate mt-0.5"${_scopeId}> در دسته ${ssrInterpolate(category.name)}</p></div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center gap-3.5 flex-1 min-w-0" }, [
                        createVNode("div", { class: "w-9 h-9 rounded-full bg-primary/10 dark:bg-primary/20 flex items-center justify-center shrink-0 group-hover:bg-primary/15 dark:group-hover:bg-primary/25 transition-colors" }, [
                          createVNode(unref(IconSearch), { class: "w-4 h-4 text-primary" })
                        ]),
                        createVNode("div", { class: "flex-1 min-w-0" }, [
                          createVNode("p", { class: "text-sm font-semibold text-gray-800 dark:text-gray-200 truncate" }, toDisplayString(unref(searchQuery)), 1),
                          createVNode("p", { class: "text-sm font-medium text-primary dark:text-primary/90 truncate mt-0.5" }, " در دسته " + toDisplayString(category.name), 1)
                        ])
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(categories).length > 0 && unref(products).length > 0) {
            _push(`<div class="border-t border-gray-200 dark:border-gray-700"></div>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(products).length > 0) {
            _push(`<div><!--[-->`);
            ssrRenderList(unref(products), (product) => {
              _push(ssrRenderComponent(_component_NuxtLink, {
                key: product.id,
                to: `/products/${product.id}`,
                class: "flex items-center justify-between px-5 py-3 hover:bg-gray-50 dark:hover:bg-gray-700/40 transition-all duration-150 group",
                onClick: closeSuggestions
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="flex items-center gap-3.5 flex-1 min-w-0"${_scopeId}><div class="aspect-square rounded-sm overflow-hidden w-12 h-12 bg-gray-100"${_scopeId}><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${product.primary_image}`)}${ssrRenderAttr("alt", product.name)} class="w-full h-full object-contain p-1 rounded-sm"${_scopeId}></div><p class="text-sm text-gray-700 dark:text-gray-300 truncate flex-1 font-medium"${_scopeId}>${ssrInterpolate(product.name)}</p></div><div class="flex flex-col items-end"${_scopeId}><div class="flex items-baseline gap-1.5"${_scopeId}><span class="text-base md:text-lg font-black text-gray-900 dark:text-white"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
                      product.variation.sale_price || product.variation.price
                    ))}</span><span class="text-[10px] text-gray-500 dark:text-gray-400 font-medium"${_scopeId}> تومان </span></div><div class="ml-7 flex items-center h-4"${_scopeId}><span class="text-xs text-gray-400 dark:text-gray-300 line-through font-medium"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.variation.price))}</span></div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center gap-3.5 flex-1 min-w-0" }, [
                        createVNode("div", { class: "aspect-square rounded-sm overflow-hidden w-12 h-12 bg-gray-100" }, [
                          createVNode("img", {
                            src: `${unref(config).public.mediaBase}/${product.primary_image}`,
                            alt: product.name,
                            class: "w-full h-full object-contain p-1 rounded-sm"
                          }, null, 8, ["src", "alt"])
                        ]),
                        createVNode("p", { class: "text-sm text-gray-700 dark:text-gray-300 truncate flex-1 font-medium" }, toDisplayString(product.name), 1)
                      ]),
                      createVNode("div", { class: "flex flex-col items-end" }, [
                        createVNode("div", { class: "flex items-baseline gap-1.5" }, [
                          createVNode("span", { class: "text-base md:text-lg font-black text-gray-900 dark:text-white" }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
                            product.variation.sale_price || product.variation.price
                          )), 1),
                          createVNode("span", { class: "text-[10px] text-gray-500 dark:text-gray-400 font-medium" }, " تومان ")
                        ]),
                        createVNode("div", { class: "ml-7 flex items-center h-4" }, [
                          createVNode("span", { class: "text-xs text-gray-400 dark:text-gray-300 line-through font-medium" }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.variation.price)), 1)
                        ])
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else if (!unref(loading) && unref(searchQuery).length >= 2 && unref(categories).length === 0 && unref(products).length === 0) {
          _push(`<div class="px-5 py-12 text-center"><div class="w-20 h-20 rounded-full bg-gray-100 dark:bg-gray-700 flex items-center justify-center mx-auto mb-4">`);
          _push(ssrRenderComponent(unref(IconSearchOff), { class: "w-10 h-10 text-gray-300 dark:text-gray-600" }, null, _parent));
          _push(`</div><p class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2"> نتیجه‌ای یافت نشد </p><p class="text-xs text-gray-500 dark:text-gray-400"> لطفاً کلمات دیگری را امتحان کنید </p></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(showProductsList) && !unref(showSuggestions) && unref(searchQuery).length >= 2) {
        _push(ssrRenderComponent(_component_ProductsListPage, {
          endpoint: "/products",
          "page-title": "جستجو در همه محصولات"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/search/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=index-DUvF3q3D.mjs.map
