/**
 * @license @tabler/icons-vue v3.35.0 - MIT
 *
 * This source code is licensed under the MIT license.
 * See the LICENSE file in the root directory of this source tree.
 */

'use strict';

var vue = require('vue');

var defaultAttributes = {
  outline: {
    xmlns: "http://www.w3.org/2000/svg",
    width: 24,
    height: 24,
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": 2,
    "stroke-linecap": "round",
    "stroke-linejoin": "round"
  },
  filled: {
    xmlns: "http://www.w3.org/2000/svg",
    width: 24,
    height: 24,
    viewBox: "0 0 24 24",
    fill: "currentColor",
    stroke: "none"
  }
};

const createVueComponent = (type, iconName, iconNamePascal, iconNode) => ({ color = "currentColor", size = 24, stroke = 2, title, class: classes, ...rest }, { attrs, slots }) => {
  let children = [...iconNode.map((child) => vue.h(...child)), ...slots.default ? [slots.default()] : []];
  if (title)
    children = [vue.h("title", title), ...children];
  return vue.h(
    "svg",
    {
      ...defaultAttributes[type],
      width: size,
      height: size,
      ...attrs,
      class: ["tabler-icon", `tabler-icon-${iconName}`],
      ...type === "filled" ? {
        fill: color
      } : {
        "stroke-width": stroke ?? defaultAttributes[type]["stroke-width"],
        stroke: color
      },
      ...rest
    },
    children
  );
};

var IconAB2 = createVueComponent("outline", "a-b-2", "AB2", [["path", { "d": "M16 21h3c.81 0 1.48 -.67 1.48 -1.48l.02 -.02c0 -.82 -.69 -1.5 -1.5 -1.5h-3v3z", "key": "svg-0" }], ["path", { "d": "M16 15h2.5c.84 -.01 1.5 .66 1.5 1.5s-.66 1.5 -1.5 1.5h-2.5v-3z", "key": "svg-1" }], ["path", { "d": "M4 9v-4c0 -1.036 .895 -2 2 -2s2 .964 2 2v4", "key": "svg-2" }], ["path", { "d": "M2.99 11.98a9 9 0 0 0 9 9m9 -9a9 9 0 0 0 -9 -9", "key": "svg-3" }], ["path", { "d": "M8 7h-4", "key": "svg-4" }]]);

var IconABOff = createVueComponent("outline", "a-b-off", "ABOff", [["path", { "d": "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5", "key": "svg-0" }], ["path", { "d": "M12 12v6", "key": "svg-1" }], ["path", { "d": "M12 6v2", "key": "svg-2" }], ["path", { "d": "M16 8h3a2 2 0 1 1 0 4h-3m3 0a2 2 0 0 1 .83 3.82m-3.83 -3.82v-4", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconAB = createVueComponent("outline", "a-b", "AB", [["path", { "d": "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5", "key": "svg-0" }], ["path", { "d": "M12 6l0 12", "key": "svg-1" }], ["path", { "d": "M16 16v-8h3a2 2 0 0 1 0 4h-3m3 0a2 2 0 0 1 0 4h-3", "key": "svg-2" }]]);

var IconAbacusOff = createVueComponent("outline", "abacus-off", "AbacusOff", [["path", { "d": "M5 5v16", "key": "svg-0" }], ["path", { "d": "M19 21v-2m0 -4v-12", "key": "svg-1" }], ["path", { "d": "M5 7h2m4 0h8", "key": "svg-2" }], ["path", { "d": "M5 15h10", "key": "svg-3" }], ["path", { "d": "M8 13v4", "key": "svg-4" }], ["path", { "d": "M11 13v4", "key": "svg-5" }], ["path", { "d": "M16 16v1", "key": "svg-6" }], ["path", { "d": "M14 5v4", "key": "svg-7" }], ["path", { "d": "M11 5v2", "key": "svg-8" }], ["path", { "d": "M8 8v1", "key": "svg-9" }], ["path", { "d": "M3 21h18", "key": "svg-10" }], ["path", { "d": "M3 3l18 18", "key": "svg-11" }]]);

var IconAbacus = createVueComponent("outline", "abacus", "Abacus", [["path", { "d": "M5 3v18", "key": "svg-0" }], ["path", { "d": "M19 21v-18", "key": "svg-1" }], ["path", { "d": "M5 7h14", "key": "svg-2" }], ["path", { "d": "M5 15h14", "key": "svg-3" }], ["path", { "d": "M8 13v4", "key": "svg-4" }], ["path", { "d": "M11 13v4", "key": "svg-5" }], ["path", { "d": "M16 13v4", "key": "svg-6" }], ["path", { "d": "M14 5v4", "key": "svg-7" }], ["path", { "d": "M11 5v4", "key": "svg-8" }], ["path", { "d": "M8 5v4", "key": "svg-9" }], ["path", { "d": "M3 21h18", "key": "svg-10" }]]);

var IconAbc = createVueComponent("outline", "abc", "Abc", [["path", { "d": "M3 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M3 13h4", "key": "svg-1" }], ["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-1a2 2 0 1 0 -4 0v1", "key": "svg-2" }], ["path", { "d": "M20.732 12a2 2 0 0 0 -3.732 1v1a2 2 0 0 0 3.726 1.01", "key": "svg-3" }]]);

var IconAccessPointOff = createVueComponent("outline", "access-point-off", "AccessPointOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M14.828 9.172a4 4 0 0 1 1.172 2.828", "key": "svg-1" }], ["path", { "d": "M17.657 6.343a8 8 0 0 1 1.635 8.952", "key": "svg-2" }], ["path", { "d": "M9.168 14.828a4 4 0 0 1 0 -5.656", "key": "svg-3" }], ["path", { "d": "M6.337 17.657a8 8 0 0 1 0 -11.314", "key": "svg-4" }]]);

var IconAccessPoint = createVueComponent("outline", "access-point", "AccessPoint", [["path", { "d": "M12 12l0 .01", "key": "svg-0" }], ["path", { "d": "M14.828 9.172a4 4 0 0 1 0 5.656", "key": "svg-1" }], ["path", { "d": "M17.657 6.343a8 8 0 0 1 0 11.314", "key": "svg-2" }], ["path", { "d": "M9.168 14.828a4 4 0 0 1 0 -5.656", "key": "svg-3" }], ["path", { "d": "M6.337 17.657a8 8 0 0 1 0 -11.314", "key": "svg-4" }]]);

var IconAccessibleOff = createVueComponent("outline", "accessible-off", "AccessibleOff", [["path", { "d": "M10 16.5l2 -3l2 3m-2 -3v-1.5m2.627 -1.376l.373 -.124m-6 0l2.231 .744", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M12 8a.5 .5 0 1 0 -.5 -.5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAccessible = createVueComponent("outline", "accessible", "Accessible", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16.5l2 -3l2 3m-2 -3v-2l3 -1m-6 0l3 1", "key": "svg-1" }], ["circle", { "cx": "12", "cy": "7.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }]]);

var IconActivityHeartbeat = createVueComponent("outline", "activity-heartbeat", "ActivityHeartbeat", [["path", { "d": "M3 12h4.5l1.5 -6l4 12l2 -9l1.5 3h4.5", "key": "svg-0" }]]);

var IconActivity = createVueComponent("outline", "activity", "Activity", [["path", { "d": "M3 12h4l3 8l4 -16l3 8h4", "key": "svg-0" }]]);

var IconAd2 = createVueComponent("outline", "ad-2", "Ad2", [["path", { "d": "M11.933 5h-6.933v16h13v-8", "key": "svg-0" }], ["path", { "d": "M14 17h-5", "key": "svg-1" }], ["path", { "d": "M9 13h5v-4h-5z", "key": "svg-2" }], ["path", { "d": "M15 5v-2", "key": "svg-3" }], ["path", { "d": "M18 6l2 -2", "key": "svg-4" }], ["path", { "d": "M19 9h2", "key": "svg-5" }]]);

var IconAdCircleOff = createVueComponent("outline", "ad-circle-off", "AdCircleOff", [["path", { "d": "M4.91 4.949a9.968 9.968 0 0 0 -2.91 7.051c0 5.523 4.477 10 10 10a9.968 9.968 0 0 0 7.05 -2.909", "key": "svg-0" }], ["path", { "d": "M20.778 16.793a9.955 9.955 0 0 0 1.222 -4.793c0 -5.523 -4.477 -10 -10 -10c-1.74 0 -3.376 .444 -4.8 1.225", "key": "svg-1" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 2.138 -1.358", "key": "svg-2" }], ["path", { "d": "M9.854 9.853c.094 .196 .146 .415 .146 .647v4.5", "key": "svg-3" }], ["path", { "d": "M7 13h3", "key": "svg-4" }], ["path", { "d": "M14 14v1h1", "key": "svg-5" }], ["path", { "d": "M17 13v-2a2 2 0 0 0 -2 -2h-1v1", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconAdCircle = createVueComponent("outline", "ad-circle", "AdCircle", [["path", { "d": "M12 12m-10 0a10 10 0 1 0 20 0a10 10 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-1" }], ["path", { "d": "M7 13h3", "key": "svg-2" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-3" }]]);

var IconAdOff = createVueComponent("outline", "ad-off", "AdOff", [["path", { "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 15v-4a2 2 0 0 1 2 -2m2 2v4", "key": "svg-1" }], ["path", { "d": "M7 13h4", "key": "svg-2" }], ["path", { "d": "M17 9v4", "key": "svg-3" }], ["path", { "d": "M16.115 12.131c.33 .149 .595 .412 .747 .74", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAd = createVueComponent("outline", "ad", "Ad", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 15v-4a2 2 0 0 1 4 0v4", "key": "svg-1" }], ["path", { "d": "M7 13l4 0", "key": "svg-2" }], ["path", { "d": "M17 9v6h-1.5a1.5 1.5 0 1 1 1.5 -1.5", "key": "svg-3" }]]);

var IconAddressBookOff = createVueComponent("outline", "address-book-off", "AddressBookOff", [["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.57 3.399c-.363 .37 -.87 .601 -1.43 .601h-10a2 2 0 0 1 -2 -2v-12", "key": "svg-0" }], ["path", { "d": "M10 16h6", "key": "svg-1" }], ["path", { "d": "M11 11a2 2 0 0 0 2 2m2 -2a2 2 0 0 0 -2 -2", "key": "svg-2" }], ["path", { "d": "M4 8h3", "key": "svg-3" }], ["path", { "d": "M4 12h3", "key": "svg-4" }], ["path", { "d": "M4 16h3", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconAddressBook = createVueComponent("outline", "address-book", "AddressBook", [["path", { "d": "M20 6v12a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2z", "key": "svg-0" }], ["path", { "d": "M10 16h6", "key": "svg-1" }], ["path", { "d": "M13 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M4 8h3", "key": "svg-3" }], ["path", { "d": "M4 12h3", "key": "svg-4" }], ["path", { "d": "M4 16h3", "key": "svg-5" }]]);

var IconAdjustmentsAlt = createVueComponent("outline", "adjustments-alt", "AdjustmentsAlt", [["path", { "d": "M4 8h4v4h-4z", "key": "svg-0" }], ["path", { "d": "M6 4l0 4", "key": "svg-1" }], ["path", { "d": "M6 12l0 8", "key": "svg-2" }], ["path", { "d": "M10 14h4v4h-4z", "key": "svg-3" }], ["path", { "d": "M12 4l0 10", "key": "svg-4" }], ["path", { "d": "M12 18l0 2", "key": "svg-5" }], ["path", { "d": "M16 5h4v4h-4z", "key": "svg-6" }], ["path", { "d": "M18 4l0 1", "key": "svg-7" }], ["path", { "d": "M18 9l0 11", "key": "svg-8" }]]);

var IconAdjustmentsBolt = createVueComponent("outline", "adjustments-bolt", "AdjustmentsBolt", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-5" }], ["path", { "d": "M12 18v2", "key": "svg-6" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-7" }], ["path", { "d": "M18 4v1", "key": "svg-8" }], ["path", { "d": "M18 9v3", "key": "svg-9" }]]);

var IconAdjustmentsCancel = createVueComponent("outline", "adjustments-cancel", "AdjustmentsCancel", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.499 14.675a2 2 0 1 0 -1.499 3.325", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-9" }], ["path", { "d": "M17 21l4 -4", "key": "svg-10" }]]);

var IconAdjustmentsCheck = createVueComponent("outline", "adjustments-check", "AdjustmentsCheck", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.823 15.176a2 2 0 1 0 -2.638 2.651", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-5" }], ["path", { "d": "M18 4v1", "key": "svg-6" }], ["path", { "d": "M18 9v5", "key": "svg-7" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-8" }]]);

var IconAdjustmentsCode = createVueComponent("outline", "adjustments-code", "AdjustmentsCode", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.557 14.745a2 2 0 1 0 -1.557 3.255", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v4", "key": "svg-8" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-9" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-10" }]]);

var IconAdjustmentsCog = createVueComponent("outline", "adjustments-cog", "AdjustmentsCog", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.199 14.399a2 2 0 1 0 -1.199 3.601", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v2.5", "key": "svg-8" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-9" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-10" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-11" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-12" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-13" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-14" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-15" }]]);

var IconAdjustmentsDollar = createVueComponent("outline", "adjustments-dollar", "AdjustmentsDollar", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.366 14.54a2 2 0 1 0 -.216 3.097", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v1", "key": "svg-8" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-9" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-10" }]]);

var IconAdjustmentsDown = createVueComponent("outline", "adjustments-down", "AdjustmentsDown", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.945 15.53a2 2 0 1 0 -1.945 2.47", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 16v6", "key": "svg-9" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-10" }]]);

var IconAdjustmentsExclamation = createVueComponent("outline", "adjustments-exclamation", "AdjustmentsExclamation", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 16v3", "key": "svg-9" }], ["path", { "d": "M19 22v.01", "key": "svg-10" }]]);

var IconAdjustmentsHeart = createVueComponent("outline", "adjustments-heart", "AdjustmentsHeart", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M12 4v8.5", "key": "svg-3" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-4" }], ["path", { "d": "M18 4v1", "key": "svg-5" }], ["path", { "d": "M18 9v2.5", "key": "svg-6" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-7" }]]);

var IconAdjustmentsHorizontal = createVueComponent("outline", "adjustments-horizontal", "AdjustmentsHorizontal", [["path", { "d": "M14 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M4 6l8 0", "key": "svg-1" }], ["path", { "d": "M16 6l4 0", "key": "svg-2" }], ["path", { "d": "M8 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M4 12l2 0", "key": "svg-4" }], ["path", { "d": "M10 12l10 0", "key": "svg-5" }], ["path", { "d": "M17 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-6" }], ["path", { "d": "M4 18l11 0", "key": "svg-7" }], ["path", { "d": "M19 18l1 0", "key": "svg-8" }]]);

var IconAdjustmentsMinus = createVueComponent("outline", "adjustments-minus", "AdjustmentsMinus", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.954 15.574a2 2 0 1 0 -1.954 2.426", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v6", "key": "svg-8" }], ["path", { "d": "M16 19h6", "key": "svg-9" }]]);

var IconAdjustmentsOff = createVueComponent("outline", "adjustments-off", "AdjustmentsOff", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 6v2", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v4m0 4v2", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v5m0 4v2", "key": "svg-8" }], ["path", { "d": "M3 3l18 18", "key": "svg-9" }]]);

var IconAdjustmentsPause = createVueComponent("outline", "adjustments-pause", "AdjustmentsPause", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.627 14.836a2 2 0 1 0 -.62 2.892", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M17 17v5", "key": "svg-8" }], ["path", { "d": "M21 17v5", "key": "svg-9" }], ["path", { "d": "M18 9v4.5", "key": "svg-10" }]]);

var IconAdjustmentsPin = createVueComponent("outline", "adjustments-pin", "AdjustmentsPin", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.071 14.31a2 2 0 1 0 -1.071 3.69", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v2.5", "key": "svg-8" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-9" }], ["path", { "d": "M19 18v.01", "key": "svg-10" }]]);

var IconAdjustmentsPlus = createVueComponent("outline", "adjustments-plus", "AdjustmentsPlus", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.958 15.592a2 2 0 1 0 -1.958 2.408", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M16 19h6", "key": "svg-9" }], ["path", { "d": "M19 16v6", "key": "svg-10" }]]);

var IconAdjustmentsQuestion = createVueComponent("outline", "adjustments-question", "AdjustmentsQuestion", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.577 14.77a2 2 0 1 0 .117 2.295", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-6" }], ["path", { "d": "M12 18v2", "key": "svg-7" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-8" }], ["path", { "d": "M18 4v1", "key": "svg-9" }], ["path", { "d": "M18 9v2", "key": "svg-10" }]]);

var IconAdjustmentsSearch = createVueComponent("outline", "adjustments-search", "AdjustmentsSearch", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M12 14a2 2 0 0 0 -1.042 3.707", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-5" }], ["path", { "d": "M18 4v1", "key": "svg-6" }], ["path", { "d": "M18 9v2", "key": "svg-7" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-8" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-9" }]]);

var IconAdjustmentsShare = createVueComponent("outline", "adjustments-share", "AdjustmentsShare", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.387 14.56a2 2 0 1 0 -.798 3.352", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M16 22l5 -5", "key": "svg-8" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-9" }], ["path", { "d": "M18 9v4", "key": "svg-10" }]]);

var IconAdjustmentsSpark = createVueComponent("outline", "adjustments-spark", "AdjustmentsSpark", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.879 15.312a2 2 0 1 0 -2.26 2.652", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-5" }], ["path", { "d": "M18 4v1", "key": "svg-6" }], ["path", { "d": "M18 9v2.5", "key": "svg-7" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-8" }]]);

var IconAdjustmentsStar = createVueComponent("outline", "adjustments-star", "AdjustmentsStar", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M12 4v9.5", "key": "svg-3" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-4" }], ["path", { "d": "M18 4v1", "key": "svg-5" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-6" }], ["path", { "d": "M18 9v1", "key": "svg-7" }]]);

var IconAdjustmentsUp = createVueComponent("outline", "adjustments-up", "AdjustmentsUp", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.927 15.462a2 2 0 1 0 -1.927 2.538", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 22v-6", "key": "svg-9" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-10" }]]);

var IconAdjustmentsX = createVueComponent("outline", "adjustments-x", "AdjustmentsX", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.653 14.874a2 2 0 1 0 -.586 2.818", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v4", "key": "svg-8" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-9" }], ["path", { "d": "M17 22l5 -5", "key": "svg-10" }]]);

var IconAdjustments = createVueComponent("outline", "adjustments", "Adjustments", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v11", "key": "svg-8" }]]);

var IconAerialLift = createVueComponent("outline", "aerial-lift", "AerialLift", [["path", { "d": "M4 5l16 -2m-8 1v10m-5.106 -6h10.306c2.45 3 2.45 9 -.2 12h-10.106c-2.544 -3 -2.544 -9 0 -12zm-1.894 6h14", "key": "svg-0" }]]);

var IconAffiliate = createVueComponent("outline", "affiliate", "Affiliate", [["path", { "d": "M5.931 6.936l1.275 4.249m5.607 5.609l4.251 1.275", "key": "svg-0" }], ["path", { "d": "M11.683 12.317l5.759 -5.759", "key": "svg-1" }], ["path", { "d": "M5.5 5.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-2" }], ["path", { "d": "M18.5 5.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-3" }], ["path", { "d": "M18.5 18.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-4" }], ["path", { "d": "M8.5 15.5m-4.5 0a4.5 4.5 0 1 0 9 0a4.5 4.5 0 1 0 -9 0", "key": "svg-5" }]]);

var IconAi = createVueComponent("outline", "ai", "Ai", [["path", { "d": "M8 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M8 13h4", "key": "svg-1" }], ["path", { "d": "M16 8v8", "key": "svg-2" }]]);

var IconAirBalloon = createVueComponent("outline", "air-balloon", "AirBalloon", [["path", { "d": "M10 19m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 16c3.314 0 6 -4.686 6 -8a6 6 0 1 0 -12 0c0 3.314 2.686 8 6 8z", "key": "svg-1" }], ["path", { "d": "M12 9m-2 0a2 7 0 1 0 4 0a2 7 0 1 0 -4 0", "key": "svg-2" }]]);

var IconAirConditioningDisabled = createVueComponent("outline", "air-conditioning-disabled", "AirConditioningDisabled", [["path", { "d": "M3 8m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 16v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3", "key": "svg-1" }]]);

var IconAirConditioning = createVueComponent("outline", "air-conditioning", "AirConditioning", [["path", { "d": "M8 16a3 3 0 0 1 -3 3", "key": "svg-0" }], ["path", { "d": "M16 16a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M12 16v4", "key": "svg-2" }], ["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-3" }], ["path", { "d": "M7 13v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3", "key": "svg-4" }]]);

var IconAirTrafficControl = createVueComponent("outline", "air-traffic-control", "AirTrafficControl", [["path", { "d": "M11 3h2", "key": "svg-0" }], ["path", { "d": "M12 3v3", "key": "svg-1" }], ["path", { "d": "M5.998 6h12.004a2 2 0 0 1 1.916 2.575l-1.8 6a2 2 0 0 1 -1.916 1.425h-8.404a2 2 0 0 1 -1.916 -1.425l-1.8 -6a2 2 0 0 1 1.916 -2.575z", "key": "svg-2" }], ["path", { "d": "M8.5 6l1.5 10v5", "key": "svg-3" }], ["path", { "d": "M15.5 6l-1.5 10v5", "key": "svg-4" }]]);

var IconAlarmAverage = createVueComponent("outline", "alarm-average", "AlarmAverage", [["path", { "d": "M5 13a7 7 0 1 0 14 0a7 7 0 0 0 -14 0", "key": "svg-0" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-1" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-2" }], ["path", { "d": "M8 13h1l2 3l2 -6l2 3h1", "key": "svg-3" }]]);

var IconAlarmMinus = createVueComponent("outline", "alarm-minus", "AlarmMinus", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-1" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-2" }], ["path", { "d": "M10 13h4", "key": "svg-3" }]]);

var IconAlarmOff = createVueComponent("outline", "alarm-off", "AlarmOff", [["path", { "d": "M7.587 7.566a7 7 0 1 0 9.833 9.864m1.35 -2.645a7 7 0 0 0 -8.536 -8.56", "key": "svg-0" }], ["path", { "d": "M12 12v1h1", "key": "svg-1" }], ["path", { "d": "M5.261 5.265l-1.011 .735", "key": "svg-2" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconAlarmPlus = createVueComponent("outline", "alarm-plus", "AlarmPlus", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-1" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-2" }], ["path", { "d": "M10 13h4", "key": "svg-3" }], ["path", { "d": "M12 11v4", "key": "svg-4" }]]);

var IconAlarmSmoke = createVueComponent("outline", "alarm-smoke", "AlarmSmoke", [["path", { "d": "M18 8l-.8 3a1.25 1.25 0 0 1 -1.2 1h-8a1.25 1.25 0 0 1 -1.2 -1l-.8 -3", "key": "svg-0" }], ["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M12 16c.643 .288 1.017 .756 1 1.25c.017 .494 -.357 .962 -1 1.25s-1.017 .756 -1 1.25c-.017 .494 .357 .962 1 1.25", "key": "svg-2" }], ["path", { "d": "M7 16c.643 .288 1.017 .756 1 1.25c.017 .494 -.357 .962 -1 1.25s-1.017 .756 -1 1.25c-.017 .494 .357 .962 1 1.25", "key": "svg-3" }], ["path", { "d": "M17 16c.643 .288 1.017 .756 1 1.25c.017 .494 -.357 .962 -1 1.25s-1.017 .756 -1 1.25c-.017 .494 .357 .962 1 1.25", "key": "svg-4" }]]);

var IconAlarmSnooze = createVueComponent("outline", "alarm-snooze", "AlarmSnooze", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M10 11h4l-4 4h4", "key": "svg-1" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-2" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-3" }]]);

var IconAlarm = createVueComponent("outline", "alarm", "Alarm", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M12 10l0 3l2 0", "key": "svg-1" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-2" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-3" }]]);

var IconAlbumOff = createVueComponent("outline", "album-off", "AlbumOff", [["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.581 3.41c-.362 .364 -.864 .59 -1.419 .59h-12a2 2 0 0 1 -2 -2v-12c0 -.552 .224 -1.052 .585 -1.413", "key": "svg-0" }], ["path", { "d": "M12 4v4m1.503 1.497l.497 -.497l2 2v-7", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAlbum = createVueComponent("outline", "album", "Album", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 4v7l2 -2l2 2v-7", "key": "svg-1" }]]);

var IconAlertCircleOff = createVueComponent("outline", "alert-circle-off", "AlertCircleOff", [["path", { "d": "M5.644 5.629a9 9 0 1 0 12.715 12.741m1.693 -2.349a9 9 0 0 0 -12.087 -12.068", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAlertCircle = createVueComponent("outline", "alert-circle", "AlertCircle", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertHexagonOff = createVueComponent("outline", "alert-hexagon-off", "AlertHexagonOff", [["path", { "d": "M18.36 18.387l-5.268 3.333a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l1.317 -.777m2.535 -1.493l2.898 -1.709a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .414 -.116 .812 -.326 1.155", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M12 8v.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }], ["path", { "d": "M12 16h.01", "key": "svg-4" }]]);

var IconAlertHexagon = createVueComponent("outline", "alert-hexagon", "AlertHexagon", [["path", { "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertOctagon = createVueComponent("outline", "alert-octagon", "AlertOctagon", [["path", { "d": "M12.802 2.165l5.575 2.389c.48 .206 .863 .589 1.07 1.07l2.388 5.574c.22 .512 .22 1.092 0 1.604l-2.389 5.575c-.206 .48 -.589 .863 -1.07 1.07l-5.574 2.388c-.512 .22 -1.092 .22 -1.604 0l-5.575 -2.389a2.036 2.036 0 0 1 -1.07 -1.07l-2.388 -5.574a2.036 2.036 0 0 1 0 -1.604l2.389 -5.575c.206 -.48 .589 -.863 1.07 -1.07l5.574 -2.388a2.036 2.036 0 0 1 1.604 0z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertSmallOff = createVueComponent("outline", "alert-small-off", "AlertSmallOff", [["path", { "d": "M12 16h.01", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAlertSmall = createVueComponent("outline", "alert-small", "AlertSmall", [["path", { "d": "M12 8v4", "key": "svg-0" }], ["path", { "d": "M12 16h.01", "key": "svg-1" }]]);

var IconAlertSquareRoundedOff = createVueComponent("outline", "alert-square-rounded-off", "AlertSquareRoundedOff", [["path", { "d": "M19.201 19.199c-1.35 1.35 -3.6 1.801 -7.201 1.801c-7.2 0 -9 -1.8 -9 -9c0 -3.598 .45 -5.847 1.797 -7.197m2.626 -1.376c1.204 -.307 2.709 -.427 4.577 -.427c7.2 0 9 1.8 9 9c0 1.865 -.12 3.367 -.425 4.57", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAlertSquareRounded = createVueComponent("outline", "alert-square-rounded", "AlertSquareRounded", [["path", { "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertSquare = createVueComponent("outline", "alert-square", "AlertSquare", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertTriangleOff = createVueComponent("outline", "alert-triangle-off", "AlertTriangleOff", [["path", { "d": "M21.998 17.997a1.913 1.913 0 0 0 -.255 -.872l-8.106 -13.534a1.914 1.914 0 0 0 -3.274 0l-1.04 1.736m-1.493 2.493l-5.573 9.304a1.914 1.914 0 0 0 1.636 2.871h16.107", "key": "svg-0" }], ["path", { "d": "M12 16h.01", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }], ["path", { "d": "M12 7v1", "key": "svg-3" }]]);

var IconAlertTriangle = createVueComponent("outline", "alert-triangle", "AlertTriangle", [["path", { "d": "M12 9v4", "key": "svg-0" }], ["path", { "d": "M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlien = createVueComponent("outline", "alien", "Alien", [["path", { "d": "M11 17a2.5 2.5 0 0 0 2 0", "key": "svg-0" }], ["path", { "d": "M12 3c-4.664 0 -7.396 2.331 -7.862 5.595a11.816 11.816 0 0 0 2 8.592a10.777 10.777 0 0 0 3.199 3.064c1.666 1 3.664 1 5.33 0a10.777 10.777 0 0 0 3.199 -3.064a11.89 11.89 0 0 0 2 -8.592c-.466 -3.265 -3.198 -5.595 -7.862 -5.595z", "key": "svg-1" }], ["path", { "d": "M8 11l2 2", "key": "svg-2" }], ["path", { "d": "M16 11l-2 2", "key": "svg-3" }]]);

var IconAlignBoxBottomCenter = createVueComponent("outline", "align-box-bottom-center", "AlignBoxBottomCenter", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 15v2", "key": "svg-1" }], ["path", { "d": "M12 11v6", "key": "svg-2" }], ["path", { "d": "M15 13v4", "key": "svg-3" }]]);

var IconAlignBoxBottomLeft = createVueComponent("outline", "align-box-bottom-left", "AlignBoxBottomLeft", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 15v2", "key": "svg-1" }], ["path", { "d": "M10 11v6", "key": "svg-2" }], ["path", { "d": "M13 13v4", "key": "svg-3" }]]);

var IconAlignBoxBottomRight = createVueComponent("outline", "align-box-bottom-right", "AlignBoxBottomRight", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 15v2", "key": "svg-1" }], ["path", { "d": "M14 11v6", "key": "svg-2" }], ["path", { "d": "M17 13v4", "key": "svg-3" }]]);

var IconAlignBoxCenterBottom = createVueComponent("outline", "align-box-center-bottom", "AlignBoxCenterBottom", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 17h2", "key": "svg-1" }], ["path", { "d": "M9 14h6", "key": "svg-2" }], ["path", { "d": "M10 11h4", "key": "svg-3" }]]);

var IconAlignBoxCenterMiddle = createVueComponent("outline", "align-box-center-middle", "AlignBoxCenterMiddle", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 15h2", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M10 9h4", "key": "svg-3" }]]);

var IconAlignBoxCenterStretch = createVueComponent("outline", "align-box-center-stretch", "AlignBoxCenterStretch", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 17h2", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M10 7h4", "key": "svg-3" }]]);

var IconAlignBoxCenterTop = createVueComponent("outline", "align-box-center-top", "AlignBoxCenterTop", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 13h2", "key": "svg-1" }], ["path", { "d": "M9 10h6", "key": "svg-2" }], ["path", { "d": "M10 7h4", "key": "svg-3" }]]);

var IconAlignBoxLeftBottom = createVueComponent("outline", "align-box-left-bottom", "AlignBoxLeftBottom", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 17h-2", "key": "svg-1" }], ["path", { "d": "M13 14h-6", "key": "svg-2" }], ["path", { "d": "M11 11h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftMiddle = createVueComponent("outline", "align-box-left-middle", "AlignBoxLeftMiddle", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 15h-2", "key": "svg-1" }], ["path", { "d": "M13 12h-6", "key": "svg-2" }], ["path", { "d": "M11 9h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftStretch = createVueComponent("outline", "align-box-left-stretch", "AlignBoxLeftStretch", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M9 17h-2", "key": "svg-1" }], ["path", { "d": "M13 12h-6", "key": "svg-2" }], ["path", { "d": "M11 7h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftTop = createVueComponent("outline", "align-box-left-top", "AlignBoxLeftTop", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 13h-2", "key": "svg-1" }], ["path", { "d": "M13 10h-6", "key": "svg-2" }], ["path", { "d": "M11 7h-4", "key": "svg-3" }]]);

var IconAlignBoxRightBottom = createVueComponent("outline", "align-box-right-bottom", "AlignBoxRightBottom", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M15 17h2", "key": "svg-1" }], ["path", { "d": "M11 14h6", "key": "svg-2" }], ["path", { "d": "M13 11h4", "key": "svg-3" }]]);

var IconAlignBoxRightMiddle = createVueComponent("outline", "align-box-right-middle", "AlignBoxRightMiddle", [["path", { "d": "M15 15h2", "key": "svg-0" }], ["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-1" }], ["path", { "d": "M11 12h6", "key": "svg-2" }], ["path", { "d": "M13 9h4", "key": "svg-3" }]]);

var IconAlignBoxRightStretch = createVueComponent("outline", "align-box-right-stretch", "AlignBoxRightStretch", [["path", { "d": "M15 17h2", "key": "svg-0" }], ["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-1" }], ["path", { "d": "M11 12h6", "key": "svg-2" }], ["path", { "d": "M13 7h4", "key": "svg-3" }]]);

var IconAlignBoxRightTop = createVueComponent("outline", "align-box-right-top", "AlignBoxRightTop", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M15 13h2", "key": "svg-1" }], ["path", { "d": "M11 10h6", "key": "svg-2" }], ["path", { "d": "M13 7h4", "key": "svg-3" }]]);

var IconAlignBoxTopCenter = createVueComponent("outline", "align-box-top-center", "AlignBoxTopCenter", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 9v-2", "key": "svg-1" }], ["path", { "d": "M12 13v-6", "key": "svg-2" }], ["path", { "d": "M15 11v-4", "key": "svg-3" }]]);

var IconAlignBoxTopLeft = createVueComponent("outline", "align-box-top-left", "AlignBoxTopLeft", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9v-2", "key": "svg-1" }], ["path", { "d": "M10 13v-6", "key": "svg-2" }], ["path", { "d": "M13 11v-4", "key": "svg-3" }]]);

var IconAlignBoxTopRight = createVueComponent("outline", "align-box-top-right", "AlignBoxTopRight", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 9v-2", "key": "svg-1" }], ["path", { "d": "M14 13v-6", "key": "svg-2" }], ["path", { "d": "M17 11v-4", "key": "svg-3" }]]);

var IconAlignCenter = createVueComponent("outline", "align-center", "AlignCenter", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M8 12l8 0", "key": "svg-1" }], ["path", { "d": "M6 18l12 0", "key": "svg-2" }]]);

var IconAlignJustified = createVueComponent("outline", "align-justified", "AlignJustified", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M4 12l16 0", "key": "svg-1" }], ["path", { "d": "M4 18l12 0", "key": "svg-2" }]]);

var IconAlignLeft2 = createVueComponent("outline", "align-left-2", "AlignLeft2", [["path", { "d": "M4 4v16", "key": "svg-0" }], ["path", { "d": "M8 6h12", "key": "svg-1" }], ["path", { "d": "M8 12h6", "key": "svg-2" }], ["path", { "d": "M8 18h10", "key": "svg-3" }]]);

var IconAlignLeft = createVueComponent("outline", "align-left", "AlignLeft", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M4 12l10 0", "key": "svg-1" }], ["path", { "d": "M4 18l14 0", "key": "svg-2" }]]);

var IconAlignRight2 = createVueComponent("outline", "align-right-2", "AlignRight2", [["path", { "d": "M20 4v16", "key": "svg-0" }], ["path", { "d": "M4 6h12", "key": "svg-1" }], ["path", { "d": "M10 12h6", "key": "svg-2" }], ["path", { "d": "M6 18h10", "key": "svg-3" }]]);

var IconAlignRight = createVueComponent("outline", "align-right", "AlignRight", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M10 12l10 0", "key": "svg-1" }], ["path", { "d": "M6 18l14 0", "key": "svg-2" }]]);

var IconAlpha = createVueComponent("outline", "alpha", "Alpha", [["path", { "d": "M18.1 6c-1.1 2.913 -1.9 4.913 -2.4 6c-1.879 4.088 -3.713 6 -6 6c-2.4 0 -4.8 -2.4 -4.8 -6s2.4 -6 4.8 -6c2.267 0 4.135 1.986 6 6c.512 1.102 1.312 3.102 2.4 6", "key": "svg-0" }]]);

var IconAlphabetArabic = createVueComponent("outline", "alphabet-arabic", "AlphabetArabic", [["path", { "d": "M10 6v4", "key": "svg-0" }], ["path", { "d": "M13 14h8q -2.518 -3 -4 -3", "key": "svg-1" }], ["path", { "d": "M13 6v9.958c0 .963 0 1.444 -.293 1.743s-.764 .299 -1.707 .299h-1", "key": "svg-2" }], ["path", { "d": "M7 6v9.958c0 .963 0 1.444 -.293 1.743s-.764 .299 -1.707 .299h-1", "key": "svg-3" }]]);

var IconAlphabetBangla = createVueComponent("outline", "alphabet-bangla", "AlphabetBangla", [["path", { "d": "M14 12c.904 -.027 3 2 3 7", "key": "svg-0" }], ["path", { "d": "M10 11c0 -.955 0 -2 .786 -2.677c1.262 -1.089 3.025 .55 3.2 2.06c.086 .741 -.215 3.109 -1.489 4.527c-.475 .53 -.904 .992 -1.711 1.074c-.75 .076 -1.364 -.122 -2.076 -.588c-1.138 -.743 -2.327 -1.997 -3.336 -3.73c-1.078 -1.849 -1.66 -3.113 -2.374 -5.666", "key": "svg-1" }], ["path", { "d": "M7.37 7.072c.769 -.836 5.246 -4.094 8.4 -.202c.382 .472 .573 .708 .9 1.63c.326 .921 .326 1.562 .326 2.844v7.656", "key": "svg-2" }], ["path", { "d": "M17 10c0 -1.989 1.5 -4 4 -4", "key": "svg-3" }]]);

var IconAlphabetCyrillic = createVueComponent("outline", "alphabet-cyrillic", "AlphabetCyrillic", [["path", { "d": "M6 10h2a2 2 0 0 1 2 2v5h-3a2 2 0 1 1 0 -4h3", "key": "svg-0" }], ["path", { "d": "M19 7h-3a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1a2 2 0 0 0 2 -2v-3a2 2 0 0 0 -2 -2h-3", "key": "svg-1" }]]);

var IconAlphabetGreek = createVueComponent("outline", "alphabet-greek", "AlphabetGreek", [["path", { "d": "M10 10v7", "key": "svg-0" }], ["path", { "d": "M5 10m0 2a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M14 20v-11a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2", "key": "svg-2" }]]);

var IconAlphabetHebrew = createVueComponent("outline", "alphabet-hebrew", "AlphabetHebrew", [["path", { "d": "M7 6c2.333 5.143 6.611 6.857 9.333 12", "key": "svg-0" }], ["path", { "d": "M13.667 14c2.505 -1.5 2.666 -4.141 2.666 -5.333c0 -1.778 -.443 -2.667 -.443 -2.667", "key": "svg-1" }], ["path", { "d": "M7.485 18s-.485 -.905 -.485 -2.714c0 -1.172 .164 -3.722 2.641 -5.27", "key": "svg-2" }]]);

var IconAlphabetKorean = createVueComponent("outline", "alphabet-korean", "AlphabetKorean", [["path", { "d": "M7 7h6c0 2.5 -1.593 8.474 -6 10", "key": "svg-0" }], ["path", { "d": "M16 5v14z", "key": "svg-1" }], ["path", { "d": "M16 12h2", "key": "svg-2" }]]);

var IconAlphabetLatin = createVueComponent("outline", "alphabet-latin", "AlphabetLatin", [["path", { "d": "M6 10h2a2 2 0 0 1 2 2v5h-3a2 2 0 1 1 0 -4h3", "key": "svg-0" }], ["path", { "d": "M14 7v10", "key": "svg-1" }], ["path", { "d": "M14 10m0 2a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2z", "key": "svg-2" }]]);

var IconAlphabetThai = createVueComponent("outline", "alphabet-thai", "AlphabetThai", [["path", { "d": "M8 18v-3.444c0 -.49 .165 -.924 .494 -1.363c.326 -.449 1.009 -.76 1.506 -.934c.032 -.011 .035 -.079 .004 -.095c-.434 -.22 -1.294 -.52 -1.626 -1.032l-.014 -.021l-.083 -.125c-.281 -.42 -.281 -1.246 -.281 -1.246c0 -1.456 .849 -2.62 1.837 -3.199q .9 -.54 2.137 -.541q 1.077 0 1.995 .47c1.328 .647 2.031 2.202 2.031 3.976v7.554", "key": "svg-0" }]]);

var IconAlt = createVueComponent("outline", "alt", "Alt", [["path", { "d": "M4 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M4 13h4", "key": "svg-1" }], ["path", { "d": "M11 8v8h4", "key": "svg-2" }], ["path", { "d": "M16 8h4", "key": "svg-3" }], ["path", { "d": "M18 8v8", "key": "svg-4" }]]);

var IconAmbulance = createVueComponent("outline", "ambulance", "Ambulance", [["path", { "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 17h-2v-11a1 1 0 0 1 1 -1h9v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5", "key": "svg-2" }], ["path", { "d": "M6 10h4m-2 -2v4", "key": "svg-3" }]]);

var IconAmpersand = createVueComponent("outline", "ampersand", "Ampersand", [["path", { "d": "M19 20l-10.403 -10.972a2.948 2.948 0 0 1 0 -4.165a2.94 2.94 0 0 1 4.161 0a2.948 2.948 0 0 1 0 4.165l-4.68 4.687a3.685 3.685 0 0 0 0 5.207a3.675 3.675 0 0 0 5.2 0l5.722 -5.922", "key": "svg-0" }]]);

var IconAnalyzeOff = createVueComponent("outline", "analyze-off", "AnalyzeOff", [["path", { "d": "M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.086 8.086 0 0 0 -4.31 .62m-2.383 1.608a8.089 8.089 0 0 0 -1.326 1.69", "key": "svg-0" }], ["path", { "d": "M4 13a8.1 8.1 0 0 0 13.687 4.676", "key": "svg-1" }], ["path", { "d": "M20 16a1 1 0 0 0 -1 -1", "key": "svg-2" }], ["path", { "d": "M5 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9.888 9.87a3 3 0 1 0 4.233 4.252m.595 -3.397a3.012 3.012 0 0 0 -1.426 -1.435", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAnalyze = createVueComponent("outline", "analyze", "Analyze", [["path", { "d": "M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.095 8.095 0 0 0 -8.019 3.918", "key": "svg-0" }], ["path", { "d": "M4 13a8.1 8.1 0 0 0 15 3", "key": "svg-1" }], ["path", { "d": "M19 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M5 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }]]);

var IconAnchorOff = createVueComponent("outline", "anchor-off", "AnchorOff", [["path", { "d": "M12 12v9", "key": "svg-0" }], ["path", { "d": "M4 13a8 8 0 0 0 14.138 5.13m1.44 -2.56a7.99 7.99 0 0 0 .422 -2.57", "key": "svg-1" }], ["path", { "d": "M21 13h-2", "key": "svg-2" }], ["path", { "d": "M5 13h-2", "key": "svg-3" }], ["path", { "d": "M12.866 8.873a3 3 0 1 0 -3.737 -3.747", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAnchor = createVueComponent("outline", "anchor", "Anchor", [["path", { "d": "M12 9v12m-8 -8a8 8 0 0 0 16 0m1 0h-2m-14 0h-2", "key": "svg-0" }], ["path", { "d": "M12 6m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }]]);

var IconAngle = createVueComponent("outline", "angle", "Angle", [["path", { "d": "M21 19h-18l9 -15", "key": "svg-0" }], ["path", { "d": "M20.615 15.171h.015", "key": "svg-1" }], ["path", { "d": "M19.515 11.771h.015", "key": "svg-2" }], ["path", { "d": "M17.715 8.671h.015", "key": "svg-3" }], ["path", { "d": "M15.415 5.971h.015", "key": "svg-4" }]]);

var IconAnkh = createVueComponent("outline", "ankh", "Ankh", [["path", { "d": "M6 13h12", "key": "svg-0" }], ["path", { "d": "M12 21v-8l-.422 -.211a6.472 6.472 0 0 1 -3.578 -5.789a4 4 0 1 1 8 0a6.472 6.472 0 0 1 -3.578 5.789l-.422 .211", "key": "svg-1" }]]);

var IconAntennaBars1 = createVueComponent("outline", "antenna-bars-1", "AntennaBars1", [["path", { "d": "M6 18l0 .01", "key": "svg-0" }], ["path", { "d": "M10 18l0 .01", "key": "svg-1" }], ["path", { "d": "M14 18l0 .01", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars2 = createVueComponent("outline", "antenna-bars-2", "AntennaBars2", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 .01", "key": "svg-1" }], ["path", { "d": "M14 18l0 .01", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars3 = createVueComponent("outline", "antenna-bars-3", "AntennaBars3", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 -6", "key": "svg-1" }], ["path", { "d": "M14 18l0 .01", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars4 = createVueComponent("outline", "antenna-bars-4", "AntennaBars4", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 -6", "key": "svg-1" }], ["path", { "d": "M14 18l0 -9", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars5 = createVueComponent("outline", "antenna-bars-5", "AntennaBars5", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 -6", "key": "svg-1" }], ["path", { "d": "M14 18l0 -9", "key": "svg-2" }], ["path", { "d": "M18 18l0 -12", "key": "svg-3" }]]);

var IconAntennaBarsOff = createVueComponent("outline", "antenna-bars-off", "AntennaBarsOff", [["path", { "d": "M6 18v-3", "key": "svg-0" }], ["path", { "d": "M10 18v-6", "key": "svg-1" }], ["path", { "d": "M14 18v-4", "key": "svg-2" }], ["path", { "d": "M14 10v-1", "key": "svg-3" }], ["path", { "d": "M18 14v-8", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAntennaOff = createVueComponent("outline", "antenna-off", "AntennaOff", [["path", { "d": "M20 4v8", "key": "svg-0" }], ["path", { "d": "M16 4.5v7", "key": "svg-1" }], ["path", { "d": "M12 5v3m0 4v9", "key": "svg-2" }], ["path", { "d": "M8 8v2.5", "key": "svg-3" }], ["path", { "d": "M4 6v4", "key": "svg-4" }], ["path", { "d": "M20 8h-8m-4 0h-4", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconAntenna = createVueComponent("outline", "antenna", "Antenna", [["path", { "d": "M20 4v8", "key": "svg-0" }], ["path", { "d": "M16 4.5v7", "key": "svg-1" }], ["path", { "d": "M12 5v16", "key": "svg-2" }], ["path", { "d": "M8 5.5v5", "key": "svg-3" }], ["path", { "d": "M4 6v4", "key": "svg-4" }], ["path", { "d": "M20 8h-16", "key": "svg-5" }]]);

var IconApertureOff = createVueComponent("outline", "aperture-off", "ApertureOff", [["path", { "d": "M3.6 15h10.55", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M7.395 7.534l2.416 7.438", "key": "svg-2" }], ["path", { "d": "M17.032 4.636l-4.852 3.526m-2.334 1.695l-1.349 .98", "key": "svg-3" }], ["path", { "d": "M20.559 14.51l-8.535 -6.201", "key": "svg-4" }], ["path", { "d": "M12.257 20.916l2.123 -6.533m.984 -3.028l.154 -.473", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconAperture = createVueComponent("outline", "aperture", "Aperture", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M3.6 15h10.55", "key": "svg-1" }], ["path", { "d": "M6.551 4.938l3.26 10.034", "key": "svg-2" }], ["path", { "d": "M17.032 4.636l-8.535 6.201", "key": "svg-3" }], ["path", { "d": "M20.559 14.51l-8.535 -6.201", "key": "svg-4" }], ["path", { "d": "M12.257 20.916l3.261 -10.034", "key": "svg-5" }]]);

var IconApiAppOff = createVueComponent("outline", "api-app-off", "ApiAppOff", [["path", { "d": "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5", "key": "svg-0" }], ["path", { "d": "M15 15v3.5a2.5 2.5 0 1 1 -5 0v-.5", "key": "svg-1" }], ["path", { "d": "M13 9h5.5a2.5 2.5 0 1 1 0 5h-.5", "key": "svg-2" }], ["path", { "d": "M9 12v-3m.042 -3.957a2.5 2.5 0 0 1 4.958 .457v.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconApiApp = createVueComponent("outline", "api-app", "ApiApp", [["path", { "d": "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5", "key": "svg-0" }], ["path", { "d": "M15 12v6.5a2.5 2.5 0 1 1 -5 0v-.5", "key": "svg-1" }], ["path", { "d": "M12 9h6.5a2.5 2.5 0 1 1 0 5h-.5", "key": "svg-2" }], ["path", { "d": "M9 12v-6.5a2.5 2.5 0 0 1 5 0v.5", "key": "svg-3" }]]);

var IconApiOff = createVueComponent("outline", "api-off", "ApiOff", [["path", { "d": "M4 13h5", "key": "svg-0" }], ["path", { "d": "M12 16v-4m0 -4h3a2 2 0 0 1 2 2v1c0 .554 -.225 1.055 -.589 1.417m-3.411 .583h-1", "key": "svg-1" }], ["path", { "d": "M20 8v8", "key": "svg-2" }], ["path", { "d": "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconApi = createVueComponent("outline", "api", "Api", [["path", { "d": "M4 13h5", "key": "svg-0" }], ["path", { "d": "M12 16v-8h3a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-3", "key": "svg-1" }], ["path", { "d": "M20 8v8", "key": "svg-2" }], ["path", { "d": "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5", "key": "svg-3" }]]);

var IconAppWindow = createVueComponent("outline", "app-window", "AppWindow", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 8h.01", "key": "svg-1" }], ["path", { "d": "M9 8h.01", "key": "svg-2" }]]);

var IconApple = createVueComponent("outline", "apple", "Apple", [["path", { "d": "M4 11.319c0 3.102 .444 5.319 2.222 7.978c1.351 1.797 3.156 2.247 5.08 .988c.426 -.268 .97 -.268 1.397 0c1.923 1.26 3.728 .809 5.079 -.988c1.778 -2.66 2.222 -4.876 2.222 -7.977c0 -2.661 -1.99 -5.32 -4.444 -5.32c-1.267 0 -2.41 .693 -3.22 1.44a.5 .5 0 0 1 -.672 0c-.809 -.746 -1.953 -1.44 -3.22 -1.44c-2.454 0 -4.444 2.66 -4.444 5.319", "key": "svg-0" }], ["path", { "d": "M7 12c0 -1.47 .454 -2.34 1.5 -3", "key": "svg-1" }], ["path", { "d": "M12 7c0 -1.2 .867 -4 3 -4", "key": "svg-2" }]]);

var IconAppsOff = createVueComponent("outline", "apps-off", "AppsOff", [["path", { "d": "M8 4h1a1 1 0 0 1 1 1v1m-.29 3.704a1 1 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706", "key": "svg-0" }], ["path", { "d": "M18 14h1a1 1 0 0 1 1 1v1m-.29 3.704a1 1 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706", "key": "svg-1" }], ["path", { "d": "M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M14 7h6", "key": "svg-3" }], ["path", { "d": "M17 4v6", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconApps = createVueComponent("outline", "apps", "Apps", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M14 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M14 7l6 0", "key": "svg-3" }], ["path", { "d": "M17 4l0 6", "key": "svg-4" }]]);

var IconArcheryArrow = createVueComponent("outline", "archery-arrow", "ArcheryArrow", [["path", { "d": "M14 7v3h3l3 -3h-3v-3z", "key": "svg-0" }], ["path", { "d": "M14 10l-9 9", "key": "svg-1" }], ["path", { "d": "M5 15v4h4", "key": "svg-2" }]]);

var IconArchiveOff = createVueComponent("outline", "archive-off", "ArchiveOff", [["path", { "d": "M8 4h11a2 2 0 1 1 0 4h-7m-4 0h-3a2 2 0 0 1 -.826 -3.822", "key": "svg-0" }], ["path", { "d": "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 1.824 -1.18m.176 -3.82v-7", "key": "svg-1" }], ["path", { "d": "M10 12h2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconArchive = createVueComponent("outline", "archive", "Archive", [["path", { "d": "M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-10", "key": "svg-1" }], ["path", { "d": "M10 12l4 0", "key": "svg-2" }]]);

var IconArmchair2Off = createVueComponent("outline", "armchair-2-off", "Armchair2Off", [["path", { "d": "M5 10v-4a3 3 0 0 1 .128 -.869m2.038 -2.013c.264 -.078 .544 -.118 .834 -.118h8a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M16.124 12.145a3 3 0 1 1 3.756 3.724m-.88 3.131h-14v-3a3 3 0 1 1 3 -3v2", "key": "svg-1" }], ["path", { "d": "M8 12h4", "key": "svg-2" }], ["path", { "d": "M7 19v2", "key": "svg-3" }], ["path", { "d": "M17 19v2", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconArmchair2 = createVueComponent("outline", "armchair-2", "Armchair2", [["path", { "d": "M5 10v-4a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M16 15v-2a3 3 0 1 1 3 3v3h-14v-3a3 3 0 1 1 3 -3v2", "key": "svg-1" }], ["path", { "d": "M8 12h8", "key": "svg-2" }], ["path", { "d": "M7 19v2", "key": "svg-3" }], ["path", { "d": "M17 19v2", "key": "svg-4" }]]);

var IconArmchairOff = createVueComponent("outline", "armchair-off", "ArmchairOff", [["path", { "d": "M17 13a2 2 0 1 1 4 0v4m-2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 1 1 4 0v2h8.036", "key": "svg-0" }], ["path", { "d": "M5 11v-5a3 3 0 0 1 .134 -.89m1.987 -1.98a3 3 0 0 1 .879 -.13h8a3 3 0 0 1 3 3v5", "key": "svg-1" }], ["path", { "d": "M6 19v2", "key": "svg-2" }], ["path", { "d": "M18 19v2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconArmchair = createVueComponent("outline", "armchair", "Armchair", [["path", { "d": "M5 11a2 2 0 0 1 2 2v2h10v-2a2 2 0 1 1 4 0v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M5 11v-5a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v5", "key": "svg-1" }], ["path", { "d": "M6 19v2", "key": "svg-2" }], ["path", { "d": "M18 19v2", "key": "svg-3" }]]);

var IconArrowAutofitContent = createVueComponent("outline", "arrow-autofit-content", "ArrowAutofitContent", [["path", { "d": "M6 4l-3 3l3 3", "key": "svg-0" }], ["path", { "d": "M18 4l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M4 14m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-2" }], ["path", { "d": "M10 7h-7", "key": "svg-3" }], ["path", { "d": "M21 7h-7", "key": "svg-4" }]]);

var IconArrowAutofitDown = createVueComponent("outline", "arrow-autofit-down", "ArrowAutofitDown", [["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8", "key": "svg-0" }], ["path", { "d": "M18 4v17", "key": "svg-1" }], ["path", { "d": "M15 18l3 3l3 -3", "key": "svg-2" }]]);

var IconArrowAutofitHeight = createVueComponent("outline", "arrow-autofit-height", "ArrowAutofitHeight", [["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6", "key": "svg-0" }], ["path", { "d": "M18 14v7", "key": "svg-1" }], ["path", { "d": "M18 3v7", "key": "svg-2" }], ["path", { "d": "M15 18l3 3l3 -3", "key": "svg-3" }], ["path", { "d": "M15 6l3 -3l3 3", "key": "svg-4" }]]);

var IconArrowAutofitLeft = createVueComponent("outline", "arrow-autofit-left", "ArrowAutofitLeft", [["path", { "d": "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M20 18h-17", "key": "svg-1" }], ["path", { "d": "M6 15l-3 3l3 3", "key": "svg-2" }]]);

var IconArrowAutofitRight = createVueComponent("outline", "arrow-autofit-right", "ArrowAutofitRight", [["path", { "d": "M20 12v-6a2 2 0 0 0 -2 -2h-12a2 2 0 0 0 -2 2v8", "key": "svg-0" }], ["path", { "d": "M4 18h17", "key": "svg-1" }], ["path", { "d": "M18 15l3 3l-3 3", "key": "svg-2" }]]);

var IconArrowAutofitUp = createVueComponent("outline", "arrow-autofit-up", "ArrowAutofitUp", [["path", { "d": "M12 4h-6a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h8", "key": "svg-0" }], ["path", { "d": "M18 20v-17", "key": "svg-1" }], ["path", { "d": "M15 6l3 -3l3 3", "key": "svg-2" }]]);

var IconArrowAutofitWidth = createVueComponent("outline", "arrow-autofit-width", "ArrowAutofitWidth", [["path", { "d": "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M10 18h-7", "key": "svg-1" }], ["path", { "d": "M21 18h-7", "key": "svg-2" }], ["path", { "d": "M6 15l-3 3l3 3", "key": "svg-3" }], ["path", { "d": "M18 15l3 3l-3 3", "key": "svg-4" }]]);

var IconArrowBackUpDouble = createVueComponent("outline", "arrow-back-up-double", "ArrowBackUpDouble", [["path", { "d": "M13 14l-4 -4l4 -4", "key": "svg-0" }], ["path", { "d": "M8 14l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M9 10h7a4 4 0 1 1 0 8h-1", "key": "svg-2" }]]);

var IconArrowBackUp = createVueComponent("outline", "arrow-back-up", "ArrowBackUp", [["path", { "d": "M9 14l-4 -4l4 -4", "key": "svg-0" }], ["path", { "d": "M5 10h11a4 4 0 1 1 0 8h-1", "key": "svg-1" }]]);

var IconArrowBack = createVueComponent("outline", "arrow-back", "ArrowBack", [["path", { "d": "M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1", "key": "svg-0" }]]);

var IconArrowBadgeDown = createVueComponent("outline", "arrow-badge-down", "ArrowBadgeDown", [["path", { "d": "M17 13v-6l-5 4l-5 -4v6l5 4z", "key": "svg-0" }]]);

var IconArrowBadgeLeft = createVueComponent("outline", "arrow-badge-left", "ArrowBadgeLeft", [["path", { "d": "M11 17h6l-4 -5l4 -5h-6l-4 5z", "key": "svg-0" }]]);

var IconArrowBadgeRight = createVueComponent("outline", "arrow-badge-right", "ArrowBadgeRight", [["path", { "d": "M13 7h-6l4 5l-4 5h6l4 -5z", "key": "svg-0" }]]);

var IconArrowBadgeUp = createVueComponent("outline", "arrow-badge-up", "ArrowBadgeUp", [["path", { "d": "M17 11v6l-5 -4l-5 4v-6l5 -4z", "key": "svg-0" }]]);

var IconArrowBarBoth = createVueComponent("outline", "arrow-bar-both", "ArrowBarBoth", [["path", { "d": "M8 12h-6", "key": "svg-0" }], ["path", { "d": "M5 15l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M22 12h-6", "key": "svg-2" }], ["path", { "d": "M19 15l3 -3l-3 -3", "key": "svg-3" }], ["path", { "d": "M12 4v16", "key": "svg-4" }]]);

var IconArrowBarDown = createVueComponent("outline", "arrow-bar-down", "ArrowBarDown", [["path", { "d": "M12 20l0 -10", "key": "svg-0" }], ["path", { "d": "M12 20l4 -4", "key": "svg-1" }], ["path", { "d": "M12 20l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 4l16 0", "key": "svg-3" }]]);

var IconArrowBarLeft = createVueComponent("outline", "arrow-bar-left", "ArrowBarLeft", [["path", { "d": "M4 12l10 0", "key": "svg-0" }], ["path", { "d": "M4 12l4 4", "key": "svg-1" }], ["path", { "d": "M4 12l4 -4", "key": "svg-2" }], ["path", { "d": "M20 4l0 16", "key": "svg-3" }]]);

var IconArrowBarRight = createVueComponent("outline", "arrow-bar-right", "ArrowBarRight", [["path", { "d": "M20 12l-10 0", "key": "svg-0" }], ["path", { "d": "M20 12l-4 4", "key": "svg-1" }], ["path", { "d": "M20 12l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 4l0 16", "key": "svg-3" }]]);

var IconArrowBarToDownDashed = createVueComponent("outline", "arrow-bar-to-down-dashed", "ArrowBarToDownDashed", [["path", { "d": "M12 14v-10", "key": "svg-0" }], ["path", { "d": "M12 14l4 -4", "key": "svg-1" }], ["path", { "d": "M12 14l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 20h3m13 0h-3m-3.5 0h-3", "key": "svg-3" }]]);

var IconArrowBarToDown = createVueComponent("outline", "arrow-bar-to-down", "ArrowBarToDown", [["path", { "d": "M4 20l16 0", "key": "svg-0" }], ["path", { "d": "M12 14l0 -10", "key": "svg-1" }], ["path", { "d": "M12 14l4 -4", "key": "svg-2" }], ["path", { "d": "M12 14l-4 -4", "key": "svg-3" }]]);

var IconArrowBarToLeftDashed = createVueComponent("outline", "arrow-bar-to-left-dashed", "ArrowBarToLeftDashed", [["path", { "d": "M10 12l10 0", "key": "svg-0" }], ["path", { "d": "M10 12l4 -4", "key": "svg-1" }], ["path", { "d": "M10 12l4 4", "key": "svg-2" }], ["path", { "d": "M4 20l0 -3m0 -13l0 3m0 3.5l0 3", "key": "svg-3" }]]);

var IconArrowBarToLeft = createVueComponent("outline", "arrow-bar-to-left", "ArrowBarToLeft", [["path", { "d": "M10 12l10 0", "key": "svg-0" }], ["path", { "d": "M10 12l4 4", "key": "svg-1" }], ["path", { "d": "M10 12l4 -4", "key": "svg-2" }], ["path", { "d": "M4 4l0 16", "key": "svg-3" }]]);

var IconArrowBarToRightDashed = createVueComponent("outline", "arrow-bar-to-right-dashed", "ArrowBarToRightDashed", [["path", { "d": "M14 12l-10 0", "key": "svg-0" }], ["path", { "d": "M14 12l-4 4", "key": "svg-1" }], ["path", { "d": "M14 12l-4 -4", "key": "svg-2" }], ["path", { "d": "M20 4l0 3m0 13l0 -3m0 -3.5l0 -3", "key": "svg-3" }]]);

var IconArrowBarToRight = createVueComponent("outline", "arrow-bar-to-right", "ArrowBarToRight", [["path", { "d": "M14 12l-10 0", "key": "svg-0" }], ["path", { "d": "M14 12l-4 4", "key": "svg-1" }], ["path", { "d": "M14 12l-4 -4", "key": "svg-2" }], ["path", { "d": "M20 4l0 16", "key": "svg-3" }]]);

var IconArrowBarToUpDashed = createVueComponent("outline", "arrow-bar-to-up-dashed", "ArrowBarToUpDashed", [["path", { "d": "M12 10v10", "key": "svg-0" }], ["path", { "d": "M12 10l4 4", "key": "svg-1" }], ["path", { "d": "M12 10l-4 4", "key": "svg-2" }], ["path", { "d": "M4 4h3m13 0h-3m-3.5 0h-3", "key": "svg-3" }]]);

var IconArrowBarToUp = createVueComponent("outline", "arrow-bar-to-up", "ArrowBarToUp", [["path", { "d": "M12 10l0 10", "key": "svg-0" }], ["path", { "d": "M12 10l4 4", "key": "svg-1" }], ["path", { "d": "M12 10l-4 4", "key": "svg-2" }], ["path", { "d": "M4 4l16 0", "key": "svg-3" }]]);

var IconArrowBarUp = createVueComponent("outline", "arrow-bar-up", "ArrowBarUp", [["path", { "d": "M12 4l0 10", "key": "svg-0" }], ["path", { "d": "M12 4l4 4", "key": "svg-1" }], ["path", { "d": "M12 4l-4 4", "key": "svg-2" }], ["path", { "d": "M4 20l16 0", "key": "svg-3" }]]);

var IconArrowBearLeft2 = createVueComponent("outline", "arrow-bear-left-2", "ArrowBearLeft2", [["path", { "d": "M9 3h-5v5", "key": "svg-0" }], ["path", { "d": "M4 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93", "key": "svg-1" }], ["path", { "d": "M20 5l-4.5 4.5", "key": "svg-2" }]]);

var IconArrowBearLeft = createVueComponent("outline", "arrow-bear-left", "ArrowBearLeft", [["path", { "d": "M13 3h-5v5", "key": "svg-0" }], ["path", { "d": "M8 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93", "key": "svg-1" }]]);

var IconArrowBearRight2 = createVueComponent("outline", "arrow-bear-right-2", "ArrowBearRight2", [["path", { "d": "M15 3h5v5", "key": "svg-0" }], ["path", { "d": "M20 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93", "key": "svg-1" }], ["path", { "d": "M4 5l4.5 4.5", "key": "svg-2" }]]);

var IconArrowBearRight = createVueComponent("outline", "arrow-bear-right", "ArrowBearRight", [["path", { "d": "M12 3h5v5", "key": "svg-0" }], ["path", { "d": "M17 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93", "key": "svg-1" }]]);

var IconArrowBigDownLine = createVueComponent("outline", "arrow-big-down-line", "ArrowBigDownLine", [["path", { "d": "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-6h6v6z", "key": "svg-0" }], ["path", { "d": "M15 3h-6", "key": "svg-1" }]]);

var IconArrowBigDownLines = createVueComponent("outline", "arrow-big-down-lines", "ArrowBigDownLines", [["path", { "d": "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-3h6v3z", "key": "svg-0" }], ["path", { "d": "M15 3h-6", "key": "svg-1" }], ["path", { "d": "M15 6h-6", "key": "svg-2" }]]);

var IconArrowBigDown = createVueComponent("outline", "arrow-big-down", "ArrowBigDown", [["path", { "d": "M15 4v8h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-8a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1z", "key": "svg-0" }]]);

var IconArrowBigLeftLine = createVueComponent("outline", "arrow-big-left-line", "ArrowBigLeftLine", [["path", { "d": "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h6v6h-6z", "key": "svg-0" }], ["path", { "d": "M21 15v-6", "key": "svg-1" }]]);

var IconArrowBigLeftLines = createVueComponent("outline", "arrow-big-left-lines", "ArrowBigLeftLines", [["path", { "d": "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h3v6h-3z", "key": "svg-0" }], ["path", { "d": "M21 15v-6", "key": "svg-1" }], ["path", { "d": "M18 15v-6", "key": "svg-2" }]]);

var IconArrowBigLeft = createVueComponent("outline", "arrow-big-left", "ArrowBigLeft", [["path", { "d": "M20 15h-8v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h8a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1z", "key": "svg-0" }]]);

var IconArrowBigRightLine = createVueComponent("outline", "arrow-big-right-line", "ArrowBigRightLine", [["path", { "d": "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-6v-6h6z", "key": "svg-0" }], ["path", { "d": "M3 9v6", "key": "svg-1" }]]);

var IconArrowBigRightLines = createVueComponent("outline", "arrow-big-right-lines", "ArrowBigRightLines", [["path", { "d": "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-3v-6h3z", "key": "svg-0" }], ["path", { "d": "M3 9v6", "key": "svg-1" }], ["path", { "d": "M6 9v6", "key": "svg-2" }]]);

var IconArrowBigRight = createVueComponent("outline", "arrow-big-right", "ArrowBigRight", [["path", { "d": "M4 9h8v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-8a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1z", "key": "svg-0" }]]);

var IconArrowBigUpLine = createVueComponent("outline", "arrow-big-up-line", "ArrowBigUpLine", [["path", { "d": "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v6h-6v-6z", "key": "svg-0" }], ["path", { "d": "M9 21h6", "key": "svg-1" }]]);

var IconArrowBigUpLines = createVueComponent("outline", "arrow-big-up-lines", "ArrowBigUpLines", [["path", { "d": "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v3h-6v-3z", "key": "svg-0" }], ["path", { "d": "M9 21h6", "key": "svg-1" }], ["path", { "d": "M9 18h6", "key": "svg-2" }]]);

var IconArrowBigUp = createVueComponent("outline", "arrow-big-up", "ArrowBigUp", [["path", { "d": "M9 20v-8h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v8a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }]]);

var IconArrowBounce = createVueComponent("outline", "arrow-bounce", "ArrowBounce", [["path", { "d": "M10 18h4", "key": "svg-0" }], ["path", { "d": "M3 8a9 9 0 0 1 9 9v1l1.428 -4.285a12 12 0 0 1 6.018 -6.938l.554 -.277", "key": "svg-1" }], ["path", { "d": "M15 6h5v5", "key": "svg-2" }]]);

var IconArrowCapsule = createVueComponent("outline", "arrow-capsule", "ArrowCapsule", [["path", { "d": "M18 15a6 6 0 1 1 -12 0v-6a6 6 0 1 1 12 0v2", "key": "svg-0" }], ["path", { "d": "M15 8l3 3l3 -3", "key": "svg-1" }]]);

var IconArrowCurveLeft = createVueComponent("outline", "arrow-curve-left", "ArrowCurveLeft", [["path", { "d": "M14 7l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M10 3v4.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v2.394", "key": "svg-1" }]]);

var IconArrowCurveRight = createVueComponent("outline", "arrow-curve-right", "ArrowCurveRight", [["path", { "d": "M10 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M14 3v4.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v2.394", "key": "svg-1" }]]);

var IconArrowDownBar = createVueComponent("outline", "arrow-down-bar", "ArrowDownBar", [["path", { "d": "M12 3v18", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M9 3h6", "key": "svg-2" }]]);

var IconArrowDownCircle = createVueComponent("outline", "arrow-down-circle", "ArrowDownCircle", [["path", { "d": "M12 7v14", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M12 7a2 2 0 1 0 0 -4a2 2 0 0 0 0 4", "key": "svg-2" }]]);

var IconArrowDownDashed = createVueComponent("outline", "arrow-down-dashed", "ArrowDownDashed", [["path", { "d": "M12 5v.5m0 3v1.5m0 3v6", "key": "svg-0" }], ["path", { "d": "M18 13l-6 6", "key": "svg-1" }], ["path", { "d": "M6 13l6 6", "key": "svg-2" }]]);

var IconArrowDownFromArc = createVueComponent("outline", "arrow-down-from-arc", "ArrowDownFromArc", [["path", { "d": "M12 15v-12", "key": "svg-0" }], ["path", { "d": "M16 7l-4 -4l-4 4", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 0 0 18 0", "key": "svg-2" }]]);

var IconArrowDownLeftCircle = createVueComponent("outline", "arrow-down-left-circle", "ArrowDownLeftCircle", [["path", { "d": "M15.536 8.464l-9.536 9.536", "key": "svg-0" }], ["path", { "d": "M6 14v4h4", "key": "svg-1" }], ["path", { "d": "M15.586 8.414a2 2 0 1 0 2.828 -2.828a2 2 0 0 0 -2.828 2.828", "key": "svg-2" }]]);

var IconArrowDownLeft = createVueComponent("outline", "arrow-down-left", "ArrowDownLeft", [["path", { "d": "M17 7l-10 10", "key": "svg-0" }], ["path", { "d": "M16 17l-9 0l0 -9", "key": "svg-1" }]]);

var IconArrowDownRhombus = createVueComponent("outline", "arrow-down-rhombus", "ArrowDownRhombus", [["path", { "d": "M12 8v13", "key": "svg-0" }], ["path", { "d": "M15 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M14.5 5.5l-2.5 -2.5l-2.5 2.5l2.5 2.5z", "key": "svg-2" }]]);

var IconArrowDownRightCircle = createVueComponent("outline", "arrow-down-right-circle", "ArrowDownRightCircle", [["path", { "d": "M8.464 8.464l9.536 9.536", "key": "svg-0" }], ["path", { "d": "M14 18h4v-4", "key": "svg-1" }], ["path", { "d": "M8.414 8.414a2 2 0 1 0 -2.828 -2.828a2 2 0 0 0 2.828 2.828", "key": "svg-2" }]]);

var IconArrowDownRight = createVueComponent("outline", "arrow-down-right", "ArrowDownRight", [["path", { "d": "M7 7l10 10", "key": "svg-0" }], ["path", { "d": "M17 8l0 9l-9 0", "key": "svg-1" }]]);

var IconArrowDownSquare = createVueComponent("outline", "arrow-down-square", "ArrowDownSquare", [["path", { "d": "M12 7v14", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M14 3v4h-4v-4z", "key": "svg-2" }]]);

var IconArrowDownTail = createVueComponent("outline", "arrow-down-tail", "ArrowDownTail", [["path", { "d": "M12 6v15", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M9 3l3 3l3 -3", "key": "svg-2" }]]);

var IconArrowDownToArc = createVueComponent("outline", "arrow-down-to-arc", "ArrowDownToArc", [["path", { "d": "M12 3v12", "key": "svg-0" }], ["path", { "d": "M16 11l-4 4l-4 -4", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 0 0 18 0", "key": "svg-2" }]]);

var IconArrowDown = createVueComponent("outline", "arrow-down", "ArrowDown", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M18 13l-6 6", "key": "svg-1" }], ["path", { "d": "M6 13l6 6", "key": "svg-2" }]]);

var IconArrowElbowLeft = createVueComponent("outline", "arrow-elbow-left", "ArrowElbowLeft", [["path", { "d": "M3 14v-6h6", "key": "svg-0" }], ["path", { "d": "M3 8l9 9l9 -9", "key": "svg-1" }]]);

var IconArrowElbowRight = createVueComponent("outline", "arrow-elbow-right", "ArrowElbowRight", [["path", { "d": "M21 14v-6h-6", "key": "svg-0" }], ["path", { "d": "M21 8l-9 9l-9 -9", "key": "svg-1" }]]);

var IconArrowFork = createVueComponent("outline", "arrow-fork", "ArrowFork", [["path", { "d": "M16 3h5v5", "key": "svg-0" }], ["path", { "d": "M8 3h-5v5", "key": "svg-1" }], ["path", { "d": "M21 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93", "key": "svg-2" }], ["path", { "d": "M3 3l7.536 7.536a5 5 0 0 1 1.464 3.534v.93", "key": "svg-3" }]]);

var IconArrowForwardUpDouble = createVueComponent("outline", "arrow-forward-up-double", "ArrowForwardUpDouble", [["path", { "d": "M11 14l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M16 14l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M15 10h-7a4 4 0 1 0 0 8h1", "key": "svg-2" }]]);

var IconArrowForwardUp = createVueComponent("outline", "arrow-forward-up", "ArrowForwardUp", [["path", { "d": "M15 14l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M19 10h-11a4 4 0 1 0 0 8h1", "key": "svg-1" }]]);

var IconArrowForward = createVueComponent("outline", "arrow-forward", "ArrowForward", [["path", { "d": "M15 11l4 4l-4 4m4 -4h-11a4 4 0 0 1 0 -8h1", "key": "svg-0" }]]);

var IconArrowGuide = createVueComponent("outline", "arrow-guide", "ArrowGuide", [["path", { "d": "M5 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M7 19h3a2 2 0 0 0 2 -2v-8a2 2 0 0 1 2 -2h7", "key": "svg-1" }], ["path", { "d": "M18 4l3 3l-3 3", "key": "svg-2" }]]);

var IconArrowIteration = createVueComponent("outline", "arrow-iteration", "ArrowIteration", [["path", { "d": "M8.5 16a5.5 5.5 0 1 0 -5.5 -5.5v.5", "key": "svg-0" }], ["path", { "d": "M3 16h18", "key": "svg-1" }], ["path", { "d": "M18 13l3 3l-3 3", "key": "svg-2" }]]);

var IconArrowLeftBar = createVueComponent("outline", "arrow-left-bar", "ArrowLeftBar", [["path", { "d": "M21 12h-18", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M21 9v6", "key": "svg-2" }]]);

var IconArrowLeftCircle = createVueComponent("outline", "arrow-left-circle", "ArrowLeftCircle", [["path", { "d": "M17 12h-14", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M19 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconArrowLeftDashed = createVueComponent("outline", "arrow-left-dashed", "ArrowLeftDashed", [["path", { "d": "M5 12h6m3 0h1.5m3 0h.5", "key": "svg-0" }], ["path", { "d": "M5 12l6 6", "key": "svg-1" }], ["path", { "d": "M5 12l6 -6", "key": "svg-2" }]]);

var IconArrowLeftFromArc = createVueComponent("outline", "arrow-left-from-arc", "ArrowLeftFromArc", [["path", { "d": "M9 12h12", "key": "svg-0" }], ["path", { "d": "M17 16l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18", "key": "svg-2" }]]);

var IconArrowLeftRhombus = createVueComponent("outline", "arrow-left-rhombus", "ArrowLeftRhombus", [["path", { "d": "M16 12h-13", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M18.5 9.5l2.5 2.5l-2.5 2.5l-2.5 -2.5z", "key": "svg-2" }]]);

var IconArrowLeftRight = createVueComponent("outline", "arrow-left-right", "ArrowLeftRight", [["path", { "d": "M17 13l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M7 13l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M12 14a5 5 0 0 1 5 -5h4", "key": "svg-2" }], ["path", { "d": "M12 19v-5a5 5 0 0 0 -5 -5h-4", "key": "svg-3" }]]);

var IconArrowLeftSquare = createVueComponent("outline", "arrow-left-square", "ArrowLeftSquare", [["path", { "d": "M17 12h-14", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M21 14h-4v-4h4z", "key": "svg-2" }]]);

var IconArrowLeftTail = createVueComponent("outline", "arrow-left-tail", "ArrowLeftTail", [["path", { "d": "M18 12h-15", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M21 9l-3 3l3 3", "key": "svg-2" }]]);

var IconArrowLeftToArc = createVueComponent("outline", "arrow-left-to-arc", "ArrowLeftToArc", [["path", { "d": "M21 12h-12", "key": "svg-0" }], ["path", { "d": "M13 16l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18", "key": "svg-2" }]]);

var IconArrowLeft = createVueComponent("outline", "arrow-left", "ArrowLeft", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M5 12l6 6", "key": "svg-1" }], ["path", { "d": "M5 12l6 -6", "key": "svg-2" }]]);

var IconArrowLoopLeft2 = createVueComponent("outline", "arrow-loop-left-2", "ArrowLoopLeft2", [["path", { "d": "M13 21v-6m0 -6v-1a4 4 0 1 1 4 4h-13", "key": "svg-0" }], ["path", { "d": "M8 16l-4 -4l4 -4", "key": "svg-1" }]]);

var IconArrowLoopLeft = createVueComponent("outline", "arrow-loop-left", "ArrowLoopLeft", [["path", { "d": "M13 21v-13a4 4 0 1 1 4 4h-13", "key": "svg-0" }], ["path", { "d": "M8 16l-4 -4l4 -4", "key": "svg-1" }]]);

var IconArrowLoopRight2 = createVueComponent("outline", "arrow-loop-right-2", "ArrowLoopRight2", [["path", { "d": "M12 21v-6m0 -6v-1a4 4 0 1 0 -4 4h13", "key": "svg-0" }], ["path", { "d": "M17 16l4 -4l-4 -4", "key": "svg-1" }]]);

var IconArrowLoopRight = createVueComponent("outline", "arrow-loop-right", "ArrowLoopRight", [["path", { "d": "M12 21v-13a4 4 0 1 0 -4 4h13", "key": "svg-0" }], ["path", { "d": "M17 16l4 -4l-4 -4", "key": "svg-1" }]]);

var IconArrowMergeAltLeft = createVueComponent("outline", "arrow-merge-alt-left", "ArrowMergeAltLeft", [["path", { "d": "M8 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M18 21v.01", "key": "svg-1" }], ["path", { "d": "M18 18.01v.01", "key": "svg-2" }], ["path", { "d": "M17 15.02v.01", "key": "svg-3" }], ["path", { "d": "M14 13.03v.01", "key": "svg-4" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v1.394", "key": "svg-5" }]]);

var IconArrowMergeAltRight = createVueComponent("outline", "arrow-merge-alt-right", "ArrowMergeAltRight", [["path", { "d": "M16 7l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M6 21v.01", "key": "svg-1" }], ["path", { "d": "M6 18.01v.01", "key": "svg-2" }], ["path", { "d": "M7 15.02v.01", "key": "svg-3" }], ["path", { "d": "M10 13.03v.01", "key": "svg-4" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v1.394", "key": "svg-5" }]]);

var IconArrowMergeBoth = createVueComponent("outline", "arrow-merge-both", "ArrowMergeBoth", [["path", { "d": "M16 8l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }], ["path", { "d": "M18 18c-4 -1.333 -6 -4.667 -6 -10", "key": "svg-2" }], ["path", { "d": "M6 18c4 -1.333 6 -4.667 6 -10", "key": "svg-3" }]]);

var IconArrowMergeLeft = createVueComponent("outline", "arrow-merge-left", "ArrowMergeLeft", [["path", { "d": "M8 8l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }], ["path", { "d": "M6 18c4 -1.333 6 -4.667 6 -10", "key": "svg-2" }]]);

var IconArrowMergeRight = createVueComponent("outline", "arrow-merge-right", "ArrowMergeRight", [["path", { "d": "M16 8l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }], ["path", { "d": "M18 18c-4 -1.333 -6 -4.667 -6 -10", "key": "svg-2" }]]);

var IconArrowMerge = createVueComponent("outline", "arrow-merge", "ArrowMerge", [["path", { "d": "M8 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v1.394", "key": "svg-1" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v1.394", "key": "svg-2" }]]);

var IconArrowMoveDown = createVueComponent("outline", "arrow-move-down", "ArrowMoveDown", [["path", { "d": "M12 11v10", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconArrowMoveLeft = createVueComponent("outline", "arrow-move-left", "ArrowMoveLeft", [["path", { "d": "M13 12h-10", "key": "svg-0" }], ["path", { "d": "M6 15l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M17 12a2 2 0 1 1 4 0a2 2 0 0 1 -4 0z", "key": "svg-2" }]]);

var IconArrowMoveRight = createVueComponent("outline", "arrow-move-right", "ArrowMoveRight", [["path", { "d": "M11 12h10", "key": "svg-0" }], ["path", { "d": "M18 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M7 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0z", "key": "svg-2" }]]);

var IconArrowMoveUp = createVueComponent("outline", "arrow-move-up", "ArrowMoveUp", [["path", { "d": "M12 13v-10", "key": "svg-0" }], ["path", { "d": "M9 6l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M12 17a2 2 0 1 1 0 4a2 2 0 0 1 0 -4z", "key": "svg-2" }]]);

var IconArrowNarrowDownDashed = createVueComponent("outline", "arrow-narrow-down-dashed", "ArrowNarrowDownDashed", [["path", { "d": "M12 5v.5m0 3v1.5m0 3v6", "key": "svg-0" }], ["path", { "d": "M16 15l-4 4", "key": "svg-1" }], ["path", { "d": "M8 15l4 4", "key": "svg-2" }]]);

var IconArrowNarrowDown = createVueComponent("outline", "arrow-narrow-down", "ArrowNarrowDown", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M16 15l-4 4", "key": "svg-1" }], ["path", { "d": "M8 15l4 4", "key": "svg-2" }]]);

var IconArrowNarrowLeftDashed = createVueComponent("outline", "arrow-narrow-left-dashed", "ArrowNarrowLeftDashed", [["path", { "d": "M5 12h6m3 0h1.5m3 0h.5", "key": "svg-0" }], ["path", { "d": "M5 12l4 4", "key": "svg-1" }], ["path", { "d": "M5 12l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowLeft = createVueComponent("outline", "arrow-narrow-left", "ArrowNarrowLeft", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M5 12l4 4", "key": "svg-1" }], ["path", { "d": "M5 12l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowRightDashed = createVueComponent("outline", "arrow-narrow-right-dashed", "ArrowNarrowRightDashed", [["path", { "d": "M5 12h.5m3 0h1.5m3 0h6", "key": "svg-0" }], ["path", { "d": "M15 16l4 -4", "key": "svg-1" }], ["path", { "d": "M15 8l4 4", "key": "svg-2" }]]);

var IconArrowNarrowRight = createVueComponent("outline", "arrow-narrow-right", "ArrowNarrowRight", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M15 16l4 -4", "key": "svg-1" }], ["path", { "d": "M15 8l4 4", "key": "svg-2" }]]);

var IconArrowNarrowUpDashed = createVueComponent("outline", "arrow-narrow-up-dashed", "ArrowNarrowUpDashed", [["path", { "d": "M12 5v6m0 3v1.5m0 3v.5", "key": "svg-0" }], ["path", { "d": "M16 9l-4 -4", "key": "svg-1" }], ["path", { "d": "M8 9l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowUp = createVueComponent("outline", "arrow-narrow-up", "ArrowNarrowUp", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M16 9l-4 -4", "key": "svg-1" }], ["path", { "d": "M8 9l4 -4", "key": "svg-2" }]]);

var IconArrowRampLeft2 = createVueComponent("outline", "arrow-ramp-left-2", "ArrowRampLeft2", [["path", { "d": "M18 3v8.707", "key": "svg-0" }], ["path", { "d": "M8 14l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M18 21c0 -6.075 -4.925 -11 -11 -11h-3", "key": "svg-2" }]]);

var IconArrowRampLeft3 = createVueComponent("outline", "arrow-ramp-left-3", "ArrowRampLeft3", [["path", { "d": "M18 3v6", "key": "svg-0" }], ["path", { "d": "M8 16l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M18 21v-6a3 3 0 0 0 -3 -3h-11", "key": "svg-2" }]]);

var IconArrowRampLeft = createVueComponent("outline", "arrow-ramp-left", "ArrowRampLeft", [["path", { "d": "M17 3l0 8.707", "key": "svg-0" }], ["path", { "d": "M13 7l4 -4l4 4", "key": "svg-1" }], ["path", { "d": "M7 14l-4 -4l4 -4", "key": "svg-2" }], ["path", { "d": "M17 21a11 11 0 0 0 -11 -11h-3", "key": "svg-3" }]]);

var IconArrowRampRight2 = createVueComponent("outline", "arrow-ramp-right-2", "ArrowRampRight2", [["path", { "d": "M6 3v8.707", "key": "svg-0" }], ["path", { "d": "M16 14l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M6 21c0 -6.075 4.925 -11 11 -11h3", "key": "svg-2" }]]);

var IconArrowRampRight3 = createVueComponent("outline", "arrow-ramp-right-3", "ArrowRampRight3", [["path", { "d": "M6 3v6", "key": "svg-0" }], ["path", { "d": "M16 16l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M6 21v-6a3 3 0 0 1 3 -3h11", "key": "svg-2" }]]);

var IconArrowRampRight = createVueComponent("outline", "arrow-ramp-right", "ArrowRampRight", [["path", { "d": "M7 3l0 8.707", "key": "svg-0" }], ["path", { "d": "M11 7l-4 -4l-4 4", "key": "svg-1" }], ["path", { "d": "M17 14l4 -4l-4 -4", "key": "svg-2" }], ["path", { "d": "M7 21a11 11 0 0 1 11 -11h3", "key": "svg-3" }]]);

var IconArrowRightBar = createVueComponent("outline", "arrow-right-bar", "ArrowRightBar", [["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-0" }], ["path", { "d": "M3 12h18", "key": "svg-1" }], ["path", { "d": "M3 9v6", "key": "svg-2" }]]);

var IconArrowRightCircle = createVueComponent("outline", "arrow-right-circle", "ArrowRightCircle", [["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-0" }], ["path", { "d": "M5 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 12h14", "key": "svg-2" }]]);

var IconArrowRightDashed = createVueComponent("outline", "arrow-right-dashed", "ArrowRightDashed", [["path", { "d": "M5 12h.5m3 0h1.5m3 0h6", "key": "svg-0" }], ["path", { "d": "M13 18l6 -6", "key": "svg-1" }], ["path", { "d": "M13 6l6 6", "key": "svg-2" }]]);

var IconArrowRightFromArc = createVueComponent("outline", "arrow-right-from-arc", "ArrowRightFromArc", [["path", { "d": "M15 12h-12", "key": "svg-0" }], ["path", { "d": "M7 8l-4 4l4 4", "key": "svg-1" }], ["path", { "d": "M12 21a9 9 0 0 0 0 -18", "key": "svg-2" }]]);

var IconArrowRightRhombus = createVueComponent("outline", "arrow-right-rhombus", "ArrowRightRhombus", [["path", { "d": "M8 12h13", "key": "svg-0" }], ["path", { "d": "M18 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M5.5 9.5l-2.5 2.5l2.5 2.5l2.5 -2.5z", "key": "svg-2" }]]);

var IconArrowRightSquare = createVueComponent("outline", "arrow-right-square", "ArrowRightSquare", [["path", { "d": "M7 12l14 0", "key": "svg-0" }], ["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 10h4v4h-4z", "key": "svg-2" }]]);

var IconArrowRightTail = createVueComponent("outline", "arrow-right-tail", "ArrowRightTail", [["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-0" }], ["path", { "d": "M3 15l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M6 12l15 0", "key": "svg-2" }]]);

var IconArrowRightToArc = createVueComponent("outline", "arrow-right-to-arc", "ArrowRightToArc", [["path", { "d": "M3 12h12", "key": "svg-0" }], ["path", { "d": "M11 8l4 4l-4 4", "key": "svg-1" }], ["path", { "d": "M12 21a9 9 0 0 0 0 -18", "key": "svg-2" }]]);

var IconArrowRight = createVueComponent("outline", "arrow-right", "ArrowRight", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M13 18l6 -6", "key": "svg-1" }], ["path", { "d": "M13 6l6 6", "key": "svg-2" }]]);

var IconArrowRotaryFirstLeft = createVueComponent("outline", "arrow-rotary-first-left", "ArrowRotaryFirstLeft", [["path", { "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z", "key": "svg-0" }], ["path", { "d": "M16 10v10", "key": "svg-1" }], ["path", { "d": "M13.5 9.5l-8.5 8.5", "key": "svg-2" }], ["path", { "d": "M10 18h-5v-5", "key": "svg-3" }]]);

var IconArrowRotaryFirstRight = createVueComponent("outline", "arrow-rotary-first-right", "ArrowRotaryFirstRight", [["path", { "d": "M8 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M8 10v10", "key": "svg-1" }], ["path", { "d": "M10.5 9.5l8.5 8.5", "key": "svg-2" }], ["path", { "d": "M14 18h5v-5", "key": "svg-3" }]]);

var IconArrowRotaryLastLeft = createVueComponent("outline", "arrow-rotary-last-left", "ArrowRotaryLastLeft", [["path", { "d": "M15 15a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z", "key": "svg-0" }], ["path", { "d": "M15 15v6", "key": "svg-1" }], ["path", { "d": "M12.5 9.5l-6.5 -6.5", "key": "svg-2" }], ["path", { "d": "M11 3h-5v5", "key": "svg-3" }]]);

var IconArrowRotaryLastRight = createVueComponent("outline", "arrow-rotary-last-right", "ArrowRotaryLastRight", [["path", { "d": "M9 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M9 15v6", "key": "svg-1" }], ["path", { "d": "M11.5 9.5l6.5 -6.5", "key": "svg-2" }], ["path", { "d": "M13 3h5v5", "key": "svg-3" }]]);

var IconArrowRotaryLeft = createVueComponent("outline", "arrow-rotary-left", "ArrowRotaryLeft", [["path", { "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z", "key": "svg-0" }], ["path", { "d": "M16 10v10", "key": "svg-1" }], ["path", { "d": "M13 7h-10", "key": "svg-2" }], ["path", { "d": "M7 11l-4 -4l4 -4", "key": "svg-3" }]]);

var IconArrowRotaryRight = createVueComponent("outline", "arrow-rotary-right", "ArrowRotaryRight", [["path", { "d": "M8 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M8 10v10", "key": "svg-1" }], ["path", { "d": "M17 11l4 -4l-4 -4", "key": "svg-2" }], ["path", { "d": "M11 7h10", "key": "svg-3" }]]);

var IconArrowRotaryStraight = createVueComponent("outline", "arrow-rotary-straight", "ArrowRotaryStraight", [["path", { "d": "M13 13m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M13 16v5", "key": "svg-1" }], ["path", { "d": "M13 3v7", "key": "svg-2" }], ["path", { "d": "M9 7l4 -4l4 4", "key": "svg-3" }]]);

var IconArrowRoundaboutLeft = createVueComponent("outline", "arrow-roundabout-left", "ArrowRoundaboutLeft", [["path", { "d": "M3 9h8a5 5 0 1 1 5 5v7", "key": "svg-0" }], ["path", { "d": "M7 5l-4 4l4 4", "key": "svg-1" }]]);

var IconArrowRoundaboutRight = createVueComponent("outline", "arrow-roundabout-right", "ArrowRoundaboutRight", [["path", { "d": "M21 9h-8a5 5 0 1 0 -5 5v7", "key": "svg-0" }], ["path", { "d": "M17 5l4 4l-4 4", "key": "svg-1" }]]);

var IconArrowSharpTurnLeft = createVueComponent("outline", "arrow-sharp-turn-left", "ArrowSharpTurnLeft", [["path", { "d": "M17 18v-11.31a.7 .7 0 0 0 -1.195 -.495l-9.805 9.805", "key": "svg-0" }], ["path", { "d": "M11 16h-5v-5", "key": "svg-1" }]]);

var IconArrowSharpTurnRight = createVueComponent("outline", "arrow-sharp-turn-right", "ArrowSharpTurnRight", [["path", { "d": "M7 18v-11.31a.7 .7 0 0 1 1.195 -.495l9.805 9.805", "key": "svg-0" }], ["path", { "d": "M13 16h5v-5", "key": "svg-1" }]]);

var IconArrowUpBar = createVueComponent("outline", "arrow-up-bar", "ArrowUpBar", [["path", { "d": "M12 21l0 -18", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M9 21l6 0", "key": "svg-2" }]]);

var IconArrowUpCircle = createVueComponent("outline", "arrow-up-circle", "ArrowUpCircle", [["path", { "d": "M12 17v-14", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M12 17a2 2 0 1 0 0 4a2 2 0 0 0 0 -4", "key": "svg-2" }]]);

var IconArrowUpDashed = createVueComponent("outline", "arrow-up-dashed", "ArrowUpDashed", [["path", { "d": "M12 5v6m0 3v1.5m0 3v.5", "key": "svg-0" }], ["path", { "d": "M18 11l-6 -6", "key": "svg-1" }], ["path", { "d": "M6 11l6 -6", "key": "svg-2" }]]);

var IconArrowUpFromArc = createVueComponent("outline", "arrow-up-from-arc", "ArrowUpFromArc", [["path", { "d": "M12 9v12", "key": "svg-0" }], ["path", { "d": "M8 17l4 4l4 -4", "key": "svg-1" }], ["path", { "d": "M21 12a9 9 0 0 0 -18 0", "key": "svg-2" }]]);

var IconArrowUpLeftCircle = createVueComponent("outline", "arrow-up-left-circle", "ArrowUpLeftCircle", [["path", { "d": "M15.536 15.536l-9.536 -9.536", "key": "svg-0" }], ["path", { "d": "M10 6h-4v4", "key": "svg-1" }], ["path", { "d": "M15.586 15.586a2 2 0 1 0 2.828 2.828a2 2 0 0 0 -2.828 -2.828", "key": "svg-2" }]]);

var IconArrowUpLeft = createVueComponent("outline", "arrow-up-left", "ArrowUpLeft", [["path", { "d": "M7 7l10 10", "key": "svg-0" }], ["path", { "d": "M16 7l-9 0l0 9", "key": "svg-1" }]]);

var IconArrowUpRhombus = createVueComponent("outline", "arrow-up-rhombus", "ArrowUpRhombus", [["path", { "d": "M12 16v-13", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M14.5 18.5l-2.5 2.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-2" }]]);

var IconArrowUpRightCircle = createVueComponent("outline", "arrow-up-right-circle", "ArrowUpRightCircle", [["path", { "d": "M8.464 15.536l9.536 -9.536", "key": "svg-0" }], ["path", { "d": "M18 10v-4h-4", "key": "svg-1" }], ["path", { "d": "M8.414 15.586a2 2 0 1 0 -2.828 2.828a2 2 0 0 0 2.828 -2.828", "key": "svg-2" }]]);

var IconArrowUpRight = createVueComponent("outline", "arrow-up-right", "ArrowUpRight", [["path", { "d": "M17 7l-10 10", "key": "svg-0" }], ["path", { "d": "M8 7l9 0l0 9", "key": "svg-1" }]]);

var IconArrowUpSquare = createVueComponent("outline", "arrow-up-square", "ArrowUpSquare", [["path", { "d": "M12 17l0 -14", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M10 21v-4h4v4z", "key": "svg-2" }]]);

var IconArrowUpTail = createVueComponent("outline", "arrow-up-tail", "ArrowUpTail", [["path", { "d": "M12 18l0 -15", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M15 21l-3 -3l-3 3", "key": "svg-2" }]]);

var IconArrowUpToArc = createVueComponent("outline", "arrow-up-to-arc", "ArrowUpToArc", [["path", { "d": "M12 21v-12", "key": "svg-0" }], ["path", { "d": "M8 13l4 -4l4 4", "key": "svg-1" }], ["path", { "d": "M21 12a9 9 0 0 0 -18 0", "key": "svg-2" }]]);

var IconArrowUp = createVueComponent("outline", "arrow-up", "ArrowUp", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M18 11l-6 -6", "key": "svg-1" }], ["path", { "d": "M6 11l6 -6", "key": "svg-2" }]]);

var IconArrowWaveLeftDown = createVueComponent("outline", "arrow-wave-left-down", "ArrowWaveLeftDown", [["path", { "d": "M7 14h-4v-4", "key": "svg-0" }], ["path", { "d": "M21 12c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3.113 -.716 -4 -2s-2.48 -2.033 -4 -2c-1.52 -.033 -3 1 -4 2l-2 2", "key": "svg-1" }]]);

var IconArrowWaveLeftUp = createVueComponent("outline", "arrow-wave-left-up", "ArrowWaveLeftUp", [["path", { "d": "M7 10h-4v4", "key": "svg-0" }], ["path", { "d": "M21 12c-.887 -1.285 -2.48 -2.033 -4 -2c-1.52 -.033 -3.113 .715 -4 2c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3 -1 -4 -2l-2 -2", "key": "svg-1" }]]);

var IconArrowWaveRightDown = createVueComponent("outline", "arrow-wave-right-down", "ArrowWaveRightDown", [["path", { "d": "M17 14h4v-4", "key": "svg-0" }], ["path", { "d": "M3 12c.887 1.284 2.48 2.033 4 2c1.52 .033 3.113 -.716 4 -2s2.48 -2.033 4 -2c1.52 -.033 3 1 4 2l2 2", "key": "svg-1" }]]);

var IconArrowWaveRightUp = createVueComponent("outline", "arrow-wave-right-up", "ArrowWaveRightUp", [["path", { "d": "M17 10h4v4", "key": "svg-0" }], ["path", { "d": "M3 12c.887 -1.284 2.48 -2.033 4 -2c1.52 -.033 3.113 .716 4 2s2.48 2.033 4 2c1.52 .033 3 -1 4 -2l2 -2", "key": "svg-1" }]]);

var IconArrowZigZag = createVueComponent("outline", "arrow-zig-zag", "ArrowZigZag", [["path", { "d": "M6 20v-10l10 6v-12", "key": "svg-0" }], ["path", { "d": "M13 7l3 -3l3 3", "key": "svg-1" }]]);

var IconArrowsCross = createVueComponent("outline", "arrows-cross", "ArrowsCross", [["path", { "d": "M16 4h4v4", "key": "svg-0" }], ["path", { "d": "M15 9l5 -5", "key": "svg-1" }], ["path", { "d": "M4 20l5 -5", "key": "svg-2" }], ["path", { "d": "M16 20h4v-4", "key": "svg-3" }], ["path", { "d": "M4 4l16 16", "key": "svg-4" }]]);

var IconArrowsDiagonal2 = createVueComponent("outline", "arrows-diagonal-2", "ArrowsDiagonal2", [["path", { "d": "M16 20l4 0l0 -4", "key": "svg-0" }], ["path", { "d": "M14 14l6 6", "key": "svg-1" }], ["path", { "d": "M8 4l-4 0l0 4", "key": "svg-2" }], ["path", { "d": "M4 4l6 6", "key": "svg-3" }]]);

var IconArrowsDiagonalMinimize2 = createVueComponent("outline", "arrows-diagonal-minimize-2", "ArrowsDiagonalMinimize2", [["path", { "d": "M18 10h-4v-4", "key": "svg-0" }], ["path", { "d": "M20 4l-6 6", "key": "svg-1" }], ["path", { "d": "M6 14h4v4", "key": "svg-2" }], ["path", { "d": "M10 14l-6 6", "key": "svg-3" }]]);

var IconArrowsDiagonalMinimize = createVueComponent("outline", "arrows-diagonal-minimize", "ArrowsDiagonalMinimize", [["path", { "d": "M6 10h4v-4", "key": "svg-0" }], ["path", { "d": "M4 4l6 6", "key": "svg-1" }], ["path", { "d": "M18 14h-4v4", "key": "svg-2" }], ["path", { "d": "M14 14l6 6", "key": "svg-3" }]]);

var IconArrowsDiagonal = createVueComponent("outline", "arrows-diagonal", "ArrowsDiagonal", [["path", { "d": "M16 4l4 0l0 4", "key": "svg-0" }], ["path", { "d": "M14 10l6 -6", "key": "svg-1" }], ["path", { "d": "M8 20l-4 0l0 -4", "key": "svg-2" }], ["path", { "d": "M4 20l6 -6", "key": "svg-3" }]]);

var IconArrowsDiff = createVueComponent("outline", "arrows-diff", "ArrowsDiff", [["path", { "d": "M11 16h10", "key": "svg-0" }], ["path", { "d": "M11 16l4 4", "key": "svg-1" }], ["path", { "d": "M11 16l4 -4", "key": "svg-2" }], ["path", { "d": "M13 8h-10", "key": "svg-3" }], ["path", { "d": "M13 8l-4 4", "key": "svg-4" }], ["path", { "d": "M13 8l-4 -4", "key": "svg-5" }]]);

var IconArrowsDoubleNeSw = createVueComponent("outline", "arrows-double-ne-sw", "ArrowsDoubleNeSw", [["path", { "d": "M3 14l11 -11", "key": "svg-0" }], ["path", { "d": "M10 3h4v4", "key": "svg-1" }], ["path", { "d": "M10 17v4h4", "key": "svg-2" }], ["path", { "d": "M21 10l-11 11", "key": "svg-3" }]]);

var IconArrowsDoubleNwSe = createVueComponent("outline", "arrows-double-nw-se", "ArrowsDoubleNwSe", [["path", { "d": "M14 21l-11 -11", "key": "svg-0" }], ["path", { "d": "M3 14v-4h4", "key": "svg-1" }], ["path", { "d": "M17 14h4v-4", "key": "svg-2" }], ["path", { "d": "M10 3l11 11", "key": "svg-3" }]]);

var IconArrowsDoubleSeNw = createVueComponent("outline", "arrows-double-se-nw", "ArrowsDoubleSeNw", [["path", { "d": "M3 10l11 11", "key": "svg-0" }], ["path", { "d": "M14 17v4h-4", "key": "svg-1" }], ["path", { "d": "M14 3h-4v4", "key": "svg-2" }], ["path", { "d": "M21 14l-11 -11", "key": "svg-3" }]]);

var IconArrowsDoubleSwNe = createVueComponent("outline", "arrows-double-sw-ne", "ArrowsDoubleSwNe", [["path", { "d": "M14 3l-11 11", "key": "svg-0" }], ["path", { "d": "M3 10v4h4", "key": "svg-1" }], ["path", { "d": "M17 10h4v4", "key": "svg-2" }], ["path", { "d": "M10 21l11 -11", "key": "svg-3" }]]);

var IconArrowsDownUp = createVueComponent("outline", "arrows-down-up", "ArrowsDownUp", [["path", { "d": "M17 3l0 18", "key": "svg-0" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M7 21l0 -18", "key": "svg-2" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-3" }]]);

var IconArrowsDown = createVueComponent("outline", "arrows-down", "ArrowsDown", [["path", { "d": "M7 21l0 -18", "key": "svg-0" }], ["path", { "d": "M20 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M4 18l3 3l3 -3", "key": "svg-2" }], ["path", { "d": "M17 21l0 -18", "key": "svg-3" }]]);

var IconArrowsExchange2 = createVueComponent("outline", "arrows-exchange-2", "ArrowsExchange2", [["path", { "d": "M17 10h-14l4 -4", "key": "svg-0" }], ["path", { "d": "M7 14h14l-4 4", "key": "svg-1" }]]);

var IconArrowsExchange = createVueComponent("outline", "arrows-exchange", "ArrowsExchange", [["path", { "d": "M7 10h14l-4 -4", "key": "svg-0" }], ["path", { "d": "M17 14h-14l4 4", "key": "svg-1" }]]);

var IconArrowsHorizontal = createVueComponent("outline", "arrows-horizontal", "ArrowsHorizontal", [["path", { "d": "M7 8l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M17 8l4 4l-4 4", "key": "svg-1" }], ["path", { "d": "M3 12l18 0", "key": "svg-2" }]]);

var IconArrowsJoin2 = createVueComponent("outline", "arrows-join-2", "ArrowsJoin2", [["path", { "d": "M3 7h1.948c1.913 0 3.705 .933 4.802 2.5a5.861 5.861 0 0 0 4.802 2.5h6.448", "key": "svg-0" }], ["path", { "d": "M3 17h1.95a5.854 5.854 0 0 0 4.798 -2.5a5.854 5.854 0 0 1 4.798 -2.5h5.454", "key": "svg-1" }], ["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-2" }]]);

var IconArrowsJoin = createVueComponent("outline", "arrows-join", "ArrowsJoin", [["path", { "d": "M3 7h5l3.5 5h9.5", "key": "svg-0" }], ["path", { "d": "M3 17h5l3.495 -5", "key": "svg-1" }], ["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-2" }]]);

var IconArrowsLeftDown = createVueComponent("outline", "arrows-left-down", "ArrowsLeftDown", [["path", { "d": "M7 3l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M3 7h11a3 3 0 0 1 3 3v11", "key": "svg-1" }], ["path", { "d": "M13 17l4 4l4 -4", "key": "svg-2" }]]);

var IconArrowsLeftRight = createVueComponent("outline", "arrows-left-right", "ArrowsLeftRight", [["path", { "d": "M21 17l-18 0", "key": "svg-0" }], ["path", { "d": "M6 10l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M3 7l18 0", "key": "svg-2" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-3" }]]);

var IconArrowsLeft = createVueComponent("outline", "arrows-left", "ArrowsLeft", [["path", { "d": "M3 7l18 0", "key": "svg-0" }], ["path", { "d": "M6 20l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M6 4l-3 3l3 3", "key": "svg-2" }], ["path", { "d": "M3 17l18 0", "key": "svg-3" }]]);

var IconArrowsMaximize = createVueComponent("outline", "arrows-maximize", "ArrowsMaximize", [["path", { "d": "M16 4l4 0l0 4", "key": "svg-0" }], ["path", { "d": "M14 10l6 -6", "key": "svg-1" }], ["path", { "d": "M8 20l-4 0l0 -4", "key": "svg-2" }], ["path", { "d": "M4 20l6 -6", "key": "svg-3" }], ["path", { "d": "M16 20l4 0l0 -4", "key": "svg-4" }], ["path", { "d": "M14 14l6 6", "key": "svg-5" }], ["path", { "d": "M8 4l-4 0l0 4", "key": "svg-6" }], ["path", { "d": "M4 4l6 6", "key": "svg-7" }]]);

var IconArrowsMinimize = createVueComponent("outline", "arrows-minimize", "ArrowsMinimize", [["path", { "d": "M5 9l4 0l0 -4", "key": "svg-0" }], ["path", { "d": "M3 3l6 6", "key": "svg-1" }], ["path", { "d": "M5 15l4 0l0 4", "key": "svg-2" }], ["path", { "d": "M3 21l6 -6", "key": "svg-3" }], ["path", { "d": "M19 9l-4 0l0 -4", "key": "svg-4" }], ["path", { "d": "M15 9l6 -6", "key": "svg-5" }], ["path", { "d": "M19 15l-4 0l0 4", "key": "svg-6" }], ["path", { "d": "M15 15l6 6", "key": "svg-7" }]]);

var IconArrowsMoveHorizontal = createVueComponent("outline", "arrows-move-horizontal", "ArrowsMoveHorizontal", [["path", { "d": "M18 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M15 12h6", "key": "svg-1" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-2" }], ["path", { "d": "M3 12h6", "key": "svg-3" }]]);

var IconArrowsMoveVertical = createVueComponent("outline", "arrows-move-vertical", "ArrowsMoveVertical", [["path", { "d": "M9 18l3 3l3 -3", "key": "svg-0" }], ["path", { "d": "M12 15v6", "key": "svg-1" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M12 3v6", "key": "svg-3" }]]);

var IconArrowsMove = createVueComponent("outline", "arrows-move", "ArrowsMove", [["path", { "d": "M18 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M15 12h6", "key": "svg-1" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-2" }], ["path", { "d": "M3 12h6", "key": "svg-3" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-4" }], ["path", { "d": "M12 15v6", "key": "svg-5" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-6" }], ["path", { "d": "M12 3v6", "key": "svg-7" }]]);

var IconArrowsRandom = createVueComponent("outline", "arrows-random", "ArrowsRandom", [["path", { "d": "M20 21h-4v-4", "key": "svg-0" }], ["path", { "d": "M16 21l5 -5", "key": "svg-1" }], ["path", { "d": "M6.5 9.504l-3.5 -2l2 -3.504", "key": "svg-2" }], ["path", { "d": "M3 7.504l6.83 -1.87", "key": "svg-3" }], ["path", { "d": "M4 16l4 -1l1 4", "key": "svg-4" }], ["path", { "d": "M8 15l-3.5 6", "key": "svg-5" }], ["path", { "d": "M21 5l-.5 4l-4 -.5", "key": "svg-6" }], ["path", { "d": "M20.5 9l-4.5 -5.5", "key": "svg-7" }]]);

var IconArrowsRightDown = createVueComponent("outline", "arrows-right-down", "ArrowsRightDown", [["path", { "d": "M3 17l4 4l4 -4", "key": "svg-0" }], ["path", { "d": "M7 21v-11a3 3 0 0 1 3 -3h11", "key": "svg-1" }], ["path", { "d": "M17 11l4 -4l-4 -4", "key": "svg-2" }]]);

var IconArrowsRightLeft = createVueComponent("outline", "arrows-right-left", "ArrowsRightLeft", [["path", { "d": "M21 7l-18 0", "key": "svg-0" }], ["path", { "d": "M18 10l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M6 20l-3 -3l3 -3", "key": "svg-2" }], ["path", { "d": "M3 17l18 0", "key": "svg-3" }]]);

var IconArrowsRight = createVueComponent("outline", "arrows-right", "ArrowsRight", [["path", { "d": "M21 17l-18 0", "key": "svg-0" }], ["path", { "d": "M18 4l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-2" }], ["path", { "d": "M21 7l-18 0", "key": "svg-3" }]]);

var IconArrowsShuffle2 = createVueComponent("outline", "arrows-shuffle-2", "ArrowsShuffle2", [["path", { "d": "M18 4l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5", "key": "svg-2" }], ["path", { "d": "M3 17h3a5 5 0 0 0 5 -5a5 5 0 0 1 5 -5h5", "key": "svg-3" }]]);

var IconArrowsShuffle = createVueComponent("outline", "arrows-shuffle", "ArrowsShuffle", [["path", { "d": "M18 4l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5", "key": "svg-2" }], ["path", { "d": "M21 7h-5a4.978 4.978 0 0 0 -3 1m-4 8a4.984 4.984 0 0 1 -3 1h-3", "key": "svg-3" }]]);

var IconArrowsSort = createVueComponent("outline", "arrows-sort", "ArrowsSort", [["path", { "d": "M3 9l4 -4l4 4m-4 -4v14", "key": "svg-0" }], ["path", { "d": "M21 15l-4 4l-4 -4m4 4v-14", "key": "svg-1" }]]);

var IconArrowsSplit2 = createVueComponent("outline", "arrows-split-2", "ArrowsSplit2", [["path", { "d": "M21 17h-5.397a5 5 0 0 1 -4.096 -2.133l-.514 -.734a5 5 0 0 0 -4.096 -2.133h-3.897", "key": "svg-0" }], ["path", { "d": "M21 7h-5.395a5 5 0 0 0 -4.098 2.135l-.51 .73a5 5 0 0 1 -4.097 2.135h-3.9", "key": "svg-1" }], ["path", { "d": "M18 10l3 -3l-3 -3", "key": "svg-2" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-3" }]]);

var IconArrowsSplit = createVueComponent("outline", "arrows-split", "ArrowsSplit", [["path", { "d": "M21 17h-8l-3.5 -5h-6.5", "key": "svg-0" }], ["path", { "d": "M21 7h-8l-3.495 5", "key": "svg-1" }], ["path", { "d": "M18 10l3 -3l-3 -3", "key": "svg-2" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-3" }]]);

var IconArrowsTransferDown = createVueComponent("outline", "arrows-transfer-down", "ArrowsTransferDown", [["path", { "d": "M17 3v6", "key": "svg-0" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M7 21v-18", "key": "svg-2" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-3" }], ["path", { "d": "M17 21v-2", "key": "svg-4" }], ["path", { "d": "M17 15v-2", "key": "svg-5" }]]);

var IconArrowsTransferUpDown = createVueComponent("outline", "arrows-transfer-up-down", "ArrowsTransferUpDown", [["path", { "d": "M7 21v-6", "key": "svg-0" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M7 3v2", "key": "svg-3" }], ["path", { "d": "M7 9v2", "key": "svg-4" }], ["path", { "d": "M17 3v6", "key": "svg-5" }], ["path", { "d": "M17 21v-2", "key": "svg-6" }], ["path", { "d": "M17 15v-2", "key": "svg-7" }]]);

var IconArrowsTransferUp = createVueComponent("outline", "arrows-transfer-up", "ArrowsTransferUp", [["path", { "d": "M7 21v-6", "key": "svg-0" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M17 3v18", "key": "svg-2" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-3" }], ["path", { "d": "M7 3v2", "key": "svg-4" }], ["path", { "d": "M7 9v2", "key": "svg-5" }]]);

var IconArrowsUpDown = createVueComponent("outline", "arrows-up-down", "ArrowsUpDown", [["path", { "d": "M7 3l0 18", "key": "svg-0" }], ["path", { "d": "M10 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M20 18l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M17 21l0 -18", "key": "svg-3" }]]);

var IconArrowsUpLeft = createVueComponent("outline", "arrows-up-left", "ArrowsUpLeft", [["path", { "d": "M21 7l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M17 3v11a3 3 0 0 1 -3 3h-11", "key": "svg-1" }], ["path", { "d": "M7 13l-4 4l4 4", "key": "svg-2" }]]);

var IconArrowsUpRight = createVueComponent("outline", "arrows-up-right", "ArrowsUpRight", [["path", { "d": "M17 21l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M21 17h-11a3 3 0 0 1 -3 -3v-11", "key": "svg-1" }], ["path", { "d": "M11 7l-4 -4l-4 4", "key": "svg-2" }]]);

var IconArrowsUp = createVueComponent("outline", "arrows-up", "ArrowsUp", [["path", { "d": "M17 3l0 18", "key": "svg-0" }], ["path", { "d": "M4 6l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M7 3l0 18", "key": "svg-3" }]]);

var IconArrowsVertical = createVueComponent("outline", "arrows-vertical", "ArrowsVertical", [["path", { "d": "M8 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M8 17l4 4l4 -4", "key": "svg-1" }], ["path", { "d": "M12 3l0 18", "key": "svg-2" }]]);

var IconArtboardOff = createVueComponent("outline", "artboard-off", "ArtboardOff", [["path", { "d": "M12 8h3a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M15.716 15.698a1 1 0 0 1 -.716 .302h-6a1 1 0 0 1 -1 -1v-6c0 -.273 .11 -.52 .287 -.7", "key": "svg-1" }], ["path", { "d": "M3 8h1", "key": "svg-2" }], ["path", { "d": "M3 16h1", "key": "svg-3" }], ["path", { "d": "M8 3v1", "key": "svg-4" }], ["path", { "d": "M16 3v1", "key": "svg-5" }], ["path", { "d": "M20 8h1", "key": "svg-6" }], ["path", { "d": "M20 16h1", "key": "svg-7" }], ["path", { "d": "M8 20v1", "key": "svg-8" }], ["path", { "d": "M16 20v1", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconArtboard = createVueComponent("outline", "artboard", "Artboard", [["path", { "d": "M8 8m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M3 8l1 0", "key": "svg-1" }], ["path", { "d": "M3 16l1 0", "key": "svg-2" }], ["path", { "d": "M8 3l0 1", "key": "svg-3" }], ["path", { "d": "M16 3l0 1", "key": "svg-4" }], ["path", { "d": "M20 8l1 0", "key": "svg-5" }], ["path", { "d": "M20 16l1 0", "key": "svg-6" }], ["path", { "d": "M8 20l0 1", "key": "svg-7" }], ["path", { "d": "M16 20l0 1", "key": "svg-8" }]]);

var IconArticleOff = createVueComponent("outline", "article-off", "ArticleOff", [["path", { "d": "M8 4h11a2 2 0 0 1 2 2v11m-1.172 2.821a1.993 1.993 0 0 1 -.828 .179h-14a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 1.156 -1.814", "key": "svg-0" }], ["path", { "d": "M7 8h1m4 0h5", "key": "svg-1" }], ["path", { "d": "M7 12h5m4 0h1", "key": "svg-2" }], ["path", { "d": "M7 16h9", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconArticle = createVueComponent("outline", "article", "Article", [["path", { "d": "M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 8h10", "key": "svg-1" }], ["path", { "d": "M7 12h10", "key": "svg-2" }], ["path", { "d": "M7 16h10", "key": "svg-3" }]]);

var IconAspectRatioOff = createVueComponent("outline", "aspect-ratio-off", "AspectRatioOff", [["path", { "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 12v-3h2", "key": "svg-1" }], ["path", { "d": "M17 12v1m-2 2h-1", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAspectRatio = createVueComponent("outline", "aspect-ratio", "AspectRatio", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 12v-3h3", "key": "svg-1" }], ["path", { "d": "M17 12v3h-3", "key": "svg-2" }]]);

var IconAssemblyOff = createVueComponent("outline", "assembly-off", "AssemblyOff", [["path", { "d": "M18.376 18.377l-5.284 3.343a2.27 2.27 0 0 1 -2.184 0l-6.75 -4.27a2.23 2.23 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l1.328 -.783m2.514 -1.487l2.908 -1.71a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .417 -.118 .817 -.33 1.16", "key": "svg-0" }], ["path", { "d": "M14.855 14.855l-2.37 1.519a1 1 0 0 1 -.97 0l-3 -1.922a1 1 0 0 1 -.515 -.876v-3.278c0 -.364 .197 -.7 .514 -.877l.563 -.336m2.437 -1.454a1.03 1.03 0 0 1 1 0l3 1.79h-.014c.312 .181 .503 .516 .5 .877v1.702", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAssembly = createVueComponent("outline", "assembly", "Assembly", [["path", { "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.27 2.27 0 0 1 -2.184 0l-6.75 -4.27a2.23 2.23 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98z", "key": "svg-0" }], ["path", { "d": "M15.5 9.422c.312 .18 .503 .515 .5 .876v3.277c0 .364 -.197 .7 -.515 .877l-3 1.922a1 1 0 0 1 -.97 0l-3 -1.922a1 1 0 0 1 -.515 -.876v-3.278c0 -.364 .197 -.7 .514 -.877l3 -1.79c.311 -.174 .69 -.174 1 0l3 1.79h-.014z", "key": "svg-1" }]]);

var IconAsset = createVueComponent("outline", "asset", "Asset", [["path", { "d": "M9 15m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M14.218 17.975l6.619 -12.174", "key": "svg-3" }], ["path", { "d": "M6.079 9.756l12.217 -6.631", "key": "svg-4" }], ["path", { "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-5" }]]);

var IconAsteriskSimple = createVueComponent("outline", "asterisk-simple", "AsteriskSimple", [["path", { "d": "M12 12v-9", "key": "svg-0" }], ["path", { "d": "M12 12l-9 -2.5", "key": "svg-1" }], ["path", { "d": "M12 12l9 -2.5", "key": "svg-2" }], ["path", { "d": "M12 12l6 8.5", "key": "svg-3" }], ["path", { "d": "M12 12l-6 8.5", "key": "svg-4" }]]);

var IconAsterisk = createVueComponent("outline", "asterisk", "Asterisk", [["path", { "d": "M12 12l8 -4.5", "key": "svg-0" }], ["path", { "d": "M12 12v9", "key": "svg-1" }], ["path", { "d": "M12 12l-8 -4.5", "key": "svg-2" }], ["path", { "d": "M12 12l8 4.5", "key": "svg-3" }], ["path", { "d": "M12 3v9", "key": "svg-4" }], ["path", { "d": "M12 12l-8 4.5", "key": "svg-5" }]]);

var IconAtOff = createVueComponent("outline", "at-off", "AtOff", [["path", { "d": "M9.174 9.17a4 4 0 0 0 5.646 5.668m1.18 -2.838a4 4 0 0 0 -4 -4", "key": "svg-0" }], ["path", { "d": "M19.695 15.697a2.5 2.5 0 0 0 1.305 -2.197v-1.5a9 9 0 0 0 -13.055 -8.047m-2.322 1.683a9 9 0 0 0 9.877 14.644", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAt = createVueComponent("outline", "at", "At", [["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M16 12v1.5a2.5 2.5 0 0 0 5 0v-1.5a9 9 0 1 0 -5.5 8.28", "key": "svg-1" }]]);

var IconAtom2 = createVueComponent("outline", "atom-2", "Atom2", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 21l0 .01", "key": "svg-1" }], ["path", { "d": "M3 9l0 .01", "key": "svg-2" }], ["path", { "d": "M21 9l0 .01", "key": "svg-3" }], ["path", { "d": "M8 20.1a9 9 0 0 1 -5 -7.1", "key": "svg-4" }], ["path", { "d": "M16 20.1a9 9 0 0 0 5 -7.1", "key": "svg-5" }], ["path", { "d": "M6.2 5a9 9 0 0 1 11.4 0", "key": "svg-6" }]]);

var IconAtomOff = createVueComponent("outline", "atom-off", "AtomOff", [["path", { "d": "M12 12v.01", "key": "svg-0" }], ["path", { "d": "M9.172 9.172c-3.906 3.905 -5.805 8.337 -4.243 9.9c1.562 1.561 6 -.338 9.9 -4.244m1.884 -2.113c2.587 -3.277 3.642 -6.502 2.358 -7.786c-1.284 -1.284 -4.508 -.23 -7.784 2.357", "key": "svg-1" }], ["path", { "d": "M4.929 4.929c-1.562 1.562 .337 6 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242m-.072 -4.071c-.767 -1.794 -2.215 -3.872 -4.172 -5.828c-1.944 -1.945 -4.041 -3.402 -5.828 -4.172", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAtom = createVueComponent("outline", "atom", "Atom", [["path", { "d": "M12 12v.01", "key": "svg-0" }], ["path", { "d": "M19.071 4.929c-1.562 -1.562 -6 .337 -9.9 4.243c-3.905 3.905 -5.804 8.337 -4.242 9.9c1.562 1.561 6 -.338 9.9 -4.244c3.905 -3.905 5.804 -8.337 4.242 -9.9", "key": "svg-1" }], ["path", { "d": "M4.929 4.929c-1.562 1.562 .337 6 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242c1.561 -1.562 -.338 -6 -4.244 -9.9c-3.905 -3.905 -8.337 -5.804 -9.9 -4.242", "key": "svg-2" }]]);

var IconAugmentedReality2 = createVueComponent("outline", "augmented-reality-2", "AugmentedReality2", [["path", { "d": "M10 21h-2a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M17 17l-4 -2.5l4 -2.5l4 2.5v4.5l-4 2.5z", "key": "svg-1" }], ["path", { "d": "M13 14.5v4.5l4 2.5", "key": "svg-2" }], ["path", { "d": "M17 17l4 -2.5", "key": "svg-3" }], ["path", { "d": "M11 4h2", "key": "svg-4" }]]);

var IconAugmentedRealityOff = createVueComponent("outline", "augmented-reality-off", "AugmentedRealityOff", [["path", { "d": "M4 8v-2c0 -.557 .228 -1.061 .595 -1.424", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2c.558 0 1.062 -.228 1.425 -.596", "key": "svg-3" }], ["path", { "d": "M12 12.5l.312 -.195m2.457 -1.536l1.231 -.769", "key": "svg-4" }], ["path", { "d": "M9.225 9.235l-1.225 .765l4 2.5v4.5l3.076 -1.923m.924 -3.077v-2l-4 -2.5l-.302 .189", "key": "svg-5" }], ["path", { "d": "M8 10v4.5l4 2.5", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconAugmentedReality = createVueComponent("outline", "augmented-reality", "AugmentedReality", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M12 12.5l4 -2.5", "key": "svg-4" }], ["path", { "d": "M8 10l4 2.5v4.5l4 -2.5v-4.5l-4 -2.5z", "key": "svg-5" }], ["path", { "d": "M8 10v4.5l4 2.5", "key": "svg-6" }]]);

var IconAuth2fa = createVueComponent("outline", "auth-2fa", "Auth2fa", [["path", { "d": "M7 16h-4l3.47 -4.66a2 2 0 1 0 -3.47 -1.54", "key": "svg-0" }], ["path", { "d": "M10 16v-8h4", "key": "svg-1" }], ["path", { "d": "M10 12l3 0", "key": "svg-2" }], ["path", { "d": "M17 16v-6a2 2 0 0 1 4 0v6", "key": "svg-3" }], ["path", { "d": "M17 13l4 0", "key": "svg-4" }]]);

var IconAutomaticGearbox = createVueComponent("outline", "automatic-gearbox", "AutomaticGearbox", [["path", { "d": "M17 17v4h1a2 2 0 1 0 0 -4h-1z", "key": "svg-0" }], ["path", { "d": "M17 11h1.5a1.5 1.5 0 0 0 0 -3h-1.5v5", "key": "svg-1" }], ["path", { "d": "M5 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M5 7v3a1 1 0 0 0 1 1h3v7a1 1 0 0 0 1 1h3", "key": "svg-3" }], ["path", { "d": "M9 11h4", "key": "svg-4" }]]);

var IconAutomation = createVueComponent("outline", "automation", "Automation", [["path", { "d": "M13 20.693c-.905 .628 -2.36 .292 -2.675 -1.01a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.492 .362 1.716 2.219 .674 3.03", "key": "svg-0" }], ["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 22l5 -3l-5 -3z", "key": "svg-2" }]]);

var IconAvocado = createVueComponent("outline", "avocado", "Avocado", [["path", { "d": "M17.8 14.04a3.905 3.905 0 0 1 1.337 -2.075c1.195 -.985 1.816 -2.285 1.863 -3.902c-.047 -1.43 -.54 -2.626 -1.477 -3.586c-.96 -.938 -2.156 -1.43 -3.585 -1.477c-1.618 .047 -2.918 .668 -3.903 1.863c-.562 .68 -1.254 1.125 -2.074 1.336c-.938 .188 -1.828 .48 -2.672 .88c-.844 .398 -1.559 .878 -2.144 1.44c-1.43 1.501 -2.145 3.224 -2.145 5.169c0 1.946 .715 3.668 2.145 5.168c1.5 1.429 3.222 2.144 5.168 2.144c1.945 0 3.667 -.715 5.167 -2.145c.563 -.585 1.055 -1.3 1.477 -2.144c.398 -.844 .68 -1.723 .844 -2.637v-.035z", "key": "svg-0" }], ["path", { "d": "M10.87 10.036c-.942 .112 -1.794 .538 -2.556 1.278c-.74 .762 -1.166 1.614 -1.278 2.556c-.135 .92 .112 1.704 .74 2.354c.65 .628 1.435 .875 2.354 .74c.942 -.112 1.794 -.538 2.556 -1.278c.74 -.762 1.166 -1.614 1.278 -2.556c.135 -.92 -.112 -1.704 -.74 -2.354c-.65 -.628 -1.435 -.875 -2.354 -.74z", "key": "svg-1" }]]);

var IconAwardOff = createVueComponent("outline", "award-off", "AwardOff", [["path", { "d": "M16.72 12.704a6 6 0 0 0 -8.433 -8.418m-1.755 2.24a6 6 0 0 0 7.936 7.944", "key": "svg-0" }], ["path", { "d": "M12 15l3.4 5.89l1.598 -3.233l.707 .046m1.108 -2.902l-1.617 -2.8", "key": "svg-1" }], ["path", { "d": "M6.802 12l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAward = createVueComponent("outline", "award", "Award", [["path", { "d": "M12 9m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M12 15l3.4 5.89l1.598 -3.233l3.598 .232l-3.4 -5.889", "key": "svg-1" }], ["path", { "d": "M6.802 12l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889", "key": "svg-2" }]]);

var IconAxe = createVueComponent("outline", "axe", "Axe", [["path", { "d": "M13 9l7.383 7.418c.823 .82 .823 2.148 0 2.967a2.11 2.11 0 0 1 -2.976 0l-7.407 -7.385", "key": "svg-0" }], ["path", { "d": "M6.66 15.66l-3.32 -3.32a1.25 1.25 0 0 1 .42 -2.044l3.24 -1.296l6 -6l3 3l-6 6l-1.296 3.24a1.25 1.25 0 0 1 -2.044 .42z", "key": "svg-1" }]]);

var IconAxisX = createVueComponent("outline", "axis-x", "AxisX", [["path", { "d": "M4 13v.01", "key": "svg-0" }], ["path", { "d": "M4 9v.01", "key": "svg-1" }], ["path", { "d": "M4 5v.01", "key": "svg-2" }], ["path", { "d": "M17 20l3 -3l-3 -3", "key": "svg-3" }], ["path", { "d": "M4 17h16", "key": "svg-4" }]]);

var IconAxisY = createVueComponent("outline", "axis-y", "AxisY", [["path", { "d": "M11 20h-.01", "key": "svg-0" }], ["path", { "d": "M15 20h-.01", "key": "svg-1" }], ["path", { "d": "M19 20h-.01", "key": "svg-2" }], ["path", { "d": "M4 7l3 -3l3 3", "key": "svg-3" }], ["path", { "d": "M7 20v-16", "key": "svg-4" }]]);

var IconBabyBottle = createVueComponent("outline", "baby-bottle", "BabyBottle", [["path", { "d": "M5 10h14", "key": "svg-0" }], ["path", { "d": "M12 2v2", "key": "svg-1" }], ["path", { "d": "M12 4a5 5 0 0 1 5 5v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-11a5 5 0 0 1 5 -5z", "key": "svg-2" }]]);

var IconBabyCarriage = createVueComponent("outline", "baby-carriage", "BabyCarriage", [["path", { "d": "M8 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M18 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M2 5h2.5l1.632 4.897a6 6 0 0 0 5.693 4.103h2.675a5.5 5.5 0 0 0 0 -11h-.5v6", "key": "svg-2" }], ["path", { "d": "M6 9h14", "key": "svg-3" }], ["path", { "d": "M9 17l1 -3", "key": "svg-4" }], ["path", { "d": "M16 14l1 3", "key": "svg-5" }]]);

var IconBackground = createVueComponent("outline", "background", "Background", [["path", { "d": "M4 8l4 -4", "key": "svg-0" }], ["path", { "d": "M14 4l-10 10", "key": "svg-1" }], ["path", { "d": "M4 20l16 -16", "key": "svg-2" }], ["path", { "d": "M20 10l-10 10", "key": "svg-3" }], ["path", { "d": "M20 16l-4 4", "key": "svg-4" }]]);

var IconBackhoe = createVueComponent("outline", "backhoe", "Backhoe", [["path", { "d": "M4 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M13 19l-9 0", "key": "svg-2" }], ["path", { "d": "M4 15l9 0", "key": "svg-3" }], ["path", { "d": "M8 12v-5h2a3 3 0 0 1 3 3v5", "key": "svg-4" }], ["path", { "d": "M5 15v-2a1 1 0 0 1 1 -1h7", "key": "svg-5" }], ["path", { "d": "M21.12 9.88l-3.12 -4.88l-5 5", "key": "svg-6" }], ["path", { "d": "M21.12 9.88a3 3 0 0 1 -2.12 5.12a3 3 0 0 1 -2.12 -.88l4.24 -4.24z", "key": "svg-7" }]]);

var IconBackpackOff = createVueComponent("outline", "backpack-off", "BackpackOff", [["path", { "d": "M10 6h3a6 6 0 0 1 6 6v3m-.129 3.872a3 3 0 0 1 -2.871 2.128h-8a3 3 0 0 1 -3 -3v-6a5.99 5.99 0 0 1 2.285 -4.712", "key": "svg-0" }], ["path", { "d": "M10 6v-1a2 2 0 1 1 4 0v1", "key": "svg-1" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBackpack = createVueComponent("outline", "backpack", "Backpack", [["path", { "d": "M5 18v-6a6 6 0 0 1 6 -6h2a6 6 0 0 1 6 6v6a3 3 0 0 1 -3 3h-8a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M10 6v-1a2 2 0 1 1 4 0v1", "key": "svg-1" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-2" }], ["path", { "d": "M11 10h2", "key": "svg-3" }]]);

var IconBackslash = createVueComponent("outline", "backslash", "Backslash", [["path", { "d": "M7 5l10 14", "key": "svg-0" }]]);

var IconBackspace = createVueComponent("outline", "backspace", "Backspace", [["path", { "d": "M20 6a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-11l-5 -5a1.5 1.5 0 0 1 0 -2l5 -5z", "key": "svg-0" }], ["path", { "d": "M12 10l4 4m0 -4l-4 4", "key": "svg-1" }]]);

var IconBadge2k = createVueComponent("outline", "badge-2k", "Badge2k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M7 9h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-4" }]]);

var IconBadge3d = createVueComponent("outline", "badge-3d", "Badge3d", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9h1.5a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1.5", "key": "svg-1" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2z", "key": "svg-2" }]]);

var IconBadge3k = createVueComponent("outline", "badge-3k", "Badge3k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M7 9.5a.5 .5 0 0 1 .5 -.5h1a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1a.5 .5 0 0 1 -.5 -.5", "key": "svg-4" }]]);

var IconBadge4k = createVueComponent("outline", "badge-4k", "Badge4k", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9v2a1 1 0 0 0 1 1h1", "key": "svg-1" }], ["path", { "d": "M10 9v6", "key": "svg-2" }], ["path", { "d": "M14 9v6", "key": "svg-3" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-4" }], ["path", { "d": "M15 12h-1", "key": "svg-5" }]]);

var IconBadge5k = createVueComponent("outline", "badge-5k", "Badge5k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M7 15h2a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-2v-3h3", "key": "svg-4" }]]);

var IconBadge8k = createVueComponent("outline", "badge-8k", "Badge8k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M8.5 12h-.5a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1zh-.5a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1", "key": "svg-4" }]]);

var IconBadgeAdOff = createVueComponent("outline", "badge-ad-off", "BadgeAdOff", [["path", { "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M14 14v1h1m2 -2v-2a2 2 0 0 0 -2 -2h-1v1", "key": "svg-1" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 2.077 -1.385m.788 .762c.087 .19 .135 .4 .135 .623v4.5", "key": "svg-2" }], ["path", { "d": "M7 13h3", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBadgeAd = createVueComponent("outline", "badge-ad", "BadgeAd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-1" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-2" }], ["path", { "d": "M7 13h3", "key": "svg-3" }]]);

var IconBadgeAr = createVueComponent("outline", "badge-ar", "BadgeAr", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-1" }], ["path", { "d": "M7 13h3", "key": "svg-2" }], ["path", { "d": "M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3", "key": "svg-3" }]]);

var IconBadgeCc = createVueComponent("outline", "badge-cc", "BadgeCc", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M10 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-1" }], ["path", { "d": "M17 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }]]);

var IconBadgeHd = createVueComponent("outline", "badge-hd", "BadgeHd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-1" }], ["path", { "d": "M7 15v-6", "key": "svg-2" }], ["path", { "d": "M10 15v-6", "key": "svg-3" }], ["path", { "d": "M7 12h3", "key": "svg-4" }]]);

var IconBadgeOff = createVueComponent("outline", "badge-off", "BadgeOff", [["path", { "d": "M7 7v10l5 3l5 -3m0 -4v-9l-5 3l-2.496 -1.497", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBadgeSd = createVueComponent("outline", "badge-sd", "BadgeSd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-1" }], ["path", { "d": "M7 14.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-2" }]]);

var IconBadgeTm = createVueComponent("outline", "badge-tm", "BadgeTm", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 9h4", "key": "svg-1" }], ["path", { "d": "M8 9v6", "key": "svg-2" }], ["path", { "d": "M13 15v-6l2 3l2 -3v6", "key": "svg-3" }]]);

var IconBadgeVo = createVueComponent("outline", "badge-vo", "BadgeVo", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9l2 6l2 -6", "key": "svg-1" }], ["path", { "d": "M15.5 9a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1 -3 0v-3a1.5 1.5 0 0 1 1.5 -1.5z", "key": "svg-2" }]]);

var IconBadgeVr = createVueComponent("outline", "badge-vr", "BadgeVr", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3", "key": "svg-1" }], ["path", { "d": "M7 9l2 6l2 -6", "key": "svg-2" }]]);

var IconBadgeWc = createVueComponent("outline", "badge-wc", "BadgeWc", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6.5 9l.5 6l2 -4l2 4l.5 -6", "key": "svg-1" }], ["path", { "d": "M17 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }]]);

var IconBadge = createVueComponent("outline", "badge", "Badge", [["path", { "d": "M17 17v-13l-5 3l-5 -3v13l5 3z", "key": "svg-0" }]]);

var IconBadgesOff = createVueComponent("outline", "badges-off", "BadgesOff", [["path", { "d": "M14.505 14.497l-2.505 1.503l-5 -3v4l5 3l5 -3", "key": "svg-0" }], ["path", { "d": "M13.873 9.876l3.127 -1.876v-4l-5 3l-2.492 -1.495m-2.508 1.495v1l2.492 1.495", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBadges = createVueComponent("outline", "badges", "Badges", [["path", { "d": "M17 17v-4l-5 3l-5 -3v4l5 3z", "key": "svg-0" }], ["path", { "d": "M17 8v-4l-5 3l-5 -3v4l5 3z", "key": "svg-1" }]]);

var IconBaguette = createVueComponent("outline", "baguette", "Baguette", [["path", { "d": "M5.628 11.283l5.644 -5.637c2.665 -2.663 5.924 -3.747 8.663 -1.205l.188 .181a2.987 2.987 0 0 1 0 4.228l-11.287 11.274a3 3 0 0 1 -4.089 .135l-.143 -.135c-2.728 -2.724 -1.704 -6.117 1.024 -8.841z", "key": "svg-0" }], ["path", { "d": "M9.5 7.5l1.5 3.5", "key": "svg-1" }], ["path", { "d": "M6.5 10.5l1.5 3.5", "key": "svg-2" }], ["path", { "d": "M12.5 4.5l1.5 3.5", "key": "svg-3" }]]);

var IconBallAmericanFootballOff = createVueComponent("outline", "ball-american-football-off", "BallAmericanFootballOff", [["path", { "d": "M15 9l-1 1m-2 2l-3 3", "key": "svg-0" }], ["path", { "d": "M10 12l2 2", "key": "svg-1" }], ["path", { "d": "M8 21a5 5 0 0 0 -5 -5", "key": "svg-2" }], ["path", { "d": "M6.813 6.802a12.96 12.96 0 0 0 -3.813 9.198a5 5 0 0 0 5 5a12.96 12.96 0 0 0 9.186 -3.801m1.789 -2.227a12.94 12.94 0 0 0 2.025 -6.972a5 5 0 0 0 -5 -5a12.94 12.94 0 0 0 -6.967 2.022", "key": "svg-3" }], ["path", { "d": "M16 3a5 5 0 0 0 5 5", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBallAmericanFootball = createVueComponent("outline", "ball-american-football", "BallAmericanFootball", [["path", { "d": "M15 9l-6 6", "key": "svg-0" }], ["path", { "d": "M10 12l2 2", "key": "svg-1" }], ["path", { "d": "M12 10l2 2", "key": "svg-2" }], ["path", { "d": "M8 21a5 5 0 0 0 -5 -5", "key": "svg-3" }], ["path", { "d": "M16 3c-7.18 0 -13 5.82 -13 13a5 5 0 0 0 5 5c7.18 0 13 -5.82 13 -13a5 5 0 0 0 -5 -5", "key": "svg-4" }], ["path", { "d": "M16 3a5 5 0 0 0 5 5", "key": "svg-5" }]]);

var IconBallBaseball = createVueComponent("outline", "ball-baseball", "BallBaseball", [["path", { "d": "M5.636 18.364a9 9 0 1 0 12.728 -12.728a9 9 0 0 0 -12.728 12.728z", "key": "svg-0" }], ["path", { "d": "M12.495 3.02a9 9 0 0 1 -9.475 9.475", "key": "svg-1" }], ["path", { "d": "M20.98 11.505a9 9 0 0 0 -9.475 9.475", "key": "svg-2" }], ["path", { "d": "M9 9l2 2", "key": "svg-3" }], ["path", { "d": "M13 13l2 2", "key": "svg-4" }], ["path", { "d": "M11 7l2 1", "key": "svg-5" }], ["path", { "d": "M7 11l1 2", "key": "svg-6" }], ["path", { "d": "M16 11l1 2", "key": "svg-7" }], ["path", { "d": "M11 16l2 1", "key": "svg-8" }]]);

var IconBallBasketball = createVueComponent("outline", "ball-basketball", "BallBasketball", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M5.65 5.65l12.7 12.7", "key": "svg-1" }], ["path", { "d": "M5.65 18.35l12.7 -12.7", "key": "svg-2" }], ["path", { "d": "M12 3a9 9 0 0 0 9 9", "key": "svg-3" }], ["path", { "d": "M3 12a9 9 0 0 1 9 9", "key": "svg-4" }]]);

var IconBallBowling = createVueComponent("outline", "ball-bowling", "BallBowling", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 9l0 .01", "key": "svg-1" }], ["path", { "d": "M15 8l0 .01", "key": "svg-2" }], ["path", { "d": "M14 12l0 .01", "key": "svg-3" }]]);

var IconBallFootballOff = createVueComponent("outline", "ball-football-off", "BallFootballOff", [["path", { "d": "M20.041 16.046a9 9 0 0 0 -12.084 -12.09m-2.323 1.683a9 9 0 0 0 12.726 12.73", "key": "svg-0" }], ["path", { "d": "M12 7l4.755 3.455l-.566 1.743l-.98 3.014l-.209 .788h-6l-1.755 -5.545l1.86 -1.351l2.313 -1.681z", "key": "svg-1" }], ["path", { "d": "M12 7v-4", "key": "svg-2" }], ["path", { "d": "M15 16l2.5 3", "key": "svg-3" }], ["path", { "d": "M16.755 10.455l3.745 -1.455", "key": "svg-4" }], ["path", { "d": "M9.061 16.045l-2.561 2.955", "key": "svg-5" }], ["path", { "d": "M7.245 10.455l-3.745 -1.455", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBallFootball = createVueComponent("outline", "ball-football", "BallFootball", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7l4.76 3.45l-1.76 5.55h-6l-1.76 -5.55z", "key": "svg-1" }], ["path", { "d": "M12 7v-4m3 13l2.5 3m-.74 -8.55l3.74 -1.45m-11.44 7.05l-2.56 2.95m.74 -8.55l-3.74 -1.45", "key": "svg-2" }]]);

var IconBallTennis = createVueComponent("outline", "ball-tennis", "BallTennis", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M6 5.3a9 9 0 0 1 0 13.4", "key": "svg-1" }], ["path", { "d": "M18 5.3a9 9 0 0 0 0 13.4", "key": "svg-2" }]]);

var IconBallVolleyball = createVueComponent("outline", "ball-volleyball", "BallVolleyball", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12a8 8 0 0 0 8 4", "key": "svg-1" }], ["path", { "d": "M7.5 13.5a12 12 0 0 0 8.5 6.5", "key": "svg-2" }], ["path", { "d": "M12 12a8 8 0 0 0 -7.464 4.928", "key": "svg-3" }], ["path", { "d": "M12.951 7.353a12 12 0 0 0 -9.88 4.111", "key": "svg-4" }], ["path", { "d": "M12 12a8 8 0 0 0 -.536 -8.928", "key": "svg-5" }], ["path", { "d": "M15.549 15.147a12 12 0 0 0 1.38 -10.611", "key": "svg-6" }]]);

var IconBalloonOff = createVueComponent("outline", "balloon-off", "BalloonOff", [["path", { "d": "M14 8a2 2 0 0 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M7.762 3.753a6 6 0 0 1 10.238 4.247c0 1.847 -.37 3.564 -1.007 4.993m-1.59 2.42c-.967 1 -2.14 1.587 -3.403 1.587c-3.314 0 -6 -4.03 -6 -9c0 -.593 .086 -1.166 .246 -1.707", "key": "svg-1" }], ["path", { "d": "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBalloon = createVueComponent("outline", "balloon", "Balloon", [["path", { "d": "M14 8a2 2 0 0 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M6 8a6 6 0 1 1 12 0c0 4.97 -2.686 9 -6 9s-6 -4.03 -6 -9", "key": "svg-1" }], ["path", { "d": "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2", "key": "svg-2" }]]);

var IconBallpenOff = createVueComponent("outline", "ballpen-off", "BallpenOff", [["path", { "d": "M14 6l7 7l-2 2", "key": "svg-0" }], ["path", { "d": "M10 10l-4.172 4.172a2.828 2.828 0 1 0 4 4l4.172 -4.172", "key": "svg-1" }], ["path", { "d": "M16 12l4.414 -4.414a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-4.414 4.414", "key": "svg-2" }], ["path", { "d": "M4 20l1.768 -1.768", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBallpen = createVueComponent("outline", "ballpen", "Ballpen", [["path", { "d": "M14 6l7 7l-4 4", "key": "svg-0" }], ["path", { "d": "M5.828 18.172a2.828 2.828 0 0 0 4 0l10.586 -10.586a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-10.586 10.586a2.828 2.828 0 0 0 0 4z", "key": "svg-1" }], ["path", { "d": "M4 20l1.768 -1.768", "key": "svg-2" }]]);

var IconBan = createVueComponent("outline", "ban", "Ban", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M5.7 5.7l12.6 12.6", "key": "svg-1" }]]);

var IconBandageOff = createVueComponent("outline", "bandage-off", "BandageOff", [["path", { "d": "M10 12v.01", "key": "svg-0" }], ["path", { "d": "M12 14v.01", "key": "svg-1" }], ["path", { "d": "M10.513 6.487l1.987 -1.987a4.95 4.95 0 0 1 7 7l-2.018 2.018m-1.982 1.982l-4 4a4.95 4.95 0 0 1 -7 -7l4 -4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBandage = createVueComponent("outline", "bandage", "Bandage", [["path", { "d": "M14 12l0 .01", "key": "svg-0" }], ["path", { "d": "M10 12l0 .01", "key": "svg-1" }], ["path", { "d": "M12 10l0 .01", "key": "svg-2" }], ["path", { "d": "M12 14l0 .01", "key": "svg-3" }], ["path", { "d": "M4.5 12.5l8 -8a4.94 4.94 0 0 1 7 7l-8 8a4.94 4.94 0 0 1 -7 -7", "key": "svg-4" }]]);

var IconBarbellOff = createVueComponent("outline", "barbell-off", "BarbellOff", [["path", { "d": "M2 12h1", "key": "svg-0" }], ["path", { "d": "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2", "key": "svg-1" }], ["path", { "d": "M6.298 6.288a1 1 0 0 0 -.298 .712v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-8", "key": "svg-2" }], ["path", { "d": "M9 12h3", "key": "svg-3" }], ["path", { "d": "M15 15v2a1 1 0 0 0 1 1h1c.275 0 .523 -.11 .704 -.29m.296 -3.71v-7a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1v4", "key": "svg-4" }], ["path", { "d": "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1", "key": "svg-5" }], ["path", { "d": "M22 12h-1", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBarbell = createVueComponent("outline", "barbell", "Barbell", [["path", { "d": "M2 12h1", "key": "svg-0" }], ["path", { "d": "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2", "key": "svg-1" }], ["path", { "d": "M6 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z", "key": "svg-2" }], ["path", { "d": "M9 12h6", "key": "svg-3" }], ["path", { "d": "M15 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z", "key": "svg-4" }], ["path", { "d": "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2", "key": "svg-5" }], ["path", { "d": "M22 12h-1", "key": "svg-6" }]]);

var IconBarcodeOff = createVueComponent("outline", "barcode-off", "BarcodeOff", [["path", { "d": "M4 7v-1c0 -.552 .224 -1.052 .586 -1.414", "key": "svg-0" }], ["path", { "d": "M4 17v1a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M16 20h2c.551 0 1.05 -.223 1.412 -.584", "key": "svg-3" }], ["path", { "d": "M5 11h1v2h-1z", "key": "svg-4" }], ["path", { "d": "M10 11v2", "key": "svg-5" }], ["path", { "d": "M15 11v.01", "key": "svg-6" }], ["path", { "d": "M19 11v2", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconBarcode = createVueComponent("outline", "barcode", "Barcode", [["path", { "d": "M4 7v-1a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 17v1a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-1", "key": "svg-3" }], ["path", { "d": "M5 11h1v2h-1z", "key": "svg-4" }], ["path", { "d": "M10 11l0 2", "key": "svg-5" }], ["path", { "d": "M14 11h1v2h-1z", "key": "svg-6" }], ["path", { "d": "M19 11l0 2", "key": "svg-7" }]]);

var IconBarrelOff = createVueComponent("outline", "barrel-off", "BarrelOff", [["path", { "d": "M8 4h8.722a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78a16.35 16.35 0 0 1 -.407 3.609m-.964 3.013l-.066 .158a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.21 .458 -4.42 1.374 -6.63", "key": "svg-0" }], ["path", { "d": "M14 4c.585 2.337 .913 4.674 .985 7.01m-.114 3.86a33.415 33.415 0 0 1 -.871 5.13", "key": "svg-1" }], ["path", { "d": "M10 4a34.42 34.42 0 0 0 -.366 1.632m-.506 3.501a32.126 32.126 0 0 0 -.128 2.867c0 2.667 .333 5.333 1 8", "key": "svg-2" }], ["path", { "d": "M4.5 16h11.5", "key": "svg-3" }], ["path", { "d": "M19.5 8h-7.5m-4 0h-3.5", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBarrel = createVueComponent("outline", "barrel", "Barrel", [["path", { "d": "M7.278 4h9.444a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78c0 2.26 -.479 4.52 -1.437 6.78a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.26 .479 -4.52 1.437 -6.78a2 2 0 0 1 1.841 -1.22z", "key": "svg-0" }], ["path", { "d": "M14 4c.667 2.667 1 5.333 1 8s-.333 5.333 -1 8", "key": "svg-1" }], ["path", { "d": "M10 4c-.667 2.667 -1 5.333 -1 8s.333 5.333 1 8", "key": "svg-2" }], ["path", { "d": "M4.5 16h15", "key": "svg-3" }], ["path", { "d": "M19.5 8h-15", "key": "svg-4" }]]);

var IconBarrierBlockOff = createVueComponent("outline", "barrier-block-off", "BarrierBlockOff", [["path", { "d": "M11 7h8a1 1 0 0 1 1 1v7c0 .27 -.107 .516 -.282 .696", "key": "svg-0" }], ["path", { "d": "M16 16h-11a1 1 0 0 1 -1 -1v-7a1 1 0 0 1 1 -1h2", "key": "svg-1" }], ["path", { "d": "M7 16v4", "key": "svg-2" }], ["path", { "d": "M7.5 16l4.244 -4.244", "key": "svg-3" }], ["path", { "d": "M13.745 9.755l2.755 -2.755", "key": "svg-4" }], ["path", { "d": "M13.5 16l1.249 -1.249", "key": "svg-5" }], ["path", { "d": "M16.741 12.759l3.259 -3.259", "key": "svg-6" }], ["path", { "d": "M4 13.5l4.752 -4.752", "key": "svg-7" }], ["path", { "d": "M17 17v3", "key": "svg-8" }], ["path", { "d": "M5 20h4", "key": "svg-9" }], ["path", { "d": "M15 20h4", "key": "svg-10" }], ["path", { "d": "M17 7v-2", "key": "svg-11" }], ["path", { "d": "M3 3l18 18", "key": "svg-12" }]]);

var IconBarrierBlock = createVueComponent("outline", "barrier-block", "BarrierBlock", [["path", { "d": "M4 7m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v7a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 16v4", "key": "svg-1" }], ["path", { "d": "M7.5 16l9 -9", "key": "svg-2" }], ["path", { "d": "M13.5 16l6.5 -6.5", "key": "svg-3" }], ["path", { "d": "M4 13.5l6.5 -6.5", "key": "svg-4" }], ["path", { "d": "M17 16v4", "key": "svg-5" }], ["path", { "d": "M5 20h4", "key": "svg-6" }], ["path", { "d": "M15 20h4", "key": "svg-7" }], ["path", { "d": "M17 7v-2", "key": "svg-8" }], ["path", { "d": "M7 7v-2", "key": "svg-9" }]]);

var IconBaselineDensityLarge = createVueComponent("outline", "baseline-density-large", "BaselineDensityLarge", [["path", { "d": "M4 4h16", "key": "svg-0" }], ["path", { "d": "M4 20h16", "key": "svg-1" }]]);

var IconBaselineDensityMedium = createVueComponent("outline", "baseline-density-medium", "BaselineDensityMedium", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M4 12h16", "key": "svg-1" }], ["path", { "d": "M4 4h16", "key": "svg-2" }]]);

var IconBaselineDensitySmall = createVueComponent("outline", "baseline-density-small", "BaselineDensitySmall", [["path", { "d": "M4 3h16", "key": "svg-0" }], ["path", { "d": "M4 9h16", "key": "svg-1" }], ["path", { "d": "M4 15h16", "key": "svg-2" }], ["path", { "d": "M4 21h16", "key": "svg-3" }]]);

var IconBaseline = createVueComponent("outline", "baseline", "Baseline", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M8 16v-8a4 4 0 1 1 8 0v8", "key": "svg-1" }], ["path", { "d": "M8 10h8", "key": "svg-2" }]]);

var IconBasketBolt = createVueComponent("outline", "basket-bolt", "BasketBolt", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13 20h-5.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.358 2.04", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-4" }]]);

var IconBasketCancel = createVueComponent("outline", "basket-cancel", "BasketCancel", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.3 1.713", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M17 21l4 -4", "key": "svg-5" }]]);

var IconBasketCheck = createVueComponent("outline", "basket-check", "BasketCheck", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M11 20h-3.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.479 2.729", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-4" }]]);

var IconBasketCode = createVueComponent("outline", "basket-code", "BasketCode", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M11 20h-3.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304c-.21 1.202 -.37 2.104 -.475 2.705", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-5" }]]);

var IconBasketCog = createVueComponent("outline", "basket-cog", "BasketCog", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.267 1.522", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconBasketDiscount = createVueComponent("outline", "basket-discount", "BasketDiscount", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12.5 20h-5.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.394 2.248", "key": "svg-2" }], ["path", { "d": "M13.856 13.254a2 2 0 1 0 -1.856 2.746", "key": "svg-3" }], ["path", { "d": "M16 21l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21v.01", "key": "svg-5" }], ["path", { "d": "M16 16v.01", "key": "svg-6" }]]);

var IconBasketDollar = createVueComponent("outline", "basket-dollar", "BasketDollar", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13 20h-5.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconBasketDown = createVueComponent("outline", "basket-down", "BasketDown", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.349 1.989", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-5" }]]);

var IconBasketExclamation = createVueComponent("outline", "basket-exclamation", "BasketExclamation", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M15 20h-7.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.36 2.055", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 16v3", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }]]);

var IconBasketHeart = createVueComponent("outline", "basket-heart", "BasketHeart", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M10.5 20h-3.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.143 .817", "key": "svg-2" }], ["path", { "d": "M12.602 12.092a2 2 0 0 0 -2.233 3.066", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconBasketMinus = createVueComponent("outline", "basket-minus", "BasketMinus", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.833 4.75", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconBasketOff = createVueComponent("outline", "basket-off", "BasketOff", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l.75 -2.252m1.001 -3.002l.249 -.746", "key": "svg-1" }], ["path", { "d": "M12 8h7a2 2 0 0 1 1.977 2.304c-.442 2.516 -.756 4.438 -.977 5.696m-1.01 3.003a2.997 2.997 0 0 1 -2.234 .997h-9.512a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h2.999", "key": "svg-2" }], ["path", { "d": "M12 12a2 2 0 1 0 2 2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBasketPause = createVueComponent("outline", "basket-pause", "BasketPause", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13 20h-5.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.478 2.725", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M17 17v5", "key": "svg-4" }], ["path", { "d": "M21 17v5", "key": "svg-5" }]]);

var IconBasketPin = createVueComponent("outline", "basket-pin", "BasketPin", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.161 .92", "key": "svg-2" }], ["path", { "d": "M13.866 13.28a2 2 0 1 0 -1.866 2.72", "key": "svg-3" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-4" }], ["path", { "d": "M19 18v.01", "key": "svg-5" }]]);

var IconBasketPlus = createVueComponent("outline", "basket-plus", "BasketPlus", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.359 2.043", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconBasketQuestion = createVueComponent("outline", "basket-question", "BasketQuestion", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M15 20h-7.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.161 .918", "key": "svg-2" }], ["path", { "d": "M12 16a2 2 0 1 0 0 -4a2 2 0 0 0 0 4z", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-5" }]]);

var IconBasketSearch = createVueComponent("outline", "basket-search", "BasketSearch", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M11 20h-3.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.215 1.227", "key": "svg-2" }], ["path", { "d": "M13.483 12.658a2 2 0 1 0 -2.162 3.224", "key": "svg-3" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-5" }]]);

var IconBasketShare = createVueComponent("outline", "basket-share", "BasketShare", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12.5 20h-5.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.478 2.723", "key": "svg-2" }], ["path", { "d": "M14 14a2 2 0 1 0 -2 2", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconBasketStar = createVueComponent("outline", "basket-star", "BasketStar", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M10.5 20h-3.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.133 .757", "key": "svg-2" }], ["path", { "d": "M13.596 12.794a2 2 0 0 0 -3.377 2.116", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconBasketUp = createVueComponent("outline", "basket-up", "BasketUp", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.358 2.04", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 22v-6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-5" }]]);

var IconBasketX = createVueComponent("outline", "basket-x", "BasketX", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13.5 20h-6.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.532 3.03", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconBasket = createVueComponent("outline", "basket", "Basket", [["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M5.001 8h13.999a2 2 0 0 1 1.977 2.304l-1.255 7.152a3 3 0 0 1 -2.966 2.544h-9.512a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304z", "key": "svg-1" }], ["path", { "d": "M17 10l-2 -6", "key": "svg-2" }], ["path", { "d": "M7 10l2 -6", "key": "svg-3" }]]);

var IconBat = createVueComponent("outline", "bat", "Bat", [["path", { "d": "M17 16c.74 -2.286 2.778 -3.762 5 -3c-.173 -2.595 .13 -5.314 -2 -7.5c-1.708 2.648 -3.358 2.557 -5 2.5v-4l-3 2l-3 -2v4c-1.642 .057 -3.292 .148 -5 -2.5c-2.13 2.186 -1.827 4.905 -2 7.5c2.222 -.762 4.26 .714 5 3c2.593 0 3.889 .952 5 4c1.111 -3.048 2.407 -4 5 -4z", "key": "svg-0" }], ["path", { "d": "M9 8a3 3 0 0 0 6 0", "key": "svg-1" }]]);

var IconBathOff = createVueComponent("outline", "bath-off", "BathOff", [["path", { "d": "M16 12h4a1 1 0 0 1 1 1v3c0 .311 -.036 .614 -.103 .904m-1.61 2.378a3.982 3.982 0 0 1 -2.287 .718h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1h8", "key": "svg-0" }], ["path", { "d": "M6 12v-6m1.178 -2.824c.252 -.113 .53 -.176 .822 -.176h3v2.25", "key": "svg-1" }], ["path", { "d": "M4 21l1 -1.5", "key": "svg-2" }], ["path", { "d": "M20 21l-1 -1.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBath = createVueComponent("outline", "bath", "Bath", [["path", { "d": "M4 12h16a1 1 0 0 1 1 1v3a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M6 12v-7a2 2 0 0 1 2 -2h3v2.25", "key": "svg-1" }], ["path", { "d": "M4 21l1 -1.5", "key": "svg-2" }], ["path", { "d": "M20 21l-1 -1.5", "key": "svg-3" }]]);

var IconBattery1 = createVueComponent("outline", "battery-1", "Battery1", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }]]);

var IconBattery2 = createVueComponent("outline", "battery-2", "Battery2", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }], ["path", { "d": "M10 10l0 4", "key": "svg-2" }]]);

var IconBattery3 = createVueComponent("outline", "battery-3", "Battery3", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }], ["path", { "d": "M10 10l0 4", "key": "svg-2" }], ["path", { "d": "M13 10l0 4", "key": "svg-3" }]]);

var IconBattery4 = createVueComponent("outline", "battery-4", "Battery4", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }], ["path", { "d": "M10 10l0 4", "key": "svg-2" }], ["path", { "d": "M13 10l0 4", "key": "svg-3" }], ["path", { "d": "M16 10l0 4", "key": "svg-4" }]]);

var IconBatteryAutomotive = createVueComponent("outline", "battery-automotive", "BatteryAutomotive", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 5v-2", "key": "svg-1" }], ["path", { "d": "M18 3v2", "key": "svg-2" }], ["path", { "d": "M6.5 12h3", "key": "svg-3" }], ["path", { "d": "M14.5 12h3", "key": "svg-4" }], ["path", { "d": "M16 10.5v3", "key": "svg-5" }]]);

var IconBatteryCharging2 = createVueComponent("outline", "battery-charging-2", "BatteryCharging2", [["path", { "d": "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-4.5", "key": "svg-0" }], ["path", { "d": "M3 15h6v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2v-2z", "key": "svg-1" }], ["path", { "d": "M6 22v-3", "key": "svg-2" }], ["path", { "d": "M4 15v-2.5", "key": "svg-3" }], ["path", { "d": "M8 15v-2.5", "key": "svg-4" }]]);

var IconBatteryCharging = createVueComponent("outline", "battery-charging", "BatteryCharging", [["path", { "d": "M16 7h1a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-2", "key": "svg-0" }], ["path", { "d": "M8 7h-2a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1", "key": "svg-1" }], ["path", { "d": "M12 8l-2 4h3l-2 4", "key": "svg-2" }]]);

var IconBatteryEco = createVueComponent("outline", "battery-eco", "BatteryEco", [["path", { "d": "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-5.5", "key": "svg-0" }], ["path", { "d": "M3 16.143c0 -2.84 2.09 -5.143 4.667 -5.143h2.333v.857c0 2.84 -2.09 5.143 -4.667 5.143h-2.333v-.857z", "key": "svg-1" }], ["path", { "d": "M3 20v-3", "key": "svg-2" }]]);

var IconBatteryExclamation = createVueComponent("outline", "battery-exclamation", "BatteryExclamation", [["path", { "d": "M9 17h8c1.105 0 2 -.895 2 -2v-.5c0 -.276 .224 -.5 .5 -.5s.5 -.224 .5 -.5v-3c0 -.276 -.224 -.5 -.5 -.5s-.5 -.224 -.5 -.5v-.5c0 -1.105 -.895 -2 -2 -2h-11c-1.105 0 -2 .895 -2 2v3", "key": "svg-0" }], ["path", { "d": "M5 16v3", "key": "svg-1" }], ["path", { "d": "M5 22v.01", "key": "svg-2" }]]);

var IconBatteryOff = createVueComponent("outline", "battery-off", "BatteryOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M11 7h6a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5m-2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h1", "key": "svg-1" }]]);

var IconBatterySpark = createVueComponent("outline", "battery-spark", "BatterySpark", [["path", { "d": "M12 17h-6a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v1", "key": "svg-0" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-1" }]]);

var IconBatteryVertical1 = createVueComponent("outline", "battery-vertical-1", "BatteryVertical1", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }]]);

var IconBatteryVertical2 = createVueComponent("outline", "battery-vertical-2", "BatteryVertical2", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }]]);

var IconBatteryVertical3 = createVueComponent("outline", "battery-vertical-3", "BatteryVertical3", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M10 11h4", "key": "svg-3" }]]);

var IconBatteryVertical4 = createVueComponent("outline", "battery-vertical-4", "BatteryVertical4", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M10 11h4", "key": "svg-3" }], ["path", { "d": "M10 8h4", "key": "svg-4" }]]);

var IconBatteryVerticalCharging2 = createVueComponent("outline", "battery-vertical-charging-2", "BatteryVerticalCharging2", [["path", { "d": "M7 18v-11c0 -1.105 .895 -2 2 -2h.5c.276 0 .5 -.224 .5 -.5s.224 -.5 .5 -.5h3c.276 0 .5 .224 .5 .5s.224 .5 .5 .5h.5c1.105 0 2 .895 2 2v1m-10 10c0 1.105 .895 2 2 2h1", "key": "svg-0" }], ["path", { "d": "M12 14h6v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M15 21v-3", "key": "svg-2" }], ["path", { "d": "M13 14v-2.5", "key": "svg-3" }], ["path", { "d": "M17 14v-2.5", "key": "svg-4" }]]);

var IconBatteryVerticalCharging = createVueComponent("outline", "battery-vertical-charging", "BatteryVerticalCharging", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M12.667 8l-2.667 4h4l-2.667 4", "key": "svg-1" }]]);

var IconBatteryVerticalEco = createVueComponent("outline", "battery-vertical-eco", "BatteryVerticalEco", [["path", { "d": "M7 18v-11c0 -1.105 .895 -2 2 -2h.5c.276 0 .5 -.224 .5 -.5s.224 -.5 .5 -.5h3c.276 0 .5 .224 .5 .5s.224 .5 .5 .5h.5c1.105 0 2 .895 2 2v1m-8 12c-1.105 0 -2 -.895 -2 -2", "key": "svg-0" }], ["path", { "d": "M13 17.143c0 -2.84 2.09 -5.143 4.667 -5.143h2.333v.857c0 2.84 -2.09 5.143 -4.667 5.143h-2.333z", "key": "svg-1" }], ["path", { "d": "M13 21v-3", "key": "svg-2" }]]);

var IconBatteryVerticalExclamation = createVueComponent("outline", "battery-vertical-exclamation", "BatteryVerticalExclamation", [["path", { "d": "M17 12v-5c0 -1.105 -.895 -2 -2 -2h-.5c-.276 0 -.5 -.224 -.5 -.5s-.224 -.5 -.5 -.5h-3c-.276 0 -.5 .224 -.5 .5s-.224 .5 -.5 .5h-.5c-1.105 0 -2 .895 -2 2v11c0 1.105 .895 2 2 2h6", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconBatteryVerticalOff = createVueComponent("outline", "battery-vertical-off", "BatteryVerticalOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M17 13v-6a2 2 0 0 0 -2 -2h-.5a.5 .5 0 0 1 -.5 -.5a.5 .5 0 0 0 -.5 -.5h-3a.5 .5 0 0 0 -.5 .5a.5 .5 0 0 1 -.5 .5h-.5m-2 2v11a2 2 0 0 0 2 2h6a2 2 0 0 0 2 -2v-1", "key": "svg-1" }]]);

var IconBatteryVertical = createVueComponent("outline", "battery-vertical", "BatteryVertical", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }]]);

var IconBattery = createVueComponent("outline", "battery", "Battery", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }]]);

var IconBeachOff = createVueComponent("outline", "beach-off", "BeachOff", [["path", { "d": "M15.071 15.102a7.502 7.502 0 0 0 -8.124 1.648", "key": "svg-0" }], ["path", { "d": "M10.27 6.269l9.926 5.731a6 6 0 0 0 -10.32 -6.123", "key": "svg-1" }], ["path", { "d": "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196", "key": "svg-2" }], ["path", { "d": "M15 9l-.739 1.279", "key": "svg-3" }], ["path", { "d": "M12.794 12.82l-.794 1.376", "key": "svg-4" }], ["path", { "d": "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1.135 -.858", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconBeach = createVueComponent("outline", "beach", "Beach", [["path", { "d": "M17.553 16.75a7.5 7.5 0 0 0 -10.606 0", "key": "svg-0" }], ["path", { "d": "M18 3.804a6 6 0 0 0 -8.196 2.196l10.392 6a6 6 0 0 0 -2.196 -8.196z", "key": "svg-1" }], ["path", { "d": "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196", "key": "svg-2" }], ["path", { "d": "M15 9l-3 5.196", "key": "svg-3" }], ["path", { "d": "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 1 .25", "key": "svg-4" }]]);

var IconBedFlat = createVueComponent("outline", "bed-flat", "BedFlat", [["path", { "d": "M5 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M10 13h11v-2a3 3 0 0 0 -3 -3h-8v5z", "key": "svg-1" }], ["path", { "d": "M3 16h18", "key": "svg-2" }]]);

var IconBedOff = createVueComponent("outline", "bed-off", "BedOff", [["path", { "d": "M7 7a2 2 0 1 0 2 2", "key": "svg-0" }], ["path", { "d": "M22 17v-3h-4m-4 0h-12", "key": "svg-1" }], ["path", { "d": "M2 8v9", "key": "svg-2" }], ["path", { "d": "M12 12v2h2m4 0h4v-2a3 3 0 0 0 -3 -3h-6", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBed = createVueComponent("outline", "bed", "Bed", [["path", { "d": "M7 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M22 17v-3h-20", "key": "svg-1" }], ["path", { "d": "M2 8v9", "key": "svg-2" }], ["path", { "d": "M12 14h10v-2a3 3 0 0 0 -3 -3h-7v5z", "key": "svg-3" }]]);

var IconBeerOff = createVueComponent("outline", "beer-off", "BeerOff", [["path", { "d": "M7 7v1.111c0 1.242 .29 2.467 .845 3.578l.31 .622a8 8 0 0 1 .845 3.578v4.111h6v-4.111a8 8 0 0 1 .045 -.85m.953 -3.035l.157 -.315a8 8 0 0 0 .845 -3.578v-4.111h-9", "key": "svg-0" }], ["path", { "d": "M7 8h1m4 0h5", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBeer = createVueComponent("outline", "beer", "Beer", [["path", { "d": "M9 21h6a1 1 0 0 0 1 -1v-3.625c0 -1.397 .29 -2.775 .845 -4.025l.31 -.7c.556 -1.25 .845 -2.253 .845 -3.65v-4a1 1 0 0 0 -1 -1h-10a1 1 0 0 0 -1 1v4c0 1.397 .29 2.4 .845 3.65l.31 .7a9.931 9.931 0 0 1 .845 4.025v3.625a1 1 0 0 0 1 1z", "key": "svg-0" }], ["path", { "d": "M6 8h12", "key": "svg-1" }]]);

var IconBellBolt = createVueComponent("outline", "bell-bolt", "BellBolt", [["path", { "d": "M13.5 17h-9.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.368 2.67", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconBellCancel = createVueComponent("outline", "bell-cancel", "BellCancel", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconBellCheck = createVueComponent("outline", "bell-check", "BellCheck", [["path", { "d": "M11.5 17h-7.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3c.016 .129 .037 .256 .065 .382", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.502 2.959", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconBellCode = createVueComponent("outline", "bell-code", "BellCode", [["path", { "d": "M11.5 17h-7.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.498 2.958", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconBellCog = createVueComponent("outline", "bell-cog", "BellCog", [["path", { "d": "M12 17h-8a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v.5", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3 3", "key": "svg-8" }]]);

var IconBellDollar = createVueComponent("outline", "bell-dollar", "BellDollar", [["path", { "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 3.911 5.17", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.02 2.822", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconBellDown = createVueComponent("outline", "bell-down", "BellDown", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.518 2.955", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconBellExclamation = createVueComponent("outline", "bell-exclamation", "BellExclamation", [["path", { "d": "M15 17h-11a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1.5", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconBellHeart = createVueComponent("outline", "bell-heart", "BellHeart", [["path", { "d": "M10 17h-6a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1c0 1.408 .97 2.59 2.28 2.913", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconBellMinus = createVueComponent("outline", "bell-minus", "BellMinus", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3c.047 .386 .149 .758 .3 1.107", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.504 2.958", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconBellOff = createVueComponent("outline", "bell-off", "BellOff", [["path", { "d": "M9.346 5.353c.21 -.129 .428 -.246 .654 -.353a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3m-1 3h-13a4 4 0 0 0 2 -3v-3a6.996 6.996 0 0 1 1.273 -3.707", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBellPause = createVueComponent("outline", "bell-pause", "BellPause", [["path", { "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.022 2.821", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconBellPin = createVueComponent("outline", "bell-pin", "BellPin", [["path", { "d": "M12 17h-8a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.64 2.931", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconBellPlus = createVueComponent("outline", "bell-plus", "BellPlus", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.51 2.957", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconBellQuestion = createVueComponent("outline", "bell-question", "BellQuestion", [["path", { "d": "M13.5 17h-9.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 5.914 .716", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconBellRinging2 = createVueComponent("outline", "bell-ringing-2", "BellRinging2", [["path", { "d": "M19.364 4.636a2 2 0 0 1 0 2.828a7 7 0 0 1 -1.414 7.072l-2.122 2.12a4 4 0 0 0 -.707 3.536l-11.313 -11.312a4 4 0 0 0 3.535 -.707l2.121 -2.123a7 7 0 0 1 7.072 -1.414a2 2 0 0 1 2.828 0z", "key": "svg-0" }], ["path", { "d": "M7.343 12.414l-.707 .707a3 3 0 0 0 4.243 4.243l.707 -.707", "key": "svg-1" }]]);

var IconBellRinging = createVueComponent("outline", "bell-ringing", "BellRinging", [["path", { "d": "M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M21 6.727a11.05 11.05 0 0 0 -2.794 -3.727", "key": "svg-2" }], ["path", { "d": "M3 6.727a11.05 11.05 0 0 1 2.792 -3.727", "key": "svg-3" }]]);

var IconBellSchool = createVueComponent("outline", "bell-school", "BellSchool", [["path", { "d": "M10 10m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M13.5 15h.5a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-1a2 2 0 0 1 2 -2h.5", "key": "svg-1" }], ["path", { "d": "M16 17a5.698 5.698 0 0 0 4.467 -7.932l-.467 -1.068", "key": "svg-2" }], ["path", { "d": "M10 10v.01", "key": "svg-3" }], ["path", { "d": "M20 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconBellSearch = createVueComponent("outline", "bell-search", "BellSearch", [["path", { "d": "M11 17h-7a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.685 2.984", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconBellShare = createVueComponent("outline", "bell-share", "BellShare", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconBellStar = createVueComponent("outline", "bell-star", "BellStar", [["path", { "d": "M9.5 17h-5.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 3.88 5", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.15 2.878", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconBellUp = createVueComponent("outline", "bell-up", "BellUp", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.49 2.96", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconBellX = createVueComponent("outline", "bell-x", "BellX", [["path", { "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.194 2.753", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconBellZ = createVueComponent("outline", "bell-z", "BellZ", [["path", { "d": "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M10 9h4l-4 4h4", "key": "svg-2" }]]);

var IconBell = createVueComponent("outline", "bell", "Bell", [["path", { "d": "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }]]);

var IconBeta = createVueComponent("outline", "beta", "Beta", [["path", { "d": "M8 22v-14a4 4 0 0 1 4 -4h.5a3.5 3.5 0 0 1 0 7h-.5h.5a4.5 4.5 0 1 1 -4.5 4.5v-.5", "key": "svg-0" }]]);

var IconBible = createVueComponent("outline", "bible", "Bible", [["path", { "d": "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z", "key": "svg-0" }], ["path", { "d": "M19 16h-12a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M12 7v6", "key": "svg-2" }], ["path", { "d": "M10 9h4", "key": "svg-3" }]]);

var IconBikeOff = createVueComponent("outline", "bike-off", "BikeOff", [["path", { "d": "M5 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M16.437 16.44a3 3 0 0 0 4.123 4.123m1.44 -2.563a3 3 0 0 0 -3 -3", "key": "svg-1" }], ["path", { "d": "M12 19v-4l-3 -3l1.665 -1.332m2.215 -1.772l1.12 -.896l2 3h3", "key": "svg-2" }], ["path", { "d": "M17 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBike = createVueComponent("outline", "bike", "Bike", [["path", { "d": "M5 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M19 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M12 19l0 -4l-3 -3l5 -4l2 3l3 0", "key": "svg-2" }], ["path", { "d": "M17 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }]]);

var IconBinaryOff = createVueComponent("outline", "binary-off", "BinaryOff", [["path", { "d": "M11 7v-2h-1", "key": "svg-0" }], ["path", { "d": "M18 19v-1", "key": "svg-1" }], ["path", { "d": "M15.5 5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5v-4a.5 .5 0 0 1 .5 -.5z", "key": "svg-2" }], ["path", { "d": "M10.5 14h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5v-4a.5 .5 0 0 1 .5 -.5z", "key": "svg-3" }], ["path", { "d": "M6 10v.01", "key": "svg-4" }], ["path", { "d": "M6 19v.01", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconBinaryTree2 = createVueComponent("outline", "binary-tree-2", "BinaryTree2", [["path", { "d": "M14 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-0" }], ["path", { "d": "M7 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-1" }], ["path", { "d": "M21 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-2" }], ["path", { "d": "M14 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-3" }], ["path", { "d": "M12 8v8", "key": "svg-4" }], ["path", { "d": "M6.316 12.496l4.368 -4.992", "key": "svg-5" }], ["path", { "d": "M17.684 12.496l-4.366 -4.99", "key": "svg-6" }]]);

var IconBinaryTree = createVueComponent("outline", "binary-tree", "BinaryTree", [["path", { "d": "M6 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-0" }], ["path", { "d": "M16 4a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-1" }], ["path", { "d": "M16 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-2" }], ["path", { "d": "M11 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-3" }], ["path", { "d": "M21 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-4" }], ["path", { "d": "M5.058 18.306l2.88 -4.606", "key": "svg-5" }], ["path", { "d": "M10.061 10.303l2.877 -4.604", "key": "svg-6" }], ["path", { "d": "M10.065 13.705l2.876 4.6", "key": "svg-7" }], ["path", { "d": "M15.063 5.7l2.881 4.61", "key": "svg-8" }]]);

var IconBinary = createVueComponent("outline", "binary", "Binary", [["path", { "d": "M11 10v-5h-1m8 14v-5h-1", "key": "svg-0" }], ["path", { "d": "M15 5m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z", "key": "svg-1" }], ["path", { "d": "M10 14m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z", "key": "svg-2" }], ["path", { "d": "M6 10h.01m-.01 9h.01", "key": "svg-3" }]]);

var IconBinoculars = createVueComponent("outline", "binoculars", "Binoculars", [["path", { "d": "M7 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M16.346 9.17l-.729 -1.261c-.16 -.248 -1.056 -.203 -1.117 .091l-.177 1.38", "key": "svg-2" }], ["path", { "d": "M19.761 14.813l-2.84 -5.133c-.189 -.31 -.592 -.68 -1.421 -.68c-.828 0 -1.5 .448 -1.5 1v6", "key": "svg-3" }], ["path", { "d": "M7.654 9.17l.729 -1.261c.16 -.249 1.056 -.203 1.117 .091l.177 1.38", "key": "svg-4" }], ["path", { "d": "M4.239 14.813l2.84 -5.133c.189 -.31 .592 -.68 1.421 -.68c.828 0 1.5 .448 1.5 1v6", "key": "svg-5" }], ["rect", { "width": "4", "height": "2", "x": "10", "y": "12", "key": "svg-6" }]]);

var IconBiohazardOff = createVueComponent("outline", "biohazard-off", "BiohazardOff", [["path", { "d": "M10.586 10.586a2 2 0 1 0 2.836 2.82", "key": "svg-0" }], ["path", { "d": "M11.939 14c0 .173 .048 .351 .056 .533v.217a4.75 4.75 0 0 1 -4.533 4.745h-.217", "key": "svg-1" }], ["path", { "d": "M2.495 14.745a4.75 4.75 0 0 1 7.737 -3.693", "key": "svg-2" }], ["path", { "d": "M16.745 19.495a4.75 4.75 0 0 1 -4.69 -5.503h-.06", "key": "svg-3" }], ["path", { "d": "M14.533 10.538a4.75 4.75 0 0 1 6.957 3.987v.217", "key": "svg-4" }], ["path", { "d": "M10.295 10.929a4.75 4.75 0 0 1 -2.988 -3.64m.66 -3.324a4.75 4.75 0 0 1 .5 -.66l.164 -.172", "key": "svg-5" }], ["path", { "d": "M15.349 3.133a4.75 4.75 0 0 1 -.836 7.385", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBiohazard = createVueComponent("outline", "biohazard", "Biohazard", [["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11.939 14c0 .173 .048 .351 .056 .533l0 .217a4.75 4.75 0 0 1 -4.533 4.745l-.217 0m-4.75 -4.75a4.75 4.75 0 0 1 7.737 -3.693m6.513 8.443a4.75 4.75 0 0 1 -4.69 -5.503l-.06 0m1.764 -2.944a4.75 4.75 0 0 1 7.731 3.477l0 .217m-11.195 -3.813a4.75 4.75 0 0 1 -1.828 -7.624l.164 -.172m6.718 0a4.75 4.75 0 0 1 -1.665 7.798", "key": "svg-1" }]]);

var IconBlade = createVueComponent("outline", "blade", "Blade", [["path", { "d": "M17.707 3.707l2.586 2.586a1 1 0 0 1 0 1.414l-.586 .586a1 1 0 0 0 0 1.414l.586 .586a1 1 0 0 1 0 1.414l-8.586 8.586a1 1 0 0 1 -1.414 0l-.586 -.586a1 1 0 0 0 -1.414 0l-.586 .586a1 1 0 0 1 -1.414 0l-2.586 -2.586a1 1 0 0 1 0 -1.414l.586 -.586a1 1 0 0 0 0 -1.414l-.586 -.586a1 1 0 0 1 0 -1.414l8.586 -8.586a1 1 0 0 1 1.414 0l.586 .586a1 1 0 0 0 1.414 0l.586 -.586a1 1 0 0 1 1.414 0z", "key": "svg-0" }], ["path", { "d": "M8 16l3.2 -3.2", "key": "svg-1" }], ["path", { "d": "M12.8 11.2l3.2 -3.2", "key": "svg-2" }], ["path", { "d": "M14 8l2 2", "key": "svg-3" }], ["path", { "d": "M8 14l2 2", "key": "svg-4" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }]]);

var IconBleachChlorine = createVueComponent("outline", "bleach-chlorine", "BleachChlorine", [["path", { "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75", "key": "svg-0" }], ["path", { "d": "M11 12h-1a2 2 0 1 0 0 4h1", "key": "svg-1" }], ["path", { "d": "M14 12v4h2", "key": "svg-2" }]]);

var IconBleachNoChlorine = createVueComponent("outline", "bleach-no-chlorine", "BleachNoChlorine", [["path", { "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75", "key": "svg-0" }], ["path", { "d": "M6.576 19l7.907 -13.733", "key": "svg-1" }], ["path", { "d": "M11.719 19.014l5.346 -9.284", "key": "svg-2" }]]);

var IconBleachOff = createVueComponent("outline", "bleach-off", "BleachOff", [["path", { "d": "M5 19h14m1.986 -1.977a2 2 0 0 0 -.146 -.773l-7.1 -12.25a2 2 0 0 0 -3.5 0l-.815 1.405m-1.488 2.568l-4.797 8.277a2 2 0 0 0 1.75 2.75", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBleach = createVueComponent("outline", "bleach", "Bleach", [["path", { "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75", "key": "svg-0" }]]);

var IconBlendMode = createVueComponent("outline", "blend-mode", "BlendMode", [["path", { "d": "M14.5 9.5m-6.5 0a6.5 6.5 0 1 0 13 0a6.5 6.5 0 1 0 -13 0", "key": "svg-0" }], ["path", { "d": "M9.5 14.5m-6.5 0a6.5 6.5 0 1 0 13 0a6.5 6.5 0 1 0 -13 0", "key": "svg-1" }]]);

var IconBlender = createVueComponent("outline", "blender", "Blender", [["path", { "d": "M9 10h-3a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h10.802a1 1 0 0 1 .984 1.179l-1.786 9.821", "key": "svg-0" }], ["path", { "d": "M8 4l2 11", "key": "svg-1" }], ["path", { "d": "M11 15h4a3 3 0 0 1 3 3v2a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-2a3 3 0 0 1 3 -3z", "key": "svg-2" }], ["path", { "d": "M12 4v-1h2v1", "key": "svg-3" }], ["path", { "d": "M13 18v.01", "key": "svg-4" }]]);

var IconBlob = createVueComponent("outline", "blob", "Blob", [["path", { "d": "M5.897 20.188c1.67 .752 3.896 .812 6.103 .812s4.434 -.059 6.104 -.812c.868 -.392 1.614 -.982 2.133 -1.856c.514 -.865 .763 -1.94 .763 -3.234c0 -2.577 -.983 -5.315 -2.557 -7.416c-1.57 -2.094 -3.833 -3.682 -6.443 -3.682s-4.873 1.588 -6.443 3.682c-1.574 2.101 -2.557 4.84 -2.557 7.416c0 1.295 .249 2.369 .763 3.234c.519 .874 1.265 1.464 2.134 1.856", "key": "svg-0" }]]);

var IconBlockquote = createVueComponent("outline", "blockquote", "Blockquote", [["path", { "d": "M6 15h15", "key": "svg-0" }], ["path", { "d": "M21 19h-15", "key": "svg-1" }], ["path", { "d": "M15 11h6", "key": "svg-2" }], ["path", { "d": "M21 7h-6", "key": "svg-3" }], ["path", { "d": "M9 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2", "key": "svg-4" }], ["path", { "d": "M3 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2", "key": "svg-5" }]]);

var IconBlocks = createVueComponent("outline", "blocks", "Blocks", [["path", { "d": "M14 4a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M3 14h12a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h3a2 2 0 0 1 2 2v12", "key": "svg-1" }]]);

var IconBluetoothConnected = createVueComponent("outline", "bluetooth-connected", "BluetoothConnected", [["path", { "d": "M7 8l10 8l-5 4l0 -16l5 4l-10 8", "key": "svg-0" }], ["path", { "d": "M4 12l1 0", "key": "svg-1" }], ["path", { "d": "M18 12l1 0", "key": "svg-2" }]]);

var IconBluetoothOff = createVueComponent("outline", "bluetooth-off", "BluetoothOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M16.438 16.45l-4.438 3.55v-8m0 -4v-4l5 4l-2.776 2.22m-2.222 1.779l-5 4", "key": "svg-1" }]]);

var IconBluetoothX = createVueComponent("outline", "bluetooth-x", "BluetoothX", [["path", { "d": "M7 8l10 8l-5 4v-16l1 .802m0 6.396l-6 4.802", "key": "svg-0" }], ["path", { "d": "M16 6l4 4", "key": "svg-1" }], ["path", { "d": "M20 6l-4 4", "key": "svg-2" }]]);

var IconBluetooth = createVueComponent("outline", "bluetooth", "Bluetooth", [["path", { "d": "M7 8l10 8l-5 4l0 -16l5 4l-10 8", "key": "svg-0" }]]);

var IconBlurOff = createVueComponent("outline", "blur-off", "BlurOff", [["path", { "d": "M12 3v5m0 4v8", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M16 12h5", "key": "svg-2" }], ["path", { "d": "M13 9h7", "key": "svg-3" }], ["path", { "d": "M12 6h6", "key": "svg-4" }], ["path", { "d": "M12 18h6", "key": "svg-5" }], ["path", { "d": "M12 15h3m4 0h1", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBlur = createVueComponent("outline", "blur", "Blur", [["path", { "d": "M12 21a9.01 9.01 0 0 0 2.32 -.302a9 9 0 0 0 1.74 -16.733a9 9 0 1 0 -4.06 17.035z", "key": "svg-0" }], ["path", { "d": "M12 3v17", "key": "svg-1" }], ["path", { "d": "M12 12h9", "key": "svg-2" }], ["path", { "d": "M12 9h8", "key": "svg-3" }], ["path", { "d": "M12 6h6", "key": "svg-4" }], ["path", { "d": "M12 18h6", "key": "svg-5" }], ["path", { "d": "M12 15h8", "key": "svg-6" }]]);

var IconBmp = createVueComponent("outline", "bmp", "Bmp", [["path", { "d": "M18 16v-8h2a2 2 0 1 1 0 4h-2", "key": "svg-0" }], ["path", { "d": "M6 14a2 2 0 0 1 -2 2h-2v-8h2a2 2 0 1 1 0 4h-2h2a2 2 0 0 1 2 2z", "key": "svg-1" }], ["path", { "d": "M9 16v-8l3 6l3 -6v8", "key": "svg-2" }]]);

var IconBodyScan = createVueComponent("outline", "body-scan", "BodyScan", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M12 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M10 17v-1a2 2 0 1 1 4 0v1", "key": "svg-5" }], ["path", { "d": "M8 10c.666 .666 1.334 1 2 1h4c.666 0 1.334 -.334 2 -1", "key": "svg-6" }], ["path", { "d": "M12 11v3", "key": "svg-7" }]]);

var IconBoldOff = createVueComponent("outline", "bold-off", "BoldOff", [["path", { "d": "M9 5h4a3.5 3.5 0 0 1 2.222 6.204m-3.222 .796h-5v-5", "key": "svg-0" }], ["path", { "d": "M17.107 17.112a3.5 3.5 0 0 1 -3.107 1.888h-7v-7", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBold = createVueComponent("outline", "bold", "Bold", [["path", { "d": "M7 5h6a3.5 3.5 0 0 1 0 7h-6z", "key": "svg-0" }], ["path", { "d": "M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7", "key": "svg-1" }]]);

var IconBoltOff = createVueComponent("outline", "bolt-off", "BoltOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M15.212 15.21l-4.212 5.79v-7h-6l3.79 -5.21m1.685 -2.32l2.525 -3.47v6m1 1h5l-2.104 2.893", "key": "svg-1" }]]);

var IconBolt = createVueComponent("outline", "bolt", "Bolt", [["path", { "d": "M13 3l0 7l6 0l-8 11l0 -7l-6 0l8 -11", "key": "svg-0" }]]);

var IconBomb = createVueComponent("outline", "bomb", "Bomb", [["path", { "d": "M15.349 5.349l3.301 3.301a1.2 1.2 0 0 1 0 1.698l-.972 .972a7.5 7.5 0 1 1 -5 -5l.972 -.972a1.2 1.2 0 0 1 1.698 0z", "key": "svg-0" }], ["path", { "d": "M17 7l1.293 -1.293a2.414 2.414 0 0 0 .707 -1.707a1 1 0 0 1 1 -1h1", "key": "svg-1" }], ["path", { "d": "M7 13a3 3 0 0 1 3 -3", "key": "svg-2" }]]);

var IconBoneOff = createVueComponent("outline", "bone-off", "BoneOff", [["path", { "d": "M12.5 8.502l.38 -.38a3 3 0 1 1 5.12 -2.122a3 3 0 1 1 -2.12 5.122l-.372 .372m-2.008 2.008l-2.378 2.378a3 3 0 1 1 -5.117 2.297l0 -.177l-.176 0a3 3 0 1 1 2.298 -5.115l2.378 -2.378", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBone = createVueComponent("outline", "bone", "Bone", [["path", { "d": "M15 3a3 3 0 0 1 3 3a3 3 0 1 1 -2.12 5.122l-4.758 4.758a3 3 0 1 1 -5.117 2.297l0 -.177l-.176 0a3 3 0 1 1 2.298 -5.115l4.758 -4.758a3 3 0 0 1 2.12 -5.122z", "key": "svg-0" }]]);

var IconBongOff = createVueComponent("outline", "bong-off", "BongOff", [["path", { "d": "M9 5v-2h4v6m1.5 1.5l2.5 -2.5l2 2l-2.5 2.5m-.5 3.505a5 5 0 1 1 -7 -4.589v-2.416", "key": "svg-0" }], ["path", { "d": "M8 3h6", "key": "svg-1" }], ["path", { "d": "M6.1 17h9.8", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBong = createVueComponent("outline", "bong", "Bong", [["path", { "d": "M13 3v8.416c.134 .059 .265 .123 .393 .193l3.607 -3.609l2 2l-3.608 3.608a5 5 0 1 1 -6.392 -2.192v-8.416h4z", "key": "svg-0" }], ["path", { "d": "M8 3h6", "key": "svg-1" }], ["path", { "d": "M6.1 17h9.8", "key": "svg-2" }]]);

var IconBook2 = createVueComponent("outline", "book-2", "Book2", [["path", { "d": "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z", "key": "svg-0" }], ["path", { "d": "M19 16h-12a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M9 8h6", "key": "svg-2" }]]);

var IconBookDownload = createVueComponent("outline", "book-download", "BookDownload", [["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5", "key": "svg-0" }], ["path", { "d": "M13 16h-7a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M15 19l3 3l3 -3", "key": "svg-2" }], ["path", { "d": "M18 22v-9", "key": "svg-3" }]]);

var IconBookOff = createVueComponent("outline", "book-off", "BookOff", [["path", { "d": "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 5.899 -1.096", "key": "svg-0" }], ["path", { "d": "M3 6a9 9 0 0 1 2.114 -.884m3.8 -.21c1.07 .17 2.116 .534 3.086 1.094a9 9 0 0 1 9 0", "key": "svg-1" }], ["path", { "d": "M3 6v13", "key": "svg-2" }], ["path", { "d": "M12 6v2m0 4v7", "key": "svg-3" }], ["path", { "d": "M21 6v11", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBookUpload = createVueComponent("outline", "book-upload", "BookUpload", [["path", { "d": "M14 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5", "key": "svg-0" }], ["path", { "d": "M11 16h-5a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M15 16l3 -3l3 3", "key": "svg-2" }], ["path", { "d": "M18 13v9", "key": "svg-3" }]]);

var IconBook = createVueComponent("outline", "book", "Book", [["path", { "d": "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 9 0", "key": "svg-0" }], ["path", { "d": "M3 6a9 9 0 0 1 9 0a9 9 0 0 1 9 0", "key": "svg-1" }], ["path", { "d": "M3 6l0 13", "key": "svg-2" }], ["path", { "d": "M12 6l0 13", "key": "svg-3" }], ["path", { "d": "M21 6l0 13", "key": "svg-4" }]]);

var IconBookmarkAi = createVueComponent("outline", "bookmark-ai", "BookmarkAi", [["path", { "d": "M10.02 18.32l-4.02 2.68v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v4.5", "key": "svg-0" }], ["path", { "d": "M14 21v-4a2 2 0 1 1 4 0v4", "key": "svg-1" }], ["path", { "d": "M14 19h4", "key": "svg-2" }], ["path", { "d": "M21 15v6", "key": "svg-3" }]]);

var IconBookmarkEdit = createVueComponent("outline", "bookmark-edit", "BookmarkEdit", [["path", { "d": "M12 17l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v4", "key": "svg-0" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 1 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-1" }]]);

var IconBookmarkMinus = createVueComponent("outline", "bookmark-minus", "BookmarkMinus", [["path", { "d": "M12 17l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v8", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconBookmarkOff = createVueComponent("outline", "bookmark-off", "BookmarkOff", [["path", { "d": "M7.708 3.721a3.982 3.982 0 0 1 2.292 -.721h4a4 4 0 0 1 4 4v7m0 4v3l-6 -4l-6 4v-14c0 -.308 .035 -.609 .1 -.897", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBookmarkPlus = createVueComponent("outline", "bookmark-plus", "BookmarkPlus", [["path", { "d": "M12 17l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v5", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconBookmarkQuestion = createVueComponent("outline", "bookmark-question", "BookmarkQuestion", [["path", { "d": "M15 19l-3 -2l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v4", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconBookmark = createVueComponent("outline", "bookmark", "Bookmark", [["path", { "d": "M18 7v14l-6 -4l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4z", "key": "svg-0" }]]);

var IconBookmarksOff = createVueComponent("outline", "bookmarks-off", "BookmarksOff", [["path", { "d": "M11 7h2a2 2 0 0 1 2 2v2m0 4v6l-5 -3l-5 3v-12a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9.265 4a2 2 0 0 1 1.735 -1h6a2 2 0 0 1 2 2v10", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBookmarks = createVueComponent("outline", "bookmarks", "Bookmarks", [["path", { "d": "M15 10v11l-5 -3l-5 3v-11a3 3 0 0 1 3 -3h4a3 3 0 0 1 3 3z", "key": "svg-0" }], ["path", { "d": "M11 3h5a3 3 0 0 1 3 3v11", "key": "svg-1" }]]);

var IconBooksOff = createVueComponent("outline", "books-off", "BooksOff", [["path", { "d": "M9 9v10a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-14", "key": "svg-0" }], ["path", { "d": "M8 4a1 1 0 0 1 1 1", "key": "svg-1" }], ["path", { "d": "M9 5a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4", "key": "svg-2" }], ["path", { "d": "M13 13v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-10", "key": "svg-3" }], ["path", { "d": "M5 8h3", "key": "svg-4" }], ["path", { "d": "M9 16h4", "key": "svg-5" }], ["path", { "d": "M14.254 10.244l-1.218 -4.424a1.02 1.02 0 0 1 .634 -1.219l.133 -.041l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.236 11.75", "key": "svg-6" }], ["path", { "d": "M19.585 19.589l-1.572 .38c-.562 .136 -1.133 -.19 -1.282 -.731l-.952 -3.458", "key": "svg-7" }], ["path", { "d": "M14 9l4 -1", "key": "svg-8" }], ["path", { "d": "M19.207 15.199l.716 -.18", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconBooks = createVueComponent("outline", "books", "Books", [["path", { "d": "M5 4m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M9 4m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M5 8h4", "key": "svg-2" }], ["path", { "d": "M9 16h4", "key": "svg-3" }], ["path", { "d": "M13.803 4.56l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.695 13.418a1.02 1.02 0 0 1 -.634 1.219l-.133 .041l-2.184 .53c-.562 .135 -1.133 -.19 -1.282 -.732l-3.695 -13.418a1.02 1.02 0 0 1 .634 -1.219l.133 -.041z", "key": "svg-4" }], ["path", { "d": "M14 9l4 -1", "key": "svg-5" }], ["path", { "d": "M16 16l3.923 -.98", "key": "svg-6" }]]);

var IconBoom = createVueComponent("outline", "boom", "Boom", [["path", { "d": "M3 9.662c2 2.338 2 4.338 0 6.338c3 .5 4.5 1 5 4c2 -3 6 -4 9 0c0 -3 1 -4 4 -4.004q -3 -2.995 0 -5.996c-3 0 -5 -2 -5 -5c-2 4 -5 3 -7.5 -1c-.5 3 -2.5 5 -5.5 5.662", "key": "svg-0" }]]);

var IconBorderAll = createVueComponent("outline", "border-all", "BorderAll", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M4 12l16 0", "key": "svg-1" }], ["path", { "d": "M12 4l0 16", "key": "svg-2" }]]);

var IconBorderBottomPlus = createVueComponent("outline", "border-bottom-plus", "BorderBottomPlus", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M4 16v-.01", "key": "svg-1" }], ["path", { "d": "M20 16v-.01", "key": "svg-2" }], ["path", { "d": "M4 12v-.01", "key": "svg-3" }], ["path", { "d": "M20 12v-.01", "key": "svg-4" }], ["path", { "d": "M4 8v-.01", "key": "svg-5" }], ["path", { "d": "M20 8v-.01", "key": "svg-6" }], ["path", { "d": "M4 4v-.01", "key": "svg-7" }], ["path", { "d": "M8 4v-.01", "key": "svg-8" }], ["path", { "d": "M12 4v-.01", "key": "svg-9" }], ["path", { "d": "M16 4v-.01", "key": "svg-10" }], ["path", { "d": "M20 4v-.01", "key": "svg-11" }], ["path", { "d": "M15 12h-6", "key": "svg-12" }], ["path", { "d": "M12 9v6", "key": "svg-13" }]]);

var IconBorderBottom = createVueComponent("outline", "border-bottom", "BorderBottom", [["path", { "d": "M20 20l-16 0", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M20 4l0 .01", "key": "svg-5" }], ["path", { "d": "M4 8l0 .01", "key": "svg-6" }], ["path", { "d": "M12 8l0 .01", "key": "svg-7" }], ["path", { "d": "M20 8l0 .01", "key": "svg-8" }], ["path", { "d": "M4 12l0 .01", "key": "svg-9" }], ["path", { "d": "M8 12l0 .01", "key": "svg-10" }], ["path", { "d": "M12 12l0 .01", "key": "svg-11" }], ["path", { "d": "M16 12l0 .01", "key": "svg-12" }], ["path", { "d": "M20 12l0 .01", "key": "svg-13" }], ["path", { "d": "M4 16l0 .01", "key": "svg-14" }], ["path", { "d": "M12 16l0 .01", "key": "svg-15" }], ["path", { "d": "M20 16l0 .01", "key": "svg-16" }]]);

var IconBorderCornerIos = createVueComponent("outline", "border-corner-ios", "BorderCornerIos", [["path", { "d": "M4 20c0 -6.559 0 -9.838 1.628 -12.162a9 9 0 0 1 2.21 -2.21c2.324 -1.628 5.602 -1.628 12.162 -1.628", "key": "svg-0" }]]);

var IconBorderCornerPill = createVueComponent("outline", "border-corner-pill", "BorderCornerPill", [["path", { "d": "M4 20v-5c0 -6.075 4.925 -11 11 -11h5", "key": "svg-0" }]]);

var IconBorderCornerRounded = createVueComponent("outline", "border-corner-rounded", "BorderCornerRounded", [["path", { "d": "M4 20v-10a6 6 0 0 1 6 -6h10", "key": "svg-0" }]]);

var IconBorderCornerSquare = createVueComponent("outline", "border-corner-square", "BorderCornerSquare", [["path", { "d": "M4 20v-15a1 1 0 0 1 1 -1h15", "key": "svg-0" }]]);

var IconBorderCorners = createVueComponent("outline", "border-corners", "BorderCorners", [["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M20 16v2a2 2 0 0 1 -2 2h-2", "key": "svg-1" }], ["path", { "d": "M8 20h-2a2 2 0 0 1 -2 -2v-2", "key": "svg-2" }], ["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBorderHorizontal = createVueComponent("outline", "border-horizontal", "BorderHorizontal", [["path", { "d": "M4 12l16 0", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M20 4l0 .01", "key": "svg-5" }], ["path", { "d": "M4 8l0 .01", "key": "svg-6" }], ["path", { "d": "M12 8l0 .01", "key": "svg-7" }], ["path", { "d": "M20 8l0 .01", "key": "svg-8" }], ["path", { "d": "M4 16l0 .01", "key": "svg-9" }], ["path", { "d": "M12 16l0 .01", "key": "svg-10" }], ["path", { "d": "M20 16l0 .01", "key": "svg-11" }], ["path", { "d": "M4 20l0 .01", "key": "svg-12" }], ["path", { "d": "M8 20l0 .01", "key": "svg-13" }], ["path", { "d": "M12 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderInner = createVueComponent("outline", "border-inner", "BorderInner", [["path", { "d": "M4 12l16 0", "key": "svg-0" }], ["path", { "d": "M12 4l0 16", "key": "svg-1" }], ["path", { "d": "M4 4l0 .01", "key": "svg-2" }], ["path", { "d": "M8 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M20 4l0 .01", "key": "svg-5" }], ["path", { "d": "M4 8l0 .01", "key": "svg-6" }], ["path", { "d": "M20 8l0 .01", "key": "svg-7" }], ["path", { "d": "M4 16l0 .01", "key": "svg-8" }], ["path", { "d": "M20 16l0 .01", "key": "svg-9" }], ["path", { "d": "M4 20l0 .01", "key": "svg-10" }], ["path", { "d": "M8 20l0 .01", "key": "svg-11" }], ["path", { "d": "M16 20l0 .01", "key": "svg-12" }], ["path", { "d": "M20 20l0 .01", "key": "svg-13" }]]);

var IconBorderLeftPlus = createVueComponent("outline", "border-left-plus", "BorderLeftPlus", [["path", { "d": "M4 20v-16", "key": "svg-0" }], ["path", { "d": "M8 4v.01", "key": "svg-1" }], ["path", { "d": "M12 4v.01", "key": "svg-2" }], ["path", { "d": "M16 4v.01", "key": "svg-3" }], ["path", { "d": "M20 4v.01", "key": "svg-4" }], ["path", { "d": "M20 8v.01", "key": "svg-5" }], ["path", { "d": "M20 12v.01", "key": "svg-6" }], ["path", { "d": "M20 16v.01", "key": "svg-7" }], ["path", { "d": "M8 20v.01", "key": "svg-8" }], ["path", { "d": "M12 20v.01", "key": "svg-9" }], ["path", { "d": "M16 20v.01", "key": "svg-10" }], ["path", { "d": "M20 20v.01", "key": "svg-11" }], ["path", { "d": "M9 12h6", "key": "svg-12" }], ["path", { "d": "M12 9v6", "key": "svg-13" }]]);

var IconBorderLeft = createVueComponent("outline", "border-left", "BorderLeft", [["path", { "d": "M4 20l0 -16", "key": "svg-0" }], ["path", { "d": "M8 4l0 .01", "key": "svg-1" }], ["path", { "d": "M12 4l0 .01", "key": "svg-2" }], ["path", { "d": "M16 4l0 .01", "key": "svg-3" }], ["path", { "d": "M20 4l0 .01", "key": "svg-4" }], ["path", { "d": "M12 8l0 .01", "key": "svg-5" }], ["path", { "d": "M20 8l0 .01", "key": "svg-6" }], ["path", { "d": "M8 12l0 .01", "key": "svg-7" }], ["path", { "d": "M12 12l0 .01", "key": "svg-8" }], ["path", { "d": "M16 12l0 .01", "key": "svg-9" }], ["path", { "d": "M20 12l0 .01", "key": "svg-10" }], ["path", { "d": "M12 16l0 .01", "key": "svg-11" }], ["path", { "d": "M20 16l0 .01", "key": "svg-12" }], ["path", { "d": "M8 20l0 .01", "key": "svg-13" }], ["path", { "d": "M12 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderNone = createVueComponent("outline", "border-none", "BorderNone", [["path", { "d": "M4 4l0 .01", "key": "svg-0" }], ["path", { "d": "M8 4l0 .01", "key": "svg-1" }], ["path", { "d": "M12 4l0 .01", "key": "svg-2" }], ["path", { "d": "M16 4l0 .01", "key": "svg-3" }], ["path", { "d": "M20 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M12 8l0 .01", "key": "svg-6" }], ["path", { "d": "M20 8l0 .01", "key": "svg-7" }], ["path", { "d": "M4 12l0 .01", "key": "svg-8" }], ["path", { "d": "M8 12l0 .01", "key": "svg-9" }], ["path", { "d": "M12 12l0 .01", "key": "svg-10" }], ["path", { "d": "M16 12l0 .01", "key": "svg-11" }], ["path", { "d": "M20 12l0 .01", "key": "svg-12" }], ["path", { "d": "M4 16l0 .01", "key": "svg-13" }], ["path", { "d": "M12 16l0 .01", "key": "svg-14" }], ["path", { "d": "M20 16l0 .01", "key": "svg-15" }], ["path", { "d": "M4 20l0 .01", "key": "svg-16" }], ["path", { "d": "M8 20l0 .01", "key": "svg-17" }], ["path", { "d": "M12 20l0 .01", "key": "svg-18" }], ["path", { "d": "M16 20l0 .01", "key": "svg-19" }], ["path", { "d": "M20 20l0 .01", "key": "svg-20" }]]);

var IconBorderOuter = createVueComponent("outline", "border-outer", "BorderOuter", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 8l0 .01", "key": "svg-1" }], ["path", { "d": "M8 12l0 .01", "key": "svg-2" }], ["path", { "d": "M12 12l0 .01", "key": "svg-3" }], ["path", { "d": "M16 12l0 .01", "key": "svg-4" }], ["path", { "d": "M12 16l0 .01", "key": "svg-5" }]]);

var IconBorderRadius = createVueComponent("outline", "border-radius", "BorderRadius", [["path", { "d": "M4 12v-4a4 4 0 0 1 4 -4h4", "key": "svg-0" }], ["path", { "d": "M16 4l0 .01", "key": "svg-1" }], ["path", { "d": "M20 4l0 .01", "key": "svg-2" }], ["path", { "d": "M20 8l0 .01", "key": "svg-3" }], ["path", { "d": "M20 12l0 .01", "key": "svg-4" }], ["path", { "d": "M4 16l0 .01", "key": "svg-5" }], ["path", { "d": "M20 16l0 .01", "key": "svg-6" }], ["path", { "d": "M4 20l0 .01", "key": "svg-7" }], ["path", { "d": "M8 20l0 .01", "key": "svg-8" }], ["path", { "d": "M12 20l0 .01", "key": "svg-9" }], ["path", { "d": "M16 20l0 .01", "key": "svg-10" }], ["path", { "d": "M20 20l0 .01", "key": "svg-11" }]]);

var IconBorderRightPlus = createVueComponent("outline", "border-right-plus", "BorderRightPlus", [["path", { "d": "M20 20v-16", "key": "svg-0" }], ["path", { "d": "M16 4v.01", "key": "svg-1" }], ["path", { "d": "M12 4v.01", "key": "svg-2" }], ["path", { "d": "M8 4v.01", "key": "svg-3" }], ["path", { "d": "M4 4v.01", "key": "svg-4" }], ["path", { "d": "M4 8v.01", "key": "svg-5" }], ["path", { "d": "M4 12v.01", "key": "svg-6" }], ["path", { "d": "M4 16v.01", "key": "svg-7" }], ["path", { "d": "M16 20v.01", "key": "svg-8" }], ["path", { "d": "M12 20v.01", "key": "svg-9" }], ["path", { "d": "M8 20v.01", "key": "svg-10" }], ["path", { "d": "M4 20v.01", "key": "svg-11" }], ["path", { "d": "M15 12h-6", "key": "svg-12" }], ["path", { "d": "M12 9v6", "key": "svg-13" }]]);

var IconBorderRight = createVueComponent("outline", "border-right", "BorderRight", [["path", { "d": "M20 4l0 16", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M12 8l0 .01", "key": "svg-6" }], ["path", { "d": "M4 12l0 .01", "key": "svg-7" }], ["path", { "d": "M8 12l0 .01", "key": "svg-8" }], ["path", { "d": "M12 12l0 .01", "key": "svg-9" }], ["path", { "d": "M16 12l0 .01", "key": "svg-10" }], ["path", { "d": "M4 16l0 .01", "key": "svg-11" }], ["path", { "d": "M12 16l0 .01", "key": "svg-12" }], ["path", { "d": "M4 20l0 .01", "key": "svg-13" }], ["path", { "d": "M8 20l0 .01", "key": "svg-14" }], ["path", { "d": "M12 20l0 .01", "key": "svg-15" }], ["path", { "d": "M16 20l0 .01", "key": "svg-16" }]]);

var IconBorderSides = createVueComponent("outline", "border-sides", "BorderSides", [["path", { "d": "M4 8v8", "key": "svg-0" }], ["path", { "d": "M20 16v-8", "key": "svg-1" }], ["path", { "d": "M8 4h8", "key": "svg-2" }], ["path", { "d": "M8 20h8", "key": "svg-3" }]]);

var IconBorderStyle2 = createVueComponent("outline", "border-style-2", "BorderStyle2", [["path", { "d": "M4 18v.01", "key": "svg-0" }], ["path", { "d": "M8 18v.01", "key": "svg-1" }], ["path", { "d": "M12 18v.01", "key": "svg-2" }], ["path", { "d": "M16 18v.01", "key": "svg-3" }], ["path", { "d": "M20 18v.01", "key": "svg-4" }], ["path", { "d": "M18 12h2", "key": "svg-5" }], ["path", { "d": "M11 12h2", "key": "svg-6" }], ["path", { "d": "M4 12h2", "key": "svg-7" }], ["path", { "d": "M4 6h16", "key": "svg-8" }]]);

var IconBorderStyle = createVueComponent("outline", "border-style", "BorderStyle", [["path", { "d": "M4 20v-14a2 2 0 0 1 2 -2h14", "key": "svg-0" }], ["path", { "d": "M20 8v.01", "key": "svg-1" }], ["path", { "d": "M20 12v.01", "key": "svg-2" }], ["path", { "d": "M20 16v.01", "key": "svg-3" }], ["path", { "d": "M8 20v.01", "key": "svg-4" }], ["path", { "d": "M12 20v.01", "key": "svg-5" }], ["path", { "d": "M16 20v.01", "key": "svg-6" }], ["path", { "d": "M20 20v.01", "key": "svg-7" }]]);

var IconBorderTopPlus = createVueComponent("outline", "border-top-plus", "BorderTopPlus", [["path", { "d": "M4 4h16", "key": "svg-0" }], ["path", { "d": "M4 8v.01", "key": "svg-1" }], ["path", { "d": "M20 8v.01", "key": "svg-2" }], ["path", { "d": "M4 12v.01", "key": "svg-3" }], ["path", { "d": "M20 12v.01", "key": "svg-4" }], ["path", { "d": "M4 16v.01", "key": "svg-5" }], ["path", { "d": "M15 12h-6", "key": "svg-6" }], ["path", { "d": "M12 9v6", "key": "svg-7" }], ["path", { "d": "M20 16v.01", "key": "svg-8" }], ["path", { "d": "M4 20v.01", "key": "svg-9" }], ["path", { "d": "M8 20v.01", "key": "svg-10" }], ["path", { "d": "M12 20v.01", "key": "svg-11" }], ["path", { "d": "M16 20v.01", "key": "svg-12" }], ["path", { "d": "M20 20v.01", "key": "svg-13" }]]);

var IconBorderTop = createVueComponent("outline", "border-top", "BorderTop", [["path", { "d": "M4 4l16 0", "key": "svg-0" }], ["path", { "d": "M4 8l0 .01", "key": "svg-1" }], ["path", { "d": "M12 8l0 .01", "key": "svg-2" }], ["path", { "d": "M20 8l0 .01", "key": "svg-3" }], ["path", { "d": "M4 12l0 .01", "key": "svg-4" }], ["path", { "d": "M8 12l0 .01", "key": "svg-5" }], ["path", { "d": "M12 12l0 .01", "key": "svg-6" }], ["path", { "d": "M16 12l0 .01", "key": "svg-7" }], ["path", { "d": "M20 12l0 .01", "key": "svg-8" }], ["path", { "d": "M4 16l0 .01", "key": "svg-9" }], ["path", { "d": "M12 16l0 .01", "key": "svg-10" }], ["path", { "d": "M20 16l0 .01", "key": "svg-11" }], ["path", { "d": "M4 20l0 .01", "key": "svg-12" }], ["path", { "d": "M8 20l0 .01", "key": "svg-13" }], ["path", { "d": "M12 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderVertical = createVueComponent("outline", "border-vertical", "BorderVertical", [["path", { "d": "M12 4l0 16", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M16 4l0 .01", "key": "svg-3" }], ["path", { "d": "M20 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M20 8l0 .01", "key": "svg-6" }], ["path", { "d": "M4 12l0 .01", "key": "svg-7" }], ["path", { "d": "M8 12l0 .01", "key": "svg-8" }], ["path", { "d": "M16 12l0 .01", "key": "svg-9" }], ["path", { "d": "M20 12l0 .01", "key": "svg-10" }], ["path", { "d": "M4 16l0 .01", "key": "svg-11" }], ["path", { "d": "M20 16l0 .01", "key": "svg-12" }], ["path", { "d": "M4 20l0 .01", "key": "svg-13" }], ["path", { "d": "M8 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBottleOff = createVueComponent("outline", "bottle-off", "BottleOff", [["path", { "d": "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z", "key": "svg-0" }], ["path", { "d": "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v.199m0 4v2a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2a8.09 8.09 0 0 1 1.35 -4.474m1.336 -2.63a7.822 7.822 0 0 0 .314 -2.196", "key": "svg-1" }], ["path", { "d": "M7 14.803a2.4 2.4 0 0 0 1 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 .866 -.142", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBottle = createVueComponent("outline", "bottle", "Bottle", [["path", { "d": "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z", "key": "svg-0" }], ["path", { "d": "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v6.199a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2c0 -1.682 .524 -3.322 1.5 -4.693l.05 -.07a7.823 7.823 0 0 0 1.45 -4.537", "key": "svg-1" }], ["path", { "d": "M7 14.803a2.4 2.4 0 0 0 1 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1 -.805", "key": "svg-2" }]]);

var IconBounceLeft = createVueComponent("outline", "bounce-left", "BounceLeft", [["path", { "d": "M20 15.5c-3 -1 -5.5 -.5 -8 4.5c-.5 -3 -1.5 -5.5 -3 -8", "key": "svg-0" }], ["path", { "d": "M6 9a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z", "key": "svg-1" }]]);

var IconBounceRight = createVueComponent("outline", "bounce-right", "BounceRight", [["path", { "d": "M4 15.5c3 -1 5.5 -.5 8 4.5c.5 -3 1.5 -5.5 3 -8", "key": "svg-0" }], ["path", { "d": "M18 9a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z", "key": "svg-1" }]]);

var IconBow = createVueComponent("outline", "bow", "Bow", [["path", { "d": "M17 3h4v4", "key": "svg-0" }], ["path", { "d": "M21 3l-15 15", "key": "svg-1" }], ["path", { "d": "M3 18h3v3", "key": "svg-2" }], ["path", { "d": "M16.5 20c1.576 -1.576 2.5 -4.095 2.5 -6.5c0 -4.81 -3.69 -8.5 -8.5 -8.5c-2.415 0 -4.922 .913 -6.5 2.5l12.5 12.5z", "key": "svg-3" }]]);

var IconBowlChopsticks = createVueComponent("outline", "bowl-chopsticks", "BowlChopsticks", [["path", { "d": "M4 11h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M19 7l-14 1", "key": "svg-1" }], ["path", { "d": "M19 2l-14 3", "key": "svg-2" }]]);

var IconBowlSpoon = createVueComponent("outline", "bowl-spoon", "BowlSpoon", [["path", { "d": "M4 11h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M8 7c1.657 0 3 -.895 3 -2s-1.343 -2 -3 -2s-3 .895 -3 2s1.343 2 3 2", "key": "svg-1" }], ["path", { "d": "M11 5h9", "key": "svg-2" }]]);

var IconBowl = createVueComponent("outline", "bowl", "Bowl", [["path", { "d": "M4 8h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z", "key": "svg-0" }]]);

var IconBowling = createVueComponent("outline", "bowling", "Bowling", [["path", { "d": "M7 11v.01", "key": "svg-0" }], ["path", { "d": "M11 10v.01", "key": "svg-1" }], ["path", { "d": "M10 14v.01", "key": "svg-2" }], ["path", { "d": "M11.059 6.07a8 8 0 1 0 .32 15.81", "key": "svg-3" }], ["path", { "d": "M15.969 9h4", "key": "svg-4" }], ["path", { "d": "M14.969 5c0 1.5 1 2 1 4c0 2.5 -2 4.5 -2 7c0 2.6 1.9 6 1.9 6h4.1s2 -3.4 2 -6c0 -2.5 -2 -4.5 -2 -7c0 -2 1 -2.5 1 -4a3 3 0 1 0 -6 0", "key": "svg-5" }]]);

var IconBoxAlignBottomLeft = createVueComponent("outline", "box-align-bottom-left", "BoxAlignBottomLeft", [["path", { "d": "M5 13h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M4 9v.01", "key": "svg-1" }], ["path", { "d": "M4 4v.01", "key": "svg-2" }], ["path", { "d": "M9 4v.01", "key": "svg-3" }], ["path", { "d": "M15 4v.01", "key": "svg-4" }], ["path", { "d": "M15 20v.01", "key": "svg-5" }], ["path", { "d": "M20 4v.01", "key": "svg-6" }], ["path", { "d": "M20 9v.01", "key": "svg-7" }], ["path", { "d": "M20 15v.01", "key": "svg-8" }], ["path", { "d": "M20 20v.01", "key": "svg-9" }]]);

var IconBoxAlignBottomRight = createVueComponent("outline", "box-align-bottom-right", "BoxAlignBottomRight", [["path", { "d": "M19 13h-5a1 1 0 0 0 -1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 1 -1v-5a1 1 0 0 0 -1 -1z", "key": "svg-0" }], ["path", { "d": "M20 9v.01", "key": "svg-1" }], ["path", { "d": "M20 4v.01", "key": "svg-2" }], ["path", { "d": "M15 4v.01", "key": "svg-3" }], ["path", { "d": "M9 4v.01", "key": "svg-4" }], ["path", { "d": "M9 20v.01", "key": "svg-5" }], ["path", { "d": "M4 4v.01", "key": "svg-6" }], ["path", { "d": "M4 9v.01", "key": "svg-7" }], ["path", { "d": "M4 15v.01", "key": "svg-8" }], ["path", { "d": "M4 20v.01", "key": "svg-9" }]]);

var IconBoxAlignBottom = createVueComponent("outline", "box-align-bottom", "BoxAlignBottom", [["path", { "d": "M4 14h16v5a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1v-5z", "key": "svg-0" }], ["path", { "d": "M4 9v.01", "key": "svg-1" }], ["path", { "d": "M4 4v.01", "key": "svg-2" }], ["path", { "d": "M9 4v.01", "key": "svg-3" }], ["path", { "d": "M15 4v.01", "key": "svg-4" }], ["path", { "d": "M20 4v.01", "key": "svg-5" }], ["path", { "d": "M20 9v.01", "key": "svg-6" }]]);

var IconBoxAlignLeft = createVueComponent("outline", "box-align-left", "BoxAlignLeft", [["path", { "d": "M10.002 20.003v-16h-5a1 1 0 0 0 -1 1v14a1 1 0 0 0 1 1h5z", "key": "svg-0" }], ["path", { "d": "M15.002 20.003h-.01", "key": "svg-1" }], ["path", { "d": "M20.003 20.003h-.011", "key": "svg-2" }], ["path", { "d": "M20.003 15.002h-.011", "key": "svg-3" }], ["path", { "d": "M20.003 9.002h-.011", "key": "svg-4" }], ["path", { "d": "M20.003 4.002h-.011", "key": "svg-5" }], ["path", { "d": "M15.002 4.002h-.01", "key": "svg-6" }]]);

var IconBoxAlignRight = createVueComponent("outline", "box-align-right", "BoxAlignRight", [["path", { "d": "M13.998 20.003v-16h5a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-5z", "key": "svg-0" }], ["path", { "d": "M8.998 20.003h.01", "key": "svg-1" }], ["path", { "d": "M3.997 20.003h.011", "key": "svg-2" }], ["path", { "d": "M3.997 15.002h.011", "key": "svg-3" }], ["path", { "d": "M3.997 9.002h.011", "key": "svg-4" }], ["path", { "d": "M3.997 4.002h.011", "key": "svg-5" }], ["path", { "d": "M8.998 4.002h.01", "key": "svg-6" }]]);

var IconBoxAlignTopLeft = createVueComponent("outline", "box-align-top-left", "BoxAlignTopLeft", [["path", { "d": "M11 5v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1z", "key": "svg-0" }], ["path", { "d": "M15 4h-.01", "key": "svg-1" }], ["path", { "d": "M20 4h-.01", "key": "svg-2" }], ["path", { "d": "M20 9h-.01", "key": "svg-3" }], ["path", { "d": "M20 15h-.01", "key": "svg-4" }], ["path", { "d": "M4 15h-.01", "key": "svg-5" }], ["path", { "d": "M20 20h-.01", "key": "svg-6" }], ["path", { "d": "M15 20h-.01", "key": "svg-7" }], ["path", { "d": "M9 20h-.01", "key": "svg-8" }], ["path", { "d": "M4 20h-.01", "key": "svg-9" }]]);

var IconBoxAlignTopRight = createVueComponent("outline", "box-align-top-right", "BoxAlignTopRight", [["path", { "d": "M19 11.01h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1z", "key": "svg-0" }], ["path", { "d": "M20 15.01v-.01", "key": "svg-1" }], ["path", { "d": "M20 20.01v-.01", "key": "svg-2" }], ["path", { "d": "M15 20.01v-.01", "key": "svg-3" }], ["path", { "d": "M9 20.01v-.01", "key": "svg-4" }], ["path", { "d": "M9 4.01v-.01", "key": "svg-5" }], ["path", { "d": "M4 20.01v-.01", "key": "svg-6" }], ["path", { "d": "M4 15.01v-.01", "key": "svg-7" }], ["path", { "d": "M4 9.01v-.01", "key": "svg-8" }], ["path", { "d": "M4 4.01v-.01", "key": "svg-9" }]]);

var IconBoxAlignTop = createVueComponent("outline", "box-align-top", "BoxAlignTop", [["path", { "d": "M4 10.005h16v-5a1 1 0 0 0 -1 -1h-14a1 1 0 0 0 -1 1v5z", "key": "svg-0" }], ["path", { "d": "M4 15.005v-.01", "key": "svg-1" }], ["path", { "d": "M4 20.005v-.01", "key": "svg-2" }], ["path", { "d": "M9 20.005v-.01", "key": "svg-3" }], ["path", { "d": "M15 20.005v-.01", "key": "svg-4" }], ["path", { "d": "M20 20.005v-.01", "key": "svg-5" }], ["path", { "d": "M20 15.005v-.01", "key": "svg-6" }]]);

var IconBoxMargin = createVueComponent("outline", "box-margin", "BoxMargin", [["path", { "d": "M8 8h8v8h-8z", "key": "svg-0" }], ["path", { "d": "M4 4v.01", "key": "svg-1" }], ["path", { "d": "M8 4v.01", "key": "svg-2" }], ["path", { "d": "M12 4v.01", "key": "svg-3" }], ["path", { "d": "M16 4v.01", "key": "svg-4" }], ["path", { "d": "M20 4v.01", "key": "svg-5" }], ["path", { "d": "M4 20v.01", "key": "svg-6" }], ["path", { "d": "M8 20v.01", "key": "svg-7" }], ["path", { "d": "M12 20v.01", "key": "svg-8" }], ["path", { "d": "M16 20v.01", "key": "svg-9" }], ["path", { "d": "M20 20v.01", "key": "svg-10" }], ["path", { "d": "M20 16v.01", "key": "svg-11" }], ["path", { "d": "M20 12v.01", "key": "svg-12" }], ["path", { "d": "M20 8v.01", "key": "svg-13" }], ["path", { "d": "M4 16v.01", "key": "svg-14" }], ["path", { "d": "M4 12v.01", "key": "svg-15" }], ["path", { "d": "M4 8v.01", "key": "svg-16" }]]);

var IconBoxModel2Off = createVueComponent("outline", "box-model-2-off", "BoxModel2Off", [["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-0" }], ["path", { "d": "M12 8h4v4m0 4h-8v-8", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBoxModel2 = createVueComponent("outline", "box-model-2", "BoxModel2", [["path", { "d": "M8 8h8v8h-8z", "key": "svg-0" }], ["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }]]);

var IconBoxModelOff = createVueComponent("outline", "box-model-off", "BoxModelOff", [["path", { "d": "M12 8h4v4m0 4h-8v-8", "key": "svg-0" }], ["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-1" }], ["path", { "d": "M16 16l3.3 3.3", "key": "svg-2" }], ["path", { "d": "M16 8l3.3 -3.3", "key": "svg-3" }], ["path", { "d": "M8 8l-3.3 -3.3", "key": "svg-4" }], ["path", { "d": "M8 16l-3.3 3.3", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconBoxModel = createVueComponent("outline", "box-model", "BoxModel", [["path", { "d": "M8 8h8v8h-8z", "key": "svg-0" }], ["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M16 16l3.3 3.3", "key": "svg-2" }], ["path", { "d": "M16 8l3.3 -3.3", "key": "svg-3" }], ["path", { "d": "M8 8l-3.3 -3.3", "key": "svg-4" }], ["path", { "d": "M8 16l-3.3 3.3", "key": "svg-5" }]]);

var IconBoxMultiple0 = createVueComponent("outline", "box-multiple-0", "BoxMultiple0", [["path", { "d": "M14 6a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconBoxMultiple1 = createVueComponent("outline", "box-multiple-1", "BoxMultiple1", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M14 14v-8l-2 2", "key": "svg-2" }]]);

var IconBoxMultiple2 = createVueComponent("outline", "box-multiple-2", "BoxMultiple2", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M12 8a2 2 0 1 1 4 0c0 .591 -.417 1.318 -.816 1.858l-3.184 4.143l4 0", "key": "svg-2" }]]);

var IconBoxMultiple3 = createVueComponent("outline", "box-multiple-3", "BoxMultiple3", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M14 10a2 2 0 1 0 -2 -2", "key": "svg-2" }], ["path", { "d": "M12 12a2 2 0 1 0 2 -2", "key": "svg-3" }]]);

var IconBoxMultiple4 = createVueComponent("outline", "box-multiple-4", "BoxMultiple4", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M15 14v-8l-4 6h5", "key": "svg-2" }]]);

var IconBoxMultiple5 = createVueComponent("outline", "box-multiple-5", "BoxMultiple5", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 14h2a2 2 0 1 0 0 -4h-2v-4h4", "key": "svg-1" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconBoxMultiple6 = createVueComponent("outline", "box-multiple-6", "BoxMultiple6", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M16 8a2 2 0 1 0 -4 0v4", "key": "svg-2" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBoxMultiple7 = createVueComponent("outline", "box-multiple-7", "BoxMultiple7", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 6h4l-2 8", "key": "svg-1" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconBoxMultiple8 = createVueComponent("outline", "box-multiple-8", "BoxMultiple8", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M14 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBoxMultiple9 = createVueComponent("outline", "box-multiple-9", "BoxMultiple9", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M12 12a2 2 0 1 0 4 0v-4", "key": "svg-2" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBoxMultiple = createVueComponent("outline", "box-multiple", "BoxMultiple", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }]]);

var IconBoxOff = createVueComponent("outline", "box-off", "BoxOff", [["path", { "d": "M17.765 17.757l-5.765 3.243l-8 -4.5v-9l2.236 -1.258m2.57 -1.445l3.194 -1.797l8 4.5v8.5", "key": "svg-0" }], ["path", { "d": "M14.561 10.559l5.439 -3.059", "key": "svg-1" }], ["path", { "d": "M12 12v9", "key": "svg-2" }], ["path", { "d": "M12 12l-8 -4.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBoxPadding = createVueComponent("outline", "box-padding", "BoxPadding", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 16v.01", "key": "svg-1" }], ["path", { "d": "M8 12v.01", "key": "svg-2" }], ["path", { "d": "M8 8v.01", "key": "svg-3" }], ["path", { "d": "M16 16v.01", "key": "svg-4" }], ["path", { "d": "M16 12v.01", "key": "svg-5" }], ["path", { "d": "M16 8v.01", "key": "svg-6" }], ["path", { "d": "M12 8v.01", "key": "svg-7" }], ["path", { "d": "M12 16v.01", "key": "svg-8" }]]);

var IconBox = createVueComponent("outline", "box", "Box", [["path", { "d": "M12 3l8 4.5l0 9l-8 4.5l-8 -4.5l0 -9l8 -4.5", "key": "svg-0" }], ["path", { "d": "M12 12l8 -4.5", "key": "svg-1" }], ["path", { "d": "M12 12l0 9", "key": "svg-2" }], ["path", { "d": "M12 12l-8 -4.5", "key": "svg-3" }]]);

var IconBracesOff = createVueComponent("outline", "braces-off", "BracesOff", [["path", { "d": "M5.176 5.177c-.113 .251 -.176 .53 -.176 .823v3c0 1.657 -.895 3 -2 3c1.105 0 2 1.343 2 3v3a2 2 0 0 0 2 2", "key": "svg-0" }], ["path", { "d": "M17 4a2 2 0 0 1 2 2v3c0 1.657 .895 3 2 3c-1.105 0 -2 1.343 -2 3m-.176 3.821a2 2 0 0 1 -1.824 1.179", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBraces = createVueComponent("outline", "braces", "Braces", [["path", { "d": "M7 4a2 2 0 0 0 -2 2v3a2 3 0 0 1 -2 3a2 3 0 0 1 2 3v3a2 2 0 0 0 2 2", "key": "svg-0" }], ["path", { "d": "M17 4a2 2 0 0 1 2 2v3a2 3 0 0 0 2 3a2 3 0 0 0 -2 3v3a2 2 0 0 1 -2 2", "key": "svg-1" }]]);

var IconBracketsAngleOff = createVueComponent("outline", "brackets-angle-off", "BracketsAngleOff", [["path", { "d": "M8 4h.01", "key": "svg-0" }], ["path", { "d": "M6.453 6.474l-3.453 5.526l5 8", "key": "svg-1" }], ["path", { "d": "M16 4l5 8l-1.917 3.067", "key": "svg-2" }], ["path", { "d": "M17.535 17.544l-1.535 2.456", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBracketsAngle = createVueComponent("outline", "brackets-angle", "BracketsAngle", [["path", { "d": "M8 4l-5 8l5 8", "key": "svg-0" }], ["path", { "d": "M16 4l5 8l-5 8", "key": "svg-1" }]]);

var IconBracketsContainEnd = createVueComponent("outline", "brackets-contain-end", "BracketsContainEnd", [["path", { "d": "M14 4h4v16h-4", "key": "svg-0" }], ["path", { "d": "M5 16h.01", "key": "svg-1" }], ["path", { "d": "M9 16h.01", "key": "svg-2" }], ["path", { "d": "M13 16h.01", "key": "svg-3" }]]);

var IconBracketsContainStart = createVueComponent("outline", "brackets-contain-start", "BracketsContainStart", [["path", { "d": "M9 4h-4v16h4", "key": "svg-0" }], ["path", { "d": "M18 16h-.01", "key": "svg-1" }], ["path", { "d": "M14 16h-.01", "key": "svg-2" }], ["path", { "d": "M10 16h-.01", "key": "svg-3" }]]);

var IconBracketsContain = createVueComponent("outline", "brackets-contain", "BracketsContain", [["path", { "d": "M7 4h-4v16h4", "key": "svg-0" }], ["path", { "d": "M17 4h4v16h-4", "key": "svg-1" }], ["path", { "d": "M8 16h.01", "key": "svg-2" }], ["path", { "d": "M12 16h.01", "key": "svg-3" }], ["path", { "d": "M16 16h.01", "key": "svg-4" }]]);

var IconBracketsOff = createVueComponent("outline", "brackets-off", "BracketsOff", [["path", { "d": "M5 5v15h3", "key": "svg-0" }], ["path", { "d": "M16 4h3v11m0 4v1h-3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBrackets = createVueComponent("outline", "brackets", "Brackets", [["path", { "d": "M8 4h-3v16h3", "key": "svg-0" }], ["path", { "d": "M16 4h3v16h-3", "key": "svg-1" }]]);

var IconBraille = createVueComponent("outline", "braille", "Braille", [["path", { "d": "M15 5a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z", "key": "svg-0" }], ["path", { "d": "M7 5a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z", "key": "svg-1" }], ["path", { "d": "M7 19a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z", "key": "svg-2" }], ["path", { "d": "M16 12h.01", "key": "svg-3" }], ["path", { "d": "M8 12h.01", "key": "svg-4" }], ["path", { "d": "M16 19h.01", "key": "svg-5" }]]);

var IconBrain = createVueComponent("outline", "brain", "Brain", [["path", { "d": "M15.5 13a3.5 3.5 0 0 0 -3.5 3.5v1a3.5 3.5 0 0 0 7 0v-1.8", "key": "svg-0" }], ["path", { "d": "M8.5 13a3.5 3.5 0 0 1 3.5 3.5v1a3.5 3.5 0 0 1 -7 0v-1.8", "key": "svg-1" }], ["path", { "d": "M17.5 16a3.5 3.5 0 0 0 0 -7h-.5", "key": "svg-2" }], ["path", { "d": "M19 9.3v-2.8a3.5 3.5 0 0 0 -7 0", "key": "svg-3" }], ["path", { "d": "M6.5 16a3.5 3.5 0 0 1 0 -7h.5", "key": "svg-4" }], ["path", { "d": "M5 9.3v-2.8a3.5 3.5 0 0 1 7 0v10", "key": "svg-5" }]]);

var IconBrand4chan = createVueComponent("outline", "brand-4chan", "Brand4chan", [["path", { "d": "M14 11s6.054 -1.05 6 -4.5c-.038 -2.324 -2.485 -3.19 -3.016 -1.5c0 0 -.502 -2 -2.01 -2c-1.508 0 -2.984 3 -.974 8z", "key": "svg-0" }], ["path", { "d": "M13.98 11s6.075 -1.05 6.02 -4.5c-.038 -2.324 -2.493 -3.19 -3.025 -1.5c0 0 -.505 -2 -2.017 -2c-1.513 0 -3 3 -.977 8z", "key": "svg-1" }], ["path", { "d": "M13 13.98l.062 .309l.081 .35l.075 .29l.092 .328l.11 .358l.061 .188l.139 .392c.64 1.73 1.841 3.837 3.88 3.805c2.324 -.038 3.19 -2.493 1.5 -3.025l.148 -.045l.165 -.058a4.13 4.13 0 0 0 .098 -.039l.222 -.098c.586 -.28 1.367 -.832 1.367 -1.777c0 -1.513 -3 -3 -8 -.977z", "key": "svg-2" }], ["path", { "d": "M10.02 13l-.309 .062l-.35 .081l-.29 .075l-.328 .092l-.358 .11l-.188 .061l-.392 .139c-1.73 .64 -3.837 1.84 -3.805 3.88c.038 2.324 2.493 3.19 3.025 1.5l.045 .148l.058 .165l.039 .098l.098 .222c.28 .586 .832 1.367 1.777 1.367c1.513 0 3 -3 .977 -8z", "key": "svg-3" }], ["path", { "d": "M11 10.02l-.062 -.309l-.081 -.35l-.075 -.29l-.092 -.328l-.11 -.358l-.128 -.382l-.148 -.399c-.658 -1.687 -1.844 -3.634 -3.804 -3.604c-2.324 .038 -3.19 2.493 -1.5 3.025l-.148 .045l-.164 .058a4.13 4.13 0 0 0 -.1 .039l-.22 .098c-.588 .28 -1.368 .832 -1.368 1.777c0 1.513 3 3 8 .977z", "key": "svg-4" }]]);

var IconBrandAbstract = createVueComponent("outline", "brand-abstract", "BrandAbstract", [["path", { "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z", "key": "svg-0" }], ["path", { "d": "M10.5 13.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-1" }], ["path", { "d": "M8 8h8v8", "key": "svg-2" }]]);

var IconBrandAdobeAfterEffect = createVueComponent("outline", "brand-adobe-after-effect", "BrandAdobeAfterEffect", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M12 15.79l-.82 -2.653m-4.864 2.652l.82 -2.652m0 0l.686 -2.218c.559 -1.806 .838 -2.708 1.336 -2.708s.777 .902 1.335 2.708l.686 2.218m-4.043 0h4.043", "key": "svg-1" }], ["path", { "d": "M13.895 12.824v1.07a1.895 1.895 0 0 0 3.54 .942m-3.54 -2.012v-.824a1.895 1.895 0 1 1 3.79 0v.824z", "key": "svg-2" }]]);

var IconBrandAdobeIllustrator = createVueComponent("outline", "brand-adobe-illustrator", "BrandAdobeIllustrator", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M12.947 15.79l-.82 -2.653m-4.864 2.652l.82 -2.652m0 0l.687 -2.218c.558 -1.806 .838 -2.708 1.335 -2.708c.498 0 .777 .902 1.336 2.708l.686 2.218m-4.043 0h4.043", "key": "svg-1" }], ["path", { "d": "M15.789 15.789v-4.736", "key": "svg-2" }], ["path", { "d": "M15.789 8.684v-.473", "key": "svg-3" }]]);

var IconBrandAdobeIndesign = createVueComponent("outline", "brand-adobe-indesign", "BrandAdobeIndesign", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M14.842 11.053v3.79c0 1.044 -.49 .946 -1.42 .946a2.368 2.368 0 0 1 0 -4.736zm0 0v-2.843", "key": "svg-1" }], ["path", { "d": "M8.211 8.211v7.578", "key": "svg-2" }]]);

var IconBrandAdobePhotoshop = createVueComponent("outline", "brand-adobe-photoshop", "BrandAdobePhotoshop", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M6.79 15.79v-3.79m0 0v-2.724c0 -.11 0 -.165 .004 -.211c.044 -.45 .4 -.806 .85 -.85c.046 -.004 .101 -.004 .211 -.004h1.303a1.895 1.895 0 1 1 0 3.789z", "key": "svg-1" }], ["path", { "d": "M17.178 11.263c-.164 -.659 -.935 -1.158 -1.862 -1.158c-1.047 0 -1.895 .637 -1.895 1.421c0 .785 .848 1.421 1.895 1.421c1.046 0 1.895 .637 1.895 1.421c0 .785 -.849 1.421 -1.895 1.421c-.93 0 -1.704 -.502 -1.864 -1.165", "key": "svg-2" }]]);

var IconBrandAdobePremier = createVueComponent("outline", "brand-adobe-premier", "BrandAdobePremier", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M7.263 15.79v-3.79m0 0v-3.248c0 -.335 .222 -.541 .542 -.541h1.353a1.895 1.895 0 1 1 0 3.789z", "key": "svg-1" }], ["path", { "d": "M13.895 10.579v1.895m0 0v3.315m0 -3.315c.531 -.709 1.026 -1.592 1.894 -1.832q .22 -.062 .474 -.063", "key": "svg-2" }]]);

var IconBrandAdobeXd = createVueComponent("outline", "brand-adobe-xd", "BrandAdobeXd", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M6.316 8.21l5.684 7.58m-5.684 0l5.684 -7.58", "key": "svg-1" }], ["path", { "d": "M17.684 11.053v3.79c0 1.044 -.49 .946 -1.42 .946a2.368 2.368 0 0 1 0 -4.736zm0 0v-2.843", "key": "svg-2" }]]);

var IconBrandAdobe = createVueComponent("outline", "brand-adobe", "BrandAdobe", [["path", { "d": "M12.893 4.514l7.977 14a.993 .993 0 0 1 -.394 1.365a1.04 1.04 0 0 1 -.5 .127h-3.476l-4.5 -8l-2.5 4h1.5l2 4h-8.977c-.565 0 -1.023 -.45 -1.023 -1c0 -.171 .045 -.34 .13 -.49l7.977 -13.993a1.034 1.034 0 0 1 1.786 0z", "key": "svg-0" }]]);

var IconBrandAdonisJs = createVueComponent("outline", "brand-adonis-js", "BrandAdonisJs", [["path", { "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z", "key": "svg-0" }], ["path", { "d": "M8.863 16.922c1.137 -.422 1.637 -.922 3.137 -.922s2 .5 3.138 .922c.713 .264 1.516 -.102 1.778 -.772c.126 -.32 .11 -.673 -.044 -.983l-3.708 -7.474c-.297 -.598 -1.058 -.859 -1.7 -.583a1.24 1.24 0 0 0 -.627 .583l-3.709 7.474c-.321 .648 -.017 1.415 .679 1.714c.332 .143 .715 .167 1.056 .04z", "key": "svg-1" }]]);

var IconBrandAirbnb = createVueComponent("outline", "brand-airbnb", "BrandAirbnb", [["path", { "d": "M12 10c-2 0 -3 1 -3 3c0 1.5 1.494 3.535 3 5.5c1 1 1.5 1.5 2.5 2s2.5 1 4.5 -.5s1.5 -3.5 .5 -6s-2.333 -5.5 -5 -9.5c-.834 -1 -1.5 -1.5 -2.503 -1.5c-1 0 -1.623 .45 -2.497 1.5c-2.667 4 -4 7 -5 9.5s-1.5 4.5 .5 6s3.5 1 4.5 .5s1.5 -1 2.5 -2c1.506 -1.965 3 -4 3 -5.5c0 -2 -1 -3 -3 -3z", "key": "svg-0" }]]);

var IconBrandAirtable = createVueComponent("outline", "brand-airtable", "BrandAirtable", [["path", { "d": "M3 10v8l7 -3v-2.6z", "key": "svg-0" }], ["path", { "d": "M3 6l9 3l9 -3l-9 -3z", "key": "svg-1" }], ["path", { "d": "M14 12.3v8.7l7 -3v-8z", "key": "svg-2" }]]);

var IconBrandAlgolia = createVueComponent("outline", "brand-algolia", "BrandAlgolia", [["path", { "d": "M15.5 11c-.414 -1.477 -1.886 -2.5 -3.5 -2.5a3.47 3.47 0 0 0 -3.5 3.5a3.47 3.47 0 0 0 3.5 3.5c.974 0 1.861 -.357 2.5 -1l4.5 4.5v-15h-7c-4.386 0 -8 3.582 -8 8s3.614 8 8 8a7.577 7.577 0 0 0 2.998 -.614", "key": "svg-0" }]]);

var IconBrandAlipay = createVueComponent("outline", "brand-alipay", "BrandAlipay", [["path", { "d": "M19 3h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 7h10", "key": "svg-1" }], ["path", { "d": "M12 3v7", "key": "svg-2" }], ["path", { "d": "M21 17.314c-2.971 -1.923 -15 -8.779 -15 -1.864c0 1.716 1.52 2.55 2.985 2.55c3.512 0 6.814 -5.425 6.814 -8h-6.604", "key": "svg-3" }]]);

var IconBrandAlpineJs = createVueComponent("outline", "brand-alpine-js", "BrandAlpineJs", [["path", { "d": "M3 11.5l4.5 4.5h9l-9 -9z", "key": "svg-0" }], ["path", { "d": "M16.5 16l4.5 -4.5l-4.5 -4.5l-4.5 4.5", "key": "svg-1" }]]);

var IconBrandAmazon = createVueComponent("outline", "brand-amazon", "BrandAmazon", [["path", { "d": "M17 12.5a15.198 15.198 0 0 1 -7.37 1.44a14.62 14.62 0 0 1 -6.63 -2.94", "key": "svg-0" }], ["path", { "d": "M19.5 15c.907 -1.411 1.451 -3.323 1.5 -5c-1.197 -.773 -2.577 -.935 -4 -1", "key": "svg-1" }]]);

var IconBrandAmd = createVueComponent("outline", "brand-amd", "BrandAmd", [["path", { "d": "M16 16v-7c0 -.566 -.434 -1 -1 -1h-7l-5 -5h17c.566 0 1 .434 1 1v17l-5 -5z", "key": "svg-0" }], ["path", { "d": "M11.293 20.707l4.707 -4.707h-7a1 1 0 0 1 -1 -1v-7l-4.707 4.707a1 1 0 0 0 -.293 .707v6.586a1 1 0 0 0 1 1h6.586a1 1 0 0 0 .707 -.293z", "key": "svg-1" }]]);

var IconBrandAmie = createVueComponent("outline", "brand-amie", "BrandAmie", [["path", { "d": "M3 8.5c0 1.33 .472 2.55 1.257 3.5a5.5 5.5 0 0 0 7.743 7.743a5.5 5.5 0 0 0 7.743 -7.743a5.5 5.5 0 0 0 -7.743 -7.743a5.5 5.5 0 0 0 -9 4.243", "key": "svg-0" }], ["path", { "d": "M10 9.5c0 -.828 .895 -1.5 2 -1.5s2 .672 2 1.5v5c0 .828 -.895 1.5 -2 1.5s-2 -.672 -2 -1.5z", "key": "svg-1" }]]);

var IconBrandAmigo = createVueComponent("outline", "brand-amigo", "BrandAmigo", [["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M9.591 3.635l-7.13 14.082c-1.712 3.38 1.759 5.45 3.69 3.573l1.86 -1.81c3.142 -3.054 4.959 -2.99 8.039 .11l1.329 1.337c2.372 2.387 5.865 .078 4.176 -3.225l-7.195 -14.067c-1.114 -2.18 -3.666 -2.18 -4.77 0z", "key": "svg-1" }]]);

var IconBrandAmongUs = createVueComponent("outline", "brand-among-us", "BrandAmongUs", [["path", { "d": "M10.646 12.774c-1.939 .396 -4.467 .317 -6.234 -.601c-2.454 -1.263 -1.537 -4.66 1.423 -4.982c2.254 -.224 3.814 -.354 5.65 .214c.835 .256 1.93 .569 1.355 3.281c-.191 1.067 -1.07 1.904 -2.194 2.088z", "key": "svg-0" }], ["path", { "d": "M5.84 7.132c.083 -.564 .214 -1.12 .392 -1.661c.456 -.936 1.095 -2.068 3.985 -2.456a22.464 22.464 0 0 1 2.867 .08c1.776 .14 2.643 1.234 3.287 3.368c.339 1.157 .46 2.342 .629 3.537v11l-12.704 -.019c-.552 -2.386 -.262 -5.894 .204 -8.481", "key": "svg-1" }], ["path", { "d": "M17 10c.991 .163 2.105 .383 3.069 .67c.255 .13 .52 .275 .534 .505c.264 3.434 .57 7.448 .278 9.825h-3.881", "key": "svg-2" }]]);

var IconBrandAndroid = createVueComponent("outline", "brand-android", "BrandAndroid", [["path", { "d": "M4 10l0 6", "key": "svg-0" }], ["path", { "d": "M20 10l0 6", "key": "svg-1" }], ["path", { "d": "M7 9h10v8a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-8a5 5 0 0 1 10 0", "key": "svg-2" }], ["path", { "d": "M8 3l1 2", "key": "svg-3" }], ["path", { "d": "M16 3l-1 2", "key": "svg-4" }], ["path", { "d": "M9 18l0 3", "key": "svg-5" }], ["path", { "d": "M15 18l0 3", "key": "svg-6" }]]);

var IconBrandAngular = createVueComponent("outline", "brand-angular", "BrandAngular", [["path", { "d": "M5.428 17.245l6.076 3.471a1 1 0 0 0 .992 0l6.076 -3.471a1 1 0 0 0 .495 -.734l1.323 -9.704a1 1 0 0 0 -.658 -1.078l-7.4 -2.612a1 1 0 0 0 -.665 0l-7.399 2.613a1 1 0 0 0 -.658 1.078l1.323 9.704a1 1 0 0 0 .495 .734z", "key": "svg-0" }], ["path", { "d": "M9 15l3 -8l3 8", "key": "svg-1" }], ["path", { "d": "M10 13h4", "key": "svg-2" }]]);

var IconBrandAnsible = createVueComponent("outline", "brand-ansible", "BrandAnsible", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9.647 12.294l6.353 3.706l-4 -9l-4 9", "key": "svg-1" }]]);

var IconBrandAo3 = createVueComponent("outline", "brand-ao3", "BrandAo3", [["path", { "d": "M2 5c7.109 4.1 10.956 10.131 12 14c1.074 -4.67 4.49 -8.94 8 -11", "key": "svg-0" }], ["path", { "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 9c-.278 5.494 -2.337 7.33 -4 10c4.013 -2 6.02 -5 15.05 -5c4.012 0 3.51 2.5 1 3c2 .5 2.508 5 -2.007 2", "key": "svg-2" }]]);

var IconBrandAppgallery = createVueComponent("outline", "brand-appgallery", "BrandAppgallery", [["path", { "d": "M4 4m0 4a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M9 8a3 3 0 0 0 6 0", "key": "svg-1" }]]);

var IconBrandAppleArcade = createVueComponent("outline", "brand-apple-arcade", "BrandAppleArcade", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M20 12.5v4.75a.734 .734 0 0 1 -.055 .325a.704 .704 0 0 1 -.348 .366l-5.462 2.58a5 5 0 0 1 -4.27 0l-5.462 -2.58a.705 .705 0 0 1 -.401 -.691l0 -4.75", "key": "svg-1" }], ["path", { "d": "M4.431 12.216l5.634 -2.332a5.065 5.065 0 0 1 3.87 0l5.634 2.332a.692 .692 0 0 1 .028 1.269l-5.462 2.543a5.064 5.064 0 0 1 -4.27 0l-5.462 -2.543a.691 .691 0 0 1 .028 -1.27z", "key": "svg-2" }], ["path", { "d": "M12 7l0 6", "key": "svg-3" }]]);

var IconBrandAppleNews = createVueComponent("outline", "brand-apple-news", "BrandAppleNews", [["path", { "d": "M4 14l6 6h-6z", "key": "svg-0" }], ["path", { "d": "M20 10l-6 -6h6z", "key": "svg-1" }], ["path", { "d": "M4 4v4l12 12h4v-4l-12 -12z", "key": "svg-2" }]]);

var IconBrandApplePodcast = createVueComponent("outline", "brand-apple-podcast", "BrandApplePodcast", [["path", { "d": "M18.364 18.364a9 9 0 1 0 -12.728 0", "key": "svg-0" }], ["path", { "d": "M11.766 22h.468a2 2 0 0 0 1.985 -1.752l.5 -4a2 2 0 0 0 -1.985 -2.248h-1.468a2 2 0 0 0 -1.985 2.248l.5 4a2 2 0 0 0 1.985 1.752z", "key": "svg-1" }], ["path", { "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconBrandApple = createVueComponent("outline", "brand-apple", "BrandApple", [["path", { "d": "M8.286 7.008c-3.216 0 -4.286 3.23 -4.286 5.92c0 3.229 2.143 8.072 4.286 8.072c1.165 -.05 1.799 -.538 3.214 -.538c1.406 0 1.607 .538 3.214 .538s4.286 -3.229 4.286 -5.381c-.03 -.011 -2.649 -.434 -2.679 -3.23c-.02 -2.335 2.589 -3.179 2.679 -3.228c-1.096 -1.606 -3.162 -2.113 -3.75 -2.153c-1.535 -.12 -3.032 1.077 -3.75 1.077c-.729 0 -2.036 -1.077 -3.214 -1.077z", "key": "svg-0" }], ["path", { "d": "M12 4a2 2 0 0 0 2 -2a2 2 0 0 0 -2 2", "key": "svg-1" }]]);

var IconBrandAppstore = createVueComponent("outline", "brand-appstore", "BrandAppstore", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 16l1.106 -1.99m1.4 -2.522l2.494 -4.488", "key": "svg-1" }], ["path", { "d": "M7 14h5m2.9 0h2.1", "key": "svg-2" }], ["path", { "d": "M16 16l-2.51 -4.518m-1.487 -2.677l-1 -1.805", "key": "svg-3" }]]);

var IconBrandArc = createVueComponent("outline", "brand-arc", "BrandArc", [["path", { "d": "M4.687 14.694l-.987 2.103c-.502 1.07 -.125 2.387 .908 2.945c1.096 .59 2.444 .13 2.972 -.995l.9 -1.92", "key": "svg-0" }], ["path", { "d": "M18.317 14.576c1.818 -1.6 3.16 -3.78 3.64 -6.217c.235 -1.194 -.525 -2.351 -1.695 -2.586a2.14 2.14 0 0 0 -1.625 .326c-.478 .323 -.81 .826 -.922 1.398c-.208 1.054 -.695 2.037 -1.366 2.872", "key": "svg-1" }], ["path", { "d": "M12.68 12.759a5.4 5.4 0 0 1 -1.283 .157c-.336 0 -.683 -.04 -1.03 -.115c-1.44 -.31 -2.89 -1.215 -3.709 -2.315a3.7 3.7 0 0 1 -.487 -.853a2.157 2.157 0 0 0 -2.818 -1.213c-1.107 .455 -1.641 1.736 -1.196 2.86c.508 1.278 1.404 2.45 2.53 3.415a11.2 11.2 0 0 0 3.791 2.133c.953 .31 1.942 .483 2.916 .483a9.8 9.8 0 0 0 3.162 -.537", "key": "svg-2" }], ["path", { "d": "M10.37 12.801l.943 -2.013c.09 -.19 .357 -.19 .446 0l.923 1.97h.006h-.006l1.88 4.015l.923 1.971a2.16 2.16 0 0 0 1.957 1.254q .29 0 .576 -.081c1.303 -.365 1.92 -1.887 1.339 -3.129l-1.04 -2.218l-1.968 -4.204l-.003 .003l.003 -.003l-2.862 -6.112a2.16 2.16 0 0 0 -1.954 -1.254c-.833 0 -1.593 .488 -1.953 1.254l-2.92 6.232", "key": "svg-3" }]]);

var IconBrandAsana = createVueComponent("outline", "brand-asana", "BrandAsana", [["path", { "d": "M12 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M7 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }]]);

var IconBrandAstro = createVueComponent("outline", "brand-astro", "BrandAstro", [["path", { "d": "M14.972 3.483c.163 .196 .247 .46 .413 .987l3.64 11.53a15.5 15.5 0 0 0 -4.352 -1.42l-2.37 -7.723a.31 .31 0 0 0 -.296 -.213a.31 .31 0 0 0 -.295 .214l-2.342 7.718a15.5 15.5 0 0 0 -4.37 1.422l3.657 -11.53c.168 -.527 .251 -.79 .415 -.986c.144 -.172 .331 -.306 .544 -.388c.242 -.094 .527 -.094 1.099 -.094h2.612c.572 0 .858 0 1.1 .094c.213 .082 .4 .217 .545 .39", "key": "svg-0" }], ["path", { "d": "M9 18c0 1.5 2 3 3 4c1 -1 3 -3 3 -4q -3 1.5 -6 0", "key": "svg-1" }]]);

var IconBrandAuth0 = createVueComponent("outline", "brand-auth0", "BrandAuth0", [["path", { "d": "M12 14.5l-5.5 3.5l2 -6l-4.5 -4h6l2 -5l2 5h6l-4.5 4l2 6z", "key": "svg-0" }], ["path", { "d": "M20.507 8.872l-2.01 -5.872h-12.994l-2.009 5.872c-1.242 3.593 -.135 7.094 3.249 9.407l5.257 3.721l5.257 -3.721c3.385 -2.313 4.49 -5.814 3.25 -9.407z", "key": "svg-1" }]]);

var IconBrandAws = createVueComponent("outline", "brand-aws", "BrandAws", [["path", { "d": "M17 18.5a15.198 15.198 0 0 1 -7.37 1.44a14.62 14.62 0 0 1 -6.63 -2.94", "key": "svg-0" }], ["path", { "d": "M19.5 21c.907 -1.411 1.451 -3.323 1.5 -5c-1.197 -.773 -2.577 -.935 -4 -1", "key": "svg-1" }], ["path", { "d": "M3 11v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-2" }], ["path", { "d": "M3 9h3", "key": "svg-3" }], ["path", { "d": "M9 5l1.2 6l1.8 -4l1.8 4l1.2 -6", "key": "svg-4" }], ["path", { "d": "M18 10.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-5" }]]);

var IconBrandAzure = createVueComponent("outline", "brand-azure", "BrandAzure", [["path", { "d": "M6 7.5l-4 9.5h4l6 -15z", "key": "svg-0" }], ["path", { "d": "M22 20l-7 -15l-3 7l4 5l-8 3z", "key": "svg-1" }]]);

var IconBrandBackbone = createVueComponent("outline", "brand-backbone", "BrandBackbone", [["path", { "d": "M5 20l14 -8l-14 -8z", "key": "svg-0" }], ["path", { "d": "M19 20l-14 -8l14 -8z", "key": "svg-1" }]]);

var IconBrandBadoo = createVueComponent("outline", "brand-badoo", "BrandBadoo", [["path", { "d": "M22 9.43c0 5.838 -4.477 10.57 -10 10.57s-10 -4.662 -10 -10.5c0 -2.667 1.83 -5.01 4.322 -5.429c2.492 -.418 4.9 1.392 5.678 3.929c.768 -2.54 3.177 -4.354 5.668 -3.931c2.495 .417 4.332 2.69 4.332 5.36z", "key": "svg-0" }], ["path", { "d": "M7.5 10c0 2.761 2.015 5 4.5 5s4.5 -2.239 4.5 -5", "key": "svg-1" }]]);

var IconBrandBaidu = createVueComponent("outline", "brand-baidu", "BrandBaidu", [["path", { "d": "M5 9.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M14.463 11.596c1.282 1.774 3.476 3.416 3.476 3.416s1.921 1.574 .593 3.636c-1.328 2.063 -4.892 1.152 -4.892 1.152s-1.416 -.44 -3.06 -.088c-1.644 .356 -3.06 .22 -3.06 .22s-2.055 -.22 -2.47 -2.304c-.416 -2.084 1.918 -3.638 2.102 -3.858c.182 -.222 1.409 -.966 2.284 -2.394c.875 -1.428 3.337 -2.287 5.027 .221z", "key": "svg-1" }], ["path", { "d": "M9 4.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M15 4.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M19 9.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-4" }]]);

var IconBrandBandcamp = createVueComponent("outline", "brand-bandcamp", "BrandBandcamp", [["path", { "d": "M8.5 6h13.5l-7 12h-13z", "key": "svg-0" }]]);

var IconBrandBandlab = createVueComponent("outline", "brand-bandlab", "BrandBandlab", [["path", { "d": "M6.885 7l-2.536 4.907c-2.021 3.845 -2.499 8.775 3.821 9.093h6.808c4.86 -.207 7.989 -2.975 4.607 -9.093l-2.988 -4.907", "key": "svg-0" }], ["path", { "d": "M15.078 4h-5.136l3.678 8.768c.547 1.14 .847 1.822 .162 2.676c-.053 .093 -1.332 1.907 -3.053 1.495c-.825 -.187 -1.384 -.926 -1.32 -1.74c.04 -.91 .62 -1.717 1.488 -2.074a4.463 4.463 0 0 1 2.723 -.358", "key": "svg-1" }]]);

var IconBrandBeats = createVueComponent("outline", "brand-beats", "BrandBeats", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12.5 12.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-1" }], ["path", { "d": "M9 12v-8", "key": "svg-2" }]]);

var IconBrandBebo = createVueComponent("outline", "brand-bebo", "BrandBebo", [["path", { "d": "M12 17.5a3.5 3.5 0 0 0 3.5 -3.5c0 -1.838 -1.159 -3.002 -3.005 -3.372c-.746 -.15 -1.37 -.745 -1.37 -1.506c0 -1.142 .934 -2.095 2.058 -1.894c3.61 .645 5.817 3.058 5.817 6.772a7 7 0 1 1 -14 0v-9.25a1.75 1.75 0 1 1 3.5 0v9.25a3.5 3.5 0 0 0 3.5 3.5", "key": "svg-0" }]]);

var IconBrandBehance = createVueComponent("outline", "brand-behance", "BrandBehance", [["path", { "d": "M3 18v-12h4.5a3 3 0 0 1 0 6a3 3 0 0 1 0 6h-4.5", "key": "svg-0" }], ["path", { "d": "M3 12l4.5 0", "key": "svg-1" }], ["path", { "d": "M14 13h7a3.5 3.5 0 0 0 -7 0v2a3.5 3.5 0 0 0 6.64 1", "key": "svg-2" }], ["path", { "d": "M16 6l3 0", "key": "svg-3" }]]);

var IconBrandBilibili = createVueComponent("outline", "brand-bilibili", "BrandBilibili", [["path", { "d": "M3 10a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v6a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4v-6z", "key": "svg-0" }], ["path", { "d": "M8 3l2 3", "key": "svg-1" }], ["path", { "d": "M16 3l-2 3", "key": "svg-2" }], ["path", { "d": "M9 13v-2", "key": "svg-3" }], ["path", { "d": "M15 11v2", "key": "svg-4" }]]);

var IconBrandBinance = createVueComponent("outline", "brand-binance", "BrandBinance", [["path", { "d": "M6 8l2 2l4 -4l4 4l2 -2l-6 -6z", "key": "svg-0" }], ["path", { "d": "M6 16l2 -2l4 4l3.5 -3.5l2 2l-5.5 5.5z", "key": "svg-1" }], ["path", { "d": "M20 10l2 2l-2 2l-2 -2z", "key": "svg-2" }], ["path", { "d": "M4 10l2 2l-2 2l-2 -2z", "key": "svg-3" }], ["path", { "d": "M12 10l2 2l-2 2l-2 -2z", "key": "svg-4" }]]);

var IconBrandBing = createVueComponent("outline", "brand-bing", "BrandBing", [["path", { "d": "M5 3l4 1.5v12l6 -2.5l-2 -1l-1 -4l7 2.5v4.5l-10 5l-4 -2z", "key": "svg-0" }]]);

var IconBrandBitbucket = createVueComponent("outline", "brand-bitbucket", "BrandBitbucket", [["path", { "d": "M3.648 4a.64 .64 0 0 0 -.64 .744l3.14 14.528c.07 .417 .43 .724 .852 .728h10a.644 .644 0 0 0 .642 -.539l3.35 -14.71a.641 .641 0 0 0 -.64 -.744l-16.704 -.007z", "key": "svg-0" }], ["path", { "d": "M14 15h-4l-1 -6h6z", "key": "svg-1" }]]);

var IconBrandBlackberry = createVueComponent("outline", "brand-blackberry", "BrandBlackberry", [["path", { "d": "M7 6a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-0" }], ["path", { "d": "M6 12a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-1" }], ["path", { "d": "M13 12a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-2" }], ["path", { "d": "M14 6a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-3" }], ["path", { "d": "M12 18a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-4" }], ["path", { "d": "M20 15a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-5" }], ["path", { "d": "M21 9a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-6" }]]);

var IconBrandBlender = createVueComponent("outline", "brand-blender", "BrandBlender", [["path", { "d": "M15 14m-6 0a6 5 0 1 0 12 0a6 5 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M15 14m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M3 16l9 -6.5", "key": "svg-2" }], ["path", { "d": "M6 9h9", "key": "svg-3" }], ["path", { "d": "M13 5l5.65 5", "key": "svg-4" }]]);

var IconBrandBlogger = createVueComponent("outline", "brand-blogger", "BrandBlogger", [["path", { "d": "M8 21h8a5 5 0 0 0 5 -5v-3a3 3 0 0 0 -3 -3h-1v-2a5 5 0 0 0 -5 -5h-4a5 5 0 0 0 -5 5v8a5 5 0 0 0 5 5z", "key": "svg-0" }], ["path", { "d": "M7 7m0 1.5a1.5 1.5 0 0 1 1.5 -1.5h3a1.5 1.5 0 0 1 1.5 1.5v0a1.5 1.5 0 0 1 -1.5 1.5h-3a1.5 1.5 0 0 1 -1.5 -1.5z", "key": "svg-1" }], ["path", { "d": "M7 14m0 1.5a1.5 1.5 0 0 1 1.5 -1.5h7a1.5 1.5 0 0 1 1.5 1.5v0a1.5 1.5 0 0 1 -1.5 1.5h-7a1.5 1.5 0 0 1 -1.5 -1.5z", "key": "svg-2" }]]);

var IconBrandBluesky = createVueComponent("outline", "brand-bluesky", "BrandBluesky", [["path", { "d": "M6.335 5.144c-1.654 -1.199 -4.335 -2.127 -4.335 .826c0 .59 .35 4.953 .556 5.661c.713 2.463 3.13 2.75 5.444 2.369c-4.045 .665 -4.889 3.208 -2.667 5.41c1.03 1.018 1.913 1.59 2.667 1.59c2 0 3.134 -2.769 3.5 -3.5c.333 -.667 .5 -1.167 .5 -1.5c0 .333 .167 .833 .5 1.5c.366 .731 1.5 3.5 3.5 3.5c.754 0 1.637 -.571 2.667 -1.59c2.222 -2.203 1.378 -4.746 -2.667 -5.41c2.314 .38 4.73 .094 5.444 -2.369c.206 -.708 .556 -5.072 .556 -5.661c0 -2.953 -2.68 -2.025 -4.335 -.826c-2.293 1.662 -4.76 5.048 -5.665 6.856c-.905 -1.808 -3.372 -5.194 -5.665 -6.856z", "key": "svg-0" }]]);

var IconBrandBooking = createVueComponent("outline", "brand-booking", "BrandBooking", [["path", { "d": "M4 18v-9.5a4.5 4.5 0 0 1 4.5 -4.5h7a4.5 4.5 0 0 1 4.5 4.5v7a4.5 4.5 0 0 1 -4.5 4.5h-9.5a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 12h3.5a2 2 0 1 1 0 4h-3.5v-7a1 1 0 0 1 1 -1h1.5a2 2 0 1 1 0 4h-1.5", "key": "svg-1" }], ["path", { "d": "M16 16l.01 0", "key": "svg-2" }]]);

var IconBrandBootstrap = createVueComponent("outline", "brand-bootstrap", "BrandBootstrap", [["path", { "d": "M2 12a2 2 0 0 0 2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2", "key": "svg-0" }], ["path", { "d": "M2 12a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-4a2 2 0 0 1 2 -2", "key": "svg-1" }], ["path", { "d": "M9 16v-8h3.5a2 2 0 1 1 0 4h-3.5h4a2 2 0 1 1 0 4h-4z", "key": "svg-2" }]]);

var IconBrandBulma = createVueComponent("outline", "brand-bulma", "BrandBulma", [["path", { "d": "M5 16l1 -9l5 -5l6.5 6l-3.5 4l5 5l-8 5z", "key": "svg-0" }]]);

var IconBrandBumble = createVueComponent("outline", "brand-bumble", "BrandBumble", [["path", { "d": "M7 12h10", "key": "svg-0" }], ["path", { "d": "M9 8h6", "key": "svg-1" }], ["path", { "d": "M10 16h4", "key": "svg-2" }], ["path", { "d": "M16.268 3h-8.536a1.46 1.46 0 0 0 -1.268 .748l-4.268 7.509a1.507 1.507 0 0 0 0 1.486l4.268 7.509c.26 .462 .744 .747 1.268 .748h8.536a1.46 1.46 0 0 0 1.268 -.748l4.268 -7.509a1.507 1.507 0 0 0 0 -1.486l-4.268 -7.509a1.46 1.46 0 0 0 -1.268 -.748z", "key": "svg-3" }]]);

var IconBrandBunpo = createVueComponent("outline", "brand-bunpo", "BrandBunpo", [["path", { "d": "M3.9 7.205a17.764 17.764 0 0 0 4.008 2.753a7.917 7.917 0 0 0 4.57 .567c1.5 -.33 2.907 -1 4.121 -1.956a12.107 12.107 0 0 0 2.892 -2.903c.603 -.94 .745 -1.766 .484 -2.231c-.261 -.465 -.927 -.568 -1.72 -.257a7.564 7.564 0 0 0 -2.608 2.034a18.425 18.425 0 0 0 -2.588 3.884a34.927 34.927 0 0 0 -2.093 5.073a12.908 12.908 0 0 0 -.677 3.515c-.07 .752 .07 1.51 .405 2.184c.323 .562 1.06 1.132 2.343 1.132c3.474 0 5.093 -3.53 5.463 -5.62c.24 -1.365 -.085 -3.197 -1.182 -4.01", "key": "svg-0" }]]);

var IconBrandCSharp = createVueComponent("outline", "brand-c-sharp", "BrandCSharp", [["path", { "d": "M10 9a3 3 0 0 0 -3 -3h-.5a3.5 3.5 0 0 0 -3.5 3.5v5a3.5 3.5 0 0 0 3.5 3.5h.5a3 3 0 0 0 3 -3", "key": "svg-0" }], ["path", { "d": "M16 7l-1 10", "key": "svg-1" }], ["path", { "d": "M20 7l-1 10", "key": "svg-2" }], ["path", { "d": "M14 10h7.5", "key": "svg-3" }], ["path", { "d": "M21 14h-7.5", "key": "svg-4" }]]);

var IconBrandCake = createVueComponent("outline", "brand-cake", "BrandCake", [["path", { "d": "M20.84 12c0 2.05 .985 3.225 -.04 5c-1.026 1.775 -2.537 1.51 -4.314 2.534c-1.776 1.026 -2.302 2.466 -4.353 2.466c-2.051 0 -2.576 -1.441 -4.353 -2.466c-1.776 -1.024 -3.288 -.759 -4.314 -2.534c-1.025 -1.775 -.04 -2.95 -.04 -5s-.985 -3.225 .04 -5c1.026 -1.775 2.537 -1.51 4.314 -2.534c1.776 -1.026 2.302 -2.466 4.353 -2.466s2.577 1.441 4.353 2.466c1.776 1.024 3.288 .759 4.313 2.534c1.026 1.775 .04 2.95 .04 5z", "key": "svg-0" }]]);

var IconBrandCakephp = createVueComponent("outline", "brand-cakephp", "BrandCakephp", [["path", { "d": "M12 11l8 2c1.361 -.545 2 -1.248 2 -2v-3.8c0 -1.765 -4.479 -3.2 -10.002 -3.2c-5.522 0 -9.998 1.435 -9.998 3.2v2.8c0 1.766 4.478 4 10 4v-3z", "key": "svg-0" }], ["path", { "d": "M12 14v3l8 2c1.362 -.547 2 -1.246 2 -2v-3c0 .754 -.638 1.453 -2 2l-8 -2z", "key": "svg-1" }], ["path", { "d": "M2 17c0 1.766 4.476 3 9.998 3l.002 -3c-5.522 0 -10 -1.734 -10 -3.5v3.5z", "key": "svg-2" }], ["path", { "d": "M2 10v4", "key": "svg-3" }], ["path", { "d": "M22 10v4", "key": "svg-4" }]]);

var IconBrandCampaignmonitor = createVueComponent("outline", "brand-campaignmonitor", "BrandCampaignmonitor", [["path", { "d": "M3 18l9 -6.462l-9 -5.538v12h18v-12l-9 5.538", "key": "svg-0" }]]);

var IconBrandCarbon = createVueComponent("outline", "brand-carbon", "BrandCarbon", [["path", { "d": "M14 10v-.2a1.8 1.8 0 0 0 -1.8 -1.8h-.4a1.8 1.8 0 0 0 -1.8 1.8v4.4a1.8 1.8 0 0 0 1.8 1.8h.4a1.8 1.8 0 0 0 1.8 -1.8v-.2", "key": "svg-0" }], ["path", { "d": "M3 3m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z", "key": "svg-1" }]]);

var IconBrandCashapp = createVueComponent("outline", "brand-cashapp", "BrandCashapp", [["path", { "d": "M17.1 8.648a.568 .568 0 0 1 -.761 .011a5.682 5.682 0 0 0 -3.659 -1.34c-1.102 0 -2.205 .363 -2.205 1.374c0 1.023 1.182 1.364 2.546 1.875c2.386 .796 4.363 1.796 4.363 4.137c0 2.545 -1.977 4.295 -5.204 4.488l-.295 1.364a.557 .557 0 0 1 -.546 .443h-2.034l-.102 -.011a.568 .568 0 0 1 -.432 -.67l.318 -1.444a7.432 7.432 0 0 1 -3.273 -1.784v-.011a.545 .545 0 0 1 0 -.773l1.137 -1.102c.214 -.2 .547 -.2 .761 0a5.495 5.495 0 0 0 3.852 1.5c1.478 0 2.466 -.625 2.466 -1.614c0 -.989 -1 -1.25 -2.886 -1.954c-2 -.716 -3.898 -1.728 -3.898 -4.091c0 -2.75 2.284 -4.091 4.989 -4.216l.284 -1.398a.545 .545 0 0 1 .545 -.432h2.023l.114 .012a.544 .544 0 0 1 .42 .647l-.307 1.557a8.528 8.528 0 0 1 2.818 1.58l.023 .022c.216 .228 .216 .569 0 .773l-1.057 1.057z", "key": "svg-0" }]]);

var IconBrandChrome = createVueComponent("outline", "brand-chrome", "BrandChrome", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M12 9h8.4", "key": "svg-2" }], ["path", { "d": "M14.598 13.5l-4.2 7.275", "key": "svg-3" }], ["path", { "d": "M9.402 13.5l-4.2 -7.275", "key": "svg-4" }]]);

var IconBrandCinema4d = createVueComponent("outline", "brand-cinema-4d", "BrandCinema4d", [["path", { "d": "M9.65 6.956a5.39 5.39 0 0 0 7.494 7.495", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }], ["path", { "d": "M17.7 12.137a5.738 5.738 0 1 1 -5.737 -5.737", "key": "svg-2" }], ["path", { "d": "M17.7 12.338v-1.175c0 -.47 .171 -.92 .476 -1.253a1.56 1.56 0 0 1 1.149 -.52c.827 0 1.523 .676 1.62 1.573c.037 .344 .055 .69 .055 1.037", "key": "svg-3" }], ["path", { "d": "M11.662 6.4h1.175c.47 0 .92 -.176 1.253 -.49c.333 -.314 .52 -.74 .52 -1.184c0 -.852 -.676 -1.57 -1.573 -1.67a9.496 9.496 0 0 0 -1.037 -.056", "key": "svg-4" }]]);

var IconBrandCitymapper = createVueComponent("outline", "brand-citymapper", "BrandCitymapper", [["path", { "d": "M3 11a1 1 0 1 1 -1 1.013a1 1 0 0 1 1 -1v-.013z", "key": "svg-0" }], ["path", { "d": "M21 11a1 1 0 1 1 -1 1.013a1 1 0 0 1 1 -1v-.013z", "key": "svg-1" }], ["path", { "d": "M8 12h8", "key": "svg-2" }], ["path", { "d": "M13 9l3 3l-3 3", "key": "svg-3" }]]);

var IconBrandCloudflare = createVueComponent("outline", "brand-cloudflare", "BrandCloudflare", [["path", { "d": "M13.031 7.007c2.469 -.007 3.295 1.293 3.969 2.993c4 0 4.994 3.825 5 6h-20c-.001 -1.64 1.36 -2.954 3 -3c0 -1.5 1 -3 3 -3c.66 -1.942 2.562 -2.986 5.031 -2.993z", "key": "svg-0" }], ["path", { "d": "M12 13h6", "key": "svg-1" }], ["path", { "d": "M17 10l-2.5 6", "key": "svg-2" }]]);

var IconBrandCodecov = createVueComponent("outline", "brand-codecov", "BrandCodecov", [["path", { "d": "M9.695 12.985a5.972 5.972 0 0 0 -3.295 -.985c-1.257 0 -2.436 .339 -3.4 1a9 9 0 1 1 18 0c-.966 -.664 -2.14 -1 -3.4 -1a6 6 0 0 0 -5.605 8.144", "key": "svg-0" }]]);

var IconBrandCodepen = createVueComponent("outline", "brand-codepen", "BrandCodepen", [["path", { "d": "M3 15l9 6l9 -6l-9 -6l-9 6", "key": "svg-0" }], ["path", { "d": "M3 9l9 6l9 -6l-9 -6l-9 6", "key": "svg-1" }], ["path", { "d": "M3 9l0 6", "key": "svg-2" }], ["path", { "d": "M21 9l0 6", "key": "svg-3" }], ["path", { "d": "M12 3l0 6", "key": "svg-4" }], ["path", { "d": "M12 15l0 6", "key": "svg-5" }]]);

var IconBrandCodesandbox = createVueComponent("outline", "brand-codesandbox", "BrandCodesandbox", [["path", { "d": "M20 7.5v9l-4 2.25l-4 2.25l-4 -2.25l-4 -2.25v-9l4 -2.25l4 -2.25l4 2.25z", "key": "svg-0" }], ["path", { "d": "M12 12l4 -2.25l4 -2.25", "key": "svg-1" }], ["path", { "d": "M12 12l0 9", "key": "svg-2" }], ["path", { "d": "M12 12l-4 -2.25l-4 -2.25", "key": "svg-3" }], ["path", { "d": "M20 12l-4 2v4.75", "key": "svg-4" }], ["path", { "d": "M4 12l4 2l0 4.75", "key": "svg-5" }], ["path", { "d": "M8 5.25l4 2.25l4 -2.25", "key": "svg-6" }]]);

var IconBrandCohost = createVueComponent("outline", "brand-cohost", "BrandCohost", [["path", { "d": "M17 14m-3 0a3 2 0 1 0 6 0a3 2 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M4.526 17.666c-1.133 -.772 -1.897 -1.924 -2.291 -3.456c-.398 -1.54 -.29 -2.937 .32 -4.19c.61 -1.255 1.59 -2.34 2.938 -3.254c1.348 -.914 2.93 -1.625 4.749 -2.132c1.81 -.504 3.516 -.708 5.12 -.61c1.608 .1 2.979 .537 4.112 1.31s1.897 1.924 2.291 3.456c.398 1.541 .29 2.938 -.32 4.192c-.61 1.253 -1.59 2.337 -2.938 3.252c-1.348 .915 -2.93 1.626 -4.749 2.133c-1.81 .503 -3.516 .707 -5.12 .61c-1.608 -.102 -2.979 -.538 -4.112 -1.31z", "key": "svg-1" }], ["path", { "d": "M11 12.508c-.53 -.316 -1.23 -.508 -2 -.508c-1.657 0 -3 .895 -3 2s1.343 2 3 2c.767 0 1.467 -.192 2 -.508", "key": "svg-2" }]]);

var IconBrandCoinbase = createVueComponent("outline", "brand-coinbase", "BrandCoinbase", [["path", { "d": "M12.95 22c-4.503 0 -8.445 -3.04 -9.61 -7.413c-1.165 -4.373 .737 -8.988 4.638 -11.25a9.906 9.906 0 0 1 12.008 1.598l-3.335 3.367a5.185 5.185 0 0 0 -7.354 .013a5.252 5.252 0 0 0 0 7.393a5.185 5.185 0 0 0 7.354 .013l3.349 3.367a9.887 9.887 0 0 1 -7.05 2.912z", "key": "svg-0" }]]);

var IconBrandComedyCentral = createVueComponent("outline", "brand-comedy-central", "BrandComedyCentral", [["path", { "d": "M5.343 17.657a8 8 0 1 0 0 -11.314", "key": "svg-0" }], ["path", { "d": "M13.828 9.172a4 4 0 1 0 0 5.656", "key": "svg-1" }]]);

var IconBrandCoreos = createVueComponent("outline", "brand-coreos", "BrandCoreos", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M12 3c-3.263 3.212 -3 7.654 -3 12c4.59 .244 8.814 -.282 12 -3", "key": "svg-1" }], ["path", { "d": "M9.5 9a4.494 4.494 0 0 1 5.5 5.5", "key": "svg-2" }]]);

var IconBrandCouchdb = createVueComponent("outline", "brand-couchdb", "BrandCouchdb", [["path", { "d": "M6 12h12v-2a2 2 0 0 1 2 -2a2 2 0 0 0 -2 -2h-12a2 2 0 0 0 -2 2a2 2 0 0 1 2 2v2z", "key": "svg-0" }], ["path", { "d": "M6 15h12", "key": "svg-1" }], ["path", { "d": "M6 18h12", "key": "svg-2" }], ["path", { "d": "M21 11v7", "key": "svg-3" }], ["path", { "d": "M3 11v7", "key": "svg-4" }]]);

var IconBrandCouchsurfing = createVueComponent("outline", "brand-couchsurfing", "BrandCouchsurfing", [["path", { "d": "M3.1 13c3.267 0 5.9 -.167 7.9 -.5c3 -.5 4 -2 4 -3.5a3 3 0 1 0 -6 0c0 1.554 1.807 3 3 4c1.193 1 2 2.5 2 3.5a1.5 1.5 0 1 1 -3 0c0 -2 4 -3.5 7 -3.5h2.9", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandCpp = createVueComponent("outline", "brand-cpp", "BrandCpp", [["path", { "d": "M18 12h4", "key": "svg-0" }], ["path", { "d": "M20 10v4", "key": "svg-1" }], ["path", { "d": "M11 12h4", "key": "svg-2" }], ["path", { "d": "M13 10v4", "key": "svg-3" }], ["path", { "d": "M9 9a3 3 0 0 0 -3 -3h-.5a3.5 3.5 0 0 0 -3.5 3.5v5a3.5 3.5 0 0 0 3.5 3.5h.5a3 3 0 0 0 3 -3", "key": "svg-4" }]]);

var IconBrandCraft = createVueComponent("outline", "brand-craft", "BrandCraft", [["path", { "d": "M20 4h-8a8 8 0 1 0 0 16h8a8 8 0 0 0 -8 -8a8 8 0 0 0 8 -8", "key": "svg-0" }], ["path", { "d": "M4 12h8", "key": "svg-1" }], ["path", { "d": "M12 4v16", "key": "svg-2" }]]);

var IconBrandCrunchbase = createVueComponent("outline", "brand-crunchbase", "BrandCrunchbase", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M10.414 11.586a2 2 0 1 0 0 2.828", "key": "svg-1" }], ["path", { "d": "M15 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M13 7v6", "key": "svg-3" }]]);

var IconBrandCss3 = createVueComponent("outline", "brand-css3", "BrandCss3", [["path", { "d": "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z", "key": "svg-0" }], ["path", { "d": "M8.5 8h7l-4.5 4h4l-.5 3.5l-2.5 .75l-2.5 -.75l-.1 -.5", "key": "svg-1" }]]);

var IconBrandCtemplar = createVueComponent("outline", "brand-ctemplar", "BrandCtemplar", [["path", { "d": "M6.04 14.831l4.46 -4.331", "key": "svg-0" }], ["path", { "d": "M12.555 20.82c4.55 -3.456 7.582 -8.639 8.426 -14.405a1.668 1.668 0 0 0 -.934 -1.767a19.647 19.647 0 0 0 -8.047 -1.648a19.647 19.647 0 0 0 -8.047 1.647a1.668 1.668 0 0 0 -.934 1.767c.844 5.766 3.875 10.95 8.426 14.406a.948 .948 0 0 0 1.11 0z", "key": "svg-1" }], ["path", { "d": "M20 5c-2 0 -4.37 3.304 -8 6.644c-3.63 -3.34 -6 -6.644 -8 -6.644", "key": "svg-2" }], ["path", { "d": "M17.738 15l-4.238 -4.5", "key": "svg-3" }]]);

var IconBrandCucumber = createVueComponent("outline", "brand-cucumber", "BrandCucumber", [["path", { "d": "M20 10.99c-.01 5.52 -4.48 10 -10 10.01v-2.26l-.01 -.01c-4.28 -1.11 -6.86 -5.47 -5.76 -9.75a8 8 0 0 1 9.74 -5.76c3.53 .91 6.03 4.13 6.03 7.78v-.01z", "key": "svg-0" }], ["path", { "d": "M10.5 8l-.5 -1", "key": "svg-1" }], ["path", { "d": "M13.5 14l.5 1", "key": "svg-2" }], ["path", { "d": "M9 12.5l-1 .5", "key": "svg-3" }], ["path", { "d": "M11 14l-.5 1", "key": "svg-4" }], ["path", { "d": "M13 8l.5 -1", "key": "svg-5" }], ["path", { "d": "M16 12.5l-1 -.5", "key": "svg-6" }], ["path", { "d": "M9 10l-1 -.5", "key": "svg-7" }]]);

var IconBrandCupra = createVueComponent("outline", "brand-cupra", "BrandCupra", [["path", { "d": "M4.5 10l-2.5 -4l15.298 6.909a.2 .2 0 0 1 .09 .283l-3.388 5.808", "key": "svg-0" }], ["path", { "d": "M10 19l-3.388 -5.808a.2 .2 0 0 1 .09 -.283l15.298 -6.909l-2.5 4", "key": "svg-1" }]]);

var IconBrandCypress = createVueComponent("outline", "brand-cypress", "BrandCypress", [["path", { "d": "M19.48 17.007a9 9 0 1 0 -7.48 3.993c.896 0 1.691 -.573 1.974 -1.423l3.526 -10.577", "key": "svg-0" }], ["path", { "d": "M13.5 9l2 6", "key": "svg-1" }], ["path", { "d": "M10.764 9.411a3 3 0 1 0 -.023 5.19", "key": "svg-2" }]]);

var IconBrandD3 = createVueComponent("outline", "brand-d3", "BrandD3", [["path", { "d": "M3 4h1.8c3.976 0 7.2 3.582 7.2 8s-3.224 8 -7.2 8h-1.8", "key": "svg-0" }], ["path", { "d": "M12 4h5.472c1.948 0 3.528 1.79 3.528 4s-1.58 4 -3.528 4", "key": "svg-1" }], ["path", { "d": "M17.472 12h-2.472", "key": "svg-2" }], ["path", { "d": "M17.472 12h-2.352", "key": "svg-3" }], ["path", { "d": "M17.472 12c1.948 0 3.528 1.79 3.528 4s-1.58 4 -3.528 4h-5.472", "key": "svg-4" }]]);

var IconBrandDatabricks = createVueComponent("outline", "brand-databricks", "BrandDatabricks", [["path", { "d": "M3 17l9 5l9 -5v-3l-9 5l-9 -5v-3l9 5l9 -5v-3l-9 5l-9 -5l9 -5l5.418 3.01", "key": "svg-0" }]]);

var IconBrandDaysCounter = createVueComponent("outline", "brand-days-counter", "BrandDaysCounter", [["path", { "d": "M20.779 10.007a9 9 0 1 0 -10.77 10.772", "key": "svg-0" }], ["path", { "d": "M13 21h8v-7", "key": "svg-1" }], ["path", { "d": "M12 8v4l3 3", "key": "svg-2" }]]);

var IconBrandDcos = createVueComponent("outline", "brand-dcos", "BrandDcos", [["path", { "d": "M3 18l18 -12h-18l9 14l9 -14v10l-18 -10z", "key": "svg-0" }]]);

var IconBrandDebian = createVueComponent("outline", "brand-debian", "BrandDebian", [["path", { "d": "M12 17c-2.397 -.943 -4 -3.153 -4 -5.635c0 -2.19 1.039 -3.14 1.604 -3.595c2.646 -2.133 6.396 -.27 6.396 3.23c0 2.5 -2.905 2.121 -3.5 1.5c-.595 -.621 -1 -1.5 -.5 -2.5", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandDeezer = createVueComponent("outline", "brand-deezer", "BrandDeezer", [["path", { "d": "M3 16.5h2v.5h-2z", "key": "svg-0" }], ["path", { "d": "M8 16.5h2.5v.5h-2.5z", "key": "svg-1" }], ["path", { "d": "M16 17h-2.5v-.5h2.5z", "key": "svg-2" }], ["path", { "d": "M21.5 17h-2.5v-.5h2.5z", "key": "svg-3" }], ["path", { "d": "M21.5 13h-2.5v.5h2.5z", "key": "svg-4" }], ["path", { "d": "M21.5 9.5h-2.5v.5h2.5z", "key": "svg-5" }], ["path", { "d": "M21.5 6h-2.5v.5h2.5z", "key": "svg-6" }], ["path", { "d": "M16 13h-2.5v.5h2.5z", "key": "svg-7" }], ["path", { "d": "M8 13.5h2.5v-.5h-2.5z", "key": "svg-8" }], ["path", { "d": "M8 9.5h2.5v.5h-2.5z", "key": "svg-9" }]]);

var IconBrandDeliveroo = createVueComponent("outline", "brand-deliveroo", "BrandDeliveroo", [["path", { "d": "M15 11l1 -9l5 .5l-1 13.5l-3 6l-12.5 -2.5l-1.5 -6l7 -1.5l-1.5 -7.5l4.5 -1z", "key": "svg-0" }], ["circle", { "cx": "15.5", "cy": "15.5", "r": "1", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "11.5", "cy": "14.5", "r": "1", "fill": "currentColor", "key": "svg-2" }]]);

var IconBrandDeno = createVueComponent("outline", "brand-deno", "BrandDeno", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M13.47 20.882l-1.47 -5.882c-2.649 -.088 -5 -1.624 -5 -3.5c0 -1.933 2.239 -3.5 5 -3.5s4 1 5 3c.024 .048 .69 2.215 2 6.5", "key": "svg-1" }], ["path", { "d": "M12 11h.01", "key": "svg-2" }]]);

var IconBrandDenodo = createVueComponent("outline", "brand-denodo", "BrandDenodo", [["path", { "d": "M11 11h2v2h-2z", "key": "svg-0" }], ["path", { "d": "M3.634 15.634l1.732 -1l1 1.732l-1.732 1z", "key": "svg-1" }], ["path", { "d": "M11 19h2v2h-2z", "key": "svg-2" }], ["path", { "d": "M18.634 14.634l1.732 1l-1 1.732l-1.732 -1z", "key": "svg-3" }], ["path", { "d": "M17.634 7.634l1.732 -1l1 1.732l-1.732 1z", "key": "svg-4" }], ["path", { "d": "M11 3h2v2h-2z", "key": "svg-5" }], ["path", { "d": "M3.634 8.366l1 -1.732l1.732 1l-1 1.732z", "key": "svg-6" }]]);

var IconBrandDeviantart = createVueComponent("outline", "brand-deviantart", "BrandDeviantart", [["path", { "d": "M18 3v4l-3.857 6h3.857v4h-6.429l-2.571 4h-3v-4l3.857 -6h-3.857v-4h6.429l2.571 -4z", "key": "svg-0" }]]);

var IconBrandDigg = createVueComponent("outline", "brand-digg", "BrandDigg", [["path", { "d": "M6 15h-3v-4h3", "key": "svg-0" }], ["path", { "d": "M15 15h-3v-4h3", "key": "svg-1" }], ["path", { "d": "M9 15v-4", "key": "svg-2" }], ["path", { "d": "M15 11v7h-3", "key": "svg-3" }], ["path", { "d": "M6 7v8", "key": "svg-4" }], ["path", { "d": "M21 15h-3v-4h3", "key": "svg-5" }], ["path", { "d": "M21 11v7h-3", "key": "svg-6" }]]);

var IconBrandDingtalk = createVueComponent("outline", "brand-dingtalk", "BrandDingtalk", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M8 7.5l7.02 2.632a1 1 0 0 1 .567 1.33l-1.087 2.538h1.5l-5 4l1 -4c-3.1 .03 -3.114 -3.139 -4 -6.5z", "key": "svg-1" }]]);

var IconBrandDiscord = createVueComponent("outline", "brand-discord", "BrandDiscord", [["path", { "d": "M8 12a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-0" }], ["path", { "d": "M14 12a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-1" }], ["path", { "d": "M15.5 17c0 1 1.5 3 2 3c1.5 0 2.833 -1.667 3.5 -3c.667 -1.667 .5 -5.833 -1.5 -11.5c-1.457 -1.015 -3 -1.34 -4.5 -1.5l-.972 1.923a11.913 11.913 0 0 0 -4.053 0l-.975 -1.923c-1.5 .16 -3.043 .485 -4.5 1.5c-2 5.667 -2.167 9.833 -1.5 11.5c.667 1.333 2 3 3.5 3c.5 0 2 -2 2 -3", "key": "svg-2" }], ["path", { "d": "M7 16.5c3.5 1 6.5 1 10 0", "key": "svg-3" }]]);

var IconBrandDisney = createVueComponent("outline", "brand-disney", "BrandDisney", [["path", { "d": "M3.22 5.838c-1.307 -.15 -1.22 -.578 -1.22 -.794c0 -.216 .424 -1.044 4.34 -1.044c4.694 0 14.66 3.645 14.66 10.042s-8.71 4.931 -10.435 4.52c-1.724 -.412 -5.565 -2.256 -5.565 -4.174c0 -1.395 3.08 -2.388 6.715 -2.388c3.634 0 5.285 1.041 5.285 2c0 .5 -.074 1.229 -1 1.5", "key": "svg-0" }], ["path", { "d": "M10.02 8a505.153 505.153 0 0 0 0 13", "key": "svg-1" }]]);

var IconBrandDisqus = createVueComponent("outline", "brand-disqus", "BrandDisqus", [["path", { "d": "M11.847 21c-2.259 0 -4.323 -.667 -5.919 -2h-3.928l1.708 -3.266c-.545 -1.174 -.759 -2.446 -.758 -3.734c0 -4.97 3.84 -9 8.898 -9c5.052 0 9.152 4.03 9.152 9c0 4.972 -4.098 9 -9.153 9z", "key": "svg-0" }], ["path", { "d": "M11.485 15h-1.485v-6h1.485c2.112 0 3.515 .823 3.515 2.981v.035c0 2.18 -1.403 2.984 -3.515 2.984z", "key": "svg-1" }]]);

var IconBrandDjango = createVueComponent("outline", "brand-django", "BrandDjango", [["path", { "d": "M3 3m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M12 7v8.5l-2.015 .201a2.715 2.715 0 1 1 0 -5.402l2.015 .201", "key": "svg-1" }], ["path", { "d": "M16 7v.01", "key": "svg-2" }], ["path", { "d": "M16 10v5.586c0 .905 -.36 1.774 -1 2.414", "key": "svg-3" }]]);

var IconBrandDocker = createVueComponent("outline", "brand-docker", "BrandDocker", [["path", { "d": "M22 12.54c-1.804 -.345 -2.701 -1.08 -3.523 -2.94c-.487 .696 -1.102 1.568 -.92 2.4c.028 .238 -.32 1 -.557 1h-14c0 5.208 3.164 7 6.196 7c4.124 .022 7.828 -1.376 9.854 -5c1.146 -.101 2.296 -1.505 2.95 -2.46z", "key": "svg-0" }], ["path", { "d": "M5 10h3v3h-3z", "key": "svg-1" }], ["path", { "d": "M8 10h3v3h-3z", "key": "svg-2" }], ["path", { "d": "M11 10h3v3h-3z", "key": "svg-3" }], ["path", { "d": "M8 7h3v3h-3z", "key": "svg-4" }], ["path", { "d": "M11 7h3v3h-3z", "key": "svg-5" }], ["path", { "d": "M11 4h3v3h-3z", "key": "svg-6" }], ["path", { "d": "M4.571 18c1.5 0 2.047 -.074 2.958 -.78", "key": "svg-7" }], ["path", { "d": "M10 16l0 .01", "key": "svg-8" }]]);

var IconBrandDoctrine = createVueComponent("outline", "brand-doctrine", "BrandDoctrine", [["path", { "d": "M12 14m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M9 14h6", "key": "svg-1" }], ["path", { "d": "M12 11l3 3l-3 3", "key": "svg-2" }], ["path", { "d": "M10 3l6.9 6", "key": "svg-3" }]]);

var IconBrandDolbyDigital = createVueComponent("outline", "brand-dolby-digital", "BrandDolbyDigital", [["path", { "d": "M21 6v12h-.89c-3.34 0 -6.047 -2.686 -6.047 -6s2.707 -6 6.046 -6h.891z", "key": "svg-0" }], ["path", { "d": "M3.063 6v12h.891c3.34 0 6.046 -2.686 6.046 -6s-2.707 -6 -6.046 -6h-.89z", "key": "svg-1" }]]);

var IconBrandDouban = createVueComponent("outline", "brand-douban", "BrandDouban", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M5 4h14", "key": "svg-1" }], ["path", { "d": "M8 8h8a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-2a2 2 0 0 1 2 -2z", "key": "svg-2" }], ["path", { "d": "M16 14l-2 6", "key": "svg-3" }], ["path", { "d": "M8 17l1 3", "key": "svg-4" }]]);

var IconBrandDribbble = createVueComponent("outline", "brand-dribbble", "BrandDribbble", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 3.6c5 6 7 10.5 7.5 16.2", "key": "svg-1" }], ["path", { "d": "M6.4 19c3.5 -3.5 6 -6.5 14.5 -6.4", "key": "svg-2" }], ["path", { "d": "M3.1 10.75c5 0 9.814 -.38 15.314 -5", "key": "svg-3" }]]);

var IconBrandDropbox = createVueComponent("outline", "brand-dropbox", "BrandDropbox", [["path", { "d": "M7.5 10.625l-4.5 -2.813l4.5 -2.812l4.5 2.813m-4.5 2.812l4.5 -2.813m-4.5 2.813l-4.5 2.823l4.5 2.802m0 -5.625l4.5 2.823m0 -5.636l4.5 2.791l4.5 -2.812l-4.5 -2.791l-4.5 2.813zm-4.5 8.438l4.5 -2.802m-4.5 2.802v1.123l4.5 2.627l4.5 -2.627v-1.123m-4.5 -2.802l4.5 -2.823l4.5 2.823l-4.5 2.802m-4.5 -2.802l4.5 2.802", "key": "svg-0" }]]);

var IconBrandDrops = createVueComponent("outline", "brand-drops", "BrandDrops", [["path", { "d": "M17.637 7.416a7.907 7.907 0 0 1 1.76 8.666a8 8 0 0 1 -7.397 4.918a8 8 0 0 1 -7.396 -4.918a7.907 7.907 0 0 1 1.759 -8.666l5.637 -5.416l5.637 5.416z", "key": "svg-0" }], ["path", { "d": "M14.466 10.923a3.595 3.595 0 0 1 .77 3.877a3.5 3.5 0 0 1 -3.236 2.2a3.5 3.5 0 0 1 -3.236 -2.2a3.595 3.595 0 0 1 .77 -3.877l2.466 -2.423l2.466 2.423z", "key": "svg-1" }]]);

var IconBrandDrupal = createVueComponent("outline", "brand-drupal", "BrandDrupal", [["path", { "d": "M12 2c0 4.308 -7 6 -7 12a7 7 0 0 0 14 0c0 -6 -7 -7.697 -7 -12z", "key": "svg-0" }], ["path", { "d": "M12 11.33a65.753 65.753 0 0 1 -2.012 2.023c-1 .957 -1.988 1.967 -1.988 3.647c0 2.17 1.79 4 4 4s4 -1.827 4 -4c0 -1.676 -.989 -2.685 -1.983 -3.642c-.42 -.404 -2.259 -2.357 -5.517 -5.858l3.5 3.83z", "key": "svg-1" }]]);

var IconBrandEdge = createVueComponent("outline", "brand-edge", "BrandEdge", [["path", { "d": "M20.978 11.372a9 9 0 1 0 -1.593 5.773", "key": "svg-0" }], ["path", { "d": "M20.978 11.372c.21 2.993 -5.034 2.413 -6.913 1.486c1.392 -1.6 .402 -4.038 -2.274 -3.851c-1.745 .122 -2.927 1.157 -2.784 3.202c.28 3.99 4.444 6.205 10.36 4.79", "key": "svg-1" }], ["path", { "d": "M3.022 12.628c-.283 -4.043 8.717 -7.228 11.248 -2.688", "key": "svg-2" }], ["path", { "d": "M12.628 20.978c-2.993 .21 -5.162 -4.725 -3.567 -9.748", "key": "svg-3" }]]);

var IconBrandElastic = createVueComponent("outline", "brand-elastic", "BrandElastic", [["path", { "d": "M14 2a5 5 0 0 1 5 5c0 .712 -.232 1.387 -.5 2c1.894 .042 3.5 1.595 3.5 3.5c0 1.869 -1.656 3.4 -3.5 3.5c.333 .625 .5 1.125 .5 1.5a2.5 2.5 0 0 1 -2.5 2.5c-.787 0 -1.542 -.432 -2 -1c-.786 1.73 -2.476 3 -4.5 3a5 5 0 0 1 -4.583 -7a3.5 3.5 0 0 1 -.11 -6.992l.195 0a2.5 2.5 0 0 1 2 -4c.787 0 1.542 .432 2 1c.786 -1.73 2.476 -3 4.5 -3z", "key": "svg-0" }], ["path", { "d": "M8.5 9l-3 -1", "key": "svg-1" }], ["path", { "d": "M9.5 5l-1 4l1 2l5 2l4 -4", "key": "svg-2" }], ["path", { "d": "M18.499 16l-3 -.5l-1 -2.5", "key": "svg-3" }], ["path", { "d": "M14.5 19l1 -3.5", "key": "svg-4" }], ["path", { "d": "M5.417 15l4.083 -4", "key": "svg-5" }]]);

var IconBrandElectronicArts = createVueComponent("outline", "brand-electronic-arts", "BrandElectronicArts", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M17.5 15l-3 -6l-3 6h-5l1.5 -3", "key": "svg-1" }], ["path", { "d": "M17 14h-2", "key": "svg-2" }], ["path", { "d": "M6.5 12h3.5", "key": "svg-3" }], ["path", { "d": "M8 9h3", "key": "svg-4" }]]);

var IconBrandEmber = createVueComponent("outline", "brand-ember", "BrandEmber", [["path", { "d": "M3 12.958c8.466 1.647 11.112 -1.196 12.17 -2.294c2.116 -2.196 0 -6.589 -2.646 -5.49c-2.644 1.096 -6.35 7.686 -3.174 12.078c2.116 2.928 6 2.178 11.65 -2.252", "key": "svg-0" }]]);

var IconBrandEnvato = createVueComponent("outline", "brand-envato", "BrandEnvato", [["path", { "d": "M4.711 17.875c-.534 -1.339 -1.35 -4.178 .129 -6.47c1.415 -2.193 3.769 -3.608 5.099 -4.278l-5.229 10.748z", "key": "svg-0" }], ["path", { "d": "M19.715 12.508c-.54 3.409 -2.094 6.156 -4.155 7.348c-4.069 2.353 -8.144 .45 -9.297 -.188c.877 -1.436 4.433 -7.22 6.882 -10.591c2.714 -3.737 5.864 -5.978 6.565 -6.077c0 .201 .03 .55 .071 1.03c.144 1.709 .443 5.264 -.066 8.478z", "key": "svg-1" }]]);

var IconBrandEtsy = createVueComponent("outline", "brand-etsy", "BrandEtsy", [["path", { "d": "M14 12h-5", "key": "svg-0" }], ["path", { "d": "M3 3m0 5a5 5 0 0 1 5 -5h8a5 5 0 0 1 5 5v8a5 5 0 0 1 -5 5h-8a5 5 0 0 1 -5 -5z", "key": "svg-1" }], ["path", { "d": "M15 16h-5a1 1 0 0 1 -1 -1v-6a1 1 0 0 1 1 -1h5", "key": "svg-2" }]]);

var IconBrandEvernote = createVueComponent("outline", "brand-evernote", "BrandEvernote", [["path", { "d": "M4 8h5v-5", "key": "svg-0" }], ["path", { "d": "M17.9 19c.6 -2.5 1.1 -5.471 1.1 -9c0 -4.5 -2 -5 -3 -5c-1.906 0 -3 -.5 -3.5 -1c-.354 -.354 -.5 -1 -1.5 -1h-2l-5 5c0 6 2.5 8 5 8c1 0 1.5 -.5 2 -1.5s1.414 -.326 2.5 0c1.044 .313 2.01 .255 2.5 .5c1 .5 2 1.5 2 3c0 .5 0 3 -3 3s-3 -3 -1 -3", "key": "svg-1" }], ["path", { "d": "M15 10h1", "key": "svg-2" }]]);

var IconBrandFacebook = createVueComponent("outline", "brand-facebook", "BrandFacebook", [["path", { "d": "M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3", "key": "svg-0" }]]);

var IconBrandFeedly = createVueComponent("outline", "brand-feedly", "BrandFeedly", [["path", { "d": "M7.833 12.278l4.445 -4.445", "key": "svg-0" }], ["path", { "d": "M10.055 14.5l2.223 -2.222", "key": "svg-1" }], ["path", { "d": "M12.278 16.722l.555 -.555", "key": "svg-2" }], ["path", { "d": "M19.828 14.828a4 4 0 0 0 0 -5.656l-5 -5a4 4 0 0 0 -5.656 0l-5 5a4 4 0 0 0 0 5.656l6.171 6.172h3.314l6.171 -6.172z", "key": "svg-3" }]]);

var IconBrandFigma = createVueComponent("outline", "brand-figma", "BrandFigma", [["path", { "d": "M15 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M6 3m0 3a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v0a3 3 0 0 1 -3 3h-6a3 3 0 0 1 -3 -3z", "key": "svg-1" }], ["path", { "d": "M9 9a3 3 0 0 0 0 6h3m-3 0a3 3 0 1 0 3 3v-15", "key": "svg-2" }]]);

var IconBrandFilezilla = createVueComponent("outline", "brand-filezilla", "BrandFilezilla", [["path", { "d": "M16 15.824a4.062 4.062 0 0 1 -2.25 .033c-.738 -.201 -2.018 -.08 -2.75 .143l4.583 -5h-6.583", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }], ["path", { "d": "M8 15l2 -8h5", "key": "svg-2" }]]);

var IconBrandFinder = createVueComponent("outline", "brand-finder", "BrandFinder", [["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 8v1", "key": "svg-1" }], ["path", { "d": "M17 8v1", "key": "svg-2" }], ["path", { "d": "M12.5 4c-.654 1.486 -1.26 3.443 -1.5 9h2.5c-.19 2.867 .094 5.024 .5 7", "key": "svg-3" }], ["path", { "d": "M7 15.5c3.667 2 6.333 2 10 0", "key": "svg-4" }]]);

var IconBrandFirebase = createVueComponent("outline", "brand-firebase", "BrandFirebase", [["path", { "d": "M4.53 17.05l6.15 -11.72h-.02c.38 -.74 1.28 -1.02 2.01 -.63c.26 .14 .48 .36 .62 .62l1.06 2.01", "key": "svg-0" }], ["path", { "d": "M15.47 6.45c.58 -.59 1.53 -.59 2.11 -.01c.22 .22 .36 .5 .41 .81l1.5 9.11c.1 .62 -.2 1.24 -.76 1.54l-6.07 2.9c-.46 .25 -1.01 .26 -1.46 0l-6.02 -2.92c-.55 -.31 -.85 -.92 -.75 -1.54l1.96 -12.04c.12 -.82 .89 -1.38 1.7 -1.25c.46 .07 .87 .36 1.09 .77l1.24 1.76", "key": "svg-1" }], ["path", { "d": "M4.57 17.18l10.93 -10.68", "key": "svg-2" }]]);

var IconBrandFirefox = createVueComponent("outline", "brand-firefox", "BrandFirefox", [["path", { "d": "M4.028 7.82a9 9 0 1 0 12.823 -3.4c-1.636 -1.02 -3.064 -1.02 -4.851 -1.02h-1.647", "key": "svg-0" }], ["path", { "d": "M4.914 9.485c-1.756 -1.569 -.805 -5.38 .109 -6.17c.086 .896 .585 1.208 1.111 1.685c.88 -.275 1.313 -.282 1.867 0c.82 -.91 1.694 -2.354 2.628 -2.093c-1.082 1.741 -.07 3.733 1.371 4.173c-.17 .975 -1.484 1.913 -2.76 2.686c-1.296 .938 -.722 1.85 0 2.234c.949 .506 3.611 -1 4.545 .354c-1.698 .102 -1.536 3.107 -3.983 2.727c2.523 .957 4.345 .462 5.458 -.34c1.965 -1.52 2.879 -3.542 2.879 -5.557c-.014 -1.398 .194 -2.695 -1.26 -4.75", "key": "svg-1" }]]);

var IconBrandFiverr = createVueComponent("outline", "brand-fiverr", "BrandFiverr", [["path", { "d": "M15 3h-2a6 6 0 0 0 -6 6h-3v4h3v8h4v-7h4v7h4v-11h-8v-1.033a1.967 1.967 0 0 1 2 -1.967h2v-4z", "key": "svg-0" }]]);

var IconBrandFlickr = createVueComponent("outline", "brand-flickr", "BrandFlickr", [["path", { "d": "M7 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }]]);

var IconBrandFlightradar24 = createVueComponent("outline", "brand-flightradar24", "BrandFlightradar24", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-1" }], ["path", { "d": "M8.5 20l3.5 -8l-6.5 6", "key": "svg-2" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }]]);

var IconBrandFlipboard = createVueComponent("outline", "brand-flipboard", "BrandFlipboard", [["path", { "d": "M3.973 3h16.054c.537 0 .973 .436 .973 .973v4.052a.973 .973 0 0 1 -.973 .973h-5.025v4.831c0 .648 -.525 1.173 -1.173 1.173h-4.829v5.025a.973 .973 0 0 1 -.974 .973h-4.053a.973 .973 0 0 1 -.973 -.973v-16.054c0 -.537 .436 -.973 .973 -.973z", "key": "svg-0" }]]);

var IconBrandFlutter = createVueComponent("outline", "brand-flutter", "BrandFlutter", [["path", { "d": "M7 14l-3 -3l8 -8h6z", "key": "svg-0" }], ["path", { "d": "M14 21l-5 -5l5 -5h5l-5 5l5 5z", "key": "svg-1" }]]);

var IconBrandFortnite = createVueComponent("outline", "brand-fortnite", "BrandFortnite", [["path", { "d": "M8 3h7.5l-.5 4h-3v3h3v3.5h-3v6.5l-4 1z", "key": "svg-0" }]]);

var IconBrandFoursquare = createVueComponent("outline", "brand-foursquare", "BrandFoursquare", [["path", { "d": "M7 3h10c.644 0 1.11 .696 .978 1.33l-1.984 9.859a1.014 1.014 0 0 1 -1 .811h-2.254c-.308 0 -.6 .141 -.793 .382l-4.144 5.25c-.599 .752 -1.809 .331 -1.809 -.632v-16c0 -.564 .44 -1 1 -1z", "key": "svg-0" }], ["path", { "d": "M12 9l5 0", "key": "svg-1" }]]);

var IconBrandFramerMotion = createVueComponent("outline", "brand-framer-motion", "BrandFramerMotion", [["path", { "d": "M12 12l-8 -8v16l16 -16v16l-4 -4", "key": "svg-0" }], ["path", { "d": "M20 12l-8 8l-4 -4", "key": "svg-1" }]]);

var IconBrandFramer = createVueComponent("outline", "brand-framer", "BrandFramer", [["path", { "d": "M6 15h12l-12 -12h12v6h-12v6l6 6v-6", "key": "svg-0" }]]);

var IconBrandFunimation = createVueComponent("outline", "brand-funimation", "BrandFunimation", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 13h8a4 4 0 1 1 -8 0z", "key": "svg-1" }]]);

var IconBrandGatsby = createVueComponent("outline", "brand-gatsby", "BrandGatsby", [["path", { "d": "M3.296 14.297l6.407 6.407a9.018 9.018 0 0 1 -6.325 -6.116l-.082 -.291z", "key": "svg-0" }], ["path", { "d": "M16 13h5c-.41 3.603 -3.007 6.59 -6.386 7.614l-11.228 -11.229a9 9 0 0 1 15.66 -2.985", "key": "svg-1" }]]);

var IconBrandGit = createVueComponent("outline", "brand-git", "BrandGit", [["path", { "d": "M16 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M12 15v-6", "key": "svg-3" }], ["path", { "d": "M15 11l-2 -2", "key": "svg-4" }], ["path", { "d": "M11 7l-1.9 -1.9", "key": "svg-5" }], ["path", { "d": "M13.446 2.6l7.955 7.954a2.045 2.045 0 0 1 0 2.892l-7.955 7.955a2.045 2.045 0 0 1 -2.892 0l-7.955 -7.955a2.045 2.045 0 0 1 0 -2.892l7.955 -7.955a2.045 2.045 0 0 1 2.892 0z", "key": "svg-6" }]]);

var IconBrandGithubCopilot = createVueComponent("outline", "brand-github-copilot", "BrandGithubCopilot", [["path", { "d": "M4 18v-5.5c0 -.667 .167 -1.333 .5 -2", "key": "svg-0" }], ["path", { "d": "M12 7.5c0 -1 -.01 -4.07 -4 -3.5c-3.5 .5 -4 2.5 -4 3.5c0 1.5 0 4 3 4c4 0 5 -2.5 5 -4z", "key": "svg-1" }], ["path", { "d": "M4 12c-1.333 .667 -2 1.333 -2 2c0 1 0 3 1.5 4c3 2 6.5 3 8.5 3s5.499 -1 8.5 -3c1.5 -1 1.5 -3 1.5 -4c0 -.667 -.667 -1.333 -2 -2", "key": "svg-2" }], ["path", { "d": "M20 18v-5.5c0 -.667 -.167 -1.333 -.5 -2", "key": "svg-3" }], ["path", { "d": "M12 7.5l0 -.297l.01 -.269l.027 -.298l.013 -.105l.033 -.215c.014 -.073 .029 -.146 .046 -.22l.06 -.223c.336 -1.118 1.262 -2.237 3.808 -1.873c2.838 .405 3.703 1.797 3.93 2.842l.036 .204c0 .033 .01 .066 .013 .098l.016 .185l0 .171l0 .49l-.015 .394l-.02 .271c-.122 1.366 -.655 2.845 -2.962 2.845c-3.256 0 -4.524 -1.656 -4.883 -3.081l-.053 -.242a3.865 3.865 0 0 1 -.036 -.235l-.021 -.227a3.518 3.518 0 0 1 -.007 -.215z", "key": "svg-4" }], ["path", { "d": "M10 15v2", "key": "svg-5" }], ["path", { "d": "M14 15v2", "key": "svg-6" }]]);

var IconBrandGithub = createVueComponent("outline", "brand-github", "BrandGithub", [["path", { "d": "M9 19c-4.3 1.4 -4.3 -2.5 -6 -3m12 5v-3.5c0 -1 .1 -1.4 -.5 -2c2.8 -.3 5.5 -1.4 5.5 -6a4.6 4.6 0 0 0 -1.3 -3.2a4.2 4.2 0 0 0 -.1 -3.2s-1.1 -.3 -3.5 1.3a12.3 12.3 0 0 0 -6.2 0c-2.4 -1.6 -3.5 -1.3 -3.5 -1.3a4.2 4.2 0 0 0 -.1 3.2a4.6 4.6 0 0 0 -1.3 3.2c0 4.6 2.7 5.7 5.5 6c-.6 .6 -.6 1.2 -.5 2v3.5", "key": "svg-0" }]]);

var IconBrandGitlab = createVueComponent("outline", "brand-gitlab", "BrandGitlab", [["path", { "d": "M21 14l-9 7l-9 -7l3 -11l3 7h6l3 -7z", "key": "svg-0" }]]);

var IconBrandGmail = createVueComponent("outline", "brand-gmail", "BrandGmail", [["path", { "d": "M16 20h3a1 1 0 0 0 1 -1v-14a1 1 0 0 0 -1 -1h-3v16z", "key": "svg-0" }], ["path", { "d": "M5 20h3v-16h-3a1 1 0 0 0 -1 1v14a1 1 0 0 0 1 1z", "key": "svg-1" }], ["path", { "d": "M16 4l-4 4l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 6.5l8 7.5l8 -7.5", "key": "svg-3" }]]);

var IconBrandGolang = createVueComponent("outline", "brand-golang", "BrandGolang", [["path", { "d": "M15.695 14.305c1.061 1.06 2.953 .888 4.226 -.384c1.272 -1.273 1.444 -3.165 .384 -4.226c-1.061 -1.06 -2.953 -.888 -4.226 .384c-1.272 1.273 -1.444 3.165 -.384 4.226z", "key": "svg-0" }], ["path", { "d": "M12.68 9.233c-1.084 -.497 -2.545 -.191 -3.591 .846c-1.284 1.273 -1.457 3.165 -.388 4.226c1.07 1.06 2.978 .888 4.261 -.384a3.669 3.669 0 0 0 1.038 -1.921h-2.427", "key": "svg-1" }], ["path", { "d": "M5.5 15h-1.5", "key": "svg-2" }], ["path", { "d": "M6 9h-2", "key": "svg-3" }], ["path", { "d": "M5 12h-3", "key": "svg-4" }]]);

var IconBrandGoogleAnalytics = createVueComponent("outline", "brand-google-analytics", "BrandGoogleAnalytics", [["path", { "d": "M10 9m0 1.105a1.105 1.105 0 0 1 1.105 -1.105h1.79a1.105 1.105 0 0 1 1.105 1.105v9.79a1.105 1.105 0 0 1 -1.105 1.105h-1.79a1.105 1.105 0 0 1 -1.105 -1.105z", "key": "svg-0" }], ["path", { "d": "M17 3m0 1.105a1.105 1.105 0 0 1 1.105 -1.105h1.79a1.105 1.105 0 0 1 1.105 1.105v15.79a1.105 1.105 0 0 1 -1.105 1.105h-1.79a1.105 1.105 0 0 1 -1.105 -1.105z", "key": "svg-1" }], ["path", { "d": "M5 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconBrandGoogleBigQuery = createVueComponent("outline", "brand-google-big-query", "BrandGoogleBigQuery", [["path", { "d": "M17.73 19.875a2.225 2.225 0 0 1 -1.948 1.125h-7.283a2.222 2.222 0 0 1 -1.947 -1.158l-4.272 -6.75a2.269 2.269 0 0 1 0 -2.184l4.272 -6.75a2.225 2.225 0 0 1 1.946 -1.158h7.285c.809 0 1.554 .443 1.947 1.158l3.98 6.75a2.33 2.33 0 0 1 0 2.25l-3.98 6.75v-.033z", "key": "svg-0" }], ["path", { "d": "M11.5 11.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-1" }], ["path", { "d": "M14 14l2 2", "key": "svg-2" }]]);

var IconBrandGoogleDrive = createVueComponent("outline", "brand-google-drive", "BrandGoogleDrive", [["path", { "d": "M12 10l-6 10l-3 -5l6 -10z", "key": "svg-0" }], ["path", { "d": "M9 15h12l-3 5h-12", "key": "svg-1" }], ["path", { "d": "M15 15l-6 -10h6l6 10z", "key": "svg-2" }]]);

var IconBrandGoogleFit = createVueComponent("outline", "brand-google-fit", "BrandGoogleFit", [["path", { "d": "M12 8.866l-2.733 -2.734a3.866 3.866 0 0 0 -5.467 5.467l2.733 2.734l5.467 5.467l8.202 -8.201a3.866 3.866 0 0 0 -5.469 -5.466l-8.201 8.2", "key": "svg-0" }]]);

var IconBrandGoogleHome = createVueComponent("outline", "brand-google-home", "BrandGoogleHome", [["path", { "d": "M19.072 21h-14.144a1.928 1.928 0 0 1 -1.928 -1.928v-6.857c0 -.512 .203 -1 .566 -1.365l7.07 -7.063a1.928 1.928 0 0 1 2.727 0l7.071 7.063c.363 .362 .566 .853 .566 1.365v6.857a1.928 1.928 0 0 1 -1.928 1.928z", "key": "svg-0" }], ["path", { "d": "M7 13v4h10v-4l-5 -5", "key": "svg-1" }], ["path", { "d": "M14.8 5.2l-11.8 11.8", "key": "svg-2" }], ["path", { "d": "M7 17v4", "key": "svg-3" }], ["path", { "d": "M17 17v4", "key": "svg-4" }]]);

var IconBrandGoogleMaps = createVueComponent("outline", "brand-google-maps", "BrandGoogleMaps", [["path", { "d": "M12 9.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M6.428 12.494l7.314 -9.252", "key": "svg-1" }], ["path", { "d": "M10.002 7.935l-2.937 -2.545", "key": "svg-2" }], ["path", { "d": "M17.693 6.593l-8.336 9.979", "key": "svg-3" }], ["path", { "d": "M17.591 6.376c.472 .907 .715 1.914 .709 2.935a7.263 7.263 0 0 1 -.72 3.18a19.085 19.085 0 0 1 -2.089 3c-.784 .933 -1.49 1.93 -2.11 2.98c-.314 .62 -.568 1.27 -.757 1.938c-.121 .36 -.277 .591 -.622 .591c-.315 0 -.463 -.136 -.626 -.593a10.595 10.595 0 0 0 -.779 -1.978a18.18 18.18 0 0 0 -1.423 -2.091c-.877 -1.184 -2.179 -2.535 -2.853 -4.071a7.077 7.077 0 0 1 -.621 -2.967a6.226 6.226 0 0 1 1.476 -4.055a6.25 6.25 0 0 1 4.811 -2.245a6.462 6.462 0 0 1 1.918 .284a6.255 6.255 0 0 1 3.686 3.092z", "key": "svg-4" }]]);

var IconBrandGoogleOne = createVueComponent("outline", "brand-google-one", "BrandGoogleOne", [["path", { "d": "M11 5v13.982a2 2 0 0 0 4 0v-13.982a2 2 0 1 0 -4 0z", "key": "svg-0" }], ["path", { "d": "M6.63 8.407a2.125 2.125 0 0 0 -.074 2.944c.77 .834 2.051 .869 2.862 .077l4.95 -4.834c.812 -.792 .846 -2.11 .076 -2.945a1.984 1.984 0 0 0 -2.861 -.077l-4.953 4.835z", "key": "svg-1" }]]);

var IconBrandGooglePhotos = createVueComponent("outline", "brand-google-photos", "BrandGooglePhotos", [["path", { "d": "M7.5 7c2.485 0 4.5 1.974 4.5 4.409v.591h-8.397a.61 .61 0 0 1 -.426 -.173a.585 .585 0 0 1 -.177 -.418c0 -2.435 2.015 -4.409 4.5 -4.409z", "key": "svg-0" }], ["path", { "d": "M16.5 17c-2.485 0 -4.5 -1.974 -4.5 -4.409v-.591h8.397c.333 0 .603 .265 .603 .591c0 2.435 -2.015 4.409 -4.5 4.409z", "key": "svg-1" }], ["path", { "d": "M7 16.5c0 -2.485 1.972 -4.5 4.405 -4.5h.595v8.392a.61 .61 0 0 1 -.173 .431a.584 .584 0 0 1 -.422 .177c-2.433 0 -4.405 -2.015 -4.405 -4.5z", "key": "svg-2" }], ["path", { "d": "M17 7.5c0 2.485 -1.972 4.5 -4.405 4.5h-.595v-8.397a.61 .61 0 0 1 .175 -.428a.584 .584 0 0 1 .42 -.175c2.433 0 4.405 2.015 4.405 4.5z", "key": "svg-3" }]]);

var IconBrandGooglePlay = createVueComponent("outline", "brand-google-play", "BrandGooglePlay", [["path", { "d": "M4 3.71v16.58a.7 .7 0 0 0 1.05 .606l14.622 -8.42a.55 .55 0 0 0 0 -.953l-14.622 -8.419a.7 .7 0 0 0 -1.05 .607z", "key": "svg-0" }], ["path", { "d": "M15 9l-10.5 11.5", "key": "svg-1" }], ["path", { "d": "M4.5 3.5l10.5 11.5", "key": "svg-2" }]]);

var IconBrandGooglePodcasts = createVueComponent("outline", "brand-google-podcasts", "BrandGooglePodcasts", [["path", { "d": "M12 3v2", "key": "svg-0" }], ["path", { "d": "M12 19v2", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }], ["path", { "d": "M8 17v2", "key": "svg-3" }], ["path", { "d": "M4 11v2", "key": "svg-4" }], ["path", { "d": "M20 11v2", "key": "svg-5" }], ["path", { "d": "M8 5v8", "key": "svg-6" }], ["path", { "d": "M16 7v-2", "key": "svg-7" }], ["path", { "d": "M16 19v-8", "key": "svg-8" }]]);

var IconBrandGoogle = createVueComponent("outline", "brand-google", "BrandGoogle", [["path", { "d": "M20.945 11a9 9 0 1 1 -3.284 -5.997l-2.655 2.392a5.5 5.5 0 1 0 2.119 6.605h-4.125v-3h7.945z", "key": "svg-0" }]]);

var IconBrandGrammarly = createVueComponent("outline", "brand-grammarly", "BrandGrammarly", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15.697 9.434a4.5 4.5 0 1 0 .217 4.788", "key": "svg-1" }], ["path", { "d": "M13.5 14h2.5v2.5", "key": "svg-2" }]]);

var IconBrandGraphql = createVueComponent("outline", "brand-graphql", "BrandGraphql", [["path", { "d": "M4 8l8 -5l8 5v8l-8 5l-8 -5z", "key": "svg-0" }], ["path", { "d": "M12 4l7.5 12h-15z", "key": "svg-1" }], ["path", { "d": "M11 3a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-2" }], ["path", { "d": "M11 21a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }], ["path", { "d": "M3 8a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-4" }], ["path", { "d": "M3 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-5" }], ["path", { "d": "M19 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-6" }], ["path", { "d": "M19 8a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-7" }]]);

var IconBrandGravatar = createVueComponent("outline", "brand-gravatar", "BrandGravatar", [["path", { "d": "M5.64 5.632a9 9 0 1 0 6.36 -2.632v7.714", "key": "svg-0" }]]);

var IconBrandGrindr = createVueComponent("outline", "brand-grindr", "BrandGrindr", [["path", { "d": "M13 13.282c0 .492 .784 1.718 2.102 1.718c1.318 0 2.898 -.966 2.898 -2.062c0 -.817 -.932 -.938 -1.409 -.938c-.228 0 -3.591 .111 -3.591 1.282z", "key": "svg-0" }], ["path", { "d": "M12 21c-2.984 0 -6.471 -2.721 -6.63 -2.982c-2.13 -3.49 -2.37 -13.703 -2.37 -13.703l1.446 -1.315c2.499 .39 5.023 .617 7.554 .68a58.626 58.626 0 0 0 7.554 -.68l1.446 1.315s-.24 10.213 -2.37 13.704c-.16 .26 -3.646 2.981 -6.63 2.981z", "key": "svg-1" }], ["path", { "d": "M11 13.282c0 .492 -.784 1.718 -2.102 1.718c-1.318 0 -2.898 -.966 -2.898 -2.062c0 -.817 .932 -.938 1.409 -.938c.228 0 3.591 .111 3.591 1.282z", "key": "svg-2" }]]);

var IconBrandGuardian = createVueComponent("outline", "brand-guardian", "BrandGuardian", [["path", { "d": "M14 13h6", "key": "svg-0" }], ["path", { "d": "M4 12c0 -9.296 9.5 -9 9.5 -9c-2.808 0 -4.5 4.373 -4.5 9s1.763 8.976 4.572 8.976c0 .023 -9.572 1.092 -9.572 -8.976z", "key": "svg-1" }], ["path", { "d": "M14.5 3c1.416 0 3.853 1.16 4.5 2v3.5", "key": "svg-2" }], ["path", { "d": "M15 13v8s2.77 -.37 4 -2v-6", "key": "svg-3" }], ["path", { "d": "M13.5 21h1.5", "key": "svg-4" }], ["path", { "d": "M13.5 3h1", "key": "svg-5" }]]);

var IconBrandGumroad = createVueComponent("outline", "brand-gumroad", "BrandGumroad", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M13.5 13h2.5v3", "key": "svg-1" }], ["path", { "d": "M15.024 9.382a4 4 0 1 0 -3.024 6.618c1.862 0 2.554 -1.278 3 -3", "key": "svg-2" }]]);

var IconBrandHackerrank = createVueComponent("outline", "brand-hackerrank", "BrandHackerrank", [["path", { "d": "M19.484 5.667c-1.146 -.904 -3.35 -2.394 -6.497 -3.429c-.484 -.159 -.725 -.238 -1.04 -.238c-.314 0 -.556 .08 -1.04 .238c-3.147 1.035 -5.35 2.525 -6.496 3.43c-.402 .317 -.604 .476 -.797 .816c-.194 .341 -.233 .62 -.309 1.178a33 33 0 0 0 -.305 4.338c0 1.742 .165 3.317 .305 4.338c.076 .558 .115 .837 .309 1.178c.193 .34 .395 .5 .797 .817c1.146 .904 3.35 2.394 6.497 3.429c.483 .159 .725 .238 1.04 .238c.314 0 .555 -.08 1.04 -.238c3.146 -1.035 5.35 -2.525 6.496 -3.43c.402 -.317 .603 -.476 .797 -.816c.194 -.341 .232 -.62 .309 -1.178c.14 -1.021 .305 -2.596 .305 -4.338s-.165 -3.317 -.305 -4.338c-.077 -.558 -.115 -.837 -.309 -1.178s-.395 -.5 -.797 -.817", "key": "svg-0" }], ["path", { "d": "M9 8v7", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M16 16h-2l1 1z", "key": "svg-3" }], ["path", { "d": "M8 8h2l-1 -1z", "key": "svg-4" }], ["path", { "d": "M15 9v7", "key": "svg-5" }]]);

var IconBrandHbo = createVueComponent("outline", "brand-hbo", "BrandHbo", [["path", { "d": "M2 16v-8", "key": "svg-0" }], ["path", { "d": "M6 8v8", "key": "svg-1" }], ["path", { "d": "M2 12h4", "key": "svg-2" }], ["path", { "d": "M9 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2v8z", "key": "svg-3" }], ["path", { "d": "M19 8a4 4 0 1 1 0 8a4 4 0 0 1 0 -8z", "key": "svg-4" }], ["path", { "d": "M19 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }]]);

var IconBrandHeadlessui = createVueComponent("outline", "brand-headlessui", "BrandHeadlessui", [["path", { "d": "M6.744 4.325l7.82 -1.267a4.456 4.456 0 0 1 5.111 3.686l1.267 7.82a4.456 4.456 0 0 1 -3.686 5.111l-7.82 1.267a4.456 4.456 0 0 1 -5.111 -3.686l-1.267 -7.82a4.456 4.456 0 0 1 3.686 -5.111z", "key": "svg-0" }], ["path", { "d": "M7.252 7.704l7.897 -1.28a1 1 0 0 1 1.147 .828l.36 2.223l-9.562 3.51l-.67 -4.134a1 1 0 0 1 .828 -1.147z", "key": "svg-1" }]]);

var IconBrandHexo = createVueComponent("outline", "brand-hexo", "BrandHexo", [["path", { "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z", "key": "svg-0" }], ["path", { "d": "M9 8v8", "key": "svg-1" }], ["path", { "d": "M15 8v8", "key": "svg-2" }], ["path", { "d": "M9 12h6", "key": "svg-3" }]]);

var IconBrandHipchat = createVueComponent("outline", "brand-hipchat", "BrandHipchat", [["path", { "d": "M17.802 17.292s.077 -.055 .2 -.149c1.843 -1.425 3 -3.49 3 -5.789c0 -4.286 -4.03 -7.764 -9 -7.764c-4.97 0 -9 3.478 -9 7.764c0 4.288 4.03 7.646 9 7.646c.424 0 1.12 -.028 2.088 -.084c1.262 .82 3.104 1.493 4.716 1.493c.499 0 .734 -.41 .414 -.828c-.486 -.596 -1.156 -1.551 -1.416 -2.29z", "key": "svg-0" }], ["path", { "d": "M7.5 13.5c2.5 2.5 6.5 2.5 9 0", "key": "svg-1" }]]);

var IconBrandHtml5 = createVueComponent("outline", "brand-html5", "BrandHtml5", [["path", { "d": "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z", "key": "svg-0" }], ["path", { "d": "M15.5 8h-7l.5 4h6l-.5 3.5l-2.5 .75l-2.5 -.75l-.1 -.5", "key": "svg-1" }]]);

var IconBrandInertia = createVueComponent("outline", "brand-inertia", "BrandInertia", [["path", { "d": "M12.5 8l4 4l-4 4h4.5l4 -4l-4 -4z", "key": "svg-0" }], ["path", { "d": "M3.5 8l4 4l-4 4h4.5l4 -4l-4 -4z", "key": "svg-1" }]]);

var IconBrandInstagram = createVueComponent("outline", "brand-instagram", "BrandInstagram", [["path", { "d": "M4 8a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M16.5 7.5v.01", "key": "svg-2" }]]);

var IconBrandIntercom = createVueComponent("outline", "brand-intercom", "BrandIntercom", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 8v3", "key": "svg-1" }], ["path", { "d": "M10 7v6", "key": "svg-2" }], ["path", { "d": "M14 7v6", "key": "svg-3" }], ["path", { "d": "M17 8v3", "key": "svg-4" }], ["path", { "d": "M7 15c4 2.667 6 2.667 10 0", "key": "svg-5" }]]);

var IconBrandItch = createVueComponent("outline", "brand-itch", "BrandItch", [["path", { "d": "M2 7v1c0 1.087 1.078 2 2 2c1.107 0 2 -.91 2 -2c0 1.09 .893 2 2 2s2 -.91 2 -2c0 1.09 .893 2 2 2s2 -.91 2 -2c0 1.09 .893 2 2 2s2 -.91 2 -2c0 1.09 .893 2 2 2c.922 0 2 -.913 2 -2v-1c-.009 -.275 -.538 -.964 -1.588 -2.068a3 3 0 0 0 -2.174 -.932h-12.476a3 3 0 0 0 -2.174 .932c-1.05 1.104 -1.58 1.793 -1.588 2.068z", "key": "svg-0" }], ["path", { "d": "M4 10c-.117 6.28 .154 9.765 .814 10.456c1.534 .367 4.355 .535 7.186 .536c2.83 -.001 5.652 -.169 7.186 -.536c.99 -1.037 .898 -9.559 .814 -10.456", "key": "svg-1" }], ["path", { "d": "M10 16l2 -2l2 2", "key": "svg-2" }], ["path", { "d": "M12 14v4", "key": "svg-3" }]]);

var IconBrandJavascript = createVueComponent("outline", "brand-javascript", "BrandJavascript", [["path", { "d": "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z", "key": "svg-0" }], ["path", { "d": "M7.5 8h3v8l-2 -1", "key": "svg-1" }], ["path", { "d": "M16.5 8h-2.5a.5 .5 0 0 0 -.5 .5v3a.5 .5 0 0 0 .5 .5h1.423a.5 .5 0 0 1 .495 .57l-.418 2.93l-2 .5", "key": "svg-2" }]]);

var IconBrandJuejin = createVueComponent("outline", "brand-juejin", "BrandJuejin", [["path", { "d": "M2 12l10 7.422l10 -7.422", "key": "svg-0" }], ["path", { "d": "M7 9l5 4l5 -4", "key": "svg-1" }], ["path", { "d": "M11 6l1 .8l1 -.8l-1 -.8z", "key": "svg-2" }]]);

var IconBrandKakoTalk = createVueComponent("outline", "brand-kako-talk", "BrandKakoTalk", [["path", { "d": "M10 8v7", "key": "svg-0" }], ["path", { "d": "M14 10l-2 2.5l2 2.5", "key": "svg-1" }], ["path", { "d": "M12 4c4.97 0 9 3.358 9 7.5c0 4.142 -4.03 7.5 -9 7.5c-.67 0 -1.323 -.061 -1.95 -.177l-3.05 2.177l.592 -2.962c-2.741 -1.284 -4.592 -3.73 -4.592 -6.538c0 -4.142 4.03 -7.5 9 -7.5z", "key": "svg-2" }]]);

var IconBrandKbin = createVueComponent("outline", "brand-kbin", "BrandKbin", [["g", { "stroke-width": "1.838", "key": "svg-0" }]]);

var IconBrandKick = createVueComponent("outline", "brand-kick", "BrandKick", [["path", { "d": "M4 4h5v4h3v-2h2v-2h6v4h-2v2h-2v4h2v2h2v4h-6v-2h-2v-2h-3v4h-5z", "key": "svg-0" }]]);

var IconBrandKickstarter = createVueComponent("outline", "brand-kickstarter", "BrandKickstarter", [["path", { "d": "M11 9l2.975 -4.65c.615 -.9 1.405 -1.35 2.377 -1.35c.79 0 1.474 .286 2.054 .858c.576 .574 .866 1.256 .866 2.054c0 .588 -.153 1.109 -.46 1.559l-2.812 4.029l3.465 4.912c.356 .46 .535 1 .535 1.613a2.92 2.92 0 0 1 -.843 2.098c-.561 .584 -1.242 .877 -2.04 .877c-.876 0 -1.545 -.29 -2 -.87l-4.112 -5.697v3.067c0 .876 -.313 1.69 -.611 2.175c-.543 .883 -1.35 1.325 -2.389 1.325c-.944 0 -1.753 -.327 -2.271 -.974c-.486 -.6 -.729 -1.392 -.729 -2.38v-11.371c0 -.934 .247 -1.706 .74 -2.313c.512 -.641 1.347 -.962 2.26 -.962c.868 0 1.821 .321 2.4 .962c.323 .356 .515 .714 .6 1.08c.052 .224 0 .643 0 1.26v2.698z", "key": "svg-0" }]]);

var IconBrandKotlin = createVueComponent("outline", "brand-kotlin", "BrandKotlin", [["path", { "d": "M20 20h-16v-16h16", "key": "svg-0" }], ["path", { "d": "M4 20l16 -16", "key": "svg-1" }], ["path", { "d": "M4 12l8 -8", "key": "svg-2" }], ["path", { "d": "M12 12l8 8", "key": "svg-3" }]]);

var IconBrandLaravel = createVueComponent("outline", "brand-laravel", "BrandLaravel", [["path", { "d": "M3 17l8 5l7 -4v-8l-4 -2.5l4 -2.5l4 2.5v4l-11 6.5l-4 -2.5v-7.5l-4 -2.5z", "key": "svg-0" }], ["path", { "d": "M11 18v4", "key": "svg-1" }], ["path", { "d": "M7 15.5l7 -4", "key": "svg-2" }], ["path", { "d": "M14 7.5v4", "key": "svg-3" }], ["path", { "d": "M14 11.5l4 2.5", "key": "svg-4" }], ["path", { "d": "M11 13v-7.5l-4 -2.5l-4 2.5", "key": "svg-5" }], ["path", { "d": "M7 8l4 -2.5", "key": "svg-6" }], ["path", { "d": "M18 10l4 -2.5", "key": "svg-7" }]]);

var IconBrandLastfm = createVueComponent("outline", "brand-lastfm", "BrandLastfm", [["path", { "d": "M20 8c-.83 -1 -1.388 -1 -2 -1c-.612 0 -2 .271 -2 2s1.384 2.233 3 3c1.616 .767 2.125 1.812 2 3s-1 2 -3 2s-3 -1 -3.5 -2s-1.585 -4.78 -2.497 -6a5 5 0 1 0 -1 7", "key": "svg-0" }]]);

var IconBrandLeetcode = createVueComponent("outline", "brand-leetcode", "BrandLeetcode", [["path", { "d": "M12 13h7.5", "key": "svg-0" }], ["path", { "d": "M9.424 7.268l4.999 -4.999", "key": "svg-1" }], ["path", { "d": "M16.633 16.644l-2.402 2.415a3.189 3.189 0 0 1 -4.524 0l-3.77 -3.787a3.223 3.223 0 0 1 0 -4.544l3.77 -3.787a3.189 3.189 0 0 1 4.524 0l2.302 2.313", "key": "svg-2" }]]);

var IconBrandLetterboxd = createVueComponent("outline", "brand-letterboxd", "BrandLetterboxd", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M16 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }]]);

var IconBrandLine = createVueComponent("outline", "brand-line", "BrandLine", [["path", { "d": "M21 10.663c0 -4.224 -4.041 -7.663 -9 -7.663s-9 3.439 -9 7.663c0 3.783 3.201 6.958 7.527 7.56c1.053 .239 .932 .644 .696 2.133c-.039 .238 -.184 .932 .777 .512c.96 -.42 5.18 -3.201 7.073 -5.48c1.304 -1.504 1.927 -3.029 1.927 -4.715v-.01z", "key": "svg-0" }]]);

var IconBrandLinkedin = createVueComponent("outline", "brand-linkedin", "BrandLinkedin", [["path", { "d": "M8 11v5", "key": "svg-0" }], ["path", { "d": "M8 8v.01", "key": "svg-1" }], ["path", { "d": "M12 16v-5", "key": "svg-2" }], ["path", { "d": "M16 16v-3a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M3 7a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v10a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z", "key": "svg-4" }]]);

var IconBrandLinktree = createVueComponent("outline", "brand-linktree", "BrandLinktree", [["path", { "d": "M4 10h16", "key": "svg-0" }], ["path", { "d": "M6.5 4.5l11 11", "key": "svg-1" }], ["path", { "d": "M6.5 15.5l11 -11", "key": "svg-2" }], ["path", { "d": "M12 10v-8", "key": "svg-3" }], ["path", { "d": "M12 15v7", "key": "svg-4" }]]);

var IconBrandLinqpad = createVueComponent("outline", "brand-linqpad", "BrandLinqpad", [["path", { "d": "M5 21h3.5l2.5 -6l2.5 -1l2.5 7h4l1 -4.5l-2 -1l-7 -12l-6 -.5l1.5 4l2.5 .5l1 2.5l-7 8z", "key": "svg-0" }]]);

var IconBrandLivewire = createVueComponent("outline", "brand-livewire", "BrandLivewire", [["path", { "d": "M20.982 18.777c-.372 .548 -.652 1.223 -1.406 1.223c-1.269 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.269 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-.398 0 -.679 -.189 -.915 -.448a10.414 10.414 0 0 1 -1.43 -5.29c0 -5.669 4.477 -10.262 10 -10.262c5.524 0 10 4.594 10 10.261c0 1.62 -.366 3.152 -1.018 4.516z", "key": "svg-0" }], ["path", { "d": "M20.982 18.777c-.372 .548 -.652 1.223 -1.406 1.223c-1.269 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.269 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-.398 0 -.679 -.189 -.915 -.448a10.414 10.414 0 0 1 -1.43 -5.29c0 -5.669 4.477 -10.262 10 -10.262c5.524 0 10 4.594 10 10.261c0 1.62 -.366 3.152 -1.018 4.516z", "key": "svg-1" }], ["path", { "d": "M11.5 16c3.167 0 4.5 -1.748 4.5 -4.231c0 -2.484 -2.014 -4.769 -4.5 -4.769c-2.485 0 -4.5 2.286 -4.5 4.769s1.333 4.231 4.5 4.231z", "key": "svg-2" }], ["path", { "d": "M10 11a1 1 0 1 0 0 -2a1 1 0 0 0 0 2z", "key": "svg-3" }]]);

var IconBrandLoom = createVueComponent("outline", "brand-loom", "BrandLoom", [["path", { "d": "M17.464 6.518a6 6 0 1 0 -3.023 7.965", "key": "svg-0" }], ["path", { "d": "M17.482 17.464a6 6 0 1 0 -7.965 -3.023", "key": "svg-1" }], ["path", { "d": "M6.54 17.482a6 6 0 1 0 3.024 -7.965", "key": "svg-2" }], ["path", { "d": "M6.518 6.54a6 6 0 1 0 7.965 3.024", "key": "svg-3" }]]);

var IconBrandMailgun = createVueComponent("outline", "brand-mailgun", "BrandMailgun", [["path", { "d": "M17 12a2 2 0 1 0 4 0a9 9 0 1 0 -2.987 6.697", "key": "svg-0" }], ["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-1" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }]]);

var IconBrandMantine = createVueComponent("outline", "brand-mantine", "BrandMantine", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 16c1.22 -.912 2 -2.36 2 -4a5.01 5.01 0 0 0 -2 -4", "key": "svg-1" }], ["path", { "d": "M14 9h-2", "key": "svg-2" }], ["path", { "d": "M14 15h-2", "key": "svg-3" }], ["path", { "d": "M10 12h.01", "key": "svg-4" }]]);

var IconBrandMastercard = createVueComponent("outline", "brand-mastercard", "BrandMastercard", [["path", { "d": "M14 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 9.765a3 3 0 1 0 0 4.47", "key": "svg-1" }], ["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-2" }]]);

var IconBrandMastodon = createVueComponent("outline", "brand-mastodon", "BrandMastodon", [["path", { "d": "M18.648 15.254c-1.816 1.763 -6.648 1.626 -6.648 1.626a18.262 18.262 0 0 1 -3.288 -.256c1.127 1.985 4.12 2.81 8.982 2.475c-1.945 2.013 -13.598 5.257 -13.668 -7.636l-.026 -1.154c0 -3.036 .023 -4.115 1.352 -5.633c1.671 -1.91 6.648 -1.666 6.648 -1.666s4.977 -.243 6.648 1.667c1.329 1.518 1.352 2.597 1.352 5.633s-.456 4.074 -1.352 4.944z", "key": "svg-0" }], ["path", { "d": "M12 11.204v-2.926c0 -1.258 -.895 -2.278 -2 -2.278s-2 1.02 -2 2.278v4.722m4 -4.722c0 -1.258 .895 -2.278 2 -2.278s2 1.02 2 2.278v4.722", "key": "svg-1" }]]);

var IconBrandMatrix = createVueComponent("outline", "brand-matrix", "BrandMatrix", [["path", { "d": "M4 3h-1v18h1", "key": "svg-0" }], ["path", { "d": "M20 21h1v-18h-1", "key": "svg-1" }], ["path", { "d": "M7 9v6", "key": "svg-2" }], ["path", { "d": "M12 15v-3.5a2.5 2.5 0 1 0 -5 0v.5", "key": "svg-3" }], ["path", { "d": "M17 15v-3.5a2.5 2.5 0 1 0 -5 0v.5", "key": "svg-4" }]]);

var IconBrandMcdonalds = createVueComponent("outline", "brand-mcdonalds", "BrandMcdonalds", [["path", { "d": "M20 20c0 -3.952 -.966 -16 -4.038 -16s-3.962 9.087 -3.962 14.756c0 -5.669 -.896 -14.756 -3.962 -14.756c-3.065 0 -4.038 12.048 -4.038 16", "key": "svg-0" }]]);

var IconBrandMedium = createVueComponent("outline", "brand-medium", "BrandMedium", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 9h1l3 3l3 -3h1", "key": "svg-1" }], ["path", { "d": "M8 15l2 0", "key": "svg-2" }], ["path", { "d": "M14 15l2 0", "key": "svg-3" }], ["path", { "d": "M9 9l0 6", "key": "svg-4" }], ["path", { "d": "M15 9l0 6", "key": "svg-5" }]]);

var IconBrandMeetup = createVueComponent("outline", "brand-meetup", "BrandMeetup", [["path", { "d": "M5.455 10.82c.935 -2.163 3.045 -3.82 5.545 -3.82c2.104 0 2.844 1.915 2 4l-2 6", "key": "svg-0" }], ["path", { "d": "M6.981 7l-3.981 9.914", "key": "svg-1" }], ["path", { "d": "M13 11c.937 -2.16 3.071 -3.802 5.42 -3.972c2.104 0 3.128 1.706 2.284 3.792l-2.454 6.094c-.853 1.676 .75 2.586 2.75 2.086", "key": "svg-2" }]]);

var IconBrandMercedes = createVueComponent("outline", "brand-mercedes", "BrandMercedes", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3v9", "key": "svg-1" }], ["path", { "d": "M12 12l7 5", "key": "svg-2" }], ["path", { "d": "M12 12l-7 5", "key": "svg-3" }]]);

var IconBrandMessenger = createVueComponent("outline", "brand-messenger", "BrandMessenger", [["path", { "d": "M3 20l1.3 -3.9a9 8 0 1 1 3.4 2.9l-4.7 1", "key": "svg-0" }], ["path", { "d": "M8 13l3 -2l2 2l3 -2", "key": "svg-1" }]]);

var IconBrandMeta = createVueComponent("outline", "brand-meta", "BrandMeta", [["path", { "d": "M12 10.174c1.766 -2.784 3.315 -4.174 4.648 -4.174c2 0 3.263 2.213 4 5.217c.704 2.869 .5 6.783 -2 6.783c-1.114 0 -2.648 -1.565 -4.148 -3.652a27.627 27.627 0 0 1 -2.5 -4.174z", "key": "svg-0" }], ["path", { "d": "M12 10.174c-1.766 -2.784 -3.315 -4.174 -4.648 -4.174c-2 0 -3.263 2.213 -4 5.217c-.704 2.869 -.5 6.783 2 6.783c1.114 0 2.648 -1.565 4.148 -3.652c1 -1.391 1.833 -2.783 2.5 -4.174z", "key": "svg-1" }]]);

var IconBrandMetabrainz = createVueComponent("outline", "brand-metabrainz", "BrandMetabrainz", [["path", { "d": "M3 7v10l7 4v-18z", "key": "svg-0" }], ["path", { "d": "M21 7v10l-7 4v-18z", "key": "svg-1" }]]);

var IconBrandMinecraft = createVueComponent("outline", "brand-minecraft", "BrandMinecraft", [["path", { "d": "M21 16.008v-8.018a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-7 4.008c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008c.62 .354 1.38 .354 2 0l7 -4.008c.619 -.355 1 -1.01 1 -1.718z", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M12 17l3.003 -1.668m3 -1.667l2.997 -1.665m-9 5l-9 -5", "key": "svg-4" }], ["path", { "d": "M15 17l3 -1.67v-3l-3 1.67z", "key": "svg-5" }]]);

var IconBrandMiniprogram = createVueComponent("outline", "brand-miniprogram", "BrandMiniprogram", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M8 11.503a2.5 2.5 0 1 0 4 2v-3a2.5 2.5 0 1 1 4 2", "key": "svg-1" }]]);

var IconBrandMixpanel = createVueComponent("outline", "brand-mixpanel", "BrandMixpanel", [["path", { "d": "M4.5 12m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M20.5 12m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-1" }], ["path", { "d": "M13 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconBrandMonday = createVueComponent("outline", "brand-monday", "BrandMonday", [["path", { "d": "M19.5 15.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-0" }], ["path", { "d": "M9.5 7a1.5 1.5 0 0 1 1.339 2.177l-4.034 7.074c-.264 .447 -.75 .749 -1.305 .749a1.5 1.5 0 0 1 -1.271 -2.297l3.906 -6.827a1.5 1.5 0 0 1 1.365 -.876z", "key": "svg-1" }], ["path", { "d": "M16.5 7a1.5 1.5 0 0 1 1.339 2.177l-4.034 7.074c-.264 .447 -.75 .749 -1.305 .749a1.5 1.5 0 0 1 -1.271 -2.297l3.906 -6.827a1.5 1.5 0 0 1 1.365 -.876z", "key": "svg-2" }]]);

var IconBrandMongodb = createVueComponent("outline", "brand-mongodb", "BrandMongodb", [["path", { "d": "M12 3v19", "key": "svg-0" }], ["path", { "d": "M18 11.227c0 3.273 -1.812 4.77 -6 9.273c-4.188 -4.503 -6 -6 -6 -9.273c0 -4.454 3.071 -6.927 6 -9.227c2.929 2.3 6 4.773 6 9.227z", "key": "svg-1" }]]);

var IconBrandMyOppo = createVueComponent("outline", "brand-my-oppo", "BrandMyOppo", [["path", { "d": "M18.316 5h-12.632l-3.418 4.019a1.089 1.089 0 0 0 .019 1.447l9.714 10.534l9.715 -10.49a1.09 1.09 0 0 0 .024 -1.444l-3.422 -4.066z", "key": "svg-0" }], ["path", { "d": "M9 11l3 3l3 -3", "key": "svg-1" }]]);

var IconBrandMysql = createVueComponent("outline", "brand-mysql", "BrandMysql", [["path", { "d": "M13 21c-1.427 -1.026 -3.59 -3.854 -4 -6c-.486 .77 -1.501 2 -2 2c-1.499 -.888 -.574 -3.973 0 -6c-1.596 -1.433 -2.468 -2.458 -2.5 -4c-3.35 -3.44 -.444 -5.27 2.5 -3h1c8.482 .5 6.421 8.07 9 11.5c2.295 .522 3.665 2.254 5 3.5c-2.086 -.2 -2.784 -.344 -3.5 0c.478 1.64 2.123 2.2 3.5 3", "key": "svg-0" }], ["path", { "d": "M9 7h.01", "key": "svg-1" }]]);

var IconBrandNationalGeographic = createVueComponent("outline", "brand-national-geographic", "BrandNationalGeographic", [["path", { "d": "M7 3h10v18h-10z", "key": "svg-0" }]]);

var IconBrandNem = createVueComponent("outline", "brand-nem", "BrandNem", [["path", { "d": "M12.182 2c1.94 .022 3.879 .382 5.818 1.08l.364 .135a23.075 23.075 0 0 1 3.636 1.785c0 5.618 -1.957 10.258 -5.87 13.92c-1.24 1.239 -2.5 2.204 -3.78 2.898l-.35 .182c-1.4 -.703 -2.777 -1.729 -4.13 -3.079c-3.912 -3.663 -5.87 -8.303 -5.87 -13.921c2.545 -1.527 5.09 -2.471 7.636 -2.832l.364 -.048a16.786 16.786 0 0 1 1.818 -.12h.364z", "key": "svg-0" }], ["path", { "d": "M2.1 7.07c2.073 6.72 5.373 7.697 9.9 2.93c0 -4 1.357 -6.353 4.07 -7.06l.59 -.11", "key": "svg-1" }], ["path", { "d": "M16.35 18.51s2.65 -5.51 -4.35 -8.51", "key": "svg-2" }]]);

var IconBrandNetbeans = createVueComponent("outline", "brand-netbeans", "BrandNetbeans", [["path", { "d": "M19.875 6.27a2.225 2.225 0 0 1 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z", "key": "svg-0" }], ["path", { "d": "M15.5 9.43a1 1 0 0 1 .5 .874v3.268a1 1 0 0 1 -.515 .874l-3 1.917a1 1 0 0 1 -.97 0l-3 -1.917a1 1 0 0 1 -.515 -.873v-3.269a1 1 0 0 1 .514 -.874l3 -1.786c.311 -.173 .69 -.173 1 0l3 1.787h-.014z", "key": "svg-1" }], ["path", { "d": "M12 21v-9l-7.5 -4.5", "key": "svg-2" }], ["path", { "d": "M12 12l7.5 -4.5", "key": "svg-3" }], ["path", { "d": "M12 3v4.5", "key": "svg-4" }], ["path", { "d": "M19.5 16l-3.5 -2", "key": "svg-5" }], ["path", { "d": "M8 14l-3.5 2", "key": "svg-6" }]]);

var IconBrandNeteaseMusic = createVueComponent("outline", "brand-netease-music", "BrandNeteaseMusic", [["path", { "d": "M9 4c-2.93 1.346 -5 5.046 -5 8.492c0 4.508 4 7.508 8 7.508s8 -3 8 -7c0 -3.513 -3.5 -5.513 -6 -5.513s-5 1.513 -5 4.513c0 2 1.5 3 3 3s3 -1 3 -3c0 -3.513 -2 -4.508 -2 -6.515c0 -3.504 3.5 -2.603 4 -1.502", "key": "svg-0" }]]);

var IconBrandNetflix = createVueComponent("outline", "brand-netflix", "BrandNetflix", [["path", { "d": "M9 3l10 18h-4l-10 -18z", "key": "svg-0" }], ["path", { "d": "M5 3v18h4v-10.5", "key": "svg-1" }], ["path", { "d": "M19 21v-18h-4v10.5", "key": "svg-2" }]]);

var IconBrandNexo = createVueComponent("outline", "brand-nexo", "BrandNexo", [["path", { "d": "M17 3l5 3v12l-5 3l-10 -6v-6l10 6v-6l-5 -3z", "key": "svg-0" }], ["path", { "d": "M12 6l-5 -3l-5 3v12l5 3l4.7 -3.13", "key": "svg-1" }]]);

var IconBrandNextcloud = createVueComponent("outline", "brand-nextcloud", "BrandNextcloud", [["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-0" }], ["path", { "d": "M4.5 12.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-1" }], ["path", { "d": "M19.5 12.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-2" }]]);

var IconBrandNextjs = createVueComponent("outline", "brand-nextjs", "BrandNextjs", [["path", { "d": "M9 15v-6l7.745 10.65a9 9 0 1 1 2.255 -1.993", "key": "svg-0" }], ["path", { "d": "M15 12v-3", "key": "svg-1" }]]);

var IconBrandNodejs = createVueComponent("outline", "brand-nodejs", "BrandNodejs", [["path", { "d": "M9 9v8.044a2 2 0 0 1 -2.996 1.734l-1.568 -.9a3 3 0 0 1 -1.436 -2.561v-6.635a3 3 0 0 1 1.436 -2.56l6 -3.667a3 3 0 0 1 3.128 0l6 3.667a3 3 0 0 1 1.436 2.561v6.634a3 3 0 0 1 -1.436 2.56l-6 3.667a3 3 0 0 1 -3.128 0", "key": "svg-0" }], ["path", { "d": "M17 9h-3.5a1.5 1.5 0 0 0 0 3h2a1.5 1.5 0 0 1 0 3h-3.5", "key": "svg-1" }]]);

var IconBrandNordVpn = createVueComponent("outline", "brand-nord-vpn", "BrandNordVpn", [["path", { "d": "M9.992 15l-2.007 -3l-4.015 8c-2.212 -3.061 -2.625 -7.098 -.915 -10.463a10.14 10.14 0 0 1 8.945 -5.537a10.14 10.14 0 0 1 8.945 5.537c1.71 3.365 1.297 7.402 -.915 10.463l-4.517 -8l-1.505 1.5", "key": "svg-0" }], ["path", { "d": "M14.5 15l-3 -6l-2.5 4.5", "key": "svg-1" }]]);

var IconBrandNotion = createVueComponent("outline", "brand-notion", "BrandNotion", [["path", { "d": "M11 17.5v-6.5h.5l4 6h.5v-6.5", "key": "svg-0" }], ["path", { "d": "M19.077 20.071l-11.53 .887a1 1 0 0 1 -.876 -.397l-2.471 -3.294a1 1 0 0 1 -.2 -.6v-10.741a1 1 0 0 1 .923 -.997l11.389 -.876a2 2 0 0 1 1.262 .33l1.535 1.023a2 2 0 0 1 .891 1.664v12.004a1 1 0 0 1 -.923 .997z", "key": "svg-1" }], ["path", { "d": "M4.5 5.5l2.5 2.5", "key": "svg-2" }], ["path", { "d": "M20 7l-13 1v12.5", "key": "svg-3" }]]);

var IconBrandNpm = createVueComponent("outline", "brand-npm", "BrandNpm", [["path", { "d": "M1 8h22v7h-12v2h-4v-2h-6z", "key": "svg-0" }], ["path", { "d": "M7 8v7", "key": "svg-1" }], ["path", { "d": "M14 8v7", "key": "svg-2" }], ["path", { "d": "M17 11v4", "key": "svg-3" }], ["path", { "d": "M4 11v4", "key": "svg-4" }], ["path", { "d": "M11 11v1", "key": "svg-5" }], ["path", { "d": "M20 11v4", "key": "svg-6" }]]);

var IconBrandNuxt = createVueComponent("outline", "brand-nuxt", "BrandNuxt", [["path", { "d": "M12.146 8.583l-1.3 -2.09a1.046 1.046 0 0 0 -1.786 .017l-5.91 9.908a1.046 1.046 0 0 0 .897 1.582h3.913", "key": "svg-0" }], ["path", { "d": "M20.043 18c.743 0 1.201 -.843 .82 -1.505l-4.044 -7.013a.936 .936 0 0 0 -1.638 0l-4.043 7.013c-.382 .662 .076 1.505 .819 1.505h8.086z", "key": "svg-1" }]]);

var IconBrandNytimes = createVueComponent("outline", "brand-nytimes", "BrandNytimes", [["path", { "d": "M11.036 5.058a8 8 0 1 0 8.706 9.965", "key": "svg-0" }], ["path", { "d": "M12 21v-11l-7.5 4", "key": "svg-1" }], ["path", { "d": "M17.5 3a2.5 2.5 0 1 1 0 5l-11 -5a2.5 2.5 0 0 0 -.67 4.91", "key": "svg-2" }], ["path", { "d": "M9 12v8", "key": "svg-3" }], ["path", { "d": "M16 13h-.01", "key": "svg-4" }]]);

var IconBrandOauth = createVueComponent("outline", "brand-oauth", "BrandOauth", [["path", { "d": "M12 12m-10 0a10 10 0 1 0 20 0a10 10 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M12.556 6c.65 0 1.235 .373 1.508 .947l2.839 7.848a1.646 1.646 0 0 1 -1.01 2.108a1.673 1.673 0 0 1 -2.068 -.851l-.46 -1.052h-2.73l-.398 .905a1.67 1.67 0 0 1 -1.977 1.045l-.153 -.047a1.647 1.647 0 0 1 -1.056 -1.956l2.824 -7.852a1.664 1.664 0 0 1 1.409 -1.087l1.272 -.008z", "key": "svg-1" }]]);

var IconBrandOffice = createVueComponent("outline", "brand-office", "BrandOffice", [["path", { "d": "M4 18h9v-12l-5 2v5l-4 2v-8l9 -4l7 2v13l-7 3z", "key": "svg-0" }]]);

var IconBrandOkRu = createVueComponent("outline", "brand-ok-ru", "BrandOkRu", [["path", { "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M20 12c0 8 0 8 -8 8s-8 0 -8 -8s0 -8 8 -8s8 0 8 8z", "key": "svg-1" }], ["path", { "d": "M9.5 13c1.333 .667 3.667 .667 5 0", "key": "svg-2" }], ["path", { "d": "M9.5 17l2.5 -3l2.5 3", "key": "svg-3" }], ["path", { "d": "M12 13.5v.5", "key": "svg-4" }]]);

var IconBrandOnedrive = createVueComponent("outline", "brand-onedrive", "BrandOnedrive", [["path", { "d": "M18.456 10.45a6.45 6.45 0 0 0 -12 -2.151a4.857 4.857 0 0 0 -4.44 5.241a4.856 4.856 0 0 0 5.236 4.444h10.751a3.771 3.771 0 0 0 3.99 -3.54a3.772 3.772 0 0 0 -3.538 -3.992z", "key": "svg-0" }]]);

var IconBrandOnlyfans = createVueComponent("outline", "brand-onlyfans", "BrandOnlyfans", [["path", { "d": "M8.5 6a6.5 6.5 0 1 0 0 13a6.5 6.5 0 0 0 0 -13z", "key": "svg-0" }], ["path", { "d": "M8.5 15a2.5 2.5 0 1 1 0 -5a2.5 2.5 0 0 1 0 5z", "key": "svg-1" }], ["path", { "d": "M14 16c2.5 0 6.42 -1.467 7 -4h-6c3 -1 6.44 -3.533 7 -6h-4c-3.03 0 -3.764 -.196 -5 1.5", "key": "svg-2" }]]);

var IconBrandOpenSource = createVueComponent("outline", "brand-open-source", "BrandOpenSource", [["path", { "d": "M12 3a9 9 0 0 1 3.618 17.243l-2.193 -5.602a3 3 0 1 0 -2.849 0l-2.193 5.603a9 9 0 0 1 3.617 -17.244z", "key": "svg-0" }]]);

var IconBrandOpenai = createVueComponent("outline", "brand-openai", "BrandOpenai", [["path", { "d": "M11.217 19.384a3.501 3.501 0 0 0 6.783 -1.217v-5.167l-6 -3.35", "key": "svg-0" }], ["path", { "d": "M5.214 15.014a3.501 3.501 0 0 0 4.446 5.266l4.34 -2.534v-6.946", "key": "svg-1" }], ["path", { "d": "M6 7.63c-1.391 -.236 -2.787 .395 -3.534 1.689a3.474 3.474 0 0 0 1.271 4.745l4.263 2.514l6 -3.348", "key": "svg-2" }], ["path", { "d": "M12.783 4.616a3.501 3.501 0 0 0 -6.783 1.217v5.067l6 3.45", "key": "svg-3" }], ["path", { "d": "M18.786 8.986a3.501 3.501 0 0 0 -4.446 -5.266l-4.34 2.534v6.946", "key": "svg-4" }], ["path", { "d": "M18 16.302c1.391 .236 2.787 -.395 3.534 -1.689a3.474 3.474 0 0 0 -1.271 -4.745l-4.308 -2.514l-5.955 3.42", "key": "svg-5" }]]);

var IconBrandOpenvpn = createVueComponent("outline", "brand-openvpn", "BrandOpenvpn", [["path", { "d": "M15.618 20.243l-2.193 -5.602a3 3 0 1 0 -2.849 0l-2.193 5.603", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandOpera = createVueComponent("outline", "brand-opera", "BrandOpera", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 5 0 1 0 6 0a3 5 0 1 0 -6 0", "key": "svg-1" }]]);

var IconBrandPagekit = createVueComponent("outline", "brand-pagekit", "BrandPagekit", [["path", { "d": "M12.077 20h-5.077v-16h11v14h-5.077", "key": "svg-0" }]]);

var IconBrandParsinta = createVueComponent("outline", "brand-parsinta", "BrandParsinta", [["path", { "d": "M12 3a9 9 0 1 0 9 9", "key": "svg-0" }], ["path", { "d": "M21 12a9 9 0 0 0 -9 -9", "opacity": ".5", "key": "svg-1" }], ["path", { "d": "M10 9v6l5 -3z", "key": "svg-2" }]]);

var IconBrandPatreon = createVueComponent("outline", "brand-patreon", "BrandPatreon", [["path", { "d": "M20 8.408c-.003 -2.299 -1.746 -4.182 -3.79 -4.862c-2.54 -.844 -5.888 -.722 -8.312 .453c-2.939 1.425 -3.862 4.545 -3.896 7.656c-.028 2.559 .22 9.297 3.92 9.345c2.75 .036 3.159 -3.603 4.43 -5.356c.906 -1.247 2.071 -1.599 3.506 -1.963c2.465 -.627 4.146 -2.626 4.142 -5.273z", "key": "svg-0" }]]);

var IconBrandPaypal = createVueComponent("outline", "brand-paypal", "BrandPaypal", [["path", { "d": "M10 13l2.5 0c2.5 0 5 -2.5 5 -5c0 -3 -1.9 -5 -5 -5h-5.5c-.5 0 -1 .5 -1 1l-2 14c0 .5 .5 1 1 1h2.8l1.2 -5c.1 -.6 .4 -1 1 -1zm7.5 -5.8c1.7 1 2.5 2.8 2.5 4.8c0 2.5 -2.5 4.5 -5 4.5h-2.6l-.6 3.6a1 1 0 0 1 -1 .8l-2.7 0a.5 .5 0 0 1 -.5 -.6l.2 -1.4", "key": "svg-0" }]]);

var IconBrandPaypay = createVueComponent("outline", "brand-paypay", "BrandPaypay", [["path", { "d": "M6.375 21l3.938 -13.838", "key": "svg-0" }], ["path", { "d": "M3 6c16.731 0 21.231 9.881 4.5 11", "key": "svg-1" }], ["path", { "d": "M21 19v-14a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2z", "key": "svg-2" }]]);

var IconBrandPeanut = createVueComponent("outline", "brand-peanut", "BrandPeanut", [["path", { "d": "M15 16.25l-.816 -.36l-.462 -.196c-1.444 -.592 -2 -.593 -3.447 0l-.462 .195l-.817 .359a4.5 4.5 0 1 1 0 -8.49v0l1.054 .462l.434 .178c1.292 .507 1.863 .48 3.237 -.082l.462 -.195l.817 -.359a4.5 4.5 0 1 1 0 8.49", "key": "svg-0" }]]);

var IconBrandPepsi = createVueComponent("outline", "brand-pepsi", "BrandPepsi", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M4 16c5.713 -2.973 11 -3.5 13.449 -11.162", "key": "svg-1" }], ["path", { "d": "M5 17.5c5.118 -2.859 15 0 14 -11", "key": "svg-2" }]]);

var IconBrandPhp = createVueComponent("outline", "brand-php", "BrandPhp", [["path", { "d": "M12 12m-10 0a10 9 0 1 0 20 0a10 9 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M5.5 15l.395 -1.974l.605 -3.026h1.32a1 1 0 0 1 .986 1.164l-.167 1a1 1 0 0 1 -.986 .836h-1.653", "key": "svg-1" }], ["path", { "d": "M15.5 15l.395 -1.974l.605 -3.026h1.32a1 1 0 0 1 .986 1.164l-.167 1a1 1 0 0 1 -.986 .836h-1.653", "key": "svg-2" }], ["path", { "d": "M12 7.5l-1 5.5", "key": "svg-3" }], ["path", { "d": "M11.6 10h2.4l-.5 3", "key": "svg-4" }]]);

var IconBrandPicsart = createVueComponent("outline", "brand-picsart", "BrandPicsart", [["path", { "d": "M12 9m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M12 9m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M5 9v11a2 2 0 1 0 4 0v-4.5", "key": "svg-2" }]]);

var IconBrandPinterest = createVueComponent("outline", "brand-pinterest", "BrandPinterest", [["path", { "d": "M8 20l4 -9", "key": "svg-0" }], ["path", { "d": "M10.7 14c.437 1.263 1.43 2 2.55 2c2.071 0 3.75 -1.554 3.75 -4a5 5 0 1 0 -9.7 1.7", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconBrandPlanetscale = createVueComponent("outline", "brand-planetscale", "BrandPlanetscale", [["path", { "d": "M20.993 11.63a9 9 0 0 1 -9.362 9.362l9.362 -9.362z", "key": "svg-0" }], ["path", { "d": "M12 3a9.001 9.001 0 0 1 8.166 5.211l-11.955 11.955a9 9 0 0 1 3.789 -17.166z", "key": "svg-1" }], ["path", { "d": "M12 12l-6 6", "key": "svg-2" }]]);

var IconBrandPnpm = createVueComponent("outline", "brand-pnpm", "BrandPnpm", [["path", { "d": "M3 17h4v4h-4z", "key": "svg-0" }], ["path", { "d": "M10 17h4v4h-4z", "key": "svg-1" }], ["path", { "d": "M17 17h4v4h-4z", "key": "svg-2" }], ["path", { "d": "M17 10h4v4h-4z", "key": "svg-3" }], ["path", { "d": "M17 3h4v4h-4z", "key": "svg-4" }], ["path", { "d": "M10 10h4v4h-4z", "key": "svg-5" }], ["path", { "d": "M10 3h4v4h-4z", "key": "svg-6" }], ["path", { "d": "M3 3h4v4h-4z", "key": "svg-7" }]]);

var IconBrandPocket = createVueComponent("outline", "brand-pocket", "BrandPocket", [["path", { "d": "M5 4h14a2 2 0 0 1 2 2v6a9 9 0 0 1 -18 0v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M8 11l4 4l4 -4", "key": "svg-1" }]]);

var IconBrandPolymer = createVueComponent("outline", "brand-polymer", "BrandPolymer", [["path", { "d": "M6.706 6l-3.706 6l3.706 6h1.059l8.47 -12h1.06l3.705 6l-3.706 6", "key": "svg-0" }]]);

var IconBrandPowershell = createVueComponent("outline", "brand-powershell", "BrandPowershell", [["path", { "d": "M4.887 20h11.868c.893 0 1.664 -.665 1.847 -1.592l2.358 -12c.212 -1.081 -.442 -2.14 -1.462 -2.366a1.784 1.784 0 0 0 -.385 -.042h-11.868c-.893 0 -1.664 .665 -1.847 1.592l-2.358 12c-.212 1.081 .442 2.14 1.462 2.366c.127 .028 .256 .042 .385 .042z", "key": "svg-0" }], ["path", { "d": "M9 8l4 4l-6 4", "key": "svg-1" }], ["path", { "d": "M12 16h3", "key": "svg-2" }]]);

var IconBrandPrintables = createVueComponent("outline", "brand-printables", "BrandPrintables", [["path", { "d": "M6 21l12 -7v-7.5l-6 -3.5l-6 3.5l6 3.5v7.5l-6 -3.5z", "key": "svg-0" }]]);

var IconBrandPrisma = createVueComponent("outline", "brand-prisma", "BrandPrisma", [["path", { "d": "M4.186 16.202l3.615 5.313c.265 .39 .754 .57 1.215 .447l10.166 -2.718a1.086 1.086 0 0 0 .713 -1.511l-7.505 -15.483a.448 .448 0 0 0 -.787 -.033l-7.453 12.838a1.07 1.07 0 0 0 .037 1.147z", "key": "svg-0" }], ["path", { "d": "M8.5 22l3.5 -20", "key": "svg-1" }]]);

var IconBrandProducthunt = createVueComponent("outline", "brand-producthunt", "BrandProducthunt", [["path", { "d": "M10 16v-8h2.5a2.5 2.5 0 1 1 0 5h-2.5", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandPushbullet = createVueComponent("outline", "brand-pushbullet", "BrandPushbullet", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 8v8h2a4 4 0 1 0 0 -8h-2z", "key": "svg-1" }], ["path", { "d": "M8 8v8", "key": "svg-2" }]]);

var IconBrandPushover = createVueComponent("outline", "brand-pushover", "BrandPushover", [["path", { "d": "M6.16 10.985c-.83 -1.935 1.53 -7.985 8.195 -7.985c3.333 0 4.645 1.382 4.645 3.9c0 2.597 -2.612 6.1 -9 6.1", "key": "svg-0" }], ["path", { "d": "M12.5 6l-5.5 15", "key": "svg-1" }]]);

var IconBrandPython = createVueComponent("outline", "brand-python", "BrandPython", [["path", { "d": "M12 9h-7a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h3", "key": "svg-0" }], ["path", { "d": "M12 15h7a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-3", "key": "svg-1" }], ["path", { "d": "M8 9v-4a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v5a2 2 0 0 1 -2 2h-4a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h4a2 2 0 0 0 2 -2v-4", "key": "svg-2" }], ["path", { "d": "M11 6l0 .01", "key": "svg-3" }], ["path", { "d": "M13 18l0 .01", "key": "svg-4" }]]);

var IconBrandQq = createVueComponent("outline", "brand-qq", "BrandQq", [["path", { "d": "M6 9.748a14.716 14.716 0 0 0 11.995 -.052c.275 -9.236 -11.104 -11.256 -11.995 .052z", "key": "svg-0" }], ["path", { "d": "M18 10c.984 2.762 1.949 4.765 2 7.153c.014 .688 -.664 1.346 -1.184 .303c-.346 -.696 -.952 -1.181 -1.816 -1.456", "key": "svg-1" }], ["path", { "d": "M17 16c.031 1.831 .147 3.102 -1 4", "key": "svg-2" }], ["path", { "d": "M8 20c-1.099 -.87 -.914 -2.24 -1 -4", "key": "svg-3" }], ["path", { "d": "M6 10c-.783 2.338 -1.742 4.12 -1.968 6.43c-.217 2.227 .716 1.644 1.16 .917c.296 -.487 .898 -.934 1.808 -1.347", "key": "svg-4" }], ["path", { "d": "M15.898 13l-.476 -2", "key": "svg-5" }], ["path", { "d": "M8 20l-1.5 1c-.5 .5 -.5 1 .5 1h10c1 0 1 -.5 .5 -1l-1.5 -1", "key": "svg-6" }], ["path", { "d": "M13.75 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-7" }], ["path", { "d": "M10.25 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-8" }]]);

var IconBrandRadixUi = createVueComponent("outline", "brand-radix-ui", "BrandRadixUi", [["path", { "d": "M16.5 5.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M6 3h5v5h-5z", "key": "svg-1" }], ["path", { "d": "M11 11v10a5 5 0 0 1 -.217 -9.995l.217 -.005z", "key": "svg-2" }]]);

var IconBrandReactNative = createVueComponent("outline", "brand-react-native", "BrandReactNative", [["path", { "d": "M6.357 9c-2.637 .68 -4.357 1.845 -4.357 3.175c0 2.107 4.405 3.825 9.85 3.825c.74 0 1.26 -.039 1.95 -.097", "key": "svg-0" }], ["path", { "d": "M9.837 15.9c-.413 -.596 -.806 -1.133 -1.18 -1.8c-2.751 -4.9 -3.488 -9.77 -1.63 -10.873c1.15 -.697 3.047 .253 4.974 2.254", "key": "svg-1" }], ["path", { "d": "M6.429 15.387c-.702 2.688 -.56 4.716 .56 5.395c1.783 1.08 5.387 -1.958 8.043 -6.804c.36 -.67 .683 -1.329 .968 -1.978", "key": "svg-2" }], ["path", { "d": "M12 18.52c1.928 2 3.817 2.95 4.978 2.253c1.85 -1.102 1.121 -5.972 -1.633 -10.873c-.384 -.677 -.777 -1.204 -1.18 -1.8", "key": "svg-3" }], ["path", { "d": "M17.66 15c2.612 -.687 4.34 -1.85 4.34 -3.176c0 -2.11 -4.408 -3.824 -9.845 -3.824c-.747 0 -1.266 .029 -1.955 .087", "key": "svg-4" }], ["path", { "d": "M8 12c.285 -.66 .607 -1.308 .968 -1.978c2.647 -4.844 6.253 -7.89 8.046 -6.801c1.11 .679 1.262 2.706 .56 5.393", "key": "svg-5" }], ["path", { "d": "M12.26 12.015h-.01c-.01 .13 -.12 .24 -.26 .24a.263 .263 0 0 1 -.25 -.26c0 -.14 .11 -.25 .24 -.25h-.01c.13 -.01 .25 .11 .25 .24", "key": "svg-6" }]]);

var IconBrandReact = createVueComponent("outline", "brand-react", "BrandReact", [["path", { "d": "M6.306 8.711c-2.602 .723 -4.306 1.926 -4.306 3.289c0 2.21 4.477 4 10 4c.773 0 1.526 -.035 2.248 -.102", "key": "svg-0" }], ["path", { "d": "M17.692 15.289c2.603 -.722 4.308 -1.926 4.308 -3.289c0 -2.21 -4.477 -4 -10 -4c-.773 0 -1.526 .035 -2.25 .102", "key": "svg-1" }], ["path", { "d": "M6.305 15.287c-.676 2.615 -.485 4.693 .695 5.373c1.913 1.105 5.703 -1.877 8.464 -6.66c.387 -.67 .733 -1.339 1.036 -2", "key": "svg-2" }], ["path", { "d": "M17.694 8.716c.677 -2.616 .487 -4.696 -.694 -5.376c-1.913 -1.105 -5.703 1.877 -8.464 6.66c-.387 .67 -.733 1.34 -1.037 2", "key": "svg-3" }], ["path", { "d": "M12 5.424c-1.925 -1.892 -3.82 -2.766 -5 -2.084c-1.913 1.104 -1.226 5.877 1.536 10.66c.386 .67 .793 1.304 1.212 1.896", "key": "svg-4" }], ["path", { "d": "M12 18.574c1.926 1.893 3.821 2.768 5 2.086c1.913 -1.104 1.226 -5.877 -1.536 -10.66c-.375 -.65 -.78 -1.283 -1.212 -1.897", "key": "svg-5" }], ["path", { "d": "M11.5 12.866a1 1 0 1 0 1 -1.732a1 1 0 0 0 -1 1.732z", "key": "svg-6" }]]);

var IconBrandReason = createVueComponent("outline", "brand-reason", "BrandReason", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M18 18h-3v-6h3", "key": "svg-1" }], ["path", { "d": "M18 15h-3", "key": "svg-2" }], ["path", { "d": "M8 18v-6h2.5a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M12 18l-2 -3", "key": "svg-4" }]]);

var IconBrandReddit = createVueComponent("outline", "brand-reddit", "BrandReddit", [["path", { "d": "M12 8c2.648 0 5.028 .826 6.675 2.14a2.5 2.5 0 0 1 2.326 4.36c0 3.59 -4.03 6.5 -9 6.5c-4.875 0 -8.845 -2.8 -9 -6.294l-1 -.206a2.5 2.5 0 0 1 2.326 -4.36c1.646 -1.313 4.026 -2.14 6.674 -2.14z", "key": "svg-0" }], ["path", { "d": "M12 8l1 -5l6 1", "key": "svg-1" }], ["path", { "d": "M19 4m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["circle", { "cx": "9", "cy": "13", "r": ".5", "fill": "currentColor", "key": "svg-3" }], ["circle", { "cx": "15", "cy": "13", "r": ".5", "fill": "currentColor", "key": "svg-4" }], ["path", { "d": "M10 17c.667 .333 1.333 .5 2 .5s1.333 -.167 2 -.5", "key": "svg-5" }]]);

var IconBrandRedhat = createVueComponent("outline", "brand-redhat", "BrandRedhat", [["path", { "d": "M6 10.5l1.436 -4c.318 -.876 .728 -1.302 1.359 -1.302c.219 0 1.054 .365 1.88 .583c.825 .219 .733 -.329 .908 -.487c.176 -.158 .355 -.294 .61 -.294c.242 0 .553 .048 1.692 .448c.759 .267 1.493 .574 2.204 .922c1.175 .582 1.426 .913 1.595 1.507l.816 4.623c2.086 .898 3.5 2.357 3.5 3.682c0 1.685 -1.2 3.818 -5.957 3.818c-6.206 0 -14.043 -4.042 -14.043 -7.32c0 -1.044 1.333 -1.77 4 -2.18z", "key": "svg-0" }], ["path", { "d": "M6 10.5c0 .969 4.39 3.5 9.5 3.5c1.314 0 3 .063 3 -1.5", "key": "svg-1" }]]);

var IconBrandRedux = createVueComponent("outline", "brand-redux", "BrandRedux", [["path", { "d": "M16.54 7c-.805 -2.365 -2.536 -4 -4.54 -4c-2.774 0 -5.023 2.632 -5.023 6.496c0 1.956 1.582 4.727 2.512 6", "key": "svg-0" }], ["path", { "d": "M4.711 11.979c-1.656 1.877 -2.214 4.185 -1.211 5.911c1.387 2.39 5.138 2.831 8.501 .9c1.703 -.979 2.875 -3.362 3.516 -4.798", "key": "svg-1" }], ["path", { "d": "M15.014 19.99c2.511 0 4.523 -.438 5.487 -2.1c1.387 -2.39 -.215 -5.893 -3.579 -7.824c-1.702 -.979 -4.357 -1.235 -5.927 -1.07", "key": "svg-2" }], ["path", { "d": "M10.493 9.862c.48 .276 1.095 .112 1.372 -.366a1 1 0 0 0 -.367 -1.365a1.007 1.007 0 0 0 -1.373 .366a1 1 0 0 0 .368 1.365z", "key": "svg-3" }], ["path", { "d": "M9.5 15.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M15.5 14m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }]]);

var IconBrandRevolut = createVueComponent("outline", "brand-revolut", "BrandRevolut", [["path", { "d": "M5 10h3v10h-3z", "key": "svg-0" }], ["path", { "d": "M14.5 4h-9.5v3h9.4a1.5 1.5 0 0 1 0 3h-3.4v4l4 6h4l-5 -7h.5a4.5 4.5 0 1 0 0 -9z", "key": "svg-1" }]]);

var IconBrandRumble = createVueComponent("outline", "brand-rumble", "BrandRumble", [["path", { "d": "M19.993 9.108c.383 .4 .687 .863 .893 1.368a4.195 4.195 0 0 1 .006 3.166a4.37 4.37 0 0 1 -.887 1.372a20.233 20.233 0 0 1 -2.208 2a20.615 20.615 0 0 1 -2.495 1.669a21.322 21.322 0 0 1 -5.622 2.202a4.213 4.213 0 0 1 -3.002 -.404a3.98 3.98 0 0 1 -1.163 -.967a3.796 3.796 0 0 1 -.695 -1.312c-1.199 -3.902 -1.022 -8.312 .134 -12.23c.609 -2.057 2.643 -3.349 4.737 -2.874c3.88 .88 7.52 3.147 10.302 6.01z", "key": "svg-0" }], ["path", { "d": "M14.044 13.034c.67 -.505 .67 -1.489 0 -2.01a14.824 14.824 0 0 0 -1.498 -1.044a15.783 15.783 0 0 0 -1.62 -.865c-.77 -.35 -1.63 .139 -1.753 .973a15.385 15.385 0 0 0 -.1 3.786a1.232 1.232 0 0 0 1.715 1.027a14.783 14.783 0 0 0 1.694 -.827a14.46 14.46 0 0 0 1.562 -1.035v-.005z", "key": "svg-1" }]]);

var IconBrandRust = createVueComponent("outline", "brand-rust", "BrandRust", [["path", { "d": "M10.139 3.463c.473 -1.95 3.249 -1.95 3.722 0a1.916 1.916 0 0 0 2.859 1.185c1.714 -1.045 3.678 .918 2.633 2.633a1.916 1.916 0 0 0 1.184 2.858c1.95 .473 1.95 3.249 0 3.722a1.916 1.916 0 0 0 -1.185 2.859c1.045 1.714 -.918 3.678 -2.633 2.633a1.916 1.916 0 0 0 -2.858 1.184c-.473 1.95 -3.249 1.95 -3.722 0a1.916 1.916 0 0 0 -2.859 -1.185c-1.714 1.045 -3.678 -.918 -2.633 -2.633a1.916 1.916 0 0 0 -1.184 -2.858c-1.95 -.473 -1.95 -3.249 0 -3.722a1.916 1.916 0 0 0 1.185 -2.859c-1.045 -1.714 .918 -3.678 2.633 -2.633a1.914 1.914 0 0 0 2.858 -1.184z", "key": "svg-0" }], ["path", { "d": "M8 12h6a2 2 0 1 0 0 -4h-6v8v-4z", "key": "svg-1" }], ["path", { "d": "M19 16h-2a2 2 0 0 1 -2 -2a2 2 0 0 0 -2 -2h-1", "key": "svg-2" }], ["path", { "d": "M9 8h-4", "key": "svg-3" }], ["path", { "d": "M5 16h4", "key": "svg-4" }]]);

var IconBrandSafari = createVueComponent("outline", "brand-safari", "BrandSafari", [["path", { "d": "M8 16l2 -6l6 -2l-2 6l-6 2", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandSamsungpass = createVueComponent("outline", "brand-samsungpass", "BrandSamsungpass", [["path", { "d": "M4 10m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 10v-1.862c0 -2.838 2.239 -5.138 5 -5.138s5 2.3 5 5.138v1.862", "key": "svg-1" }], ["path", { "d": "M10.485 17.577c.337 .29 .7 .423 1.515 .423h.413c.323 0 .633 -.133 .862 -.368a1.27 1.27 0 0 0 .356 -.886c0 -.332 -.128 -.65 -.356 -.886a1.203 1.203 0 0 0 -.862 -.368h-.826a1.2 1.2 0 0 1 -.861 -.367a1.27 1.27 0 0 1 -.356 -.886c0 -.332 .128 -.651 .356 -.886a1.2 1.2 0 0 1 .861 -.368h.413c.816 0 1.178 .133 1.515 .423", "key": "svg-2" }]]);

var IconBrandSass = createVueComponent("outline", "brand-sass", "BrandSass", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 10.523c2.46 -.826 4 -.826 4 -2.155c0 -1.366 -1.347 -1.366 -2.735 -1.366c-1.91 0 -3.352 .49 -4.537 1.748c-.848 .902 -1.027 2.449 -.153 3.307c.973 .956 3.206 1.789 2.884 3.493c-.233 1.235 -1.469 1.823 -2.617 1.202c-.782 -.424 -.454 -1.746 .626 -2.512s2.822 -.992 4.1 -.24c.98 .575 1.046 1.724 .434 2.193", "key": "svg-1" }]]);

var IconBrandSentry = createVueComponent("outline", "brand-sentry", "BrandSentry", [["path", { "d": "M3 18a1.93 1.93 0 0 0 .306 1.076a2 2 0 0 0 1.584 .924c.646 .033 -.537 0 .11 0h3a4.992 4.992 0 0 0 -3.66 -4.81c.558 -.973 1.24 -2.149 2.04 -3.531a9 9 0 0 1 5.62 8.341h4c.663 0 2.337 0 3 0a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-1.84 3.176c4.482 2.05 7.6 6.571 7.6 11.824", "key": "svg-0" }]]);

var IconBrandSharik = createVueComponent("outline", "brand-sharik", "BrandSharik", [["path", { "d": "M4.281 16.606a8.968 8.968 0 0 1 1.363 -10.977a9.033 9.033 0 0 1 11.011 -1.346c-1.584 4.692 -2.415 6.96 -4.655 8.717c-1.584 1.242 -3.836 2.24 -7.719 3.606zm16.335 -7.306c2.113 7.59 -4.892 13.361 -11.302 11.264c1.931 -3.1 3.235 -4.606 4.686 -6.065c1.705 -1.715 3.591 -3.23 6.616 -5.199z", "key": "svg-0" }]]);

var IconBrandShazam = createVueComponent("outline", "brand-shazam", "BrandShazam", [["path", { "d": "M10 12l2 -2a2.828 2.828 0 0 1 4 0a2.828 2.828 0 0 1 0 4l-3 3", "key": "svg-0" }], ["path", { "d": "M14 12l-2 2a2.828 2.828 0 1 1 -4 -4l3 -3", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconBrandShopee = createVueComponent("outline", "brand-shopee", "BrandShopee", [["path", { "d": "M4 7l.867 12.143a2 2 0 0 0 2 1.857h10.276a2 2 0 0 0 2 -1.857l.867 -12.143h-16z", "key": "svg-0" }], ["path", { "d": "M8.5 7c0 -1.653 1.5 -4 3.5 -4s3.5 2.347 3.5 4", "key": "svg-1" }], ["path", { "d": "M9.5 17c.413 .462 1 1 2.5 1s2.5 -.897 2.5 -2s-1 -1.5 -2.5 -2s-2 -1.47 -2 -2c0 -1.104 1 -2 2 -2s1.5 0 2.5 1", "key": "svg-2" }]]);

var IconBrandSketch = createVueComponent("outline", "brand-sketch", "BrandSketch", [["path", { "d": "M3.262 10.878l8 8.789c.4 .44 1.091 .44 1.491 0l8 -8.79c.313 -.344 .349 -.859 .087 -1.243l-3.537 -5.194a1 1 0 0 0 -.823 -.436h-8.926a1 1 0 0 0 -.823 .436l-3.54 5.192c-.263 .385 -.227 .901 .087 1.246z", "key": "svg-0" }]]);

var IconBrandSkype = createVueComponent("outline", "brand-skype", "BrandSkype", [["path", { "d": "M12 3a9 9 0 0 1 8.603 11.65a4.5 4.5 0 0 1 -5.953 5.953a9 9 0 0 1 -11.253 -11.253a4.5 4.5 0 0 1 5.953 -5.954a8.987 8.987 0 0 1 2.65 -.396z", "key": "svg-0" }], ["path", { "d": "M8 14.5c.5 2 2.358 2.5 4 2.5c2.905 0 4 -1.187 4 -2.5c0 -1.503 -1.927 -2.5 -4 -2.5s-4 -1 -4 -2.5c0 -1.313 1.095 -2.5 4 -2.5c1.642 0 3.5 .5 4 2.5", "key": "svg-1" }]]);

var IconBrandSlack = createVueComponent("outline", "brand-slack", "BrandSlack", [["path", { "d": "M12 12v-6a2 2 0 0 1 4 0v6m0 -2a2 2 0 1 1 2 2h-6", "key": "svg-0" }], ["path", { "d": "M12 12h6a2 2 0 0 1 0 4h-6m2 0a2 2 0 1 1 -2 2v-6", "key": "svg-1" }], ["path", { "d": "M12 12v6a2 2 0 0 1 -4 0v-6m0 2a2 2 0 1 1 -2 -2h6", "key": "svg-2" }], ["path", { "d": "M12 12h-6a2 2 0 0 1 0 -4h6m-2 0a2 2 0 1 1 2 -2v6", "key": "svg-3" }]]);

var IconBrandSnapchat = createVueComponent("outline", "brand-snapchat", "BrandSnapchat", [["path", { "d": "M16.882 7.842a4.882 4.882 0 0 0 -9.764 0c0 4.273 -.213 6.409 -4.118 8.118c2 .882 2 .882 3 3c3 0 4 2 6 2s3 -2 6 -2c1 -2.118 1 -2.118 3 -3c-3.906 -1.709 -4.118 -3.845 -4.118 -8.118zm-13.882 8.119c4 -2.118 4 -4.118 1 -7.118m17 7.118c-4 -2.118 -4 -4.118 -1 -7.118", "key": "svg-0" }]]);

var IconBrandSnapseed = createVueComponent("outline", "brand-snapseed", "BrandSnapseed", [["path", { "d": "M8.152 3.115a.46 .46 0 0 0 -.609 0c-2.943 2.58 -4.529 5.441 -4.543 8.378c0 2.928 1.586 5.803 4.543 8.392a.46 .46 0 0 0 .61 0c2.957 -2.589 4.547 -5.464 4.547 -8.392c0 -2.928 -1.6 -5.799 -4.548 -8.378z", "key": "svg-0" }], ["path", { "d": "M8 20l12.09 -.011c.503 0 .91 -.434 .91 -.969v-6.063c0 -.535 -.407 -.968 -.91 -.968h-7.382", "key": "svg-1" }]]);

var IconBrandSnowflake = createVueComponent("outline", "brand-snowflake", "BrandSnowflake", [["path", { "d": "M14 21v-5.5l4.5 2.5", "key": "svg-0" }], ["path", { "d": "M10 21v-5.5l-4.5 2.5", "key": "svg-1" }], ["path", { "d": "M3.5 14.5l4.5 -2.5l-4.5 -2.5", "key": "svg-2" }], ["path", { "d": "M20.5 9.5l-4.5 2.5l4.5 2.5", "key": "svg-3" }], ["path", { "d": "M10 3v5.5l-4.5 -2.5", "key": "svg-4" }], ["path", { "d": "M14 3v5.5l4.5 -2.5", "key": "svg-5" }], ["path", { "d": "M12 11l1 1l-1 1l-1 -1z", "key": "svg-6" }]]);

var IconBrandSocketIo = createVueComponent("outline", "brand-socket-io", "BrandSocketIo", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 11h1l3 -4z", "key": "svg-1" }], ["path", { "d": "M12 13h1l-4 4z", "key": "svg-2" }]]);

var IconBrandSolidjs = createVueComponent("outline", "brand-solidjs", "BrandSolidjs", [["path", { "d": "M2 17.5c4.667 3 8 4.5 10 4.5c2.5 0 4 -1.5 4 -3.5s-1.5 -3.5 -4 -3.5c-2 0 -5.333 .833 -10 2.5z", "key": "svg-0" }], ["path", { "d": "M5 13.5c4.667 -1.667 8 -2.5 10 -2.5c2.5 0 4 1.5 4 3.5c0 .738 -.204 1.408 -.588 1.96l-2.883 3.825", "key": "svg-1" }], ["path", { "d": "M22 6.5c-4 -3 -8 -4.5 -10 -4.5c-2.04 0 -2.618 .463 -3.419 1.545", "key": "svg-2" }], ["path", { "d": "M2 17.5l3 -4", "key": "svg-3" }], ["path", { "d": "M22 6.5l-3 4", "key": "svg-4" }], ["path", { "d": "M8.581 3.545l-2.953 3.711", "key": "svg-5" }], ["path", { "d": "M7.416 12.662c-1.51 -.476 -2.416 -1.479 -2.416 -3.162c0 -2.5 1.5 -3.5 4 -3.5c1.688 0 5.087 1.068 8.198 3.204a114.76 114.76 0 0 1 1.802 1.296l-2.302 .785", "key": "svg-6" }]]);

var IconBrandSoundcloud = createVueComponent("outline", "brand-soundcloud", "BrandSoundcloud", [["path", { "d": "M17 11h1c1.38 0 3 1.274 3 3c0 1.657 -1.5 3 -3 3l-6 0v-10c3 0 4.5 1.5 5 4z", "key": "svg-0" }], ["path", { "d": "M9 8l0 9", "key": "svg-1" }], ["path", { "d": "M6 17l0 -7", "key": "svg-2" }], ["path", { "d": "M3 16l0 -2", "key": "svg-3" }]]);

var IconBrandSpacehey = createVueComponent("outline", "brand-spacehey", "BrandSpacehey", [["path", { "d": "M17 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M14 20h6v-6a3 3 0 0 0 -6 0v6z", "key": "svg-1" }], ["path", { "d": "M11 8v2.5a3.5 3.5 0 0 1 -3.5 3.5h-.5a3 3 0 0 1 0 -6h4z", "key": "svg-2" }]]);

var IconBrandSpeedtest = createVueComponent("outline", "brand-speedtest", "BrandSpeedtest", [["path", { "d": "M5.636 19.364a9 9 0 1 1 12.728 0", "key": "svg-0" }], ["path", { "d": "M16 9l-4 4", "key": "svg-1" }]]);

var IconBrandSpotify = createVueComponent("outline", "brand-spotify", "BrandSpotify", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 11.973c2.5 -1.473 5.5 -.973 7.5 .527", "key": "svg-1" }], ["path", { "d": "M9 15c1.5 -1 4 -1 5 .5", "key": "svg-2" }], ["path", { "d": "M7 9c2 -1 6 -2 10 .5", "key": "svg-3" }]]);

var IconBrandStackoverflow = createVueComponent("outline", "brand-stackoverflow", "BrandStackoverflow", [["path", { "d": "M4 17v1a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-1", "key": "svg-0" }], ["path", { "d": "M8 16h8", "key": "svg-1" }], ["path", { "d": "M8.322 12.582l7.956 .836", "key": "svg-2" }], ["path", { "d": "M8.787 9.168l7.826 1.664", "key": "svg-3" }], ["path", { "d": "M10.096 5.764l7.608 2.472", "key": "svg-4" }]]);

var IconBrandStackshare = createVueComponent("outline", "brand-stackshare", "BrandStackshare", [["path", { "d": "M19 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M19 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M7 12h3l3.5 6h3.5", "key": "svg-3" }], ["path", { "d": "M17 6h-3.5l-3.5 6", "key": "svg-4" }]]);

var IconBrandSteam = createVueComponent("outline", "brand-steam", "BrandSteam", [["path", { "d": "M16.5 5a4.5 4.5 0 1 1 -.653 8.953l-4.347 3.009l0 .038a3 3 0 0 1 -2.824 3l-.176 0a3 3 0 0 1 -2.94 -2.402l-2.56 -1.098v-3.5l3.51 1.755a2.989 2.989 0 0 1 2.834 -.635l2.727 -3.818a4.5 4.5 0 0 1 4.429 -5.302z", "key": "svg-0" }], ["circle", { "cx": "16.5", "cy": "9.5", "r": "1", "fill": "currentColor", "key": "svg-1" }]]);

var IconBrandStocktwits = createVueComponent("outline", "brand-stocktwits", "BrandStocktwits", [["path", { "d": "M16 3l-8 4.5l8 4.5", "key": "svg-0" }], ["path", { "d": "M8 12l8 4.5l-8 4.5", "key": "svg-1" }]]);

var IconBrandStorj = createVueComponent("outline", "brand-storj", "BrandStorj", [["path", { "d": "M4 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M4 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M20 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M20 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M12 3m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M12 21m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }], ["path", { "d": "M12 21l-8 -4v-10l8 -4l8 4v10z", "key": "svg-6" }], ["path", { "d": "M9.1 15a2.1 2.1 0 0 1 -.648 -4.098c.282 -1.648 1.319 -2.902 3.048 -2.902c1.694 0 2.906 1.203 3.23 2.8h.17a2.1 2.1 0 0 1 .202 4.19l-.202 .01h-5.8z", "key": "svg-7" }], ["path", { "d": "M4 7l4.323 2.702", "key": "svg-8" }], ["path", { "d": "M16.413 14.758l3.587 2.242", "key": "svg-9" }], ["path", { "d": "M4 17l3.529 -2.206", "key": "svg-10" }], ["path", { "d": "M14.609 10.37l5.391 -3.37", "key": "svg-11" }], ["path", { "d": "M12 3v5", "key": "svg-12" }], ["path", { "d": "M12 15v6", "key": "svg-13" }]]);

var IconBrandStorybook = createVueComponent("outline", "brand-storybook", "BrandStorybook", [["path", { "d": "M5 4l.5 16.5l13.5 .5v-18z", "key": "svg-0" }], ["path", { "d": "M9 15c.6 1.5 1.639 2 3.283 2h-.283c1.8 0 3 -.974 3 -2.435c0 -1.194 -.831 -1.799 -2.147 -2.333l-1.975 -.802c-1.15 -.467 -1.878 -1.422 -1.878 -2.467c0 -.97 .899 -1.786 2.087 -1.893l.613 -.055c1.528 -.138 3 .762 3.3 1.985", "key": "svg-1" }], ["path", { "d": "M16 3.5v1", "key": "svg-2" }]]);

var IconBrandStorytel = createVueComponent("outline", "brand-storytel", "BrandStorytel", [["path", { "d": "M4.103 22c2.292 -2.933 16.825 -2.43 16.825 -11.538c0 -6.298 -4.974 -8.462 -8.451 -8.462c-3.477 0 -9.477 3.036 -9.477 11.241c0 6.374 1.103 8.759 1.103 8.759z", "key": "svg-0" }]]);

var IconBrandStrava = createVueComponent("outline", "brand-strava", "BrandStrava", [["path", { "d": "M15 13l-5 -10l-5 10m6 0l4 8l4 -8", "key": "svg-0" }]]);

var IconBrandStripe = createVueComponent("outline", "brand-stripe", "BrandStripe", [["path", { "d": "M11.453 8.056c0 -.623 .518 -.979 1.442 -.979c1.69 0 3.41 .343 4.605 .923l.5 -4c-.948 -.449 -2.82 -1 -5.5 -1c-1.895 0 -3.373 .087 -4.5 1c-1.172 .956 -2 2.33 -2 4c0 3.03 1.958 4.906 5 6c1.961 .69 3 .743 3 1.5c0 .735 -.851 1.5 -2 1.5c-1.423 0 -3.963 -.609 -5.5 -1.5l-.5 4c1.321 .734 3.474 1.5 6 1.5c2 0 3.957 -.468 5.084 -1.36c1.263 -.979 1.916 -2.268 1.916 -4.14c0 -3.096 -1.915 -4.547 -5 -5.637c-1.646 -.605 -2.544 -1.07 -2.544 -1.807z", "key": "svg-0" }]]);

var IconBrandSublimeText = createVueComponent("outline", "brand-sublime-text", "BrandSublimeText", [["path", { "d": "M19 8l-14 4.5v-5.5l14 -4.5z", "key": "svg-0" }], ["path", { "d": "M19 17l-14 4.5v-5.5l14 -4.5z", "key": "svg-1" }], ["path", { "d": "M19 11.5l-14 -4.5", "key": "svg-2" }], ["path", { "d": "M5 12.5l14 4.5", "key": "svg-3" }]]);

var IconBrandSugarizer = createVueComponent("outline", "brand-sugarizer", "BrandSugarizer", [["path", { "d": "M14.277 16l3.252 -3.252a1.61 1.61 0 0 0 -2.277 -2.276l-3.252 3.251l-3.252 -3.251a1.61 1.61 0 0 0 -2.276 2.276l3.251 3.252l-3.251 3.252a1.61 1.61 0 1 0 2.276 2.277l3.252 -3.252l3.252 3.252a1.61 1.61 0 1 0 2.277 -2.277l-3.252 -3.252z", "key": "svg-0" }], ["path", { "d": "M12 5m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }]]);

var IconBrandSupabase = createVueComponent("outline", "brand-supabase", "BrandSupabase", [["path", { "d": "M4 14h8v7l8 -11h-8v-7z", "key": "svg-0" }]]);

var IconBrandSuperhuman = createVueComponent("outline", "brand-superhuman", "BrandSuperhuman", [["path", { "d": "M16 12l4 3l-8 7l-8 -7l4 -3", "key": "svg-0" }], ["path", { "d": "M12 3l-8 6l8 6l8 -6z", "key": "svg-1" }], ["path", { "d": "M12 15h8", "key": "svg-2" }]]);

var IconBrandSupernova = createVueComponent("outline", "brand-supernova", "BrandSupernova", [["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 15h.5c3.038 0 5.5 -1.343 5.5 -3s-2.462 -3 -5.5 -3c-1.836 0 -3.462 .49 -4.46 1.245", "key": "svg-1" }], ["path", { "d": "M9 9h-.5c-3.038 0 -5.5 1.343 -5.5 3s2.462 3 5.5 3c1.844 0 3.476 -.495 4.474 -1.255", "key": "svg-2" }], ["path", { "d": "M15 9v-.5c0 -3.038 -1.343 -5.5 -3 -5.5s-3 2.462 -3 5.5c0 1.833 .49 3.457 1.241 4.456", "key": "svg-3" }], ["path", { "d": "M9 15v.5c0 3.038 1.343 5.5 3 5.5s3 -2.462 3 -5.5c0 -1.842 -.494 -3.472 -1.252 -4.47", "key": "svg-4" }]]);

var IconBrandSurfshark = createVueComponent("outline", "brand-surfshark", "BrandSurfshark", [["path", { "d": "M19.954 9.447c-.237 -6.217 0 -6.217 -6 -6.425c-5.774 -.208 -6.824 1 -7.91 5.382c-2.884 11.816 -3.845 14.716 4.792 11.198c9.392 -3.831 9.297 -5.382 9.114 -10.155z", "key": "svg-0" }], ["path", { "d": "M8 16h.452c1.943 .007 3.526 -1.461 3.543 -3.286v-2.428c.018 -1.828 1.607 -3.298 3.553 -3.286h.452", "key": "svg-1" }]]);

var IconBrandSvelte = createVueComponent("outline", "brand-svelte", "BrandSvelte", [["path", { "d": "M15 8l-5 3l.821 -.495c1.86 -1.15 4.412 -.49 5.574 1.352a3.91 3.91 0 0 1 -1.264 5.42l-5.053 3.126c-1.86 1.151 -4.312 .591 -5.474 -1.251a3.91 3.91 0 0 1 1.263 -5.42l.26 -.16", "key": "svg-0" }], ["path", { "d": "M8 17l5 -3l-.822 .496c-1.86 1.151 -4.411 .491 -5.574 -1.351a3.91 3.91 0 0 1 1.264 -5.42l5.054 -3.127c1.86 -1.15 4.311 -.59 5.474 1.252a3.91 3.91 0 0 1 -1.264 5.42l-.26 .16", "key": "svg-1" }]]);

var IconBrandSwift = createVueComponent("outline", "brand-swift", "BrandSwift", [["path", { "d": "M20.547 15.828c1.33 -4.126 -1.384 -9.521 -6.047 -12.828c-.135 -.096 2.39 6.704 1.308 9.124c-2.153 -1.454 -4.756 -3.494 -7.808 -6.124l-.5 2l-3.5 -1c4.36 4.748 7.213 7.695 8.56 8.841c-4.658 2.089 -10.65 -.978 -10.56 -.841c1.016 1.545 6 6 11 6c2 0 3.788 -.502 4.742 -1.389c.005 -.005 .432 -.446 1.378 -.17c.504 .148 1.463 .667 2.88 1.559v-1.507c0 -1.377 -.515 -2.67 -1.453 -3.665z", "key": "svg-0" }]]);

var IconBrandSymfony = createVueComponent("outline", "brand-symfony", "BrandSymfony", [["path", { "d": "M6 13c.458 .667 1.125 1 2 1c1.313 0 2 -.875 2 -1.5c0 -1.5 -2 -1 -2 -2c0 -.625 .516 -1.5 1.5 -1.5c2.5 0 1.563 2 5.5 2c.667 0 1 -.333 1 -1", "key": "svg-0" }], ["path", { "d": "M9 17c-.095 .667 .238 1 1 1c1.714 0 2.714 -2 3 -6c.286 -4 1.571 -6 3 -6c.571 0 .905 .333 1 1", "key": "svg-1" }], ["path", { "d": "M22 12c0 5.523 -4.477 10 -10 10s-10 -4.477 -10 -10s4.477 -10 10 -10a10 10 0 0 1 10 10z", "key": "svg-2" }]]);

var IconBrandTabler = createVueComponent("outline", "brand-tabler", "BrandTabler", [["path", { "d": "M8 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M13 15h3", "key": "svg-1" }], ["path", { "d": "M3 7a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v10a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z", "key": "svg-2" }]]);

var IconBrandTailwind = createVueComponent("outline", "brand-tailwind", "BrandTailwind", [["path", { "d": "M11.667 6c-2.49 0 -4.044 1.222 -4.667 3.667c.933 -1.223 2.023 -1.68 3.267 -1.375c.71 .174 1.217 .68 1.778 1.24c.916 .912 2 1.968 4.288 1.968c2.49 0 4.044 -1.222 4.667 -3.667c-.933 1.223 -2.023 1.68 -3.267 1.375c-.71 -.174 -1.217 -.68 -1.778 -1.24c-.916 -.912 -1.975 -1.968 -4.288 -1.968zm-4 6.5c-2.49 0 -4.044 1.222 -4.667 3.667c.933 -1.223 2.023 -1.68 3.267 -1.375c.71 .174 1.217 .68 1.778 1.24c.916 .912 1.975 1.968 4.288 1.968c2.49 0 4.044 -1.222 4.667 -3.667c-.933 1.223 -2.023 1.68 -3.267 1.375c-.71 -.174 -1.217 -.68 -1.778 -1.24c-.916 -.912 -1.975 -1.968 -4.288 -1.968z", "key": "svg-0" }]]);

var IconBrandTaobao = createVueComponent("outline", "brand-taobao", "BrandTaobao", [["path", { "d": "M2 5c.968 .555 1.335 1.104 2 2", "key": "svg-0" }], ["path", { "d": "M2 10c5.007 3.674 2.85 6.544 0 10", "key": "svg-1" }], ["path", { "d": "M10 4c-.137 4.137 -2.258 5.286 -3.709 6.684", "key": "svg-2" }], ["path", { "d": "M10 6c2.194 -.8 3.736 -.852 6.056 -.993c4.206 -.158 5.523 2.264 5.803 5.153c.428 4.396 -.077 7.186 -2.117 9.298c-1.188 1.23 -3.238 2.62 -7.207 .259", "key": "svg-3" }], ["path", { "d": "M11 10h6", "key": "svg-4" }], ["path", { "d": "M13 10v6.493", "key": "svg-5" }], ["path", { "d": "M8 13h10", "key": "svg-6" }], ["path", { "d": "M16 15.512l.853 1.72", "key": "svg-7" }], ["path", { "d": "M16.5 17c-1.145 .361 -7 3 -8.5 -.5", "key": "svg-8" }], ["path", { "d": "M11.765 8.539l-1.765 2.461", "key": "svg-9" }]]);

var IconBrandTeams = createVueComponent("outline", "brand-teams", "BrandTeams", [["path", { "d": "M3 7h10v10h-10z", "key": "svg-0" }], ["path", { "d": "M6 10h4", "key": "svg-1" }], ["path", { "d": "M8 10v4", "key": "svg-2" }], ["path", { "d": "M8.104 17c.47 2.274 2.483 4 4.896 4a5 5 0 0 0 5 -5v-7h-5", "key": "svg-3" }], ["path", { "d": "M18 18a4 4 0 0 0 4 -4v-5h-4", "key": "svg-4" }], ["path", { "d": "M13.003 8.83a3 3 0 1 0 -1.833 -1.833", "key": "svg-5" }], ["path", { "d": "M15.83 8.36a2.5 2.5 0 1 0 .594 -4.117", "key": "svg-6" }]]);

var IconBrandTed = createVueComponent("outline", "brand-ted", "BrandTed", [["path", { "d": "M2 8h4", "key": "svg-0" }], ["path", { "d": "M4 8v8", "key": "svg-1" }], ["path", { "d": "M13 8h-4v8h4", "key": "svg-2" }], ["path", { "d": "M9 12h2.5", "key": "svg-3" }], ["path", { "d": "M16 8v8h2a3 3 0 0 0 3 -3v-2a3 3 0 0 0 -3 -3h-2z", "key": "svg-4" }]]);

var IconBrandTelegram = createVueComponent("outline", "brand-telegram", "BrandTelegram", [["path", { "d": "M15 10l-4 4l6 6l4 -16l-18 7l4 2l2 6l3 -4", "key": "svg-0" }]]);

var IconBrandTerraform = createVueComponent("outline", "brand-terraform", "BrandTerraform", [["path", { "d": "M15 15.5l-11.476 -6.216a1 1 0 0 1 -.524 -.88v-4.054a1.35 1.35 0 0 1 2.03 -1.166l9.97 5.816v10.65a1.35 1.35 0 0 1 -2.03 1.166l-3.474 -2.027a1 1 0 0 1 -.496 -.863v-11.926", "key": "svg-0" }], ["path", { "d": "M15 15.5l5.504 -3.21a1 1 0 0 0 .496 -.864v-3.576a1.35 1.35 0 0 0 -2.03 -1.166l-3.97 2.316", "key": "svg-1" }]]);

var IconBrandTesla = createVueComponent("outline", "brand-tesla", "BrandTesla", [["path", { "d": "M12 21l3 -11c2.359 0 3 0 3 1c0 0 1.18 -1.745 2 -3c-3.077 -1.464 -6 -1 -6 -1l-2 2l-2 -2s-2.923 -.464 -6 1c.82 1.255 2 3 2 3c0 -1 .744 -1 3 -1z", "key": "svg-0" }], ["path", { "d": "M20 5c-5.114 -2 -10.886 -2 -16 0", "key": "svg-1" }]]);

var IconBrandTether = createVueComponent("outline", "brand-tether", "BrandTether", [["path", { "d": "M14.08 20.188c-1.15 1.083 -3.02 1.083 -4.17 0l-6.93 -6.548c-.96 -.906 -1.27 -2.624 -.69 -3.831l2.4 -5.018c.47 -.991 1.72 -1.791 2.78 -1.791h9.06c1.06 0 2.31 .802 2.78 1.79l2.4 5.019c.58 1.207 .26 2.925 -.69 3.83c-3.453 3.293 -3.466 3.279 -6.94 6.549z", "key": "svg-0" }], ["path", { "d": "M12 15v-7", "key": "svg-1" }], ["path", { "d": "M8 8h8", "key": "svg-2" }]]);

var IconBrandThingiverse = createVueComponent("outline", "brand-thingiverse", "BrandThingiverse", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 9h8m-4 0v8", "key": "svg-1" }]]);

var IconBrandThreads = createVueComponent("outline", "brand-threads", "BrandThreads", [["path", { "d": "M19 7.5c-1.333 -3 -3.667 -4.5 -7 -4.5c-5 0 -8 2.5 -8 9s3.5 9 8 9s7 -3 7 -5s-1 -5 -7 -5c-2.5 0 -3 1.25 -3 2.5c0 1.5 1 2.5 2.5 2.5c2.5 0 3.5 -1.5 3.5 -5s-2 -4 -3 -4s-1.833 .333 -2.5 1", "key": "svg-0" }]]);

var IconBrandThreejs = createVueComponent("outline", "brand-threejs", "BrandThreejs", [["path", { "d": "M8 22l-5 -19l19 5.5z", "key": "svg-0" }], ["path", { "d": "M12.573 17.58l-6.152 -1.576l8.796 -9.466l1.914 6.64", "key": "svg-1" }], ["path", { "d": "M12.573 17.58l-1.573 -6.58l6.13 2.179", "key": "svg-2" }], ["path", { "d": "M9.527 4.893l1.473 6.107l-6.31 -1.564z", "key": "svg-3" }]]);

var IconBrandTidal = createVueComponent("outline", "brand-tidal", "BrandTidal", [["path", { "d": "M5.333 6l3.334 3.25l3.333 -3.25l3.333 3.25l3.334 -3.25l3.333 3.25l-3.333 3.25l-3.334 -3.25l-3.333 3.25l3.333 3.25l-3.333 3.25l-3.333 -3.25l3.333 -3.25l-3.333 -3.25l-3.334 3.25l-3.333 -3.25z", "key": "svg-0" }]]);

var IconBrandTiktok = createVueComponent("outline", "brand-tiktok", "BrandTiktok", [["path", { "d": "M21 7.917v4.034a9.948 9.948 0 0 1 -5 -1.951v4.5a6.5 6.5 0 1 1 -8 -6.326v4.326a2.5 2.5 0 1 0 4 2v-11.5h4.083a6.005 6.005 0 0 0 4.917 4.917z", "key": "svg-0" }]]);

var IconBrandTinder = createVueComponent("outline", "brand-tinder", "BrandTinder", [["path", { "d": "M18.918 8.174c2.56 4.982 .501 11.656 -5.38 12.626c-7.702 1.687 -12.84 -7.716 -7.054 -13.229c.309 -.305 1.161 -1.095 1.516 -1.349c0 .528 .27 3.475 1 3.167c3 0 4 -4.222 3.587 -7.389c2.7 1.411 4.987 3.376 6.331 6.174z", "key": "svg-0" }]]);

var IconBrandTopbuzz = createVueComponent("outline", "brand-topbuzz", "BrandTopbuzz", [["path", { "d": "M4.417 8.655a.524 .524 0 0 1 -.405 -.622l.986 -4.617a.524 .524 0 0 1 .626 -.404l14.958 3.162c.285 .06 .467 .339 .406 .622l-.987 4.618a.524 .524 0 0 1 -.625 .404l-4.345 -.92c-.198 -.04 -.315 .024 -.353 .197l-2.028 9.49a.527 .527 0 0 1 -.625 .404l-4.642 -.982a.527 .527 0 0 1 -.406 -.622l2.028 -9.493c.037 -.17 -.031 -.274 -.204 -.31l-4.384 -.927z", "key": "svg-0" }]]);

var IconBrandTorchain = createVueComponent("outline", "brand-torchain", "BrandTorchain", [["path", { "d": "M15.588 15.537l-3.553 -3.537l-7.742 8.18c-.791 .85 .153 2.18 1.238 1.73l9.616 -4.096a1.398 1.398 0 0 0 .44 -2.277z", "key": "svg-0" }], ["path", { "d": "M8.412 8.464l3.553 3.536l7.742 -8.18c.791 -.85 -.153 -2.18 -1.238 -1.73l-9.616 4.098a1.398 1.398 0 0 0 -.44 2.277z", "key": "svg-1" }]]);

var IconBrandToyota = createVueComponent("outline", "brand-toyota", "BrandToyota", [["path", { "d": "M12 12m-10 0a10 7 0 1 0 20 0a10 7 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M9 12c0 3.866 1.343 7 3 7s3 -3.134 3 -7s-1.343 -7 -3 -7s-3 3.134 -3 7z", "key": "svg-1" }], ["path", { "d": "M6.415 6.191c-.888 .503 -1.415 1.13 -1.415 1.809c0 1.657 3.134 3 7 3s7 -1.343 7 -3c0 -.678 -.525 -1.304 -1.41 -1.806", "key": "svg-2" }]]);

var IconBrandTrello = createVueComponent("outline", "brand-trello", "BrandTrello", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 7h3v10h-3z", "key": "svg-1" }], ["path", { "d": "M14 7h3v6h-3z", "key": "svg-2" }]]);

var IconBrandTripadvisor = createVueComponent("outline", "brand-tripadvisor", "BrandTripadvisor", [["path", { "d": "M6.5 13.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-0" }], ["path", { "d": "M17.5 13.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-1" }], ["path", { "d": "M17.5 9a4.5 4.5 0 1 0 3.5 1.671l1 -1.671h-4.5z", "key": "svg-2" }], ["path", { "d": "M6.5 9a4.5 4.5 0 1 1 -3.5 1.671l-1 -1.671h4.5z", "key": "svg-3" }], ["path", { "d": "M10.5 15.5l1.5 2l1.5 -2", "key": "svg-4" }], ["path", { "d": "M9 6.75c2 -.667 4 -.667 6 0", "key": "svg-5" }]]);

var IconBrandTumblr = createVueComponent("outline", "brand-tumblr", "BrandTumblr", [["path", { "d": "M14 21h4v-4h-4v-6h4v-4h-4v-4h-4v1a3 3 0 0 1 -3 3h-1v4h4v6a4 4 0 0 0 4 4", "key": "svg-0" }]]);

var IconBrandTwilio = createVueComponent("outline", "brand-twilio", "BrandTwilio", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M9 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M15 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M15 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconBrandTwitch = createVueComponent("outline", "brand-twitch", "BrandTwitch", [["path", { "d": "M4 5v11a1 1 0 0 0 1 1h2v4l4 -4h5.584c.266 0 .52 -.105 .707 -.293l2.415 -2.414c.187 -.188 .293 -.442 .293 -.708v-8.585a1 1 0 0 0 -1 -1h-14a1 1 0 0 0 -1 1z", "key": "svg-0" }], ["path", { "d": "M16 8l0 4", "key": "svg-1" }], ["path", { "d": "M12 8l0 4", "key": "svg-2" }]]);

var IconBrandTwitter = createVueComponent("outline", "brand-twitter", "BrandTwitter", [["path", { "d": "M22 4.01c-1 .49 -1.98 .689 -3 .99c-1.121 -1.265 -2.783 -1.335 -4.38 -.737s-2.643 2.06 -2.62 3.737v1c-3.245 .083 -6.135 -1.395 -8 -4c0 0 -4.182 7.433 4 11c-1.872 1.247 -3.739 2.088 -6 2c3.308 1.803 6.913 2.423 10.034 1.517c3.58 -1.04 6.522 -3.723 7.651 -7.742a13.84 13.84 0 0 0 .497 -3.753c0 -.249 1.51 -2.772 1.818 -4.013z", "key": "svg-0" }]]);

var IconBrandTypescript = createVueComponent("outline", "brand-typescript", "BrandTypescript", [["path", { "d": "M15 17.5c.32 .32 .754 .5 1.207 .5h.543c.69 0 1.25 -.56 1.25 -1.25v-.25a1.5 1.5 0 0 0 -1.5 -1.5a1.5 1.5 0 0 1 -1.5 -1.5v-.25c0 -.69 .56 -1.25 1.25 -1.25h.543c.453 0 .887 .18 1.207 .5", "key": "svg-0" }], ["path", { "d": "M9 12h4", "key": "svg-1" }], ["path", { "d": "M11 12v6", "key": "svg-2" }], ["path", { "d": "M21 19v-14a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2z", "key": "svg-3" }]]);

var IconBrandUber = createVueComponent("outline", "brand-uber", "BrandUber", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 9m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M3 12h6", "key": "svg-2" }]]);

var IconBrandUbuntu = createVueComponent("outline", "brand-ubuntu", "BrandUbuntu", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17.723 7.41a7.992 7.992 0 0 0 -3.74 -2.162m-3.971 0a7.993 7.993 0 0 0 -3.789 2.216m-1.881 3.215a8 8 0 0 0 -.342 2.32c0 .738 .1 1.453 .287 2.132m1.96 3.428a7.993 7.993 0 0 0 3.759 2.19m4 0a7.993 7.993 0 0 0 3.747 -2.186m1.962 -3.43a8.008 8.008 0 0 0 .287 -2.131c0 -.764 -.107 -1.503 -.307 -2.203", "key": "svg-1" }], ["path", { "d": "M5 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }]]);

var IconBrandUnity = createVueComponent("outline", "brand-unity", "BrandUnity", [["path", { "d": "M14 3l6 4v7", "key": "svg-0" }], ["path", { "d": "M18 17l-6 4l-6 -4", "key": "svg-1" }], ["path", { "d": "M4 14v-7l6 -4", "key": "svg-2" }], ["path", { "d": "M4 7l8 5v9", "key": "svg-3" }], ["path", { "d": "M20 7l-8 5", "key": "svg-4" }]]);

var IconBrandUnsplash = createVueComponent("outline", "brand-unsplash", "BrandUnsplash", [["path", { "d": "M4 11h5v4h6v-4h5v9h-16zm5 -7h6v4h-6z", "key": "svg-0" }]]);

var IconBrandUpwork = createVueComponent("outline", "brand-upwork", "BrandUpwork", [["path", { "d": "M3 7v5a3 3 0 0 0 6 0v-5h1l4 6c.824 1.319 1.945 2 3.5 2a3.5 3.5 0 0 0 0 -7c-2.027 0 -3.137 1 -3.5 3c-.242 1.33 -.908 4 -2 8", "key": "svg-0" }]]);

var IconBrandValorant = createVueComponent("outline", "brand-valorant", "BrandValorant", [["path", { "d": "M14.5 14h4.5l2 -2v-6z", "key": "svg-0" }], ["path", { "d": "M9 19h5l-11 -13v6z", "key": "svg-1" }]]);

var IconBrandVercel = createVueComponent("outline", "brand-vercel", "BrandVercel", [["path", { "d": "M3 19h18l-9 -15z", "key": "svg-0" }]]);

var IconBrandVimeo = createVueComponent("outline", "brand-vimeo", "BrandVimeo", [["path", { "d": "M3 8.5l1 1s1.5 -1.102 2 -.5c.509 .609 1.863 7.65 2.5 9c.556 1.184 1.978 2.89 4 1.5c2 -1.5 7.5 -5.5 8.5 -11.5c.444 -2.661 -1 -4 -2.5 -4c-2 0 -4.047 1.202 -4.5 4c2.05 -1.254 2.551 1 1.5 3c-1.052 2 -2 3 -2.5 3c-.49 0 -.924 -1.165 -1.5 -3.5c-.59 -2.42 -.5 -6.5 -3 -6.5s-5.5 4.5 -5.5 4.5z", "key": "svg-0" }]]);

var IconBrandVinted = createVueComponent("outline", "brand-vinted", "BrandVinted", [["path", { "d": "M11.028 6c0 7.695 -.292 11.728 0 12c2.046 -5 4.246 -12.642 5.252 -14.099c.343 -.497 .768 -.93 1.257 -1.277c.603 -.39 1.292 -.76 1.463 -.575c-.07 2.319 -4.023 15.822 -4.209 16.314a6.135 6.135 0 0 1 -3.465 3.386c-3.213 .78 -3.429 -.446 -3.836 -1.134c-.95 -2.103 -1.682 -14.26 -1.445 -15.615c.05 -.523 .143 -1.851 2.491 -2c2.359 -.354 2.547 1.404 2.492 3z", "key": "svg-0" }]]);

var IconBrandVisa = createVueComponent("outline", "brand-visa", "BrandVisa", [["path", { "d": "M21 15l-1 -6l-2.5 6", "key": "svg-0" }], ["path", { "d": "M9 15l1 -6", "key": "svg-1" }], ["path", { "d": "M3 9h1v6h.5l2.5 -6", "key": "svg-2" }], ["path", { "d": "M16 9.5a.5 .5 0 0 0 -.5 -.5h-.75c-.721 0 -1.337 .521 -1.455 1.233l-.09 .534a1.059 1.059 0 0 0 1.045 1.233a1.059 1.059 0 0 1 1.045 1.233l-.09 .534a1.476 1.476 0 0 1 -1.455 1.233h-.75a.5 .5 0 0 1 -.5 -.5", "key": "svg-3" }], ["path", { "d": "M18 14h2.7", "key": "svg-4" }]]);

var IconBrandVisualStudio = createVueComponent("outline", "brand-visual-studio", "BrandVisualStudio", [["path", { "d": "M4 8l2 -1l10 13l4 -2v-12l-4 -2l-10 13l-2 -1z", "key": "svg-0" }]]);

var IconBrandVite = createVueComponent("outline", "brand-vite", "BrandVite", [["path", { "d": "M10 4.5l6 -1.5l-2 6.5l2 -.5l-4 7v-5l-3 1z", "key": "svg-0" }], ["path", { "d": "M15 6.5l7 -1.5l-10 17l-10 -17l7.741 1.5", "key": "svg-1" }]]);

var IconBrandVivaldi = createVueComponent("outline", "brand-vivaldi", "BrandVivaldi", [["path", { "d": "M21.648 6.808c-2.468 4.28 -4.937 8.56 -7.408 12.836c-.397 .777 -1.366 1.301 -2.24 1.356c-.962 .102 -1.7 -.402 -2.154 -1.254c-1.563 -2.684 -3.106 -5.374 -4.66 -8.064c-.943 -1.633 -1.891 -3.266 -2.83 -4.905a2.47 2.47 0 0 1 -.06 -2.45a2.493 2.493 0 0 1 2.085 -1.307c.951 -.065 1.85 .438 2.287 1.281c.697 1.19 2.043 3.83 2.55 4.682a3.919 3.919 0 0 0 3.282 2.017c2.126 .133 3.974 -.95 4.21 -3.058c0 -.164 .228 -3.178 .846 -3.962c.619 -.784 1.64 -1.155 2.606 -.893a2.484 2.484 0 0 1 1.814 2.062c.08 .581 -.041 1.171 -.343 1.674", "key": "svg-0" }]]);

var IconBrandVk = createVueComponent("outline", "brand-vk", "BrandVk", [["path", { "d": "M14 19h-4a8 8 0 0 1 -8 -8v-5h4v5a4 4 0 0 0 4 4h0v-9h4v4.5l.03 0a4.531 4.531 0 0 0 3.97 -4.496h4l-.342 1.711a6.858 6.858 0 0 1 -3.658 4.789h0a5.34 5.34 0 0 1 3.566 4.111l.434 2.389h0h-4a4.531 4.531 0 0 0 -3.97 -4.496v4.5z", "key": "svg-0" }]]);

var IconBrandVlc = createVueComponent("outline", "brand-vlc", "BrandVlc", [["path", { "d": "M13.79 4.337l3.101 9.305c.33 .985 -.113 2.07 -1.02 2.499a9.148 9.148 0 0 1 -7.742 0c-.907 -.428 -1.35 -1.514 -1.02 -2.499l3.1 -9.305c.267 -.8 .985 -1.337 1.791 -1.337c.807 0 1.525 .537 1.79 1.337z", "key": "svg-0" }], ["path", { "d": "M7 14h-1.429a2 2 0 0 0 -1.923 1.45l-.571 2a2 2 0 0 0 1.923 2.55h13.998a2 2 0 0 0 1.923 -2.55l-.572 -2a2 2 0 0 0 -1.923 -1.45h-1.426", "key": "svg-1" }]]);

var IconBrandVolkswagen = createVueComponent("outline", "brand-volkswagen", "BrandVolkswagen", [["path", { "d": "M12 21a9 9 0 0 0 9 -9a9 9 0 0 0 -9 -9a9 9 0 0 0 -9 9a9 9 0 0 0 9 9z", "key": "svg-0" }], ["path", { "d": "M5 7l4.5 11l1.5 -5h2l1.5 5l4.5 -11", "key": "svg-1" }], ["path", { "d": "M9 4l2 6h2l2 -6", "key": "svg-2" }]]);

var IconBrandVsco = createVueComponent("outline", "brand-vsco", "BrandVsco", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M17 12a5 5 0 1 0 -10 0a5 5 0 0 0 10 0z", "key": "svg-1" }], ["path", { "d": "M12 3v4", "key": "svg-2" }], ["path", { "d": "M21 12h-4", "key": "svg-3" }], ["path", { "d": "M12 21v-4", "key": "svg-4" }], ["path", { "d": "M3 12h4", "key": "svg-5" }], ["path", { "d": "M18.364 5.636l-2.828 2.828", "key": "svg-6" }], ["path", { "d": "M18.364 18.364l-2.828 -2.828", "key": "svg-7" }], ["path", { "d": "M5.636 18.364l2.828 -2.828", "key": "svg-8" }], ["path", { "d": "M5.636 5.636l2.828 2.828", "key": "svg-9" }]]);

var IconBrandVscode = createVueComponent("outline", "brand-vscode", "BrandVscode", [["path", { "d": "M16 3v18l4 -2.5v-13z", "key": "svg-0" }], ["path", { "d": "M9.165 13.903l-4.165 3.597l-2 -1l4.333 -4.5m1.735 -1.802l6.932 -7.198v5l-4.795 4.141", "key": "svg-1" }], ["path", { "d": "M16 16.5l-11 -10l-2 1l13 13.5", "key": "svg-2" }]]);

var IconBrandVue = createVueComponent("outline", "brand-vue", "BrandVue", [["path", { "d": "M16.5 4l-4.5 8l-4.5 -8", "key": "svg-0" }], ["path", { "d": "M3 4l9 16l9 -16", "key": "svg-1" }]]);

var IconBrandWalmart = createVueComponent("outline", "brand-walmart", "BrandWalmart", [["path", { "d": "M12 8.04v-5.04", "key": "svg-0" }], ["path", { "d": "M15.5 10l4.5 -2.5", "key": "svg-1" }], ["path", { "d": "M15.5 14l4.5 2.5", "key": "svg-2" }], ["path", { "d": "M12 15.96v5.04", "key": "svg-3" }], ["path", { "d": "M8.5 14l-4.5 2.5", "key": "svg-4" }], ["path", { "d": "M8.5 10l-4.5 -2.505", "key": "svg-5" }]]);

var IconBrandWaze = createVueComponent("outline", "brand-waze", "BrandWaze", [["path", { "d": "M6.66 17.52a7 7 0 0 1 -3.66 -4.52c2 0 3 -1 3 -2.51c0 -3.92 2.25 -7.49 7.38 -7.49c4.62 0 7.62 3.51 7.62 8a8.08 8.08 0 0 1 -3.39 6.62", "key": "svg-0" }], ["path", { "d": "M10 18.69a17.29 17.29 0 0 0 3.33 .3h.54", "key": "svg-1" }], ["path", { "d": "M16 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M8 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M16 9h.01", "key": "svg-4" }], ["path", { "d": "M11 9h.01", "key": "svg-5" }]]);

var IconBrandWebflow = createVueComponent("outline", "brand-webflow", "BrandWebflow", [["path", { "d": "M17 10s-1.376 3.606 -1.5 4c-.046 -.4 -1.5 -8 -1.5 -8c-2.627 0 -3.766 1.562 -4.5 3.5c0 0 -1.843 4.593 -2 5c-.013 -.368 -.5 -4.5 -.5 -4.5c-.15 -2.371 -2.211 -3.98 -4 -3.98l2 12.98c2.745 -.013 4.72 -1.562 5.5 -3.5c0 0 1.44 -4.3 1.5 -4.5c.013 .18 1 8 1 8c2.758 0 4.694 -1.626 5.5 -3.5l3.5 -9.5c-2.732 0 -4.253 2.055 -5 4z", "key": "svg-0" }]]);

var IconBrandWechat = createVueComponent("outline", "brand-wechat", "BrandWechat", [["path", { "d": "M16.5 10c3.038 0 5.5 2.015 5.5 4.5c0 1.397 -.778 2.645 -2 3.47l0 2.03l-1.964 -1.178a6.649 6.649 0 0 1 -1.536 .178c-3.038 0 -5.5 -2.015 -5.5 -4.5s2.462 -4.5 5.5 -4.5z", "key": "svg-0" }], ["path", { "d": "M11.197 15.698c-.69 .196 -1.43 .302 -2.197 .302a8.008 8.008 0 0 1 -2.612 -.432l-2.388 1.432v-2.801c-1.237 -1.082 -2 -2.564 -2 -4.199c0 -3.314 3.134 -6 7 -6c3.782 0 6.863 2.57 7 5.785l0 .233", "key": "svg-1" }], ["path", { "d": "M10 8h.01", "key": "svg-2" }], ["path", { "d": "M7 8h.01", "key": "svg-3" }], ["path", { "d": "M15 14h.01", "key": "svg-4" }], ["path", { "d": "M18 14h.01", "key": "svg-5" }]]);

var IconBrandWeibo = createVueComponent("outline", "brand-weibo", "BrandWeibo", [["path", { "d": "M19 14.127c0 3.073 -3.502 5.873 -8 5.873c-4.126 0 -8 -2.224 -8 -5.565c0 -1.78 .984 -3.737 2.7 -5.567c2.362 -2.51 5.193 -3.687 6.551 -2.238c.415 .44 .752 1.39 .749 2.062c2 -1.615 4.308 .387 3.5 2.693c1.26 .557 2.5 .538 2.5 2.742z", "key": "svg-0" }], ["path", { "d": "M15 4h1a5 5 0 0 1 5 5v1", "key": "svg-1" }]]);

var IconBrandWhatsapp = createVueComponent("outline", "brand-whatsapp", "BrandWhatsapp", [["path", { "d": "M3 21l1.65 -3.8a9 9 0 1 1 3.4 2.9l-5.05 .9", "key": "svg-0" }], ["path", { "d": "M9 10a.5 .5 0 0 0 1 0v-1a.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a.5 .5 0 0 0 0 -1h-1a.5 .5 0 0 0 0 1", "key": "svg-1" }]]);

var IconBrandWikipedia = createVueComponent("outline", "brand-wikipedia", "BrandWikipedia", [["path", { "d": "M3 4.984h2", "key": "svg-0" }], ["path", { "d": "M8 4.984h2.5", "key": "svg-1" }], ["path", { "d": "M14.5 4.984h2.5", "key": "svg-2" }], ["path", { "d": "M22 4.984h-2", "key": "svg-3" }], ["path", { "d": "M4 4.984l5.455 14.516l6.545 -14.516", "key": "svg-4" }], ["path", { "d": "M9 4.984l6 14.516l6 -14.516", "key": "svg-5" }]]);

var IconBrandWindows = createVueComponent("outline", "brand-windows", "BrandWindows", [["path", { "d": "M17.8 20l-12 -1.5c-1 -.1 -1.8 -.9 -1.8 -1.9v-9.2c0 -1 .8 -1.8 1.8 -1.9l12 -1.5c1.2 -.1 2.2 .8 2.2 1.9v12.1c0 1.2 -1.1 2.1 -2.2 1.9z", "key": "svg-0" }], ["path", { "d": "M12 5l0 14", "key": "svg-1" }], ["path", { "d": "M4 12l16 0", "key": "svg-2" }]]);

var IconBrandWindy = createVueComponent("outline", "brand-windy", "BrandWindy", [["path", { "d": "M9 4c0 5.5 -.33 16 4 16s7.546 -11.27 8 -13", "key": "svg-0" }], ["path", { "d": "M3 4c.253 5.44 1.449 16 5.894 16c4.444 0 8.42 -10.036 9.106 -14", "key": "svg-1" }]]);

var IconBrandWish = createVueComponent("outline", "brand-wish", "BrandWish", [["path", { "d": "M2 6l5.981 2.392l-.639 6.037c-.18 .893 .06 1.819 .65 2.514a3 3 0 0 0 2.381 1.057a4.328 4.328 0 0 0 4.132 -3.57c-.18 .893 .06 1.819 .65 2.514a3 3 0 0 0 2.38 1.056a4.328 4.328 0 0 0 4.132 -3.57l.333 -4.633", "key": "svg-0" }], ["path", { "d": "M14.504 14.429l.334 -3", "key": "svg-1" }]]);

var IconBrandWix = createVueComponent("outline", "brand-wix", "BrandWix", [["path", { "d": "M3 9l1.5 6l1.379 -5.515a.64 .64 0 0 1 1.242 0l1.379 5.515l1.5 -6", "key": "svg-0" }], ["path", { "d": "M13 11.5v3.5", "key": "svg-1" }], ["path", { "d": "M16 9l5 6", "key": "svg-2" }], ["path", { "d": "M21 9l-5 6", "key": "svg-3" }], ["path", { "d": "M13 9h.01", "key": "svg-4" }]]);

var IconBrandWordpress = createVueComponent("outline", "brand-wordpress", "BrandWordpress", [["path", { "d": "M9.5 9h3", "key": "svg-0" }], ["path", { "d": "M4 9h2.5", "key": "svg-1" }], ["path", { "d": "M11 9l3 11l4 -9", "key": "svg-2" }], ["path", { "d": "M5.5 9l3.5 11l3 -7", "key": "svg-3" }], ["path", { "d": "M18 11c.177 -.528 1 -1.364 1 -2.5c0 -1.78 -.776 -2.5 -1.875 -2.5c-.898 0 -1.125 .812 -1.125 1.429c0 1.83 2 2.058 2 3.571z", "key": "svg-4" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-5" }]]);

var IconBrandX = createVueComponent("outline", "brand-x", "BrandX", [["path", { "d": "M4 4l11.733 16h4.267l-11.733 -16z", "key": "svg-0" }], ["path", { "d": "M4 20l6.768 -6.768m2.46 -2.46l6.772 -6.772", "key": "svg-1" }]]);

var IconBrandXamarin = createVueComponent("outline", "brand-xamarin", "BrandXamarin", [["path", { "d": "M15.958 21h-7.917a2 2 0 0 1 -1.732 -1l-4.041 -7a2 2 0 0 1 0 -2l4.041 -7a2 2 0 0 1 1.732 -1h7.917a2 2 0 0 1 1.732 1l4.042 7a2 2 0 0 1 0 2l-4.041 7a2 2 0 0 1 -1.733 1z", "key": "svg-0" }], ["path", { "d": "M15 16l-6 -8", "key": "svg-1" }], ["path", { "d": "M9 16l6 -8", "key": "svg-2" }]]);

var IconBrandXbox = createVueComponent("outline", "brand-xbox", "BrandXbox", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M6.5 5c7.72 2.266 10.037 7.597 12.5 12.5", "key": "svg-1" }], ["path", { "d": "M17.5 5c-7.72 2.266 -10.037 7.597 -12.5 12.5", "key": "svg-2" }]]);

var IconBrandXdeep = createVueComponent("outline", "brand-xdeep", "BrandXdeep", [["path", { "d": "M14.401 8.398l1.599 -2.398h5l-4 6l4 6h-5l-8 -12h-5l4 6l-4 6h5l1.596 -2.393", "key": "svg-0" }]]);

var IconBrandXing = createVueComponent("outline", "brand-xing", "BrandXing", [["path", { "d": "M16 21l-4 -7l6.5 -11", "key": "svg-0" }], ["path", { "d": "M7 7l2 3.5l-3 4.5", "key": "svg-1" }]]);

var IconBrandYahoo = createVueComponent("outline", "brand-yahoo", "BrandYahoo", [["path", { "d": "M3 6l5 0", "key": "svg-0" }], ["path", { "d": "M7 18l7 0", "key": "svg-1" }], ["path", { "d": "M4.5 6l5.5 7v5", "key": "svg-2" }], ["path", { "d": "M10 13l6 -5", "key": "svg-3" }], ["path", { "d": "M12.5 8l5 0", "key": "svg-4" }], ["path", { "d": "M20 11l0 4", "key": "svg-5" }], ["path", { "d": "M20 18l0 .01", "key": "svg-6" }]]);

var IconBrandYandex = createVueComponent("outline", "brand-yandex", "BrandYandex", [["path", { "d": "M15 20v-16h-2a4 4 0 0 0 -4 4v1a4 4 0 0 0 4 4h2", "key": "svg-0" }], ["path", { "d": "M9 20l3 -7", "key": "svg-1" }]]);

var IconBrandYarn = createVueComponent("outline", "brand-yarn", "BrandYarn", [["path", { "d": "M17.845 19.308c-1.268 .814 -2.41 1.254 -3.845 1.692c-.176 .21 -.645 .544 -.912 .588a42.469 42.469 0 0 1 -4.498 .412c-.812 .006 -1.31 -.214 -1.447 -.554c-.115 -.279 .336 -2.054 .298 -1.964c-.157 .392 -.575 1.287 -.997 1.72c-.579 .6 -1.674 .4 -2.322 .051c-.71 -.386 -.07 -1.28 -.346 -1.267c-.276 .014 -.776 -1.486 -.776 -2.236c0 -.828 .622 -1.674 1.235 -2.211a6.811 6.811 0 0 1 .46 -3.143a7.414 7.414 0 0 1 2.208 -2.615s-1.353 -1.534 -.849 -2.912c.328 -.902 .46 -.895 .567 -.935c.38 -.12 .727 -.33 1.013 -.612c.78 -.88 1.96 -1.438 3.116 -1.322c0 0 .781 -2.43 1.533 -1.936c.415 .653 .671 1.218 .967 1.936c0 0 1.15 -.7 1.25 -.5c.514 1.398 .487 3.204 .211 4.67c-.324 1.408 -.84 2.691 -1.711 3.83c-.094 .16 .98 .705 1.722 2.812c.686 1.928 .278 2.438 .278 2.688s.716 .144 2.296 -.855a5.848 5.848 0 0 1 2.984 -1.145c.735 -.066 .988 -.035 1.22 1c.232 1.035 -.346 1.406 -.744 1.506c0 0 -2.09 .675 -2.911 1.302z", "key": "svg-0" }]]);

var IconBrandYatse = createVueComponent("outline", "brand-yatse", "BrandYatse", [["path", { "d": "M7 3l5 2.876v5.088l4.197 -2.73l4.803 2.731l-9.281 5.478l-2.383 1.41l-2.334 1.377l-3 1.77v-5.565l3 -1.771z", "key": "svg-0" }]]);

var IconBrandYcombinator = createVueComponent("outline", "brand-ycombinator", "BrandYcombinator", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 7l4 6l4 -6", "key": "svg-1" }], ["path", { "d": "M12 17l0 -4", "key": "svg-2" }]]);

var IconBrandYoutubeKids = createVueComponent("outline", "brand-youtube-kids", "BrandYoutubeKids", [["path", { "d": "M18.608 17.75l-3.9 .268h-.027a13.83 13.83 0 0 0 -3.722 .828l-2.511 .908a4.111 4.111 0 0 1 -3.287 -.216a3.82 3.82 0 0 1 -1.98 -2.527l-1.376 -6.05a3.669 3.669 0 0 1 .536 -2.86a3.964 3.964 0 0 1 2.489 -1.661l11.25 -2.354c2.137 -.448 4.247 .85 4.713 2.9l1.403 6.162a3.677 3.677 0 0 1 -.697 3.086a4.007 4.007 0 0 1 -2.89 1.512v.002z", "key": "svg-0" }], ["path", { "d": "M9 10l1.208 5l4.292 -4z", "key": "svg-1" }]]);

var IconBrandYoutube = createVueComponent("outline", "brand-youtube", "BrandYoutube", [["path", { "d": "M2 8a4 4 0 0 1 4 -4h12a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-12a4 4 0 0 1 -4 -4v-8z", "key": "svg-0" }], ["path", { "d": "M10 9l5 3l-5 3z", "key": "svg-1" }]]);

var IconBrandZalando = createVueComponent("outline", "brand-zalando", "BrandZalando", [["path", { "d": "M7.531 21c-.65 0 -1 -.15 -1.196 -.27c-.266 -.157 -.753 -.563 -1.197 -1.747a20.583 20.583 0 0 1 -1.137 -6.983c.015 -2.745 .436 -5.07 1.137 -6.975c.444 -1.2 .93 -1.605 1.197 -1.763c.192 -.103 .545 -.262 1.195 -.262c.244 0 .532 .022 .871 .075a19.093 19.093 0 0 1 6.425 2.475h.007a19.572 19.572 0 0 1 5.287 4.508c.783 .99 .879 1.627 .879 1.942c0 .315 -.096 .953 -.879 1.943a19.571 19.571 0 0 1 -5.287 4.5h-.007a19.041 19.041 0 0 1 -6.425 2.474a5.01 5.01 0 0 1 -.871 .083z", "key": "svg-0" }]]);

var IconBrandZapier = createVueComponent("outline", "brand-zapier", "BrandZapier", [["path", { "d": "M3 12h6", "key": "svg-0" }], ["path", { "d": "M21 12h-6", "key": "svg-1" }], ["path", { "d": "M12 3v6", "key": "svg-2" }], ["path", { "d": "M12 15v6", "key": "svg-3" }], ["path", { "d": "M5.636 5.636l4.243 4.243", "key": "svg-4" }], ["path", { "d": "M18.364 18.364l-4.243 -4.243", "key": "svg-5" }], ["path", { "d": "M18.364 5.636l-4.243 4.243", "key": "svg-6" }], ["path", { "d": "M9.879 14.121l-4.243 4.243", "key": "svg-7" }]]);

var IconBrandZeit = createVueComponent("outline", "brand-zeit", "BrandZeit", [["path", { "d": "M3 20h18l-9 -16z", "key": "svg-0" }]]);

var IconBrandZhihu = createVueComponent("outline", "brand-zhihu", "BrandZhihu", [["path", { "d": "M14 6h6v12h-2l-2 2l-1 -2h-1z", "key": "svg-0" }], ["path", { "d": "M4 12h6.5", "key": "svg-1" }], ["path", { "d": "M10.5 6h-5", "key": "svg-2" }], ["path", { "d": "M6 4c-.5 2.5 -1.5 3.5 -2.5 4.5", "key": "svg-3" }], ["path", { "d": "M8 6v7c0 4.5 -2 5.5 -4 7", "key": "svg-4" }], ["path", { "d": "M11 18l-3 -5", "key": "svg-5" }]]);

var IconBrandZoom = createVueComponent("outline", "brand-zoom", "BrandZoom", [["path", { "d": "M17.011 9.385v5.128l3.989 3.487v-12z", "key": "svg-0" }], ["path", { "d": "M3.887 6h10.08c1.468 0 3.033 1.203 3.033 2.803v8.196a.991 .991 0 0 1 -.975 1h-10.373c-1.667 0 -2.652 -1.5 -2.652 -3l.01 -8a.882 .882 0 0 1 .208 -.71a.841 .841 0 0 1 .67 -.287z", "key": "svg-1" }]]);

var IconBrandZulip = createVueComponent("outline", "brand-zulip", "BrandZulip", [["path", { "d": "M6.5 3h11c1.325 0 2.5 1 2.5 2.5c0 2 -1.705 3.264 -2 3.5l-4.5 4l2 -5h-9a2.5 2.5 0 0 1 0 -5z", "key": "svg-0" }], ["path", { "d": "M17.5 21h-11c-1.325 0 -2.5 -1 -2.5 -2.5c0 -2 1.705 -3.264 2 -3.5l4.5 -4l-2 5h9a2.5 2.5 0 1 1 0 5z", "key": "svg-1" }]]);

var IconBrandZwift = createVueComponent("outline", "brand-zwift", "BrandZwift", [["path", { "d": "M5.5 4c-1.465 0 -2.5 1.101 -2.5 2.5s1.035 2.5 2.5 2.5h2.5l-4.637 7.19a2.434 2.434 0 0 0 -.011 2.538c.473 .787 1.35 1.272 2.3 1.272h10.848c1.465 0 2.5 -1.101 2.5 -2.5s-1.035 -2.5 -2.5 -2.5h-2.5l7 -11h-15.5z", "key": "svg-0" }]]);

var IconBreadOff = createVueComponent("outline", "bread-off", "BreadOff", [["path", { "d": "M8 4l10 .005v-.005a3 3 0 0 1 2 5.235v6.765m-.59 3.418c-.36 .36 -.86 .582 -1.41 .582h-12a2 2 0 0 1 -2 -2v-8.764a3 3 0 0 1 .418 -4.785", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBread = createVueComponent("outline", "bread", "Bread", [["path", { "d": "M18 4a3 3 0 0 1 2 5.235v8.765a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-8.764a3 3 0 0 1 1.824 -5.231h12.176v-.005z", "key": "svg-0" }]]);

var IconBriefcase2 = createVueComponent("outline", "briefcase-2", "Briefcase2", [["path", { "d": "M3 9a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9z", "key": "svg-0" }], ["path", { "d": "M8 7v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2", "key": "svg-1" }]]);

var IconBriefcaseOff = createVueComponent("outline", "briefcase-off", "BriefcaseOff", [["path", { "d": "M11 7h8a2 2 0 0 1 2 2v8m-1.166 2.818a1.993 1.993 0 0 1 -.834 .182h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M8.185 4.158a2 2 0 0 1 1.815 -1.158h4a2 2 0 0 1 2 2v2", "key": "svg-1" }], ["path", { "d": "M12 12v.01", "key": "svg-2" }], ["path", { "d": "M3 13a20 20 0 0 0 11.905 1.928m3.263 -.763a20 20 0 0 0 2.832 -1.165", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBriefcase = createVueComponent("outline", "briefcase", "Briefcase", [["path", { "d": "M3 7m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 7v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2", "key": "svg-1" }], ["path", { "d": "M12 12l0 .01", "key": "svg-2" }], ["path", { "d": "M3 13a20 20 0 0 0 18 0", "key": "svg-3" }]]);

var IconBrightness2 = createVueComponent("outline", "brightness-2", "Brightness2", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-1" }]]);

var IconBrightnessAuto = createVueComponent("outline", "brightness-auto", "BrightnessAuto", [["path", { "d": "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-0" }], ["path", { "d": "M10 14.5v-3.5a2 2 0 1 1 4 0v3.5", "key": "svg-1" }], ["path", { "d": "M10 13h4", "key": "svg-2" }]]);

var IconBrightnessDown = createVueComponent("outline", "brightness-down", "BrightnessDown", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 5l0 .01", "key": "svg-1" }], ["path", { "d": "M17 7l0 .01", "key": "svg-2" }], ["path", { "d": "M19 12l0 .01", "key": "svg-3" }], ["path", { "d": "M17 17l0 .01", "key": "svg-4" }], ["path", { "d": "M12 19l0 .01", "key": "svg-5" }], ["path", { "d": "M7 17l0 .01", "key": "svg-6" }], ["path", { "d": "M5 12l0 .01", "key": "svg-7" }], ["path", { "d": "M7 7l0 .01", "key": "svg-8" }]]);

var IconBrightnessHalf = createVueComponent("outline", "brightness-half", "BrightnessHalf", [["path", { "d": "M12 9a3 3 0 0 0 0 6v-6z", "key": "svg-0" }], ["path", { "d": "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-1" }]]);

var IconBrightnessOff = createVueComponent("outline", "brightness-off", "BrightnessOff", [["path", { "d": "M12 3v5m0 4v9", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M12.5 8.5l4.15 -4.15", "key": "svg-2" }], ["path", { "d": "M12 14l1.025 -.983m2.065 -1.981l4.28 -4.106", "key": "svg-3" }], ["path", { "d": "M12 19.6l3.79 -3.79m2 -2l3.054 -3.054", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBrightnessUp = createVueComponent("outline", "brightness-up", "BrightnessUp", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 5l0 -2", "key": "svg-1" }], ["path", { "d": "M17 7l1.4 -1.4", "key": "svg-2" }], ["path", { "d": "M19 12l2 0", "key": "svg-3" }], ["path", { "d": "M17 17l1.4 1.4", "key": "svg-4" }], ["path", { "d": "M12 19l0 2", "key": "svg-5" }], ["path", { "d": "M7 17l-1.4 1.4", "key": "svg-6" }], ["path", { "d": "M6 12l-2 0", "key": "svg-7" }], ["path", { "d": "M7 7l-1.4 -1.4", "key": "svg-8" }]]);

var IconBrightness = createVueComponent("outline", "brightness", "Brightness", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3l0 18", "key": "svg-1" }], ["path", { "d": "M12 9l4.65 -4.65", "key": "svg-2" }], ["path", { "d": "M12 14.3l7.37 -7.37", "key": "svg-3" }], ["path", { "d": "M12 19.6l8.85 -8.85", "key": "svg-4" }]]);

var IconBroadcastOff = createVueComponent("outline", "broadcast-off", "BroadcastOff", [["path", { "d": "M18.364 19.364a9 9 0 0 0 -9.721 -14.717m-2.488 1.509a9 9 0 0 0 -.519 13.208", "key": "svg-0" }], ["path", { "d": "M15.536 16.536a5 5 0 0 0 -3.536 -8.536m-3 1a5 5 0 0 0 -.535 7.536", "key": "svg-1" }], ["path", { "d": "M12 12a1 1 0 1 0 1 1", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBroadcast = createVueComponent("outline", "broadcast", "Broadcast", [["path", { "d": "M18.364 19.364a9 9 0 1 0 -12.728 0", "key": "svg-0" }], ["path", { "d": "M15.536 16.536a5 5 0 1 0 -7.072 0", "key": "svg-1" }], ["path", { "d": "M12 13m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconBrowserCheck = createVueComponent("outline", "browser-check", "BrowserCheck", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 8h16", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M9.5 14.5l1.5 1.5l3 -3", "key": "svg-3" }]]);

var IconBrowserMaximize = createVueComponent("outline", "browser-maximize", "BrowserMaximize", [["path", { "d": "M4 8h8", "key": "svg-0" }], ["path", { "d": "M20 11.5v6.5a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6.5", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 8l5 -5", "key": "svg-3" }], ["path", { "d": "M21 7.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconBrowserMinus = createVueComponent("outline", "browser-minus", "BrowserMinus", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v9", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconBrowserOff = createVueComponent("outline", "browser-off", "BrowserOff", [["path", { "d": "M8 4h11a1 1 0 0 1 1 1v11m-.288 3.702a1 1 0 0 1 -.712 .298h-14a1 1 0 0 1 -1 -1v-14c0 -.276 .112 -.526 .293 -.707", "key": "svg-0" }], ["path", { "d": "M4 8h4m4 0h8", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBrowserPlus = createVueComponent("outline", "browser-plus", "BrowserPlus", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconBrowserShare = createVueComponent("outline", "browser-share", "BrowserShare", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M12.5 20h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 22l5 -5", "key": "svg-3" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconBrowserX = createVueComponent("outline", "browser-x", "BrowserX", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 8h16", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M10 16l4 -4", "key": "svg-3" }], ["path", { "d": "M14 16l-4 -4", "key": "svg-4" }]]);

var IconBrowser = createVueComponent("outline", "browser", "Browser", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }]]);

var IconBrushOff = createVueComponent("outline", "brush-off", "BrushOff", [["path", { "d": "M3 17a4 4 0 1 1 4 4h-4v-4z", "key": "svg-0" }], ["path", { "d": "M21 3a16 16 0 0 0 -9.309 4.704m-1.795 2.212a15.993 15.993 0 0 0 -1.696 3.284", "key": "svg-1" }], ["path", { "d": "M21 3a16 16 0 0 1 -4.697 9.302m-2.195 1.786a15.993 15.993 0 0 1 -3.308 1.712", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBrush = createVueComponent("outline", "brush", "Brush", [["path", { "d": "M3 21v-4a4 4 0 1 1 4 4h-4", "key": "svg-0" }], ["path", { "d": "M21 3a16 16 0 0 0 -12.8 10.2", "key": "svg-1" }], ["path", { "d": "M21 3a16 16 0 0 1 -10.2 12.8", "key": "svg-2" }], ["path", { "d": "M10.6 9a9 9 0 0 1 4.4 4.4", "key": "svg-3" }]]);

var IconBubbleMinus = createVueComponent("outline", "bubble-minus", "BubbleMinus", [["path", { "d": "M12.4 19a4.2 4.2 0 0 1 -1.57 -.298l-3.83 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.335 5.335 0 0 1 9.194 1.078a5.333 5.333 0 0 1 3.404 8.771", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconBubblePlus = createVueComponent("outline", "bubble-plus", "BubblePlus", [["path", { "d": "M12.4 19a4.2 4.2 0 0 1 -1.57 -.298l-3.83 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.335 5.335 0 0 1 9.194 1.078a5.333 5.333 0 0 1 4.45 6.89", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconBubbleTea2 = createVueComponent("outline", "bubble-tea-2", "BubbleTea2", [["path", { "d": "M17.95 9l-1.478 8.69c-.25 1.463 -.374 2.195 -.936 2.631c-1.2 .931 -6.039 .88 -7.172 0c-.562 -.436 -.687 -1.168 -.936 -2.632l-1.478 -8.689", "key": "svg-0" }], ["path", { "d": "M6 9l.514 -1.286a5.908 5.908 0 0 1 10.972 0l.514 1.286", "key": "svg-1" }], ["path", { "d": "M5 9h14", "key": "svg-2" }], ["path", { "d": "M12 9l4 -7", "key": "svg-3" }], ["path", { "d": "M7 14c.593 .642 1.484 1.017 2.5 1c1.016 .017 1.907 -.358 2.5 -1s1.484 -1.017 2.5 -1c1.016 -.017 1.907 .358 2.5 1", "key": "svg-4" }]]);

var IconBubbleTea = createVueComponent("outline", "bubble-tea", "BubbleTea", [["path", { "d": "M17.95 9l-1.478 8.69c-.25 1.463 -.374 2.195 -.936 2.631c-1.2 .931 -6.039 .88 -7.172 0c-.562 -.436 -.687 -1.168 -.936 -2.632l-1.478 -8.689", "key": "svg-0" }], ["path", { "d": "M6 9l.514 -1.286a5.908 5.908 0 0 1 10.972 0l.514 1.286", "key": "svg-1" }], ["path", { "d": "M5 9h14", "key": "svg-2" }], ["path", { "d": "M12 9l4 -7", "key": "svg-3" }], ["path", { "d": "M10.01 14h.01", "key": "svg-4" }], ["path", { "d": "M11.02 18h.01", "key": "svg-5" }], ["path", { "d": "M13.02 16h.01", "key": "svg-6" }]]);

var IconBubbleText = createVueComponent("outline", "bubble-text", "BubbleText", [["path", { "d": "M7 10h10", "key": "svg-0" }], ["path", { "d": "M9 14h5", "key": "svg-1" }], ["path", { "d": "M12.4 3a5.34 5.34 0 0 1 4.906 3.239a5.333 5.333 0 0 1 -1.195 10.6a4.26 4.26 0 0 1 -5.28 1.863l-3.831 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.33 5.33 0 0 1 4.287 -2.16", "key": "svg-2" }]]);

var IconBubbleX = createVueComponent("outline", "bubble-x", "BubbleX", [["path", { "d": "M13.5 18.75c-.345 .09 -.727 .25 -1.1 .25a4.3 4.3 0 0 1 -1.57 -.298l-3.83 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.335 5.335 0 0 1 9.194 1.078a5.333 5.333 0 0 1 4.484 6.778", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconBubble = createVueComponent("outline", "bubble", "Bubble", [["path", { "d": "M12.4 3a5.34 5.34 0 0 1 4.906 3.239a5.333 5.333 0 0 1 -1.195 10.6a4.26 4.26 0 0 1 -5.28 1.863l-3.831 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.33 5.33 0 0 1 4.287 -2.16", "key": "svg-0" }]]);

var IconBucketDroplet = createVueComponent("outline", "bucket-droplet", "BucketDroplet", [["path", { "d": "M5 16l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z", "key": "svg-0" }], ["path", { "d": "M13.737 9.737c2.299 -2.3 3.23 -5.095 2.081 -6.245c-1.15 -1.15 -3.945 -.217 -6.244 2.082c-2.3 2.299 -3.231 5.095 -2.082 6.244c1.15 1.15 3.946 .218 6.245 -2.081z", "key": "svg-1" }], ["path", { "d": "M7.492 11.818c.362 .362 .768 .676 1.208 .934l6.895 4.047c1.078 .557 2.255 -.075 3.692 -1.512c1.437 -1.437 2.07 -2.614 1.512 -3.692c-.372 -.718 -1.72 -3.017 -4.047 -6.895a6.015 6.015 0 0 0 -.934 -1.208", "key": "svg-2" }]]);

var IconBucketOff = createVueComponent("outline", "bucket-off", "BucketOff", [["path", { "d": "M5.029 5.036c-.655 .58 -1.029 1.25 -1.029 1.964c0 2.033 3.033 3.712 6.96 3.967m3.788 -.21c3.064 -.559 5.252 -2.029 5.252 -3.757c0 -2.21 -3.582 -4 -8 -4c-1.605 0 -3.1 .236 -4.352 .643", "key": "svg-0" }], ["path", { "d": "M4 7c0 .664 .088 1.324 .263 1.965l2.737 10.035c.5 1.5 2.239 2 5 2s4.5 -.5 5 -2c.1 -.3 .252 -.812 .457 -1.535m.862 -3.146c.262 -.975 .735 -2.76 1.418 -5.354a7.45 7.45 0 0 0 .263 -1.965", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBucket = createVueComponent("outline", "bucket", "Bucket", [["path", { "d": "M12 7m-8 0a8 4 0 1 0 16 0a8 4 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 7c0 .664 .088 1.324 .263 1.965l2.737 10.035c.5 1.5 2.239 2 5 2s4.5 -.5 5 -2c.333 -1 1.246 -4.345 2.737 -10.035a7.45 7.45 0 0 0 .263 -1.965", "key": "svg-1" }]]);

var IconBugOff = createVueComponent("outline", "bug-off", "BugOff", [["path", { "d": "M9.884 5.873a3 3 0 0 1 5.116 2.127v1", "key": "svg-0" }], ["path", { "d": "M13 9h3a6 6 0 0 1 1 3v1m-.298 3.705a5 5 0 0 1 -9.702 -1.705v-3a6 6 0 0 1 1 -3h1", "key": "svg-1" }], ["path", { "d": "M3 13h4", "key": "svg-2" }], ["path", { "d": "M17 13h4", "key": "svg-3" }], ["path", { "d": "M12 20v-6", "key": "svg-4" }], ["path", { "d": "M4 19l3.35 -2", "key": "svg-5" }], ["path", { "d": "M4 7l3.75 2.4", "key": "svg-6" }], ["path", { "d": "M20 7l-3.75 2.4", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconBug = createVueComponent("outline", "bug", "Bug", [["path", { "d": "M9 9v-1a3 3 0 0 1 6 0v1", "key": "svg-0" }], ["path", { "d": "M8 9h8a6 6 0 0 1 1 3v3a5 5 0 0 1 -10 0v-3a6 6 0 0 1 1 -3", "key": "svg-1" }], ["path", { "d": "M3 13l4 0", "key": "svg-2" }], ["path", { "d": "M17 13l4 0", "key": "svg-3" }], ["path", { "d": "M12 20l0 -6", "key": "svg-4" }], ["path", { "d": "M4 19l3.35 -2", "key": "svg-5" }], ["path", { "d": "M20 19l-3.35 -2", "key": "svg-6" }], ["path", { "d": "M4 7l3.75 2.4", "key": "svg-7" }], ["path", { "d": "M20 7l-3.75 2.4", "key": "svg-8" }]]);

var IconBuildingAirport = createVueComponent("outline", "building-airport", "BuildingAirport", [["path", { "d": "M3.59 7h8.82a1 1 0 0 1 .902 1.433l-1.44 3a1 1 0 0 1 -.901 .567h-5.942a1 1 0 0 1 -.901 -.567l-1.44 -3a1 1 0 0 1 .901 -1.433", "key": "svg-0" }], ["path", { "d": "M6 7l-.78 -2.342a.5 .5 0 0 1 .473 -.658h4.612a.5 .5 0 0 1 .475 .658l-.78 2.342", "key": "svg-1" }], ["path", { "d": "M8 2v2", "key": "svg-2" }], ["path", { "d": "M6 12v9h4v-9", "key": "svg-3" }], ["path", { "d": "M3 21h18", "key": "svg-4" }], ["path", { "d": "M22 5h-6l-1 -1", "key": "svg-5" }], ["path", { "d": "M18 3l2 2l-2 2", "key": "svg-6" }], ["path", { "d": "M10 17h7a2 2 0 0 1 2 2v2", "key": "svg-7" }]]);

var IconBuildingArch = createVueComponent("outline", "building-arch", "BuildingArch", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M4 21v-15a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v15", "key": "svg-1" }], ["path", { "d": "M9 21v-8a3 3 0 0 1 6 0v8", "key": "svg-2" }]]);

var IconBuildingBank = createVueComponent("outline", "building-bank", "BuildingBank", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M3 10l18 0", "key": "svg-1" }], ["path", { "d": "M5 6l7 -3l7 3", "key": "svg-2" }], ["path", { "d": "M4 10l0 11", "key": "svg-3" }], ["path", { "d": "M20 10l0 11", "key": "svg-4" }], ["path", { "d": "M8 14l0 3", "key": "svg-5" }], ["path", { "d": "M12 14l0 3", "key": "svg-6" }], ["path", { "d": "M16 14l0 3", "key": "svg-7" }]]);

var IconBuildingBridge2 = createVueComponent("outline", "building-bridge-2", "BuildingBridge2", [["path", { "d": "M6 7h12a2 2 0 0 1 2 2v9a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a4 4 0 0 0 -8 0v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-9a2 2 0 0 1 2 -2", "key": "svg-0" }]]);

var IconBuildingBridge = createVueComponent("outline", "building-bridge", "BuildingBridge", [["path", { "d": "M6 5l0 14", "key": "svg-0" }], ["path", { "d": "M18 5l0 14", "key": "svg-1" }], ["path", { "d": "M2 15l20 0", "key": "svg-2" }], ["path", { "d": "M3 8a7.5 7.5 0 0 0 3 -2a6.5 6.5 0 0 0 12 0a7.5 7.5 0 0 0 3 2", "key": "svg-3" }], ["path", { "d": "M12 10l0 5", "key": "svg-4" }]]);

var IconBuildingBroadcastTower = createVueComponent("outline", "building-broadcast-tower", "BuildingBroadcastTower", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M16.616 13.924a5 5 0 1 0 -9.23 0", "key": "svg-1" }], ["path", { "d": "M20.307 15.469a9 9 0 1 0 -16.615 0", "key": "svg-2" }], ["path", { "d": "M9 21l3 -9l3 9", "key": "svg-3" }], ["path", { "d": "M10 19h4", "key": "svg-4" }]]);

var IconBuildingBurjAlArab = createVueComponent("outline", "building-burj-al-arab", "BuildingBurjAlArab", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M7 21v-18", "key": "svg-1" }], ["path", { "d": "M7 4c5.675 .908 10 5.613 10 11.28a11 11 0 0 1 -1.605 5.72", "key": "svg-2" }], ["path", { "d": "M5 9h12", "key": "svg-3" }], ["path", { "d": "M7 13h4", "key": "svg-4" }], ["path", { "d": "M7 17h4", "key": "svg-5" }]]);

var IconBuildingCarousel = createVueComponent("outline", "building-carousel", "BuildingCarousel", [["path", { "d": "M12 12m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M5 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M12 4m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M5 16m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19 16m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-5" }], ["path", { "d": "M8 22l4 -10l4 10", "key": "svg-6" }]]);

var IconBuildingCastle = createVueComponent("outline", "building-castle", "BuildingCastle", [["path", { "d": "M15 19v-2a3 3 0 0 0 -6 0v2a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14h4v3h3v-3h4v3h3v-3h4v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M3 11l18 0", "key": "svg-1" }]]);

var IconBuildingChurch = createVueComponent("outline", "building-church", "BuildingChurch", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M10 21v-4a2 2 0 0 1 4 0v4", "key": "svg-1" }], ["path", { "d": "M10 5l4 0", "key": "svg-2" }], ["path", { "d": "M12 3l0 5", "key": "svg-3" }], ["path", { "d": "M6 21v-7m-2 2l8 -8l8 8m-2 -2v7", "key": "svg-4" }]]);

var IconBuildingCircus = createVueComponent("outline", "building-circus", "BuildingCircus", [["path", { "d": "M4 11h16", "key": "svg-0" }], ["path", { "d": "M12 6.5c0 1 -5 4.5 -8 4.5", "key": "svg-1" }], ["path", { "d": "M12 6.5c0 1 5 4.5 8 4.5", "key": "svg-2" }], ["path", { "d": "M6 11c-.333 5.333 -1 8.667 -2 10h4c1 0 4 -4 4 -9v-1", "key": "svg-3" }], ["path", { "d": "M18 11c.333 5.333 1 8.667 2 10h-4c-1 0 -4 -4 -4 -9v-1", "key": "svg-4" }], ["path", { "d": "M12 7v-4l2 1h-2", "key": "svg-5" }]]);

var IconBuildingCog = createVueComponent("outline", "building-cog", "BuildingCog", [["path", { "d": "M3 21h9", "key": "svg-0" }], ["path", { "d": "M9 8h1", "key": "svg-1" }], ["path", { "d": "M9 12h1", "key": "svg-2" }], ["path", { "d": "M9 16h1", "key": "svg-3" }], ["path", { "d": "M14 8h1", "key": "svg-4" }], ["path", { "d": "M14 12h1", "key": "svg-5" }], ["path", { "d": "M5 21v-16c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h10c.53 0 1.039 .211 1.414 .586c.375 .375 .586 .884 .586 1.414v7", "key": "svg-6" }], ["path", { "d": "M16 18c0 .53 .211 1.039 .586 1.414c.375 .375 .884 .586 1.414 .586c.53 0 1.039 -.211 1.414 -.586c.375 -.375 .586 -.884 .586 -1.414c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586c-.53 0 -1.039 .211 -1.414 .586c-.375 .375 -.586 .884 -.586 1.414z", "key": "svg-7" }], ["path", { "d": "M18 14.5v1.5", "key": "svg-8" }], ["path", { "d": "M18 20v1.5", "key": "svg-9" }], ["path", { "d": "M21.032 16.25l-1.299 .75", "key": "svg-10" }], ["path", { "d": "M16.27 19l-1.3 .75", "key": "svg-11" }], ["path", { "d": "M14.97 16.25l1.3 .75", "key": "svg-12" }], ["path", { "d": "M19.733 19l1.3 .75", "key": "svg-13" }]]);

var IconBuildingCommunity = createVueComponent("outline", "building-community", "BuildingCommunity", [["path", { "d": "M8 9l5 5v7h-5v-4m0 4h-5v-7l5 -5m1 1v-6a1 1 0 0 1 1 -1h10a1 1 0 0 1 1 1v17h-8", "key": "svg-0" }], ["path", { "d": "M13 7l0 .01", "key": "svg-1" }], ["path", { "d": "M17 7l0 .01", "key": "svg-2" }], ["path", { "d": "M17 11l0 .01", "key": "svg-3" }], ["path", { "d": "M17 15l0 .01", "key": "svg-4" }]]);

var IconBuildingCottage = createVueComponent("outline", "building-cottage", "BuildingCottage", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M4 21v-11l2.5 -4.5l5.5 -2.5l5.5 2.5l2.5 4.5v11", "key": "svg-1" }], ["path", { "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M9 21v-5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v5", "key": "svg-3" }]]);

var IconBuildingEstate = createVueComponent("outline", "building-estate", "BuildingEstate", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M19 21v-4", "key": "svg-1" }], ["path", { "d": "M19 17a2 2 0 0 0 2 -2v-2a2 2 0 1 0 -4 0v2a2 2 0 0 0 2 2z", "key": "svg-2" }], ["path", { "d": "M14 21v-14a3 3 0 0 0 -3 -3h-4a3 3 0 0 0 -3 3v14", "key": "svg-3" }], ["path", { "d": "M9 17v4", "key": "svg-4" }], ["path", { "d": "M8 13h2", "key": "svg-5" }], ["path", { "d": "M8 9h2", "key": "svg-6" }]]);

var IconBuildingFactory2 = createVueComponent("outline", "building-factory-2", "BuildingFactory2", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M5 21v-12l5 4v-4l5 4h4", "key": "svg-1" }], ["path", { "d": "M19 21v-8l-1.436 -9.574a.5 .5 0 0 0 -.495 -.426h-1.145a.5 .5 0 0 0 -.494 .418l-1.43 8.582", "key": "svg-2" }], ["path", { "d": "M9 17h1", "key": "svg-3" }], ["path", { "d": "M14 17h1", "key": "svg-4" }]]);

var IconBuildingFactory = createVueComponent("outline", "building-factory", "BuildingFactory", [["path", { "d": "M4 21c1.147 -4.02 1.983 -8.027 2 -12h6c.017 3.973 .853 7.98 2 12", "key": "svg-0" }], ["path", { "d": "M12.5 13h4.5c.025 2.612 .894 5.296 2 8", "key": "svg-1" }], ["path", { "d": "M9 5a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1", "key": "svg-2" }], ["path", { "d": "M3 21l19 0", "key": "svg-3" }]]);

var IconBuildingFortress = createVueComponent("outline", "building-fortress", "BuildingFortress", [["path", { "d": "M7 21h1a1 1 0 0 0 1 -1v-1h0a3 3 0 0 1 6 0m3 2h1a1 1 0 0 0 1 -1v-15l-3 -2l-3 2v6h-4v-6l-3 -2l-3 2v15a1 1 0 0 0 1 1h2m8 -2v1a1 1 0 0 0 1 1h2", "key": "svg-0" }], ["path", { "d": "M7 7h0v.01", "key": "svg-1" }], ["path", { "d": "M7 10h0v.01", "key": "svg-2" }], ["path", { "d": "M7 13h0v.01", "key": "svg-3" }], ["path", { "d": "M17 7h0v.01", "key": "svg-4" }], ["path", { "d": "M17 10h0v.01", "key": "svg-5" }], ["path", { "d": "M17 13h0v.01", "key": "svg-6" }]]);

var IconBuildingHospital = createVueComponent("outline", "building-hospital", "BuildingHospital", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16", "key": "svg-1" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-2" }], ["path", { "d": "M10 9l4 0", "key": "svg-3" }], ["path", { "d": "M12 7l0 4", "key": "svg-4" }]]);

var IconBuildingLighthouse = createVueComponent("outline", "building-lighthouse", "BuildingLighthouse", [["path", { "d": "M12 3l2 3l2 15h-8l2 -15z", "key": "svg-0" }], ["path", { "d": "M8 9l8 0", "key": "svg-1" }], ["path", { "d": "M3 11l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M21 11l-2 -2l2 -2", "key": "svg-3" }]]);

var IconBuildingMinus = createVueComponent("outline", "building-minus", "BuildingMinus", [["path", { "d": "M3 21h9", "key": "svg-0" }], ["path", { "d": "M9 8h1", "key": "svg-1" }], ["path", { "d": "M9 12h1", "key": "svg-2" }], ["path", { "d": "M9 16h1", "key": "svg-3" }], ["path", { "d": "M14 8h1", "key": "svg-4" }], ["path", { "d": "M14 12h1", "key": "svg-5" }], ["path", { "d": "M5 21v-16c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h10c.53 0 1.039 .211 1.414 .586c.375 .375 .586 .884 .586 1.414v7", "key": "svg-6" }], ["path", { "d": "M16 19h6", "key": "svg-7" }]]);

var IconBuildingMonument = createVueComponent("outline", "building-monument", "BuildingMonument", [["path", { "d": "M8 18l2 -13l2 -2l2 2l2 13", "key": "svg-0" }], ["path", { "d": "M5 21v-3h14v3", "key": "svg-1" }], ["path", { "d": "M3 21l18 0", "key": "svg-2" }]]);

var IconBuildingMosque = createVueComponent("outline", "building-mosque", "BuildingMosque", [["path", { "d": "M3 21h7v-2a2 2 0 1 1 4 0v2h7", "key": "svg-0" }], ["path", { "d": "M4 21v-10", "key": "svg-1" }], ["path", { "d": "M20 21v-10", "key": "svg-2" }], ["path", { "d": "M4 16h3v-3h10v3h3", "key": "svg-3" }], ["path", { "d": "M17 13a5 5 0 0 0 -10 0", "key": "svg-4" }], ["path", { "d": "M21 10.5c0 -.329 -.077 -.653 -.224 -.947l-.776 -1.553l-.776 1.553a2.118 2.118 0 0 0 -.224 .947a.5 .5 0 0 0 .5 .5h1a.5 .5 0 0 0 .5 -.5z", "key": "svg-5" }], ["path", { "d": "M5 10.5c0 -.329 -.077 -.653 -.224 -.947l-.776 -1.553l-.776 1.553a2.118 2.118 0 0 0 -.224 .947a.5 .5 0 0 0 .5 .5h1a.5 .5 0 0 0 .5 -.5z", "key": "svg-6" }], ["path", { "d": "M12 2a2 2 0 1 0 2 2", "key": "svg-7" }], ["path", { "d": "M12 6v2", "key": "svg-8" }]]);

var IconBuildingOff = createVueComponent("outline", "building-off", "BuildingOff", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M9 12h1", "key": "svg-1" }], ["path", { "d": "M9 16h1", "key": "svg-2" }], ["path", { "d": "M14 8h1", "key": "svg-3" }], ["path", { "d": "M14 16h1", "key": "svg-4" }], ["path", { "d": "M5 21v-16", "key": "svg-5" }], ["path", { "d": "M7 3h10c1 0 2 1 2 2v10", "key": "svg-6" }], ["path", { "d": "M19 19v2", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconBuildingPavilion = createVueComponent("outline", "building-pavilion", "BuildingPavilion", [["path", { "d": "M3 21h7v-3a2 2 0 0 1 4 0v3h7", "key": "svg-0" }], ["path", { "d": "M6 21l0 -9", "key": "svg-1" }], ["path", { "d": "M18 21l0 -9", "key": "svg-2" }], ["path", { "d": "M6 12h12a3 3 0 0 0 3 -3a9 8 0 0 1 -9 -6a9 8 0 0 1 -9 6a3 3 0 0 0 3 3", "key": "svg-3" }]]);

var IconBuildingPlus = createVueComponent("outline", "building-plus", "BuildingPlus", [["path", { "d": "M3 21h9", "key": "svg-0" }], ["path", { "d": "M9 8h1", "key": "svg-1" }], ["path", { "d": "M9 12h1", "key": "svg-2" }], ["path", { "d": "M9 16h1", "key": "svg-3" }], ["path", { "d": "M14 8h1", "key": "svg-4" }], ["path", { "d": "M14 12h1", "key": "svg-5" }], ["path", { "d": "M5 21v-16c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h10c.53 0 1.039 .211 1.414 .586c.375 .375 .586 .884 .586 1.414v7", "key": "svg-6" }], ["path", { "d": "M16 19h6", "key": "svg-7" }], ["path", { "d": "M19 16v6", "key": "svg-8" }]]);

var IconBuildingSkyscraper = createVueComponent("outline", "building-skyscraper", "BuildingSkyscraper", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M5 21v-14l8 -4v18", "key": "svg-1" }], ["path", { "d": "M19 21v-10l-6 -4", "key": "svg-2" }], ["path", { "d": "M9 9l0 .01", "key": "svg-3" }], ["path", { "d": "M9 12l0 .01", "key": "svg-4" }], ["path", { "d": "M9 15l0 .01", "key": "svg-5" }], ["path", { "d": "M9 18l0 .01", "key": "svg-6" }]]);

var IconBuildingStadium = createVueComponent("outline", "building-stadium", "BuildingStadium", [["path", { "d": "M12 12m-8 0a8 2 0 1 0 16 0a8 2 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 12v7c0 .94 2.51 1.785 6 2v-3h4v3c3.435 -.225 6 -1.07 6 -2v-7", "key": "svg-1" }], ["path", { "d": "M15 6h4v-3h-4v7", "key": "svg-2" }], ["path", { "d": "M7 6h4v-3h-4v7", "key": "svg-3" }]]);

var IconBuildingStore = createVueComponent("outline", "building-store", "BuildingStore", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M3 7v1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1h-18l2 -4h14l2 4", "key": "svg-1" }], ["path", { "d": "M5 21l0 -10.15", "key": "svg-2" }], ["path", { "d": "M19 21l0 -10.15", "key": "svg-3" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-4" }]]);

var IconBuildingTunnel = createVueComponent("outline", "building-tunnel", "BuildingTunnel", [["path", { "d": "M5 21h14a2 2 0 0 0 2 -2v-7a9 9 0 0 0 -18 0v7a2 2 0 0 0 2 2z", "key": "svg-0" }], ["path", { "d": "M8 21v-9a4 4 0 1 1 8 0v9", "key": "svg-1" }], ["path", { "d": "M3 17h4", "key": "svg-2" }], ["path", { "d": "M17 17h4", "key": "svg-3" }], ["path", { "d": "M21 12h-4", "key": "svg-4" }], ["path", { "d": "M7 12h-4", "key": "svg-5" }], ["path", { "d": "M12 3v5", "key": "svg-6" }], ["path", { "d": "M6 6l3 3", "key": "svg-7" }], ["path", { "d": "M15 9l3 -3l-3 3z", "key": "svg-8" }]]);

var IconBuildingWarehouse = createVueComponent("outline", "building-warehouse", "BuildingWarehouse", [["path", { "d": "M3 21v-13l9 -4l9 4v13", "key": "svg-0" }], ["path", { "d": "M13 13h4v8h-10v-6h6", "key": "svg-1" }], ["path", { "d": "M13 21v-9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v3", "key": "svg-2" }]]);

var IconBuildingWindTurbine = createVueComponent("outline", "building-wind-turbine", "BuildingWindTurbine", [["path", { "d": "M12 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M10 11v-2.573c0 -.18 .013 -.358 .04 -.536l.716 -4.828c.064 -.597 .597 -1.063 1.244 -1.063s1.18 .466 1.244 1.063l.716 4.828c.027 .178 .04 .357 .04 .536v2.573", "key": "svg-1" }], ["path", { "d": "M13.01 9.28l2.235 1.276c.156 .09 .305 .19 .446 .3l3.836 2.911c.487 .352 .624 1.04 .3 1.596c-.325 .556 -1 .782 -1.548 .541l-4.555 -1.68a3.624 3.624 0 0 1 -.486 -.231l-2.235 -1.277", "key": "svg-2" }], ["path", { "d": "M13 12.716l-2.236 1.277a3.624 3.624 0 0 1 -.485 .23l-4.555 1.681c-.551 .241 -1.223 .015 -1.548 -.54c-.324 -.557 -.187 -1.245 .3 -1.597l3.836 -2.91a3.41 3.41 0 0 1 .446 -.3l2.235 -1.277", "key": "svg-3" }], ["path", { "d": "M7 21h10", "key": "svg-4" }], ["path", { "d": "M10 21l1 -7", "key": "svg-5" }], ["path", { "d": "M13 14l1 7", "key": "svg-6" }]]);

var IconBuilding = createVueComponent("outline", "building", "Building", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M9 8l1 0", "key": "svg-1" }], ["path", { "d": "M9 12l1 0", "key": "svg-2" }], ["path", { "d": "M9 16l1 0", "key": "svg-3" }], ["path", { "d": "M14 8l1 0", "key": "svg-4" }], ["path", { "d": "M14 12l1 0", "key": "svg-5" }], ["path", { "d": "M14 16l1 0", "key": "svg-6" }], ["path", { "d": "M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16", "key": "svg-7" }]]);

var IconBuildings = createVueComponent("outline", "buildings", "Buildings", [["path", { "d": "M4 21v-15c0 -1 1 -2 2 -2h5c1 0 2 1 2 2v15", "key": "svg-0" }], ["path", { "d": "M16 8h2c1 0 2 1 2 2v11", "key": "svg-1" }], ["path", { "d": "M3 21h18", "key": "svg-2" }], ["path", { "d": "M10 12v0", "key": "svg-3" }], ["path", { "d": "M10 16v0", "key": "svg-4" }], ["path", { "d": "M10 8v0", "key": "svg-5" }], ["path", { "d": "M7 12v0", "key": "svg-6" }], ["path", { "d": "M7 16v0", "key": "svg-7" }], ["path", { "d": "M7 8v0", "key": "svg-8" }], ["path", { "d": "M17 12v0", "key": "svg-9" }], ["path", { "d": "M17 16v0", "key": "svg-10" }]]);

var IconBulbOff = createVueComponent("outline", "bulb-off", "BulbOff", [["path", { "d": "M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7", "key": "svg-0" }], ["path", { "d": "M11.089 7.083a5 5 0 0 1 5.826 5.84m-1.378 2.611a5.012 5.012 0 0 1 -.537 .466a3.5 3.5 0 0 0 -1 3a2 2 0 1 1 -4 0a3.5 3.5 0 0 0 -1 -3a5 5 0 0 1 -.528 -7.544", "key": "svg-1" }], ["path", { "d": "M9.7 17h4.6", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBulb = createVueComponent("outline", "bulb", "Bulb", [["path", { "d": "M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7", "key": "svg-0" }], ["path", { "d": "M9 16a5 5 0 1 1 6 0a3.5 3.5 0 0 0 -1 3a2 2 0 0 1 -4 0a3.5 3.5 0 0 0 -1 -3", "key": "svg-1" }], ["path", { "d": "M9.7 17l4.6 0", "key": "svg-2" }]]);

var IconBulldozer = createVueComponent("outline", "bulldozer", "Bulldozer", [["path", { "d": "M2 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 13v4a2 2 0 0 0 2 2h1", "key": "svg-2" }], ["path", { "d": "M14 19h-10", "key": "svg-3" }], ["path", { "d": "M4 15h10", "key": "svg-4" }], ["path", { "d": "M9 11v-5h2a3 3 0 0 1 3 3v6", "key": "svg-5" }], ["path", { "d": "M5 15v-3a1 1 0 0 1 1 -1h8", "key": "svg-6" }], ["path", { "d": "M19 17h-3", "key": "svg-7" }]]);

var IconBurger = createVueComponent("outline", "burger", "Burger", [["path", { "d": "M4 15h16a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M12 4c3.783 0 6.953 2.133 7.786 5h-15.572c.833 -2.867 4.003 -5 7.786 -5z", "key": "svg-1" }], ["path", { "d": "M5 12h14", "key": "svg-2" }]]);

var IconBusOff = createVueComponent("outline", "bus-off", "BusOff", [["path", { "d": "M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M16.18 16.172a2 2 0 0 0 2.652 2.648", "key": "svg-1" }], ["path", { "d": "M4 17h-2v-11a1 1 0 0 1 1 -1h2m4 0h8c2.761 0 5 3.134 5 7v5h-1m-5 0h-8", "key": "svg-2" }], ["path", { "d": "M16 5l1.5 7h4.5", "key": "svg-3" }], ["path", { "d": "M2 10h8m4 0h3", "key": "svg-4" }], ["path", { "d": "M7 7v3", "key": "svg-5" }], ["path", { "d": "M12 5v3", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBusStop = createVueComponent("outline", "bus-stop", "BusStop", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M10 5h7c2.761 0 5 3.134 5 7v5h-2", "key": "svg-2" }], ["path", { "d": "M16 17h-8", "key": "svg-3" }], ["path", { "d": "M16 5l1.5 7h4.5", "key": "svg-4" }], ["path", { "d": "M9.5 10h7.5", "key": "svg-5" }], ["path", { "d": "M12 5v5", "key": "svg-6" }], ["path", { "d": "M5 9v11", "key": "svg-7" }]]);

var IconBus = createVueComponent("outline", "bus", "Bus", [["path", { "d": "M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M4 17h-2v-11a1 1 0 0 1 1 -1h14a5 7 0 0 1 5 7v5h-2m-4 0h-8", "key": "svg-2" }], ["path", { "d": "M16 5l1.5 7l4.5 0", "key": "svg-3" }], ["path", { "d": "M2 10l15 0", "key": "svg-4" }], ["path", { "d": "M7 5l0 5", "key": "svg-5" }], ["path", { "d": "M12 5l0 5", "key": "svg-6" }]]);

var IconBusinessplan = createVueComponent("outline", "businessplan", "Businessplan", [["path", { "d": "M16 6m-5 0a5 3 0 1 0 10 0a5 3 0 1 0 -10 0", "key": "svg-0" }], ["path", { "d": "M11 6v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4", "key": "svg-1" }], ["path", { "d": "M11 10v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4", "key": "svg-2" }], ["path", { "d": "M11 14v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4", "key": "svg-3" }], ["path", { "d": "M7 9h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M5 15v1m0 -8v1", "key": "svg-5" }]]);

var IconButterfly = createVueComponent("outline", "butterfly", "Butterfly", [["path", { "d": "M12 18.176a3 3 0 1 1 -4.953 -2.449l-.025 .023a4.502 4.502 0 0 1 1.483 -8.75c1.414 0 2.675 .652 3.5 1.671a4.5 4.5 0 1 1 4.983 7.079a3 3 0 1 1 -4.983 2.25z", "key": "svg-0" }], ["path", { "d": "M12 19v-10", "key": "svg-1" }], ["path", { "d": "M9 3l3 2l3 -2", "key": "svg-2" }]]);

var IconCactusOff = createVueComponent("outline", "cactus-off", "CactusOff", [["path", { "d": "M6 9v1a3 3 0 0 0 3 3h1", "key": "svg-0" }], ["path", { "d": "M18 8v5a3 3 0 0 1 -.129 .872m-2.014 2a3 3 0 0 1 -.857 .124h-1", "key": "svg-1" }], ["path", { "d": "M10 21v-11m0 -4v-1a2 2 0 1 1 4 0v5m0 4v7", "key": "svg-2" }], ["path", { "d": "M7 21h10", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCactus = createVueComponent("outline", "cactus", "Cactus", [["path", { "d": "M6 9v1a3 3 0 0 0 3 3h1", "key": "svg-0" }], ["path", { "d": "M18 8v5a3 3 0 0 1 -3 3h-1", "key": "svg-1" }], ["path", { "d": "M10 21v-16a2 2 0 1 1 4 0v16", "key": "svg-2" }], ["path", { "d": "M7 21h10", "key": "svg-3" }]]);

var IconCakeOff = createVueComponent("outline", "cake-off", "CakeOff", [["path", { "d": "M21 17v-5a3 3 0 0 0 -3 -3h-5m-4 0h-3a3 3 0 0 0 -3 3v8h17", "key": "svg-0" }], ["path", { "d": "M3 14.803c.312 .135 .654 .204 1 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1m4 0a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1 -.197", "key": "svg-1" }], ["path", { "d": "M10.172 6.188c.07 -.158 .163 -.31 .278 -.451l1.55 -1.737l1.465 1.638a2 2 0 0 1 -.65 3.19", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCakeRoll = createVueComponent("outline", "cake-roll", "CakeRoll", [["path", { "d": "M12 15c-4.97 0 -9 -2.462 -9 -5.5s4.03 -5.5 9 -5.5s9 2.462 9 5.5s-4.03 5.5 -9 5.5", "key": "svg-0" }], ["path", { "d": "M12 6.97c3 0 4 1.036 4 1.979c0 2.805 -8 2.969 -8 -.99c0 -2.11 1.5 -3.959 4 -3.959", "key": "svg-1" }], ["path", { "d": "M21 9.333v5.334c0 2.945 -4.03 5.333 -9 5.333s-9 -2.388 -9 -5.333v-5.334", "key": "svg-2" }]]);

var IconCake = createVueComponent("outline", "cake", "Cake", [["path", { "d": "M3 20h18v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -3 3v8z", "key": "svg-0" }], ["path", { "d": "M3 14.803c.312 .135 .654 .204 1 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1 -.197", "key": "svg-1" }], ["path", { "d": "M12 4l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z", "key": "svg-2" }]]);

var IconCalculatorOff = createVueComponent("outline", "calculator-off", "CalculatorOff", [["path", { "d": "M19.823 19.824a2 2 0 0 1 -1.823 1.176h-12a2 2 0 0 1 -2 -2v-14c0 -.295 .064 -.575 .178 -.827m2.822 -1.173h11a2 2 0 0 1 2 2v11", "key": "svg-0" }], ["path", { "d": "M10 10h-1a1 1 0 0 1 -1 -1v-1m3 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1", "key": "svg-1" }], ["path", { "d": "M8 14v.01", "key": "svg-2" }], ["path", { "d": "M12 14v.01", "key": "svg-3" }], ["path", { "d": "M8 17v.01", "key": "svg-4" }], ["path", { "d": "M12 17v.01", "key": "svg-5" }], ["path", { "d": "M16 17v.01", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconCalculator = createVueComponent("outline", "calculator", "Calculator", [["path", { "d": "M4 3m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 7m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M8 14l0 .01", "key": "svg-2" }], ["path", { "d": "M12 14l0 .01", "key": "svg-3" }], ["path", { "d": "M16 14l0 .01", "key": "svg-4" }], ["path", { "d": "M8 17l0 .01", "key": "svg-5" }], ["path", { "d": "M12 17l0 .01", "key": "svg-6" }], ["path", { "d": "M16 17l0 .01", "key": "svg-7" }]]);

var IconCalendarBolt = createVueComponent("outline", "calendar-bolt", "CalendarBolt", [["path", { "d": "M13.5 21h-7.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-4" }]]);

var IconCalendarCancel = createVueComponent("outline", "calendar-cancel", "CalendarCancel", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M17 21l4 -4", "key": "svg-5" }]]);

var IconCalendarCheck = createVueComponent("outline", "calendar-check", "CalendarCheck", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-4" }]]);

var IconCalendarClock = createVueComponent("outline", "calendar-clock", "CalendarClock", [["path", { "d": "M10.5 21h-4.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h10", "key": "svg-3" }], ["path", { "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-4" }], ["path", { "d": "M18 16.5v1.5l.5 .5", "key": "svg-5" }]]);

var IconCalendarCode = createVueComponent("outline", "calendar-code", "CalendarCode", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-5" }]]);

var IconCalendarCog = createVueComponent("outline", "calendar-cog", "CalendarCog", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconCalendarDollar = createVueComponent("outline", "calendar-dollar", "CalendarDollar", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h12.5", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconCalendarDot = createVueComponent("outline", "calendar-dot", "CalendarDot", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }]]);

var IconCalendarDown = createVueComponent("outline", "calendar-down", "CalendarDown", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M16 3v4", "key": "svg-3" }], ["path", { "d": "M8 3v4", "key": "svg-4" }], ["path", { "d": "M4 11h16", "key": "svg-5" }]]);

var IconCalendarDue = createVueComponent("outline", "calendar-due", "CalendarDue", [["path", { "d": "M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconCalendarEvent = createVueComponent("outline", "calendar-event", "CalendarEvent", [["path", { "d": "M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 3l0 4", "key": "svg-1" }], ["path", { "d": "M8 3l0 4", "key": "svg-2" }], ["path", { "d": "M4 11l16 0", "key": "svg-3" }], ["path", { "d": "M8 15h2v2h-2z", "key": "svg-4" }]]);

var IconCalendarExclamation = createVueComponent("outline", "calendar-exclamation", "CalendarExclamation", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M11 15h1", "key": "svg-4" }], ["path", { "d": "M12 15v3", "key": "svg-5" }], ["path", { "d": "M19 16v3", "key": "svg-6" }], ["path", { "d": "M19 22v.01", "key": "svg-7" }]]);

var IconCalendarHeart = createVueComponent("outline", "calendar-heart", "CalendarHeart", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconCalendarMinus = createVueComponent("outline", "calendar-minus", "CalendarMinus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconCalendarMonth = createVueComponent("outline", "calendar-month", "CalendarMonth", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M8 14v4", "key": "svg-4" }], ["path", { "d": "M12 14v4", "key": "svg-5" }], ["path", { "d": "M16 14v4", "key": "svg-6" }]]);

var IconCalendarOff = createVueComponent("outline", "calendar-off", "CalendarOff", [["path", { "d": "M9 5h9a2 2 0 0 1 2 2v9m-.184 3.839a2 2 0 0 1 -1.816 1.161h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 1.158 -1.815", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v1", "key": "svg-2" }], ["path", { "d": "M4 11h7m4 0h5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCalendarPause = createVueComponent("outline", "calendar-pause", "CalendarPause", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M17 17v5", "key": "svg-4" }], ["path", { "d": "M21 17v5", "key": "svg-5" }]]);

var IconCalendarPin = createVueComponent("outline", "calendar-pin", "CalendarPin", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }], ["path", { "d": "M8 3v4", "key": "svg-4" }], ["path", { "d": "M4 11h16", "key": "svg-5" }]]);

var IconCalendarPlus = createVueComponent("outline", "calendar-plus", "CalendarPlus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconCalendarQuestion = createVueComponent("outline", "calendar-question", "CalendarQuestion", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-5" }]]);

var IconCalendarRepeat = createVueComponent("outline", "calendar-repeat", "CalendarRepeat", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h12", "key": "svg-3" }], ["path", { "d": "M20 14l2 2h-3", "key": "svg-4" }], ["path", { "d": "M20 18l2 -2", "key": "svg-5" }], ["path", { "d": "M19 16a3 3 0 1 0 2 5.236", "key": "svg-6" }]]);

var IconCalendarSad = createVueComponent("outline", "calendar-sad", "CalendarSad", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12zm12 -4v4m-8 -4v4m-4 4h16m-9.995 3h.01m3.99 0h.01", "key": "svg-0" }], ["path", { "d": "M10 18a3.5 3.5 0 0 1 4 0", "key": "svg-1" }]]);

var IconCalendarSearch = createVueComponent("outline", "calendar-search", "CalendarSearch", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-5" }]]);

var IconCalendarShare = createVueComponent("outline", "calendar-share", "CalendarShare", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconCalendarSmile = createVueComponent("outline", "calendar-smile", "CalendarSmile", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12zm12 -4v4m-8 -4v4m-4 4h16m-9.995 3h.01m3.99 0h.01", "key": "svg-0" }], ["path", { "d": "M10.005 17a3.5 3.5 0 0 0 4 0", "key": "svg-1" }]]);

var IconCalendarStar = createVueComponent("outline", "calendar-star", "CalendarStar", [["path", { "d": "M11 21h-5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h11", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconCalendarStats = createVueComponent("outline", "calendar-stats", "CalendarStats", [["path", { "d": "M11.795 21h-6.795a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M18 14v4h4", "key": "svg-1" }], ["path", { "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }], ["path", { "d": "M15 3v4", "key": "svg-3" }], ["path", { "d": "M7 3v4", "key": "svg-4" }], ["path", { "d": "M3 11h16", "key": "svg-5" }]]);

var IconCalendarTime = createVueComponent("outline", "calendar-time", "CalendarTime", [["path", { "d": "M11.795 21h-6.795a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M15 3v4", "key": "svg-2" }], ["path", { "d": "M7 3v4", "key": "svg-3" }], ["path", { "d": "M3 11h16", "key": "svg-4" }], ["path", { "d": "M18 16.496v1.504l1 1", "key": "svg-5" }]]);

var IconCalendarUp = createVueComponent("outline", "calendar-up", "CalendarUp", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 22v-6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-5" }]]);

var IconCalendarUser = createVueComponent("outline", "calendar-user", "CalendarUser", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M22 22a2 2 0 0 0 -2 -2h-2a2 2 0 0 0 -2 2", "key": "svg-5" }]]);

var IconCalendarWeek = createVueComponent("outline", "calendar-week", "CalendarWeek", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M7 14h.013", "key": "svg-4" }], ["path", { "d": "M10.01 14h.005", "key": "svg-5" }], ["path", { "d": "M13.01 14h.005", "key": "svg-6" }], ["path", { "d": "M16.015 14h.005", "key": "svg-7" }], ["path", { "d": "M13.015 17h.005", "key": "svg-8" }], ["path", { "d": "M7.01 17h.005", "key": "svg-9" }], ["path", { "d": "M10.01 17h.005", "key": "svg-10" }]]);

var IconCalendarX = createVueComponent("outline", "calendar-x", "CalendarX", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconCalendar = createVueComponent("outline", "calendar", "Calendar", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M11 15h1", "key": "svg-4" }], ["path", { "d": "M12 15v3", "key": "svg-5" }]]);

var IconCameraAi = createVueComponent("outline", "camera-ai", "CameraAi", [["path", { "d": "M10 20h-5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M14.362 11.15a3 3 0 1 0 -4.144 4.263", "key": "svg-1" }], ["path", { "d": "M14 21v-4a2 2 0 1 1 4 0v4", "key": "svg-2" }], ["path", { "d": "M14 19h4", "key": "svg-3" }], ["path", { "d": "M21 15v6", "key": "svg-4" }]]);

var IconCameraBitcoin = createVueComponent("outline", "camera-bitcoin", "CameraBitcoin", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v1", "key": "svg-0" }], ["path", { "d": "M14.477 11.307a3 3 0 1 0 -2.477 4.693", "key": "svg-1" }], ["path", { "d": "M17 21v-6", "key": "svg-2" }], ["path", { "d": "M19 15v-1.5", "key": "svg-3" }], ["path", { "d": "M19 22.5v-1.5", "key": "svg-4" }], ["path", { "d": "M17 18h3", "key": "svg-5" }], ["path", { "d": "M19 18h.5a1.5 1.5 0 0 1 0 3h-3.5", "key": "svg-6" }], ["path", { "d": "M19 18h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-7" }]]);

var IconCameraBolt = createVueComponent("outline", "camera-bolt", "CameraBolt", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconCameraCancel = createVueComponent("outline", "camera-cancel", "CameraCancel", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M14.984 13.307a3 3 0 1 0 -2.32 2.62", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconCameraCheck = createVueComponent("outline", "camera-check", "CameraCheck", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconCameraCode = createVueComponent("outline", "camera-code", "CameraCode", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M14.948 13.559a3 3 0 1 0 -2.58 2.419", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconCameraCog = createVueComponent("outline", "camera-cog", "CameraCog", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M14.973 13.406a3 3 0 1 0 -2.973 2.594", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconCameraDollar = createVueComponent("outline", "camera-dollar", "CameraDollar", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v1.5", "key": "svg-0" }], ["path", { "d": "M14.935 12.375a3.001 3.001 0 1 0 -1.902 3.442", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconCameraDown = createVueComponent("outline", "camera-down", "CameraDown", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconCameraExclamation = createVueComponent("outline", "camera-exclamation", "CameraExclamation", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconCameraHeart = createVueComponent("outline", "camera-heart", "CameraHeart", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M14.41 11.212a3 3 0 1 0 -4.15 4.231", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconCameraMinus = createVueComponent("outline", "camera-minus", "CameraMinus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-2" }]]);

var IconCameraMoon = createVueComponent("outline", "camera-moon", "CameraMoon", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M14.815 11.96a3.001 3.001 0 1 0 -3.398 3.983", "key": "svg-1" }], ["path", { "d": "M18.62 22c-2 0 -3.62 -1.58 -3.62 -3.53c0 -1.727 1.273 -3.165 2.954 -3.47a3.4 3.4 0 0 0 -.24 1.264c0 1.95 1.621 3.53 3.62 3.53q .342 0 .666 -.06c-.521 1.326 -1.838 2.266 -3.38 2.266", "key": "svg-2" }]]);

var IconCameraOff = createVueComponent("outline", "camera-off", "CameraOff", [["path", { "d": "M8.297 4.289a.997 .997 0 0 1 .703 -.289h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v8m-1.187 2.828c-.249 .11 -.524 .172 -.813 .172h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1c.298 0 .58 -.065 .834 -.181", "key": "svg-0" }], ["path", { "d": "M10.422 10.448a3 3 0 1 0 4.15 4.098", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCameraPause = createVueComponent("outline", "camera-pause", "CameraPause", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M14.958 13.506a3 3 0 1 0 -1.735 2.235", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconCameraPin = createVueComponent("outline", "camera-pin", "CameraPin", [["path", { "d": "M12.5 20h-7.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M14.933 12.366a3.001 3.001 0 1 0 -2.933 3.634", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconCameraPlus = createVueComponent("outline", "camera-plus", "CameraPlus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-3" }]]);

var IconCameraQuestion = createVueComponent("outline", "camera-question", "CameraQuestion", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M14.975 12.612a3 3 0 1 0 -1.507 3.005", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconCameraRotate = createVueComponent("outline", "camera-rotate", "CameraRotate", [["path", { "d": "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M11.245 15.904a3 3 0 0 0 3.755 -2.904m-2.25 -2.905a3 3 0 0 0 -3.75 2.905", "key": "svg-1" }], ["path", { "d": "M14 13h2v2", "key": "svg-2" }], ["path", { "d": "M10 13h-2v-2", "key": "svg-3" }]]);

var IconCameraSearch = createVueComponent("outline", "camera-search", "CameraSearch", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M14.757 11.815a3 3 0 1 0 -3.431 4.109", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconCameraSelfie = createVueComponent("outline", "camera-selfie", "CameraSelfie", [["path", { "d": "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9.5 15a3.5 3.5 0 0 0 5 0", "key": "svg-1" }], ["path", { "d": "M15 11l.01 0", "key": "svg-2" }], ["path", { "d": "M9 11l.01 0", "key": "svg-3" }]]);

var IconCameraShare = createVueComponent("outline", "camera-share", "CameraShare", [["path", { "d": "M12.5 20h-7.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M14.98 13.347a3 3 0 1 0 -2.39 2.595", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconCameraSpark = createVueComponent("outline", "camera-spark", "CameraSpark", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-2" }]]);

var IconCameraStar = createVueComponent("outline", "camera-star", "CameraStar", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M14.569 11.45a3 3 0 1 0 -4.518 3.83", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconCameraUp = createVueComponent("outline", "camera-up", "CameraUp", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M12 16a3 3 0 1 0 0 -6a3 3 0 0 0 0 6z", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconCameraX = createVueComponent("outline", "camera-x", "CameraX", [["path", { "d": "M13.5 20h-8.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconCamera = createVueComponent("outline", "camera", "Camera", [["path", { "d": "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }]]);

var IconCamper = createVueComponent("outline", "camper", "Camper", [["path", { "d": "M5 18a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 18a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 18h-1a1 1 0 0 1 -1 -1v-11a2 2 0 0 1 2 -2h12a4 4 0 0 1 4 4h-18", "key": "svg-2" }], ["path", { "d": "M9 18h6", "key": "svg-3" }], ["path", { "d": "M19 18h1a1 1 0 0 0 1 -1v-4l-3 -5", "key": "svg-4" }], ["path", { "d": "M21 13h-7", "key": "svg-5" }], ["path", { "d": "M14 8v10", "key": "svg-6" }]]);

var IconCampfire = createVueComponent("outline", "campfire", "Campfire", [["path", { "d": "M4 21l16 -4", "key": "svg-0" }], ["path", { "d": "M20 21l-16 -4", "key": "svg-1" }], ["path", { "d": "M12 15a4 4 0 0 0 4 -4c0 -3 -2 -3 -2 -8c-4 2 -6 5 -6 8a4 4 0 0 0 4 4z", "key": "svg-2" }]]);

var IconCancel = createVueComponent("outline", "cancel", "Cancel", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M18.364 5.636l-12.728 12.728", "key": "svg-1" }]]);

var IconCandle = createVueComponent("outline", "candle", "Candle", [["path", { "d": "M9 21h6v-10a1 1 0 0 0 -1 -1h-4a1 1 0 0 0 -1 1z", "key": "svg-0" }], ["path", { "d": "M12 2l1.465 1.638a2 2 0 1 1 -3.015 .099z", "key": "svg-1" }]]);

var IconCandyOff = createVueComponent("outline", "candy-off", "CandyOff", [["path", { "d": "M11.174 7.17l.119 -.12a2 2 0 0 1 2.828 0l2.829 2.83a2 2 0 0 1 0 2.828l-.124 .124m-2 2l-2.123 2.123a2 2 0 0 1 -2.828 0l-2.829 -2.831a2 2 0 0 1 0 -2.828l2.113 -2.112", "key": "svg-0" }], ["path", { "d": "M16.243 9.172l3.086 -.772a1.5 1.5 0 0 0 .697 -2.516l-2.216 -2.217a1.5 1.5 0 0 0 -2.44 .47l-1.248 2.913", "key": "svg-1" }], ["path", { "d": "M9.172 16.243l-.772 3.086a1.5 1.5 0 0 1 -2.516 .697l-2.217 -2.216a1.5 1.5 0 0 1 .47 -2.44l2.913 -1.248", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCandy = createVueComponent("outline", "candy", "Candy", [["path", { "d": "M7.05 11.293l4.243 -4.243a2 2 0 0 1 2.828 0l2.829 2.83a2 2 0 0 1 0 2.828l-4.243 4.243a2 2 0 0 1 -2.828 0l-2.829 -2.831a2 2 0 0 1 0 -2.828z", "key": "svg-0" }], ["path", { "d": "M16.243 9.172l3.086 -.772a1.5 1.5 0 0 0 .697 -2.516l-2.216 -2.217a1.5 1.5 0 0 0 -2.44 .47l-1.248 2.913", "key": "svg-1" }], ["path", { "d": "M9.172 16.243l-.772 3.086a1.5 1.5 0 0 1 -2.516 .697l-2.217 -2.216a1.5 1.5 0 0 1 .47 -2.44l2.913 -1.248", "key": "svg-2" }]]);

var IconCane = createVueComponent("outline", "cane", "Cane", [["path", { "d": "M9 21l6.324 -11.69c.54 -.974 1.756 -4.104 -1.499 -5.762c-3.255 -1.657 -5.175 .863 -5.825 2.032", "key": "svg-0" }]]);

var IconCannabis = createVueComponent("outline", "cannabis", "Cannabis", [["path", { "d": "M7 20s0 -2 1 -3.5c-1.5 0 -2 -.5 -4 -1.5c0 0 1.839 -1.38 5 -1c-1.789 -.97 -3.279 -2.03 -5 -6c0 0 3.98 -.3 6.5 3.5c-2.284 -4.9 1.5 -9.5 1.5 -9.5c2.734 5.47 2.389 7.5 1.5 9.5c2.531 -3.77 6.5 -3.5 6.5 -3.5c-1.721 3.97 -3.211 5.03 -5 6c3.161 -.38 5 1 5 1c-2 1 -2.5 1.5 -4 1.5c1 1.5 1 3.5 1 3.5c-2 0 -4.438 -2.22 -5 -3c-.563 .78 -3 3 -5 3z", "key": "svg-0" }], ["path", { "d": "M12 22v-5", "key": "svg-1" }]]);

var IconCapProjecting = createVueComponent("outline", "cap-projecting", "CapProjecting", [["path", { "d": "M20 6h-13a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h13", "key": "svg-0" }], ["path", { "d": "M13 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0", "key": "svg-1" }], ["path", { "d": "M13 12h7", "key": "svg-2" }]]);

var IconCapRounded = createVueComponent("outline", "cap-rounded", "CapRounded", [["path", { "d": "M20 6h-9a6 6 0 1 0 0 12h9", "key": "svg-0" }], ["path", { "d": "M13 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0", "key": "svg-1" }], ["path", { "d": "M13 12h7", "key": "svg-2" }]]);

var IconCapStraight = createVueComponent("outline", "cap-straight", "CapStraight", [["path", { "d": "M8 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0", "key": "svg-0" }], ["path", { "d": "M8 12h12", "key": "svg-1" }], ["path", { "d": "M20 6h-12a2 2 0 0 0 -2 2v2", "key": "svg-2" }], ["path", { "d": "M6 14v2a2 2 0 0 0 2 2h12", "key": "svg-3" }]]);

var IconCapsuleHorizontal = createVueComponent("outline", "capsule-horizontal", "CapsuleHorizontal", [["path", { "d": "M3 6m0 6a6 6 0 0 1 6 -6h6a6 6 0 0 1 6 6v0a6 6 0 0 1 -6 6h-6a6 6 0 0 1 -6 -6z", "key": "svg-0" }]]);

var IconCapsule = createVueComponent("outline", "capsule", "Capsule", [["path", { "d": "M6 3m0 6a6 6 0 0 1 6 -6h0a6 6 0 0 1 6 6v6a6 6 0 0 1 -6 6h0a6 6 0 0 1 -6 -6z", "key": "svg-0" }]]);

var IconCaptureOff = createVueComponent("outline", "capture-off", "CaptureOff", [["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-0" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-1" }], ["path", { "d": "M16 20h2c.554 0 1.055 -.225 1.417 -.589", "key": "svg-2" }], ["path", { "d": "M9.87 9.887a3 3 0 0 0 4.255 4.23m.58 -3.416a3.012 3.012 0 0 0 -1.4 -1.403", "key": "svg-3" }], ["path", { "d": "M4 8v-2c0 -.548 .22 -1.044 .577 -1.405", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCapture = createVueComponent("outline", "capture", "Capture", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }]]);

var IconCar4wd = createVueComponent("outline", "car-4wd", "Car4wd", [["path", { "d": "M5 3m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M5 15m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M15 3m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-2" }], ["path", { "d": "M15 15m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-3" }], ["path", { "d": "M9 18h6", "key": "svg-4" }], ["path", { "d": "M9 6h6", "key": "svg-5" }], ["path", { "d": "M12 6.5v-.5v12", "key": "svg-6" }]]);

var IconCarCrane = createVueComponent("outline", "car-crane", "CarCrane", [["path", { "d": "M5 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 18h8m4 0h2v-6a5 5 0 0 0 -5 -5h-1l1.5 5h4.5", "key": "svg-2" }], ["path", { "d": "M12 18v-11h3", "key": "svg-3" }], ["path", { "d": "M3 17v-5h9", "key": "svg-4" }], ["path", { "d": "M4 12v-6l18 -3v2", "key": "svg-5" }], ["path", { "d": "M8 12v-4l-4 -2", "key": "svg-6" }]]);

var IconCarCrash = createVueComponent("outline", "car-crash", "CarCrash", [["path", { "d": "M10 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M7 6l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-5m0 -6h8m-6 0v-5m2 0h-4", "key": "svg-1" }], ["path", { "d": "M14 8v-2", "key": "svg-2" }], ["path", { "d": "M19 12h2", "key": "svg-3" }], ["path", { "d": "M17.5 15.5l1.5 1.5", "key": "svg-4" }], ["path", { "d": "M17.5 8.5l1.5 -1.5", "key": "svg-5" }]]);

var IconCarFan1 = createVueComponent("outline", "car-fan-1", "CarFan1", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.424 15.03l-2.424 -3.03h6", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M18 17l2 -2v6", "key": "svg-4" }]]);

var IconCarFan2 = createVueComponent("outline", "car-fan-2", "CarFan2", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.044 14.624l-2.044 -2.624h4", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M18 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-4" }]]);

var IconCarFan3 = createVueComponent("outline", "car-fan-3", "CarFan3", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.044 14.624l-2.044 -2.624h4", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M18 15.5a.5 .5 0 0 1 .5 -.5h1a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1a.5 .5 0 0 1 -.5 -.5", "key": "svg-4" }]]);

var IconCarFanAuto = createVueComponent("outline", "car-fan-auto", "CarFanAuto", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.044 14.624l-2.044 -2.624h4", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M17 21v-4a2 2 0 1 1 4 0v4", "key": "svg-4" }], ["path", { "d": "M17 19h4", "key": "svg-5" }]]);

var IconCarFan = createVueComponent("outline", "car-fan", "CarFan", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M12 12h9l-1.914 4.912a1.7 1.7 0 0 1 -2.925 .428z", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }]]);

var IconCarGarage = createVueComponent("outline", "car-garage", "CarGarage", [["path", { "d": "M5 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 20h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5", "key": "svg-2" }], ["path", { "d": "M3 6l9 -4l9 4", "key": "svg-3" }]]);

var IconCarOff = createVueComponent("outline", "car-off", "CarOff", [["path", { "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15.584 15.588a2 2 0 0 0 2.828 2.83", "key": "svg-1" }], ["path", { "d": "M5 17h-2v-6l2 -5h1m4 0h4l4 5h1a2 2 0 0 1 2 2v4m-6 0h-6m-6 -6h8m4 0h3m-6 -3v-2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCarSuv = createVueComponent("outline", "car-suv", "CarSuv", [["path", { "d": "M5 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M16 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 9l2 -4h7.438a2 2 0 0 1 1.94 1.515l.622 2.485h3a2 2 0 0 1 2 2v3", "key": "svg-2" }], ["path", { "d": "M10 9v-4", "key": "svg-3" }], ["path", { "d": "M2 7v4", "key": "svg-4" }], ["path", { "d": "M22.001 14.001a4.992 4.992 0 0 0 -4.001 -2.001a4.992 4.992 0 0 0 -4 2h-3a4.998 4.998 0 0 0 -8.003 .003", "key": "svg-5" }], ["path", { "d": "M5 12v-3h13", "key": "svg-6" }]]);

var IconCarTurbine = createVueComponent("outline", "car-turbine", "CarTurbine", [["path", { "d": "M11 13m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M18.86 11c.088 .66 .14 1.512 .14 2a8 8 0 1 1 -8 -8h6", "key": "svg-1" }], ["path", { "d": "M11 9c2.489 .108 4.489 .108 6 0", "key": "svg-2" }], ["path", { "d": "M17 3m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-3" }], ["path", { "d": "M11 13l-3.5 -1.5", "key": "svg-4" }], ["path", { "d": "M11 13l2.5 3", "key": "svg-5" }], ["path", { "d": "M8.5 16l2.5 -3", "key": "svg-6" }], ["path", { "d": "M11 13l3.5 -1.5", "key": "svg-7" }], ["path", { "d": "M11 9v4", "key": "svg-8" }]]);

var IconCar = createVueComponent("outline", "car", "Car", [["path", { "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5", "key": "svg-2" }]]);

var IconCarambola = createVueComponent("outline", "carambola", "Carambola", [["path", { "d": "M17.286 21.09q -1.69 .001 -5.288 -2.615q -3.596 2.617 -5.288 2.616q -2.726 0 -.495 -6.8q -9.389 -6.775 2.135 -6.775h.076q 1.785 -5.516 3.574 -5.516q 1.785 0 3.574 5.516h.076q 11.525 0 2.133 6.774q 2.23 6.802 -.497 6.8", "key": "svg-0" }]]);

var IconCaravan = createVueComponent("outline", "caravan", "Caravan", [["path", { "d": "M7 18a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11 18h7a2 2 0 0 0 2 -2v-7a2 2 0 0 0 -2 -2h-9.5a5.5 5.5 0 0 0 -5.5 5.5v3.5a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M8 7l7 -3l1 3", "key": "svg-2" }], ["path", { "d": "M13 11m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v2a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z", "key": "svg-3" }], ["path", { "d": "M20 16h2", "key": "svg-4" }]]);

var IconCardboardsOff = createVueComponent("outline", "cardboards-off", "CardboardsOff", [["path", { "d": "M20.96 16.953c.026 -.147 .04 -.298 .04 -.453v-8.5a2 2 0 0 0 -2 -2h-9m-4 0h-1a2 2 0 0 0 -2 2v8.5a2.5 2.5 0 0 0 2.5 2.5h1.06a3 3 0 0 0 2.34 -1.13l1.54 -1.92a2 2 0 0 1 3.12 0l1.54 1.92a3 3 0 0 0 2.34 1.13h1.06c.155 0 .307 -.014 .454 -.041", "key": "svg-0" }], ["path", { "d": "M8 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M16.714 12.7a1 1 0 0 0 -1.417 -1.411l1.417 1.41z", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCardboards = createVueComponent("outline", "cardboards", "Cardboards", [["path", { "d": "M3 8v8.5a2.5 2.5 0 0 0 2.5 2.5h1.06a3 3 0 0 0 2.34 -1.13l1.54 -1.92a2 2 0 0 1 3.12 0l1.54 1.92a3 3 0 0 0 2.34 1.13h1.06a2.5 2.5 0 0 0 2.5 -2.5v-8.5a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2z", "key": "svg-0" }], ["path", { "d": "M8 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M16 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconCards = createVueComponent("outline", "cards", "Cards", [["path", { "d": "M3.604 7.197l7.138 -3.109a.96 .96 0 0 1 1.27 .527l4.924 11.902a1 1 0 0 1 -.514 1.304l-7.137 3.109a.96 .96 0 0 1 -1.271 -.527l-4.924 -11.903a1 1 0 0 1 .514 -1.304z", "key": "svg-0" }], ["path", { "d": "M15 4h1a1 1 0 0 1 1 1v3.5", "key": "svg-1" }], ["path", { "d": "M20 6c.264 .112 .52 .217 .768 .315a1 1 0 0 1 .53 1.311l-2.298 5.374", "key": "svg-2" }]]);

var IconCaretDown = createVueComponent("outline", "caret-down", "CaretDown", [["path", { "d": "M6 10l6 6l6 -6h-12", "key": "svg-0" }]]);

var IconCaretLeftRight = createVueComponent("outline", "caret-left-right", "CaretLeftRight", [["path", { "d": "M14 18l6 -6l-6 -6v12", "key": "svg-0" }], ["path", { "d": "M10 18l-6 -6l6 -6v12", "key": "svg-1" }]]);

var IconCaretLeft = createVueComponent("outline", "caret-left", "CaretLeft", [["path", { "d": "M14 6l-6 6l6 6v-12", "key": "svg-0" }]]);

var IconCaretRight = createVueComponent("outline", "caret-right", "CaretRight", [["path", { "d": "M10 18l6 -6l-6 -6v12", "key": "svg-0" }]]);

var IconCaretUpDown = createVueComponent("outline", "caret-up-down", "CaretUpDown", [["path", { "d": "M18 10l-6 -6l-6 6h12", "key": "svg-0" }], ["path", { "d": "M18 14l-6 6l-6 -6h12", "key": "svg-1" }]]);

var IconCaretUp = createVueComponent("outline", "caret-up", "CaretUp", [["path", { "d": "M18 14l-6 -6l-6 6h12", "key": "svg-0" }]]);

var IconCarouselHorizontal = createVueComponent("outline", "carousel-horizontal", "CarouselHorizontal", [["path", { "d": "M7 5m0 1a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M22 17h-1a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h1", "key": "svg-1" }], ["path", { "d": "M2 17h1a1 1 0 0 0 1 -1v-8a1 1 0 0 0 -1 -1h-1", "key": "svg-2" }]]);

var IconCarouselVertical = createVueComponent("outline", "carousel-vertical", "CarouselVertical", [["path", { "d": "M19 8v8a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1z", "key": "svg-0" }], ["path", { "d": "M7 22v-1a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v1", "key": "svg-1" }], ["path", { "d": "M17 2v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1", "key": "svg-2" }]]);

var IconCarrotOff = createVueComponent("outline", "carrot-off", "CarrotOff", [["path", { "d": "M8.868 8.846c-2.756 3.382 -5.868 12.154 -5.868 12.154s8.75 -3.104 12.134 -5.85m1.667 -2.342a4.486 4.486 0 0 0 -5.589 -5.615", "key": "svg-0" }], ["path", { "d": "M9 13l-1.5 -1.5", "key": "svg-1" }], ["path", { "d": "M22 8s-1.14 -2 -3 -2c-1.406 0 -3 2 -3 2s1.14 2 3 2s3 -2 3 -2z", "key": "svg-2" }], ["path", { "d": "M16 2s-2 1.14 -2 3s2 3 2 3s2 -1.577 2 -3c0 -1.86 -2 -3 -2 -3z", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCarrot = createVueComponent("outline", "carrot", "Carrot", [["path", { "d": "M3 21s9.834 -3.489 12.684 -6.34a4.487 4.487 0 0 0 0 -6.344a4.483 4.483 0 0 0 -6.342 0c-2.86 2.861 -6.347 12.689 -6.347 12.689z", "key": "svg-0" }], ["path", { "d": "M9 13l-1.5 -1.5", "key": "svg-1" }], ["path", { "d": "M16 14l-2 -2", "key": "svg-2" }], ["path", { "d": "M22 8s-1.14 -2 -3 -2c-1.406 0 -3 2 -3 2s1.14 2 3 2s3 -2 3 -2z", "key": "svg-3" }], ["path", { "d": "M16 2s-2 1.14 -2 3s2 3 2 3s2 -1.577 2 -3c0 -1.86 -2 -3 -2 -3z", "key": "svg-4" }]]);

var IconCashBanknoteEdit = createVueComponent("outline", "cash-banknote-edit", "CashBanknoteEdit", [["path", { "d": "M11 18h-6a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M6 12h.01", "key": "svg-2" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 1 1 2.97 2.97l-3.39 3.42h-3v-3z", "key": "svg-3" }]]);

var IconCashBanknoteHeart = createVueComponent("outline", "cash-banknote-heart", "CashBanknoteHeart", [["path", { "d": "M14.872 11.13a3.001 3.001 0 1 0 -4.29 3.514", "key": "svg-0" }], ["path", { "d": "M10 18h-5a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v3", "key": "svg-1" }], ["path", { "d": "M6 12h.01", "key": "svg-2" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.24 2.24 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.24 2.24 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071z", "key": "svg-3" }]]);

var IconCashBanknoteMinus = createVueComponent("outline", "cash-banknote-minus", "CashBanknoteMinus", [["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 18h-7a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-1" }], ["path", { "d": "M18 12h.01", "key": "svg-2" }], ["path", { "d": "M6 12h.01", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconCashBanknoteMoveBack = createVueComponent("outline", "cash-banknote-move-back", "CashBanknoteMoveBack", [["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 18h-7a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4.5", "key": "svg-1" }], ["path", { "d": "M18 12h.01", "key": "svg-2" }], ["path", { "d": "M6 12h.01", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16l-3 3l3 3", "key": "svg-5" }]]);

var IconCashBanknoteMove = createVueComponent("outline", "cash-banknote-move", "CashBanknoteMove", [["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 18h-7a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4.5", "key": "svg-1" }], ["path", { "d": "M18 12h.01", "key": "svg-2" }], ["path", { "d": "M6 12h.01", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16l3 3l-3 3", "key": "svg-5" }]]);

var IconCashBanknoteOff = createVueComponent("outline", "cash-banknote-off", "CashBanknoteOff", [["path", { "d": "M9.88 9.878a3 3 0 1 0 4.242 4.243m.58 -3.425a3.012 3.012 0 0 0 -1.412 -1.405", "key": "svg-0" }], ["path", { "d": "M10 6h9a2 2 0 0 1 2 2v8c0 .294 -.064 .574 -.178 .825m-2.822 1.175h-13a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h1", "key": "svg-1" }], ["path", { "d": "M18 12l.01 0", "key": "svg-2" }], ["path", { "d": "M6 12l.01 0", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCashBanknotePlus = createVueComponent("outline", "cash-banknote-plus", "CashBanknotePlus", [["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12.25 18h-7.25a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4.5", "key": "svg-1" }], ["path", { "d": "M18 12h.01", "key": "svg-2" }], ["path", { "d": "M6 12h.01", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconCashBanknote = createVueComponent("outline", "cash-banknote", "CashBanknote", [["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-0" }], ["path", { "d": "M3 8a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M18 12h.01", "key": "svg-2" }], ["path", { "d": "M6 12h.01", "key": "svg-3" }]]);

var IconCashEdit = createVueComponent("outline", "cash-edit", "CashEdit", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M11 19h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v1.25", "key": "svg-1" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 1 1 2.97 2.97l-3.39 3.42h-3v-3z", "key": "svg-2" }]]);

var IconCashHeart = createVueComponent("outline", "cash-heart", "CashHeart", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M10.25 19h-2.25a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v1.25", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.24 2.24 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.24 2.24 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071z", "key": "svg-2" }]]);

var IconCashMinus = createVueComponent("outline", "cash-minus", "CashMinus", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M12 19h-4a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v5", "key": "svg-1" }], ["path", { "d": "M12 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconCashMoveBack = createVueComponent("outline", "cash-move-back", "CashMoveBack", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M12 19h-4a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v2.5", "key": "svg-1" }], ["path", { "d": "M15.914 13.417a2 2 0 1 0 -2.447 2.511", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16l-3 3l3 3", "key": "svg-4" }]]);

var IconCashMove = createVueComponent("outline", "cash-move", "CashMove", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M12 19h-4a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v2.5", "key": "svg-1" }], ["path", { "d": "M15.92 13.437a2 2 0 1 0 -2.472 2.486", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16l3 3l-3 3", "key": "svg-4" }]]);

var IconCashOff = createVueComponent("outline", "cash-off", "CashOff", [["path", { "d": "M13 9h6a2 2 0 0 1 2 2v6m-2 2h-10a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M12.582 12.59a2 2 0 0 0 2.83 2.826", "key": "svg-1" }], ["path", { "d": "M17 9v-2a2 2 0 0 0 -2 -2h-6m-4 0a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCashPlus = createVueComponent("outline", "cash-plus", "CashPlus", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M12 19h-4a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v2.5", "key": "svg-1" }], ["path", { "d": "M12 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconCashRegister = createVueComponent("outline", "cash-register", "CashRegister", [["path", { "d": "M21 15h-2.5c-.398 0 -.779 .158 -1.061 .439c-.281 .281 -.439 .663 -.439 1.061c0 .398 .158 .779 .439 1.061c.281 .281 .663 .439 1.061 .439h1c.398 0 .779 .158 1.061 .439c.281 .281 .439 .663 .439 1.061c0 .398 -.158 .779 -.439 1.061c-.281 .281 -.663 .439 -1.061 .439h-2.5", "key": "svg-0" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-1" }], ["path", { "d": "M13 21h-7c-.53 0 -1.039 -.211 -1.414 -.586c-.375 -.375 -.586 -.884 -.586 -1.414v-10c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h2m12 3.12v-1.12c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586h-2", "key": "svg-2" }], ["path", { "d": "M16 10v-6c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586h-4c-.53 0 -1.039 .211 -1.414 .586c-.375 .375 -.586 .884 -.586 1.414v6m8 0h-8m8 0h1m-9 0h-1", "key": "svg-3" }], ["path", { "d": "M8 14v.01", "key": "svg-4" }], ["path", { "d": "M8 17v.01", "key": "svg-5" }], ["path", { "d": "M12 13.99v.01", "key": "svg-6" }], ["path", { "d": "M12 17v.01", "key": "svg-7" }]]);

var IconCash = createVueComponent("outline", "cash", "Cash", [["path", { "d": "M7 15h-3a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M7 9m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M12 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-2" }]]);

var IconCastOff = createVueComponent("outline", "cast-off", "CastOff", [["path", { "d": "M3 19h.01", "key": "svg-0" }], ["path", { "d": "M7 19a4 4 0 0 0 -4 -4", "key": "svg-1" }], ["path", { "d": "M11 19a8 8 0 0 0 -8 -8", "key": "svg-2" }], ["path", { "d": "M15 19h3a3 3 0 0 0 .875 -.13m2 -2a3 3 0 0 0 .128 -.868v-8a3 3 0 0 0 -3 -3h-9m-3.865 .136a3 3 0 0 0 -1.935 1.864", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCast = createVueComponent("outline", "cast", "Cast", [["path", { "d": "M3 19l.01 0", "key": "svg-0" }], ["path", { "d": "M7 19a4 4 0 0 0 -4 -4", "key": "svg-1" }], ["path", { "d": "M11 19a8 8 0 0 0 -8 -8", "key": "svg-2" }], ["path", { "d": "M15 19h3a3 3 0 0 0 3 -3v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -2.8 2", "key": "svg-3" }]]);

var IconCat = createVueComponent("outline", "cat", "Cat", [["path", { "d": "M20 3v10a8 8 0 1 1 -16 0v-10l3.432 3.432a7.963 7.963 0 0 1 4.568 -1.432c1.769 0 3.403 .574 4.728 1.546l3.272 -3.546z", "key": "svg-0" }], ["path", { "d": "M2 16h5l-4 4", "key": "svg-1" }], ["path", { "d": "M22 16h-5l4 4", "key": "svg-2" }], ["path", { "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9 11v.01", "key": "svg-4" }], ["path", { "d": "M15 11v.01", "key": "svg-5" }]]);

var IconCategory2 = createVueComponent("outline", "category-2", "Category2", [["path", { "d": "M14 4h6v6h-6z", "key": "svg-0" }], ["path", { "d": "M4 14h6v6h-6z", "key": "svg-1" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M7 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }]]);

var IconCategoryMinus = createVueComponent("outline", "category-minus", "CategoryMinus", [["path", { "d": "M4 4h6v6h-6zm10 0h6v6h-6zm-10 10h6v6h-6zm10 3h6", "key": "svg-0" }]]);

var IconCategoryPlus = createVueComponent("outline", "category-plus", "CategoryPlus", [["path", { "d": "M4 4h6v6h-6zm10 0h6v6h-6zm-10 10h6v6h-6zm10 3h6m-3 -3v6", "key": "svg-0" }]]);

var IconCategory = createVueComponent("outline", "category", "Category", [["path", { "d": "M4 4h6v6h-6z", "key": "svg-0" }], ["path", { "d": "M14 4h6v6h-6z", "key": "svg-1" }], ["path", { "d": "M4 14h6v6h-6z", "key": "svg-2" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }]]);

var IconCeOff = createVueComponent("outline", "ce-off", "CeOff", [["path", { "d": "M6.53 6.53a6.001 6.001 0 0 0 2.47 11.47", "key": "svg-0" }], ["path", { "d": "M21 6a6 6 0 0 0 -5.927 5.061l.927 .939", "key": "svg-1" }], ["path", { "d": "M16 12h5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCe = createVueComponent("outline", "ce", "Ce", [["path", { "d": "M9 6a6 6 0 1 0 0 12", "key": "svg-0" }], ["path", { "d": "M21 6a6 6 0 1 0 0 12", "key": "svg-1" }], ["path", { "d": "M15 12h6", "key": "svg-2" }]]);

var IconCellSignal1 = createVueComponent("outline", "cell-signal-1", "CellSignal1", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }]]);

var IconCellSignal2 = createVueComponent("outline", "cell-signal-2", "CellSignal2", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M8 20v-5", "key": "svg-1" }]]);

var IconCellSignal3 = createVueComponent("outline", "cell-signal-3", "CellSignal3", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M12 20v-9", "key": "svg-1" }]]);

var IconCellSignal4 = createVueComponent("outline", "cell-signal-4", "CellSignal4", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M16 7v13", "key": "svg-1" }]]);

var IconCellSignal5 = createVueComponent("outline", "cell-signal-5", "CellSignal5", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M16 7v13", "key": "svg-1" }], ["path", { "d": "M12 20v-9", "key": "svg-2" }], ["path", { "d": "M8 20v-5", "key": "svg-3" }]]);

var IconCellSignalOff = createVueComponent("outline", "cell-signal-off", "CellSignalOff", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l7.265 -7.264m2 -2l5.272 -5.272a.731 .731 0 0 1 1.249 .517v11.269", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCell = createVueComponent("outline", "cell", "Cell", [["path", { "d": "M8 4l-4 2v5l4 2l4 -2v-5z", "key": "svg-0" }], ["path", { "d": "M12 11l4 2l4 -2v-5l-4 -2l-4 2", "key": "svg-1" }], ["path", { "d": "M8 13v5l4 2l4 -2v-5", "key": "svg-2" }]]);

var IconCertificate2Off = createVueComponent("outline", "certificate-2-off", "Certificate2Off", [["path", { "d": "M12 12a3 3 0 1 0 3 3", "key": "svg-0" }], ["path", { "d": "M11 7h3", "key": "svg-1" }], ["path", { "d": "M10 18v4l2 -1l2 1v-4", "key": "svg-2" }], ["path", { "d": "M10 19h-2a2 2 0 0 1 -2 -2v-11m1.18 -2.825c.25 -.112 .529 -.175 .82 -.175h8a2 2 0 0 1 2 2v9m-.175 3.82a2 2 0 0 1 -1.825 1.18h-2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCertificate2 = createVueComponent("outline", "certificate-2", "Certificate2", [["path", { "d": "M12 15m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M10 7h4", "key": "svg-1" }], ["path", { "d": "M10 18v4l2 -1l2 1v-4", "key": "svg-2" }], ["path", { "d": "M10 19h-2a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-2", "key": "svg-3" }]]);

var IconCertificateOff = createVueComponent("outline", "certificate-off", "CertificateOff", [["path", { "d": "M12.876 12.881a3 3 0 0 0 4.243 4.243m.588 -3.42a3.012 3.012 0 0 0 -1.437 -1.423", "key": "svg-0" }], ["path", { "d": "M13 17.5v4.5l2 -1.5l2 1.5v-4.5", "key": "svg-1" }], ["path", { "d": "M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2m4 0h10a2 2 0 0 1 2 2v10", "key": "svg-2" }], ["path", { "d": "M6 9h3m4 0h5", "key": "svg-3" }], ["path", { "d": "M6 12h3", "key": "svg-4" }], ["path", { "d": "M6 15h2", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconCertificate = createVueComponent("outline", "certificate", "Certificate", [["path", { "d": "M15 15m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M13 17.5v4.5l2 -1.5l2 1.5v-4.5", "key": "svg-1" }], ["path", { "d": "M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -1 1.73", "key": "svg-2" }], ["path", { "d": "M6 9l12 0", "key": "svg-3" }], ["path", { "d": "M6 12l3 0", "key": "svg-4" }], ["path", { "d": "M6 15l2 0", "key": "svg-5" }]]);

var IconChairDirector = createVueComponent("outline", "chair-director", "ChairDirector", [["path", { "d": "M6 21l12 -9", "key": "svg-0" }], ["path", { "d": "M6 12l12 9", "key": "svg-1" }], ["path", { "d": "M5 12h14", "key": "svg-2" }], ["path", { "d": "M6 3v9", "key": "svg-3" }], ["path", { "d": "M18 3v9", "key": "svg-4" }], ["path", { "d": "M6 8h12", "key": "svg-5" }], ["path", { "d": "M6 5h12", "key": "svg-6" }]]);

var IconChalkboardOff = createVueComponent("outline", "chalkboard-off", "ChalkboardOff", [["path", { "d": "M8 19h-3a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2m4 0h10a2 2 0 0 1 2 2v10", "key": "svg-0" }], ["path", { "d": "M17 17v1a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h4", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChalkboardTeacher = createVueComponent("outline", "chalkboard-teacher", "ChalkboardTeacher", [["path", { "d": "M8 19h-3a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v11a1 1 0 0 1 -1 1", "key": "svg-0" }], ["path", { "d": "M12 14a2 2 0 1 0 4.001 -.001a2 2 0 0 0 -4.001 .001", "key": "svg-1" }], ["path", { "d": "M17 19a2 2 0 0 0 -2 -2h-2a2 2 0 0 0 -2 2", "key": "svg-2" }]]);

var IconChalkboard = createVueComponent("outline", "chalkboard", "Chalkboard", [["path", { "d": "M8 19h-3a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v11a1 1 0 0 1 -1 1", "key": "svg-0" }], ["path", { "d": "M11 16m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }]]);

var IconChargingPile = createVueComponent("outline", "charging-pile", "ChargingPile", [["path", { "d": "M18 7l-1 1", "key": "svg-0" }], ["path", { "d": "M14 11h1a2 2 0 0 1 2 2v3a1.5 1.5 0 0 0 3 0v-7l-3 -3", "key": "svg-1" }], ["path", { "d": "M4 20v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v14", "key": "svg-2" }], ["path", { "d": "M9 11.5l-1.5 2.5h3l-1.5 2.5", "key": "svg-3" }], ["path", { "d": "M3 20l12 0", "key": "svg-4" }], ["path", { "d": "M4 8l10 0", "key": "svg-5" }]]);

var IconChartArcs3 = createVueComponent("outline", "chart-arcs-3", "ChartArcs3", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M7 12a5 5 0 1 0 5 -5", "key": "svg-1" }], ["path", { "d": "M6.29 18.957a9 9 0 1 0 5.71 -15.957", "key": "svg-2" }]]);

var IconChartArcs = createVueComponent("outline", "chart-arcs", "ChartArcs", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M16.924 11.132a5 5 0 1 0 -4.056 5.792", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 1 0 9 -9", "key": "svg-2" }]]);

var IconChartAreaLine = createVueComponent("outline", "chart-area-line", "ChartAreaLine", [["path", { "d": "M4 19l4 -6l4 2l4 -5l4 4l0 5l-16 0", "key": "svg-0" }], ["path", { "d": "M4 12l3 -4l4 2l5 -6l4 4", "key": "svg-1" }]]);

var IconChartArea = createVueComponent("outline", "chart-area", "ChartArea", [["path", { "d": "M4 19l16 0", "key": "svg-0" }], ["path", { "d": "M4 15l4 -6l4 2l4 -5l4 4l0 5l-16 0", "key": "svg-1" }]]);

var IconChartArrowsVertical = createVueComponent("outline", "chart-arrows-vertical", "ChartArrowsVertical", [["path", { "d": "M18 21v-14", "key": "svg-0" }], ["path", { "d": "M9 15l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M15 10l3 -3l3 3", "key": "svg-2" }], ["path", { "d": "M3 21l18 0", "key": "svg-3" }], ["path", { "d": "M12 21l0 -9", "key": "svg-4" }], ["path", { "d": "M3 6l3 -3l3 3", "key": "svg-5" }], ["path", { "d": "M6 21v-18", "key": "svg-6" }]]);

var IconChartArrows = createVueComponent("outline", "chart-arrows", "ChartArrows", [["path", { "d": "M3 18l14 0", "key": "svg-0" }], ["path", { "d": "M9 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M14 15l3 3l-3 3", "key": "svg-2" }], ["path", { "d": "M3 3l0 18", "key": "svg-3" }], ["path", { "d": "M3 12l9 0", "key": "svg-4" }], ["path", { "d": "M18 3l3 3l-3 3", "key": "svg-5" }], ["path", { "d": "M3 6l18 0", "key": "svg-6" }]]);

var IconChartBarOff = createVueComponent("outline", "chart-bar-off", "ChartBarOff", [["path", { "d": "M3 12m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 8h2a1 1 0 0 1 1 1v2m0 4v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-10", "key": "svg-1" }], ["path", { "d": "M15 11v-6a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v12m-1 3h-4a1 1 0 0 1 -1 -1v-4", "key": "svg-2" }], ["path", { "d": "M4 20h14", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconChartBarPopular = createVueComponent("outline", "chart-bar-popular", "ChartBarPopular", [["path", { "d": "M3 13a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M9 9a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M15 5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M4 20h14", "key": "svg-3" }]]);

var IconChartBar = createVueComponent("outline", "chart-bar", "ChartBar", [["path", { "d": "M3 13a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M15 9a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M9 5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M4 20h14", "key": "svg-3" }]]);

var IconChartBubble = createVueComponent("outline", "chart-bubble", "ChartBubble", [["path", { "d": "M6 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M16 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M14.5 7.5m-4.5 0a4.5 4.5 0 1 0 9 0a4.5 4.5 0 1 0 -9 0", "key": "svg-2" }]]);

var IconChartCandle = createVueComponent("outline", "chart-candle", "ChartCandle", [["path", { "d": "M4 6m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M6 4l0 2", "key": "svg-1" }], ["path", { "d": "M6 11l0 9", "key": "svg-2" }], ["path", { "d": "M10 14m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-3" }], ["path", { "d": "M12 4l0 10", "key": "svg-4" }], ["path", { "d": "M12 19l0 1", "key": "svg-5" }], ["path", { "d": "M16 5m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-6" }], ["path", { "d": "M18 4l0 1", "key": "svg-7" }], ["path", { "d": "M18 11l0 9", "key": "svg-8" }]]);

var IconChartCircles = createVueComponent("outline", "chart-circles", "ChartCircles", [["path", { "d": "M9.5 9.5m-5.5 0a5.5 5.5 0 1 0 11 0a5.5 5.5 0 1 0 -11 0", "key": "svg-0" }], ["path", { "d": "M14.5 14.5m-5.5 0a5.5 5.5 0 1 0 11 0a5.5 5.5 0 1 0 -11 0", "key": "svg-1" }]]);

var IconChartCohort = createVueComponent("outline", "chart-cohort", "ChartCohort", [["path", { "d": "M3 9h18v-6h-18v18h6v-18", "key": "svg-0" }], ["path", { "d": "M3 15h12v-12", "key": "svg-1" }]]);

var IconChartColumn = createVueComponent("outline", "chart-column", "ChartColumn", [["path", { "d": "M4 20h3", "key": "svg-0" }], ["path", { "d": "M17 20h3", "key": "svg-1" }], ["path", { "d": "M10.5 20h3", "key": "svg-2" }], ["path", { "d": "M4 16h3", "key": "svg-3" }], ["path", { "d": "M17 16h3", "key": "svg-4" }], ["path", { "d": "M10.5 16h3", "key": "svg-5" }], ["path", { "d": "M4 12h3", "key": "svg-6" }], ["path", { "d": "M17 12h3", "key": "svg-7" }], ["path", { "d": "M10.5 12h3", "key": "svg-8" }], ["path", { "d": "M4 8h3", "key": "svg-9" }], ["path", { "d": "M17 8h3", "key": "svg-10" }], ["path", { "d": "M4 4h3", "key": "svg-11" }]]);

var IconChartCovariate = createVueComponent("outline", "chart-covariate", "ChartCovariate", [["path", { "d": "M18 11h.009", "key": "svg-0" }], ["path", { "d": "M14 15h.009", "key": "svg-1" }], ["path", { "d": "M12 6h.009", "key": "svg-2" }], ["path", { "d": "M8 10h.009", "key": "svg-3" }], ["path", { "d": "M3 21l17 -17", "key": "svg-4" }], ["path", { "d": "M3 3v18h18", "key": "svg-5" }]]);

var IconChartDonut2 = createVueComponent("outline", "chart-donut-2", "ChartDonut2", [["path", { "d": "M12 3v5m4 4h5", "key": "svg-0" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconChartDonut3 = createVueComponent("outline", "chart-donut-3", "ChartDonut3", [["path", { "d": "M12 3v5m4 4h5", "key": "svg-0" }], ["path", { "d": "M8.929 14.582l-3.429 2.918", "key": "svg-1" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-3" }]]);

var IconChartDonut4 = createVueComponent("outline", "chart-donut-4", "ChartDonut4", [["path", { "d": "M8.848 14.667l-3.348 2.833", "key": "svg-0" }], ["path", { "d": "M12 3v5m4 4h5", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }], ["path", { "d": "M14.219 15.328l2.781 4.172", "key": "svg-3" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-4" }]]);

var IconChartDonut = createVueComponent("outline", "chart-donut", "ChartDonut", [["path", { "d": "M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-3.8a4.1 4.1 0 1 1 -5 -5v-4a.9 .9 0 0 0 -1 -.8", "key": "svg-0" }], ["path", { "d": "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a9 9 0 0 0 -1 -1v-4.5", "key": "svg-1" }]]);

var IconChartDots2 = createVueComponent("outline", "chart-dots-2", "ChartDots2", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M13 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M21 3l-6 1.5", "key": "svg-4" }], ["path", { "d": "M14.113 6.65l2.771 3.695", "key": "svg-5" }], ["path", { "d": "M16 12.5l-5 2", "key": "svg-6" }]]);

var IconChartDots3 = createVueComponent("outline", "chart-dots-3", "ChartDots3", [["path", { "d": "M5 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M16 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M18 6m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M6 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M9 17l5 -1.5", "key": "svg-4" }], ["path", { "d": "M6.5 8.5l7.81 5.37", "key": "svg-5" }], ["path", { "d": "M7 7l8 -1", "key": "svg-6" }]]);

var IconChartDots = createVueComponent("outline", "chart-dots", "ChartDots", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M9 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M14 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M10.16 10.62l2.34 2.88", "key": "svg-4" }], ["path", { "d": "M15.088 13.328l2.837 -4.586", "key": "svg-5" }]]);

var IconChartFunnel = createVueComponent("outline", "chart-funnel", "ChartFunnel", [["path", { "d": "M4.387 3h15.226a1 1 0 0 1 .948 1.316l-5.105 15.316a2 2 0 0 1 -1.898 1.368h-3.116a2 2 0 0 1 -1.898 -1.368l-5.104 -15.316a1 1 0 0 1 .947 -1.316", "key": "svg-0" }], ["path", { "d": "M5 9h14", "key": "svg-1" }], ["path", { "d": "M7 15h10", "key": "svg-2" }]]);

var IconChartGridDots = createVueComponent("outline", "chart-grid-dots", "ChartGridDots", [["path", { "d": "M18 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M6 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M8 18h8", "key": "svg-4" }], ["path", { "d": "M18 20v1", "key": "svg-5" }], ["path", { "d": "M18 3v1", "key": "svg-6" }], ["path", { "d": "M6 20v1", "key": "svg-7" }], ["path", { "d": "M6 10v-7", "key": "svg-8" }], ["path", { "d": "M12 3v18", "key": "svg-9" }], ["path", { "d": "M18 8v8", "key": "svg-10" }], ["path", { "d": "M8 12h13", "key": "svg-11" }], ["path", { "d": "M21 6h-1", "key": "svg-12" }], ["path", { "d": "M16 6h-13", "key": "svg-13" }], ["path", { "d": "M3 12h1", "key": "svg-14" }], ["path", { "d": "M20 18h1", "key": "svg-15" }], ["path", { "d": "M3 18h1", "key": "svg-16" }], ["path", { "d": "M6 14v2", "key": "svg-17" }]]);

var IconChartHistogram = createVueComponent("outline", "chart-histogram", "ChartHistogram", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M20 18v3", "key": "svg-1" }], ["path", { "d": "M16 16v5", "key": "svg-2" }], ["path", { "d": "M12 13v8", "key": "svg-3" }], ["path", { "d": "M8 16v5", "key": "svg-4" }], ["path", { "d": "M3 11c6 0 5 -5 9 -5s3 5 9 5", "key": "svg-5" }]]);

var IconChartInfographic = createVueComponent("outline", "chart-infographic", "ChartInfographic", [["path", { "d": "M7 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M7 3v4h4", "key": "svg-1" }], ["path", { "d": "M9 17l0 4", "key": "svg-2" }], ["path", { "d": "M17 14l0 7", "key": "svg-3" }], ["path", { "d": "M13 13l0 8", "key": "svg-4" }], ["path", { "d": "M21 12l0 9", "key": "svg-5" }]]);

var IconChartLine = createVueComponent("outline", "chart-line", "ChartLine", [["path", { "d": "M4 19l16 0", "key": "svg-0" }], ["path", { "d": "M4 15l4 -6l4 2l4 -5l4 4", "key": "svg-1" }]]);

var IconChartPie2 = createVueComponent("outline", "chart-pie-2", "ChartPie2", [["path", { "d": "M12 3v9h9", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconChartPie3 = createVueComponent("outline", "chart-pie-3", "ChartPie3", [["path", { "d": "M12 12l-6.5 5.5", "key": "svg-0" }], ["path", { "d": "M12 3v9h9", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconChartPie4 = createVueComponent("outline", "chart-pie-4", "ChartPie4", [["path", { "d": "M12 12l-6.5 5.5", "key": "svg-0" }], ["path", { "d": "M12 3v9h9", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }], ["path", { "d": "M12 12l5 7.5", "key": "svg-3" }]]);

var IconChartPieOff = createVueComponent("outline", "chart-pie-off", "ChartPieOff", [["path", { "d": "M5.63 5.643a9 9 0 0 0 12.742 12.715m1.674 -2.29a9.03 9.03 0 0 0 .754 -2.068a1 1 0 0 0 -1 -1h-2.8m-4 0a2 2 0 0 1 -2 -2m0 -4v-3a.9 .9 0 0 0 -1 -.8a9 9 0 0 0 -2.057 .749", "key": "svg-0" }], ["path", { "d": "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a1 1 0 0 1 -1 -1v-4.5", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChartPie = createVueComponent("outline", "chart-pie", "ChartPie", [["path", { "d": "M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-6.8a2 2 0 0 1 -2 -2v-7a.9 .9 0 0 0 -1 -.8", "key": "svg-0" }], ["path", { "d": "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a1 1 0 0 1 -1 -1v-4.5", "key": "svg-1" }]]);

var IconChartPpf = createVueComponent("outline", "chart-ppf", "ChartPpf", [["path", { "d": "M19 17c0 -6.075 -5.373 -11 -12 -11", "key": "svg-0" }], ["path", { "d": "M3 3v18h18", "key": "svg-1" }]]);

var IconChartRadar = createVueComponent("outline", "chart-radar", "ChartRadar", [["path", { "d": "M12 3l9.5 7l-3.5 11h-12l-3.5 -11z", "key": "svg-0" }], ["path", { "d": "M12 7.5l5.5 4l-2.5 5.5h-6.5l-2 -5.5z", "key": "svg-1" }], ["path", { "d": "M2.5 10l9.5 3l9.5 -3", "key": "svg-2" }], ["path", { "d": "M12 3v10l6 8", "key": "svg-3" }], ["path", { "d": "M6 21l6 -8", "key": "svg-4" }]]);

var IconChartSankey = createVueComponent("outline", "chart-sankey", "ChartSankey", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M3 6h18", "key": "svg-1" }], ["path", { "d": "M3 8c10 0 8 9 18 9", "key": "svg-2" }]]);

var IconChartScatter3d = createVueComponent("outline", "chart-scatter-3d", "ChartScatter3d", [["path", { "d": "M3 20l9 -7", "key": "svg-0" }], ["path", { "d": "M12 3v10l9 7", "key": "svg-1" }], ["path", { "d": "M17 12v.015", "key": "svg-2" }], ["path", { "d": "M17 4.015v.015", "key": "svg-3" }], ["path", { "d": "M21 8.015v.015", "key": "svg-4" }], ["path", { "d": "M12 19.015v.015", "key": "svg-5" }], ["path", { "d": "M3 12.015v.015", "key": "svg-6" }], ["path", { "d": "M7 8.015v.015", "key": "svg-7" }], ["path", { "d": "M3 4.015v.015", "key": "svg-8" }]]);

var IconChartScatter = createVueComponent("outline", "chart-scatter", "ChartScatter", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M8 15.015v.015", "key": "svg-1" }], ["path", { "d": "M16 16.015v.015", "key": "svg-2" }], ["path", { "d": "M8 7.03v.015", "key": "svg-3" }], ["path", { "d": "M12 11.03v.015", "key": "svg-4" }], ["path", { "d": "M19 11.03v.015", "key": "svg-5" }]]);

var IconChartTreemap = createVueComponent("outline", "chart-treemap", "ChartTreemap", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 4v16", "key": "svg-1" }], ["path", { "d": "M4 15h8", "key": "svg-2" }], ["path", { "d": "M12 12h8", "key": "svg-3" }], ["path", { "d": "M16 12v8", "key": "svg-4" }], ["path", { "d": "M16 16h4", "key": "svg-5" }]]);

var IconCheck = createVueComponent("outline", "check", "Check", [["path", { "d": "M5 12l5 5l10 -10", "key": "svg-0" }]]);

var IconCheckbox = createVueComponent("outline", "checkbox", "Checkbox", [["path", { "d": "M9 11l3 3l8 -8", "key": "svg-0" }], ["path", { "d": "M20 12v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h9", "key": "svg-1" }]]);

var IconChecklist = createVueComponent("outline", "checklist", "Checklist", [["path", { "d": "M9.615 20h-2.615a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M14 19l2 2l4 -4", "key": "svg-1" }], ["path", { "d": "M9 8h4", "key": "svg-2" }], ["path", { "d": "M9 12h2", "key": "svg-3" }]]);

var IconChecks = createVueComponent("outline", "checks", "Checks", [["path", { "d": "M7 12l5 5l10 -10", "key": "svg-0" }], ["path", { "d": "M2 12l5 5m5 -5l5 -5", "key": "svg-1" }]]);

var IconCheckupList = createVueComponent("outline", "checkup-list", "CheckupList", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 14h.01", "key": "svg-2" }], ["path", { "d": "M9 17h.01", "key": "svg-3" }], ["path", { "d": "M12 16l1 1l3 -3", "key": "svg-4" }]]);

var IconCheese = createVueComponent("outline", "cheese", "Cheese", [["path", { "d": "M4.519 20.008l16.481 -.008v-3.5a2 2 0 1 1 0 -4v-3.5h-16.722", "key": "svg-0" }], ["path", { "d": "M21 9l-9.385 -4.992c-2.512 .12 -4.758 1.42 -6.327 3.425c-1.423 1.82 -2.288 4.221 -2.288 6.854c0 2.117 .56 4.085 1.519 5.721", "key": "svg-1" }], ["path", { "d": "M15 13v.01", "key": "svg-2" }], ["path", { "d": "M8 13v.01", "key": "svg-3" }], ["path", { "d": "M11 16v.01", "key": "svg-4" }]]);

var IconChefHatOff = createVueComponent("outline", "chef-hat-off", "ChefHatOff", [["path", { "d": "M8.72 4.712a4 4 0 0 1 7.19 1.439a4 4 0 0 1 2.09 7.723v.126m0 4v3h-12v-7.126a4 4 0 0 1 .081 -7.796", "key": "svg-0" }], ["path", { "d": "M6.161 17.009l10.839 -.009", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChefHat = createVueComponent("outline", "chef-hat", "ChefHat", [["path", { "d": "M12 3c1.918 0 3.52 1.35 3.91 3.151a4 4 0 0 1 2.09 7.723l0 7.126h-12v-7.126a4 4 0 1 1 2.092 -7.723a4 4 0 0 1 3.908 -3.151z", "key": "svg-0" }], ["path", { "d": "M6.161 17.009l11.839 -.009", "key": "svg-1" }]]);

var IconCherry = createVueComponent("outline", "cherry", "Cherry", [["path", { "d": "M7.5 16.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-0" }], ["path", { "d": "M17 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M9 13c.366 -2 1.866 -3.873 4.5 -5.6", "key": "svg-2" }], ["path", { "d": "M17 15c-1.333 -2.333 -2.333 -5.333 -1 -9", "key": "svg-3" }], ["path", { "d": "M5 6c3.667 -2.667 7.333 -2.667 11 0c-3.667 2.667 -7.333 2.667 -11 0", "key": "svg-4" }]]);

var IconChessBishop = createVueComponent("outline", "chess-bishop", "ChessBishop", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M12 4m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M9.5 16c-1.667 0 -2.5 -1.669 -2.5 -3c0 -3.667 1.667 -6 5 -7c3.333 1 5 3.427 5 7c0 1.284 -.775 2.881 -2.325 3l-.175 0h-5z", "key": "svg-2" }], ["path", { "d": "M15 8l-3 3", "key": "svg-3" }], ["path", { "d": "M12 5v1", "key": "svg-4" }]]);

var IconChessKing = createVueComponent("outline", "chess-king", "ChessKing", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M8.5 16a3.5 3.5 0 1 1 3.163 -5h.674a3.5 3.5 0 1 1 3.163 5z", "key": "svg-1" }], ["path", { "d": "M9 6h6", "key": "svg-2" }], ["path", { "d": "M12 3v8", "key": "svg-3" }]]);

var IconChessKnight = createVueComponent("outline", "chess-knight", "ChessKnight", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M9 3l1 3l-3.491 2.148a1 1 0 0 0 .524 1.852h2.967l-2.073 6h7.961l.112 -5c0 -3 -1.09 -5.983 -4 -7c-1.94 -.678 -2.94 -1.011 -3 -1z", "key": "svg-1" }]]);

var IconChessQueen = createVueComponent("outline", "chess-queen", "ChessQueen", [["path", { "d": "M16 16l2 -11l-4 4l-2 -5l-2 5l-4 -4l2 11", "key": "svg-0" }], ["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-1" }], ["path", { "d": "M12 4m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M6 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M18 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconChessRook = createVueComponent("outline", "chess-rook", "ChessRook", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M8 16l1 -9h6l1 9", "key": "svg-1" }], ["path", { "d": "M6 4l.5 3h11l.5 -3", "key": "svg-2" }], ["path", { "d": "M10 4v3", "key": "svg-3" }], ["path", { "d": "M14 4v3", "key": "svg-4" }]]);

var IconChess = createVueComponent("outline", "chess", "Chess", [["path", { "d": "M12 3a3 3 0 0 1 3 3c0 1.113 -.6 2.482 -1.5 3l1.5 7h-6l1.5 -7c-.9 -.518 -1.5 -1.887 -1.5 -3a3 3 0 0 1 3 -3z", "key": "svg-0" }], ["path", { "d": "M8 9h8", "key": "svg-1" }], ["path", { "d": "M6.684 16.772a1 1 0 0 0 -.684 .949v1.279a1 1 0 0 0 1 1h10a1 1 0 0 0 1 -1v-1.28a1 1 0 0 0 -.684 -.948l-2.316 -.772h-6l-2.316 .772z", "key": "svg-2" }]]);

var IconChevronCompactDown = createVueComponent("outline", "chevron-compact-down", "ChevronCompactDown", [["path", { "d": "M4 11l8 3l8 -3", "key": "svg-0" }]]);

var IconChevronCompactLeft = createVueComponent("outline", "chevron-compact-left", "ChevronCompactLeft", [["path", { "d": "M13 20l-3 -8l3 -8", "key": "svg-0" }]]);

var IconChevronCompactRight = createVueComponent("outline", "chevron-compact-right", "ChevronCompactRight", [["path", { "d": "M11 4l3 8l-3 8", "key": "svg-0" }]]);

var IconChevronCompactUp = createVueComponent("outline", "chevron-compact-up", "ChevronCompactUp", [["path", { "d": "M4 13l8 -3l8 3", "key": "svg-0" }]]);

var IconChevronDownLeft = createVueComponent("outline", "chevron-down-left", "ChevronDownLeft", [["path", { "d": "M8 8v8h8", "key": "svg-0" }]]);

var IconChevronDownRight = createVueComponent("outline", "chevron-down-right", "ChevronDownRight", [["path", { "d": "M16 8v8h-8", "key": "svg-0" }]]);

var IconChevronDown = createVueComponent("outline", "chevron-down", "ChevronDown", [["path", { "d": "M6 9l6 6l6 -6", "key": "svg-0" }]]);

var IconChevronLeftPipe = createVueComponent("outline", "chevron-left-pipe", "ChevronLeftPipe", [["path", { "d": "M7 6v12", "key": "svg-0" }], ["path", { "d": "M18 6l-6 6l6 6", "key": "svg-1" }]]);

var IconChevronLeft = createVueComponent("outline", "chevron-left", "ChevronLeft", [["path", { "d": "M15 6l-6 6l6 6", "key": "svg-0" }]]);

var IconChevronRightPipe = createVueComponent("outline", "chevron-right-pipe", "ChevronRightPipe", [["path", { "d": "M6 6l6 6l-6 6", "key": "svg-0" }], ["path", { "d": "M17 5v13", "key": "svg-1" }]]);

var IconChevronRight = createVueComponent("outline", "chevron-right", "ChevronRight", [["path", { "d": "M9 6l6 6l-6 6", "key": "svg-0" }]]);

var IconChevronUpLeft = createVueComponent("outline", "chevron-up-left", "ChevronUpLeft", [["path", { "d": "M8 16v-8h8", "key": "svg-0" }]]);

var IconChevronUpRight = createVueComponent("outline", "chevron-up-right", "ChevronUpRight", [["path", { "d": "M8 8h8v8", "key": "svg-0" }]]);

var IconChevronUp = createVueComponent("outline", "chevron-up", "ChevronUp", [["path", { "d": "M6 15l6 -6l6 6", "key": "svg-0" }]]);

var IconChevronsDownLeft = createVueComponent("outline", "chevrons-down-left", "ChevronsDownLeft", [["path", { "d": "M11 5v8h8", "key": "svg-0" }], ["path", { "d": "M7 9v8h8", "key": "svg-1" }]]);

var IconChevronsDownRight = createVueComponent("outline", "chevrons-down-right", "ChevronsDownRight", [["path", { "d": "M13 5v8h-8", "key": "svg-0" }], ["path", { "d": "M17 9v8h-8", "key": "svg-1" }]]);

var IconChevronsDown = createVueComponent("outline", "chevrons-down", "ChevronsDown", [["path", { "d": "M7 7l5 5l5 -5", "key": "svg-0" }], ["path", { "d": "M7 13l5 5l5 -5", "key": "svg-1" }]]);

var IconChevronsLeft = createVueComponent("outline", "chevrons-left", "ChevronsLeft", [["path", { "d": "M11 7l-5 5l5 5", "key": "svg-0" }], ["path", { "d": "M17 7l-5 5l5 5", "key": "svg-1" }]]);

var IconChevronsRight = createVueComponent("outline", "chevrons-right", "ChevronsRight", [["path", { "d": "M7 7l5 5l-5 5", "key": "svg-0" }], ["path", { "d": "M13 7l5 5l-5 5", "key": "svg-1" }]]);

var IconChevronsUpLeft = createVueComponent("outline", "chevrons-up-left", "ChevronsUpLeft", [["path", { "d": "M7 15v-8h8", "key": "svg-0" }], ["path", { "d": "M11 19v-8h8", "key": "svg-1" }]]);

var IconChevronsUpRight = createVueComponent("outline", "chevrons-up-right", "ChevronsUpRight", [["path", { "d": "M9 7h8v8", "key": "svg-0" }], ["path", { "d": "M5 11h8v8", "key": "svg-1" }]]);

var IconChevronsUp = createVueComponent("outline", "chevrons-up", "ChevronsUp", [["path", { "d": "M7 11l5 -5l5 5", "key": "svg-0" }], ["path", { "d": "M7 17l5 -5l5 5", "key": "svg-1" }]]);

var IconChisel = createVueComponent("outline", "chisel", "Chisel", [["path", { "d": "M14 14l1.5 1.5", "key": "svg-0" }], ["path", { "d": "M18.347 15.575l2.08 2.079a1.96 1.96 0 0 1 -2.773 2.772l-2.08 -2.079a1.96 1.96 0 0 1 2.773 -2.772z", "key": "svg-1" }], ["path", { "d": "M3 6l3 -3l7.414 7.414a2 2 0 0 1 .586 1.414v2.172h-2.172a2 2 0 0 1 -1.414 -.586l-7.414 -7.414z", "key": "svg-2" }]]);

var IconChristmasBall = createVueComponent("outline", "christmas-ball", "ChristmasBall", [["path", { "d": "M12 13m-8 0a8 8 0 1 0 16 0a8 8 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M11 5l1 -2l1 2", "key": "svg-1" }], ["path", { "d": "M4.512 10.161c2.496 -1.105 4.992 -.825 7.488 .839c2.627 1.752 5.255 1.97 7.882 .653", "key": "svg-2" }], ["path", { "d": "M4.315 15.252c2.561 -1.21 5.123 -.96 7.685 .748c2.293 1.528 4.585 1.889 6.878 1.081", "key": "svg-3" }]]);

var IconChristmasTreeOff = createVueComponent("outline", "christmas-tree-off", "ChristmasTreeOff", [["path", { "d": "M9.5 5.5l2.5 -2.5l4 4l-2 1l4 4l-1.5 .5m.5 4.5h-12l4 -4l-3 -1l3 -3", "key": "svg-0" }], ["path", { "d": "M14 17v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChristmasTree = createVueComponent("outline", "christmas-tree", "ChristmasTree", [["path", { "d": "M12 3l4 4l-2 1l4 4l-3 1l4 4h-14l4 -4l-3 -1l4 -4l-2 -1z", "key": "svg-0" }], ["path", { "d": "M14 17v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-3", "key": "svg-1" }]]);

var IconCircleArrowDownLeft = createVueComponent("outline", "circle-arrow-down-left", "CircleArrowDownLeft", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9l-6 6", "key": "svg-1" }], ["path", { "d": "M15 15h-6v-6", "key": "svg-2" }]]);

var IconCircleArrowDownRight = createVueComponent("outline", "circle-arrow-down-right", "CircleArrowDownRight", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 15h-6", "key": "svg-1" }], ["path", { "d": "M15 9v6l-6 -6", "key": "svg-2" }]]);

var IconCircleArrowDown = createVueComponent("outline", "circle-arrow-down", "CircleArrowDown", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 12l4 4", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }], ["path", { "d": "M16 12l-4 4", "key": "svg-3" }]]);

var IconCircleArrowLeft = createVueComponent("outline", "circle-arrow-left", "CircleArrowLeft", [["path", { "d": "M12 21a9 9 0 1 0 0 -18a9 9 0 0 0 0 18", "key": "svg-0" }], ["path", { "d": "M8 12l4 4", "key": "svg-1" }], ["path", { "d": "M8 12h8", "key": "svg-2" }], ["path", { "d": "M12 8l-4 4", "key": "svg-3" }]]);

var IconCircleArrowRight = createVueComponent("outline", "circle-arrow-right", "CircleArrowRight", [["path", { "d": "M12 3a9 9 0 1 0 0 18a9 9 0 0 0 0 -18", "key": "svg-0" }], ["path", { "d": "M16 12l-4 -4", "key": "svg-1" }], ["path", { "d": "M16 12h-8", "key": "svg-2" }], ["path", { "d": "M12 16l4 -4", "key": "svg-3" }]]);

var IconCircleArrowUpLeft = createVueComponent("outline", "circle-arrow-up-left", "CircleArrowUpLeft", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 9l6 6", "key": "svg-1" }], ["path", { "d": "M15 9h-6v6", "key": "svg-2" }]]);

var IconCircleArrowUpRight = createVueComponent("outline", "circle-arrow-up-right", "CircleArrowUpRight", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9l-6 6", "key": "svg-1" }], ["path", { "d": "M15 15v-6h-6", "key": "svg-2" }]]);

var IconCircleArrowUp = createVueComponent("outline", "circle-arrow-up", "CircleArrowUp", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8l-4 4", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }], ["path", { "d": "M16 12l-4 -4", "key": "svg-3" }]]);

var IconCircleCaretDown = createVueComponent("outline", "circle-caret-down", "CircleCaretDown", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 15l-4 -4h8z", "key": "svg-1" }]]);

var IconCircleCaretLeft = createVueComponent("outline", "circle-caret-left", "CircleCaretLeft", [["path", { "d": "M9 12l4 -4v8z", "key": "svg-0" }], ["path", { "d": "M12 21a9 9 0 1 1 0 -18a9 9 0 0 1 0 18z", "key": "svg-1" }]]);

var IconCircleCaretRight = createVueComponent("outline", "circle-caret-right", "CircleCaretRight", [["path", { "d": "M15 12l-4 -4v8z", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleCaretUp = createVueComponent("outline", "circle-caret-up", "CircleCaretUp", [["path", { "d": "M12 9l4 4h-8z", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleCheck = createVueComponent("outline", "circle-check", "CircleCheck", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12l2 2l4 -4", "key": "svg-1" }]]);

var IconCircleChevronDown = createVueComponent("outline", "circle-chevron-down", "CircleChevronDown", [["path", { "d": "M15 11l-3 3l-3 -3", "key": "svg-0" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18a9 9 0 0 0 0 -18z", "key": "svg-1" }]]);

var IconCircleChevronLeft = createVueComponent("outline", "circle-chevron-left", "CircleChevronLeft", [["path", { "d": "M13 15l-3 -3l3 -3", "key": "svg-0" }], ["path", { "d": "M21 12a9 9 0 1 0 -18 0a9 9 0 0 0 18 0z", "key": "svg-1" }]]);

var IconCircleChevronRight = createVueComponent("outline", "circle-chevron-right", "CircleChevronRight", [["path", { "d": "M11 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0z", "key": "svg-1" }]]);

var IconCircleChevronUp = createVueComponent("outline", "circle-chevron-up", "CircleChevronUp", [["path", { "d": "M9 13l3 -3l3 3", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleChevronsDown = createVueComponent("outline", "circle-chevrons-down", "CircleChevronsDown", [["path", { "d": "M15 9l-3 3l-3 -3", "key": "svg-0" }], ["path", { "d": "M15 13l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18a9 9 0 0 0 0 -18z", "key": "svg-2" }]]);

var IconCircleChevronsLeft = createVueComponent("outline", "circle-chevrons-left", "CircleChevronsLeft", [["path", { "d": "M15 15l-3 -3l3 -3", "key": "svg-0" }], ["path", { "d": "M11 15l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M21 12a9 9 0 1 0 0 .265l0 -.265z", "key": "svg-2" }]]);

var IconCircleChevronsRight = createVueComponent("outline", "circle-chevrons-right", "CircleChevronsRight", [["path", { "d": "M9 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M13 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 1 0 0 -.265l0 .265z", "key": "svg-2" }]]);

var IconCircleChevronsUp = createVueComponent("outline", "circle-chevrons-up", "CircleChevronsUp", [["path", { "d": "M9 15l3 -3l3 3", "key": "svg-0" }], ["path", { "d": "M9 11l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M12 21a9 9 0 1 0 -.265 0l.265 0z", "key": "svg-2" }]]);

var IconCircleDashedCheck = createVueComponent("outline", "circle-dashed-check", "CircleDashedCheck", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M9 12l2 2l4 -4", "key": "svg-8" }]]);

var IconCircleDashedLetterA = createVueComponent("outline", "circle-dashed-letter-a", "CircleDashedLetterA", [["path", { "d": "M10 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M10 13h4", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterB = createVueComponent("outline", "circle-dashed-letter-b", "CircleDashedLetterB", [["path", { "d": "M10 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2z", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterC = createVueComponent("outline", "circle-dashed-letter-c", "CircleDashedLetterC", [["path", { "d": "M14 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterD = createVueComponent("outline", "circle-dashed-letter-d", "CircleDashedLetterD", [["path", { "d": "M10 8v8h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterE = createVueComponent("outline", "circle-dashed-letter-e", "CircleDashedLetterE", [["path", { "d": "M14 8h-4v8h4", "key": "svg-0" }], ["path", { "d": "M10 12h2.5", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterF = createVueComponent("outline", "circle-dashed-letter-f", "CircleDashedLetterF", [["path", { "d": "M10 12h3", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterG = createVueComponent("outline", "circle-dashed-letter-g", "CircleDashedLetterG", [["path", { "d": "M14 8h-2a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2v-4h-1", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterH = createVueComponent("outline", "circle-dashed-letter-h", "CircleDashedLetterH", [["path", { "d": "M10 16v-8m4 0v8", "key": "svg-0" }], ["path", { "d": "M10 12h4", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterI = createVueComponent("outline", "circle-dashed-letter-i", "CircleDashedLetterI", [["path", { "d": "M12 8v8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterJ = createVueComponent("outline", "circle-dashed-letter-j", "CircleDashedLetterJ", [["path", { "d": "M10 8h4v6a2 2 0 1 1 -4 0", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterK = createVueComponent("outline", "circle-dashed-letter-k", "CircleDashedLetterK", [["path", { "d": "M10 8v8", "key": "svg-0" }], ["path", { "d": "M14 8l-2.5 4l2.5 4", "key": "svg-1" }], ["path", { "d": "M10 12h1.5", "key": "svg-2" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-3" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-4" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-5" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-6" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-7" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-8" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-9" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-10" }]]);

var IconCircleDashedLetterL = createVueComponent("outline", "circle-dashed-letter-l", "CircleDashedLetterL", [["path", { "d": "M10 8v8h4", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterM = createVueComponent("outline", "circle-dashed-letter-m", "CircleDashedLetterM", [["path", { "d": "M9 16v-8l3 5l3 -5v8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterN = createVueComponent("outline", "circle-dashed-letter-n", "CircleDashedLetterN", [["path", { "d": "M10 16v-8l4 8v-8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterO = createVueComponent("outline", "circle-dashed-letter-o", "CircleDashedLetterO", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterP = createVueComponent("outline", "circle-dashed-letter-p", "CircleDashedLetterP", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterQ = createVueComponent("outline", "circle-dashed-letter-q", "CircleDashedLetterQ", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M13 15l1 1", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterR = createVueComponent("outline", "circle-dashed-letter-r", "CircleDashedLetterR", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8m4 0l-3 -4", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterS = createVueComponent("outline", "circle-dashed-letter-s", "CircleDashedLetterS", [["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterT = createVueComponent("outline", "circle-dashed-letter-t", "CircleDashedLetterT", [["path", { "d": "M10 8h4", "key": "svg-0" }], ["path", { "d": "M12 8v8", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterU = createVueComponent("outline", "circle-dashed-letter-u", "CircleDashedLetterU", [["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-6", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterV = createVueComponent("outline", "circle-dashed-letter-v", "CircleDashedLetterV", [["path", { "d": "M10 8l2 8l2 -8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterW = createVueComponent("outline", "circle-dashed-letter-w", "CircleDashedLetterW", [["path", { "d": "M9 8l1 8l2 -5l2 5l1 -8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterX = createVueComponent("outline", "circle-dashed-letter-x", "CircleDashedLetterX", [["path", { "d": "M10 8l4 8", "key": "svg-0" }], ["path", { "d": "M10 16l4 -8", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterY = createVueComponent("outline", "circle-dashed-letter-y", "CircleDashedLetterY", [["path", { "d": "M10 8l2 5l2 -5", "key": "svg-0" }], ["path", { "d": "M12 16v-3", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterZ = createVueComponent("outline", "circle-dashed-letter-z", "CircleDashedLetterZ", [["path", { "d": "M10 8h4l-4 8h4", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedMinus = createVueComponent("outline", "circle-dashed-minus", "CircleDashedMinus", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M9 12h6", "key": "svg-8" }]]);

var IconCircleDashedNumber0 = createVueComponent("outline", "circle-dashed-number-0", "CircleDashedNumber0", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 10v4a2 2 0 1 0 4 0v-4a2 2 0 1 0 -4 0z", "key": "svg-8" }]]);

var IconCircleDashedNumber1 = createVueComponent("outline", "circle-dashed-number-1", "CircleDashedNumber1", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 10l2 -2v8", "key": "svg-8" }]]);

var IconCircleDashedNumber2 = createVueComponent("outline", "circle-dashed-number-2", "CircleDashedNumber2", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8h3a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-8" }]]);

var IconCircleDashedNumber3 = createVueComponent("outline", "circle-dashed-number-3", "CircleDashedNumber3", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8h2.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-1.5h1.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-2.5", "key": "svg-8" }]]);

var IconCircleDashedNumber4 = createVueComponent("outline", "circle-dashed-number-4", "CircleDashedNumber4", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8v3a1 1 0 0 0 1 1h3", "key": "svg-8" }], ["path", { "d": "M14 8v8", "key": "svg-9" }]]);

var IconCircleDashedNumber5 = createVueComponent("outline", "circle-dashed-number-5", "CircleDashedNumber5", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3v-4h4", "key": "svg-8" }]]);

var IconCircleDashedNumber6 = createVueComponent("outline", "circle-dashed-number-6", "CircleDashedNumber6", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M14 9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3", "key": "svg-8" }]]);

var IconCircleDashedNumber7 = createVueComponent("outline", "circle-dashed-number-7", "CircleDashedNumber7", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8h4l-2 8", "key": "svg-8" }]]);

var IconCircleDashedNumber8 = createVueComponent("outline", "circle-dashed-number-8", "CircleDashedNumber8", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M12 12h-1a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1", "key": "svg-8" }]]);

var IconCircleDashedNumber9 = createVueComponent("outline", "circle-dashed-number-9", "CircleDashedNumber9", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-6a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-8" }]]);

var IconCircleDashedPercentage = createVueComponent("outline", "circle-dashed-percentage", "CircleDashedPercentage", [["path", { "d": "M9 15l6 -6", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }], ["path", { "d": "M9 9.03v.015", "key": "svg-9" }], ["path", { "d": "M15 15.045v.015", "key": "svg-10" }]]);

var IconCircleDashedPlus = createVueComponent("outline", "circle-dashed-plus", "CircleDashedPlus", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M9 12h6", "key": "svg-8" }], ["path", { "d": "M12 9v6", "key": "svg-9" }]]);

var IconCircleDashedX = createVueComponent("outline", "circle-dashed-x", "CircleDashedX", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M14 14l-4 -4", "key": "svg-8" }], ["path", { "d": "M10 14l4 -4", "key": "svg-9" }]]);

var IconCircleDashed = createVueComponent("outline", "circle-dashed", "CircleDashed", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }]]);

var IconCircleDot = createVueComponent("outline", "circle-dot", "CircleDot", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleDottedLetterA = createVueComponent("outline", "circle-dotted-letter-a", "CircleDottedLetterA", [["path", { "d": "M10 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M10 13h4", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterB = createVueComponent("outline", "circle-dotted-letter-b", "CircleDottedLetterB", [["path", { "d": "M10 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2z", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterC = createVueComponent("outline", "circle-dotted-letter-c", "CircleDottedLetterC", [["path", { "d": "M14 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterD = createVueComponent("outline", "circle-dotted-letter-d", "CircleDottedLetterD", [["path", { "d": "M10 8v8h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterE = createVueComponent("outline", "circle-dotted-letter-e", "CircleDottedLetterE", [["path", { "d": "M14 8h-4v8h4", "key": "svg-0" }], ["path", { "d": "M10 12h2.5", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterF = createVueComponent("outline", "circle-dotted-letter-f", "CircleDottedLetterF", [["path", { "d": "M10 12h3", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterG = createVueComponent("outline", "circle-dotted-letter-g", "CircleDottedLetterG", [["path", { "d": "M14 8h-2a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2v-4h-1", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterH = createVueComponent("outline", "circle-dotted-letter-h", "CircleDottedLetterH", [["path", { "d": "M10 16v-8m4 0v8", "key": "svg-0" }], ["path", { "d": "M10 12h4", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterI = createVueComponent("outline", "circle-dotted-letter-i", "CircleDottedLetterI", [["path", { "d": "M12 8v8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterJ = createVueComponent("outline", "circle-dotted-letter-j", "CircleDottedLetterJ", [["path", { "d": "M10 8h4v6a2 2 0 1 1 -4 0", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterK = createVueComponent("outline", "circle-dotted-letter-k", "CircleDottedLetterK", [["path", { "d": "M10 8v8", "key": "svg-0" }], ["path", { "d": "M14 8l-2.5 4l2.5 4", "key": "svg-1" }], ["path", { "d": "M10 12h1.5", "key": "svg-2" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-3" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-4" }], ["path", { "d": "M3 12v.01", "key": "svg-5" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-6" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M12 21v.01", "key": "svg-8" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-9" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-10" }], ["path", { "d": "M21 12v.01", "key": "svg-11" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-12" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-13" }], ["path", { "d": "M12 3v.01", "key": "svg-14" }]]);

var IconCircleDottedLetterL = createVueComponent("outline", "circle-dotted-letter-l", "CircleDottedLetterL", [["path", { "d": "M10 8v8h4", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterM = createVueComponent("outline", "circle-dotted-letter-m", "CircleDottedLetterM", [["path", { "d": "M9 16v-8l3 5l3 -5v8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterN = createVueComponent("outline", "circle-dotted-letter-n", "CircleDottedLetterN", [["path", { "d": "M10 16v-8l4 8v-8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterO = createVueComponent("outline", "circle-dotted-letter-o", "CircleDottedLetterO", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterP = createVueComponent("outline", "circle-dotted-letter-p", "CircleDottedLetterP", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterQ = createVueComponent("outline", "circle-dotted-letter-q", "CircleDottedLetterQ", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M13 15l1 1", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterR = createVueComponent("outline", "circle-dotted-letter-r", "CircleDottedLetterR", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8m4 0l-3 -4", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterS = createVueComponent("outline", "circle-dotted-letter-s", "CircleDottedLetterS", [["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterT = createVueComponent("outline", "circle-dotted-letter-t", "CircleDottedLetterT", [["path", { "d": "M10 8h4", "key": "svg-0" }], ["path", { "d": "M12 8v8", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterU = createVueComponent("outline", "circle-dotted-letter-u", "CircleDottedLetterU", [["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-6", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterV = createVueComponent("outline", "circle-dotted-letter-v", "CircleDottedLetterV", [["path", { "d": "M10 8l2 8l2 -8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterW = createVueComponent("outline", "circle-dotted-letter-w", "CircleDottedLetterW", [["path", { "d": "M9 8l1 8l2 -5l2 5l1 -8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterX = createVueComponent("outline", "circle-dotted-letter-x", "CircleDottedLetterX", [["path", { "d": "M10 8l4 8", "key": "svg-0" }], ["path", { "d": "M10 16l4 -8", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterY = createVueComponent("outline", "circle-dotted-letter-y", "CircleDottedLetterY", [["path", { "d": "M10 8l2 5l2 -5", "key": "svg-0" }], ["path", { "d": "M12 16v-3", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterZ = createVueComponent("outline", "circle-dotted-letter-z", "CircleDottedLetterZ", [["path", { "d": "M10 8h4l-4 8h4", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDotted = createVueComponent("outline", "circle-dotted", "CircleDotted", [["path", { "d": "M7.5 4.21l0 .01", "key": "svg-0" }], ["path", { "d": "M4.21 7.5l0 .01", "key": "svg-1" }], ["path", { "d": "M3 12l0 .01", "key": "svg-2" }], ["path", { "d": "M4.21 16.5l0 .01", "key": "svg-3" }], ["path", { "d": "M7.5 19.79l0 .01", "key": "svg-4" }], ["path", { "d": "M12 21l0 .01", "key": "svg-5" }], ["path", { "d": "M16.5 19.79l0 .01", "key": "svg-6" }], ["path", { "d": "M19.79 16.5l0 .01", "key": "svg-7" }], ["path", { "d": "M21 12l0 .01", "key": "svg-8" }], ["path", { "d": "M19.79 7.5l0 .01", "key": "svg-9" }], ["path", { "d": "M16.5 4.21l0 .01", "key": "svg-10" }], ["path", { "d": "M12 3l0 .01", "key": "svg-11" }]]);

var IconCircleHalf2 = createVueComponent("outline", "circle-half-2", "CircleHalf2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3v18", "key": "svg-1" }], ["path", { "d": "M12 14l7 -7", "key": "svg-2" }], ["path", { "d": "M12 19l8.5 -8.5", "key": "svg-3" }], ["path", { "d": "M12 9l4.5 -4.5", "key": "svg-4" }]]);

var IconCircleHalfVertical = createVueComponent("outline", "circle-half-vertical", "CircleHalfVertical", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M3 12h18", "key": "svg-1" }]]);

var IconCircleHalf = createVueComponent("outline", "circle-half", "CircleHalf", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3v18", "key": "svg-1" }]]);

var IconCircleKey = createVueComponent("outline", "circle-key", "CircleKey", [["path", { "d": "M14 10m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-1" }], ["path", { "d": "M12.5 11.5l-4 4l1.5 1.5", "key": "svg-2" }], ["path", { "d": "M12 15l-1.5 -1.5", "key": "svg-3" }]]);

var IconCircleLetterA = createVueComponent("outline", "circle-letter-a", "CircleLetterA", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16v-6a2 2 0 1 1 4 0v6", "key": "svg-1" }], ["path", { "d": "M10 13h4", "key": "svg-2" }]]);

var IconCircleLetterB = createVueComponent("outline", "circle-letter-b", "CircleLetterB", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2v8z", "key": "svg-1" }]]);

var IconCircleLetterC = createVueComponent("outline", "circle-letter-c", "CircleLetterC", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-1" }]]);

var IconCircleLetterD = createVueComponent("outline", "circle-letter-d", "CircleLetterD", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v8h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-2z", "key": "svg-1" }]]);

var IconCircleLetterE = createVueComponent("outline", "circle-letter-e", "CircleLetterE", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8h4", "key": "svg-1" }], ["path", { "d": "M10 12h2.5", "key": "svg-2" }]]);

var IconCircleLetterF = createVueComponent("outline", "circle-letter-f", "CircleLetterF", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 12h3", "key": "svg-1" }], ["path", { "d": "M14 8h-4v8", "key": "svg-2" }]]);

var IconCircleLetterG = createVueComponent("outline", "circle-letter-g", "CircleLetterG", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 8h-2a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2v-4h-1", "key": "svg-1" }]]);

var IconCircleLetterH = createVueComponent("outline", "circle-letter-h", "CircleLetterH", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16v-8m4 0v8", "key": "svg-1" }], ["path", { "d": "M10 12h4", "key": "svg-2" }]]);

var IconCircleLetterI = createVueComponent("outline", "circle-letter-i", "CircleLetterI", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8v8", "key": "svg-1" }]]);

var IconCircleLetterJ = createVueComponent("outline", "circle-letter-j", "CircleLetterJ", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4v6a2 2 0 1 1 -4 0", "key": "svg-1" }]]);

var IconCircleLetterK = createVueComponent("outline", "circle-letter-k", "CircleLetterK", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v8", "key": "svg-1" }], ["path", { "d": "M14 8l-2.5 4l2.5 4", "key": "svg-2" }], ["path", { "d": "M10 12h1.5", "key": "svg-3" }]]);

var IconCircleLetterL = createVueComponent("outline", "circle-letter-l", "CircleLetterL", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v8h4", "key": "svg-1" }]]);

var IconCircleLetterM = createVueComponent("outline", "circle-letter-m", "CircleLetterM", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 16v-8l3 5l3 -5v8", "key": "svg-1" }]]);

var IconCircleLetterN = createVueComponent("outline", "circle-letter-n", "CircleLetterN", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16v-8l4 8v-8", "key": "svg-1" }]]);

var IconCircleLetterO = createVueComponent("outline", "circle-letter-o", "CircleLetterO", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-1" }]]);

var IconCircleLetterP = createVueComponent("outline", "circle-letter-p", "CircleLetterP", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8", "key": "svg-1" }]]);

var IconCircleLetterQ = createVueComponent("outline", "circle-letter-q", "CircleLetterQ", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-1" }], ["path", { "d": "M13 15l1 1", "key": "svg-2" }]]);

var IconCircleLetterR = createVueComponent("outline", "circle-letter-r", "CircleLetterR", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8m4 0l-3 -4", "key": "svg-1" }]]);

var IconCircleLetterS = createVueComponent("outline", "circle-letter-s", "CircleLetterS", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-1" }]]);

var IconCircleLetterT = createVueComponent("outline", "circle-letter-t", "CircleLetterT", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }]]);

var IconCircleLetterU = createVueComponent("outline", "circle-letter-u", "CircleLetterU", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-6", "key": "svg-1" }]]);

var IconCircleLetterV = createVueComponent("outline", "circle-letter-v", "CircleLetterV", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8l2 8l2 -8", "key": "svg-1" }]]);

var IconCircleLetterW = createVueComponent("outline", "circle-letter-w", "CircleLetterW", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 8l1 8l2 -5l2 5l1 -8", "key": "svg-1" }]]);

var IconCircleLetterX = createVueComponent("outline", "circle-letter-x", "CircleLetterX", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8l4 8", "key": "svg-1" }], ["path", { "d": "M10 16l4 -8", "key": "svg-2" }]]);

var IconCircleLetterY = createVueComponent("outline", "circle-letter-y", "CircleLetterY", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8l2 5l2 -5", "key": "svg-1" }], ["path", { "d": "M12 16v-3", "key": "svg-2" }]]);

var IconCircleLetterZ = createVueComponent("outline", "circle-letter-z", "CircleLetterZ", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4l-4 8h4", "key": "svg-1" }]]);

var IconCircleMinus2 = createVueComponent("outline", "circle-minus-2", "CircleMinus2", [["path", { "d": "M20.475 15.029a9 9 0 1 0 -7.962 5.957", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconCircleMinus = createVueComponent("outline", "circle-minus", "CircleMinus", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12l6 0", "key": "svg-1" }]]);

var IconCircleNumber0 = createVueComponent("outline", "circle-number-0", "CircleNumber0", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 10v4a2 2 0 1 0 4 0v-4a2 2 0 1 0 -4 0z", "key": "svg-1" }]]);

var IconCircleNumber1 = createVueComponent("outline", "circle-number-1", "CircleNumber1", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 10l2 -2v8", "key": "svg-1" }]]);

var IconCircleNumber2 = createVueComponent("outline", "circle-number-2", "CircleNumber2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h3a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-1" }]]);

var IconCircleNumber3 = createVueComponent("outline", "circle-number-3", "CircleNumber3", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 9a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1", "key": "svg-1" }]]);

var IconCircleNumber4 = createVueComponent("outline", "circle-number-4", "CircleNumber4", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v3a1 1 0 0 0 1 1h3", "key": "svg-1" }], ["path", { "d": "M14 8v8", "key": "svg-2" }]]);

var IconCircleNumber5 = createVueComponent("outline", "circle-number-5", "CircleNumber5", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3v-4h4", "key": "svg-1" }]]);

var IconCircleNumber6 = createVueComponent("outline", "circle-number-6", "CircleNumber6", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3", "key": "svg-1" }]]);

var IconCircleNumber7 = createVueComponent("outline", "circle-number-7", "CircleNumber7", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4l-2 8", "key": "svg-1" }]]);

var IconCircleNumber8 = createVueComponent("outline", "circle-number-8", "CircleNumber8", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12h-1a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1", "key": "svg-1" }]]);

var IconCircleNumber9 = createVueComponent("outline", "circle-number-9", "CircleNumber9", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-6a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-1" }]]);

var IconCircleOff = createVueComponent("outline", "circle-off", "CircleOff", [["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCirclePercentage = createVueComponent("outline", "circle-percentage", "CirclePercentage", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 15.075l6 -6", "key": "svg-1" }], ["path", { "d": "M9 9.105v.015", "key": "svg-2" }], ["path", { "d": "M15 15.12v.015", "key": "svg-3" }]]);

var IconCirclePlus2 = createVueComponent("outline", "circle-plus-2", "CirclePlus2", [["path", { "d": "M20.985 12.522a9 9 0 1 0 -8.475 8.464", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconCirclePlus = createVueComponent("outline", "circle-plus", "CirclePlus", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12h6", "key": "svg-1" }], ["path", { "d": "M12 9v6", "key": "svg-2" }]]);

var IconCircleRectangleOff = createVueComponent("outline", "circle-rectangle-off", "CircleRectangleOff", [["path", { "d": "M14 10h3v3m-3 1h-7v-4h3", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCircleRectangle = createVueComponent("outline", "circle-rectangle", "CircleRectangle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M7 10h10v4h-10z", "key": "svg-1" }]]);

var IconCircleSquare = createVueComponent("outline", "circle-square", "CircleSquare", [["path", { "d": "M9.5 9.5m-6.5 0a6.5 6.5 0 1 0 13 0a6.5 6.5 0 1 0 -13 0", "key": "svg-0" }], ["path", { "d": "M10 10m0 2a2 2 0 0 1 2 -2h7a2 2 0 0 1 2 2v7a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2z", "key": "svg-1" }]]);

var IconCircleTriangle = createVueComponent("outline", "circle-triangle", "CircleTriangle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 20l7 -12h-14z", "key": "svg-1" }]]);

var IconCircleX = createVueComponent("outline", "circle-x", "CircleX", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 10l4 4m0 -4l-4 4", "key": "svg-1" }]]);

var IconCircle = createVueComponent("outline", "circle", "Circle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }]]);

var IconCirclesRelation = createVueComponent("outline", "circles-relation", "CirclesRelation", [["path", { "d": "M9.183 6.117a6 6 0 1 0 4.511 3.986", "key": "svg-0" }], ["path", { "d": "M14.813 17.883a6 6 0 1 0 -4.496 -3.954", "key": "svg-1" }]]);

var IconCircles = createVueComponent("outline", "circles", "Circles", [["path", { "d": "M12 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M6.5 17m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M17.5 17m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }]]);

var IconCircuitAmmeter = createVueComponent("outline", "circuit-ammeter", "CircuitAmmeter", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 12h-3", "key": "svg-1" }], ["path", { "d": "M19 12h3", "key": "svg-2" }], ["path", { "d": "M10 14v-3c0 -1.036 .895 -2 2 -2s2 .964 2 2v3", "key": "svg-3" }], ["path", { "d": "M14 12h-4", "key": "svg-4" }]]);

var IconCircuitBattery = createVueComponent("outline", "circuit-battery", "CircuitBattery", [["path", { "d": "M2 12h4", "key": "svg-0" }], ["path", { "d": "M18 12h4", "key": "svg-1" }], ["path", { "d": "M18 5v14", "key": "svg-2" }], ["path", { "d": "M14 9v6", "key": "svg-3" }], ["path", { "d": "M10 5v14", "key": "svg-4" }], ["path", { "d": "M6 9v6", "key": "svg-5" }]]);

var IconCircuitBulb = createVueComponent("outline", "circuit-bulb", "CircuitBulb", [["path", { "d": "M2 12h5", "key": "svg-0" }], ["path", { "d": "M17 12h5", "key": "svg-1" }], ["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-2" }], ["path", { "d": "M8.5 8.5l7 7", "key": "svg-3" }], ["path", { "d": "M15.5 8.5l-7 7", "key": "svg-4" }]]);

var IconCircuitCapacitorPolarized = createVueComponent("outline", "circuit-capacitor-polarized", "CircuitCapacitorPolarized", [["path", { "d": "M22 12h-8", "key": "svg-0" }], ["path", { "d": "M2 12h8", "key": "svg-1" }], ["path", { "d": "M10 7v10", "key": "svg-2" }], ["path", { "d": "M14 7v10", "key": "svg-3" }], ["path", { "d": "M17 5h4", "key": "svg-4" }], ["path", { "d": "M19 3v4", "key": "svg-5" }]]);

var IconCircuitCapacitor = createVueComponent("outline", "circuit-capacitor", "CircuitCapacitor", [["path", { "d": "M22 12h-8", "key": "svg-0" }], ["path", { "d": "M2 12h8", "key": "svg-1" }], ["path", { "d": "M10 7v10", "key": "svg-2" }], ["path", { "d": "M14 7v10", "key": "svg-3" }]]);

var IconCircuitCellPlus = createVueComponent("outline", "circuit-cell-plus", "CircuitCellPlus", [["path", { "d": "M2 12h9", "key": "svg-0" }], ["path", { "d": "M15 12h7", "key": "svg-1" }], ["path", { "d": "M11 5v14", "key": "svg-2" }], ["path", { "d": "M15 9v6", "key": "svg-3" }], ["path", { "d": "M3 5h4", "key": "svg-4" }], ["path", { "d": "M5 3v4", "key": "svg-5" }]]);

var IconCircuitCell = createVueComponent("outline", "circuit-cell", "CircuitCell", [["path", { "d": "M2 12h8", "key": "svg-0" }], ["path", { "d": "M14 12h8", "key": "svg-1" }], ["path", { "d": "M10 5v14", "key": "svg-2" }], ["path", { "d": "M14 9v6", "key": "svg-3" }]]);

var IconCircuitChangeover = createVueComponent("outline", "circuit-changeover", "CircuitChangeover", [["path", { "d": "M2 12h2", "key": "svg-0" }], ["path", { "d": "M20 7h2", "key": "svg-1" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M20 17h2", "key": "svg-4" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-5" }], ["path", { "d": "M7.5 10.5l8.5 -3.5", "key": "svg-6" }]]);

var IconCircuitDiodeZener = createVueComponent("outline", "circuit-diode-zener", "CircuitDiodeZener", [["path", { "d": "M22 12h-6", "key": "svg-0" }], ["path", { "d": "M2 12h6", "key": "svg-1" }], ["path", { "d": "M8 7l8 5l-8 5z", "key": "svg-2" }], ["path", { "d": "M14 7h2v10h2", "key": "svg-3" }]]);

var IconCircuitDiode = createVueComponent("outline", "circuit-diode", "CircuitDiode", [["path", { "d": "M22 12h-6", "key": "svg-0" }], ["path", { "d": "M2 12h6", "key": "svg-1" }], ["path", { "d": "M8 7l8 5l-8 5z", "key": "svg-2" }], ["path", { "d": "M16 7v10", "key": "svg-3" }]]);

var IconCircuitGroundDigital = createVueComponent("outline", "circuit-ground-digital", "CircuitGroundDigital", [["path", { "d": "M12 13v-10", "key": "svg-0" }], ["path", { "d": "M12 21l-6 -8h12z", "key": "svg-1" }]]);

var IconCircuitGround = createVueComponent("outline", "circuit-ground", "CircuitGround", [["path", { "d": "M12 13v-8", "key": "svg-0" }], ["path", { "d": "M4 13h16", "key": "svg-1" }], ["path", { "d": "M7 16h10", "key": "svg-2" }], ["path", { "d": "M10 19h4", "key": "svg-3" }]]);

var IconCircuitInductor = createVueComponent("outline", "circuit-inductor", "CircuitInductor", [["path", { "d": "M2 14h3v-2a2 2 0 1 1 4 0v2v-1.5a2.5 2.5 0 1 1 5 0v1.5v-1.5a2.5 2.5 0 1 1 5 0v1.5h3", "key": "svg-0" }]]);

var IconCircuitMotor = createVueComponent("outline", "circuit-motor", "CircuitMotor", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 12h-3", "key": "svg-1" }], ["path", { "d": "M19 12h3", "key": "svg-2" }], ["path", { "d": "M10 14v-4l2 2l2 -2v4", "key": "svg-3" }]]);

var IconCircuitPushbutton = createVueComponent("outline", "circuit-pushbutton", "CircuitPushbutton", [["path", { "d": "M2 17h2", "key": "svg-0" }], ["path", { "d": "M20 17h2", "key": "svg-1" }], ["path", { "d": "M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M6 11h12", "key": "svg-4" }], ["path", { "d": "M12 11v-6", "key": "svg-5" }]]);

var IconCircuitResistor = createVueComponent("outline", "circuit-resistor", "CircuitResistor", [["path", { "d": "M2 12h2l2 -5l3 10l3 -10l3 10l3 -10l1.5 5h2.5", "key": "svg-0" }]]);

var IconCircuitSwitchClosed = createVueComponent("outline", "circuit-switch-closed", "CircuitSwitchClosed", [["path", { "d": "M2 12h2", "key": "svg-0" }], ["path", { "d": "M20 12h2", "key": "svg-1" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M8 12h8", "key": "svg-4" }]]);

var IconCircuitSwitchOpen = createVueComponent("outline", "circuit-switch-open", "CircuitSwitchOpen", [["path", { "d": "M2 12h2", "key": "svg-0" }], ["path", { "d": "M20 12h2", "key": "svg-1" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M7.5 10.5l7.5 -5.5", "key": "svg-4" }]]);

var IconCircuitVoltmeter = createVueComponent("outline", "circuit-voltmeter", "CircuitVoltmeter", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 12h-3", "key": "svg-1" }], ["path", { "d": "M19 12h3", "key": "svg-2" }], ["path", { "d": "M10 10l2 4l2 -4", "key": "svg-3" }]]);

var IconClearAll = createVueComponent("outline", "clear-all", "ClearAll", [["path", { "d": "M8 6h12", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M4 18h12", "key": "svg-2" }]]);

var IconClearFormatting = createVueComponent("outline", "clear-formatting", "ClearFormatting", [["path", { "d": "M17 15l4 4m0 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M7 6v-1h11v1", "key": "svg-1" }], ["path", { "d": "M7 19l4 0", "key": "svg-2" }], ["path", { "d": "M13 5l-4 14", "key": "svg-3" }]]);

var IconClick = createVueComponent("outline", "click", "Click", [["path", { "d": "M3 12l3 0", "key": "svg-0" }], ["path", { "d": "M12 3l0 3", "key": "svg-1" }], ["path", { "d": "M7.8 7.8l-2.2 -2.2", "key": "svg-2" }], ["path", { "d": "M16.2 7.8l2.2 -2.2", "key": "svg-3" }], ["path", { "d": "M7.8 16.2l-2.2 2.2", "key": "svg-4" }], ["path", { "d": "M12 12l9 3l-4 2l-2 4l-3 -9", "key": "svg-5" }]]);

var IconCliffJumping = createVueComponent("outline", "cliff-jumping", "CliffJumping", [["path", { "d": "M14 7a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M10.5 18l2.5 2l2 -2", "key": "svg-1" }], ["path", { "d": "M18 21l3 -3l-4 -2l-1 -5", "key": "svg-2" }], ["path", { "d": "M10.5 7.5l2 3l3.5 .5l3 -2l.5 -3", "key": "svg-3" }], ["path", { "d": "M4 21v-1l2 -3l.5 -2.5l1.5 -2.5l-1 -5l1 -3l-1 -1l-2 .5l-2 -.5", "key": "svg-4" }]]);

var IconClipboardCheck = createVueComponent("outline", "clipboard-check", "ClipboardCheck", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 14l2 2l4 -4", "key": "svg-2" }]]);

var IconClipboardCopy = createVueComponent("outline", "clipboard-copy", "ClipboardCopy", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h3m9 -9v-5a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M13 17v-1a1 1 0 0 1 1 -1h1m3 0h1a1 1 0 0 1 1 1v1m0 3v1a1 1 0 0 1 -1 1h-1m-3 0h-1a1 1 0 0 1 -1 -1v-1", "key": "svg-1" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-2" }]]);

var IconClipboardData = createVueComponent("outline", "clipboard-data", "ClipboardData", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 17v-4", "key": "svg-2" }], ["path", { "d": "M12 17v-1", "key": "svg-3" }], ["path", { "d": "M15 17v-2", "key": "svg-4" }], ["path", { "d": "M12 17v-1", "key": "svg-5" }]]);

var IconClipboardHeart = createVueComponent("outline", "clipboard-heart", "ClipboardHeart", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M11.993 16.75l2.747 -2.815a1.9 1.9 0 0 0 0 -2.632a1.775 1.775 0 0 0 -2.56 0l-.183 .188l-.183 -.189a1.775 1.775 0 0 0 -2.56 0a1.899 1.899 0 0 0 0 2.632l2.738 2.825z", "key": "svg-2" }]]);

var IconClipboardList = createVueComponent("outline", "clipboard-list", "ClipboardList", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 12l.01 0", "key": "svg-2" }], ["path", { "d": "M13 12l2 0", "key": "svg-3" }], ["path", { "d": "M9 16l.01 0", "key": "svg-4" }], ["path", { "d": "M13 16l2 0", "key": "svg-5" }]]);

var IconClipboardOff = createVueComponent("outline", "clipboard-off", "ClipboardOff", [["path", { "d": "M5.575 5.597a2 2 0 0 0 -.575 1.403v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2m0 -4v-8a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 5a2 2 0 0 1 2 -2h2a2 2 0 1 1 0 4h-2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconClipboardPlus = createVueComponent("outline", "clipboard-plus", "ClipboardPlus", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M12 12v4", "key": "svg-3" }]]);

var IconClipboardSearch = createVueComponent("outline", "clipboard-search", "ClipboardSearch", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h4.5m7.5 -10v-4a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 5a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconClipboardSmile = createVueComponent("outline", "clipboard-smile", "ClipboardSmile", [["path", { "d": "M10 13h.01", "key": "svg-0" }], ["path", { "d": "M14 13h.01", "key": "svg-1" }], ["path", { "d": "M10 16a3.5 3.5 0 0 0 4 0", "key": "svg-2" }], ["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-3" }], ["path", { "d": "M9 5a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-4" }]]);

var IconClipboardText = createVueComponent("outline", "clipboard-text", "ClipboardText", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M9 16h6", "key": "svg-3" }]]);

var IconClipboardTypography = createVueComponent("outline", "clipboard-typography", "ClipboardTypography", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 12v-1h6v1", "key": "svg-2" }], ["path", { "d": "M12 11v6", "key": "svg-3" }], ["path", { "d": "M11 17h2", "key": "svg-4" }]]);

var IconClipboardX = createVueComponent("outline", "clipboard-x", "ClipboardX", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M10 12l4 4m0 -4l-4 4", "key": "svg-2" }]]);

var IconClipboard = createVueComponent("outline", "clipboard", "Clipboard", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }]]);

var IconClock12 = createVueComponent("outline", "clock-12", "Clock12", [["path", { "d": "M3 12a9 9 0 0 0 9 9m9 -9a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5l.5 .5", "key": "svg-1" }], ["path", { "d": "M18 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-2" }], ["path", { "d": "M15 21v-6", "key": "svg-3" }]]);

var IconClock2 = createVueComponent("outline", "clock-2", "Clock2", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M4 12h1", "key": "svg-2" }], ["path", { "d": "M19 12h1", "key": "svg-3" }], ["path", { "d": "M12 19v1", "key": "svg-4" }]]);

var IconClock24 = createVueComponent("outline", "clock-24", "Clock24", [["path", { "d": "M3 12a9 9 0 0 0 5.998 8.485m12.002 -8.485a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5", "key": "svg-1" }], ["path", { "d": "M12 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-2" }], ["path", { "d": "M18 15v2a1 1 0 0 0 1 1h1", "key": "svg-3" }], ["path", { "d": "M21 15v6", "key": "svg-4" }]]);

var IconClockBitcoin = createVueComponent("outline", "clock-bitcoin", "ClockBitcoin", [["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-0" }], ["path", { "d": "M20.866 10.45a9 9 0 1 0 -7.815 10.488", "key": "svg-1" }], ["path", { "d": "M12 7v5l1.5 1.5", "key": "svg-2" }]]);

var IconClockBolt = createVueComponent("outline", "clock-bolt", "ClockBolt", [["path", { "d": "M20.984 12.53a9 9 0 1 0 -7.552 8.355", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconClockCancel = createVueComponent("outline", "clock-cancel", "ClockCancel", [["path", { "d": "M20.997 12.25a9 9 0 1 0 -8.718 8.745", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-3" }]]);

var IconClockCheck = createVueComponent("outline", "clock-check", "ClockCheck", [["path", { "d": "M20.942 13.021a9 9 0 1 0 -9.407 7.967", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconClockCode = createVueComponent("outline", "clock-code", "ClockCode", [["path", { "d": "M20.931 13.111a9 9 0 1 0 -9.453 7.874", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-3" }]]);

var IconClockCog = createVueComponent("outline", "clock-cog", "ClockCog", [["path", { "d": "M21 12a9 9 0 1 0 -9.002 9", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-8" }]]);

var IconClockDollar = createVueComponent("outline", "clock-dollar", "ClockDollar", [["path", { "d": "M20.866 10.45a9 9 0 1 0 -7.815 10.488", "key": "svg-0" }], ["path", { "d": "M12 7v5l1.5 1.5", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconClockDown = createVueComponent("outline", "clock-down", "ClockDown", [["path", { "d": "M20.984 12.535a9 9 0 1 0 -8.431 8.448", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconClockEdit = createVueComponent("outline", "clock-edit", "ClockEdit", [["path", { "d": "M21 12a9 9 0 1 0 -9.972 8.948c.32 .034 .644 .052 .972 .052", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-2" }]]);

var IconClockExclamation = createVueComponent("outline", "clock-exclamation", "ClockExclamation", [["path", { "d": "M20.986 12.502a9 9 0 1 0 -5.973 7.98", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconClockHeart = createVueComponent("outline", "clock-heart", "ClockHeart", [["path", { "d": "M20.956 11.107a9 9 0 1 0 -9.579 9.871", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }], ["path", { "d": "M12 7v5l.5 .5", "key": "svg-2" }]]);

var IconClockHour1 = createVueComponent("outline", "clock-hour-1", "ClockHour1", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5", "key": "svg-1" }], ["path", { "d": "M12 12l2 -3", "key": "svg-2" }]]);

var IconClockHour10 = createVueComponent("outline", "clock-hour-10", "ClockHour10", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-3 -2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour11 = createVueComponent("outline", "clock-hour-11", "ClockHour11", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-2 -3", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour12 = createVueComponent("outline", "clock-hour-12", "ClockHour12", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5", "key": "svg-1" }]]);

var IconClockHour2 = createVueComponent("outline", "clock-hour-2", "ClockHour2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l3 -2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour3 = createVueComponent("outline", "clock-hour-3", "ClockHour3", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12h3.5", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour4 = createVueComponent("outline", "clock-hour-4", "ClockHour4", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l3 2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour5 = createVueComponent("outline", "clock-hour-5", "ClockHour5", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l2 3", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour6 = createVueComponent("outline", "clock-hour-6", "ClockHour6", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12v3.5", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour7 = createVueComponent("outline", "clock-hour-7", "ClockHour7", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-2 3", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour8 = createVueComponent("outline", "clock-hour-8", "ClockHour8", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-3 2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour9 = createVueComponent("outline", "clock-hour-9", "ClockHour9", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12h-3.5", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockMinus = createVueComponent("outline", "clock-minus", "ClockMinus", [["path", { "d": "M20.477 15.022a9 9 0 1 0 -7.998 5.965", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconClockOff = createVueComponent("outline", "clock-off", "ClockOff", [["path", { "d": "M5.633 5.64a9 9 0 1 0 12.735 12.72m1.674 -2.32a9 9 0 0 0 -12.082 -12.082", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconClockPause = createVueComponent("outline", "clock-pause", "ClockPause", [["path", { "d": "M20.942 13.018a9 9 0 1 0 -7.909 7.922", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconClockPin = createVueComponent("outline", "clock-pin", "ClockPin", [["path", { "d": "M20.971 11.278a9 9 0 1 0 -8.313 9.698", "key": "svg-0" }], ["path", { "d": "M12 7v5l1.5 1.5", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconClockPlay = createVueComponent("outline", "clock-play", "ClockPlay", [["path", { "d": "M12 7v5l2 2", "key": "svg-0" }], ["path", { "d": "M17 22l5 -3l-5 -3z", "key": "svg-1" }], ["path", { "d": "M13.017 20.943a9 9 0 1 1 7.831 -7.292", "key": "svg-2" }]]);

var IconClockPlus = createVueComponent("outline", "clock-plus", "ClockPlus", [["path", { "d": "M20.984 12.535a9 9 0 1 0 -8.468 8.45", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-3" }]]);

var IconClockQuestion = createVueComponent("outline", "clock-question", "ClockQuestion", [["path", { "d": "M20.975 11.33a9 9 0 1 0 -5.717 9.06", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconClockRecord = createVueComponent("outline", "clock-record", "ClockRecord", [["path", { "d": "M21 12.3a9 9 0 1 0 -8.683 8.694", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }]]);

var IconClockSearch = createVueComponent("outline", "clock-search", "ClockSearch", [["path", { "d": "M20.993 11.646a9 9 0 1 0 -9.318 9.348", "key": "svg-0" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconClockShare = createVueComponent("outline", "clock-share", "ClockShare", [["path", { "d": "M20.943 13.016a9 9 0 1 0 -8.915 7.984", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-3" }]]);

var IconClockShield = createVueComponent("outline", "clock-shield", "ClockShield", [["path", { "d": "M21 12a9 9 0 1 0 -8.98 9", "key": "svg-0" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-1" }], ["path", { "d": "M22 16c0 4 -2.5 6 -3.5 6s-3.5 -2 -3.5 -6c1 0 2.5 -.5 3.5 -1.5c1 1 2.5 1.5 3.5 1.5z", "key": "svg-2" }]]);

var IconClockStar = createVueComponent("outline", "clock-star", "ClockStar", [["path", { "d": "M20.982 11.436a9 9 0 1 0 -9.966 9.51", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-2" }]]);

var IconClockStop = createVueComponent("outline", "clock-stop", "ClockStop", [["path", { "d": "M21 12a9 9 0 1 0 -9 9", "key": "svg-0" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-1" }], ["path", { "d": "M16 16h6v6h-6z", "key": "svg-2" }]]);

var IconClockUp = createVueComponent("outline", "clock-up", "ClockUp", [["path", { "d": "M20.983 12.548a9 9 0 1 0 -8.45 8.436", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M12 7v5l2.5 2.5", "key": "svg-3" }]]);

var IconClockX = createVueComponent("outline", "clock-x", "ClockX", [["path", { "d": "M20.926 13.15a9 9 0 1 0 -7.835 7.784", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconClock = createVueComponent("outline", "clock", "Clock", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }]]);

var IconClothesRackOff = createVueComponent("outline", "clothes-rack-off", "ClothesRackOff", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 7v1m0 4v9", "key": "svg-1" }], ["path", { "d": "M9 21h6", "key": "svg-2" }], ["path", { "d": "M7.757 9.243a6 6 0 0 0 3.129 1.653m3.578 -.424a6 6 0 0 0 1.779 -1.229", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconClothesRack = createVueComponent("outline", "clothes-rack", "ClothesRack", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 7v14", "key": "svg-1" }], ["path", { "d": "M9 21h6", "key": "svg-2" }], ["path", { "d": "M7.757 9.243a6 6 0 0 0 8.486 0", "key": "svg-3" }]]);

var IconCloudBitcoin = createVueComponent("outline", "cloud-bitcoin", "CloudBitcoin", [["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-0" }], ["path", { "d": "M13.5 18.004h-6.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487s2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.28 1.023 1.957 2.51 1.873 4.027", "key": "svg-1" }]]);

var IconCloudBolt = createVueComponent("outline", "cloud-bolt", "CloudBolt", [["path", { "d": "M13 18.004h-6.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.396 0 2.6 .831 3.148 2.03", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }]]);

var IconCloudCancel = createVueComponent("outline", "cloud-cancel", "CloudCancel", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99a3.45 3.45 0 0 1 2.756 1.373", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }]]);

var IconCloudCheck = createVueComponent("outline", "cloud-check", "CloudCheck", [["path", { "d": "M11 18.004h-4.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.388 0 2.585 .82 3.138 2.007", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }]]);

var IconCloudCode = createVueComponent("outline", "cloud-code", "CloudCode", [["path", { "d": "M11 18.004h-4.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99a3.468 3.468 0 0 1 3.307 2.444", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }]]);

var IconCloudCog = createVueComponent("outline", "cloud-cog", "CloudCog", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c.956 0 1.822 .39 2.449 1.02", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }]]);

var IconCloudComputing = createVueComponent("outline", "cloud-computing", "CloudComputing", [["path", { "d": "M6.657 16c-2.572 0 -4.657 -2.007 -4.657 -4.483c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-11.878", "key": "svg-0" }], ["path", { "d": "M12 16v5", "key": "svg-1" }], ["path", { "d": "M16 16v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M8 16v4a1 1 0 0 1 -1 1h-4", "key": "svg-3" }]]);

var IconCloudDataConnection = createVueComponent("outline", "cloud-data-connection", "CloudDataConnection", [["path", { "d": "M5 9.897c0 -1.714 1.46 -3.104 3.26 -3.104c.275 -1.22 1.255 -2.215 2.572 -2.611c1.317 -.397 2.77 -.134 3.811 .69c1.042 .822 1.514 2.08 1.239 3.3h.693a2.42 2.42 0 0 1 2.425 2.414a2.42 2.42 0 0 1 -2.425 2.414h-8.315c-1.8 0 -3.26 -1.39 -3.26 -3.103z", "key": "svg-0" }], ["path", { "d": "M12 13v3", "key": "svg-1" }], ["path", { "d": "M12 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M14 18h7", "key": "svg-3" }], ["path", { "d": "M3 18h7", "key": "svg-4" }]]);

var IconCloudDollar = createVueComponent("outline", "cloud-dollar", "CloudDollar", [["path", { "d": "M13.5 18.004h-6.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.28 1.023 1.957 2.51 1.873 4.027", "key": "svg-0" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-1" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-2" }]]);

var IconCloudDown = createVueComponent("outline", "cloud-down", "CloudDown", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.38 0 2.573 .813 3.13 1.99", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }]]);

var IconCloudDownload = createVueComponent("outline", "cloud-download", "CloudDownload", [["path", { "d": "M19 18a3.5 3.5 0 0 0 0 -7h-1a5 4.5 0 0 0 -11 -2a4.6 4.4 0 0 0 -2.1 8.4", "key": "svg-0" }], ["path", { "d": "M12 13l0 9", "key": "svg-1" }], ["path", { "d": "M9 19l3 3l3 -3", "key": "svg-2" }]]);

var IconCloudExclamation = createVueComponent("outline", "cloud-exclamation", "CloudExclamation", [["path", { "d": "M15 18.004h-8.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.374 0 2.562 .805 3.121 1.972", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconCloudFog = createVueComponent("outline", "cloud-fog", "CloudFog", [["path", { "d": "M7 16a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-12", "key": "svg-0" }], ["path", { "d": "M5 20l14 0", "key": "svg-1" }]]);

var IconCloudHeart = createVueComponent("outline", "cloud-heart", "CloudHeart", [["path", { "d": "M10 18.004h-3.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }]]);

var IconCloudLockOpen = createVueComponent("outline", "cloud-lock-open", "CloudLockOpen", [["path", { "d": "M19 18a3.5 3.5 0 0 0 0 -7h-1c.397 -1.768 -.285 -3.593 -1.788 -4.787c-1.503 -1.193 -3.6 -1.575 -5.5 -1s-3.315 2.019 -3.712 3.787c-2.199 -.088 -4.155 1.326 -4.666 3.373c-.512 2.047 .564 4.154 2.566 5.027", "key": "svg-0" }], ["path", { "d": "M8 15m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M10 15v-2a2 2 0 0 1 3.736 -1", "key": "svg-2" }]]);

var IconCloudLock = createVueComponent("outline", "cloud-lock", "CloudLock", [["path", { "d": "M19 18a3.5 3.5 0 0 0 0 -7h-1c.397 -1.768 -.285 -3.593 -1.788 -4.787c-1.503 -1.193 -3.6 -1.575 -5.5 -1s-3.315 2.019 -3.712 3.787c-2.199 -.088 -4.155 1.326 -4.666 3.373c-.512 2.047 .564 4.154 2.566 5.027", "key": "svg-0" }], ["path", { "d": "M8 15m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M10 15v-2a2 2 0 1 1 4 0v2", "key": "svg-2" }]]);

var IconCloudMinus = createVueComponent("outline", "cloud-minus", "CloudMinus", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 .186 -.015 .37 -.042 .548", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconCloudNetwork = createVueComponent("outline", "cloud-network", "CloudNetwork", [["path", { "d": "M3 20h7", "key": "svg-0" }], ["path", { "d": "M14 20h7", "key": "svg-1" }], ["path", { "d": "M10 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-2" }], ["path", { "d": "M12 16v2", "key": "svg-3" }], ["path", { "d": "M8 16.004h-1.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-2.535", "key": "svg-4" }]]);

var IconCloudOff = createVueComponent("outline", "cloud-off", "CloudOff", [["path", { "d": "M9.58 5.548c.24 -.11 .492 -.207 .752 -.286c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 .957 -.383 1.824 -1.003 2.454m-2.997 1.033h-11.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.13 -.582 .37 -1.128 .7 -1.62", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCloudPause = createVueComponent("outline", "cloud-pause", "CloudPause", [["path", { "d": "M13 18.004h-6.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.406 0 2.617 .843 3.16 2.055", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }]]);

var IconCloudPin = createVueComponent("outline", "cloud-pin", "CloudPin", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }]]);

var IconCloudPlus = createVueComponent("outline", "cloud-plus", "CloudPlus", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99a3.46 3.46 0 0 1 3.085 1.9", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconCloudQuestion = createVueComponent("outline", "cloud-question", "CloudQuestion", [["path", { "d": "M14.5 18.004h-7.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconCloudRain = createVueComponent("outline", "cloud-rain", "CloudRain", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7", "key": "svg-0" }], ["path", { "d": "M11 13v2m0 3v2m4 -5v2m0 3v2", "key": "svg-1" }]]);

var IconCloudSearch = createVueComponent("outline", "cloud-search", "CloudSearch", [["path", { "d": "M11 18.004h-4.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }]]);

var IconCloudShare = createVueComponent("outline", "cloud-share", "CloudShare", [["path", { "d": "M12.5 18.004h-5.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.41 0 2.624 .848 3.164 2.065", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }]]);

var IconCloudSnow = createVueComponent("outline", "cloud-snow", "CloudSnow", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7", "key": "svg-0" }], ["path", { "d": "M11 15v.01m0 3v.01m0 3v.01m4 -4v.01m0 3v.01", "key": "svg-1" }]]);

var IconCloudStar = createVueComponent("outline", "cloud-star", "CloudStar", [["path", { "d": "M9.5 18.004h-2.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.209 .967 1.88 2.347 1.88 3.776", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }]]);

var IconCloudStorm = createVueComponent("outline", "cloud-storm", "CloudStorm", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-1", "key": "svg-0" }], ["path", { "d": "M13 14l-2 4l3 0l-2 4", "key": "svg-1" }]]);

var IconCloudUp = createVueComponent("outline", "cloud-up", "CloudUp", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.38 0 2.57 .811 3.128 1.986", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }]]);

var IconCloudUpload = createVueComponent("outline", "cloud-upload", "CloudUpload", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-1", "key": "svg-0" }], ["path", { "d": "M9 15l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M12 12l0 9", "key": "svg-2" }]]);

var IconCloudX = createVueComponent("outline", "cloud-x", "CloudX", [["path", { "d": "M13 18.004h-6.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.37 0 2.556 .8 3.117 1.964", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconCloud = createVueComponent("outline", "cloud", "Cloud", [["path", { "d": "M6.657 18c-2.572 0 -4.657 -2.007 -4.657 -4.483c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-11.878", "key": "svg-0" }]]);

var IconClover2 = createVueComponent("outline", "clover-2", "Clover2", [["path", { "d": "M11 11l-3.397 -3.44a2.104 2.104 0 0 1 0 -2.95a2.04 2.04 0 0 1 2.912 0l.485 .39l.485 -.39a2.04 2.04 0 0 1 2.912 0a2.104 2.104 0 0 1 0 2.95l-3.397 3.44z", "key": "svg-0" }], ["path", { "d": "M11 11l-3.397 3.44a2.104 2.104 0 0 0 0 2.95a2.04 2.04 0 0 0 2.912 0l.485 -.39l.485 .39a2.04 2.04 0 0 0 2.912 0a2.104 2.104 0 0 0 0 -2.95l-3.397 -3.44z", "key": "svg-1" }], ["path", { "d": "M14.44 7.603a2.104 2.104 0 0 1 2.95 0a2.04 2.04 0 0 1 0 2.912l-.39 .485l.39 .485a2.04 2.04 0 0 1 0 2.912a2.104 2.104 0 0 1 -2.95 0", "key": "svg-2" }], ["path", { "d": "M7.56 7.603a2.104 2.104 0 0 0 -2.95 0a2.04 2.04 0 0 0 0 2.912l.39 .485l-.39 .485a2.04 2.04 0 0 0 0 2.912a2.104 2.104 0 0 0 2.95 0", "key": "svg-3" }], ["path", { "d": "M15 15l6 6", "key": "svg-4" }]]);

var IconClover = createVueComponent("outline", "clover", "Clover", [["path", { "d": "M12 10l-3.397 -3.44a2.104 2.104 0 0 1 0 -2.95a2.04 2.04 0 0 1 2.912 0l.485 .39l.485 -.39a2.04 2.04 0 0 1 2.912 0a2.104 2.104 0 0 1 0 2.95l-3.397 3.44z", "key": "svg-0" }], ["path", { "d": "M12 14l-3.397 3.44a2.104 2.104 0 0 0 0 2.95a2.04 2.04 0 0 0 2.912 0l.485 -.39l.485 .39a2.04 2.04 0 0 0 2.912 0a2.104 2.104 0 0 0 0 -2.95l-3.397 -3.44z", "key": "svg-1" }], ["path", { "d": "M14 12l3.44 -3.397a2.104 2.104 0 0 1 2.95 0a2.04 2.04 0 0 1 0 2.912l-.39 .485l.39 .485a2.04 2.04 0 0 1 0 2.912a2.104 2.104 0 0 1 -2.95 0l-3.44 -3.397z", "key": "svg-2" }], ["path", { "d": "M10 12l-3.44 -3.397a2.104 2.104 0 0 0 -2.95 0a2.04 2.04 0 0 0 0 2.912l.39 .485l-.39 .485a2.04 2.04 0 0 0 0 2.912a2.104 2.104 0 0 0 2.95 0l3.44 -3.397z", "key": "svg-3" }]]);

var IconClubs = createVueComponent("outline", "clubs", "Clubs", [["path", { "d": "M12 3a4 4 0 0 1 3.164 6.447a4 4 0 1 1 -1.164 6.198v1.355l1 4h-6l1 -4l0 -1.355a4 4 0 1 1 -1.164 -6.199a4 4 0 0 1 3.163 -6.446z", "key": "svg-0" }]]);

var IconCodeAsterisk = createVueComponent("outline", "code-asterisk", "CodeAsterisk", [["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M12 11.875l3 -1.687", "key": "svg-1" }], ["path", { "d": "M12 11.875v3.375", "key": "svg-2" }], ["path", { "d": "M12 11.875l-3 -1.687", "key": "svg-3" }], ["path", { "d": "M12 11.875l3 1.688", "key": "svg-4" }], ["path", { "d": "M12 8.5v3.375", "key": "svg-5" }], ["path", { "d": "M12 11.875l-3 1.688", "key": "svg-6" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-7" }]]);

var IconCodeCircle2 = createVueComponent("outline", "code-circle-2", "CodeCircle2", [["path", { "d": "M8.5 13.5l-1.5 -1.5l1.5 -1.5", "key": "svg-0" }], ["path", { "d": "M15.5 10.5l1.5 1.5l-1.5 1.5", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }], ["path", { "d": "M13 9.5l-2 5.5", "key": "svg-3" }]]);

var IconCodeCircle = createVueComponent("outline", "code-circle", "CodeCircle", [["path", { "d": "M10 14l-2 -2l2 -2", "key": "svg-0" }], ["path", { "d": "M14 10l2 2l-2 2", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconCodeDots = createVueComponent("outline", "code-dots", "CodeDots", [["path", { "d": "M15 12h.01", "key": "svg-0" }], ["path", { "d": "M12 12h.01", "key": "svg-1" }], ["path", { "d": "M9 12h.01", "key": "svg-2" }], ["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-3" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-4" }]]);

var IconCodeMinus = createVueComponent("outline", "code-minus", "CodeMinus", [["path", { "d": "M9 12h6", "key": "svg-0" }], ["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-1" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-2" }]]);

var IconCodeOff = createVueComponent("outline", "code-off", "CodeOff", [["path", { "d": "M7 8l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M17 8l4 4l-2.5 2.5", "key": "svg-1" }], ["path", { "d": "M14 4l-1.201 4.805m-.802 3.207l-2 7.988", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCodePlus = createVueComponent("outline", "code-plus", "CodePlus", [["path", { "d": "M9 12h6", "key": "svg-0" }], ["path", { "d": "M12 9v6", "key": "svg-1" }], ["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-2" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-3" }]]);

var IconCodeVariableMinus = createVueComponent("outline", "code-variable-minus", "CodeVariableMinus", [["path", { "d": "M12.5 16h-6.5a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 18h6", "key": "svg-1" }]]);

var IconCodeVariablePlus = createVueComponent("outline", "code-variable-plus", "CodeVariablePlus", [["path", { "d": "M13 16h-7a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v1", "key": "svg-0" }], ["path", { "d": "M16 18h6", "key": "svg-1" }], ["path", { "d": "M19 15v6", "key": "svg-2" }]]);

var IconCodeVariable = createVueComponent("outline", "code-variable", "CodeVariable", [["path", { "d": "M4 8m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCode = createVueComponent("outline", "code", "Code", [["path", { "d": "M7 8l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M17 8l4 4l-4 4", "key": "svg-1" }], ["path", { "d": "M14 4l-4 16", "key": "svg-2" }]]);

var IconCoffeeOff = createVueComponent("outline", "coffee-off", "CoffeeOff", [["path", { "d": "M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.73 -.565 1.783 -.923 3 -.99", "key": "svg-0" }], ["path", { "d": "M8 3c-.194 .14 -.364 .305 -.506 .49", "key": "svg-1" }], ["path", { "d": "M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2", "key": "svg-2" }], ["path", { "d": "M14 10h3v3m-.257 3.743a6 6 0 0 1 -5.743 4.257h-2a6 6 0 0 1 -6 -6v-5h7", "key": "svg-3" }], ["path", { "d": "M20.116 16.124a3 3 0 0 0 -3.118 -4.953", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCoffee = createVueComponent("outline", "coffee", "Coffee", [["path", { "d": "M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.83 -.642 2.077 -1.017 3.5 -1c1.423 -.017 2.67 .358 3.5 1", "key": "svg-0" }], ["path", { "d": "M8 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2", "key": "svg-1" }], ["path", { "d": "M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2", "key": "svg-2" }], ["path", { "d": "M3 10h14v5a6 6 0 0 1 -6 6h-2a6 6 0 0 1 -6 -6v-5z", "key": "svg-3" }], ["path", { "d": "M16.746 16.726a3 3 0 1 0 .252 -5.555", "key": "svg-4" }]]);

var IconCoffin = createVueComponent("outline", "coffin", "Coffin", [["path", { "d": "M7 3l-2 6l2 12h6l2 -12l-2 -6z", "key": "svg-0" }], ["path", { "d": "M10 7v5", "key": "svg-1" }], ["path", { "d": "M8 9h4", "key": "svg-2" }], ["path", { "d": "M13 21h4l2 -12l-2 -6h-4", "key": "svg-3" }]]);

var IconCoinBitcoin = createVueComponent("outline", "coin-bitcoin", "CoinBitcoin", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 8h4.09c1.055 0 1.91 .895 1.91 2s-.855 2 -1.91 2c1.055 0 1.91 .895 1.91 2s-.855 2 -1.91 2h-4.09", "key": "svg-1" }], ["path", { "d": "M10 12h4", "key": "svg-2" }], ["path", { "d": "M10 7v10v-9", "key": "svg-3" }], ["path", { "d": "M13 7v1", "key": "svg-4" }], ["path", { "d": "M13 16v1", "key": "svg-5" }]]);

var IconCoinEuro = createVueComponent("outline", "coin-euro", "CoinEuro", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14.401 8c-.669 -.628 -1.5 -1 -2.401 -1c-2.21 0 -4 2.239 -4 5s1.79 5 4 5c.9 0 1.731 -.372 2.4 -1", "key": "svg-1" }], ["path", { "d": "M7 10.5h4", "key": "svg-2" }], ["path", { "d": "M7 13.5h4", "key": "svg-3" }]]);

var IconCoinMonero = createVueComponent("outline", "coin-monero", "CoinMonero", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M4 16h4v-7l4 4l4 -4v7h4", "key": "svg-1" }]]);

var IconCoinOff = createVueComponent("outline", "coin-off", "CoinOff", [["path", { "d": "M14.8 9a2 2 0 0 0 -1.8 -1h-1m-2.82 1.171a2 2 0 0 0 1.82 2.829h1m2.824 2.822a2 2 0 0 1 -1.824 1.178h-2a2 2 0 0 1 -1.8 -1", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M12 6v2m0 8v2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCoinPound = createVueComponent("outline", "coin-pound", "CoinPound", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9a2 2 0 1 0 -4 0v5a2 2 0 0 1 -2 2h6", "key": "svg-1" }], ["path", { "d": "M9 12h4", "key": "svg-2" }]]);

var IconCoinRupee = createVueComponent("outline", "coin-rupee", "CoinRupee", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 8h-6h1a3 3 0 0 1 0 6h-1l3 3", "key": "svg-1" }], ["path", { "d": "M9 11h6", "key": "svg-2" }]]);

var IconCoinTaka = createVueComponent("outline", "coin-taka", "CoinTaka", [["path", { "d": "M8 8l.553 -.276a1 1 0 0 1 1.447 .894v6.382a2 2 0 0 0 2 2h.5a2.5 2.5 0 0 0 2.5 -2.5v-.5h-1", "key": "svg-0" }], ["path", { "d": "M8 11h7", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-2" }]]);

var IconCoinYen = createVueComponent("outline", "coin-yen", "CoinYen", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12h6", "key": "svg-1" }], ["path", { "d": "M9 15h6", "key": "svg-2" }], ["path", { "d": "M9 8l3 4.5", "key": "svg-3" }], ["path", { "d": "M15 8l-3 4.5v4.5", "key": "svg-4" }]]);

var IconCoinYuan = createVueComponent("outline", "coin-yuan", "CoinYuan", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 13h6", "key": "svg-1" }], ["path", { "d": "M9 8l3 4.5", "key": "svg-2" }], ["path", { "d": "M15 8l-3 4.5v4.5", "key": "svg-3" }]]);

var IconCoin = createVueComponent("outline", "coin", "Coin", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14.8 9a2 2 0 0 0 -1.8 -1h-2a2 2 0 1 0 0 4h2a2 2 0 1 1 0 4h-2a2 2 0 0 1 -1.8 -1", "key": "svg-1" }], ["path", { "d": "M12 7v10", "key": "svg-2" }]]);

var IconCoins = createVueComponent("outline", "coins", "Coins", [["path", { "d": "M9 14c0 1.657 2.686 3 6 3s6 -1.343 6 -3s-2.686 -3 -6 -3s-6 1.343 -6 3z", "key": "svg-0" }], ["path", { "d": "M9 14v4c0 1.656 2.686 3 6 3s6 -1.344 6 -3v-4", "key": "svg-1" }], ["path", { "d": "M3 6c0 1.072 1.144 2.062 3 2.598s4.144 .536 6 0c1.856 -.536 3 -1.526 3 -2.598c0 -1.072 -1.144 -2.062 -3 -2.598s-4.144 -.536 -6 0c-1.856 .536 -3 1.526 -3 2.598z", "key": "svg-2" }], ["path", { "d": "M3 6v10c0 .888 .772 1.45 2 2", "key": "svg-3" }], ["path", { "d": "M3 11c0 .888 .772 1.45 2 2", "key": "svg-4" }]]);

var IconColorFilter = createVueComponent("outline", "color-filter", "ColorFilter", [["path", { "d": "M13.58 13.79c.27 .68 .42 1.43 .42 2.21c0 1.77 -.77 3.37 -2 4.46a5.93 5.93 0 0 1 -4 1.54c-3.31 0 -6 -2.69 -6 -6c0 -2.76 1.88 -5.1 4.42 -5.79", "key": "svg-0" }], ["path", { "d": "M17.58 10.21c2.54 .69 4.42 3.03 4.42 5.79c0 3.31 -2.69 6 -6 6a5.93 5.93 0 0 1 -4 -1.54", "key": "svg-1" }], ["path", { "d": "M12 8m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-2" }]]);

var IconColorPickerOff = createVueComponent("outline", "color-picker-off", "ColorPickerOff", [["path", { "d": "M11 7l6 6", "key": "svg-0" }], ["path", { "d": "M12 8l3.699 -3.699a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-3.702 3.702m-2 2l-6 6h-4v-4l6 -6", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconColorPicker = createVueComponent("outline", "color-picker", "ColorPicker", [["path", { "d": "M11 7l6 6", "key": "svg-0" }], ["path", { "d": "M4 16l11.7 -11.7a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-11.7 11.7h-4v-4z", "key": "svg-1" }]]);

var IconColorSwatchOff = createVueComponent("outline", "color-swatch-off", "ColorSwatchOff", [["path", { "d": "M13 13v4a4 4 0 0 0 6.832 2.825m1.168 -2.825v-12a2 2 0 0 0 -2 -2h-4a2 2 0 0 0 -2 2v4", "key": "svg-0" }], ["path", { "d": "M13 7.35l-2 -2a2 2 0 0 0 -2.11 -.461m-2.13 1.874l-1.416 1.415a2 2 0 0 0 0 2.828l9 9", "key": "svg-1" }], ["path", { "d": "M7.3 13h-2.3a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h12", "key": "svg-2" }], ["path", { "d": "M17 17v.01", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconColorSwatch = createVueComponent("outline", "color-swatch", "ColorSwatch", [["path", { "d": "M19 3h-4a2 2 0 0 0 -2 2v12a4 4 0 0 0 8 0v-12a2 2 0 0 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M13 7.35l-2 -2a2 2 0 0 0 -2.828 0l-2.828 2.828a2 2 0 0 0 0 2.828l9 9", "key": "svg-1" }], ["path", { "d": "M7.3 13h-2.3a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h12", "key": "svg-2" }], ["path", { "d": "M17 17l0 .01", "key": "svg-3" }]]);

var IconColumnInsertLeft = createVueComponent("outline", "column-insert-left", "ColumnInsertLeft", [["path", { "d": "M14 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M5 12l4 0", "key": "svg-1" }], ["path", { "d": "M7 10l0 4", "key": "svg-2" }]]);

var IconColumnInsertRight = createVueComponent("outline", "column-insert-right", "ColumnInsertRight", [["path", { "d": "M6 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M15 12l4 0", "key": "svg-1" }], ["path", { "d": "M17 10l0 4", "key": "svg-2" }]]);

var IconColumnRemove = createVueComponent("outline", "column-remove", "ColumnRemove", [["path", { "d": "M6 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M16 10l4 4", "key": "svg-1" }], ["path", { "d": "M16 14l4 -4", "key": "svg-2" }]]);

var IconColumns1 = createVueComponent("outline", "columns-1", "Columns1", [["path", { "d": "M5 3m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }]]);

var IconColumns2 = createVueComponent("outline", "columns-2", "Columns2", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1zm9 -1v18", "key": "svg-0" }]]);

var IconColumns3 = createVueComponent("outline", "columns-3", "Columns3", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1zm6 -1v18m6 -18v18", "key": "svg-0" }]]);

var IconColumnsOff = createVueComponent("outline", "columns-off", "ColumnsOff", [["path", { "d": "M4 6h2", "key": "svg-0" }], ["path", { "d": "M4 10h5.5", "key": "svg-1" }], ["path", { "d": "M4 14h5.5", "key": "svg-2" }], ["path", { "d": "M4 18h5.5", "key": "svg-3" }], ["path", { "d": "M14.5 6h5.5", "key": "svg-4" }], ["path", { "d": "M14.5 10h5.5", "key": "svg-5" }], ["path", { "d": "M18 14h2", "key": "svg-6" }], ["path", { "d": "M14.5 18h3.5", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconColumns = createVueComponent("outline", "columns", "Columns", [["path", { "d": "M4 6l5.5 0", "key": "svg-0" }], ["path", { "d": "M4 10l5.5 0", "key": "svg-1" }], ["path", { "d": "M4 14l5.5 0", "key": "svg-2" }], ["path", { "d": "M4 18l5.5 0", "key": "svg-3" }], ["path", { "d": "M14.5 6l5.5 0", "key": "svg-4" }], ["path", { "d": "M14.5 10l5.5 0", "key": "svg-5" }], ["path", { "d": "M14.5 14l5.5 0", "key": "svg-6" }], ["path", { "d": "M14.5 18l5.5 0", "key": "svg-7" }]]);

var IconComet = createVueComponent("outline", "comet", "Comet", [["path", { "d": "M15.5 18.5l-3 1.5l.5 -3.5l-2 -2l3 -.5l1.5 -3l1.5 3l3 .5l-2 2l.5 3.5z", "key": "svg-0" }], ["path", { "d": "M4 4l7 7", "key": "svg-1" }], ["path", { "d": "M9 4l3.5 3.5", "key": "svg-2" }], ["path", { "d": "M4 9l3.5 3.5", "key": "svg-3" }]]);

var IconCommandOff = createVueComponent("outline", "command-off", "CommandOff", [["path", { "d": "M9 9v8a2 2 0 1 1 -2 -2h8m3.411 3.417a2 2 0 0 1 -3.411 -1.417v-2m0 -4v-4a2 2 0 1 1 2 2h-4m-4 0h-2a2 2 0 0 1 -1.417 -3.411", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCommand = createVueComponent("outline", "command", "Command", [["path", { "d": "M7 9a2 2 0 1 1 2 -2v10a2 2 0 1 1 -2 -2h10a2 2 0 1 1 -2 2v-10a2 2 0 1 1 2 2h-10", "key": "svg-0" }]]);

var IconCompassOff = createVueComponent("outline", "compass-off", "CompassOff", [["path", { "d": "M13 9l3 -1l-1 3m-1 3l-6 2l2 -6", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M12 3v2", "key": "svg-2" }], ["path", { "d": "M12 19v2", "key": "svg-3" }], ["path", { "d": "M3 12h2", "key": "svg-4" }], ["path", { "d": "M19 12h2", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconCompass = createVueComponent("outline", "compass", "Compass", [["path", { "d": "M8 16l2 -6l6 -2l-2 6l-6 2", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }], ["path", { "d": "M12 3l0 2", "key": "svg-2" }], ["path", { "d": "M12 19l0 2", "key": "svg-3" }], ["path", { "d": "M3 12l2 0", "key": "svg-4" }], ["path", { "d": "M19 12l2 0", "key": "svg-5" }]]);

var IconComponentsOff = createVueComponent("outline", "components-off", "ComponentsOff", [["path", { "d": "M3 12l3 3l3 -3l-3 -3z", "key": "svg-0" }], ["path", { "d": "M18.5 14.5l2.5 -2.5l-3 -3l-2.5 2.5", "key": "svg-1" }], ["path", { "d": "M12.499 8.501l2.501 -2.501l-3 -3l-2.5 2.5", "key": "svg-2" }], ["path", { "d": "M9 18l3 3l3 -3l-3 -3z", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconComponents = createVueComponent("outline", "components", "Components", [["path", { "d": "M3 12l3 3l3 -3l-3 -3z", "key": "svg-0" }], ["path", { "d": "M15 12l3 3l3 -3l-3 -3z", "key": "svg-1" }], ["path", { "d": "M9 6l3 3l3 -3l-3 -3z", "key": "svg-2" }], ["path", { "d": "M9 18l3 3l3 -3l-3 -3z", "key": "svg-3" }]]);

var IconCone2 = createVueComponent("outline", "cone-2", "Cone2", [["path", { "d": "M21 5.002v.5l-8.13 14.99a1 1 0 0 1 -1.74 0l-8.13 -14.989v-.5c0 -1.659 4.03 -3.003 9 -3.003s9 1.344 9 3.002", "key": "svg-0" }]]);

var IconConeOff = createVueComponent("outline", "cone-off", "ConeOff", [["path", { "d": "M20.396 16.384l-7.526 -13.877a1 1 0 0 0 -1.74 0l-1.626 2.998m-1.407 2.594l-5.097 9.398v.5c0 1.66 4.03 3.003 9 3.003c3.202 0 6.014 -.558 7.609 -1.398", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconConePlus = createVueComponent("outline", "cone-plus", "ConePlus", [["path", { "d": "M18.03 12.022l-5.16 -9.515a1 1 0 0 0 -1.74 0l-8.13 14.99v.5c0 1.66 4.03 3.003 9 3.003c.17 0 .34 -.002 .508 -.005", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconCone = createVueComponent("outline", "cone", "Cone", [["path", { "d": "M21 17.998v-.5l-8.13 -14.99a1 1 0 0 0 -1.74 0l-8.13 14.989v.5c0 1.659 4.03 3.003 9 3.003s9 -1.344 9 -3.002", "key": "svg-0" }]]);

var IconConfettiOff = createVueComponent("outline", "confetti-off", "ConfettiOff", [["path", { "d": "M4 5h1", "key": "svg-0" }], ["path", { "d": "M5 5v1", "key": "svg-1" }], ["path", { "d": "M11.5 4l-.5 2", "key": "svg-2" }], ["path", { "d": "M18 5h2", "key": "svg-3" }], ["path", { "d": "M19 4v2", "key": "svg-4" }], ["path", { "d": "M15 9l-1 1", "key": "svg-5" }], ["path", { "d": "M18 13l2 -.5", "key": "svg-6" }], ["path", { "d": "M18 19h1", "key": "svg-7" }], ["path", { "d": "M19 19v1", "key": "svg-8" }], ["path", { "d": "M14 16.518l-6.518 -6.518l-4.39 9.58a1 1 0 0 0 1.329 1.329l9.579 -4.39v0z", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconConfetti = createVueComponent("outline", "confetti", "Confetti", [["path", { "d": "M4 5h2", "key": "svg-0" }], ["path", { "d": "M5 4v2", "key": "svg-1" }], ["path", { "d": "M11.5 4l-.5 2", "key": "svg-2" }], ["path", { "d": "M18 5h2", "key": "svg-3" }], ["path", { "d": "M19 4v2", "key": "svg-4" }], ["path", { "d": "M15 9l-1 1", "key": "svg-5" }], ["path", { "d": "M18 13l2 -.5", "key": "svg-6" }], ["path", { "d": "M18 19h2", "key": "svg-7" }], ["path", { "d": "M19 18v2", "key": "svg-8" }], ["path", { "d": "M14 16.518l-6.518 -6.518l-4.39 9.58a1 1 0 0 0 1.329 1.329l9.579 -4.39z", "key": "svg-9" }]]);

var IconConfucius = createVueComponent("outline", "confucius", "Confucius", [["path", { "d": "M9 19l3 2v-18", "key": "svg-0" }], ["path", { "d": "M4 10l8 -2", "key": "svg-1" }], ["path", { "d": "M4 18l8 -10", "key": "svg-2" }], ["path", { "d": "M20 18l-8 -8l8 -4", "key": "svg-3" }]]);

var IconCongruentTo = createVueComponent("outline", "congruent-to", "CongruentTo", [["path", { "d": "M5 13h14", "key": "svg-0" }], ["path", { "d": "M5 17h14", "key": "svg-1" }], ["path", { "d": "M5 7.686c2.333 -2.624 4.667 -1.856 7 .064s4.667 2.688 7 .064", "key": "svg-2" }]]);

var IconContainerOff = createVueComponent("outline", "container-off", "ContainerOff", [["path", { "d": "M20 4v.01", "key": "svg-0" }], ["path", { "d": "M20 20v.01", "key": "svg-1" }], ["path", { "d": "M20 16v.01", "key": "svg-2" }], ["path", { "d": "M20 12v.01", "key": "svg-3" }], ["path", { "d": "M20 8v.01", "key": "svg-4" }], ["path", { "d": "M8.297 4.289a1 1 0 0 1 .703 -.289h6a1 1 0 0 1 1 1v7m0 4v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1v-11", "key": "svg-5" }], ["path", { "d": "M4 4v.01", "key": "svg-6" }], ["path", { "d": "M4 20v.01", "key": "svg-7" }], ["path", { "d": "M4 16v.01", "key": "svg-8" }], ["path", { "d": "M4 12v.01", "key": "svg-9" }], ["path", { "d": "M4 8v.01", "key": "svg-10" }], ["path", { "d": "M3 3l18 18", "key": "svg-11" }]]);

var IconContainer = createVueComponent("outline", "container", "Container", [["path", { "d": "M20 4v.01", "key": "svg-0" }], ["path", { "d": "M20 20v.01", "key": "svg-1" }], ["path", { "d": "M20 16v.01", "key": "svg-2" }], ["path", { "d": "M20 12v.01", "key": "svg-3" }], ["path", { "d": "M20 8v.01", "key": "svg-4" }], ["path", { "d": "M8 4m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-5" }], ["path", { "d": "M4 4v.01", "key": "svg-6" }], ["path", { "d": "M4 20v.01", "key": "svg-7" }], ["path", { "d": "M4 16v.01", "key": "svg-8" }], ["path", { "d": "M4 12v.01", "key": "svg-9" }], ["path", { "d": "M4 8v.01", "key": "svg-10" }]]);

var IconContract = createVueComponent("outline", "contract", "Contract", [["path", { "d": "M8 21h-2a3 3 0 0 1 -3 -3v-1h5.5", "key": "svg-0" }], ["path", { "d": "M17 8.5v-3.5a2 2 0 1 1 2 2h-2", "key": "svg-1" }], ["path", { "d": "M19 3h-11a3 3 0 0 0 -3 3v11", "key": "svg-2" }], ["path", { "d": "M9 7h4", "key": "svg-3" }], ["path", { "d": "M9 11h4", "key": "svg-4" }], ["path", { "d": "M18.42 12.61a2.1 2.1 0 0 1 2.97 2.97l-6.39 6.42h-3v-3z", "key": "svg-5" }]]);

var IconContrast2Off = createVueComponent("outline", "contrast-2-off", "Contrast2Off", [["path", { "d": "M4 18h2a6 6 0 0 0 6 -6m.878 -3.126a6 6 0 0 1 5.122 -2.874h2", "key": "svg-0" }], ["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconContrast2 = createVueComponent("outline", "contrast-2", "Contrast2", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M3 19h2.25c3.728 0 6.75 -3.134 6.75 -7s3.022 -7 6.75 -7h2.25", "key": "svg-1" }]]);

var IconContrastOff = createVueComponent("outline", "contrast-off", "ContrastOff", [["path", { "d": "M12 12v5a4.984 4.984 0 0 0 3.522 -1.45m1.392 -2.623a5 5 0 0 0 -4.914 -5.927v1", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconContrast = createVueComponent("outline", "contrast", "Contrast", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 17a5 5 0 0 0 0 -10v10", "key": "svg-1" }]]);

var IconCooker = createVueComponent("outline", "cooker", "Cooker", [["path", { "d": "M12 7h.01", "key": "svg-0" }], ["path", { "d": "M15 7h.01", "key": "svg-1" }], ["path", { "d": "M9 7h.01", "key": "svg-2" }], ["path", { "d": "M5 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-3" }], ["path", { "d": "M9 15h6", "key": "svg-4" }], ["path", { "d": "M5 11h14", "key": "svg-5" }]]);

var IconCookieMan = createVueComponent("outline", "cookie-man", "CookieMan", [["path", { "d": "M12 2a5 5 0 0 1 2.845 9.112l.147 .369l1.755 -.803c.969 -.443 2.12 -.032 2.571 .918a1.88 1.88 0 0 1 -.787 2.447l-.148 .076l-2.383 1.089v2.02l1.426 1.425l.114 .125a1.96 1.96 0 0 1 -2.762 2.762l-.125 -.114l-2.079 -2.08l-.114 -.124a2 2 0 0 1 -.161 -.22h-.599q -.071 .114 -.16 .22l-.115 .125l-2.08 2.079a1.96 1.96 0 0 1 -2.886 -2.648l.114 -.125l1.427 -1.426v-2.019l-2.383 -1.09l-.148 -.075a1.88 1.88 0 0 1 -.787 -2.447c.429 -.902 1.489 -1.318 2.424 -.978l.147 .06l1.755 .803l.147 -.369a5 5 0 0 1 -2.15 -3.895v-.217a5 5 0 0 1 5 -5z", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }], ["path", { "d": "M12 13h.01", "key": "svg-3" }], ["path", { "d": "M10 7h.01", "key": "svg-4" }], ["path", { "d": "M14 7h.01", "key": "svg-5" }], ["path", { "d": "M12 9h.01", "key": "svg-6" }]]);

var IconCookieOff = createVueComponent("outline", "cookie-off", "CookieOff", [["path", { "d": "M8 13v.01", "key": "svg-0" }], ["path", { "d": "M12 17v.01", "key": "svg-1" }], ["path", { "d": "M12 12v.01", "key": "svg-2" }], ["path", { "d": "M18.192 18.187a3 3 0 0 1 -.976 .652c-1.048 .263 -1.787 .483 -2.216 .661c-.475 .197 -1.092 .538 -1.852 1.024a3 3 0 0 1 -2.296 0c-.802 -.503 -1.419 -.844 -1.852 -1.024c-.471 -.195 -1.21 -.415 -2.216 -.66a3 3 0 0 1 -1.623 -1.624c-.265 -1.052 -.485 -1.79 -.661 -2.216c-.198 -.479 -.54 -1.096 -1.024 -1.852a3 3 0 0 1 0 -2.296c.48 -.744 .82 -1.361 1.024 -1.852c.171 -.413 .391 -1.152 .66 -2.216a3 3 0 0 1 .649 -.971m2.821 -1.174c.14 -.049 .263 -.095 .37 -.139c.458 -.19 1.075 -.531 1.852 -1.024a3 3 0 0 1 2.296 0l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296c-.497 .786 -.838 1.404 -1.024 1.852a6.579 6.579 0 0 0 -.135 .36", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCookie = createVueComponent("outline", "cookie", "Cookie", [["path", { "d": "M8 13v.01", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M12 12v.01", "key": "svg-3" }], ["path", { "d": "M16 14v.01", "key": "svg-4" }], ["path", { "d": "M11 8v.01", "key": "svg-5" }], ["path", { "d": "M13.148 3.476l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296q -.745 1.18 -1.024 1.852q -.283 .684 -.66 2.216a3 3 0 0 1 -1.624 1.623q -1.572 .394 -2.216 .661q -.712 .295 -1.852 1.024a3 3 0 0 1 -2.296 0q -1.203 -.754 -1.852 -1.024q -.707 -.292 -2.216 -.66a3 3 0 0 1 -1.623 -1.624q -.397 -1.577 -.661 -2.216q -.298 -.718 -1.024 -1.852a3 3 0 0 1 0 -2.296q .719 -1.116 1.024 -1.852q .257 -.62 .66 -2.216a3 3 0 0 1 1.624 -1.623q 1.547 -.384 2.216 -.661q .687 -.285 1.852 -1.024a3 3 0 0 1 2.296 0", "key": "svg-6" }]]);

var IconCopyCheck = createVueComponent("outline", "copy-check", "CopyCheck", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11 14l2 2l4 -4", "key": "svg-3" }]]);

var IconCopyMinus = createVueComponent("outline", "copy-minus", "CopyMinus", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11 14h6", "key": "svg-3" }]]);

var IconCopyOff = createVueComponent("outline", "copy-off", "CopyOff", [["path", { "d": "M19.414 19.415a2 2 0 0 1 -1.414 .585h-8a2 2 0 0 1 -2 -2v-8c0 -.554 .225 -1.055 .589 -1.417m3.411 -.583h6a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 8v-2a2 2 0 0 0 -2 -2h-6m-3.418 .59c-.36 .36 -.582 .86 -.582 1.41v8a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCopyPlus = createVueComponent("outline", "copy-plus", "CopyPlus", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11 14h6", "key": "svg-3" }], ["path", { "d": "M14 11v6", "key": "svg-4" }]]);

var IconCopyX = createVueComponent("outline", "copy-x", "CopyX", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11.5 11.5l4.9 5", "key": "svg-3" }], ["path", { "d": "M16.5 11.5l-5.1 5", "key": "svg-4" }]]);

var IconCopy = createVueComponent("outline", "copy", "Copy", [["path", { "d": "M7 7m0 2.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-0" }], ["path", { "d": "M4.012 16.737a2.005 2.005 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-1" }]]);

var IconCopyleftOff = createVueComponent("outline", "copyleft-off", "CopyleftOff", [["path", { "d": "M13.303 9.3a3.01 3.01 0 0 1 1.405 1.406m-.586 3.413a3.016 3.016 0 0 1 -4.122 .131", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCopyleft = createVueComponent("outline", "copyleft", "Copyleft", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 9.75a3.016 3.016 0 0 1 4.163 .173a2.993 2.993 0 0 1 0 4.154a3.016 3.016 0 0 1 -4.163 .173", "key": "svg-1" }]]);

var IconCopyrightOff = createVueComponent("outline", "copyright-off", "CopyrightOff", [["path", { "d": "M14 9.75a3.016 3.016 0 0 0 -.711 -.466m-3.41 .596a2.993 2.993 0 0 0 -.042 4.197a3.016 3.016 0 0 0 4.163 .173", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCopyright = createVueComponent("outline", "copyright", "Copyright", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 9.75a3.016 3.016 0 0 0 -4.163 .173a2.993 2.993 0 0 0 0 4.154a3.016 3.016 0 0 0 4.163 .173", "key": "svg-1" }]]);

var IconCornerDownLeftDouble = createVueComponent("outline", "corner-down-left-double", "CornerDownLeftDouble", [["path", { "d": "M19 5v6a3 3 0 0 1 -3 3h-7", "key": "svg-0" }], ["path", { "d": "M13 10l-4 4l4 4m-5 -8l-4 4l4 4", "key": "svg-1" }]]);

var IconCornerDownLeft = createVueComponent("outline", "corner-down-left", "CornerDownLeft", [["path", { "d": "M18 6v6a3 3 0 0 1 -3 3h-10l4 -4m0 8l-4 -4", "key": "svg-0" }]]);

var IconCornerDownRightDouble = createVueComponent("outline", "corner-down-right-double", "CornerDownRightDouble", [["path", { "d": "M4 5v6a3 3 0 0 0 3 3h7", "key": "svg-0" }], ["path", { "d": "M10 10l4 4l-4 4m5 -8l4 4l-4 4", "key": "svg-1" }]]);

var IconCornerDownRight = createVueComponent("outline", "corner-down-right", "CornerDownRight", [["path", { "d": "M6 6v6a3 3 0 0 0 3 3h10l-4 -4m0 8l4 -4", "key": "svg-0" }]]);

var IconCornerLeftDownDouble = createVueComponent("outline", "corner-left-down-double", "CornerLeftDownDouble", [["path", { "d": "M18 4h-6a3 3 0 0 0 -3 3v7", "key": "svg-0" }], ["path", { "d": "M13 10l-4 4l-4 -4m8 5l-4 4l-4 -4", "key": "svg-1" }]]);

var IconCornerLeftDown = createVueComponent("outline", "corner-left-down", "CornerLeftDown", [["path", { "d": "M18 6h-6a3 3 0 0 0 -3 3v10l-4 -4m8 0l-4 4", "key": "svg-0" }]]);

var IconCornerLeftUpDouble = createVueComponent("outline", "corner-left-up-double", "CornerLeftUpDouble", [["path", { "d": "M18 19h-6a3 3 0 0 1 -3 -3v-7", "key": "svg-0" }], ["path", { "d": "M13 13l-4 -4l-4 4m8 -5l-4 -4l-4 4", "key": "svg-1" }]]);

var IconCornerLeftUp = createVueComponent("outline", "corner-left-up", "CornerLeftUp", [["path", { "d": "M18 18h-6a3 3 0 0 1 -3 -3v-10l-4 4m8 0l-4 -4", "key": "svg-0" }]]);

var IconCornerRightDownDouble = createVueComponent("outline", "corner-right-down-double", "CornerRightDownDouble", [["path", { "d": "M5 4h6a3 3 0 0 1 3 3v7", "key": "svg-0" }], ["path", { "d": "M10 10l4 4l4 -4m-8 5l4 4l4 -4", "key": "svg-1" }]]);

var IconCornerRightDown = createVueComponent("outline", "corner-right-down", "CornerRightDown", [["path", { "d": "M6 6h6a3 3 0 0 1 3 3v10l-4 -4m8 0l-4 4", "key": "svg-0" }]]);

var IconCornerRightUpDouble = createVueComponent("outline", "corner-right-up-double", "CornerRightUpDouble", [["path", { "d": "M5 19h6a3 3 0 0 0 3 -3v-7", "key": "svg-0" }], ["path", { "d": "M10 13l4 -4l4 4m-8 -5l4 -4l4 4", "key": "svg-1" }]]);

var IconCornerRightUp = createVueComponent("outline", "corner-right-up", "CornerRightUp", [["path", { "d": "M6 18h6a3 3 0 0 0 3 -3v-10l-4 4m8 0l-4 -4", "key": "svg-0" }]]);

var IconCornerUpLeftDouble = createVueComponent("outline", "corner-up-left-double", "CornerUpLeftDouble", [["path", { "d": "M19 18v-6a3 3 0 0 0 -3 -3h-7", "key": "svg-0" }], ["path", { "d": "M13 13l-4 -4l4 -4m-5 8l-4 -4l4 -4", "key": "svg-1" }]]);

var IconCornerUpLeft = createVueComponent("outline", "corner-up-left", "CornerUpLeft", [["path", { "d": "M18 18v-6a3 3 0 0 0 -3 -3h-10l4 -4m0 8l-4 -4", "key": "svg-0" }]]);

var IconCornerUpRightDouble = createVueComponent("outline", "corner-up-right-double", "CornerUpRightDouble", [["path", { "d": "M4 18v-6a3 3 0 0 1 3 -3h7", "key": "svg-0" }], ["path", { "d": "M10 13l4 -4l-4 -4m5 8l4 -4l-4 -4", "key": "svg-1" }]]);

var IconCornerUpRight = createVueComponent("outline", "corner-up-right", "CornerUpRight", [["path", { "d": "M6 18v-6a3 3 0 0 1 3 -3h10l-4 -4m0 8l4 -4", "key": "svg-0" }]]);

var IconCpu2 = createVueComponent("outline", "cpu-2", "Cpu2", [["path", { "d": "M5 5m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M8 10v-2h2m6 6v2h-2m-4 0h-2v-2m8 -4v-2h-2", "key": "svg-1" }], ["path", { "d": "M3 10h2", "key": "svg-2" }], ["path", { "d": "M3 14h2", "key": "svg-3" }], ["path", { "d": "M10 3v2", "key": "svg-4" }], ["path", { "d": "M14 3v2", "key": "svg-5" }], ["path", { "d": "M21 10h-2", "key": "svg-6" }], ["path", { "d": "M21 14h-2", "key": "svg-7" }], ["path", { "d": "M14 21v-2", "key": "svg-8" }], ["path", { "d": "M10 21v-2", "key": "svg-9" }]]);

var IconCpuOff = createVueComponent("outline", "cpu-off", "CpuOff", [["path", { "d": "M9 5h9a1 1 0 0 1 1 1v9m-.292 3.706a1 1 0 0 1 -.708 .294h-12a1 1 0 0 1 -1 -1v-12c0 -.272 .108 -.518 .284 -.698", "key": "svg-0" }], ["path", { "d": "M13 9h2v2m0 4h-6v-6", "key": "svg-1" }], ["path", { "d": "M3 10h2", "key": "svg-2" }], ["path", { "d": "M3 14h2", "key": "svg-3" }], ["path", { "d": "M10 3v2", "key": "svg-4" }], ["path", { "d": "M14 3v2", "key": "svg-5" }], ["path", { "d": "M21 10h-2", "key": "svg-6" }], ["path", { "d": "M21 14h-2", "key": "svg-7" }], ["path", { "d": "M14 21v-2", "key": "svg-8" }], ["path", { "d": "M10 21v-2", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconCpu = createVueComponent("outline", "cpu", "Cpu", [["path", { "d": "M5 5m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M9 9h6v6h-6z", "key": "svg-1" }], ["path", { "d": "M3 10h2", "key": "svg-2" }], ["path", { "d": "M3 14h2", "key": "svg-3" }], ["path", { "d": "M10 3v2", "key": "svg-4" }], ["path", { "d": "M14 3v2", "key": "svg-5" }], ["path", { "d": "M21 10h-2", "key": "svg-6" }], ["path", { "d": "M21 14h-2", "key": "svg-7" }], ["path", { "d": "M14 21v-2", "key": "svg-8" }], ["path", { "d": "M10 21v-2", "key": "svg-9" }]]);

var IconCraneOff = createVueComponent("outline", "crane-off", "CraneOff", [["path", { "d": "M6 21h6", "key": "svg-0" }], ["path", { "d": "M9 21v-12", "key": "svg-1" }], ["path", { "d": "M9 5v-2l-1 1", "key": "svg-2" }], ["path", { "d": "M6 6l-3 3h6", "key": "svg-3" }], ["path", { "d": "M13 9h8", "key": "svg-4" }], ["path", { "d": "M9 3l10 6", "key": "svg-5" }], ["path", { "d": "M17 9v4a2 2 0 0 1 2 2m-2 2a2 2 0 0 1 -2 -2", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconCrane = createVueComponent("outline", "crane", "Crane", [["path", { "d": "M6 21h6", "key": "svg-0" }], ["path", { "d": "M9 21v-18l-6 6h18", "key": "svg-1" }], ["path", { "d": "M9 3l10 6", "key": "svg-2" }], ["path", { "d": "M17 9v4a2 2 0 1 1 -2 2", "key": "svg-3" }]]);

var IconCreativeCommonsBy = createVueComponent("outline", "creative-commons-by", "CreativeCommonsBy", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M9 13v-1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-.5l-.5 4h-2l-.5 -4h-.5a1 1 0 0 1 -1 -1z", "key": "svg-2" }]]);

var IconCreativeCommonsNc = createVueComponent("outline", "creative-commons-nc", "CreativeCommonsNc", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9h-4.5a1.5 1.5 0 0 0 0 3h3a1.5 1.5 0 0 1 0 3h-4.5", "key": "svg-1" }], ["path", { "d": "M12 7v2", "key": "svg-2" }], ["path", { "d": "M12 15v2", "key": "svg-3" }], ["path", { "d": "M6 6l3 3", "key": "svg-4" }], ["path", { "d": "M15 15l3 3", "key": "svg-5" }]]);

var IconCreativeCommonsNd = createVueComponent("outline", "creative-commons-nd", "CreativeCommonsNd", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 10h6", "key": "svg-1" }], ["path", { "d": "M9 14h6", "key": "svg-2" }]]);

var IconCreativeCommonsOff = createVueComponent("outline", "creative-commons-off", "CreativeCommonsOff", [["path", { "d": "M5.638 5.634a9 9 0 1 0 12.723 12.733m1.686 -2.332a9 9 0 0 0 -12.093 -12.077", "key": "svg-0" }], ["path", { "d": "M10.5 10.5a2.187 2.187 0 0 0 -2.914 .116a1.928 1.928 0 0 0 0 2.768a2.188 2.188 0 0 0 2.914 .116", "key": "svg-1" }], ["path", { "d": "M16.5 10.5a2.194 2.194 0 0 0 -2.309 -.302", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCreativeCommonsSa = createVueComponent("outline", "creative-commons-sa", "CreativeCommonsSa", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 16a4 4 0 1 0 -4 -4v1", "key": "svg-1" }], ["path", { "d": "M6 12l2 2l2 -2", "key": "svg-2" }]]);

var IconCreativeCommonsZero = createVueComponent("outline", "creative-commons-zero", "CreativeCommonsZero", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 4 0 1 0 6 0a3 4 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M14 9l-4 6", "key": "svg-2" }]]);

var IconCreativeCommons = createVueComponent("outline", "creative-commons", "CreativeCommons", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10.5 10.5c-.847 -.71 -2.132 -.658 -2.914 .116a1.928 1.928 0 0 0 0 2.768c.782 .774 2.067 .825 2.914 .116", "key": "svg-1" }], ["path", { "d": "M16.5 10.5c-.847 -.71 -2.132 -.658 -2.914 .116a1.928 1.928 0 0 0 0 2.768c.782 .774 2.067 .825 2.914 .116", "key": "svg-2" }]]);

var IconCreditCardOff = createVueComponent("outline", "credit-card-off", "CreditCardOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M9 5h9a3 3 0 0 1 3 3v8a3 3 0 0 1 -.128 .87", "key": "svg-1" }], ["path", { "d": "M18.87 18.872a3 3 0 0 1 -.87 .128h-12a3 3 0 0 1 -3 -3v-8c0 -1.352 .894 -2.495 2.124 -2.87", "key": "svg-2" }], ["path", { "d": "M3 11l8 0", "key": "svg-3" }], ["path", { "d": "M15 11l6 0", "key": "svg-4" }], ["path", { "d": "M7 15l.01 0", "key": "svg-5" }], ["path", { "d": "M11 15l2 0", "key": "svg-6" }]]);

var IconCreditCardPay = createVueComponent("outline", "credit-card-pay", "CreditCardPay", [["path", { "d": "M12 19h-6a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v4.5", "key": "svg-0" }], ["path", { "d": "M3 10h18", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16l3 3l-3 3", "key": "svg-3" }], ["path", { "d": "M7.005 15h.005", "key": "svg-4" }], ["path", { "d": "M11 15h2", "key": "svg-5" }]]);

var IconCreditCardRefund = createVueComponent("outline", "credit-card-refund", "CreditCardRefund", [["path", { "d": "M12 19h-6a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v4.5", "key": "svg-0" }], ["path", { "d": "M3 10h18", "key": "svg-1" }], ["path", { "d": "M7 15h.01", "key": "svg-2" }], ["path", { "d": "M11 15h2", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16l-3 3l3 3", "key": "svg-5" }]]);

var IconCreditCard = createVueComponent("outline", "credit-card", "CreditCard", [["path", { "d": "M3 5m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M3 10l18 0", "key": "svg-1" }], ["path", { "d": "M7 15l.01 0", "key": "svg-2" }], ["path", { "d": "M11 15l2 0", "key": "svg-3" }]]);

var IconCricket = createVueComponent("outline", "cricket", "Cricket", [["path", { "d": "M11.105 18.79l-1 .992a4.159 4.159 0 0 1 -6.038 -5.715l.157 -.166l8.282 -8.401l1.5 1.5l3.45 -3.391a2.08 2.08 0 0 1 3.057 2.815l-.116 .126l-3.391 3.45l1.5 1.5l-3.668 3.617", "key": "svg-0" }], ["path", { "d": "M10.5 7.5l6 6", "key": "svg-1" }], ["path", { "d": "M14 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }]]);

var IconCrop11 = createVueComponent("outline", "crop-1-1", "Crop11", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop169 = createVueComponent("outline", "crop-16-9", "Crop169", [["path", { "d": "M4 8m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop32 = createVueComponent("outline", "crop-3-2", "Crop32", [["path", { "d": "M4 7m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop54 = createVueComponent("outline", "crop-5-4", "Crop54", [["path", { "d": "M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop75 = createVueComponent("outline", "crop-7-5", "Crop75", [["path", { "d": "M4 6m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCropLandscape = createVueComponent("outline", "crop-landscape", "CropLandscape", [["path", { "d": "M4 6m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCropPortrait = createVueComponent("outline", "crop-portrait", "CropPortrait", [["path", { "d": "M6 4m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop = createVueComponent("outline", "crop", "Crop", [["path", { "d": "M8 5v10a1 1 0 0 0 1 1h10", "key": "svg-0" }], ["path", { "d": "M5 8h10a1 1 0 0 1 1 1v10", "key": "svg-1" }]]);

var IconCrossOff = createVueComponent("outline", "cross-off", "CrossOff", [["path", { "d": "M16 12h3v-4h-5v-5h-4v3m-2 2h-3v4h5v9h4v-7", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCross = createVueComponent("outline", "cross", "Cross", [["path", { "d": "M10 21h4v-9h5v-4h-5v-5h-4v5h-5v4h5z", "key": "svg-0" }]]);

var IconCrosshair = createVueComponent("outline", "crosshair", "Crosshair", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M9 12l6 0", "key": "svg-4" }], ["path", { "d": "M12 9l0 6", "key": "svg-5" }]]);

var IconCrownOff = createVueComponent("outline", "crown-off", "CrownOff", [["path", { "d": "M18 18h-13l-1.865 -9.327a.25 .25 0 0 1 .4 -.244l4.465 3.571l1.6 -2.4m1.596 -2.394l.804 -1.206l4 6l4.464 -3.571a.25 .25 0 0 1 .401 .244l-1.363 6.818", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCrown = createVueComponent("outline", "crown", "Crown", [["path", { "d": "M12 6l4 6l5 -4l-2 10h-14l-2 -10l5 4z", "key": "svg-0" }]]);

var IconCrutchesOff = createVueComponent("outline", "crutches-off", "CrutchesOff", [["path", { "d": "M8.178 4.174a2 2 0 0 1 1.822 -1.174h4a2 2 0 1 1 0 4h-3", "key": "svg-0" }], ["path", { "d": "M11 21h2", "key": "svg-1" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 1 .504 -1.664l.992 -1.488a3 3 0 0 0 .097 -.155m.407 -3.601v-3", "key": "svg-2" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 0 -.504 -1.664l-.992 -1.488a3 3 0 0 1 -.504 -1.664v-2.092", "key": "svg-3" }], ["path", { "d": "M10 11h1", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCrutches = createVueComponent("outline", "crutches", "Crutches", [["path", { "d": "M8 3m0 2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-4a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 21h2", "key": "svg-1" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 1 .504 -1.664l.992 -1.488a3 3 0 0 0 .504 -1.664v-5.092", "key": "svg-2" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 0 -.504 -1.664l-.992 -1.488a3 3 0 0 1 -.504 -1.664v-5.092", "key": "svg-3" }], ["path", { "d": "M10 11h4", "key": "svg-4" }]]);

var IconCrystalBall = createVueComponent("outline", "crystal-ball", "CrystalBall", [["path", { "d": "M6.73 17.018a8 8 0 1 1 10.54 0", "key": "svg-0" }], ["path", { "d": "M5 19a2 2 0 0 0 2 2h10a2 2 0 1 0 0 -4h-10a2 2 0 0 0 -2 2z", "key": "svg-1" }], ["path", { "d": "M11 7a3 3 0 0 0 -3 3", "key": "svg-2" }]]);

var IconCsv = createVueComponent("outline", "csv", "Csv", [["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-0" }], ["path", { "d": "M17 8l2 8l2 -8", "key": "svg-1" }], ["path", { "d": "M7 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-2" }]]);

var IconCube3dSphereOff = createVueComponent("outline", "cube-3d-sphere-off", "Cube3dSphereOff", [["path", { "d": "M6 17.6l-2 -1.1v-2.5", "key": "svg-0" }], ["path", { "d": "M4 10v-2.5l2 -1.1", "key": "svg-1" }], ["path", { "d": "M10 4.1l2 -1.1l2 1.1", "key": "svg-2" }], ["path", { "d": "M18 6.4l2 1.1v2.5", "key": "svg-3" }], ["path", { "d": "M20 14v2", "key": "svg-4" }], ["path", { "d": "M14 19.9l-2 1.1l-2 -1.1", "key": "svg-5" }], ["path", { "d": "M18 8.6l2 -1.1", "key": "svg-6" }], ["path", { "d": "M12 12v2.5", "key": "svg-7" }], ["path", { "d": "M12 18.5v2.5", "key": "svg-8" }], ["path", { "d": "M12 12l-2 -1.12", "key": "svg-9" }], ["path", { "d": "M6 8.6l-2 -1.1", "key": "svg-10" }], ["path", { "d": "M3 3l18 18", "key": "svg-11" }]]);

var IconCube3dSphere = createVueComponent("outline", "cube-3d-sphere", "Cube3dSphere", [["path", { "d": "M6 17.6l-2 -1.1v-2.5", "key": "svg-0" }], ["path", { "d": "M4 10v-2.5l2 -1.1", "key": "svg-1" }], ["path", { "d": "M10 4.1l2 -1.1l2 1.1", "key": "svg-2" }], ["path", { "d": "M18 6.4l2 1.1v2.5", "key": "svg-3" }], ["path", { "d": "M20 14v2.5l-2 1.12", "key": "svg-4" }], ["path", { "d": "M14 19.9l-2 1.1l-2 -1.1", "key": "svg-5" }], ["path", { "d": "M12 12l2 -1.1", "key": "svg-6" }], ["path", { "d": "M18 8.6l2 -1.1", "key": "svg-7" }], ["path", { "d": "M12 12l0 2.5", "key": "svg-8" }], ["path", { "d": "M12 18.5l0 2.5", "key": "svg-9" }], ["path", { "d": "M12 12l-2 -1.12", "key": "svg-10" }], ["path", { "d": "M6 8.6l-2 -1.1", "key": "svg-11" }]]);

var IconCubeOff = createVueComponent("outline", "cube-off", "CubeOff", [["path", { "d": "M20.83 16.809c.11 -.248 .17 -.52 .17 -.801v-8.018a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-3.012 1.725m-2.547 1.458l-1.441 .825c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008a2.016 2.016 0 0 0 2 0l5.544 -3.174", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M14.532 10.538l6.198 -3.578", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCubePlus = createVueComponent("outline", "cube-plus", "CubePlus", [["path", { "d": "M21 12.5v-4.509a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-7 4.007c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008a2.016 2.016 0 0 0 2 0", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconCubeSend = createVueComponent("outline", "cube-send", "CubeSend", [["path", { "d": "M16 12.5l-5 -3l5 -3l5 3v5.5l-5 3z", "key": "svg-0" }], ["path", { "d": "M11 9.5v5.5l5 3", "key": "svg-1" }], ["path", { "d": "M16 12.545l5 -3.03", "key": "svg-2" }], ["path", { "d": "M7 9h-5", "key": "svg-3" }], ["path", { "d": "M7 12h-3", "key": "svg-4" }], ["path", { "d": "M7 15h-1", "key": "svg-5" }]]);

var IconCubeSpark = createVueComponent("outline", "cube-spark", "CubeSpark", [["path", { "d": "M21 12v-4.01a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.02 2.02 0 0 0 -2 0l-7 4.008c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008c.62 .354 1.38 .354 2 0", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-4" }]]);

var IconCubeUnfolded = createVueComponent("outline", "cube-unfolded", "CubeUnfolded", [["path", { "d": "M2 15h10v5h5v-5h5v-5h-10v-5h-5v5h-5z", "key": "svg-0" }], ["path", { "d": "M7 15v-5h5v5h5v-5", "key": "svg-1" }]]);

var IconCube = createVueComponent("outline", "cube", "Cube", [["path", { "d": "M21 16.008v-8.018a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-7 4.008c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008a2.016 2.016 0 0 0 2 0l7 -4.008c.619 -.355 1 -1.01 1 -1.718z", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }]]);

var IconCupOff = createVueComponent("outline", "cup-off", "CupOff", [["path", { "d": "M8 8h-3v3h6m4 0h4v-3h-7", "key": "svg-0" }], ["path", { "d": "M17.5 11l-.323 2.154m-.525 3.497l-.652 4.349h-8l-1.5 -10", "key": "svg-1" }], ["path", { "d": "M6 8v-1c0 -.296 .064 -.577 .18 -.83m2.82 -1.17h7a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M15 5v-2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCup = createVueComponent("outline", "cup", "Cup", [["path", { "d": "M5 11h14v-3h-14z", "key": "svg-0" }], ["path", { "d": "M17.5 11l-1.5 10h-8l-1.5 -10", "key": "svg-1" }], ["path", { "d": "M6 8v-1a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M15 5v-2", "key": "svg-3" }]]);

var IconCurling = createVueComponent("outline", "curling", "Curling", [["path", { "d": "M4 9m0 4a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v2a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M4 14h16", "key": "svg-1" }], ["path", { "d": "M8 5h6a2 2 0 0 1 2 2v2", "key": "svg-2" }]]);

var IconCurlyLoop = createVueComponent("outline", "curly-loop", "CurlyLoop", [["path", { "d": "M21 8c-4 0 -7 2 -7 5a3 3 0 0 0 6 0c0 -3 -2.5 -5 -8 -5s-8 2 -8 5a3 3 0 0 0 6 0c0 -3 -3 -5 -7 -5", "key": "svg-0" }]]);

var IconCurrencyAfghani = createVueComponent("outline", "currency-afghani", "CurrencyAfghani", [["path", { "d": "M15 13h-3.5a3.5 3.5 0 1 1 3.5 -3.5v6.5h-7", "key": "svg-0" }], ["path", { "d": "M12 3v.01", "key": "svg-1" }], ["path", { "d": "M12 19v2", "key": "svg-2" }]]);

var IconCurrencyBahraini = createVueComponent("outline", "currency-bahraini", "CurrencyBahraini", [["path", { "d": "M3 10v1a4 4 0 0 0 4 4h2a2 2 0 0 0 2 -2v-3", "key": "svg-0" }], ["path", { "d": "M7 19.01v-.01", "key": "svg-1" }], ["path", { "d": "M14 15.01v-.01", "key": "svg-2" }], ["path", { "d": "M17 15h2a2 2 0 0 0 1.649 -3.131l-2.653 -3.869", "key": "svg-3" }]]);

var IconCurrencyBaht = createVueComponent("outline", "currency-baht", "CurrencyBaht", [["path", { "d": "M8 6h5a3 3 0 0 1 3 3v.143a2.857 2.857 0 0 1 -2.857 2.857h-5.143", "key": "svg-0" }], ["path", { "d": "M8 12h5a3 3 0 0 1 3 3v.143a2.857 2.857 0 0 1 -2.857 2.857h-5.143", "key": "svg-1" }], ["path", { "d": "M8 6v12", "key": "svg-2" }], ["path", { "d": "M11 4v2", "key": "svg-3" }], ["path", { "d": "M11 18v2", "key": "svg-4" }]]);

var IconCurrencyBitcoin = createVueComponent("outline", "currency-bitcoin", "CurrencyBitcoin", [["path", { "d": "M6 6h8a3 3 0 0 1 0 6a3 3 0 0 1 0 6h-8", "key": "svg-0" }], ["path", { "d": "M8 6l0 12", "key": "svg-1" }], ["path", { "d": "M8 12l6 0", "key": "svg-2" }], ["path", { "d": "M9 3l0 3", "key": "svg-3" }], ["path", { "d": "M13 3l0 3", "key": "svg-4" }], ["path", { "d": "M9 18l0 3", "key": "svg-5" }], ["path", { "d": "M13 18l0 3", "key": "svg-6" }]]);

var IconCurrencyCent = createVueComponent("outline", "currency-cent", "CurrencyCent", [["path", { "d": "M16.007 7.54a5.965 5.965 0 0 0 -4.008 -1.54a6 6 0 0 0 -5.992 6c0 3.314 2.682 6 5.992 6a5.965 5.965 0 0 0 4 -1.536", "key": "svg-0" }], ["path", { "d": "M12 20v-2", "key": "svg-1" }], ["path", { "d": "M12 6v-2", "key": "svg-2" }]]);

var IconCurrencyDinar = createVueComponent("outline", "currency-dinar", "CurrencyDinar", [["path", { "d": "M14 20.01v-.01", "key": "svg-0" }], ["path", { "d": "M6 13l2.386 -.9a1 1 0 0 0 -.095 -1.902l-1.514 -.404a1 1 0 0 1 -.102 -1.9l2.325 -.894", "key": "svg-1" }], ["path", { "d": "M3 14v1a3 3 0 0 0 3 3h4.161a3 3 0 0 0 2.983 -3.32l-1.144 -10.68", "key": "svg-2" }], ["path", { "d": "M16 17l1 1h2a2 2 0 0 0 1.649 -3.131l-2.653 -3.869", "key": "svg-3" }]]);

var IconCurrencyDirham = createVueComponent("outline", "currency-dirham", "CurrencyDirham", [["path", { "d": "M8.5 19h-3.5", "key": "svg-0" }], ["path", { "d": "M8.599 16.479a1.5 1.5 0 1 0 -1.099 2.521", "key": "svg-1" }], ["path", { "d": "M7 4v9", "key": "svg-2" }], ["path", { "d": "M15 13h1.888a1.5 1.5 0 0 0 1.296 -2.256l-2.184 -3.744", "key": "svg-3" }], ["path", { "d": "M11 13.01v-.01", "key": "svg-4" }]]);

var IconCurrencyDogecoin = createVueComponent("outline", "currency-dogecoin", "CurrencyDogecoin", [["path", { "d": "M6 12h6", "key": "svg-0" }], ["path", { "d": "M9 6v12", "key": "svg-1" }], ["path", { "d": "M6 18h6a6 6 0 1 0 0 -12h-6", "key": "svg-2" }]]);

var IconCurrencyDollarAustralian = createVueComponent("outline", "currency-dollar-australian", "CurrencyDollarAustralian", [["path", { "d": "M3 18l3.279 -11.476a.75 .75 0 0 1 1.442 0l3.279 11.476", "key": "svg-0" }], ["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }], ["path", { "d": "M4.5 14h5", "key": "svg-4" }]]);

var IconCurrencyDollarBrunei = createVueComponent("outline", "currency-dollar-brunei", "CurrencyDollarBrunei", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M17 20v-2", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M3 6v12h4a3 3 0 0 0 0 -6h-4h4a3 3 0 0 0 0 -6h-4z", "key": "svg-3" }]]);

var IconCurrencyDollarCanadian = createVueComponent("outline", "currency-dollar-canadian", "CurrencyDollarCanadian", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M10 18h-1a6 6 0 1 1 0 -12h1", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }]]);

var IconCurrencyDollarGuyanese = createVueComponent("outline", "currency-dollar-guyanese", "CurrencyDollarGuyanese", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M10 6h-3a4 4 0 0 0 -4 4v4a4 4 0 0 0 4 4h3v-6h-2", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }]]);

var IconCurrencyDollarOff = createVueComponent("outline", "currency-dollar-off", "CurrencyDollarOff", [["path", { "d": "M16.7 8a3 3 0 0 0 -2.7 -2h-4m-2.557 1.431a3 3 0 0 0 2.557 4.569h2m4.564 4.558a3 3 0 0 1 -2.564 1.442h-4a3 3 0 0 1 -2.7 -2", "key": "svg-0" }], ["path", { "d": "M12 3v3m0 12v3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCurrencyDollarSingapore = createVueComponent("outline", "currency-dollar-singapore", "CurrencyDollarSingapore", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M10 6h-4a3 3 0 1 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }]]);

var IconCurrencyDollarZimbabwean = createVueComponent("outline", "currency-dollar-zimbabwean", "CurrencyDollarZimbabwean", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M17 20v-2", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M3 6h7l-7 12h7", "key": "svg-3" }]]);

var IconCurrencyDollar = createVueComponent("outline", "currency-dollar", "CurrencyDollar", [["path", { "d": "M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2", "key": "svg-0" }], ["path", { "d": "M12 3v3m0 12v3", "key": "svg-1" }]]);

var IconCurrencyDong = createVueComponent("outline", "currency-dong", "CurrencyDong", [["path", { "d": "M6 19h12", "key": "svg-0" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M16 16v-12", "key": "svg-2" }], ["path", { "d": "M17 5h-4", "key": "svg-3" }]]);

var IconCurrencyDram = createVueComponent("outline", "currency-dram", "CurrencyDram", [["path", { "d": "M4 10a6 6 0 1 1 12 0v10", "key": "svg-0" }], ["path", { "d": "M12 16h8", "key": "svg-1" }], ["path", { "d": "M12 12h8", "key": "svg-2" }]]);

var IconCurrencyEthereum = createVueComponent("outline", "currency-ethereum", "CurrencyEthereum", [["path", { "d": "M6 12l6 -9l6 9l-6 9z", "key": "svg-0" }], ["path", { "d": "M6 12l6 -3l6 3l-6 2z", "key": "svg-1" }]]);

var IconCurrencyEuroOff = createVueComponent("outline", "currency-euro-off", "CurrencyEuroOff", [["path", { "d": "M17.2 7c-1.977 -2.26 -4.954 -2.602 -7.234 -1.04m-1.913 2.079c-1.604 2.72 -1.374 6.469 .69 8.894c2.292 2.691 6 2.758 8.356 .18", "key": "svg-0" }], ["path", { "d": "M10 10h-5m0 4h8", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCurrencyEuro = createVueComponent("outline", "currency-euro", "CurrencyEuro", [["path", { "d": "M17.2 7a6 7 0 1 0 0 10", "key": "svg-0" }], ["path", { "d": "M13 10h-8m0 4h8", "key": "svg-1" }]]);

var IconCurrencyFlorin = createVueComponent("outline", "currency-florin", "CurrencyFlorin", [["path", { "d": "M8 12h8", "key": "svg-0" }], ["path", { "d": "M7 19c1.213 0 2.31 -.723 2.788 -1.838l4.424 -10.324a3.033 3.033 0 0 1 2.788 -1.838", "key": "svg-1" }]]);

var IconCurrencyForint = createVueComponent("outline", "currency-forint", "CurrencyForint", [["path", { "d": "M11 4h-4a3 3 0 0 0 -3 3v12", "key": "svg-0" }], ["path", { "d": "M10 11h-6", "key": "svg-1" }], ["path", { "d": "M16 4v13a2 2 0 0 0 2 2h2", "key": "svg-2" }], ["path", { "d": "M19 9h-5", "key": "svg-3" }]]);

var IconCurrencyFrank = createVueComponent("outline", "currency-frank", "CurrencyFrank", [["path", { "d": "M17 5h-6a2 2 0 0 0 -2 2v12", "key": "svg-0" }], ["path", { "d": "M7 15h4", "key": "svg-1" }], ["path", { "d": "M9 11h7", "key": "svg-2" }]]);

var IconCurrencyGuarani = createVueComponent("outline", "currency-guarani", "CurrencyGuarani", [["path", { "d": "M16.007 7.54a5.965 5.965 0 0 0 -4.008 -1.54a6 6 0 0 0 -5.992 6c0 3.314 2.682 6 5.992 6a5.965 5.965 0 0 0 4 -1.536c.732 -.66 1.064 -2.148 1 -4.464h-5", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }]]);

var IconCurrencyHryvnia = createVueComponent("outline", "currency-hryvnia", "CurrencyHryvnia", [["path", { "d": "M8 7a2.64 2.64 0 0 1 2.562 -2h3.376a2.64 2.64 0 0 1 2.562 2a2.57 2.57 0 0 1 -1.344 2.922l-5.876 2.938a3.338 3.338 0 0 0 -1.78 3.64a3.11 3.11 0 0 0 3.05 2.5h2.888a2.64 2.64 0 0 0 2.562 -2", "key": "svg-0" }], ["path", { "d": "M6 10h12", "key": "svg-1" }], ["path", { "d": "M6 14h12", "key": "svg-2" }]]);

var IconCurrencyIranianRial = createVueComponent("outline", "currency-iranian-rial", "CurrencyIranianRial", [["path", { "d": "M9 4v9a2 2 0 0 1 -2 2h-1a3 3 0 0 1 -3 -3v-1", "key": "svg-0" }], ["path", { "d": "M12 5v8a1 1 0 0 0 1 1h1a2 2 0 0 0 2 -2v-1", "key": "svg-1" }], ["path", { "d": "M21 14v1.096a5 5 0 0 1 -3.787 4.85l-.213 .054", "key": "svg-2" }], ["path", { "d": "M11 18h.01", "key": "svg-3" }], ["path", { "d": "M14 18h.01", "key": "svg-4" }]]);

var IconCurrencyKip = createVueComponent("outline", "currency-kip", "CurrencyKip", [["path", { "d": "M6 12h12", "key": "svg-0" }], ["path", { "d": "M9 5v14", "key": "svg-1" }], ["path", { "d": "M16 19a7 7 0 0 0 -7 -7a7 7 0 0 0 7 -7", "key": "svg-2" }]]);

var IconCurrencyKroneCzech = createVueComponent("outline", "currency-krone-czech", "CurrencyKroneCzech", [["path", { "d": "M5 6v12", "key": "svg-0" }], ["path", { "d": "M5 12c3.5 0 6 -3 6 -6", "key": "svg-1" }], ["path", { "d": "M5 12c3.5 0 6 3 6 6", "key": "svg-2" }], ["path", { "d": "M19 6l-2 2l-2 -2", "key": "svg-3" }], ["path", { "d": "M19 12h-2a3 3 0 0 0 0 6h2", "key": "svg-4" }]]);

var IconCurrencyKroneDanish = createVueComponent("outline", "currency-krone-danish", "CurrencyKroneDanish", [["path", { "d": "M5 6v12", "key": "svg-0" }], ["path", { "d": "M5 12c3.5 0 6 -3 6 -6", "key": "svg-1" }], ["path", { "d": "M5 12c3.5 0 6 3 6 6", "key": "svg-2" }], ["path", { "d": "M15 10v8", "key": "svg-3" }], ["path", { "d": "M19 10a4 4 0 0 0 -4 4", "key": "svg-4" }], ["path", { "d": "M20 18.01v-.01", "key": "svg-5" }]]);

var IconCurrencyKroneSwedish = createVueComponent("outline", "currency-krone-swedish", "CurrencyKroneSwedish", [["path", { "d": "M5 6v12", "key": "svg-0" }], ["path", { "d": "M5 12c3.5 0 6 -3 6 -6", "key": "svg-1" }], ["path", { "d": "M5 12c3.5 0 6 3 6 6", "key": "svg-2" }], ["path", { "d": "M15 10v8", "key": "svg-3" }], ["path", { "d": "M19 10a4 4 0 0 0 -4 4", "key": "svg-4" }]]);

var IconCurrencyLari = createVueComponent("outline", "currency-lari", "CurrencyLari", [["path", { "d": "M18 13a6 6 0 1 0 -6 6", "key": "svg-0" }], ["path", { "d": "M6 19h12", "key": "svg-1" }], ["path", { "d": "M10 5v7", "key": "svg-2" }], ["path", { "d": "M14 12v-7", "key": "svg-3" }]]);

var IconCurrencyLeu = createVueComponent("outline", "currency-leu", "CurrencyLeu", [["path", { "d": "M17 18h-7a3 3 0 0 1 -3 -3v-10", "key": "svg-0" }]]);

var IconCurrencyLira = createVueComponent("outline", "currency-lira", "CurrencyLira", [["path", { "d": "M10 5v15a7 7 0 0 0 7 -7", "key": "svg-0" }], ["path", { "d": "M6 15l8 -4", "key": "svg-1" }], ["path", { "d": "M14 7l-8 4", "key": "svg-2" }]]);

var IconCurrencyLitecoin = createVueComponent("outline", "currency-litecoin", "CurrencyLitecoin", [["path", { "d": "M18 19h-8.194a2 2 0 0 1 -1.98 -2.283l1.674 -11.717", "key": "svg-0" }], ["path", { "d": "M14 9l-9 4", "key": "svg-1" }]]);

var IconCurrencyLyd = createVueComponent("outline", "currency-lyd", "CurrencyLyd", [["path", { "d": "M11 15h.01", "key": "svg-0" }], ["path", { "d": "M21 5v10a2 2 0 0 1 -2 2h-2.764a2 2 0 0 1 -1.789 -1.106l-.447 -.894", "key": "svg-1" }], ["path", { "d": "M5 8l2.773 4.687c.427 .697 .234 1.626 -.43 2.075a1.38 1.38 0 0 1 -.773 .238h-2.224a.93 .93 0 0 1 -.673 -.293l-.673 -.707", "key": "svg-2" }]]);

var IconCurrencyManat = createVueComponent("outline", "currency-manat", "CurrencyManat", [["path", { "d": "M7 19v-7a5 5 0 1 1 10 0v7", "key": "svg-0" }], ["path", { "d": "M12 5v14", "key": "svg-1" }]]);

var IconCurrencyMonero = createVueComponent("outline", "currency-monero", "CurrencyMonero", [["path", { "d": "M3 18h3v-11l6 7l6 -7v11h3", "key": "svg-0" }]]);

var IconCurrencyNaira = createVueComponent("outline", "currency-naira", "CurrencyNaira", [["path", { "d": "M7 18v-10.948a1.05 1.05 0 0 1 1.968 -.51l6.064 10.916a1.05 1.05 0 0 0 1.968 -.51v-10.948", "key": "svg-0" }], ["path", { "d": "M5 10h14", "key": "svg-1" }], ["path", { "d": "M5 14h14", "key": "svg-2" }]]);

var IconCurrencyNano = createVueComponent("outline", "currency-nano", "CurrencyNano", [["path", { "d": "M7 20l10 -16", "key": "svg-0" }], ["path", { "d": "M7 12h10", "key": "svg-1" }], ["path", { "d": "M7 16h10", "key": "svg-2" }], ["path", { "d": "M17 20l-10 -16", "key": "svg-3" }]]);

var IconCurrencyOff = createVueComponent("outline", "currency-off", "CurrencyOff", [["path", { "d": "M18.531 14.524a7 7 0 0 0 -9.06 -9.053m-2.422 1.582a7 7 0 0 0 9.903 9.896", "key": "svg-0" }], ["path", { "d": "M4 4l3 3", "key": "svg-1" }], ["path", { "d": "M20 4l-3 3", "key": "svg-2" }], ["path", { "d": "M4 20l3 -3", "key": "svg-3" }], ["path", { "d": "M20 20l-3 -3", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCurrencyPaanga = createVueComponent("outline", "currency-paanga", "CurrencyPaanga", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M17 20v-2", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M3 6h8", "key": "svg-3" }], ["path", { "d": "M7 6v12", "key": "svg-4" }]]);

var IconCurrencyPeso = createVueComponent("outline", "currency-peso", "CurrencyPeso", [["path", { "d": "M8 19v-14h3.5a4.5 4.5 0 1 1 0 9h-3.5", "key": "svg-0" }], ["path", { "d": "M18 8h-12", "key": "svg-1" }], ["path", { "d": "M18 11h-12", "key": "svg-2" }]]);

var IconCurrencyPoundOff = createVueComponent("outline", "currency-pound-off", "CurrencyPoundOff", [["path", { "d": "M17 18.5a6 6 0 0 1 -5 0a6 6 0 0 0 -5 .5a3 3 0 0 0 2 -2.5v-7.5m1.192 -2.825a4 4 0 0 1 6.258 .825m-3.45 6h-6", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCurrencyPound = createVueComponent("outline", "currency-pound", "CurrencyPound", [["path", { "d": "M17 18.5a6 6 0 0 1 -5 0a6 6 0 0 0 -5 .5a3 3 0 0 0 2 -2.5v-7.5a4 4 0 0 1 7.45 -2m-2.55 6h-7", "key": "svg-0" }]]);

var IconCurrencyQuetzal = createVueComponent("outline", "currency-quetzal", "CurrencyQuetzal", [["path", { "d": "M12 12m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M13 13l5 5", "key": "svg-1" }]]);

var IconCurrencyReal = createVueComponent("outline", "currency-real", "CurrencyReal", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M4 18v-12h3a3 3 0 1 1 0 6h-3c5.5 0 5 4 6 6", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M17 20v-2", "key": "svg-3" }]]);

var IconCurrencyRenminbi = createVueComponent("outline", "currency-renminbi", "CurrencyRenminbi", [["path", { "d": "M15 9v8a2 2 0 1 0 4 0", "key": "svg-0" }], ["path", { "d": "M19 9h-14", "key": "svg-1" }], ["path", { "d": "M19 5h-14", "key": "svg-2" }], ["path", { "d": "M9 9v4c0 2.5 -.667 4 -2 6", "key": "svg-3" }]]);

var IconCurrencyRipple = createVueComponent("outline", "currency-ripple", "CurrencyRipple", [["path", { "d": "M7 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M10 12h3l2 -2.5", "key": "svg-3" }], ["path", { "d": "M15 14.5l-2 -2.5", "key": "svg-4" }]]);

var IconCurrencyRiyal = createVueComponent("outline", "currency-riyal", "CurrencyRiyal", [["path", { "d": "M15 9v2a2 2 0 1 1 -4 0v-1v1a2 2 0 1 1 -4 0v-1v4a2 2 0 1 1 -4 0v-2", "key": "svg-0" }], ["path", { "d": "M18 12.01v-.01", "key": "svg-1" }], ["path", { "d": "M22 10v1a5 5 0 0 1 -5 5", "key": "svg-2" }]]);

var IconCurrencyRubel = createVueComponent("outline", "currency-rubel", "CurrencyRubel", [["path", { "d": "M8 19v-14h6a3 3 0 0 1 0 6h-8", "key": "svg-0" }], ["path", { "d": "M14 15h-8", "key": "svg-1" }]]);

var IconCurrencyRufiyaa = createVueComponent("outline", "currency-rufiyaa", "CurrencyRufiyaa", [["path", { "d": "M20 16h.01", "key": "svg-0" }], ["path", { "d": "M4 16c9.5 -4 11.5 -8 14 -9", "key": "svg-1" }], ["path", { "d": "M12 8l5 3", "key": "svg-2" }]]);

var IconCurrencyRupeeNepalese = createVueComponent("outline", "currency-rupee-nepalese", "CurrencyRupeeNepalese", [["path", { "d": "M15 5h-11h3a4 4 0 1 1 0 8h-3l6 6", "key": "svg-0" }], ["path", { "d": "M21 17l-4.586 -4.414a2 2 0 0 0 -2.828 2.828l.707 .707", "key": "svg-1" }]]);

var IconCurrencyRupee = createVueComponent("outline", "currency-rupee", "CurrencyRupee", [["path", { "d": "M18 5h-11h3a4 4 0 0 1 0 8h-3l6 6", "key": "svg-0" }], ["path", { "d": "M7 9l11 0", "key": "svg-1" }]]);

var IconCurrencyShekel = createVueComponent("outline", "currency-shekel", "CurrencyShekel", [["path", { "d": "M6 18v-12h4a4 4 0 0 1 4 4v4", "key": "svg-0" }], ["path", { "d": "M18 6v12h-4a4 4 0 0 1 -4 -4v-4", "key": "svg-1" }]]);

var IconCurrencySolana = createVueComponent("outline", "currency-solana", "CurrencySolana", [["path", { "d": "M4 18h12l4 -4h-12z", "key": "svg-0" }], ["path", { "d": "M8 14l-4 -4h12l4 4", "key": "svg-1" }], ["path", { "d": "M16 10l4 -4h-12l-4 4", "key": "svg-2" }]]);

var IconCurrencySom = createVueComponent("outline", "currency-som", "CurrencySom", [["path", { "d": "M10 18v-12h-5v10a2 2 0 0 1 -2 2", "key": "svg-0" }], ["path", { "d": "M14 6v12h4a3 3 0 0 0 0 -6h-4h4a3 3 0 0 0 0 -6h-4z", "key": "svg-1" }]]);

var IconCurrencyTaka = createVueComponent("outline", "currency-taka", "CurrencyTaka", [["path", { "d": "M16.5 15.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M7 7a2 2 0 1 1 4 0v9a3 3 0 0 0 6 0v-.5", "key": "svg-1" }], ["path", { "d": "M8 11h6", "key": "svg-2" }]]);

var IconCurrencyTenge = createVueComponent("outline", "currency-tenge", "CurrencyTenge", [["path", { "d": "M6 5h12", "key": "svg-0" }], ["path", { "d": "M6 9h12", "key": "svg-1" }], ["path", { "d": "M12 9v10", "key": "svg-2" }]]);

var IconCurrencyTugrik = createVueComponent("outline", "currency-tugrik", "CurrencyTugrik", [["path", { "d": "M7 6h10", "key": "svg-0" }], ["path", { "d": "M12 6v13", "key": "svg-1" }], ["path", { "d": "M8 17l8 -3", "key": "svg-2" }], ["path", { "d": "M16 10l-8 3", "key": "svg-3" }]]);

var IconCurrencyWon = createVueComponent("outline", "currency-won", "CurrencyWon", [["path", { "d": "M4 6l3.245 11.358a.85 .85 0 0 0 1.624 .035l3.131 -9.393l3.131 9.393a.85 .85 0 0 0 1.624 -.035l3.245 -11.358", "key": "svg-0" }], ["path", { "d": "M21 10h-18", "key": "svg-1" }], ["path", { "d": "M21 14h-18", "key": "svg-2" }]]);

var IconCurrencyXrp = createVueComponent("outline", "currency-xrp", "CurrencyXrp", [["path", { "d": "M5 5l3.585 3.585a4.83 4.83 0 0 0 6.83 0l3.585 -3.585", "key": "svg-0" }], ["path", { "d": "M5 19l3.585 -3.585a4.83 4.83 0 0 1 6.83 0l3.585 3.584", "key": "svg-1" }]]);

var IconCurrencyYenOff = createVueComponent("outline", "currency-yen-off", "CurrencyYenOff", [["path", { "d": "M12 19v-7m5 -7l-3.328 4.66", "key": "svg-0" }], ["path", { "d": "M8 17h8", "key": "svg-1" }], ["path", { "d": "M8 13h5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCurrencyYen = createVueComponent("outline", "currency-yen", "CurrencyYen", [["path", { "d": "M12 19v-7l-5 -7m10 0l-5 7", "key": "svg-0" }], ["path", { "d": "M8 17l8 0", "key": "svg-1" }], ["path", { "d": "M8 13l8 0", "key": "svg-2" }]]);

var IconCurrencyYuan = createVueComponent("outline", "currency-yuan", "CurrencyYuan", [["path", { "d": "M12 19v-7l-5 -7", "key": "svg-0" }], ["path", { "d": "M17 5l-5 7", "key": "svg-1" }], ["path", { "d": "M8 13h8", "key": "svg-2" }]]);

var IconCurrencyZloty = createVueComponent("outline", "currency-zloty", "CurrencyZloty", [["path", { "d": "M12 18h-7l7 -7h-7", "key": "svg-0" }], ["path", { "d": "M17 18v-13", "key": "svg-1" }], ["path", { "d": "M14 14.5l6 -3.5", "key": "svg-2" }]]);

var IconCurrency = createVueComponent("outline", "currency", "Currency", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M4 4l3 3", "key": "svg-1" }], ["path", { "d": "M20 4l-3 3", "key": "svg-2" }], ["path", { "d": "M4 20l3 -3", "key": "svg-3" }], ["path", { "d": "M20 20l-3 -3", "key": "svg-4" }]]);

var IconCurrentLocationOff = createVueComponent("outline", "current-location-off", "CurrentLocationOff", [["path", { "d": "M14.685 10.661c-.3 -.6 -.795 -1.086 -1.402 -1.374m-3.397 .584a3 3 0 1 0 4.24 4.245", "key": "svg-0" }], ["path", { "d": "M6.357 6.33a8 8 0 1 0 11.301 11.326m1.642 -2.378a8 8 0 0 0 -10.597 -10.569", "key": "svg-1" }], ["path", { "d": "M12 2v2", "key": "svg-2" }], ["path", { "d": "M12 20v2", "key": "svg-3" }], ["path", { "d": "M20 12h2", "key": "svg-4" }], ["path", { "d": "M2 12h2", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconCurrentLocation = createVueComponent("outline", "current-location", "CurrentLocation", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 12m-8 0a8 8 0 1 0 16 0a8 8 0 1 0 -16 0", "key": "svg-1" }], ["path", { "d": "M12 2l0 2", "key": "svg-2" }], ["path", { "d": "M12 20l0 2", "key": "svg-3" }], ["path", { "d": "M20 12l2 0", "key": "svg-4" }], ["path", { "d": "M2 12l2 0", "key": "svg-5" }]]);

var IconCursorOff = createVueComponent("outline", "cursor-off", "CursorOff", [["path", { "d": "M9 4a3 3 0 0 1 3 3v1m0 9a3 3 0 0 1 -3 3", "key": "svg-0" }], ["path", { "d": "M15 4a3 3 0 0 0 -3 3v1m0 4v5a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCursorText = createVueComponent("outline", "cursor-text", "CursorText", [["path", { "d": "M10 12h4", "key": "svg-0" }], ["path", { "d": "M9 4a3 3 0 0 1 3 3v10a3 3 0 0 1 -3 3", "key": "svg-1" }], ["path", { "d": "M15 4a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3", "key": "svg-2" }]]);

var IconCut = createVueComponent("outline", "cut", "Cut", [["path", { "d": "M7 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M9.15 14.85l8.85 -10.85", "key": "svg-2" }], ["path", { "d": "M6 4l8.85 10.85", "key": "svg-3" }]]);

var IconCylinderOff = createVueComponent("outline", "cylinder-off", "CylinderOff", [["path", { "d": "M5.23 5.233c-.15 .245 -.23 .502 -.23 .767c0 1.131 1.461 2.117 3.62 2.628m4.357 .343c3.404 -.204 6.023 -1.456 6.023 -2.971c0 -1.657 -3.134 -3 -7 -3c-1.645 0 -3.158 .243 -4.353 .65", "key": "svg-0" }], ["path", { "d": "M5 6v12c0 1.657 3.134 3 7 3c3.245 0 5.974 -.946 6.767 -2.23m.233 -3.77v-9", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCylinderPlus = createVueComponent("outline", "cylinder-plus", "CylinderPlus", [["path", { "d": "M12 6m-7 0a7 3 0 1 0 14 0a7 3 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 6v12c0 1.657 3.134 3 7 3c.173 0 .345 -.003 .515 -.008m6.485 -8.992v-6", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconCylinder = createVueComponent("outline", "cylinder", "Cylinder", [["path", { "d": "M12 6m-7 0a7 3 0 1 0 14 0a7 3 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 6v12c0 1.657 3.134 3 7 3s7 -1.343 7 -3v-12", "key": "svg-1" }]]);

var IconDashboardOff = createVueComponent("outline", "dashboard-off", "DashboardOff", [["path", { "d": "M11.175 11.178a2 2 0 1 0 2.653 2.634", "key": "svg-0" }], ["path", { "d": "M14.5 10.5l1 -1", "key": "svg-1" }], ["path", { "d": "M8.621 4.612a9 9 0 0 1 11.721 11.72m-1.516 2.488a9.008 9.008 0 0 1 -1.226 1.18h-11.2a9 9 0 0 1 -.268 -13.87", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDashboard = createVueComponent("outline", "dashboard", "Dashboard", [["path", { "d": "M12 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.45 11.55l2.05 -2.05", "key": "svg-1" }], ["path", { "d": "M6.4 20a9 9 0 1 1 11.2 0z", "key": "svg-2" }]]);

var IconDatabaseCog = createVueComponent("outline", "database-cog", "DatabaseCog", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.21 0 .42 -.003 .626 -.01", "key": "svg-1" }], ["path", { "d": "M20 11.5v-5.5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconDatabaseDollar = createVueComponent("outline", "database-dollar", "DatabaseDollar", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.415 0 .822 -.012 1.22 -.035", "key": "svg-1" }], ["path", { "d": "M20 10v-4", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.352 0 .698 -.009 1.037 -.025", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconDatabaseEdit = createVueComponent("outline", "database-edit", "DatabaseEdit", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.478 0 .947 -.016 1.402 -.046", "key": "svg-1" }], ["path", { "d": "M20 12v-6", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.526 3.04 2.786 6.972 2.975", "key": "svg-3" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-4" }]]);

var IconDatabaseExclamation = createVueComponent("outline", "database-exclamation", "DatabaseExclamation", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c1.118 0 2.182 -.086 3.148 -.241m4.852 -2.759v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c1.064 0 2.079 -.078 3.007 -.22", "key": "svg-2" }], ["path", { "d": "M19 16v3", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }]]);

var IconDatabaseExport = createVueComponent("outline", "database-export", "DatabaseExport", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c1.118 0 2.183 -.086 3.15 -.241", "key": "svg-1" }], ["path", { "d": "M20 12v-6", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.157 0 .312 -.002 .466 -.005", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16l3 3l-3 3", "key": "svg-5" }]]);

var IconDatabaseHeart = createVueComponent("outline", "database-heart", "DatabaseHeart", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.453 2.755 2.665 6.414 2.941", "key": "svg-1" }], ["path", { "d": "M20 11v-5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.579 3.253 2.873 7.383 2.991", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconDatabaseImport = createVueComponent("outline", "database-import", "DatabaseImport", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.856 0 1.68 -.05 2.454 -.144m5.546 -2.856v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.171 0 .341 -.002 .51 -.006", "key": "svg-2" }], ["path", { "d": "M19 22v-6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-4" }]]);

var IconDatabaseLeak = createVueComponent("outline", "database-leak", "DatabaseLeak", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v12c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-12", "key": "svg-1" }], ["path", { "d": "M4 15a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1", "key": "svg-2" }]]);

var IconDatabaseMinus = createVueComponent("outline", "database-minus", "DatabaseMinus", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.164 0 .328 -.002 .49 -.006", "key": "svg-2" }], ["path", { "d": "M20 15v-3", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconDatabaseOff = createVueComponent("outline", "database-off", "DatabaseOff", [["path", { "d": "M12.983 8.978c3.955 -.182 7.017 -1.446 7.017 -2.978c0 -1.657 -3.582 -3 -8 -3c-1.661 0 -3.204 .19 -4.483 .515m-2.783 1.228c-.471 .382 -.734 .808 -.734 1.257c0 1.22 1.944 2.271 4.734 2.74", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.986 0 1.93 -.067 2.802 -.19m3.187 -.82c1.251 -.53 2.011 -1.228 2.011 -1.99v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c3.217 0 5.991 -.712 7.261 -1.74m.739 -3.26v-4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDatabasePlus = createVueComponent("outline", "database-plus", "DatabasePlus", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c1.075 0 2.1 -.08 3.037 -.224", "key": "svg-1" }], ["path", { "d": "M20 12v-6", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.166 0 .331 -.002 .495 -.006", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconDatabaseSearch = createVueComponent("outline", "database-search", "DatabaseSearch", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3m8 -3.5v-5.5", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3", "key": "svg-2" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-4" }]]);

var IconDatabaseShare = createVueComponent("outline", "database-share", "DatabaseShare", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.361 0 .716 -.009 1.065 -.026", "key": "svg-1" }], ["path", { "d": "M20 13v-7", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconDatabaseSmile = createVueComponent("outline", "database-smile", "DatabaseSmile", [["path", { "d": "M10 14h.01", "key": "svg-0" }], ["path", { "d": "M14 14h.01", "key": "svg-1" }], ["path", { "d": "M10 17a3.5 3.5 0 0 0 4 0", "key": "svg-2" }], ["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-3" }], ["path", { "d": "M4 6v12c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-12", "key": "svg-4" }]]);

var IconDatabaseStar = createVueComponent("outline", "database-star", "DatabaseStar", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.43 2.67 2.627 6.243 2.927", "key": "svg-1" }], ["path", { "d": "M20 10.5v-4.5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.546 3.12 2.82 7.128 2.982", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconDatabaseX = createVueComponent("outline", "database-x", "DatabaseX", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.537 0 1.062 -.02 1.57 -.058", "key": "svg-1" }], ["path", { "d": "M20 13.5v-7.5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.384 0 .762 -.01 1.132 -.03", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconDatabase = createVueComponent("outline", "database", "Database", [["path", { "d": "M12 6m-8 0a8 3 0 1 0 16 0a8 3 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 6v6a8 3 0 0 0 16 0v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6a8 3 0 0 0 16 0v-6", "key": "svg-2" }]]);

var IconDecimal = createVueComponent("outline", "decimal", "Decimal", [["path", { "d": "M17 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M10 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-1" }], ["path", { "d": "M5 16h.01", "key": "svg-2" }]]);

var IconDeer = createVueComponent("outline", "deer", "Deer", [["path", { "d": "M3 3c0 2 1 3 4 3c2 0 3 1 3 3", "key": "svg-0" }], ["path", { "d": "M21 3c0 2 -1 3 -4 3c-2 0 -3 .333 -3 3", "key": "svg-1" }], ["path", { "d": "M12 18c-1 0 -4 -3 -4 -6c0 -2 1.333 -3 4 -3s4 1 4 3c0 3 -3 6 -4 6", "key": "svg-2" }], ["path", { "d": "M15.185 14.889l.095 -.18a4 4 0 1 1 -6.56 0", "key": "svg-3" }], ["path", { "d": "M17 3c0 1.333 -.333 2.333 -1 3", "key": "svg-4" }], ["path", { "d": "M7 3c0 1.333 .333 2.333 1 3", "key": "svg-5" }], ["path", { "d": "M7 6c-2.667 .667 -4.333 1.667 -5 3", "key": "svg-6" }], ["path", { "d": "M17 6c2.667 .667 4.333 1.667 5 3", "key": "svg-7" }], ["path", { "d": "M8.5 10l-1.5 -1", "key": "svg-8" }], ["path", { "d": "M15.5 10l1.5 -1", "key": "svg-9" }], ["path", { "d": "M12 15h.01", "key": "svg-10" }]]);

var IconDelta = createVueComponent("outline", "delta", "Delta", [["path", { "d": "M4 20h16l-8 -16z", "key": "svg-0" }]]);

var IconDentalBroken = createVueComponent("outline", "dental-broken", "DentalBroken", [["path", { "d": "M12 5.5c-1.074 -.586 -2.583 -1.5 -4 -1.5c-2.1 0 -4 1.247 -4 5c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 0 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 2 .993 2.567 .237c1.615 -2.127 2.671 -5.637 2.671 -10.537c0 -3.74 -1.908 -5 -4 -5c-1.423 0 -2.92 .911 -4 1.5z", "key": "svg-0" }], ["path", { "d": "M12 5.5l1 2.5l-2 2l2 2", "key": "svg-1" }]]);

var IconDentalOff = createVueComponent("outline", "dental-off", "DentalOff", [["path", { "d": "M19.277 15.281c.463 -1.75 .723 -3.844 .723 -6.281c0 -3.74 -1.908 -5 -4 -5c-1.423 0 -2.92 .911 -4 1.5c-1.074 -.586 -2.583 -1.5 -4 -1.5m-2.843 1.153c-.707 .784 -1.157 2.017 -1.157 3.847c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 0 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 2 .993 2.567 .237c.305 -.402 .59 -.853 .852 -1.353", "key": "svg-0" }], ["path", { "d": "M12 5.5l3 1.5", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDental = createVueComponent("outline", "dental", "Dental", [["path", { "d": "M12 5.5c-1.074 -.586 -2.583 -1.5 -4 -1.5c-2.1 0 -4 1.247 -4 5c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 0 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 2 .993 2.567 .237c1.615 -2.127 2.671 -5.637 2.671 -10.537c0 -3.74 -1.908 -5 -4 -5c-1.423 0 -2.92 .911 -4 1.5z", "key": "svg-0" }], ["path", { "d": "M12 5.5l3 1.5", "key": "svg-1" }]]);

var IconDeselect = createVueComponent("outline", "deselect", "Deselect", [["path", { "d": "M12 8h3a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M16 16h-7a1 1 0 0 1 -1 -1v-7", "key": "svg-1" }], ["path", { "d": "M12 20v.01", "key": "svg-2" }], ["path", { "d": "M16 20v.01", "key": "svg-3" }], ["path", { "d": "M8 20v.01", "key": "svg-4" }], ["path", { "d": "M4 20v.01", "key": "svg-5" }], ["path", { "d": "M4 16v.01", "key": "svg-6" }], ["path", { "d": "M4 12v.01", "key": "svg-7" }], ["path", { "d": "M4 8v.01", "key": "svg-8" }], ["path", { "d": "M8 4v.01", "key": "svg-9" }], ["path", { "d": "M12 4v.01", "key": "svg-10" }], ["path", { "d": "M16 4v.01", "key": "svg-11" }], ["path", { "d": "M20 4v.01", "key": "svg-12" }], ["path", { "d": "M20 8v.01", "key": "svg-13" }], ["path", { "d": "M20 12v.01", "key": "svg-14" }], ["path", { "d": "M20 16v.01", "key": "svg-15" }], ["path", { "d": "M3 3l18 18", "key": "svg-16" }]]);

var IconDesk = createVueComponent("outline", "desk", "Desk", [["path", { "d": "M3 6h18", "key": "svg-0" }], ["path", { "d": "M4 6v13", "key": "svg-1" }], ["path", { "d": "M20 19v-13", "key": "svg-2" }], ["path", { "d": "M4 10h16", "key": "svg-3" }], ["path", { "d": "M15 6v8a2 2 0 0 0 2 2h3", "key": "svg-4" }]]);

var IconDetailsOff = createVueComponent("outline", "details-off", "DetailsOff", [["path", { "d": "M5 19h14", "key": "svg-0" }], ["path", { "d": "M20.986 16.984a2 2 0 0 0 -.146 -.734l-7.1 -12.25a2 2 0 0 0 -3.5 0l-.821 1.417m-1.469 2.534l-4.81 8.299a2 2 0 0 0 1.75 2.75", "key": "svg-1" }], ["path", { "d": "M12 3v5m0 4v7", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDetails = createVueComponent("outline", "details", "Details", [["path", { "d": "M11.999 3l.001 17", "key": "svg-0" }], ["path", { "d": "M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z", "key": "svg-1" }]]);

var IconDeviceAirpodsCase = createVueComponent("outline", "device-airpods-case", "DeviceAirpodsCase", [["path", { "d": "M21 10h-18", "key": "svg-0" }], ["path", { "d": "M3 4m0 4a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z", "key": "svg-1" }], ["path", { "d": "M7 10v1.5a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 1.5 -1.5v-1.5", "key": "svg-2" }]]);

var IconDeviceAirpods = createVueComponent("outline", "device-airpods", "DeviceAirpods", [["path", { "d": "M6 4a4 4 0 0 1 4 3.8l0 .2v10.5a1.5 1.5 0 0 1 -3 0v-6.5h-1a4 4 0 0 1 -4 -3.8l0 -.2a4 4 0 0 1 4 -4z", "key": "svg-0" }], ["path", { "d": "M18 4a4 4 0 0 0 -4 3.8l0 .2v10.5a1.5 1.5 0 0 0 3 0v-6.5h1a4 4 0 0 0 4 -3.8l0 -.2a4 4 0 0 0 -4 -4z", "key": "svg-1" }]]);

var IconDeviceAirtag = createVueComponent("outline", "device-airtag", "DeviceAirtag", [["path", { "d": "M4 12a8 8 0 1 0 16 0a8 8 0 0 0 -16 0", "key": "svg-0" }], ["path", { "d": "M9 15v.01", "key": "svg-1" }], ["path", { "d": "M15 15a6 6 0 0 0 -6 -6", "key": "svg-2" }], ["path", { "d": "M12 15a3 3 0 0 0 -3 -3", "key": "svg-3" }]]);

var IconDeviceAnalytics = createVueComponent("outline", "device-analytics", "DeviceAnalytics", [["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 20l10 0", "key": "svg-1" }], ["path", { "d": "M9 16l0 4", "key": "svg-2" }], ["path", { "d": "M15 16l0 4", "key": "svg-3" }], ["path", { "d": "M8 12l3 -3l2 2l3 -3", "key": "svg-4" }]]);

var IconDeviceAudioTape = createVueComponent("outline", "device-audio-tape", "DeviceAudioTape", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M3 17l4 -3h10l4 3", "key": "svg-1" }], ["circle", { "cx": "7.5", "cy": "9.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "16.5", "cy": "9.5", "r": ".5", "fill": "currentColor", "key": "svg-3" }]]);

var IconDeviceCameraPhone = createVueComponent("outline", "device-camera-phone", "DeviceCameraPhone", [["path", { "d": "M18.5 8.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M13 7h-8a2 2 0 0 0 -2 2v7a2 2 0 0 0 2 2h13a2 2 0 0 0 2 -2v-2", "key": "svg-1" }], ["path", { "d": "M17 15v-1", "key": "svg-2" }]]);

var IconDeviceCctvOff = createVueComponent("outline", "device-cctv-off", "DeviceCctvOff", [["path", { "d": "M7 7h-3a1 1 0 0 1 -1 -1v-2c0 -.275 .11 -.523 .29 -.704m3.71 -.296h13a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-9", "key": "svg-0" }], ["path", { "d": "M10.36 10.35a4 4 0 1 0 5.285 5.3", "key": "svg-1" }], ["path", { "d": "M19 7v7c0 .321 -.022 .637 -.064 .947m-1.095 2.913a7 7 0 0 1 -12.841 -3.86l0 -7", "key": "svg-2" }], ["path", { "d": "M12 14h.01", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDeviceCctv = createVueComponent("outline", "device-cctv", "DeviceCctv", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 14m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M19 7v7a7 7 0 0 1 -14 0v-7", "key": "svg-2" }], ["path", { "d": "M12 14l.01 0", "key": "svg-3" }]]);

var IconDeviceComputerCameraOff = createVueComponent("outline", "device-computer-camera-off", "DeviceComputerCameraOff", [["path", { "d": "M6.15 6.153a7 7 0 0 0 9.696 9.696m2 -2a7 7 0 0 0 -9.699 -9.695", "key": "svg-0" }], ["path", { "d": "M9.13 9.122a3 3 0 0 0 3.743 3.749m2 -2a3 3 0 0 0 -3.737 -3.736", "key": "svg-1" }], ["path", { "d": "M8 16l-2.091 3.486a1 1 0 0 0 .857 1.514h10.468a1 1 0 0 0 .857 -1.514l-2.091 -3.486", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDeviceComputerCamera = createVueComponent("outline", "device-computer-camera", "DeviceComputerCamera", [["path", { "d": "M12 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M12 10m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M8 16l-2.091 3.486a1 1 0 0 0 .857 1.514h10.468a1 1 0 0 0 .857 -1.514l-2.091 -3.486", "key": "svg-2" }]]);

var IconDeviceDesktopAnalytics = createVueComponent("outline", "device-desktop-analytics", "DeviceDesktopAnalytics", [["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 20h10", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }], ["path", { "d": "M9 12v-4", "key": "svg-4" }], ["path", { "d": "M12 12v-1", "key": "svg-5" }], ["path", { "d": "M15 12v-2", "key": "svg-6" }], ["path", { "d": "M12 12v-1", "key": "svg-7" }]]);

var IconDeviceDesktopBolt = createVueComponent("outline", "device-desktop-bolt", "DeviceDesktopBolt", [["path", { "d": "M14.5 16h-10.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h6", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-3" }]]);

var IconDeviceDesktopCancel = createVueComponent("outline", "device-desktop-cancel", "DeviceDesktopCancel", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M17 21l4 -4", "key": "svg-4" }]]);

var IconDeviceDesktopCheck = createVueComponent("outline", "device-desktop-check", "DeviceDesktopCheck", [["path", { "d": "M12 16h-8a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }], ["path", { "d": "M7 20h4", "key": "svg-2" }], ["path", { "d": "M9 16v4", "key": "svg-3" }]]);

var IconDeviceDesktopCode = createVueComponent("outline", "device-desktop-code", "DeviceDesktopCode", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M7 20h4", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-3" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-4" }]]);

var IconDeviceDesktopCog = createVueComponent("outline", "device-desktop-cog", "DeviceDesktopCog", [["path", { "d": "M12 16h-8a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-4" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-5" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-6" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-7" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-8" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-9" }]]);

var IconDeviceDesktopDollar = createVueComponent("outline", "device-desktop-dollar", "DeviceDesktopDollar", [["path", { "d": "M13 16h-9a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v5.5", "key": "svg-0" }], ["path", { "d": "M7 20h6.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-4" }]]);

var IconDeviceDesktopDown = createVueComponent("outline", "device-desktop-down", "DeviceDesktopDown", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-4" }]]);

var IconDeviceDesktopExclamation = createVueComponent("outline", "device-desktop-exclamation", "DeviceDesktopExclamation", [["path", { "d": "M15 16h-11a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M7 20h8", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }], ["path", { "d": "M19 16v3", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }]]);

var IconDeviceDesktopHeart = createVueComponent("outline", "device-desktop-heart", "DeviceDesktopHeart", [["path", { "d": "M10 16h-6a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M7 20h3.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-3" }]]);

var IconDeviceDesktopMinus = createVueComponent("outline", "device-desktop-minus", "DeviceDesktopMinus", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconDeviceDesktopOff = createVueComponent("outline", "device-desktop-off", "DeviceDesktopOff", [["path", { "d": "M8 4h12a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1m-4 0h-12a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1", "key": "svg-0" }], ["path", { "d": "M7 20h10", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDeviceDesktopPause = createVueComponent("outline", "device-desktop-pause", "DeviceDesktopPause", [["path", { "d": "M13 16h-9a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }], ["path", { "d": "M7 20h6", "key": "svg-3" }], ["path", { "d": "M9 16v4", "key": "svg-4" }]]);

var IconDeviceDesktopPin = createVueComponent("outline", "device-desktop-pin", "DeviceDesktopPin", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }], ["path", { "d": "M7 20h5", "key": "svg-3" }], ["path", { "d": "M9 16v4", "key": "svg-4" }]]);

var IconDeviceDesktopPlus = createVueComponent("outline", "device-desktop-plus", "DeviceDesktopPlus", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconDeviceDesktopQuestion = createVueComponent("outline", "device-desktop-question", "DeviceDesktopQuestion", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M7 20h8", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-4" }]]);

var IconDeviceDesktopSearch = createVueComponent("outline", "device-desktop-search", "DeviceDesktopSearch", [["path", { "d": "M11.5 16h-7.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M7 20h4", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-4" }]]);

var IconDeviceDesktopShare = createVueComponent("outline", "device-desktop-share", "DeviceDesktopShare", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M7 20h5.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M16 22l5 -5", "key": "svg-3" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconDeviceDesktopStar = createVueComponent("outline", "device-desktop-star", "DeviceDesktopStar", [["path", { "d": "M10 16h-6a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M7 20h3.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-3" }]]);

var IconDeviceDesktopUp = createVueComponent("outline", "device-desktop-up", "DeviceDesktopUp", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M7 20h5", "key": "svg-3" }], ["path", { "d": "M9 16v4", "key": "svg-4" }]]);

var IconDeviceDesktopX = createVueComponent("outline", "device-desktop-x", "DeviceDesktopX", [["path", { "d": "M13 16h-9a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M7 20h6.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-3" }], ["path", { "d": "M17 22l5 -5", "key": "svg-4" }]]);

var IconDeviceDesktop = createVueComponent("outline", "device-desktop", "DeviceDesktop", [["path", { "d": "M3 5a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1v-10z", "key": "svg-0" }], ["path", { "d": "M7 20h10", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }]]);

var IconDeviceFloppy = createVueComponent("outline", "device-floppy", "DeviceFloppy", [["path", { "d": "M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M14 4l0 4l-6 0l0 -4", "key": "svg-2" }]]);

var IconDeviceGamepad2 = createVueComponent("outline", "device-gamepad-2", "DeviceGamepad2", [["path", { "d": "M12 5h3.5a5 5 0 0 1 0 10h-5.5l-4.015 4.227a2.3 2.3 0 0 1 -3.923 -2.035l1.634 -8.173a5 5 0 0 1 4.904 -4.019h3.4z", "key": "svg-0" }], ["path", { "d": "M14 15l4.07 4.284a2.3 2.3 0 0 0 3.925 -2.023l-1.6 -8.232", "key": "svg-1" }], ["path", { "d": "M8 9v2", "key": "svg-2" }], ["path", { "d": "M7 10h2", "key": "svg-3" }], ["path", { "d": "M14 10h2", "key": "svg-4" }]]);

var IconDeviceGamepad3 = createVueComponent("outline", "device-gamepad-3", "DeviceGamepad3", [["path", { "d": "M9 12l-3 -3h-2a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h2z", "key": "svg-0" }], ["path", { "d": "M15 12l3 -3h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2z", "key": "svg-1" }], ["path", { "d": "M12 15l-3 3v2a1 1 0 0 0 1 1h4a1 1 0 0 0 1 -1v-2z", "key": "svg-2" }], ["path", { "d": "M12 9l-3 -3v-2a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v2z", "key": "svg-3" }]]);

var IconDeviceGamepad = createVueComponent("outline", "device-gamepad", "DeviceGamepad", [["path", { "d": "M2 6m0 2a2 2 0 0 1 2 -2h16a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-16a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 12h4m-2 -2v4", "key": "svg-1" }], ["path", { "d": "M15 11l0 .01", "key": "svg-2" }], ["path", { "d": "M18 13l0 .01", "key": "svg-3" }]]);

var IconDeviceHeartMonitor = createVueComponent("outline", "device-heart-monitor", "DeviceHeartMonitor", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M4 9h6l1 -2l2 4l1 -2h6", "key": "svg-1" }], ["path", { "d": "M4 14h16", "key": "svg-2" }], ["path", { "d": "M14 17v.01", "key": "svg-3" }], ["path", { "d": "M17 17v.01", "key": "svg-4" }]]);

var IconDeviceImacBolt = createVueComponent("outline", "device-imac-bolt", "DeviceImacBolt", [["path", { "d": "M13.5 17h-9.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h5.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-4" }]]);

var IconDeviceImacCancel = createVueComponent("outline", "device-imac-cancel", "DeviceImacCancel", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M3 13h12.5", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M17 21l4 -4", "key": "svg-5" }]]);

var IconDeviceImacCheck = createVueComponent("outline", "device-imac-check", "DeviceImacCheck", [["path", { "d": "M11.5 17h-7.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h3.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-4" }]]);

var IconDeviceImacCode = createVueComponent("outline", "device-imac-code", "DeviceImacCode", [["path", { "d": "M11.5 17h-7.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h3.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-5" }]]);

var IconDeviceImacCog = createVueComponent("outline", "device-imac-cog", "DeviceImacCog", [["path", { "d": "M12 17h-8a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h4", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconDeviceImacDollar = createVueComponent("outline", "device-imac-dollar", "DeviceImacDollar", [["path", { "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M3 13h11", "key": "svg-1" }], ["path", { "d": "M8 21h5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconDeviceImacDown = createVueComponent("outline", "device-imac-down", "DeviceImacDown", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-5" }]]);

var IconDeviceImacExclamation = createVueComponent("outline", "device-imac-exclamation", "DeviceImacExclamation", [["path", { "d": "M15 17h-11a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h7", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }], ["path", { "d": "M19 16v3", "key": "svg-5" }], ["path", { "d": "M19 22v.01", "key": "svg-6" }]]);

var IconDeviceImacHeart = createVueComponent("outline", "device-imac-heart", "DeviceImacHeart", [["path", { "d": "M10 17h-6a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M3 13h9", "key": "svg-1" }], ["path", { "d": "M8 21h3.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconDeviceImacMinus = createVueComponent("outline", "device-imac-minus", "DeviceImacMinus", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v11", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconDeviceImacOff = createVueComponent("outline", "device-imac-off", "DeviceImacOff", [["path", { "d": "M7 3h13a1 1 0 0 1 1 1v12c0 .28 -.115 .532 -.3 .713m-3.7 .287h-13a1 1 0 0 1 -1 -1v-12c0 -.276 .112 -.526 .293 -.707", "key": "svg-0" }], ["path", { "d": "M3 13h10m4 0h4", "key": "svg-1" }], ["path", { "d": "M8 21h8", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconDeviceImacPause = createVueComponent("outline", "device-imac-pause", "DeviceImacPause", [["path", { "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M17 17v5", "key": "svg-4" }], ["path", { "d": "M21 17v5", "key": "svg-5" }]]);

var IconDeviceImacPin = createVueComponent("outline", "device-imac-pin", "DeviceImacPin", [["path", { "d": "M12 17h-8a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }], ["path", { "d": "M3 13h11", "key": "svg-3" }], ["path", { "d": "M8 21h4.5", "key": "svg-4" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-5" }]]);

var IconDeviceImacPlus = createVueComponent("outline", "device-imac-plus", "DeviceImacPlus", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13.5", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconDeviceImacQuestion = createVueComponent("outline", "device-imac-question", "DeviceImacQuestion", [["path", { "d": "M14 17h-10a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M3 13h11.5", "key": "svg-1" }], ["path", { "d": "M8 21h7", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-6" }]]);

var IconDeviceImacSearch = createVueComponent("outline", "device-imac-search", "DeviceImacSearch", [["path", { "d": "M11 17h-7a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M3 13h10", "key": "svg-1" }], ["path", { "d": "M8 21h4", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-5" }]]);

var IconDeviceImacShare = createVueComponent("outline", "device-imac-share", "DeviceImacShare", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h4", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconDeviceImacStar = createVueComponent("outline", "device-imac-star", "DeviceImacStar", [["path", { "d": "M10 17h-6a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M3 13h10", "key": "svg-1" }], ["path", { "d": "M8 21h3", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconDeviceImacUp = createVueComponent("outline", "device-imac-up", "DeviceImacUp", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 22v-6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-5" }]]);

var IconDeviceImacX = createVueComponent("outline", "device-imac-x", "DeviceImacX", [["path", { "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconDeviceImac = createVueComponent("outline", "device-imac", "DeviceImac", [["path", { "d": "M3 4a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1v-12z", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h8", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }]]);

var IconDeviceIpadBolt = createVueComponent("outline", "device-ipad-bolt", "DeviceIpadBolt", [["path", { "d": "M13.5 21h-7.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h4", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconDeviceIpadCancel = createVueComponent("outline", "device-ipad-cancel", "DeviceIpadCancel", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconDeviceIpadCheck = createVueComponent("outline", "device-ipad-check", "DeviceIpadCheck", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h2", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconDeviceIpadCode = createVueComponent("outline", "device-ipad-code", "DeviceIpadCode", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h2", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconDeviceIpadCog = createVueComponent("outline", "device-ipad-cog", "DeviceIpadCog", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconDeviceIpadDollar = createVueComponent("outline", "device-ipad-dollar", "DeviceIpadDollar", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 18h4", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconDeviceIpadDown = createVueComponent("outline", "device-ipad-down", "DeviceIpadDown", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconDeviceIpadExclamation = createVueComponent("outline", "device-ipad-exclamation", "DeviceIpadExclamation", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h6", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconDeviceIpadHeart = createVueComponent("outline", "device-ipad-heart", "DeviceIpadHeart", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h1", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalBolt = createVueComponent("outline", "device-ipad-horizontal-bolt", "DeviceIpadHorizontalBolt", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h4.5", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalCancel = createVueComponent("outline", "device-ipad-horizontal-cancel", "DeviceIpadHorizontalCancel", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalCheck = createVueComponent("outline", "device-ipad-horizontal-check", "DeviceIpadHorizontalCheck", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }], ["path", { "d": "M9 17h2.5", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalCode = createVueComponent("outline", "device-ipad-horizontal-code", "DeviceIpadHorizontalCode", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 17h2.5", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalCog = createVueComponent("outline", "device-ipad-horizontal-cog", "DeviceIpadHorizontalCog", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 17h3", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconDeviceIpadHorizontalDollar = createVueComponent("outline", "device-ipad-horizontal-dollar", "DeviceIpadHorizontalDollar", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4.5", "key": "svg-0" }], ["path", { "d": "M9 17h4", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalDown = createVueComponent("outline", "device-ipad-horizontal-down", "DeviceIpadHorizontalDown", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalExclamation = createVueComponent("outline", "device-ipad-horizontal-exclamation", "DeviceIpadHorizontalExclamation", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 17h6", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalHeart = createVueComponent("outline", "device-ipad-horizontal-heart", "DeviceIpadHorizontalHeart", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 17h1", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalMinus = createVueComponent("outline", "device-ipad-horizontal-minus", "DeviceIpadHorizontalMinus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalOff = createVueComponent("outline", "device-ipad-horizontal-off", "DeviceIpadHorizontalOff", [["path", { "d": "M8 4h12a2 2 0 0 1 2 2v12m-2 2h-16a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9 17h6", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalPause = createVueComponent("outline", "device-ipad-horizontal-pause", "DeviceIpadHorizontalPause", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 17h4", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalPin = createVueComponent("outline", "device-ipad-horizontal-pin", "DeviceIpadHorizontalPin", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 17h3", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalPlus = createVueComponent("outline", "device-ipad-horizontal-plus", "DeviceIpadHorizontalPlus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalQuestion = createVueComponent("outline", "device-ipad-horizontal-question", "DeviceIpadHorizontalQuestion", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 17h4.5", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalSearch = createVueComponent("outline", "device-ipad-horizontal-search", "DeviceIpadHorizontalSearch", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5.5", "key": "svg-0" }], ["path", { "d": "M9 17h2", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalShare = createVueComponent("outline", "device-ipad-horizontal-share", "DeviceIpadHorizontalShare", [["path", { "d": "M12.5 20h-7.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 17h3", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalStar = createVueComponent("outline", "device-ipad-horizontal-star", "DeviceIpadHorizontalStar", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5.5", "key": "svg-0" }], ["path", { "d": "M9 17h1", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalUp = createVueComponent("outline", "device-ipad-horizontal-up", "DeviceIpadHorizontalUp", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalX = createVueComponent("outline", "device-ipad-horizontal-x", "DeviceIpadHorizontalX", [["path", { "d": "M13.5 20h-8.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }], ["path", { "d": "M9 17h4", "key": "svg-3" }]]);

var IconDeviceIpadHorizontal = createVueComponent("outline", "device-ipad-horizontal", "DeviceIpadHorizontal", [["path", { "d": "M3 6a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M9 17h6", "key": "svg-1" }]]);

var IconDeviceIpadMinus = createVueComponent("outline", "device-ipad-minus", "DeviceIpadMinus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v10", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconDeviceIpadOff = createVueComponent("outline", "device-ipad-off", "DeviceIpadOff", [["path", { "d": "M6 2h12a2 2 0 0 1 2 2v12m0 4a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-16", "key": "svg-0" }], ["path", { "d": "M9 19h6", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceIpadPause = createVueComponent("outline", "device-ipad-pause", "DeviceIpadPause", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h4", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconDeviceIpadPin = createVueComponent("outline", "device-ipad-pin", "DeviceIpadPin", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconDeviceIpadPlus = createVueComponent("outline", "device-ipad-plus", "DeviceIpadPlus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconDeviceIpadQuestion = createVueComponent("outline", "device-ipad-question", "DeviceIpadQuestion", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h5", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconDeviceIpadSearch = createVueComponent("outline", "device-ipad-search", "DeviceIpadSearch", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h2", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconDeviceIpadShare = createVueComponent("outline", "device-ipad-share", "DeviceIpadShare", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h3.5", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconDeviceIpadStar = createVueComponent("outline", "device-ipad-star", "DeviceIpadStar", [["path", { "d": "M11 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5.5", "key": "svg-0" }], ["path", { "d": "M9 18h1", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconDeviceIpadUp = createVueComponent("outline", "device-ipad-up", "DeviceIpadUp", [["path", { "d": "M9 18h3", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M13.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-3" }]]);

var IconDeviceIpadX = createVueComponent("outline", "device-ipad-x", "DeviceIpadX", [["path", { "d": "M22 22l-5 -5", "key": "svg-0" }], ["path", { "d": "M17 22l5 -5", "key": "svg-1" }], ["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v9", "key": "svg-2" }], ["path", { "d": "M9 18h4", "key": "svg-3" }]]);

var IconDeviceIpad = createVueComponent("outline", "device-ipad", "DeviceIpad", [["path", { "d": "M18 3a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M9 18h6", "key": "svg-1" }]]);

var IconDeviceLandlinePhone = createVueComponent("outline", "device-landline-phone", "DeviceLandlinePhone", [["path", { "d": "M20 3h-2a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h2a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 4h-11a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3h11", "key": "svg-1" }], ["path", { "d": "M12 8h-6v3h6z", "key": "svg-2" }], ["path", { "d": "M12 14v.01", "key": "svg-3" }], ["path", { "d": "M9 14v.01", "key": "svg-4" }], ["path", { "d": "M6 14v.01", "key": "svg-5" }], ["path", { "d": "M12 17v.01", "key": "svg-6" }], ["path", { "d": "M9 17v.01", "key": "svg-7" }], ["path", { "d": "M6 17v.01", "key": "svg-8" }]]);

var IconDeviceLaptopOff = createVueComponent("outline", "device-laptop-off", "DeviceLaptopOff", [["path", { "d": "M3 19h16", "key": "svg-0" }], ["path", { "d": "M10 6h8a1 1 0 0 1 1 1v8m-3 1h-10a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceLaptop = createVueComponent("outline", "device-laptop", "DeviceLaptop", [["path", { "d": "M3 19l18 0", "key": "svg-0" }], ["path", { "d": "M5 6m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-1" }]]);

var IconDeviceMobileBolt = createVueComponent("outline", "device-mobile-bolt", "DeviceMobileBolt", [["path", { "d": "M13.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }], ["path", { "d": "M11 4h2", "key": "svg-2" }], ["path", { "d": "M12 17v.01", "key": "svg-3" }]]);

var IconDeviceMobileCancel = createVueComponent("outline", "device-mobile-cancel", "DeviceMobileCancel", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileCharging = createVueComponent("outline", "device-mobile-charging", "DeviceMobileCharging", [["path", { "d": "M6 3m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 9.5l-1 2.5h2l-1 2.5", "key": "svg-2" }]]);

var IconDeviceMobileCheck = createVueComponent("outline", "device-mobile-check", "DeviceMobileCheck", [["path", { "d": "M11.5 21h-3.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v9.5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-3" }]]);

var IconDeviceMobileCode = createVueComponent("outline", "device-mobile-code", "DeviceMobileCode", [["path", { "d": "M11.5 21h-3.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileCog = createVueComponent("outline", "device-mobile-cog", "DeviceMobileCog", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-4" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-5" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-6" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-7" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-8" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-9" }]]);

var IconDeviceMobileDollar = createVueComponent("outline", "device-mobile-dollar", "DeviceMobileDollar", [["path", { "d": "M13 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-4" }]]);

var IconDeviceMobileDown = createVueComponent("outline", "device-mobile-down", "DeviceMobileDown", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-4" }]]);

var IconDeviceMobileExclamation = createVueComponent("outline", "device-mobile-exclamation", "DeviceMobileExclamation", [["path", { "d": "M15 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M19 16v3", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }]]);

var IconDeviceMobileHeart = createVueComponent("outline", "device-mobile-heart", "DeviceMobileHeart", [["path", { "d": "M11.5 21h-3.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconDeviceMobileMessage = createVueComponent("outline", "device-mobile-message", "DeviceMobileMessage", [["path", { "d": "M11 3h10v8h-3l-4 2v-2h-3z", "key": "svg-0" }], ["path", { "d": "M15 16v4a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1h2", "key": "svg-1" }], ["path", { "d": "M10 18v.01", "key": "svg-2" }]]);

var IconDeviceMobileMinus = createVueComponent("outline", "device-mobile-minus", "DeviceMobileMinus", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v10", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconDeviceMobileOff = createVueComponent("outline", "device-mobile-off", "DeviceMobileOff", [["path", { "d": "M7.159 3.185c.256 -.119 .54 -.185 .841 -.185h8a2 2 0 0 1 2 2v9m0 4v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-13", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }], ["path", { "d": "M12 17v.01", "key": "svg-3" }]]);

var IconDeviceMobilePause = createVueComponent("outline", "device-mobile-pause", "DeviceMobilePause", [["path", { "d": "M13 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobilePin = createVueComponent("outline", "device-mobile-pin", "DeviceMobilePin", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobilePlus = createVueComponent("outline", "device-mobile-plus", "DeviceMobilePlus", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileQuestion = createVueComponent("outline", "device-mobile-question", "DeviceMobileQuestion", [["path", { "d": "M15 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileRotated = createVueComponent("outline", "device-mobile-rotated", "DeviceMobileRotated", [["path", { "d": "M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M20 11v2", "key": "svg-1" }], ["path", { "d": "M7 12h-.01", "key": "svg-2" }]]);

var IconDeviceMobileSearch = createVueComponent("outline", "device-mobile-search", "DeviceMobileSearch", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileShare = createVueComponent("outline", "device-mobile-share", "DeviceMobileShare", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileStar = createVueComponent("outline", "device-mobile-star", "DeviceMobileStar", [["path", { "d": "M11 21h-3a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconDeviceMobileUp = createVueComponent("outline", "device-mobile-up", "DeviceMobileUp", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileVibration = createVueComponent("outline", "device-mobile-vibration", "DeviceMobileVibration", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 4l2 0", "key": "svg-1" }], ["path", { "d": "M9 17l0 .01", "key": "svg-2" }], ["path", { "d": "M21 6l-2 3l2 3l-2 3l2 3", "key": "svg-3" }]]);

var IconDeviceMobileX = createVueComponent("outline", "device-mobile-x", "DeviceMobileX", [["path", { "d": "M13 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobile = createVueComponent("outline", "device-mobile", "DeviceMobile", [["path", { "d": "M6 5a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }]]);

var IconDeviceNintendoOff = createVueComponent("outline", "device-nintendo-off", "DeviceNintendoOff", [["path", { "d": "M4.713 4.718a4 4 0 0 0 -1.713 3.282v8a4 4 0 0 0 4 4h3v-10m0 -4v-2h-2", "key": "svg-0" }], ["path", { "d": "M14 10v-6h3a4 4 0 0 1 4 4v8c0 .308 -.035 .608 -.1 .896m-1.62 2.39a3.982 3.982 0 0 1 -2.28 .714h-3v-6", "key": "svg-1" }], ["path", { "d": "M6.5 8.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDeviceNintendo = createVueComponent("outline", "device-nintendo", "DeviceNintendo", [["path", { "d": "M10 20v-16h-3a4 4 0 0 0 -4 4v8a4 4 0 0 0 4 4h3z", "key": "svg-0" }], ["path", { "d": "M14 20v-16h3a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-3z", "key": "svg-1" }], ["circle", { "cx": "17.5", "cy": "15.5", "r": "1", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "6.5", "cy": "8.5", "r": "1", "fill": "currentColor", "key": "svg-3" }]]);

var IconDeviceProjector = createVueComponent("outline", "device-projector", "DeviceProjector", [["path", { "d": "M8 9a5 5 0 1 0 10 0a5 5 0 0 0 -10 0", "key": "svg-0" }], ["path", { "d": "M9 6h-4a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2v-8a2 2 0 0 0 -2 -2h-2", "key": "svg-1" }], ["path", { "d": "M6 15h1", "key": "svg-2" }], ["path", { "d": "M7 18l-1 2", "key": "svg-3" }], ["path", { "d": "M18 18l1 2", "key": "svg-4" }]]);

var IconDeviceRemote = createVueComponent("outline", "device-remote", "DeviceRemote", [["path", { "d": "M12 10m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M12 3v2", "key": "svg-2" }], ["path", { "d": "M10 15v.01", "key": "svg-3" }], ["path", { "d": "M10 18v.01", "key": "svg-4" }], ["path", { "d": "M14 18v.01", "key": "svg-5" }], ["path", { "d": "M14 15v.01", "key": "svg-6" }]]);

var IconDeviceSdCard = createVueComponent("outline", "device-sd-card", "DeviceSdCard", [["path", { "d": "M7 21h10a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2h-6.172a2 2 0 0 0 -1.414 .586l-3.828 3.828a2 2 0 0 0 -.586 1.414v10.172a2 2 0 0 0 2 2z", "key": "svg-0" }], ["path", { "d": "M13 6v2", "key": "svg-1" }], ["path", { "d": "M16 6v2", "key": "svg-2" }], ["path", { "d": "M10 7v1", "key": "svg-3" }]]);

var IconDeviceSim1 = createVueComponent("outline", "device-sim-1", "DeviceSim1", [["path", { "d": "M6 3h8.5l4.5 4.5v12.5a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M10 11l2 -2v8", "key": "svg-1" }]]);

var IconDeviceSim2 = createVueComponent("outline", "device-sim-2", "DeviceSim2", [["path", { "d": "M6 3h8.5l4.5 4.5v12.5a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M10 9h3a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-1" }]]);

var IconDeviceSim3 = createVueComponent("outline", "device-sim-3", "DeviceSim3", [["path", { "d": "M6 3h8.5l4.5 4.5v12.5a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M10 9h2.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-1.5h1.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-2.5", "key": "svg-1" }]]);

var IconDeviceSim = createVueComponent("outline", "device-sim", "DeviceSim", [["path", { "d": "M6 3h8.5l4.5 4.5v12.5a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M9 11h3v6", "key": "svg-1" }], ["path", { "d": "M15 17v.01", "key": "svg-2" }], ["path", { "d": "M15 14v.01", "key": "svg-3" }], ["path", { "d": "M15 11v.01", "key": "svg-4" }], ["path", { "d": "M9 14v.01", "key": "svg-5" }], ["path", { "d": "M9 17v.01", "key": "svg-6" }]]);

var IconDeviceSpeakerOff = createVueComponent("outline", "device-speaker-off", "DeviceSpeakerOff", [["path", { "d": "M7 3h10a2 2 0 0 1 2 2v10m0 4a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-14", "key": "svg-0" }], ["path", { "d": "M11.114 11.133a3 3 0 1 0 3.754 3.751", "key": "svg-1" }], ["path", { "d": "M12 7v.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDeviceSpeaker = createVueComponent("outline", "device-speaker", "DeviceSpeaker", [["path", { "d": "M5 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 14m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M12 7l0 .01", "key": "svg-2" }]]);

var IconDeviceTabletBolt = createVueComponent("outline", "device-tablet-bolt", "DeviceTabletBolt", [["path", { "d": "M13.5 21h-7.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-2" }]]);

var IconDeviceTabletCancel = createVueComponent("outline", "device-tablet-cancel", "DeviceTabletCancel", [["path", { "d": "M12.5 21h-6.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }]]);

var IconDeviceTabletCheck = createVueComponent("outline", "device-tablet-check", "DeviceTabletCheck", [["path", { "d": "M11.5 21h-5.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v9.5", "key": "svg-0" }], ["path", { "d": "M12.314 16.05a1 1 0 0 0 -1.042 1.635", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconDeviceTabletCode = createVueComponent("outline", "device-tablet-code", "DeviceTabletCode", [["path", { "d": "M11.5 21h-5.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M12.344 16.06a1 1 0 0 0 -1.07 1.627", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconDeviceTabletCog = createVueComponent("outline", "device-tablet-cog", "DeviceTabletCog", [["path", { "d": "M12 21h-6a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M12 16a1 1 0 0 0 0 2", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconDeviceTabletDollar = createVueComponent("outline", "device-tablet-dollar", "DeviceTabletDollar", [["path", { "d": "M13 21h-7a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconDeviceTabletDown = createVueComponent("outline", "device-tablet-down", "DeviceTabletDown", [["path", { "d": "M12.5 21h-6.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }]]);

var IconDeviceTabletExclamation = createVueComponent("outline", "device-tablet-exclamation", "DeviceTabletExclamation", [["path", { "d": "M15 21h-9a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconDeviceTabletHeart = createVueComponent("outline", "device-tablet-heart", "DeviceTabletHeart", [["path", { "d": "M11.5 21h-5.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }]]);

var IconDeviceTabletMinus = createVueComponent("outline", "device-tablet-minus", "DeviceTabletMinus", [["path", { "d": "M12.5 21h-6.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v11", "key": "svg-0" }], ["path", { "d": "M12.872 16.51a1 1 0 1 0 -.872 1.49", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconDeviceTabletOff = createVueComponent("outline", "device-tablet-off", "DeviceTabletOff", [["path", { "d": "M7 3h11a1 1 0 0 1 1 1v11m0 4v1a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-15", "key": "svg-0" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceTabletPause = createVueComponent("outline", "device-tablet-pause", "DeviceTabletPause", [["path", { "d": "M13 21h-7a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v9.5", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }]]);

var IconDeviceTabletPin = createVueComponent("outline", "device-tablet-pin", "DeviceTabletPin", [["path", { "d": "M12.5 21h-6.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M12 16a1 1 0 0 0 0 2", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconDeviceTabletPlus = createVueComponent("outline", "device-tablet-plus", "DeviceTabletPlus", [["path", { "d": "M12.5 21h-6.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }]]);

var IconDeviceTabletQuestion = createVueComponent("outline", "device-tablet-question", "DeviceTabletQuestion", [["path", { "d": "M15 21h-9a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }]]);

var IconDeviceTabletSearch = createVueComponent("outline", "device-tablet-search", "DeviceTabletSearch", [["path", { "d": "M11.5 21h-5.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }]]);

var IconDeviceTabletShare = createVueComponent("outline", "device-tablet-share", "DeviceTabletShare", [["path", { "d": "M12 21h-6a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M12.57 16.178a1 1 0 1 0 .016 1.633", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconDeviceTabletStar = createVueComponent("outline", "device-tablet-star", "DeviceTabletStar", [["path", { "d": "M11 21h-5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }]]);

var IconDeviceTabletUp = createVueComponent("outline", "device-tablet-up", "DeviceTabletUp", [["path", { "d": "M12.5 21h-6.5a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M12.906 16.576a1 1 0 1 0 -.906 1.424", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconDeviceTabletX = createVueComponent("outline", "device-tablet-x", "DeviceTabletX", [["path", { "d": "M13 21h-7a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v9.5", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }]]);

var IconDeviceTablet = createVueComponent("outline", "device-tablet", "DeviceTablet", [["path", { "d": "M5 4a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-16z", "key": "svg-0" }], ["path", { "d": "M11 17a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-1" }]]);

var IconDeviceTvOff = createVueComponent("outline", "device-tv-off", "DeviceTvOff", [["path", { "d": "M11 7h8a2 2 0 0 1 2 2v8m-1.178 2.824c-.25 .113 -.529 .176 -.822 .176h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M16 3l-4 4l-4 -4", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceTvOld = createVueComponent("outline", "device-tv-old", "DeviceTvOld", [["path", { "d": "M3 7m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 3l-4 4l-4 -4", "key": "svg-1" }], ["path", { "d": "M15 7v13", "key": "svg-2" }], ["path", { "d": "M18 15v.01", "key": "svg-3" }], ["path", { "d": "M18 12v.01", "key": "svg-4" }]]);

var IconDeviceTv = createVueComponent("outline", "device-tv", "DeviceTv", [["path", { "d": "M3 7m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 3l-4 4l-4 -4", "key": "svg-1" }]]);

var IconDeviceUnknown = createVueComponent("outline", "device-unknown", "DeviceUnknown", [["path", { "d": "M5 5a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 16v.01", "key": "svg-1" }], ["path", { "d": "M12 13a2 2 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconDeviceUsb = createVueComponent("outline", "device-usb", "DeviceUsb", [["path", { "d": "M7 8h10v8a5 5 0 0 1 -10 0z", "key": "svg-0" }], ["path", { "d": "M9 8v-5h6v5", "key": "svg-1" }]]);

var IconDeviceVisionPro = createVueComponent("outline", "device-vision-pro", "DeviceVisionPro", [["path", { "d": "M12 7c1.143 0 2.235 .035 3.275 .104c1.017 .068 1.95 .207 2.798 .42c.813 .203 1.52 .505 2.119 .909a3.903 3.903 0 0 1 1.328 1.531c.326 .657 .48 1.48 .48 2.466c0 1.006 -.189 1.91 -.574 2.707c-.375 .779 -.886 1.396 -1.537 1.848a3.696 3.696 0 0 1 -2.16 .66c-.509 0 -.97 -.068 -1.382 -.21a5.84 5.84 0 0 1 -1.17 -.548a18.45 18.45 0 0 1 -1.045 -.695a9.104 9.104 0 0 0 -1.001 -.63a2.376 2.376 0 0 0 -1.13 -.301c-.373 0 -.75 .097 -1.132 .3c-.316 .17 -.65 .38 -1 .63c-.322 .23 -.67 .462 -1.047 .695a5.78 5.78 0 0 1 -1.168 .548c-.413 .142 -.872 .21 -1.378 .21a3.706 3.706 0 0 1 -2.165 -.659c-.651 -.452 -1.162 -1.07 -1.537 -1.848c-.385 -.798 -.574 -1.7 -.574 -2.709c-.004 -.98 .15 -1.802 .477 -2.46a3.897 3.897 0 0 1 1.33 -1.531c.6 -.403 1.307 -.704 2.12 -.907a16.088 16.088 0 0 1 2.8 -.423c1.04 -.071 2.13 -.107 3.273 -.107z", "key": "svg-0" }]]);

var IconDeviceWatchBolt = createVueComponent("outline", "device-watch-bolt", "DeviceWatchBolt", [["path", { "d": "M13 18h-4a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v3", "key": "svg-0" }], ["path", { "d": "M9 18v3h4.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-3" }]]);

var IconDeviceWatchCancel = createVueComponent("outline", "device-watch-cancel", "DeviceWatchCancel", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v3", "key": "svg-0" }], ["path", { "d": "M9 18v3h3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M17 21l4 -4", "key": "svg-4" }]]);

var IconDeviceWatchCheck = createVueComponent("outline", "device-watch-check", "DeviceWatchCheck", [["path", { "d": "M11 18h-2a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v5.5", "key": "svg-0" }], ["path", { "d": "M9 18v3h2.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-3" }]]);

var IconDeviceWatchCode = createVueComponent("outline", "device-watch-code", "DeviceWatchCode", [["path", { "d": "M11 18h-2a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }], ["path", { "d": "M9 18v3h3", "key": "svg-3" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-4" }]]);

var IconDeviceWatchCog = createVueComponent("outline", "device-watch-cog", "DeviceWatchCog", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v2.5", "key": "svg-0" }], ["path", { "d": "M9 18v3h3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-4" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-5" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-6" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-7" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-8" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-9" }]]);

var IconDeviceWatchDollar = createVueComponent("outline", "device-watch-dollar", "DeviceWatchDollar", [["path", { "d": "M13 18h-4a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v1", "key": "svg-0" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-1" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-2" }], ["path", { "d": "M9 18v3h4", "key": "svg-3" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-4" }]]);

var IconDeviceWatchDown = createVueComponent("outline", "device-watch-down", "DeviceWatchDown", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v3", "key": "svg-0" }], ["path", { "d": "M9 18v3h3.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-4" }]]);

var IconDeviceWatchExclamation = createVueComponent("outline", "device-watch-exclamation", "DeviceWatchExclamation", [["path", { "d": "M15 18h-6a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v3", "key": "svg-0" }], ["path", { "d": "M9 18v3h6v-3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19 16v3", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }]]);

var IconDeviceWatchHeart = createVueComponent("outline", "device-watch-heart", "DeviceWatchHeart", [["path", { "d": "M10 18h-1a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v2", "key": "svg-0" }], ["path", { "d": "M9 18v3h2.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-3" }]]);

var IconDeviceWatchMinus = createVueComponent("outline", "device-watch-minus", "DeviceWatchMinus", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v6", "key": "svg-0" }], ["path", { "d": "M9 18v3h3.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconDeviceWatchOff = createVueComponent("outline", "device-watch-off", "DeviceWatchOff", [["path", { "d": "M10 6h5a3 3 0 0 1 3 3v5m-.89 3.132a2.99 2.99 0 0 1 -2.11 .868h-6a3 3 0 0 1 -3 -3v-6c0 -.817 .327 -1.559 .857 -2.1", "key": "svg-0" }], ["path", { "d": "M9 18v3h6v-3", "key": "svg-1" }], ["path", { "d": "M9 5v-2h6v3", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDeviceWatchPause = createVueComponent("outline", "device-watch-pause", "DeviceWatchPause", [["path", { "d": "M13 18h-4a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M9 18v3h4", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M17 17v5", "key": "svg-3" }], ["path", { "d": "M21 17v5", "key": "svg-4" }]]);

var IconDeviceWatchPin = createVueComponent("outline", "device-watch-pin", "DeviceWatchPin", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v2", "key": "svg-0" }], ["path", { "d": "M9 18v3h3.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-3" }], ["path", { "d": "M19 18v.01", "key": "svg-4" }]]);

var IconDeviceWatchPlus = createVueComponent("outline", "device-watch-plus", "DeviceWatchPlus", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v3", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M9 18v3h3.5", "key": "svg-3" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-4" }]]);

var IconDeviceWatchQuestion = createVueComponent("outline", "device-watch-question", "DeviceWatchQuestion", [["path", { "d": "M14 18h-5a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v2", "key": "svg-0" }], ["path", { "d": "M9 18v3h6v-2", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-4" }]]);

var IconDeviceWatchSearch = createVueComponent("outline", "device-watch-search", "DeviceWatchSearch", [["path", { "d": "M11 18h-2a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v2", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }], ["path", { "d": "M9 18v3h3", "key": "svg-3" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-4" }]]);

var IconDeviceWatchShare = createVueComponent("outline", "device-watch-share", "DeviceWatchShare", [["path", { "d": "M12.5 18h-3.5a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M9 18v3h3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M16 22l5 -5", "key": "svg-3" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconDeviceWatchStar = createVueComponent("outline", "device-watch-star", "DeviceWatchStar", [["path", { "d": "M10 18h-1a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v1", "key": "svg-0" }], ["path", { "d": "M9 18v3h2", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-3" }]]);

var IconDeviceWatchStats2 = createVueComponent("outline", "device-watch-stats-2", "DeviceWatchStats2", [["path", { "d": "M6 6m0 3a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v6a3 3 0 0 1 -3 3h-6a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M9 18v3h6v-3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M12 10a2 2 0 1 0 2 2", "key": "svg-3" }]]);

var IconDeviceWatchStats = createVueComponent("outline", "device-watch-stats", "DeviceWatchStats", [["path", { "d": "M6 6m0 3a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v6a3 3 0 0 1 -3 3h-6a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M9 18v3h6v-3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M9 14v-4", "key": "svg-3" }], ["path", { "d": "M12 14v-1", "key": "svg-4" }], ["path", { "d": "M15 14v-3", "key": "svg-5" }]]);

var IconDeviceWatchUp = createVueComponent("outline", "device-watch-up", "DeviceWatchUp", [["path", { "d": "M12 18h-3a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v3", "key": "svg-0" }], ["path", { "d": "M9 18v3h3.5", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M19 22v-6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-4" }]]);

var IconDeviceWatchX = createVueComponent("outline", "device-watch-x", "DeviceWatchX", [["path", { "d": "M13 18h-4a3 3 0 0 1 -3 -3v-6a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M9 18v3h4", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-3" }], ["path", { "d": "M17 22l5 -5", "key": "svg-4" }]]);

var IconDeviceWatch = createVueComponent("outline", "device-watch", "DeviceWatch", [["path", { "d": "M6 9a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v6a3 3 0 0 1 -3 3h-6a3 3 0 0 1 -3 -3v-6z", "key": "svg-0" }], ["path", { "d": "M9 18v3h6v-3", "key": "svg-1" }], ["path", { "d": "M9 6v-3h6v3", "key": "svg-2" }]]);

var IconDevices2 = createVueComponent("outline", "devices-2", "Devices2", [["path", { "d": "M10 15h-6a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h6", "key": "svg-0" }], ["path", { "d": "M13 4m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M7 19l3 0", "key": "svg-2" }], ["path", { "d": "M17 8l0 .01", "key": "svg-3" }], ["path", { "d": "M17 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M9 15l0 4", "key": "svg-5" }]]);

var IconDevicesBolt = createVueComponent("outline", "devices-bolt", "DevicesBolt", [["path", { "d": "M13 19v-10a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }], ["path", { "d": "M16 9h2", "key": "svg-3" }]]);

var IconDevicesCancel = createVueComponent("outline", "devices-cancel", "DevicesCancel", [["path", { "d": "M13 15.5v-6.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesCheck = createVueComponent("outline", "devices-check", "DevicesCheck", [["path", { "d": "M13 15.5v-6.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v4", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h7", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-3" }]]);

var IconDevicesCode = createVueComponent("outline", "devices-code", "DevicesCode", [["path", { "d": "M13 15.5v-6.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v4m0 6a1 1 0 0 1 -1 1", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h7", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesCog = createVueComponent("outline", "devices-cog", "DevicesCog", [["path", { "d": "M13 14.5v-5.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-4" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-5" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-6" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-7" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-8" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-9" }]]);

var IconDevicesDollar = createVueComponent("outline", "devices-dollar", "DevicesDollar", [["path", { "d": "M13 19v-10a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v1.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-4" }]]);

var IconDevicesDown = createVueComponent("outline", "devices-down", "DevicesDown", [["path", { "d": "M13 16.5v-7.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesExclamation = createVueComponent("outline", "devices-exclamation", "DevicesExclamation", [["path", { "d": "M15 20h-1a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M19 16v3", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }]]);

var IconDevicesHeart = createVueComponent("outline", "devices-heart", "DevicesHeart", [["path", { "d": "M13 12v-3a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v2", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h6", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }], ["path", { "d": "M16 9h2", "key": "svg-3" }]]);

var IconDevicesMinus = createVueComponent("outline", "devices-minus", "DevicesMinus", [["path", { "d": "M13 16.5v-7.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M16 9h2", "key": "svg-3" }]]);

var IconDevicesOff = createVueComponent("outline", "devices-off", "DevicesOff", [["path", { "d": "M13 9a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v8m-1 3h-6a1 1 0 0 1 -1 -1v-6", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-9m-4 0a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDevicesPause = createVueComponent("outline", "devices-pause", "DevicesPause", [["path", { "d": "M13 19v-10a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v4", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesPcOff = createVueComponent("outline", "devices-pc-off", "DevicesPcOff", [["path", { "d": "M9 9v10h-6v-14h2", "key": "svg-0" }], ["path", { "d": "M13 9h9v7h-2m-4 0h-4v-4", "key": "svg-1" }], ["path", { "d": "M14 19h5", "key": "svg-2" }], ["path", { "d": "M17 17v2", "key": "svg-3" }], ["path", { "d": "M6 13v.01", "key": "svg-4" }], ["path", { "d": "M6 16v.01", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconDevicesPc = createVueComponent("outline", "devices-pc", "DevicesPc", [["path", { "d": "M3 5h6v14h-6z", "key": "svg-0" }], ["path", { "d": "M12 9h10v7h-10z", "key": "svg-1" }], ["path", { "d": "M14 19h6", "key": "svg-2" }], ["path", { "d": "M17 16v3", "key": "svg-3" }], ["path", { "d": "M6 13v.01", "key": "svg-4" }], ["path", { "d": "M6 16v.01", "key": "svg-5" }]]);

var IconDevicesPin = createVueComponent("outline", "devices-pin", "DevicesPin", [["path", { "d": "M13 14v-5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v2", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesPlus = createVueComponent("outline", "devices-plus", "DevicesPlus", [["path", { "d": "M13 16.5v-7.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconDevicesQuestion = createVueComponent("outline", "devices-question", "DevicesQuestion", [["path", { "d": "M15 20h-1a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v2", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesSearch = createVueComponent("outline", "devices-search", "DevicesSearch", [["path", { "d": "M13 13v-4a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v2.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h7", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesShare = createVueComponent("outline", "devices-share", "DevicesShare", [["path", { "d": "M13 15v-6a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v4", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesStar = createVueComponent("outline", "devices-star", "DevicesStar", [["path", { "d": "M13 13v-4a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v2.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h5.5", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }], ["path", { "d": "M16 9h2", "key": "svg-3" }]]);

var IconDevicesUp = createVueComponent("outline", "devices-up", "DevicesUp", [["path", { "d": "M13 16.5v-7.5a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3.5", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h8", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }], ["path", { "d": "M16 9h2", "key": "svg-4" }]]);

var IconDevicesX = createVueComponent("outline", "devices-x", "DevicesX", [["path", { "d": "M14 20a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v4", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-3" }], ["path", { "d": "M17 22l5 -5", "key": "svg-4" }]]);

var IconDevices = createVueComponent("outline", "devices", "Devices", [["path", { "d": "M13 9a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1v-10z", "key": "svg-0" }], ["path", { "d": "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9", "key": "svg-1" }], ["path", { "d": "M16 9h2", "key": "svg-2" }]]);

var IconDiaboloOff = createVueComponent("outline", "diabolo-off", "DiaboloOff", [["path", { "d": "M4.727 4.749c-.467 .38 -.727 .804 -.727 1.251c0 1.217 1.933 2.265 4.71 2.735m4.257 .243c3.962 -.178 7.033 -1.444 7.033 -2.978c0 -1.657 -3.582 -3 -8 -3c-1.66 0 -3.202 .19 -4.48 .514", "key": "svg-0" }], ["path", { "d": "M4 6v.143a1 1 0 0 0 .048 .307l1.952 5.55l-1.964 5.67a1 1 0 0 0 -.036 .265v.065c0 1.657 3.582 3 8 3c3.218 0 5.992 -.712 7.262 -1.74m-.211 -4.227l-1.051 -3.033l1.952 -5.55a1 1 0 0 0 .048 -.307v-.143", "key": "svg-1" }], ["path", { "d": "M6 12c0 1.105 2.686 2 6 2c.656 0 1.288 -.035 1.879 -.1m3.198 -.834c.585 -.308 .923 -.674 .923 -1.066", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDiaboloPlus = createVueComponent("outline", "diabolo-plus", "DiaboloPlus", [["path", { "d": "M12 6m-8 0a8 3 0 1 0 16 0a8 3 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 6v.143a1 1 0 0 0 .048 .307l1.952 5.55l-1.964 5.67a1 1 0 0 0 -.036 .265v.065c0 1.657 3.582 3 8 3c.17 0 .34 -.002 .508 -.006m5.492 -8.994l1.952 -5.55a1 1 0 0 0 .048 -.307v-.143", "key": "svg-1" }], ["path", { "d": "M6 12c0 1.105 2.686 2 6 2s6 -.895 6 -2", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconDiabolo = createVueComponent("outline", "diabolo", "Diabolo", [["path", { "d": "M12 6m-8 0a8 3 0 1 0 16 0a8 3 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 6v.143a1 1 0 0 0 .048 .307l1.952 5.55l-1.964 5.67a1 1 0 0 0 -.036 .265v.065c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-.065a1 1 0 0 0 -.036 -.265l-1.964 -5.67l1.952 -5.55a1 1 0 0 0 .048 -.307v-.143", "key": "svg-1" }], ["path", { "d": "M6 12c0 1.105 2.686 2 6 2s6 -.895 6 -2", "key": "svg-2" }]]);

var IconDialpadOff = createVueComponent("outline", "dialpad-off", "DialpadOff", [["path", { "d": "M7 7h-4v-4", "key": "svg-0" }], ["path", { "d": "M17 3h4v4h-4z", "key": "svg-1" }], ["path", { "d": "M10 6v-3h4v4h-3", "key": "svg-2" }], ["path", { "d": "M3 10h4v4h-4z", "key": "svg-3" }], ["path", { "d": "M17 13v-3h4v4h-3", "key": "svg-4" }], ["path", { "d": "M14 14h-4v-4", "key": "svg-5" }], ["path", { "d": "M10 17h4v4h-4z", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconDialpad = createVueComponent("outline", "dialpad", "Dialpad", [["path", { "d": "M4 3h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M18 3h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-1" }], ["path", { "d": "M11 3h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-2" }], ["path", { "d": "M4 10h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-3" }], ["path", { "d": "M18 10h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-4" }], ["path", { "d": "M11 10h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-5" }], ["path", { "d": "M11 17h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1z", "key": "svg-6" }]]);

var IconDiamondOff = createVueComponent("outline", "diamond-off", "DiamondOff", [["path", { "d": "M9 5h9l3 5l-3.308 3.697m-1.883 2.104l-3.309 3.699a.7 .7 0 0 1 -1 0l-8.5 -9.5l2.62 -4.368", "key": "svg-0" }], ["path", { "d": "M10 12l-2 -2.2l.6 -1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDiamond = createVueComponent("outline", "diamond", "Diamond", [["path", { "d": "M6 5h12l3 5l-8.5 9.5a.7 .7 0 0 1 -1 0l-8.5 -9.5l3 -5", "key": "svg-0" }], ["path", { "d": "M10 12l-2 -2.2l.6 -1", "key": "svg-1" }]]);

var IconDiamonds = createVueComponent("outline", "diamonds", "Diamonds", [["path", { "d": "M10.831 20.413l-5.375 -6.91c-.608 -.783 -.608 -2.223 0 -3l5.375 -6.911a1.457 1.457 0 0 1 2.338 0l5.375 6.91c.608 .783 .608 2.223 0 3l-5.375 6.911a1.457 1.457 0 0 1 -2.338 0z", "key": "svg-0" }]]);

var IconDiaper = createVueComponent("outline", "diaper", "Diaper", [["path", { "d": "M3 8.323c0 -.579 0 -.868 .044 -1.11a2.7 2.7 0 0 1 2.17 -2.169c.239 -.044 .529 -.044 1.109 -.044h11.353c.579 0 .868 0 1.11 .044a2.7 2.7 0 0 1 2.169 2.17c.044 .24 .044 .53 .044 1.11v2.676a9 9 0 0 1 -18 0z", "key": "svg-0" }], ["path", { "d": "M17 9h4", "key": "svg-1" }], ["path", { "d": "M3 9h4", "key": "svg-2" }], ["path", { "d": "M14.25 19.7v-1.4a6.3 6.3 0 0 1 6.3 -6.3", "key": "svg-3" }], ["path", { "d": "M9.75 19.7v-1.4a6.3 6.3 0 0 0 -6.3 -6.3", "key": "svg-4" }]]);

var IconDice1 = createVueComponent("outline", "dice-1", "Dice1", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "12", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-1" }]]);

var IconDice2 = createVueComponent("outline", "dice-2", "Dice2", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "9.5", "cy": "9.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "14.5", "cy": "14.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }]]);

var IconDice3 = createVueComponent("outline", "dice-3", "Dice3", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "8.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "15.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "12", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-3" }]]);

var IconDice4 = createVueComponent("outline", "dice-4", "Dice4", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "8.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "15.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "15.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-3" }], ["circle", { "cx": "8.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-4" }]]);

var IconDice5 = createVueComponent("outline", "dice-5", "Dice5", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "8.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "15.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "15.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-3" }], ["circle", { "cx": "8.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-4" }], ["circle", { "cx": "12", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-5" }]]);

var IconDice6 = createVueComponent("outline", "dice-6", "Dice6", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "8.5", "cy": "7.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "15.5", "cy": "7.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "8.5", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-3" }], ["circle", { "cx": "15.5", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-4" }], ["circle", { "cx": "15.5", "cy": "16.5", "r": ".5", "fill": "currentColor", "key": "svg-5" }], ["circle", { "cx": "8.5", "cy": "16.5", "r": ".5", "fill": "currentColor", "key": "svg-6" }]]);

var IconDice = createVueComponent("outline", "dice", "Dice", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["circle", { "cx": "8.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "15.5", "cy": "8.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "15.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-3" }], ["circle", { "cx": "8.5", "cy": "15.5", "r": ".5", "fill": "currentColor", "key": "svg-4" }]]);

var IconDimensions = createVueComponent("outline", "dimensions", "Dimensions", [["path", { "d": "M3 5h11", "key": "svg-0" }], ["path", { "d": "M12 7l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M5 3l-2 2l2 2", "key": "svg-2" }], ["path", { "d": "M19 10v11", "key": "svg-3" }], ["path", { "d": "M17 19l2 2l2 -2", "key": "svg-4" }], ["path", { "d": "M21 12l-2 -2l-2 2", "key": "svg-5" }], ["path", { "d": "M3 10m0 2a2 2 0 0 1 2 -2h7a2 2 0 0 1 2 2v7a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2z", "key": "svg-6" }]]);

var IconDirectionArrows = createVueComponent("outline", "direction-arrows", "DirectionArrows", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 11l-1 1l1 1", "key": "svg-1" }], ["path", { "d": "M11 8l1 -1l1 1", "key": "svg-2" }], ["path", { "d": "M16 11l1 1l-1 1", "key": "svg-3" }], ["path", { "d": "M11 16l1 1l1 -1", "key": "svg-4" }]]);

var IconDirectionHorizontal = createVueComponent("outline", "direction-horizontal", "DirectionHorizontal", [["path", { "d": "M10 9l-3 3l3 3", "key": "svg-0" }], ["path", { "d": "M14 9l3 3l-3 3", "key": "svg-1" }]]);

var IconDirectionSignOff = createVueComponent("outline", "direction-sign-off", "DirectionSignOff", [["path", { "d": "M18.73 14.724l1.949 -1.95a1.095 1.095 0 0 0 0 -1.548l-7.905 -7.905a1.095 1.095 0 0 0 -1.548 0l-1.95 1.95m-2.01 2.01l-3.945 3.945a1.095 1.095 0 0 0 0 1.548l7.905 7.905c.427 .428 1.12 .428 1.548 0l3.95 -3.95", "key": "svg-0" }], ["path", { "d": "M8 12h4", "key": "svg-1" }], ["path", { "d": "M13.748 13.752l-1.748 1.748", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDirectionSign = createVueComponent("outline", "direction-sign", "DirectionSign", [["path", { "d": "M3.32 12.774l7.906 7.905c.427 .428 1.12 .428 1.548 0l7.905 -7.905a1.095 1.095 0 0 0 0 -1.548l-7.905 -7.905a1.095 1.095 0 0 0 -1.548 0l-7.905 7.905a1.095 1.095 0 0 0 0 1.548z", "key": "svg-0" }], ["path", { "d": "M8 12h7.5", "key": "svg-1" }], ["path", { "d": "M12 8.5l3.5 3.5l-3.5 3.5", "key": "svg-2" }]]);

var IconDirection = createVueComponent("outline", "direction", "Direction", [["path", { "d": "M9 10l3 -3l3 3", "key": "svg-0" }], ["path", { "d": "M9 14l3 3l3 -3", "key": "svg-1" }]]);

var IconDirectionsOff = createVueComponent("outline", "directions-off", "DirectionsOff", [["path", { "d": "M12 21v-4", "key": "svg-0" }], ["path", { "d": "M12 13v-1", "key": "svg-1" }], ["path", { "d": "M12 5v-2", "key": "svg-2" }], ["path", { "d": "M10 21h4", "key": "svg-3" }], ["path", { "d": "M8 8v1h1m4 0h6l2 -2l-2 -2h-10", "key": "svg-4" }], ["path", { "d": "M14 14v3h-8l-2 -2l2 -2h7", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconDirections = createVueComponent("outline", "directions", "Directions", [["path", { "d": "M12 21v-4", "key": "svg-0" }], ["path", { "d": "M12 13v-4", "key": "svg-1" }], ["path", { "d": "M12 5v-2", "key": "svg-2" }], ["path", { "d": "M10 21h4", "key": "svg-3" }], ["path", { "d": "M8 5v4h11l2 -2l-2 -2z", "key": "svg-4" }], ["path", { "d": "M14 13v4h-8l-2 -2l2 -2z", "key": "svg-5" }]]);

var IconDisabled2 = createVueComponent("outline", "disabled-2", "Disabled2", [["path", { "d": "M17 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M9 11a5 5 0 1 0 3.95 7.95", "key": "svg-1" }], ["path", { "d": "M19 20l-4 -5h-4l3 -5l-4 -3l-4 1", "key": "svg-2" }]]);

var IconDisabledOff = createVueComponent("outline", "disabled-off", "DisabledOff", [["path", { "d": "M11 7a2 2 0 1 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M11 11v4h4l4 5", "key": "svg-1" }], ["path", { "d": "M15 11h1", "key": "svg-2" }], ["path", { "d": "M7 11.5a5 5 0 1 0 6 7.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDisabled = createVueComponent("outline", "disabled", "Disabled", [["path", { "d": "M11 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11 7l0 8l4 0l4 5", "key": "svg-1" }], ["path", { "d": "M11 11l5 0", "key": "svg-2" }], ["path", { "d": "M7 11.5a5 5 0 1 0 6 7.5", "key": "svg-3" }]]);

var IconDiscGolf = createVueComponent("outline", "disc-golf", "DiscGolf", [["path", { "d": "M5 5h14", "key": "svg-0" }], ["path", { "d": "M6 5c.32 6.744 2.74 9.246 6 10", "key": "svg-1" }], ["path", { "d": "M18 5c-.32 6.744 -2.74 9.246 -6 10", "key": "svg-2" }], ["path", { "d": "M10 5c0 4.915 .552 7.082 2 10", "key": "svg-3" }], ["path", { "d": "M14 5c0 4.915 -.552 7.082 -2 10", "key": "svg-4" }], ["path", { "d": "M12 15v6", "key": "svg-5" }], ["path", { "d": "M12 3v2", "key": "svg-6" }], ["path", { "d": "M7 16c.64 .64 1.509 1 2.414 1h5.172c.905 0 1.774 -.36 2.414 -1", "key": "svg-7" }], ["path", { "d": "M11 21h2", "key": "svg-8" }]]);

var IconDiscOff = createVueComponent("outline", "disc-off", "DiscOff", [["path", { "d": "M20.044 16.04a9 9 0 0 0 -12.082 -12.085m-2.333 1.688a9 9 0 0 0 6.371 15.357c2.491 0 4.73 -1 6.36 -2.631", "key": "svg-0" }], ["path", { "d": "M11.298 11.288a1 1 0 1 0 1.402 1.427", "key": "svg-1" }], ["path", { "d": "M7 12c0 -1.38 .559 -2.629 1.462 -3.534m2.607 -1.38c.302 -.056 .613 -.086 .931 -.086", "key": "svg-2" }], ["path", { "d": "M12 17a4.985 4.985 0 0 0 3.551 -1.48m1.362 -2.587c.057 -.302 .087 -.614 .087 -.933", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDisc = createVueComponent("outline", "disc", "Disc", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M7 12a5 5 0 0 1 5 -5", "key": "svg-2" }], ["path", { "d": "M12 17a5 5 0 0 0 5 -5", "key": "svg-3" }]]);

var IconDiscountOff = createVueComponent("outline", "discount-off", "DiscountOff", [["path", { "d": "M9 15l3 -3m2 -2l1 -1", "key": "svg-0" }], ["path", { "d": "M9.148 9.145a.498 .498 0 0 0 .352 .855a.5 .5 0 0 0 .35 -.142", "key": "svg-1" }], ["path", { "d": "M14.148 14.145a.498 .498 0 0 0 .352 .855a.5 .5 0 0 0 .35 -.142", "key": "svg-2" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDiscount = createVueComponent("outline", "discount", "Discount", [["path", { "d": "M9 15l6 -6", "key": "svg-0" }], ["circle", { "cx": "9.5", "cy": "9.5", "r": ".5", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "14.5", "cy": "14.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-3" }]]);

var IconDivide = createVueComponent("outline", "divide", "Divide", [["circle", { "cx": "12", "cy": "6", "r": "1", "fill": "currentColor", "key": "svg-0" }], ["circle", { "cx": "12", "cy": "18", "r": "1", "fill": "currentColor", "key": "svg-1" }], ["path", { "d": "M5 12l14 0", "key": "svg-2" }]]);

var IconDna2Off = createVueComponent("outline", "dna-2-off", "Dna2Off", [["path", { "d": "M17 3v1c-.007 2.46 -.91 4.554 -2.705 6.281m-2.295 1.719c-3.328 1.99 -5 4.662 -5.008 8.014v1", "key": "svg-0" }], ["path", { "d": "M17 21.014v-1c0 -1.44 -.315 -2.755 -.932 -3.944m-4.068 -4.07c-1.903 -1.138 -3.263 -2.485 -4.082 -4.068", "key": "svg-1" }], ["path", { "d": "M8 4h9", "key": "svg-2" }], ["path", { "d": "M7 20h10", "key": "svg-3" }], ["path", { "d": "M12 8h4", "key": "svg-4" }], ["path", { "d": "M8 16h8", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconDna2 = createVueComponent("outline", "dna-2", "Dna2", [["path", { "d": "M17 3v1c-.01 3.352 -1.68 6.023 -5.008 8.014c-3.328 1.99 3.336 -2 .008 -.014c-3.328 1.99 -5 4.662 -5.008 8.014v1", "key": "svg-0" }], ["path", { "d": "M17 21.014v-1c-.01 -3.352 -1.68 -6.023 -5.008 -8.014c-3.328 -1.99 3.336 2 .008 .014c-3.328 -1.991 -5 -4.662 -5.008 -8.014v-1", "key": "svg-1" }], ["path", { "d": "M7 4h10", "key": "svg-2" }], ["path", { "d": "M7 20h10", "key": "svg-3" }], ["path", { "d": "M8 8h8", "key": "svg-4" }], ["path", { "d": "M8 16h8", "key": "svg-5" }]]);

var IconDnaOff = createVueComponent("outline", "dna-off", "DnaOff", [["path", { "d": "M16 12a3.898 3.898 0 0 0 -1.172 -2.828a4.027 4.027 0 0 0 -2.828 -1.172m-2.828 1.172a4 4 0 1 0 5.656 5.656", "key": "svg-0" }], ["path", { "d": "M9.172 20.485a4 4 0 1 0 -5.657 -5.657", "key": "svg-1" }], ["path", { "d": "M14.828 3.515a4 4 0 1 0 5.657 5.657", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDna = createVueComponent("outline", "dna", "Dna", [["path", { "d": "M14.828 14.828a4 4 0 1 0 -5.656 -5.656a4 4 0 0 0 5.656 5.656z", "key": "svg-0" }], ["path", { "d": "M9.172 20.485a4 4 0 1 0 -5.657 -5.657", "key": "svg-1" }], ["path", { "d": "M14.828 3.515a4 4 0 0 0 5.657 5.657", "key": "svg-2" }]]);

var IconDogBowl = createVueComponent("outline", "dog-bowl", "DogBowl", [["path", { "d": "M10 15l5.586 -5.585a2 2 0 1 1 3.414 -1.415a2 2 0 1 1 -1.413 3.414l-3.587 3.586", "key": "svg-0" }], ["path", { "d": "M12 13l-3.586 -3.585a2 2 0 1 0 -3.414 -1.415a2 2 0 1 0 1.413 3.414l3.587 3.586", "key": "svg-1" }], ["path", { "d": "M3 20h18c-.175 -1.671 -.046 -3.345 -2 -5h-14c-1.333 1 -2 2.667 -2 5z", "key": "svg-2" }]]);

var IconDog = createVueComponent("outline", "dog", "Dog", [["path", { "d": "M11 5h2", "key": "svg-0" }], ["path", { "d": "M19 12c-.667 5.333 -2.333 8 -5 8h-4c-2.667 0 -4.333 -2.667 -5 -8", "key": "svg-1" }], ["path", { "d": "M11 16c0 .667 .333 1 1 1s1 -.333 1 -1h-2z", "key": "svg-2" }], ["path", { "d": "M12 18v2", "key": "svg-3" }], ["path", { "d": "M10 11v.01", "key": "svg-4" }], ["path", { "d": "M14 11v.01", "key": "svg-5" }], ["path", { "d": "M5 4l6 .97l-6.238 6.688a1.021 1.021 0 0 1 -1.41 .111a.953 .953 0 0 1 -.327 -.954l1.975 -6.815z", "key": "svg-6" }], ["path", { "d": "M19 4l-6 .97l6.238 6.688c.358 .408 .989 .458 1.41 .111a.953 .953 0 0 0 .327 -.954l-1.975 -6.815z", "key": "svg-7" }]]);

var IconDoorEnter = createVueComponent("outline", "door-enter", "DoorEnter", [["path", { "d": "M13 12v.01", "key": "svg-0" }], ["path", { "d": "M3 21h18", "key": "svg-1" }], ["path", { "d": "M5 21v-16a2 2 0 0 1 2 -2h6m4 10.5v7.5", "key": "svg-2" }], ["path", { "d": "M21 7h-7m3 -3l-3 3l3 3", "key": "svg-3" }]]);

var IconDoorExit = createVueComponent("outline", "door-exit", "DoorExit", [["path", { "d": "M13 12v.01", "key": "svg-0" }], ["path", { "d": "M3 21h18", "key": "svg-1" }], ["path", { "d": "M5 21v-16a2 2 0 0 1 2 -2h7.5m2.5 10.5v7.5", "key": "svg-2" }], ["path", { "d": "M14 7h7m-3 -3l3 3l-3 3", "key": "svg-3" }]]);

var IconDoorOff = createVueComponent("outline", "door-off", "DoorOff", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M6 21v-15", "key": "svg-1" }], ["path", { "d": "M7.18 3.175c.25 -.112 .528 -.175 .82 -.175h8a2 2 0 0 1 2 2v9", "key": "svg-2" }], ["path", { "d": "M18 18v3", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDoor = createVueComponent("outline", "door", "Door", [["path", { "d": "M14 12v.01", "key": "svg-0" }], ["path", { "d": "M3 21h18", "key": "svg-1" }], ["path", { "d": "M6 21v-16a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v16", "key": "svg-2" }]]);

var IconDotsCircleHorizontal = createVueComponent("outline", "dots-circle-horizontal", "DotsCircleHorizontal", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 12l0 .01", "key": "svg-1" }], ["path", { "d": "M12 12l0 .01", "key": "svg-2" }], ["path", { "d": "M16 12l0 .01", "key": "svg-3" }]]);

var IconDotsDiagonal2 = createVueComponent("outline", "dots-diagonal-2", "DotsDiagonal2", [["path", { "d": "M7 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M17 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconDotsDiagonal = createVueComponent("outline", "dots-diagonal", "DotsDiagonal", [["path", { "d": "M7 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M17 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconDotsVertical = createVueComponent("outline", "dots-vertical", "DotsVertical", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M12 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconDots = createVueComponent("outline", "dots", "Dots", [["path", { "d": "M5 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M19 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconDownloadOff = createVueComponent("outline", "download-off", "DownloadOff", [["path", { "d": "M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 1.83 -1.19", "key": "svg-0" }], ["path", { "d": "M7 11l5 5l2 -2m2 -2l1 -1", "key": "svg-1" }], ["path", { "d": "M12 4v4m0 4v4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDownload = createVueComponent("outline", "download", "Download", [["path", { "d": "M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2", "key": "svg-0" }], ["path", { "d": "M7 11l5 5l5 -5", "key": "svg-1" }], ["path", { "d": "M12 4l0 12", "key": "svg-2" }]]);

var IconDragDrop2 = createVueComponent("outline", "drag-drop-2", "DragDrop2", [["path", { "d": "M8 8m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M4 12l0 .01", "key": "svg-6" }], ["path", { "d": "M4 16l0 .01", "key": "svg-7" }]]);

var IconDragDrop = createVueComponent("outline", "drag-drop", "DragDrop", [["path", { "d": "M19 11v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2", "key": "svg-0" }], ["path", { "d": "M13 13l9 3l-4 2l-2 4l-3 -9", "key": "svg-1" }], ["path", { "d": "M3 3l0 .01", "key": "svg-2" }], ["path", { "d": "M7 3l0 .01", "key": "svg-3" }], ["path", { "d": "M11 3l0 .01", "key": "svg-4" }], ["path", { "d": "M15 3l0 .01", "key": "svg-5" }], ["path", { "d": "M3 7l0 .01", "key": "svg-6" }], ["path", { "d": "M3 11l0 .01", "key": "svg-7" }], ["path", { "d": "M3 15l0 .01", "key": "svg-8" }]]);

var IconDroneOff = createVueComponent("outline", "drone-off", "DroneOff", [["path", { "d": "M14 14h-4v-4", "key": "svg-0" }], ["path", { "d": "M10 10l-3.5 -3.5", "key": "svg-1" }], ["path", { "d": "M9.957 5.95a3.503 3.503 0 0 0 -2.917 -2.91m-3.02 .989a3.5 3.5 0 0 0 1.98 5.936", "key": "svg-2" }], ["path", { "d": "M14 10l3.5 -3.5", "key": "svg-3" }], ["path", { "d": "M18 9.965a3.5 3.5 0 1 0 -3.966 -3.965", "key": "svg-4" }], ["path", { "d": "M14 14l3.5 3.5", "key": "svg-5" }], ["path", { "d": "M14.035 18a3.5 3.5 0 0 0 5.936 1.98m.987 -3.026a3.503 3.503 0 0 0 -2.918 -2.913", "key": "svg-6" }], ["path", { "d": "M10 14l-3.5 3.5", "key": "svg-7" }], ["path", { "d": "M6 14.035a3.5 3.5 0 1 0 3.966 3.965", "key": "svg-8" }], ["path", { "d": "M3 3l18 18", "key": "svg-9" }]]);

var IconDrone = createVueComponent("outline", "drone", "Drone", [["path", { "d": "M10 10h4v4h-4z", "key": "svg-0" }], ["path", { "d": "M10 10l-3.5 -3.5", "key": "svg-1" }], ["path", { "d": "M9.96 6a3.5 3.5 0 1 0 -3.96 3.96", "key": "svg-2" }], ["path", { "d": "M14 10l3.5 -3.5", "key": "svg-3" }], ["path", { "d": "M18 9.96a3.5 3.5 0 1 0 -3.96 -3.96", "key": "svg-4" }], ["path", { "d": "M14 14l3.5 3.5", "key": "svg-5" }], ["path", { "d": "M14.04 18a3.5 3.5 0 1 0 3.96 -3.96", "key": "svg-6" }], ["path", { "d": "M10 14l-3.5 3.5", "key": "svg-7" }], ["path", { "d": "M6 14.04a3.5 3.5 0 1 0 3.96 3.96", "key": "svg-8" }]]);

var IconDropCircle = createVueComponent("outline", "drop-circle", "DropCircle", [["path", { "d": "M10.07 15.34c1.115 .88 2.74 .88 3.855 0c1.115 -.88 1.398 -2.388 .671 -3.575l-2.596 -3.765l-2.602 3.765c-.726 1.187 -.443 2.694 .672 3.575z", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconDropletBolt = createVueComponent("outline", "droplet-bolt", "DropletBolt", [["path", { "d": "M18.628 12.076a6.653 6.653 0 0 0 -.564 -1.199l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546c1.7 1.375 3.906 1.852 5.958 1.431", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }]]);

var IconDropletCancel = createVueComponent("outline", "droplet-cancel", "DropletCancel", [["path", { "d": "M18.606 12.014a6.659 6.659 0 0 0 -.542 -1.137l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.154 7.154 0 0 0 4.826 1.572", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }]]);

var IconDropletCheck = createVueComponent("outline", "droplet-check", "DropletCheck", [["path", { "d": "M18.967 13.594a6.568 6.568 0 0 0 -.903 -2.717l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.125 7.125 0 0 0 4.04 1.565", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }]]);

var IconDropletCode = createVueComponent("outline", "droplet-code", "DropletCode", [["path", { "d": "M18.907 13.147a6.586 6.586 0 0 0 -.843 -2.27l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.123 7.123 0 0 0 3.99 1.561", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }]]);

var IconDropletCog = createVueComponent("outline", "droplet-cog", "DropletCog", [["path", { "d": "M18.421 11.56a6.702 6.702 0 0 0 -.357 -.683l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.144 7.144 0 0 0 4.518 1.58", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }]]);

var IconDropletDollar = createVueComponent("outline", "droplet-dollar", "DropletDollar", [["path", { "d": "M17.668 10.29l-4.493 -6.673c-.421 -.625 -1.288 -.803 -1.937 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.175 7.175 0 0 0 5.493 1.51", "key": "svg-0" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-1" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-2" }]]);

var IconDropletDown = createVueComponent("outline", "droplet-down", "DropletDown", [["path", { "d": "M18.602 12.003a6.66 6.66 0 0 0 -.538 -1.126l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.159 7.159 0 0 0 4.972 1.564", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }]]);

var IconDropletExclamation = createVueComponent("outline", "droplet-exclamation", "DropletExclamation", [["path", { "d": "M18.602 12.004a6.66 6.66 0 0 0 -.538 -1.127l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546c2.142 1.734 5.092 2.04 7.519 .919", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconDropletHalf2 = createVueComponent("outline", "droplet-half-2", "DropletHalf2", [["path", { "d": "M7.502 19.423c2.602 2.105 6.395 2.105 8.996 0c2.602 -2.105 3.262 -5.708 1.566 -8.546l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546z", "key": "svg-0" }], ["path", { "d": "M5 14h14", "key": "svg-1" }]]);

var IconDropletHalf = createVueComponent("outline", "droplet-half", "DropletHalf", [["path", { "d": "M7.502 19.423c2.602 2.105 6.395 2.105 8.996 0c2.602 -2.105 3.262 -5.708 1.566 -8.546l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546z", "key": "svg-0" }], ["path", { "d": "M12 3v18", "key": "svg-1" }]]);

var IconDropletHeart = createVueComponent("outline", "droplet-heart", "DropletHeart", [["path", { "d": "M18.288 11.282a6.734 6.734 0 0 0 -.224 -.405l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.117 7.117 0 0 0 3.824 1.548", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }]]);

var IconDropletMinus = createVueComponent("outline", "droplet-minus", "DropletMinus", [["path", { "d": "M18.946 15.083a6.538 6.538 0 0 0 -.882 -4.206l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.163 7.163 0 0 0 5.089 1.555", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconDropletOff = createVueComponent("outline", "droplet-off", "DropletOff", [["path", { "d": "M18.963 14.938a6.54 6.54 0 0 0 -.899 -4.06l-4.89 -7.26c-.42 -.626 -1.287 -.804 -1.936 -.398a1.376 1.376 0 0 0 -.41 .397l-1.282 1.9m-1.625 2.415l-1.986 2.946c-1.695 2.837 -1.035 6.44 1.567 8.545c2.602 2.105 6.395 2.105 8.996 0a6.83 6.83 0 0 0 1.376 -1.499", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconDropletPause = createVueComponent("outline", "droplet-pause", "DropletPause", [["path", { "d": "M18.952 13.456a6.573 6.573 0 0 0 -.888 -2.579l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.176 7.176 0 0 0 5.517 1.507", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }]]);

var IconDropletPin = createVueComponent("outline", "droplet-pin", "DropletPin", [["path", { "d": "M18.064 10.877l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.163 7.163 0 0 0 5.102 1.554", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }]]);

var IconDropletPlus = createVueComponent("outline", "droplet-plus", "DropletPlus", [["path", { "d": "M18.602 12.004a6.66 6.66 0 0 0 -.538 -1.127l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.16 7.16 0 0 0 5.033 1.56", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconDropletQuestion = createVueComponent("outline", "droplet-question", "DropletQuestion", [["path", { "d": "M18.064 10.877l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546c2.203 1.782 5.259 2.056 7.723 .82", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconDropletSearch = createVueComponent("outline", "droplet-search", "DropletSearch", [["path", { "d": "M18.064 10.877l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.13 7.13 0 0 0 4.168 1.572", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }]]);

var IconDropletShare = createVueComponent("outline", "droplet-share", "DropletShare", [["path", { "d": "M18.884 13.025a6.591 6.591 0 0 0 -.82 -2.148l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.125 7.125 0 0 0 4.498 1.58", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }]]);

var IconDropletStar = createVueComponent("outline", "droplet-star", "DropletStar", [["path", { "d": "M17.496 10.034l-4.321 -6.417c-.421 -.625 -1.288 -.803 -1.937 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.106 7.106 0 0 0 3.547 1.517", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }]]);

var IconDropletUp = createVueComponent("outline", "droplet-up", "DropletUp", [["path", { "d": "M18.6 11.998a6.66 6.66 0 0 0 -.536 -1.12l-4.89 -7.26c-.42 -.626 -1.287 -.804 -1.936 -.398a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.16 7.16 0 0 0 5.002 1.562", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }]]);

var IconDropletX = createVueComponent("outline", "droplet-x", "DropletX", [["path", { "d": "M18.953 13.467a6.572 6.572 0 0 0 -.889 -2.59l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.179 7.179 0 0 0 5.633 1.49", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconDroplet = createVueComponent("outline", "droplet", "Droplet", [["path", { "d": "M7.502 19.423c2.602 2.105 6.395 2.105 8.996 0c2.602 -2.105 3.262 -5.708 1.566 -8.546l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546z", "key": "svg-0" }]]);

var IconDroplets = createVueComponent("outline", "droplets", "Droplets", [["path", { "d": "M4.072 20.3a2.999 2.999 0 0 0 3.856 0a3.002 3.002 0 0 0 .67 -3.798l-2.095 -3.227a.6 .6 0 0 0 -1.005 0l-2.098 3.227a3.003 3.003 0 0 0 .671 3.798z", "key": "svg-0" }], ["path", { "d": "M16.072 20.3a2.999 2.999 0 0 0 3.856 0a3.002 3.002 0 0 0 .67 -3.798l-2.095 -3.227a.6 .6 0 0 0 -1.005 0l-2.098 3.227a3.003 3.003 0 0 0 .671 3.798z", "key": "svg-1" }], ["path", { "d": "M10.072 10.3a2.999 2.999 0 0 0 3.856 0a3.002 3.002 0 0 0 .67 -3.798l-2.095 -3.227a.6 .6 0 0 0 -1.005 0l-2.098 3.227a3.003 3.003 0 0 0 .671 3.798z", "key": "svg-2" }]]);

var IconDualScreen = createVueComponent("outline", "dual-screen", "DualScreen", [["path", { "d": "M5 4l8 3v15l-8 -3z", "key": "svg-0" }], ["path", { "d": "M13 19h6v-15h-14", "key": "svg-1" }]]);

var IconDumpling = createVueComponent("outline", "dumpling", "Dumpling", [["path", { "d": "M5.532 5.532a2.53 2.53 0 0 1 2.56 -.623a2.532 2.532 0 0 1 4.604 -.717q .146 -.24 .356 -.45a2.532 2.532 0 0 1 4.318 1.637a2.53 2.53 0 0 1 2.844 .511l.358 .358c1.384 1.385 -.7 5.713 -4.655 9.669c-3.956 3.955 -8.284 6.04 -9.669 4.655l-.358 -.358l-.114 -.122a2.53 2.53 0 0 1 -.398 -2.724a2.532 2.532 0 0 1 -1.186 -4.675a2.532 2.532 0 0 1 .718 -4.603a2.53 2.53 0 0 1 .622 -2.558", "key": "svg-0" }]]);

var IconEPassport = createVueComponent("outline", "e-passport", "EPassport", [["path", { "d": "M2 5m0 2a2 2 0 0 1 2 -2h16a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-16a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M9 12h-7", "key": "svg-2" }], ["path", { "d": "M15 12h7", "key": "svg-3" }]]);

var IconEarOff = createVueComponent("outline", "ear-off", "EarOff", [["path", { "d": "M6 10c0 -1.146 .277 -2.245 .78 -3.219m1.792 -2.208a7 7 0 0 1 10.428 9.027a10 10 0 0 1 -.633 .762m-2.045 1.96a8 8 0 0 0 -1.322 2.278a4.5 4.5 0 0 1 -6.8 1.4", "key": "svg-0" }], ["path", { "d": "M11.42 7.414a3 3 0 0 1 4.131 4.13", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconEarScan = createVueComponent("outline", "ear-scan", "EarScan", [["path", { "d": "M15 15a2 2 0 0 1 -2 2c-.732 0 -1.555 -.247 -1.72 -.98c-.634 -2.8 -3.17 -2.628 -3.28 -5.02v-.5a3.5 3.5 0 0 1 6.671 -1.483", "key": "svg-0" }], ["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-2" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-3" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-4" }], ["path", { "d": "M13 12v.01", "key": "svg-5" }]]);

var IconEar = createVueComponent("outline", "ear", "Ear", [["path", { "d": "M6 10a7 7 0 1 1 13 3.6a10 10 0 0 1 -2 2a8 8 0 0 0 -2 3a4.5 4.5 0 0 1 -6.8 1.4", "key": "svg-0" }], ["path", { "d": "M10 10a3 3 0 1 1 5 2.2", "key": "svg-1" }]]);

var IconEaseInControlPoint = createVueComponent("outline", "ease-in-control-point", "EaseInControlPoint", [["path", { "d": "M3 19c8 0 18 -16 18 -16", "key": "svg-0" }], ["path", { "d": "M17 19a2 2 0 1 0 4 0a2 2 0 0 0 -4 0z", "key": "svg-1" }], ["path", { "d": "M17 19h-2", "key": "svg-2" }], ["path", { "d": "M12 19h-2", "key": "svg-3" }]]);

var IconEaseInOutControlPoints = createVueComponent("outline", "ease-in-out-control-points", "EaseInOutControlPoints", [["path", { "d": "M17 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0z", "key": "svg-0" }], ["path", { "d": "M17 20h-2", "key": "svg-1" }], ["path", { "d": "M7 4a2 2 0 1 1 -4 0a2 2 0 0 1 4 0z", "key": "svg-2" }], ["path", { "d": "M7 4h2", "key": "svg-3" }], ["path", { "d": "M14 4h-2", "key": "svg-4" }], ["path", { "d": "M12 20h-2", "key": "svg-5" }], ["path", { "d": "M3 20c8 0 10 -16 18 -16", "key": "svg-6" }]]);

var IconEaseInOut = createVueComponent("outline", "ease-in-out", "EaseInOut", [["path", { "d": "M3 20c8 0 10 -16 18 -16", "key": "svg-0" }]]);

var IconEaseIn = createVueComponent("outline", "ease-in", "EaseIn", [["path", { "d": "M3 20c8 0 18 -16 18 -16", "key": "svg-0" }]]);

var IconEaseOutControlPoint = createVueComponent("outline", "ease-out-control-point", "EaseOutControlPoint", [["path", { "d": "M3 21s10 -16 18 -16", "key": "svg-0" }], ["path", { "d": "M7 5a2 2 0 1 1 -4 0a2 2 0 0 1 4 0z", "key": "svg-1" }], ["path", { "d": "M7 5h2", "key": "svg-2" }], ["path", { "d": "M14 5h-2", "key": "svg-3" }]]);

var IconEaseOut = createVueComponent("outline", "ease-out", "EaseOut", [["path", { "d": "M3 20s10 -16 18 -16", "key": "svg-0" }]]);

var IconEditCircleOff = createVueComponent("outline", "edit-circle-off", "EditCircleOff", [["path", { "d": "M10.507 10.498l-1.507 1.502v3h3l1.493 -1.498m2 -2.01l4.89 -4.907a2.1 2.1 0 0 0 -2.97 -2.97l-4.913 4.896", "key": "svg-0" }], ["path", { "d": "M16 5l3 3", "key": "svg-1" }], ["path", { "d": "M7.476 7.471a7 7 0 0 0 2.524 13.529a7 7 0 0 0 6.53 -4.474", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconEditCircle = createVueComponent("outline", "edit-circle", "EditCircle", [["path", { "d": "M12 15l8.385 -8.415a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3z", "key": "svg-0" }], ["path", { "d": "M16 5l3 3", "key": "svg-1" }], ["path", { "d": "M9 7.07a7 7 0 0 0 1 13.93a7 7 0 0 0 6.929 -6", "key": "svg-2" }]]);

var IconEditOff = createVueComponent("outline", "edit-off", "EditOff", [["path", { "d": "M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1", "key": "svg-0" }], ["path", { "d": "M10.507 10.498l-1.507 1.502v3h3l1.493 -1.498m2 -2.01l4.89 -4.907a2.1 2.1 0 0 0 -2.97 -2.97l-4.913 4.896", "key": "svg-1" }], ["path", { "d": "M16 5l3 3", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconEdit = createVueComponent("outline", "edit", "Edit", [["path", { "d": "M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1", "key": "svg-0" }], ["path", { "d": "M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z", "key": "svg-1" }], ["path", { "d": "M16 5l3 3", "key": "svg-2" }]]);

var IconEggCracked = createVueComponent("outline", "egg-cracked", "EggCracked", [["path", { "d": "M19 14.083c0 4.154 -2.966 6.74 -7 6.917c-4.2 0 -7 -2.763 -7 -6.917c0 -5.538 3.5 -11.09 7 -11.083c3.5 .007 7 5.545 7 11.083z", "key": "svg-0" }], ["path", { "d": "M12 3l-1.5 5l3.5 2.5l-2 3.5", "key": "svg-1" }]]);

var IconEggFried = createVueComponent("outline", "egg-fried", "EggFried", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M14 3a5 5 0 0 1 4.872 6.13a3 3 0 0 1 .178 5.681a3 3 0 1 1 -4.684 3.626a5 5 0 1 1 -8.662 -5a5 5 0 1 1 4.645 -8.856a4.982 4.982 0 0 1 3.651 -1.585z", "key": "svg-1" }]]);

var IconEggOff = createVueComponent("outline", "egg-off", "EggOff", [["path", { "d": "M17.927 17.934c-1.211 1.858 -3.351 2.953 -5.927 3.066c-4.2 0 -7 -2.763 -7 -6.917c0 -2.568 .753 -5.14 1.91 -7.158", "key": "svg-0" }], ["path", { "d": "M8.642 4.628c1.034 -1.02 2.196 -1.63 3.358 -1.628c3.5 .007 7 5.545 7 11.083c0 .298 -.015 .587 -.045 .868", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconEgg = createVueComponent("outline", "egg", "Egg", [["path", { "d": "M19 14.083c0 4.154 -2.966 6.74 -7 6.917c-4.2 0 -7 -2.763 -7 -6.917c0 -5.538 3.5 -11.09 7 -11.083c3.5 .007 7 5.545 7 11.083z", "key": "svg-0" }]]);

var IconEggs = createVueComponent("outline", "eggs", "Eggs", [["path", { "d": "M13 22c-3 0 -4.868 -2.118 -5 -5c0 -3 2 -5 5 -5c4 0 8.01 2.5 8 5c0 2.5 -4 5 -8 5z", "key": "svg-0" }], ["path", { "d": "M8 18c-3.03 -.196 -5 -2.309 -5 -5.38c0 -4.307 2.75 -8.625 5.5 -8.62c2.614 0 5.248 3.915 5.5 8", "key": "svg-1" }]]);

var IconElevatorOff = createVueComponent("outline", "elevator-off", "ElevatorOff", [["path", { "d": "M8 4h10a1 1 0 0 1 1 1v10m0 4a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-14", "key": "svg-0" }], ["path", { "d": "M12 8l2 2", "key": "svg-1" }], ["path", { "d": "M10 14l2 2l2 -2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconElevator = createVueComponent("outline", "elevator", "Elevator", [["path", { "d": "M5 4m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M10 10l2 -2l2 2", "key": "svg-1" }], ["path", { "d": "M10 14l2 2l2 -2", "key": "svg-2" }]]);

var IconEmergencyBed = createVueComponent("outline", "emergency-bed", "EmergencyBed", [["path", { "d": "M16 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M8 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M4 8l2.1 2.8a3 3 0 0 0 2.4 1.2h11.5", "key": "svg-2" }], ["path", { "d": "M10 6h4", "key": "svg-3" }], ["path", { "d": "M12 4v4", "key": "svg-4" }], ["path", { "d": "M12 12v2l-2.5 2.5", "key": "svg-5" }], ["path", { "d": "M14.5 16.5l-2.5 -2.5", "key": "svg-6" }]]);

var IconEmpathizeOff = createVueComponent("outline", "empathize-off", "EmpathizeOff", [["path", { "d": "M12 8a2.5 2.5 0 1 0 -2.5 -2.5", "key": "svg-0" }], ["path", { "d": "M12.317 12.315l-.317 .317l-.728 -.727a3.088 3.088 0 1 0 -4.367 4.367l5.095 5.096l4.689 -4.69m1.324 -2.673a3.087 3.087 0 0 0 -3.021 -3.018", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconEmpathize = createVueComponent("outline", "empathize", "Empathize", [["path", { "d": "M12 5.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M12 21.368l5.095 -5.096a3.088 3.088 0 1 0 -4.367 -4.367l-.728 .727l-.728 -.727a3.088 3.088 0 1 0 -4.367 4.367l5.095 5.096z", "key": "svg-1" }]]);

var IconEmphasis = createVueComponent("outline", "emphasis", "Emphasis", [["path", { "d": "M16 5h-8v10h8m-1 -5h-7", "key": "svg-0" }], ["path", { "d": "M6 20l0 .01", "key": "svg-1" }], ["path", { "d": "M10 20l0 .01", "key": "svg-2" }], ["path", { "d": "M14 20l0 .01", "key": "svg-3" }], ["path", { "d": "M18 20l0 .01", "key": "svg-4" }]]);

var IconEngineOff = createVueComponent("outline", "engine-off", "EngineOff", [["path", { "d": "M3 10v6", "key": "svg-0" }], ["path", { "d": "M12 5v3", "key": "svg-1" }], ["path", { "d": "M10 5h4", "key": "svg-2" }], ["path", { "d": "M5 13h-2", "key": "svg-3" }], ["path", { "d": "M16 16h-1v2a1 1 0 0 1 -1 1h-3.465a1 1 0 0 1 -.832 -.445l-1.703 -2.555h-2v-6h2l.99 -.99m3.01 -1.01h1.382a1 1 0 0 1 .894 .553l1.448 2.894a1 1 0 0 0 .894 .553h1.382v-2h2a1 1 0 0 1 1 1v6", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconEngine = createVueComponent("outline", "engine", "Engine", [["path", { "d": "M3 10v6", "key": "svg-0" }], ["path", { "d": "M12 5v3", "key": "svg-1" }], ["path", { "d": "M10 5h4", "key": "svg-2" }], ["path", { "d": "M5 13h-2", "key": "svg-3" }], ["path", { "d": "M6 10h2l2 -2h3.382a1 1 0 0 1 .894 .553l1.448 2.894a1 1 0 0 0 .894 .553h1.382v-2h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2v-2h-3v2a1 1 0 0 1 -1 1h-3.465a1 1 0 0 1 -.832 -.445l-1.703 -2.555h-2v-6z", "key": "svg-4" }]]);

var IconEqualDouble = createVueComponent("outline", "equal-double", "EqualDouble", [["path", { "d": "M3 10h7", "key": "svg-0" }], ["path", { "d": "M3 14h7", "key": "svg-1" }], ["path", { "d": "M14 10h7", "key": "svg-2" }], ["path", { "d": "M14 14h7", "key": "svg-3" }]]);

var IconEqualNot = createVueComponent("outline", "equal-not", "EqualNot", [["path", { "d": "M5 10h14", "key": "svg-0" }], ["path", { "d": "M5 14h14", "key": "svg-1" }], ["path", { "d": "M5 19l14 -14", "key": "svg-2" }]]);

var IconEqual = createVueComponent("outline", "equal", "Equal", [["path", { "d": "M5 10h14", "key": "svg-0" }], ["path", { "d": "M5 14h14", "key": "svg-1" }]]);

var IconEraserOff = createVueComponent("outline", "eraser-off", "EraserOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M19 20h-10.5l-4.21 -4.3a1 1 0 0 1 0 -1.41l5 -4.993m2.009 -2.01l3 -3a1 1 0 0 1 1.41 0l5 5a1 1 0 0 1 0 1.41c-1.417 1.431 -2.406 2.432 -2.97 3m-2.02 2.043l-4.211 4.256", "key": "svg-1" }], ["path", { "d": "M18 13.3l-6.3 -6.3", "key": "svg-2" }]]);

var IconEraser = createVueComponent("outline", "eraser", "Eraser", [["path", { "d": "M19 20h-10.5l-4.21 -4.3a1 1 0 0 1 0 -1.41l10 -10a1 1 0 0 1 1.41 0l5 5a1 1 0 0 1 0 1.41l-9.2 9.3", "key": "svg-0" }], ["path", { "d": "M18 13.3l-6.3 -6.3", "key": "svg-1" }]]);

var IconError404Off = createVueComponent("outline", "error-404-off", "Error404Off", [["path", { "d": "M3 8v3a1 1 0 0 0 1 1h3", "key": "svg-0" }], ["path", { "d": "M7 8v8", "key": "svg-1" }], ["path", { "d": "M17 8v3a1 1 0 0 0 1 1h3", "key": "svg-2" }], ["path", { "d": "M21 8v8", "key": "svg-3" }], ["path", { "d": "M10 10v4a2 2 0 1 0 4 0m0 -4a2 2 0 0 0 -2 -2", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconError404 = createVueComponent("outline", "error-404", "Error404", [["path", { "d": "M3 8v3a1 1 0 0 0 1 1h3", "key": "svg-0" }], ["path", { "d": "M7 8v8", "key": "svg-1" }], ["path", { "d": "M17 8v3a1 1 0 0 0 1 1h3", "key": "svg-2" }], ["path", { "d": "M21 8v8", "key": "svg-3" }], ["path", { "d": "M10 10v4a2 2 0 1 0 4 0v-4a2 2 0 1 0 -4 0", "key": "svg-4" }]]);

var IconEscalatorDown = createVueComponent("outline", "escalator-down", "EscalatorDown", [["path", { "d": "M4.5 7h2.733a2 2 0 0 1 1.337 .513l9.43 8.487h1.5a2.5 2.5 0 1 1 0 5h-2.733a2 2 0 0 1 -1.337 -.513l-9.43 -8.487h-1.5a2.5 2.5 0 1 1 0 -5z", "key": "svg-0" }], ["path", { "d": "M18 3v7", "key": "svg-1" }], ["path", { "d": "M15 7l3 3l3 -3", "key": "svg-2" }]]);

var IconEscalatorUp = createVueComponent("outline", "escalator-up", "EscalatorUp", [["path", { "d": "M19.5 7h-2.672a2 2 0 0 0 -1.414 .586l-8.414 8.414h-2.5a2.5 2.5 0 1 0 0 5h3.672a2 2 0 0 0 1.414 -.586l8.414 -8.414h1.5a2.5 2.5 0 1 0 0 -5z", "key": "svg-0" }], ["path", { "d": "M6 10v-7", "key": "svg-1" }], ["path", { "d": "M3 6l3 -3l3 3", "key": "svg-2" }]]);

var IconEscalator = createVueComponent("outline", "escalator", "Escalator", [["path", { "d": "M19.5 5h-2.672a2 2 0 0 0 -1.414 .586l-8.414 8.414h-2.5a2.5 2.5 0 1 0 0 5h3.672a2 2 0 0 0 1.414 -.586l8.414 -8.414h1.5a2.5 2.5 0 0 0 0 -5z", "key": "svg-0" }]]);

var IconExchangeOff = createVueComponent("outline", "exchange-off", "ExchangeOff", [["path", { "d": "M5 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M19 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 8v5c0 .594 -.104 1.164 -.294 1.692m-1.692 2.298a4.978 4.978 0 0 1 -3.014 1.01h-3l3 -3", "key": "svg-2" }], ["path", { "d": "M14 21l-3 -3", "key": "svg-3" }], ["path", { "d": "M5 16v-5c0 -1.632 .782 -3.082 1.992 -4m3.008 -1h3l-3 -3", "key": "svg-4" }], ["path", { "d": "M11.501 7.499l1.499 -1.499", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconExchange = createVueComponent("outline", "exchange", "Exchange", [["path", { "d": "M5 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M19 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 8v5a5 5 0 0 1 -5 5h-3l3 -3m0 6l-3 -3", "key": "svg-2" }], ["path", { "d": "M5 16v-5a5 5 0 0 1 5 -5h3l-3 -3m0 6l3 -3", "key": "svg-3" }]]);

var IconExclamationCircle = createVueComponent("outline", "exclamation-circle", "ExclamationCircle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 9v4", "key": "svg-1" }], ["path", { "d": "M12 16v.01", "key": "svg-2" }]]);

var IconExclamationMarkOff = createVueComponent("outline", "exclamation-mark-off", "ExclamationMarkOff", [["path", { "d": "M12 19v.01", "key": "svg-0" }], ["path", { "d": "M12 15v-3m0 -4v-3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconExclamationMark = createVueComponent("outline", "exclamation-mark", "ExclamationMark", [["path", { "d": "M12 19v.01", "key": "svg-0" }], ["path", { "d": "M12 15v-10", "key": "svg-1" }]]);

var IconExplicitOff = createVueComponent("outline", "explicit-off", "ExplicitOff", [["path", { "d": "M14 8h-2m-2 2v6h4", "key": "svg-0" }], ["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-1" }], ["path", { "d": "M12 12h-2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconExplicit = createVueComponent("outline", "explicit", "Explicit", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8h4", "key": "svg-1" }], ["path", { "d": "M14 12h-4", "key": "svg-2" }]]);

var IconExposure0 = createVueComponent("outline", "exposure-0", "Exposure0", [["path", { "d": "M12 19a4 4 0 0 0 4 -4v-6a4 4 0 1 0 -8 0v6a4 4 0 0 0 4 4z", "key": "svg-0" }]]);

var IconExposureMinus1 = createVueComponent("outline", "exposure-minus-1", "ExposureMinus1", [["path", { "d": "M3 12h6", "key": "svg-0" }], ["path", { "d": "M18 19v-14l-4 4", "key": "svg-1" }]]);

var IconExposureMinus2 = createVueComponent("outline", "exposure-minus-2", "ExposureMinus2", [["path", { "d": "M12 9a4 4 0 1 1 8 0c0 1.098 -.564 2.025 -1.159 2.815l-6.841 7.185h8", "key": "svg-0" }], ["path", { "d": "M3 12h6", "key": "svg-1" }]]);

var IconExposureOff = createVueComponent("outline", "exposure-off", "ExposureOff", [["path", { "d": "M3.6 20.4l8.371 -8.371m2.04 -2.04l6.389 -6.389", "key": "svg-0" }], ["path", { "d": "M6 8h2m0 0v2", "key": "svg-1" }], ["path", { "d": "M14 16h2", "key": "svg-2" }], ["path", { "d": "M7 3h12a2 2 0 0 1 2 2v12m-.5 3.5c-.362 .36 -.95 .5 -1.5 .5h-14a2 2 0 0 1 -2 -2v-14c0 -.541 .215 -1.033 .565 -1.393", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconExposurePlus1 = createVueComponent("outline", "exposure-plus-1", "ExposurePlus1", [["path", { "d": "M3 12h6", "key": "svg-0" }], ["path", { "d": "M6 9v6", "key": "svg-1" }], ["path", { "d": "M18 19v-14l-4 4", "key": "svg-2" }]]);

var IconExposurePlus2 = createVueComponent("outline", "exposure-plus-2", "ExposurePlus2", [["path", { "d": "M12 9a4 4 0 1 1 8 0c0 1.098 -.564 2.025 -1.159 2.815l-6.841 7.185h8", "key": "svg-0" }], ["path", { "d": "M3 12h6", "key": "svg-1" }], ["path", { "d": "M6 9v6", "key": "svg-2" }]]);

var IconExposure = createVueComponent("outline", "exposure", "Exposure", [["path", { "d": "M3.6 20.4l16.8 -16.8", "key": "svg-0" }], ["path", { "d": "M6 8h4m-2 -2v4", "key": "svg-1" }], ["path", { "d": "M14 16h4", "key": "svg-2" }], ["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-3" }]]);

var IconExternalLinkOff = createVueComponent("outline", "external-link-off", "ExternalLinkOff", [["path", { "d": "M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1", "key": "svg-0" }], ["path", { "d": "M10 14l2 -2m2.007 -2.007l6 -6", "key": "svg-1" }], ["path", { "d": "M15 4h5v5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconExternalLink = createVueComponent("outline", "external-link", "ExternalLink", [["path", { "d": "M12 6h-6a2 2 0 0 0 -2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-6", "key": "svg-0" }], ["path", { "d": "M11 13l9 -9", "key": "svg-1" }], ["path", { "d": "M15 4h5v5", "key": "svg-2" }]]);

var IconEyeBitcoin = createVueComponent("outline", "eye-bitcoin", "EyeBitcoin", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.193 17.924q -.585 .075 -1.193 .076q -5.4 0 -9 -6q 3.6 -6 9 -6q 4.508 0 7.761 4.181", "key": "svg-1" }], ["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-2" }]]);

var IconEyeBolt = createVueComponent("outline", "eye-bolt", "EyeBolt", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.1 17.936a9.28 9.28 0 0 1 -1.1 .064c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconEyeCancel = createVueComponent("outline", "eye-cancel", "EyeCancel", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconEyeCheck = createVueComponent("outline", "eye-check", "EyeCheck", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11.102 17.957c-3.204 -.307 -5.904 -2.294 -8.102 -5.957c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6a19.5 19.5 0 0 1 -.663 1.032", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconEyeClosed = createVueComponent("outline", "eye-closed", "EyeClosed", [["path", { "d": "M21 9c-2.4 2.667 -5.4 4 -9 4c-3.6 0 -6.6 -1.333 -9 -4", "key": "svg-0" }], ["path", { "d": "M3 15l2.5 -3.8", "key": "svg-1" }], ["path", { "d": "M21 14.976l-2.492 -3.776", "key": "svg-2" }], ["path", { "d": "M9 17l.5 -4", "key": "svg-3" }], ["path", { "d": "M15 17l-.5 -4", "key": "svg-4" }]]);

var IconEyeCode = createVueComponent("outline", "eye-code", "EyeCode", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11.11 17.958c-3.209 -.307 -5.91 -2.293 -8.11 -5.958c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.21 .352 -.427 .688 -.647 1.008", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconEyeCog = createVueComponent("outline", "eye-cog", "EyeCog", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconEyeDiscount = createVueComponent("outline", "eye-discount", "EyeDiscount", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M16 21l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21v.01", "key": "svg-3" }], ["path", { "d": "M16 16v.01", "key": "svg-4" }]]);

var IconEyeDollar = createVueComponent("outline", "eye-dollar", "EyeDollar", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.193 17.924c-.39 .05 -.788 .076 -1.193 .076c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.005 0 5.592 1.394 7.761 4.181", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconEyeDotted = createVueComponent("outline", "eye-dotted", "EyeDotted", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M21 12h.01", "key": "svg-1" }], ["path", { "d": "M3 12h.01", "key": "svg-2" }], ["path", { "d": "M5 15h.01", "key": "svg-3" }], ["path", { "d": "M5 9h.01", "key": "svg-4" }], ["path", { "d": "M19 15h.01", "key": "svg-5" }], ["path", { "d": "M12 18h.01", "key": "svg-6" }], ["path", { "d": "M12 6h.01", "key": "svg-7" }], ["path", { "d": "M8 17h.01", "key": "svg-8" }], ["path", { "d": "M8 7h.01", "key": "svg-9" }], ["path", { "d": "M16 17h.01", "key": "svg-10" }], ["path", { "d": "M16 7h.01", "key": "svg-11" }], ["path", { "d": "M19 9h.01", "key": "svg-12" }]]);

var IconEyeDown = createVueComponent("outline", "eye-down", "EyeDown", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconEyeEdit = createVueComponent("outline", "eye-edit", "EyeEdit", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11.192 17.966c-3.242 -.28 -5.972 -2.269 -8.192 -5.966c2.4 -4 5.4 -6 9 -6c3.326 0 6.14 1.707 8.442 5.122", "key": "svg-1" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-2" }]]);

var IconEyeExclamation = createVueComponent("outline", "eye-exclamation", "EyeExclamation", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15.03 17.478a8.797 8.797 0 0 1 -3.03 .522c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6a20.48 20.48 0 0 1 -.258 .419", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconEyeHeart = createVueComponent("outline", "eye-heart", "EyeHeart", [["path", { "d": "M13.905 11.39a2 2 0 1 0 -2.855 2.37", "key": "svg-0" }], ["path", { "d": "M9.992 17.779c-2.722 -.621 -5.053 -2.547 -6.992 -5.779c2.4 -4 5.4 -6 9 -6c3.332 0 6.15 1.714 8.454 5.14", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconEyeMinus = createVueComponent("outline", "eye-minus", "EyeMinus", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.713 1.188 -1.478 2.199 -2.296 3.034", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconEyeOff = createVueComponent("outline", "eye-off", "EyeOff", [["path", { "d": "M10.585 10.587a2 2 0 0 0 2.829 2.828", "key": "svg-0" }], ["path", { "d": "M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconEyePause = createVueComponent("outline", "eye-pause", "EyePause", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.022 17.945a9.308 9.308 0 0 1 -1.022 .055c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.195 .325 -.394 .636 -.596 .935", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconEyePin = createVueComponent("outline", "eye-pin", "EyePin", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.362 0 6.202 1.745 8.517 5.234", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconEyePlus = createVueComponent("outline", "eye-plus", "EyePlus", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconEyeQuestion = createVueComponent("outline", "eye-question", "EyeQuestion", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M14.071 17.764a8.989 8.989 0 0 1 -2.071 .236c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.346 0 6.173 1.727 8.482 5.182", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconEyeSearch = createVueComponent("outline", "eye-search", "EyeSearch", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-.328 0 -.652 -.017 -.97 -.05c-3.172 -.332 -5.85 -2.315 -8.03 -5.95c2.4 -4 5.4 -6 9 -6c3.465 0 6.374 1.853 8.727 5.558", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconEyeShare = createVueComponent("outline", "eye-share", "EyeShare", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12.597 17.981a9.467 9.467 0 0 1 -.597 .019c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.205 .342 -.415 .67 -.63 .983", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconEyeSpark = createVueComponent("outline", "eye-spark", "EyeSpark", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11.669 17.994q -5.18 -.18 -8.669 -5.994q 3.6 -6 9 -6t 9 6", "key": "svg-1" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-2" }]]);

var IconEyeStar = createVueComponent("outline", "eye-star", "EyeStar", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M9.608 17.682c-2.558 -.71 -4.76 -2.603 -6.608 -5.682c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconEyeTable = createVueComponent("outline", "eye-table", "EyeTable", [["path", { "d": "M8 18h-.011", "key": "svg-0" }], ["path", { "d": "M12 18h-.011", "key": "svg-1" }], ["path", { "d": "M16 18h-.011", "key": "svg-2" }], ["path", { "d": "M4 3h16", "key": "svg-3" }], ["path", { "d": "M5 3v17a1 1 0 0 0 1 1h12a1 1 0 0 0 1 -1v-17", "key": "svg-4" }], ["path", { "d": "M14 7h-4", "key": "svg-5" }], ["path", { "d": "M9 15h1", "key": "svg-6" }], ["path", { "d": "M14 15h1", "key": "svg-7" }], ["path", { "d": "M12 11v-4", "key": "svg-8" }]]);

var IconEyeUp = createVueComponent("outline", "eye-up", "EyeUp", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.09 .15 -.18 .295 -.27 .439", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconEyeX = createVueComponent("outline", "eye-x", "EyeX", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.048 17.942a9.298 9.298 0 0 1 -1.048 .058c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6a17.986 17.986 0 0 1 -1.362 1.975", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconEye = createVueComponent("outline", "eye", "Eye", [["path", { "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6", "key": "svg-1" }]]);

var IconEyeglass2 = createVueComponent("outline", "eyeglass-2", "Eyeglass2", [["path", { "d": "M8 4h-2l-3 10v2.5", "key": "svg-0" }], ["path", { "d": "M16 4h2l3 10v2.5", "key": "svg-1" }], ["path", { "d": "M10 16l4 0", "key": "svg-2" }], ["path", { "d": "M17.5 16.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-3" }], ["path", { "d": "M6.5 16.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-4" }]]);

var IconEyeglassOff = createVueComponent("outline", "eyeglass-off", "EyeglassOff", [["path", { "d": "M5.536 5.546l-2.536 8.454", "key": "svg-0" }], ["path", { "d": "M16 4h2l3 10", "key": "svg-1" }], ["path", { "d": "M10 16h4", "key": "svg-2" }], ["path", { "d": "M19.426 19.423a3.5 3.5 0 0 1 -5.426 -2.923v-2.5m4 0h3v2.5c0 .157 -.01 .312 -.03 .463", "key": "svg-3" }], ["path", { "d": "M10 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconEyeglass = createVueComponent("outline", "eyeglass", "Eyeglass", [["path", { "d": "M8 4h-2l-3 10", "key": "svg-0" }], ["path", { "d": "M16 4h2l3 10", "key": "svg-1" }], ["path", { "d": "M10 16l4 0", "key": "svg-2" }], ["path", { "d": "M21 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5", "key": "svg-3" }], ["path", { "d": "M10 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5", "key": "svg-4" }]]);

var IconFaceIdError = createVueComponent("outline", "face-id-error", "FaceIdError", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M9 10h.01", "key": "svg-4" }], ["path", { "d": "M15 10h.01", "key": "svg-5" }], ["path", { "d": "M9.5 15.05a3.5 3.5 0 0 1 5 0", "key": "svg-6" }]]);

var IconFaceId = createVueComponent("outline", "face-id", "FaceId", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M9 10l.01 0", "key": "svg-4" }], ["path", { "d": "M15 10l.01 0", "key": "svg-5" }], ["path", { "d": "M9.5 15a3.5 3.5 0 0 0 5 0", "key": "svg-6" }]]);

var IconFaceMaskOff = createVueComponent("outline", "face-mask-off", "FaceMaskOff", [["path", { "d": "M5 14.5h-.222c-1.535 0 -2.778 -1.12 -2.778 -2.5s1.243 -2.5 2.778 -2.5h.222", "key": "svg-0" }], ["path", { "d": "M19 14.5h.222c1.534 0 2.778 -1.12 2.778 -2.5s-1.244 -2.5 -2.778 -2.5h-.222", "key": "svg-1" }], ["path", { "d": "M9 10h1m4 0h1", "key": "svg-2" }], ["path", { "d": "M9 14h5", "key": "svg-3" }], ["path", { "d": "M19 15v-6.49a2 2 0 0 0 -1.45 -1.923l-5 -1.429a2 2 0 0 0 -1.1 0l-1.788 .511m-3.118 .891l-.094 .027a2 2 0 0 0 -1.45 1.922v6.982a2 2 0 0 0 1.45 1.923l5 1.429a2 2 0 0 0 1.1 0l4.899 -1.4", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconFaceMask = createVueComponent("outline", "face-mask", "FaceMask", [["path", { "d": "M5 14.5h-.222c-1.535 0 -2.778 -1.12 -2.778 -2.5s1.243 -2.5 2.778 -2.5h.222", "key": "svg-0" }], ["path", { "d": "M19 14.5h.222c1.534 0 2.778 -1.12 2.778 -2.5s-1.244 -2.5 -2.778 -2.5h-.222", "key": "svg-1" }], ["path", { "d": "M9 10h6", "key": "svg-2" }], ["path", { "d": "M9 14h6", "key": "svg-3" }], ["path", { "d": "M12.55 18.843l5 -1.429a2 2 0 0 0 1.45 -1.923v-6.981a2 2 0 0 0 -1.45 -1.923l-5 -1.429a2 2 0 0 0 -1.1 0l-5 1.429a2 2 0 0 0 -1.45 1.922v6.982a2 2 0 0 0 1.45 1.923l5 1.429a2 2 0 0 0 1.1 0z", "key": "svg-4" }]]);

var IconFall = createVueComponent("outline", "fall", "Fall", [["path", { "d": "M11 21l1 -5l-1 -4l-3 -4h4l3 -3", "key": "svg-0" }], ["path", { "d": "M6 16l-1 -4l3 -4", "key": "svg-1" }], ["path", { "d": "M6 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M13.5 12h2.5l4 2", "key": "svg-3" }]]);

var IconFavicon = createVueComponent("outline", "favicon", "Favicon", [["path", { "d": "M2 5m0 3a3 3 0 0 1 3 -3h14a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-14a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M6 10v4", "key": "svg-1" }], ["path", { "d": "M11 10a2 2 0 1 0 0 4", "key": "svg-2" }], ["path", { "d": "M16 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }]]);

var IconFeatherOff = createVueComponent("outline", "feather-off", "FeatherOff", [["path", { "d": "M4 20l8 -8", "key": "svg-0" }], ["path", { "d": "M14 5v5h5", "key": "svg-1" }], ["path", { "d": "M9 11v4h4", "key": "svg-2" }], ["path", { "d": "M6 13v5h5", "key": "svg-3" }], ["path", { "d": "M6 13l3.502 -3.502m2.023 -2.023l2.475 -2.475", "key": "svg-4" }], ["path", { "d": "M19 10c.638 -.636 1 -1.515 1 -2.486a3.515 3.515 0 0 0 -3.517 -3.514c-.97 0 -1.847 .367 -2.483 1", "key": "svg-5" }], ["path", { "d": "M11 18l3.499 -3.499m2.008 -2.008l2.493 -2.493", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconFeather = createVueComponent("outline", "feather", "Feather", [["path", { "d": "M4 20l10 -10m0 -5v5h5m-9 -1v5h5m-9 -1v5h5m-5 -5l4 -4l4 -4", "key": "svg-0" }], ["path", { "d": "M19 10c.638 -.636 1 -1.515 1 -2.486a3.515 3.515 0 0 0 -3.517 -3.514c-.97 0 -1.847 .367 -2.483 1m-3 13l4 -4l4 -4", "key": "svg-1" }]]);

var IconFenceOff = createVueComponent("outline", "fence-off", "FenceOff", [["path", { "d": "M12 12h-8v4h12m4 0v-4h-4", "key": "svg-0" }], ["path", { "d": "M6 16v4h4v-4", "key": "svg-1" }], ["path", { "d": "M10 12v-2m0 -4l-2 -2m-2 2v6", "key": "svg-2" }], ["path", { "d": "M14 16v4h4v-2", "key": "svg-3" }], ["path", { "d": "M18 12v-6l-2 -2l-2 2v4", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconFence = createVueComponent("outline", "fence", "Fence", [["path", { "d": "M4 12v4h16v-4z", "key": "svg-0" }], ["path", { "d": "M6 16v4h4v-4m0 -4v-6l-2 -2l-2 2v6", "key": "svg-1" }], ["path", { "d": "M14 16v4h4v-4m0 -4v-6l-2 -2l-2 2v6", "key": "svg-2" }]]);

var IconFerry = createVueComponent("outline", "ferry", "Ferry", [["path", { "d": "M2 18h15.293c1.02 0 1.972 -.503 2.536 -1.34l2.171 -3.66h-18.479z", "key": "svg-0" }], ["path", { "d": "M14 8l-1 -2", "key": "svg-1" }], ["path", { "d": "M6.107 12.675l1.384 -4.675h8l2.675 4.598", "key": "svg-2" }]]);

var IconFidgetSpinner = createVueComponent("outline", "fidget-spinner", "FidgetSpinner", [["path", { "d": "M18 16v.01", "key": "svg-0" }], ["path", { "d": "M6 16v.01", "key": "svg-1" }], ["path", { "d": "M12 5v.01", "key": "svg-2" }], ["path", { "d": "M12 12v.01", "key": "svg-3" }], ["path", { "d": "M12 1a4 4 0 0 1 2.001 7.464l.001 .072a3.998 3.998 0 0 1 1.987 3.758l.22 .128a3.978 3.978 0 0 1 1.591 -.417l.2 -.005a4 4 0 1 1 -3.994 3.77l-.28 -.16c-.522 .25 -1.108 .39 -1.726 .39c-.619 0 -1.205 -.14 -1.728 -.391l-.279 .16l.007 .231a4 4 0 1 1 -2.212 -3.579l.222 -.129a3.998 3.998 0 0 1 1.988 -3.756l.002 -.071a4 4 0 0 1 -1.995 -3.265l-.005 -.2a4 4 0 0 1 4 -4z", "key": "svg-4" }]]);

var IconFile3d = createVueComponent("outline", "file-3d", "File3d", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 13.5l4 -1.5", "key": "svg-2" }], ["path", { "d": "M8 11.846l4 1.654v4.5l4 -1.846v-4.308l-4 -1.846z", "key": "svg-3" }], ["path", { "d": "M8 12v4.2l4 1.8", "key": "svg-4" }]]);

var IconFileAi = createVueComponent("outline", "file-ai", "FileAi", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M10 21h-3a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M14 21v-4a2 2 0 1 1 4 0v4", "key": "svg-2" }], ["path", { "d": "M14 19h4", "key": "svg-3" }], ["path", { "d": "M21 15v6", "key": "svg-4" }]]);

var IconFileAlert = createVueComponent("outline", "file-alert", "FileAlert", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 17l.01 0", "key": "svg-2" }], ["path", { "d": "M12 11l0 3", "key": "svg-3" }]]);

var IconFileAnalytics = createVueComponent("outline", "file-analytics", "FileAnalytics", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 17l0 -5", "key": "svg-2" }], ["path", { "d": "M12 17l0 -1", "key": "svg-3" }], ["path", { "d": "M15 17l0 -3", "key": "svg-4" }]]);

var IconFileArrowLeft = createVueComponent("outline", "file-arrow-left", "FileArrowLeft", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M15 15h-6", "key": "svg-2" }], ["path", { "d": "M11.5 17.5l-2.5 -2.5l2.5 -2.5", "key": "svg-3" }]]);

var IconFileArrowRight = createVueComponent("outline", "file-arrow-right", "FileArrowRight", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 15h6", "key": "svg-2" }], ["path", { "d": "M12.5 17.5l2.5 -2.5l-2.5 -2.5", "key": "svg-3" }]]);

var IconFileBarcode = createVueComponent("outline", "file-barcode", "FileBarcode", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M8 13h1v3h-1z", "key": "svg-2" }], ["path", { "d": "M12 13v3", "key": "svg-3" }], ["path", { "d": "M15 13h1v3h-1z", "key": "svg-4" }]]);

var IconFileBitcoin = createVueComponent("outline", "file-bitcoin", "FileBitcoin", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M12 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v2", "key": "svg-1" }], ["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-2" }]]);

var IconFileBroken = createVueComponent("outline", "file-broken", "FileBroken", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 7v-2a2 2 0 0 1 2 -2h7l5 5v2", "key": "svg-1" }], ["path", { "d": "M19 19a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2", "key": "svg-2" }], ["path", { "d": "M5 16h.01", "key": "svg-3" }], ["path", { "d": "M5 13h.01", "key": "svg-4" }], ["path", { "d": "M5 10h.01", "key": "svg-5" }], ["path", { "d": "M19 13h.01", "key": "svg-6" }], ["path", { "d": "M19 16h.01", "key": "svg-7" }]]);

var IconFileCertificate = createVueComponent("outline", "file-certificate", "FileCertificate", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 8v-3a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-5", "key": "svg-1" }], ["path", { "d": "M6 14m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M4.5 17l-1.5 5l3 -1.5l3 1.5l-1.5 -5", "key": "svg-3" }]]);

var IconFileChart = createVueComponent("outline", "file-chart", "FileChart", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 10v4h4", "key": "svg-2" }], ["path", { "d": "M12 14m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-3" }]]);

var IconFileCheck = createVueComponent("outline", "file-check", "FileCheck", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 15l2 2l4 -4", "key": "svg-2" }]]);

var IconFileCode2 = createVueComponent("outline", "file-code-2", "FileCode2", [["path", { "d": "M10 12h-1v5h1", "key": "svg-0" }], ["path", { "d": "M14 12h1v5h-1", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-3" }]]);

var IconFileCode = createVueComponent("outline", "file-code", "FileCode", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M10 13l-1 2l1 2", "key": "svg-2" }], ["path", { "d": "M14 13l1 2l-1 2", "key": "svg-3" }]]);

var IconFileCv = createVueComponent("outline", "file-cv", "FileCv", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M11 12.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }], ["path", { "d": "M13 11l1.5 6l1.5 -6", "key": "svg-3" }]]);

var IconFileDatabase = createVueComponent("outline", "file-database", "FileDatabase", [["path", { "d": "M12 12.75m-4 0a4 1.75 0 1 0 8 0a4 1.75 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M8 12.5v3.75c0 .966 1.79 1.75 4 1.75s4 -.784 4 -1.75v-3.75", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-3" }]]);

var IconFileDelta = createVueComponent("outline", "file-delta", "FileDelta", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 17h6l-3 -6z", "key": "svg-2" }]]);

var IconFileDescription = createVueComponent("outline", "file-description", "FileDescription", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 17h6", "key": "svg-2" }], ["path", { "d": "M9 13h6", "key": "svg-3" }]]);

var IconFileDiff = createVueComponent("outline", "file-diff", "FileDiff", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 10l0 4", "key": "svg-2" }], ["path", { "d": "M10 12l4 0", "key": "svg-3" }], ["path", { "d": "M10 17l4 0", "key": "svg-4" }]]);

var IconFileDigit = createVueComponent("outline", "file-digit", "FileDigit", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M9 12m0 1a1 1 0 0 1 1 -1h1a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-1a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-2" }], ["path", { "d": "M15 12v5", "key": "svg-3" }]]);

var IconFileDislike = createVueComponent("outline", "file-dislike", "FileDislike", [["path", { "d": "M3 14m0 1a1 1 0 0 1 1 -1h1a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-1a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M6 15a1 1 0 0 1 1 -1h3.756a1 1 0 0 1 .958 .713l1.2 3c.09 .303 .133 .63 -.056 .884c-.188 .254 -.542 .403 -.858 .403h-2v2.467a1.1 1.1 0 0 1 -2.015 .61l-1.985 -3.077v-4z", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M5 11v-6a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-2.5", "key": "svg-3" }]]);

var IconFileDollar = createVueComponent("outline", "file-dollar", "FileDollar", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M14 11h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M12 17v1m0 -8v1", "key": "svg-3" }]]);

var IconFileDots = createVueComponent("outline", "file-dots", "FileDots", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 14v.01", "key": "svg-2" }], ["path", { "d": "M12 14v.01", "key": "svg-3" }], ["path", { "d": "M15 14v.01", "key": "svg-4" }]]);

var IconFileDownload = createVueComponent("outline", "file-download", "FileDownload", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 17v-6", "key": "svg-2" }], ["path", { "d": "M9.5 14.5l2.5 2.5l2.5 -2.5", "key": "svg-3" }]]);

var IconFileEuro = createVueComponent("outline", "file-euro", "FileEuro", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 14h-3", "key": "svg-2" }], ["path", { "d": "M14 11.172a3 3 0 1 0 0 5.656", "key": "svg-3" }]]);

var IconFileExcel = createVueComponent("outline", "file-excel", "FileExcel", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2", "key": "svg-1" }], ["path", { "d": "M10 12l4 5", "key": "svg-2" }], ["path", { "d": "M10 17l4 -5", "key": "svg-3" }]]);

var IconFileExport = createVueComponent("outline", "file-export", "FileExport", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M11.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v5m-5 6h7m-3 -3l3 3l-3 3", "key": "svg-1" }]]);

var IconFileFunction = createVueComponent("outline", "file-function", "FileFunction", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M10.5 17h.333c.474 0 .87 -.323 .916 -.746l.502 -4.508c.047 -.423 .443 -.746 .916 -.746h.333", "key": "svg-2" }], ["path", { "d": "M10.5 14h3", "key": "svg-3" }]]);

var IconFileHorizontal = createVueComponent("outline", "file-horizontal", "FileHorizontal", [["path", { "d": "M16 5v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M3 7v10a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2v-7l-5 -5h-11a2 2 0 0 0 -2 2z", "key": "svg-1" }]]);

var IconFileImport = createVueComponent("outline", "file-import", "FileImport", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 13v-8a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-5.5m-9.5 -2h7m-3 -3l3 3l-3 3", "key": "svg-1" }]]);

var IconFileInfinity = createVueComponent("outline", "file-infinity", "FileInfinity", [["path", { "d": "M15.536 17.586a2.123 2.123 0 0 0 -2.929 0a1.951 1.951 0 0 0 0 2.828c.809 .781 2.12 .781 2.929 0c.809 -.781 -.805 .778 0 0l1.46 -1.41l1.46 -1.419", "key": "svg-0" }], ["path", { "d": "M15.54 17.582l1.46 1.42l1.46 1.41c.809 .78 -.805 -.779 0 0s2.12 .781 2.929 0a1.951 1.951 0 0 0 0 -2.828a2.123 2.123 0 0 0 -2.929 0", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M9.5 21h-2.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v6", "key": "svg-3" }]]);

var IconFileInfo = createVueComponent("outline", "file-info", "FileInfo", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M11 14h1v4h1", "key": "svg-2" }], ["path", { "d": "M12 11h.01", "key": "svg-3" }]]);

var IconFileInvoice = createVueComponent("outline", "file-invoice", "FileInvoice", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 7l1 0", "key": "svg-2" }], ["path", { "d": "M9 13l6 0", "key": "svg-3" }], ["path", { "d": "M13 17l2 0", "key": "svg-4" }]]);

var IconFileIsr = createVueComponent("outline", "file-isr", "FileIsr", [["path", { "d": "M15 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M15 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M6 8v-3a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-7", "key": "svg-2" }], ["path", { "d": "M3 15l3 -3l3 3", "key": "svg-3" }]]);

var IconFileLambda = createVueComponent("outline", "file-lambda", "FileLambda", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M10 17l2 -3", "key": "svg-2" }], ["path", { "d": "M15 17c-2.5 0 -2.5 -6 -5 -6", "key": "svg-3" }]]);

var IconFileLike = createVueComponent("outline", "file-like", "FileLike", [["path", { "d": "M3 16m0 1a1 1 0 0 1 1 -1h1a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-1a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M6 20a1 1 0 0 0 1 1h3.756a1 1 0 0 0 .958 -.713l1.2 -3c.09 -.303 .133 -.63 -.056 -.884c-.188 -.254 -.542 -.403 -.858 -.403h-2v-2.467a1.1 1.1 0 0 0 -2.015 -.61l-1.985 3.077v4z", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M5 12.1v-7.1a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-2.3", "key": "svg-3" }]]);

var IconFileMinus = createVueComponent("outline", "file-minus", "FileMinus", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 14l6 0", "key": "svg-2" }]]);

var IconFileMusic = createVueComponent("outline", "file-music", "FileMusic", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M11 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M12 16l0 -5l2 1", "key": "svg-3" }]]);

var IconFileNeutral = createVueComponent("outline", "file-neutral", "FileNeutral", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2zm-7 -7h.01m3.99 0h.01m-4.01 3h4", "key": "svg-1" }]]);

var IconFileOff = createVueComponent("outline", "file-off", "FileOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M7 3h7l5 5v7m0 4a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-14", "key": "svg-1" }]]);

var IconFileOrientation = createVueComponent("outline", "file-orientation", "FileOrientation", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M10 21h-3a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v2", "key": "svg-1" }], ["path", { "d": "M13 20h5a2 2 0 0 0 2 -2v-5", "key": "svg-2" }], ["path", { "d": "M15 22l-2 -2l2 -2", "key": "svg-3" }], ["path", { "d": "M18 15l2 -2l2 2", "key": "svg-4" }]]);

var IconFilePencil = createVueComponent("outline", "file-pencil", "FilePencil", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M10 18l5 -5a1.414 1.414 0 0 0 -2 -2l-5 5v2h2z", "key": "svg-2" }]]);

var IconFilePercent = createVueComponent("outline", "file-percent", "FilePercent", [["path", { "d": "M10 17l4 -4", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-2" }], ["path", { "d": "M10 13h.01", "key": "svg-3" }], ["path", { "d": "M14 17h.01", "key": "svg-4" }]]);

var IconFilePhone = createVueComponent("outline", "file-phone", "FilePhone", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 12a.5 .5 0 0 0 1 0v-1a.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a.5 .5 0 0 0 0 -1h-1a.5 .5 0 0 0 0 1", "key": "svg-2" }]]);

var IconFilePlus = createVueComponent("outline", "file-plus", "FilePlus", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 11l0 6", "key": "svg-2" }], ["path", { "d": "M9 14l6 0", "key": "svg-3" }]]);

var IconFilePower = createVueComponent("outline", "file-power", "FilePower", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 11l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconFileReport = createVueComponent("outline", "file-report", "FileReport", [["path", { "d": "M17 17m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M17 13v4h4", "key": "svg-1" }], ["path", { "d": "M12 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M11.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v2m0 3v4", "key": "svg-3" }]]);

var IconFileRss = createVueComponent("outline", "file-rss", "FileRss", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 17a3 3 0 0 0 -3 -3", "key": "svg-2" }], ["path", { "d": "M15 17a6 6 0 0 0 -6 -6", "key": "svg-3" }], ["path", { "d": "M9 17h.01", "key": "svg-4" }]]);

var IconFileSad = createVueComponent("outline", "file-sad", "FileSad", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2zm-7 -7h.01m3.99 0h.01", "key": "svg-1" }], ["path", { "d": "M10 18a3.5 3.5 0 0 1 4 0", "key": "svg-2" }]]);

var IconFileScissors = createVueComponent("outline", "file-scissors", "FileScissors", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M15 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M9 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9 17l6 -6", "key": "svg-4" }], ["path", { "d": "M15 17l-6 -6", "key": "svg-5" }]]);

var IconFileSearch = createVueComponent("outline", "file-search", "FileSearch", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M12 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v4.5", "key": "svg-1" }], ["path", { "d": "M16.5 17.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-2" }], ["path", { "d": "M18.5 19.5l2.5 2.5", "key": "svg-3" }]]);

var IconFileSettings = createVueComponent("outline", "file-settings", "FileSettings", [["path", { "d": "M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 10.5v1.5", "key": "svg-1" }], ["path", { "d": "M12 16v1.5", "key": "svg-2" }], ["path", { "d": "M15.031 12.25l-1.299 .75", "key": "svg-3" }], ["path", { "d": "M10.268 15l-1.3 .75", "key": "svg-4" }], ["path", { "d": "M15 15.803l-1.285 -.773", "key": "svg-5" }], ["path", { "d": "M10.285 12.97l-1.285 -.773", "key": "svg-6" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-7" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-8" }]]);

var IconFileShredder = createVueComponent("outline", "file-shredder", "FileShredder", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M3 12l18 0", "key": "svg-2" }], ["path", { "d": "M6 16l0 2", "key": "svg-3" }], ["path", { "d": "M10 16l0 6", "key": "svg-4" }], ["path", { "d": "M14 16l0 2", "key": "svg-5" }], ["path", { "d": "M18 16l0 4", "key": "svg-6" }]]);

var IconFileSignal = createVueComponent("outline", "file-signal", "FileSignal", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 14v.01", "key": "svg-2" }], ["path", { "d": "M9.525 11.525a3.5 3.5 0 0 0 0 4.95m4.95 0a3.5 3.5 0 0 0 0 -4.95", "key": "svg-3" }]]);

var IconFileSmile = createVueComponent("outline", "file-smile", "FileSmile", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2zm-7 -7h.01m3.99 0h.01", "key": "svg-1" }], ["path", { "d": "M10 17a3.5 3.5 0 0 0 4 0", "key": "svg-2" }]]);

var IconFileSpark = createVueComponent("outline", "file-spark", "FileSpark", [["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M12 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v3.5", "key": "svg-2" }]]);

var IconFileSpreadsheet = createVueComponent("outline", "file-spreadsheet", "FileSpreadsheet", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M8 11h8v7h-8z", "key": "svg-2" }], ["path", { "d": "M8 15h8", "key": "svg-3" }], ["path", { "d": "M11 11v7", "key": "svg-4" }]]);

var IconFileStack = createVueComponent("outline", "file-stack", "FileStack", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M5 21h14", "key": "svg-2" }], ["path", { "d": "M5 18h14", "key": "svg-3" }], ["path", { "d": "M5 15h14", "key": "svg-4" }]]);

var IconFileStar = createVueComponent("outline", "file-star", "FileStar", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M11.8 16.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconFileSymlink = createVueComponent("outline", "file-symlink", "FileSymlink", [["path", { "d": "M4 21v-4a3 3 0 0 1 3 -3h5", "key": "svg-0" }], ["path", { "d": "M9 17l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M5 11v-6a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-9.5", "key": "svg-3" }]]);

var IconFileTextAi = createVueComponent("outline", "file-text-ai", "FileTextAi", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M10 21h-3a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v3.5", "key": "svg-1" }], ["path", { "d": "M9 9h1", "key": "svg-2" }], ["path", { "d": "M9 13h2.5", "key": "svg-3" }], ["path", { "d": "M9 17h1", "key": "svg-4" }], ["path", { "d": "M14 21v-4a2 2 0 1 1 4 0v4", "key": "svg-5" }], ["path", { "d": "M14 19h4", "key": "svg-6" }], ["path", { "d": "M21 15v6", "key": "svg-7" }]]);

var IconFileTextShield = createVueComponent("outline", "file-text-shield", "FileTextShield", [["path", { "d": "M13 3v4a.997 .997 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M11 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v3.5", "key": "svg-1" }], ["path", { "d": "M8 9h1", "key": "svg-2" }], ["path", { "d": "M8 12.994l3 0", "key": "svg-3" }], ["path", { "d": "M8 16.997l2 0", "key": "svg-4" }], ["path", { "d": "M21 15.994c0 4 -2.5 6 -3.5 6s-3.5 -2 -3.5 -6c1 0 2.5 -.5 3.5 -1.5c1 1 2.5 1.5 3.5 1.5", "key": "svg-5" }]]);

var IconFileTextSpark = createVueComponent("outline", "file-text-spark", "FileTextSpark", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M12 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v3.5", "key": "svg-1" }], ["path", { "d": "M9 9h1", "key": "svg-2" }], ["path", { "d": "M9 13h6", "key": "svg-3" }], ["path", { "d": "M9 17h3", "key": "svg-4" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-5" }]]);

var IconFileText = createVueComponent("outline", "file-text", "FileText", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M9 9l1 0", "key": "svg-2" }], ["path", { "d": "M9 13l6 0", "key": "svg-3" }], ["path", { "d": "M9 17l6 0", "key": "svg-4" }]]);

var IconFileTime = createVueComponent("outline", "file-time", "FileTime", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 14m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }], ["path", { "d": "M12 12.496v1.504l1 1", "key": "svg-3" }]]);

var IconFileTypeBmp = createVueComponent("outline", "file-type-bmp", "FileTypeBmp", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M18 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-2" }], ["path", { "d": "M4 21h1.5a1.5 1.5 0 0 0 0 -3h-1.5h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6z", "key": "svg-3" }], ["path", { "d": "M10 21v-6l2.5 3l2.5 -3v6", "key": "svg-4" }]]);

var IconFileTypeCss = createVueComponent("outline", "file-type-css", "FileTypeCss", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M8 16.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }], ["path", { "d": "M11 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-3" }], ["path", { "d": "M17 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-4" }]]);

var IconFileTypeCsv = createVueComponent("outline", "file-type-csv", "FileTypeCsv", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M7 16.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }], ["path", { "d": "M10 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-3" }], ["path", { "d": "M16 15l2 6l2 -6", "key": "svg-4" }]]);

var IconFileTypeDoc = createVueComponent("outline", "file-type-doc", "FileTypeDoc", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M5 15v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-2" }], ["path", { "d": "M20 16.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-3" }], ["path", { "d": "M12.5 15a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1 -3 0v-3a1.5 1.5 0 0 1 1.5 -1.5z", "key": "svg-4" }]]);

var IconFileTypeDocx = createVueComponent("outline", "file-type-docx", "FileTypeDocx", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M2 15v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-2" }], ["path", { "d": "M17 16.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-3" }], ["path", { "d": "M9.5 15a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1 -3 0v-3a1.5 1.5 0 0 1 1.5 -1.5z", "key": "svg-4" }], ["path", { "d": "M19.5 15l3 6", "key": "svg-5" }], ["path", { "d": "M19.5 21l3 -6", "key": "svg-6" }]]);

var IconFileTypeHtml = createVueComponent("outline", "file-type-html", "FileTypeHtml", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M2 21v-6", "key": "svg-2" }], ["path", { "d": "M5 15v6", "key": "svg-3" }], ["path", { "d": "M2 18h3", "key": "svg-4" }], ["path", { "d": "M20 15v6h2", "key": "svg-5" }], ["path", { "d": "M13 21v-6l2 3l2 -3v6", "key": "svg-6" }], ["path", { "d": "M7.5 15h3", "key": "svg-7" }], ["path", { "d": "M9 15v6", "key": "svg-8" }]]);

var IconFileTypeJpg = createVueComponent("outline", "file-type-jpg", "FileTypeJpg", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M11 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-2" }], ["path", { "d": "M20 15h-1a2 2 0 0 0 -2 2v2a2 2 0 0 0 2 2h1v-3", "key": "svg-3" }], ["path", { "d": "M5 15h3v4.5a1.5 1.5 0 0 1 -3 0", "key": "svg-4" }]]);

var IconFileTypeJs = createVueComponent("outline", "file-type-js", "FileTypeJs", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M3 15h3v4.5a1.5 1.5 0 0 1 -3 0", "key": "svg-1" }], ["path", { "d": "M9 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-2" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1", "key": "svg-3" }]]);

var IconFileTypeJsx = createVueComponent("outline", "file-type-jsx", "FileTypeJsx", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M4 15h3v4.5a1.5 1.5 0 0 1 -3 0", "key": "svg-2" }], ["path", { "d": "M10 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-3" }], ["path", { "d": "M16 15l4 6", "key": "svg-4" }], ["path", { "d": "M16 21l4 -6", "key": "svg-5" }]]);

var IconFileTypePdf = createVueComponent("outline", "file-type-pdf", "FileTypePdf", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M5 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-2" }], ["path", { "d": "M17 18h2", "key": "svg-3" }], ["path", { "d": "M20 15h-3v6", "key": "svg-4" }], ["path", { "d": "M11 15v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-5" }]]);

var IconFileTypePhp = createVueComponent("outline", "file-type-php", "FileTypePhp", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M5 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-2" }], ["path", { "d": "M17 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-3" }], ["path", { "d": "M11 21v-6", "key": "svg-4" }], ["path", { "d": "M14 15v6", "key": "svg-5" }], ["path", { "d": "M11 18h3", "key": "svg-6" }]]);

var IconFileTypePng = createVueComponent("outline", "file-type-png", "FileTypePng", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M20 15h-1a2 2 0 0 0 -2 2v2a2 2 0 0 0 2 2h1v-3", "key": "svg-2" }], ["path", { "d": "M5 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-3" }], ["path", { "d": "M11 21v-6l3 6v-6", "key": "svg-4" }]]);

var IconFileTypePpt = createVueComponent("outline", "file-type-ppt", "FileTypePpt", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M5 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-2" }], ["path", { "d": "M11 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-3" }], ["path", { "d": "M16.5 15h3", "key": "svg-4" }], ["path", { "d": "M18 15v6", "key": "svg-5" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-6" }]]);

var IconFileTypeRs = createVueComponent("outline", "file-type-rs", "FileTypeRs", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M9 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-2" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1", "key": "svg-3" }], ["path", { "d": "M3 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3", "key": "svg-4" }]]);

var IconFileTypeSql = createVueComponent("outline", "file-type-sql", "FileTypeSql", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M5 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-2" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-3" }], ["path", { "d": "M18 15v6h2", "key": "svg-4" }], ["path", { "d": "M13 15a2 2 0 0 1 2 2v2a2 2 0 1 1 -4 0v-2a2 2 0 0 1 2 -2z", "key": "svg-5" }], ["path", { "d": "M14 20l1.5 1.5", "key": "svg-6" }]]);

var IconFileTypeSvg = createVueComponent("outline", "file-type-svg", "FileTypeSvg", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M4 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-2" }], ["path", { "d": "M10 15l2 6l2 -6", "key": "svg-3" }], ["path", { "d": "M20 15h-1a2 2 0 0 0 -2 2v2a2 2 0 0 0 2 2h1v-3", "key": "svg-4" }]]);

var IconFileTypeTs = createVueComponent("outline", "file-type-ts", "FileTypeTs", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1", "key": "svg-1" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M9 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-3" }], ["path", { "d": "M3.5 15h3", "key": "svg-4" }], ["path", { "d": "M5 15v6", "key": "svg-5" }]]);

var IconFileTypeTsx = createVueComponent("outline", "file-type-tsx", "FileTypeTsx", [["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M16 15l4 6", "key": "svg-2" }], ["path", { "d": "M16 21l4 -6", "key": "svg-3" }], ["path", { "d": "M10 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-4" }], ["path", { "d": "M4.5 15h3", "key": "svg-5" }], ["path", { "d": "M6 15v6", "key": "svg-6" }]]);

var IconFileTypeTxt = createVueComponent("outline", "file-type-txt", "FileTypeTxt", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-1" }], ["path", { "d": "M16.5 15h3", "key": "svg-2" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-3" }], ["path", { "d": "M4.5 15h3", "key": "svg-4" }], ["path", { "d": "M6 15v6", "key": "svg-5" }], ["path", { "d": "M18 15v6", "key": "svg-6" }], ["path", { "d": "M10 15l4 6", "key": "svg-7" }], ["path", { "d": "M10 21l4 -6", "key": "svg-8" }]]);

var IconFileTypeVue = createVueComponent("outline", "file-type-vue", "FileTypeVue", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M4 15l2 6l2 -6", "key": "svg-2" }], ["path", { "d": "M11 15v4.5a1.5 1.5 0 0 0 3 0v-4.5", "key": "svg-3" }], ["path", { "d": "M20 15h-3v6h3", "key": "svg-4" }], ["path", { "d": "M17 18h2", "key": "svg-5" }]]);

var IconFileTypeXls = createVueComponent("outline", "file-type-xls", "FileTypeXls", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M4 15l4 6", "key": "svg-2" }], ["path", { "d": "M4 21l4 -6", "key": "svg-3" }], ["path", { "d": "M17 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-4" }], ["path", { "d": "M11 15v6h3", "key": "svg-5" }]]);

var IconFileTypeXml = createVueComponent("outline", "file-type-xml", "FileTypeXml", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M4 15l4 6", "key": "svg-2" }], ["path", { "d": "M4 21l4 -6", "key": "svg-3" }], ["path", { "d": "M19 15v6h3", "key": "svg-4" }], ["path", { "d": "M11 21v-6l2.5 3l2.5 -3v6", "key": "svg-5" }]]);

var IconFileTypeZip = createVueComponent("outline", "file-type-zip", "FileTypeZip", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4", "key": "svg-1" }], ["path", { "d": "M16 18h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6", "key": "svg-2" }], ["path", { "d": "M12 15v6", "key": "svg-3" }], ["path", { "d": "M5 15h3l-3 6h3", "key": "svg-4" }]]);

var IconFileTypography = createVueComponent("outline", "file-typography", "FileTypography", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M11 18h2", "key": "svg-2" }], ["path", { "d": "M12 18v-7", "key": "svg-3" }], ["path", { "d": "M9 12v-1h6v1", "key": "svg-4" }]]);

var IconFileUnknown = createVueComponent("outline", "file-unknown", "FileUnknown", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M12 14a1.5 1.5 0 1 0 -1.14 -2.474", "key": "svg-3" }]]);

var IconFileUpload = createVueComponent("outline", "file-upload", "FileUpload", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M12 11v6", "key": "svg-2" }], ["path", { "d": "M9.5 13.5l2.5 -2.5l2.5 2.5", "key": "svg-3" }]]);

var IconFileVector = createVueComponent("outline", "file-vector", "FileVector", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M9.5 16.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-1" }], ["path", { "d": "M14.5 12.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-2" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-3" }], ["path", { "d": "M9.5 15a2.5 2.5 0 0 1 2.5 -2.5h1", "key": "svg-4" }]]);

var IconFileWord = createVueComponent("outline", "file-word", "FileWord", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2", "key": "svg-1" }], ["path", { "d": "M9 12l1.333 5l1.667 -4l1.667 4l1.333 -5", "key": "svg-2" }]]);

var IconFileX = createVueComponent("outline", "file-x", "FileX", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M10 12l4 4m0 -4l-4 4", "key": "svg-2" }]]);

var IconFileZip = createVueComponent("outline", "file-zip", "FileZip", [["path", { "d": "M6 20.735a2 2 0 0 1 -1 -1.735v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1", "key": "svg-0" }], ["path", { "d": "M11 17a2 2 0 0 1 2 2v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a2 2 0 0 1 2 -2z", "key": "svg-1" }], ["path", { "d": "M11 5l-1 0", "key": "svg-2" }], ["path", { "d": "M13 7l-1 0", "key": "svg-3" }], ["path", { "d": "M11 9l-1 0", "key": "svg-4" }], ["path", { "d": "M13 11l-1 0", "key": "svg-5" }], ["path", { "d": "M11 13l-1 0", "key": "svg-6" }], ["path", { "d": "M13 15l-1 0", "key": "svg-7" }]]);

var IconFile = createVueComponent("outline", "file", "File", [["path", { "d": "M14 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z", "key": "svg-1" }]]);

var IconFilesOff = createVueComponent("outline", "files-off", "FilesOff", [["path", { "d": "M15 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M17 17h-6a2 2 0 0 1 -2 -2v-6m0 -4a2 2 0 0 1 2 -2h4l5 5v7c0 .294 -.063 .572 -.177 .823", "key": "svg-1" }], ["path", { "d": "M16 17v2a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconFiles = createVueComponent("outline", "files", "Files", [["path", { "d": "M15 3v4a1 1 0 0 0 1 1h4", "key": "svg-0" }], ["path", { "d": "M18 17h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h4l5 5v7a2 2 0 0 1 -2 2z", "key": "svg-1" }], ["path", { "d": "M16 17v2a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconFilter2Bolt = createVueComponent("outline", "filter-2-bolt", "Filter2Bolt", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h4", "key": "svg-2" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-3" }]]);

var IconFilter2Cancel = createVueComponent("outline", "filter-2-cancel", "Filter2Cancel", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4m-5 2c0 .796 .316 1.559 .879 2.121c.563 .563 1.326 .879 2.121 .879c.796 0 1.559 -.316 2.121 -.879c.563 -.563 .879 -1.326 .879 -2.121c0 -.796 -.316 -1.559 -.879 -2.121c-.563 -.563 -1.326 -.879 -2.121 -.879c-.796 0 -1.559 .316 -2.121 .879c-.563 .563 -.879 1.326 -.879 2.121z", "key": "svg-3" }]]);

var IconFilter2Check = createVueComponent("outline", "filter-2-check", "Filter2Check", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h2", "key": "svg-2" }], ["path", { "d": "M15 18l2 2l4 -4", "key": "svg-3" }]]);

var IconFilter2Code = createVueComponent("outline", "filter-2-code", "Filter2Code", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }]]);

var IconFilter2Cog = createVueComponent("outline", "filter-2-cog", "Filter2Cog", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M19.001 21c-.53 0 -1.039 -.211 -1.414 -.586c-.375 -.375 -.586 -.884 -.586 -1.414c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586m0 4c.53 0 1.039 -.211 1.414 -.586c.375 -.375 .586 -.884 .586 -1.414c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586m0 4v1.5m0 -5.5v-1.5m3.031 1.75l-1.299 .75m-3.463 2l-1.3 .75m0 -3.5l1.3 .75m3.463 2l1.3 .75", "key": "svg-3" }]]);

var IconFilter2Discount = createVueComponent("outline", "filter-2-discount", "Filter2Discount", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M16 16v.01", "key": "svg-3" }], ["path", { "d": "M16 21l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21v.01", "key": "svg-5" }]]);

var IconFilter2Dollar = createVueComponent("outline", "filter-2-dollar", "Filter2Dollar", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h10", "key": "svg-1" }], ["path", { "d": "M9 18h4", "key": "svg-2" }], ["path", { "d": "M21 15h-2m-2 6h2m0 0v1m0 -1h.5c.398 0 .779 -.158 1.061 -.439c.281 -.281 .439 -.663 .439 -1.061c0 -.398 -.158 -.779 -.439 -1.061c-.281 -.281 -.663 -.439 -1.061 -.439h-1c-.398 0 -.779 -.158 -1.061 -.439c-.281 -.281 -.439 -.663 -.439 -1.061c0 -.398 .158 -.779 .439 -1.061c.281 -.281 .663 -.439 1.061 -.439h.5m0 -1v1", "key": "svg-3" }]]);

var IconFilter2Down = createVueComponent("outline", "filter-2-down", "Filter2Down", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }], ["path", { "d": "M19 22l3 -3", "key": "svg-4" }], ["path", { "d": "M19 22l-3 -3", "key": "svg-5" }]]);

var IconFilter2Edit = createVueComponent("outline", "filter-2-edit", "Filter2Edit", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h11", "key": "svg-1" }], ["path", { "d": "M9 18h2", "key": "svg-2" }], ["path", { "d": "M18.42 15.61c.195 -.195 .426 -.35 .681 -.455c.255 -.106 .528 -.16 .804 -.16c.276 0 .549 .054 .804 .16c.255 .106 .486 .26 .681 .455c.195 .195 .35 .427 .455 .681c.106 .255 .16 .528 .16 .804c0 .276 -.054 .549 -.16 .804c-.105 .255 -.26 .486 -.455 .681l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-3" }]]);

var IconFilter2Exclamation = createVueComponent("outline", "filter-2-exclamation", "Filter2Exclamation", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h6", "key": "svg-2" }], ["path", { "d": "M19 16v3m0 3v.01", "key": "svg-3" }]]);

var IconFilter2Minus = createVueComponent("outline", "filter-2-minus", "Filter2Minus", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconFilter2Pause = createVueComponent("outline", "filter-2-pause", "Filter2Pause", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h4", "key": "svg-2" }], ["path", { "d": "M17 17v5", "key": "svg-3" }], ["path", { "d": "M21 17v5", "key": "svg-4" }]]);

var IconFilter2Pin = createVueComponent("outline", "filter-2-pin", "Filter2Pin", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h10", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M19 18v.01m2.121 2.111c.42 -.419 .706 -.954 .821 -1.536c.116 -.582 .056 -1.185 -.17 -1.733c-.227 -.548 -.611 -1.017 -1.105 -1.347c-.493 -.33 -1.073 -.506 -1.667 -.506c-.593 0 -1.173 .176 -1.667 .506c-.493 .33 -.878 .798 -1.105 1.347c-.227 .548 -.286 1.151 -.17 1.733c.116 .582 .402 1.116 .821 1.536c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-3" }]]);

var IconFilter2Plus = createVueComponent("outline", "filter-2-plus", "Filter2Plus", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h10", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M19 15v6", "key": "svg-3" }], ["path", { "d": "M16 18h6", "key": "svg-4" }]]);

var IconFilter2Question = createVueComponent("outline", "filter-2-question", "Filter2Question", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h10.5", "key": "svg-1" }], ["path", { "d": "M9 18h5", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }], ["path", { "d": "M19 19c.448 -.001 .883 -.153 1.235 -.431c.352 -.278 .6 -.666 .706 -1.101c.105 -.436 .061 -.894 -.125 -1.302c-.186 -.408 -.504 -.742 -.902 -.948c-.398 -.204 -.853 -.267 -1.291 -.179c-.438 .088 -.834 .321 -1.123 .662", "key": "svg-4" }]]);

var IconFilter2Search = createVueComponent("outline", "filter-2-search", "Filter2Search", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h8.5", "key": "svg-1" }], ["path", { "d": "M9 18h2", "key": "svg-2" }], ["path", { "d": "M15 18c0 .796 .316 1.559 .879 2.121c.563 .563 1.326 .879 2.121 .879c.796 0 1.559 -.316 2.121 -.879c.563 -.563 .879 -1.326 .879 -2.121c0 -.796 -.316 -1.559 -.879 -2.121c-.563 -.563 -1.326 -.879 -2.121 -.879c-.796 0 -1.559 .316 -2.121 .879c-.563 .563 -.879 1.326 -.879 2.121z", "key": "svg-3" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-4" }]]);

var IconFilter2Share = createVueComponent("outline", "filter-2-share", "Filter2Share", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3.5", "key": "svg-2" }], ["path", { "d": "M16 22l5 -5", "key": "svg-3" }], ["path", { "d": "M21 17v4.5", "key": "svg-4" }], ["path", { "d": "M21 17h-4.5", "key": "svg-5" }]]);

var IconFilter2Spark = createVueComponent("outline", "filter-2-spark", "Filter2Spark", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h9.5", "key": "svg-1" }], ["path", { "d": "M9 18h2.5", "key": "svg-2" }], ["path", { "d": "M19 21.5c.205 -.849 .641 -1.625 1.258 -2.242c.617 -.617 1.393 -1.053 2.242 -1.258c-.849 -.205 -1.625 -.641 -2.242 -1.258c-.617 -.617 -1.053 -1.393 -1.258 -2.242c-.205 .849 -.641 1.625 -1.258 2.242c-.617 .617 -1.393 1.053 -2.242 1.258c.849 .205 1.625 .641 2.242 1.258c.617 .617 1.053 1.393 1.258 2.242z", "key": "svg-3" }]]);

var IconFilter2Up = createVueComponent("outline", "filter-2-up", "Filter2Up", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h3", "key": "svg-2" }], ["path", { "d": "M19 22v-6m0 0l3 3m-3 -3l-3 3", "key": "svg-3" }]]);

var IconFilter2X = createVueComponent("outline", "filter-2-x", "Filter2X", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h4", "key": "svg-2" }], ["path", { "d": "M22 22l-5 -5m0 5l5 -5", "key": "svg-3" }]]);

var IconFilter2 = createVueComponent("outline", "filter-2", "Filter2", [["path", { "d": "M4 6h16", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M9 18h6", "key": "svg-2" }]]);

var IconFilterBolt = createVueComponent("outline", "filter-bolt", "FilterBolt", [["path", { "d": "M12.991 19.67l-3.991 1.33v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v3", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }]]);

var IconFilterCancel = createVueComponent("outline", "filter-cancel", "FilterCancel", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1.5", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }]]);

var IconFilterCheck = createVueComponent("outline", "filter-check", "FilterCheck", [["path", { "d": "M11.18 20.274l-2.18 .726v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v3", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }]]);

var IconFilterCode = createVueComponent("outline", "filter-code", "FilterCode", [["path", { "d": "M11.19 20.27l-2.19 .73v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1.5", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }]]);

var IconFilterCog = createVueComponent("outline", "filter-cog", "FilterCog", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1.5", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }]]);

var IconFilterDiscount = createVueComponent("outline", "filter-discount", "FilterDiscount", [["path", { "d": "M12.705 19.765l-3.705 1.235v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v.5", "key": "svg-0" }], ["path", { "d": "M16 21l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21v.01", "key": "svg-2" }], ["path", { "d": "M16 16v.01", "key": "svg-3" }]]);

var IconFilterDollar = createVueComponent("outline", "filter-dollar", "FilterDollar", [["path", { "d": "M13.25 19.583l-4.25 1.417v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414", "key": "svg-0" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-1" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-2" }]]);

var IconFilterDown = createVueComponent("outline", "filter-down", "FilterDown", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v3", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }]]);

var IconFilterEdit = createVueComponent("outline", "filter-edit", "FilterEdit", [["path", { "d": "M10.97 20.344l-1.97 .656v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1.5", "key": "svg-0" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-1" }]]);

var IconFilterExclamation = createVueComponent("outline", "filter-exclamation", "FilterExclamation", [["path", { "d": "M4 4h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v7l-6 2v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227z", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconFilterHeart = createVueComponent("outline", "filter-heart", "FilterHeart", [["path", { "d": "M10.888 20.37l-1.888 .63v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-3.503 3.503", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }]]);

var IconFilterMinus = createVueComponent("outline", "filter-minus", "FilterMinus", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v3", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconFilterOff = createVueComponent("outline", "filter-off", "FilterOff", [["path", { "d": "M8 4h12v2.172a2 2 0 0 1 -.586 1.414l-3.914 3.914m-.5 3.5v4l-6 2v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconFilterPause = createVueComponent("outline", "filter-pause", "FilterPause", [["path", { "d": "M12.97 19.677l-3.97 1.323v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1.5", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }]]);

var IconFilterPin = createVueComponent("outline", "filter-pin", "FilterPin", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }]]);

var IconFilterPlus = createVueComponent("outline", "filter-plus", "FilterPlus", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v3", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconFilterQuestion = createVueComponent("outline", "filter-question", "FilterQuestion", [["path", { "d": "M15 19l-6 2v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconFilterSearch = createVueComponent("outline", "filter-search", "FilterSearch", [["path", { "d": "M11.36 20.213l-2.36 .787v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }]]);

var IconFilterShare = createVueComponent("outline", "filter-share", "FilterShare", [["path", { "d": "M12.713 19.762l-3.713 1.238v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }]]);

var IconFilterSpark = createVueComponent("outline", "filter-spark", "FilterSpark", [["path", { "d": "M15 12.5v-.5l4.414 -4.414a2 2 0 0 0 .586 -1.414v-2.172h-16v2.227c0 .497 .185 .977 .52 1.345l4.48 4.928v8.5l2 -.667", "key": "svg-0" }], ["path", { "d": "M18.5 22a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-1" }]]);

var IconFilterStar = createVueComponent("outline", "filter-star", "FilterStar", [["path", { "d": "M11.042 20.32l-2.042 .68v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }]]);

var IconFilterUp = createVueComponent("outline", "filter-up", "FilterUp", [["path", { "d": "M12 20l-3 1v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v2", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }]]);

var IconFilterX = createVueComponent("outline", "filter-x", "FilterX", [["path", { "d": "M13.758 19.414l-4.758 1.586v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v1.5", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconFilter = createVueComponent("outline", "filter", "Filter", [["path", { "d": "M4 4h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v7l-6 2v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227z", "key": "svg-0" }]]);

var IconFilters = createVueComponent("outline", "filters", "Filters", [["path", { "d": "M12 8m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-0" }], ["path", { "d": "M8 11a5 5 0 1 0 3.998 1.997", "key": "svg-1" }], ["path", { "d": "M12.002 19.003a5 5 0 1 0 3.998 -8.003", "key": "svg-2" }]]);

var IconFingerprintOff = createVueComponent("outline", "fingerprint-off", "FingerprintOff", [["path", { "d": "M18.9 7a8 8 0 0 1 1.1 5v1a6 6 0 0 0 .8 3", "key": "svg-0" }], ["path", { "d": "M8 11c0 -.848 .264 -1.634 .713 -2.28m2.4 -1.621a4 4 0 0 1 4.887 3.901l0 1", "key": "svg-1" }], ["path", { "d": "M12 12v1a14 14 0 0 0 2.5 8", "key": "svg-2" }], ["path", { "d": "M8 15a18 18 0 0 0 1.8 6", "key": "svg-3" }], ["path", { "d": "M4.9 19a22 22 0 0 1 -.9 -7v-1a8 8 0 0 1 1.854 -5.143m2.176 -1.825a8 8 0 0 1 7.97 .018", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconFingerprintScan = createVueComponent("outline", "fingerprint-scan", "FingerprintScan", [["path", { "d": "M9 11a3 3 0 0 1 6 0c0 1.657 .612 3.082 1 4", "key": "svg-0" }], ["path", { "d": "M12 11v1.75c-.001 1.11 .661 2.206 1 3.25", "key": "svg-1" }], ["path", { "d": "M9 14.25c.068 .58 .358 1.186 .5 1.75", "key": "svg-2" }], ["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-3" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-4" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-5" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-6" }]]);

var IconFingerprint = createVueComponent("outline", "fingerprint", "Fingerprint", [["path", { "d": "M18.9 7a8 8 0 0 1 1.1 5v1a6 6 0 0 0 .8 3", "key": "svg-0" }], ["path", { "d": "M8 11a4 4 0 0 1 8 0v1a10 10 0 0 0 2 6", "key": "svg-1" }], ["path", { "d": "M12 11v2a14 14 0 0 0 2.5 8", "key": "svg-2" }], ["path", { "d": "M8 15a18 18 0 0 0 1.8 6", "key": "svg-3" }], ["path", { "d": "M4.9 19a22 22 0 0 1 -.9 -7v-1a8 8 0 0 1 12 -6.95", "key": "svg-4" }]]);

var IconFireExtinguisher = createVueComponent("outline", "fire-extinguisher", "FireExtinguisher", [["path", { "d": "M12 7a4 4 0 0 1 4 4v9a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1v-9a4 4 0 0 1 4 -4z", "key": "svg-0" }], ["path", { "d": "M9 16h6", "key": "svg-1" }], ["path", { "d": "M12 7v-3", "key": "svg-2" }], ["path", { "d": "M16 5l-4 -1l4 -1", "key": "svg-3" }], ["path", { "d": "M12 4h-3a3 3 0 0 0 -3 3", "key": "svg-4" }]]);

var IconFireHydrantOff = createVueComponent("outline", "fire-hydrant-off", "FireHydrantOff", [["path", { "d": "M5 21h14", "key": "svg-0" }], ["path", { "d": "M17 21v-4m2 -2v-2a1 1 0 0 0 -1 -1h-1v-4a5 5 0 0 0 -8.533 -3.538m-1.387 2.638a5.03 5.03 0 0 0 -.08 .9v4h-1a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h1v5", "key": "svg-1" }], ["path", { "d": "M12 12a2 2 0 1 0 2 2", "key": "svg-2" }], ["path", { "d": "M6 8h2m4 0h6", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconFireHydrant = createVueComponent("outline", "fire-hydrant", "FireHydrant", [["path", { "d": "M5 21h14", "key": "svg-0" }], ["path", { "d": "M17 21v-5h1a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-1v-4a5 5 0 0 0 -10 0v4h-1a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h1v5", "key": "svg-1" }], ["path", { "d": "M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M6 8h12", "key": "svg-3" }]]);

var IconFiretruck = createVueComponent("outline", "firetruck", "Firetruck", [["path", { "d": "M5 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 18h8m4 0h2v-6a5 5 0 0 0 -5 -5h-1l1.5 5h4.5", "key": "svg-2" }], ["path", { "d": "M12 18v-11h3", "key": "svg-3" }], ["path", { "d": "M3 17l0 -5l9 0", "key": "svg-4" }], ["path", { "d": "M3 9l18 -6", "key": "svg-5" }], ["path", { "d": "M6 12l0 -4", "key": "svg-6" }]]);

var IconFirstAidKitOff = createVueComponent("outline", "first-aid-kit-off", "FirstAidKitOff", [["path", { "d": "M8.595 4.577a2 2 0 0 1 1.405 -.577h4a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M12 8h6a2 2 0 0 1 2 2v6m-.576 3.405a2 2 0 0 1 -1.424 .595h-12a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M12 12v4", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconFirstAidKit = createVueComponent("outline", "first-aid-kit", "FirstAidKit", [["path", { "d": "M8 8v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M4 8m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M12 12v4", "key": "svg-3" }]]);

var IconFishBone = createVueComponent("outline", "fish-bone", "FishBone", [["path", { "d": "M16.69 7.44a6.973 6.973 0 0 0 -1.69 4.56a6.97 6.97 0 0 0 1.699 4.571c1.914 -.684 3.691 -2.183 5.301 -4.565c-1.613 -2.384 -3.394 -3.883 -5.312 -4.565", "key": "svg-0" }], ["path", { "d": "M2 9.504a40.73 40.73 0 0 0 2.422 2.504a39.679 39.679 0 0 0 -2.422 2.498", "key": "svg-1" }], ["path", { "d": "M18 11v.01", "key": "svg-2" }], ["path", { "d": "M4.422 12h10.578", "key": "svg-3" }], ["path", { "d": "M7 10v4", "key": "svg-4" }], ["path", { "d": "M11 8v8", "key": "svg-5" }]]);

var IconFishChristianity = createVueComponent("outline", "fish-christianity", "FishChristianity", [["path", { "d": "M22 7s-5.646 10 -12.308 10c-3.226 .025 -6.194 -1.905 -7.692 -5c1.498 -3.095 4.466 -5.025 7.692 -5c6.662 0 12.308 10 12.308 10", "key": "svg-0" }]]);

var IconFishHookOff = createVueComponent("outline", "fish-hook-off", "FishHookOff", [["path", { "d": "M16 9v3m-.085 3.924a5 5 0 0 1 -9.915 -.924v-4l3 3", "key": "svg-0" }], ["path", { "d": "M16 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M16 5v-2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconFishHook = createVueComponent("outline", "fish-hook", "FishHook", [["path", { "d": "M16 9v6a5 5 0 0 1 -10 0v-4l3 3", "key": "svg-0" }], ["path", { "d": "M16 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M16 5v-2", "key": "svg-2" }]]);

var IconFishOff = createVueComponent("outline", "fish-off", "FishOff", [["path", { "d": "M16.69 7.44a6.973 6.973 0 0 0 -1.63 3.635", "key": "svg-0" }], ["path", { "d": "M2 9.504c5.307 5.948 10.293 8.57 14.597 7.1m2.583 -1.449c.988 -.788 1.93 -1.836 2.82 -3.153c-3 -4.443 -6.596 -5.812 -10.564 -4.548m-2.764 1.266c-2.145 1.266 -4.378 3.215 -6.672 5.786", "key": "svg-1" }], ["path", { "d": "M18 11v.01", "key": "svg-2" }], ["path", { "d": "M11.153 11.169c-.287 .777 -.171 1.554 .347 2.331", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconFish = createVueComponent("outline", "fish", "Fish", [["path", { "d": "M16.69 7.44a6.973 6.973 0 0 0 -1.69 4.56c0 1.747 .64 3.345 1.699 4.571", "key": "svg-0" }], ["path", { "d": "M2 9.504c7.715 8.647 14.75 10.265 20 2.498c-5.25 -7.761 -12.285 -6.142 -20 2.504", "key": "svg-1" }], ["path", { "d": "M18 11v.01", "key": "svg-2" }], ["path", { "d": "M11.5 10.5c-.667 1 -.667 2 0 3", "key": "svg-3" }]]);

var IconFlag2Off = createVueComponent("outline", "flag-2-off", "Flag2Off", [["path", { "d": "M5 14h9m4 0h1v-9h-10m-4 0v16", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconFlag2 = createVueComponent("outline", "flag-2", "Flag2", [["path", { "d": "M5 14h14v-9h-14v16", "key": "svg-0" }]]);

var IconFlag3 = createVueComponent("outline", "flag-3", "Flag3", [["path", { "d": "M5 14h14l-4.5 -4.5l4.5 -4.5h-14v16", "key": "svg-0" }]]);

var IconFlagBitcoin = createVueComponent("outline", "flag-bitcoin", "FlagBitcoin", [["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-0" }], ["path", { "d": "M13.222 14.882a5 5 0 0 1 -1.222 -.882a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v5", "key": "svg-1" }], ["path", { "d": "M5 21v-7", "key": "svg-2" }]]);

var IconFlagBolt = createVueComponent("outline", "flag-bolt", "FlagBolt", [["path", { "d": "M14.673 15.36a4.978 4.978 0 0 1 -2.673 -1.36a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v7", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconFlagCancel = createVueComponent("outline", "flag-cancel", "FlagCancel", [["path", { "d": "M13.342 14.941a4.993 4.993 0 0 1 -1.342 -.941a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v7", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconFlagCheck = createVueComponent("outline", "flag-check", "FlagCheck", [["path", { "d": "M13.767 15.12a4.983 4.983 0 0 1 -1.767 -1.12a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v8.5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconFlagCode = createVueComponent("outline", "flag-code", "FlagCode", [["path", { "d": "M13.41 14.973a4.991 4.991 0 0 1 -1.41 -.973a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v8", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconFlagCog = createVueComponent("outline", "flag-cog", "FlagCog", [["path", { "d": "M12.901 14.702a5.014 5.014 0 0 1 -.901 -.702a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v6.5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconFlagDiscount = createVueComponent("outline", "flag-discount", "FlagDiscount", [["path", { "d": "M12.804 14.641a5.02 5.02 0 0 1 -.804 -.641a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v8", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M16 21l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21v.01", "key": "svg-3" }], ["path", { "d": "M16 16v.01", "key": "svg-4" }]]);

var IconFlagDollar = createVueComponent("outline", "flag-dollar", "FlagDollar", [["path", { "d": "M13.222 14.882a4.998 4.998 0 0 1 -1.222 -.882a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconFlagDown = createVueComponent("outline", "flag-down", "FlagDown", [["path", { "d": "M14.434 15.315a4.978 4.978 0 0 1 -2.434 -1.315a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v7", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconFlagExclamation = createVueComponent("outline", "flag-exclamation", "FlagExclamation", [["path", { "d": "M15.035 15.408a4.98 4.98 0 0 1 -3.035 -1.408a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v7", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconFlagHeart = createVueComponent("outline", "flag-heart", "FlagHeart", [["path", { "d": "M11.33 13.447a5.001 5.001 0 0 0 -6.33 .553v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v6", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconFlagMinus = createVueComponent("outline", "flag-minus", "FlagMinus", [["path", { "d": "M14.373 15.301a4.978 4.978 0 0 1 -2.373 -1.301a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v9", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconFlagOff = createVueComponent("outline", "flag-off", "FlagOff", [["path", { "d": "M5 5v16", "key": "svg-0" }], ["path", { "d": "M19 5v9", "key": "svg-1" }], ["path", { "d": "M7.641 3.645a5 5 0 0 1 4.359 1.355a5 5 0 0 0 7 0", "key": "svg-2" }], ["path", { "d": "M5 14a5 5 0 0 1 7 0a4.984 4.984 0 0 0 3.437 1.429m3.019 -.966c.19 -.14 .371 -.294 .544 -.463", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconFlagPause = createVueComponent("outline", "flag-pause", "FlagPause", [["path", { "d": "M13.536 15.029a4.987 4.987 0 0 1 -1.536 -1.029a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v8.5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconFlagPin = createVueComponent("outline", "flag-pin", "FlagPin", [["path", { "d": "M12.857 14.675a5.016 5.016 0 0 1 -.857 -.675a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v6", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconFlagPlus = createVueComponent("outline", "flag-plus", "FlagPlus", [["path", { "d": "M14.433 15.315a4.978 4.978 0 0 1 -2.433 -1.315a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v7", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconFlagQuestion = createVueComponent("outline", "flag-question", "FlagQuestion", [["path", { "d": "M13.5 15a4.914 4.914 0 0 1 -1.5 -1a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v6", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconFlagSearch = createVueComponent("outline", "flag-search", "FlagSearch", [["path", { "d": "M12 14a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v6", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconFlagShare = createVueComponent("outline", "flag-share", "FlagShare", [["path", { "d": "M13.13 14.833a5.002 5.002 0 0 1 -1.13 -.833a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v8", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconFlagSpark = createVueComponent("outline", "flag-spark", "FlagSpark", [["path", { "d": "M14.165 15.249a5 5 0 0 1 -2.165 -1.249a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v6.5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-2" }]]);

var IconFlagStar = createVueComponent("outline", "flag-star", "FlagStar", [["path", { "d": "M11.475 13.551a5.001 5.001 0 0 0 -6.475 .449v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconFlagUp = createVueComponent("outline", "flag-up", "FlagUp", [["path", { "d": "M14.138 15.241a4.979 4.979 0 0 1 -2.138 -1.241a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v7", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconFlagX = createVueComponent("outline", "flag-x", "FlagX", [["path", { "d": "M13.533 15.028a4.988 4.988 0 0 1 -1.533 -1.028a5 5 0 0 0 -7 0v-9a5 5 0 0 1 7 0a5 5 0 0 0 7 0v8.5", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconFlag = createVueComponent("outline", "flag", "Flag", [["path", { "d": "M5 5a5 5 0 0 1 7 0a5 5 0 0 0 7 0v9a5 5 0 0 1 -7 0a5 5 0 0 0 -7 0v-9z", "key": "svg-0" }], ["path", { "d": "M5 21v-7", "key": "svg-1" }]]);

var IconFlameOff = createVueComponent("outline", "flame-off", "FlameOff", [["path", { "d": "M8.973 8.974c-.335 .378 -.67 .716 -.973 1.026c-1.226 1.26 -2 3.24 -2 5a6 6 0 0 0 11.472 2.466m.383 -3.597c-.32 -1.409 -1.122 -3.045 -1.855 -3.869c-.281 .472 -.543 .87 -.79 1.202m-2.358 -2.35c-.068 -2.157 -1.182 -4.184 -1.852 -4.852c0 .968 -.18 1.801 -.465 2.527", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconFlame = createVueComponent("outline", "flame", "Flame", [["path", { "d": "M12 10.941c2.333 -3.308 .167 -7.823 -1 -8.941c0 3.395 -2.235 5.299 -3.667 6.706c-1.43 1.408 -2.333 3.621 -2.333 5.588c0 3.704 3.134 6.706 7 6.706s7 -3.002 7 -6.706c0 -1.712 -1.232 -4.403 -2.333 -5.588c-2.084 3.353 -3.257 3.353 -4.667 2.235", "key": "svg-0" }]]);

var IconFlare = createVueComponent("outline", "flare", "Flare", [["path", { "d": "M12 3l3 6l6 3l-6 3l-3 6l-3 -6l-6 -3l6 -3z", "key": "svg-0" }]]);

var IconFlask2Off = createVueComponent("outline", "flask-2-off", "Flask2Off", [["path", { "d": "M6.1 15h8.9", "key": "svg-0" }], ["path", { "d": "M17.742 17.741a6 6 0 0 1 -2.424 3.259h-6.635a6 6 0 0 1 1.317 -10.66v-.326m0 -4.014v-3h4v7m.613 .598a6 6 0 0 1 2.801 2.817", "key": "svg-1" }], ["path", { "d": "M9 3h6", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconFlask2 = createVueComponent("outline", "flask-2", "Flask2", [["path", { "d": "M6.1 15h11.8", "key": "svg-0" }], ["path", { "d": "M14 3v7.342a6 6 0 0 1 1.318 10.658h-6.635a6 6 0 0 1 1.317 -10.66v-7.34h4z", "key": "svg-1" }], ["path", { "d": "M9 3h6", "key": "svg-2" }]]);

var IconFlaskOff = createVueComponent("outline", "flask-off", "FlaskOff", [["path", { "d": "M9 3h6", "key": "svg-0" }], ["path", { "d": "M13 9h1", "key": "svg-1" }], ["path", { "d": "M10 3v3m-.268 3.736l-3.732 10.264a.7 .7 0 0 0 .5 1h11a.7 .7 0 0 0 .5 -1l-1.143 -3.142m-2.288 -6.294l-.569 -1.564v-6", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconFlask = createVueComponent("outline", "flask", "Flask", [["path", { "d": "M9 3l6 0", "key": "svg-0" }], ["path", { "d": "M10 9l4 0", "key": "svg-1" }], ["path", { "d": "M10 3v6l-4 11a.7 .7 0 0 0 .5 1h11a.7 .7 0 0 0 .5 -1l-4 -11v-6", "key": "svg-2" }]]);

var IconFlipFlops = createVueComponent("outline", "flip-flops", "FlipFlops", [["path", { "d": "M18 4c2.21 0 4 1.682 4 3.758c0 .078 0 .156 -.008 .234l-.6 9.014c-.11 1.683 -1.596 3 -3.392 3s-3.28 -1.311 -3.392 -3l-.6 -9.014c-.138 -2.071 1.538 -3.855 3.743 -3.985a4.15 4.15 0 0 1 .25 -.007z", "key": "svg-0" }], ["path", { "d": "M14.5 14c1 -3.333 2.167 -5 3.5 -5c1.333 0 2.5 1.667 3.5 5", "key": "svg-1" }], ["path", { "d": "M18 16v1", "key": "svg-2" }], ["path", { "d": "M6 4c2.21 0 4 1.682 4 3.758c0 .078 0 .156 -.008 .234l-.6 9.014c-.11 1.683 -1.596 3 -3.392 3s-3.28 -1.311 -3.392 -3l-.6 -9.014c-.138 -2.071 1.538 -3.855 3.742 -3.985c.084 0 .167 -.007 .25 -.007z", "key": "svg-3" }], ["path", { "d": "M2.5 14c1 -3.333 2.167 -5 3.5 -5c1.333 0 2.5 1.667 3.5 5", "key": "svg-4" }], ["path", { "d": "M6 16v1", "key": "svg-5" }]]);

var IconFlipHorizontal = createVueComponent("outline", "flip-horizontal", "FlipHorizontal", [["path", { "d": "M3 12l18 0", "key": "svg-0" }], ["path", { "d": "M7 16l10 0l-10 5l0 -5", "key": "svg-1" }], ["path", { "d": "M7 8l10 0l-10 -5l0 5", "key": "svg-2" }]]);

var IconFlipVertical = createVueComponent("outline", "flip-vertical", "FlipVertical", [["path", { "d": "M12 3l0 18", "key": "svg-0" }], ["path", { "d": "M16 7l0 10l5 0l-5 -10", "key": "svg-1" }], ["path", { "d": "M8 7l0 10l-5 0l5 -10", "key": "svg-2" }]]);

var IconFloatCenter = createVueComponent("outline", "float-center", "FloatCenter", [["path", { "d": "M9 5m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 7l1 0", "key": "svg-1" }], ["path", { "d": "M4 11l1 0", "key": "svg-2" }], ["path", { "d": "M19 7l1 0", "key": "svg-3" }], ["path", { "d": "M19 11l1 0", "key": "svg-4" }], ["path", { "d": "M4 15l16 0", "key": "svg-5" }], ["path", { "d": "M4 19l16 0", "key": "svg-6" }]]);

var IconFloatLeft = createVueComponent("outline", "float-left", "FloatLeft", [["path", { "d": "M4 5m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M14 7l6 0", "key": "svg-1" }], ["path", { "d": "M14 11l6 0", "key": "svg-2" }], ["path", { "d": "M4 15l16 0", "key": "svg-3" }], ["path", { "d": "M4 19l16 0", "key": "svg-4" }]]);

var IconFloatNone = createVueComponent("outline", "float-none", "FloatNone", [["path", { "d": "M4 5m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 15l16 0", "key": "svg-1" }], ["path", { "d": "M4 19l16 0", "key": "svg-2" }]]);

var IconFloatRight = createVueComponent("outline", "float-right", "FloatRight", [["path", { "d": "M14 5m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 7l6 0", "key": "svg-1" }], ["path", { "d": "M4 11l6 0", "key": "svg-2" }], ["path", { "d": "M4 15l16 0", "key": "svg-3" }], ["path", { "d": "M4 19l16 0", "key": "svg-4" }]]);

var IconFlowerOff = createVueComponent("outline", "flower-off", "FlowerOff", [["path", { "d": "M9.875 9.882a3 3 0 0 0 4.247 4.238m.581 -3.423a3.012 3.012 0 0 0 -1.418 -1.409", "key": "svg-0" }], ["path", { "d": "M9 5a3 3 0 0 1 6 0c0 .562 -.259 1.442 -.776 2.64l-.724 1.36l1.76 -1.893c.499 -.6 .922 -1 1.27 -1.205a2.968 2.968 0 0 1 4.07 1.099a3.011 3.011 0 0 1 -1.09 4.098c-.374 .217 -.99 .396 -1.846 .535l-1.779 .244m.292 .282l1.223 .166c1 .145 1.698 .337 2.11 .576a3.011 3.011 0 0 1 1.226 3.832m-2.277 1.733a2.968 2.968 0 0 1 -1.929 -.369c-.348 -.202 -.771 -.604 -1.27 -1.205l-1.76 -1.893l.724 1.36c.516 1.199 .776 2.079 .776 2.64a3 3 0 0 1 -6 0c0 -.562 .259 -1.442 .776 -2.64l.724 -1.36l-1.76 1.893c-.499 .601 -.922 1 -1.27 1.205a2.968 2.968 0 0 1 -4.07 -1.098a3.011 3.011 0 0 1 1.09 -4.098c.374 -.218 .99 -.396 1.846 -.536l2.664 -.366l-2.4 -.325c-1 -.145 -1.698 -.337 -2.11 -.576a3.011 3.011 0 0 1 -1.09 -4.099a2.968 2.968 0 0 1 2.134 -1.467", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconFlower = createVueComponent("outline", "flower", "Flower", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 2a3 3 0 0 1 3 3c0 .562 -.259 1.442 -.776 2.64l-.724 1.36l1.76 -1.893c.499 -.6 .922 -1 1.27 -1.205a2.968 2.968 0 0 1 4.07 1.099a3.011 3.011 0 0 1 -1.09 4.098c-.374 .217 -.99 .396 -1.846 .535l-2.664 .366l2.4 .326c1 .145 1.698 .337 2.11 .576a3.011 3.011 0 0 1 1.09 4.098a2.968 2.968 0 0 1 -4.07 1.098c-.348 -.202 -.771 -.604 -1.27 -1.205l-1.76 -1.893l.724 1.36c.516 1.199 .776 2.079 .776 2.64a3 3 0 0 1 -6 0c0 -.562 .259 -1.442 .776 -2.64l.724 -1.36l-1.76 1.893c-.499 .601 -.922 1 -1.27 1.205a2.968 2.968 0 0 1 -4.07 -1.098a3.011 3.011 0 0 1 1.09 -4.098c.374 -.218 .99 -.396 1.846 -.536l2.664 -.366l-2.4 -.325c-1 -.145 -1.698 -.337 -2.11 -.576a3.011 3.011 0 0 1 -1.09 -4.099a2.968 2.968 0 0 1 4.07 -1.099c.348 .203 .771 .604 1.27 1.205l1.76 1.894c-1 -2.292 -1.5 -3.625 -1.5 -4a3 3 0 0 1 3 -3z", "key": "svg-1" }]]);

var IconFocus2 = createVueComponent("outline", "focus-2", "Focus2", [["circle", { "cx": "12", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-0" }], ["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-1" }], ["path", { "d": "M12 3l0 2", "key": "svg-2" }], ["path", { "d": "M3 12l2 0", "key": "svg-3" }], ["path", { "d": "M12 19l0 2", "key": "svg-4" }], ["path", { "d": "M19 12l2 0", "key": "svg-5" }]]);

var IconFocusAuto = createVueComponent("outline", "focus-auto", "FocusAuto", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M10 15v-4a2 2 0 1 1 4 0v4", "key": "svg-4" }], ["path", { "d": "M10 13h4", "key": "svg-5" }]]);

var IconFocusCentered = createVueComponent("outline", "focus-centered", "FocusCentered", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-2" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-3" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-4" }]]);

var IconFocus = createVueComponent("outline", "focus", "Focus", [["circle", { "cx": "12", "cy": "12", "r": ".5", "fill": "currentColor", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconFoldDown = createVueComponent("outline", "fold-down", "FoldDown", [["path", { "d": "M12 11v8l3 -3m-6 0l3 3", "key": "svg-0" }], ["path", { "d": "M9 7l1 0", "key": "svg-1" }], ["path", { "d": "M14 7l1 0", "key": "svg-2" }], ["path", { "d": "M19 7l1 0", "key": "svg-3" }], ["path", { "d": "M4 7l1 0", "key": "svg-4" }]]);

var IconFoldUp = createVueComponent("outline", "fold-up", "FoldUp", [["path", { "d": "M12 13v-8l-3 3m6 0l-3 -3", "key": "svg-0" }], ["path", { "d": "M9 17l1 0", "key": "svg-1" }], ["path", { "d": "M14 17l1 0", "key": "svg-2" }], ["path", { "d": "M19 17l1 0", "key": "svg-3" }], ["path", { "d": "M4 17l1 0", "key": "svg-4" }]]);

var IconFold = createVueComponent("outline", "fold", "Fold", [["path", { "d": "M12 3v6l3 -3m-6 0l3 3", "key": "svg-0" }], ["path", { "d": "M12 21v-6l3 3m-6 0l3 -3", "key": "svg-1" }], ["path", { "d": "M4 12l1 0", "key": "svg-2" }], ["path", { "d": "M9 12l1 0", "key": "svg-3" }], ["path", { "d": "M14 12l1 0", "key": "svg-4" }], ["path", { "d": "M19 12l1 0", "key": "svg-5" }]]);

var IconFolderBolt = createVueComponent("outline", "folder-bolt", "FolderBolt", [["path", { "d": "M13 19h-8a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }]]);

var IconFolderCancel = createVueComponent("outline", "folder-cancel", "FolderCancel", [["path", { "d": "M12 19h-7a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }]]);

var IconFolderCheck = createVueComponent("outline", "folder-check", "FolderCheck", [["path", { "d": "M11 19h-6a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }]]);

var IconFolderCode = createVueComponent("outline", "folder-code", "FolderCode", [["path", { "d": "M11 19h-6a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }]]);

var IconFolderCog = createVueComponent("outline", "folder-cog", "FolderCog", [["path", { "d": "M12.5 19h-7.5a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }]]);

var IconFolderDollar = createVueComponent("outline", "folder-dollar", "FolderDollar", [["path", { "d": "M13.5 19h-8.5a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v1.5", "key": "svg-0" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-1" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-2" }]]);

var IconFolderDown = createVueComponent("outline", "folder-down", "FolderDown", [["path", { "d": "M12 19h-7a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }]]);

var IconFolderExclamation = createVueComponent("outline", "folder-exclamation", "FolderExclamation", [["path", { "d": "M15 19h-10a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconFolderHeart = createVueComponent("outline", "folder-heart", "FolderHeart", [["path", { "d": "M10.5 19h-5.5a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }]]);

var IconFolderMinus = createVueComponent("outline", "folder-minus", "FolderMinus", [["path", { "d": "M12 19h-7a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconFolderOff = createVueComponent("outline", "folder-off", "FolderOff", [["path", { "d": "M8 4h1l3 3h7a2 2 0 0 1 2 2v8m-2 2h-14a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 1.189 -1.829", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconFolderOpen = createVueComponent("outline", "folder-open", "FolderOpen", [["path", { "d": "M5 19l2.757 -7.351a1 1 0 0 1 .936 -.649h12.307a1 1 0 0 1 .986 1.164l-.996 5.211a2 2 0 0 1 -1.964 1.625h-14.026a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v2", "key": "svg-0" }]]);

var IconFolderPause = createVueComponent("outline", "folder-pause", "FolderPause", [["path", { "d": "M13 19h-8a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }]]);

var IconFolderPin = createVueComponent("outline", "folder-pin", "FolderPin", [["path", { "d": "M12 19h-7a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }]]);

var IconFolderPlus = createVueComponent("outline", "folder-plus", "FolderPlus", [["path", { "d": "M12 19h-7a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconFolderQuestion = createVueComponent("outline", "folder-question", "FolderQuestion", [["path", { "d": "M15 19h-10a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconFolderRoot = createVueComponent("outline", "folder-root", "FolderRoot", [["path", { "d": "M12 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 15v4", "key": "svg-1" }], ["path", { "d": "M5 4h4l3 3h7a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2", "key": "svg-2" }]]);

var IconFolderSearch = createVueComponent("outline", "folder-search", "FolderSearch", [["path", { "d": "M11 19h-6a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }]]);

var IconFolderShare = createVueComponent("outline", "folder-share", "FolderShare", [["path", { "d": "M13 19h-8a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }]]);

var IconFolderStar = createVueComponent("outline", "folder-star", "FolderStar", [["path", { "d": "M10 19h-5a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }]]);

var IconFolderSymlink = createVueComponent("outline", "folder-symlink", "FolderSymlink", [["path", { "d": "M3 21v-4a3 3 0 0 1 3 -3h5", "key": "svg-0" }], ["path", { "d": "M8 17l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 11v-5a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-8", "key": "svg-2" }]]);

var IconFolderUp = createVueComponent("outline", "folder-up", "FolderUp", [["path", { "d": "M12 19h-7a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }]]);

var IconFolderX = createVueComponent("outline", "folder-x", "FolderX", [["path", { "d": "M13.5 19h-8.5a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2h4l3 3h7a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconFolder = createVueComponent("outline", "folder", "Folder", [["path", { "d": "M5 4h4l3 3h7a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2", "key": "svg-0" }]]);

var IconFoldersOff = createVueComponent("outline", "folders-off", "FoldersOff", [["path", { "d": "M17 17h-8a2 2 0 0 1 -2 -2v-8m1.177 -2.823c.251 -.114 .53 -.177 .823 -.177h3l2 2h5a2 2 0 0 1 2 2v7c0 .55 -.223 1.05 -.583 1.411", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconFolders = createVueComponent("outline", "folders", "Folders", [["path", { "d": "M9 3h3l2 2h5a2 2 0 0 1 2 2v7a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M17 16v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h2", "key": "svg-1" }]]);

var IconForbid2 = createVueComponent("outline", "forbid-2", "Forbid2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 15l6 -6", "key": "svg-1" }]]);

var IconForbid = createVueComponent("outline", "forbid", "Forbid", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 9l6 6", "key": "svg-1" }]]);

var IconForklift = createVueComponent("outline", "forklift", "Forklift", [["path", { "d": "M5 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M14 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 17l5 0", "key": "svg-2" }], ["path", { "d": "M3 17v-6h13v6", "key": "svg-3" }], ["path", { "d": "M5 11v-4h4", "key": "svg-4" }], ["path", { "d": "M9 11v-6h4l3 6", "key": "svg-5" }], ["path", { "d": "M22 15h-3v-10", "key": "svg-6" }], ["path", { "d": "M16 13l3 0", "key": "svg-7" }]]);

var IconForms = createVueComponent("outline", "forms", "Forms", [["path", { "d": "M12 3a3 3 0 0 0 -3 3v12a3 3 0 0 0 3 3", "key": "svg-0" }], ["path", { "d": "M6 3a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3", "key": "svg-1" }], ["path", { "d": "M13 7h7a1 1 0 0 1 1 1v8a1 1 0 0 1 -1 1h-7", "key": "svg-2" }], ["path", { "d": "M5 7h-1a1 1 0 0 0 -1 1v8a1 1 0 0 0 1 1h1", "key": "svg-3" }], ["path", { "d": "M17 12h.01", "key": "svg-4" }], ["path", { "d": "M13 12h.01", "key": "svg-5" }]]);

var IconFountainOff = createVueComponent("outline", "fountain-off", "FountainOff", [["path", { "d": "M9 16v-5a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 16v-1m0 -4a2 2 0 1 1 4 0", "key": "svg-1" }], ["path", { "d": "M12 16v-4m0 -4v-2a3 3 0 0 1 6 0", "key": "svg-2" }], ["path", { "d": "M7.451 3.43a3 3 0 0 1 4.549 2.57", "key": "svg-3" }], ["path", { "d": "M20 16h1v1m-.871 3.114a2.99 2.99 0 0 1 -2.129 .886h-12a3 3 0 0 1 -3 -3v-2h13", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconFountain = createVueComponent("outline", "fountain", "Fountain", [["path", { "d": "M9 16v-5a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 16v-5a2 2 0 1 1 4 0", "key": "svg-1" }], ["path", { "d": "M12 16v-10a3 3 0 0 1 6 0", "key": "svg-2" }], ["path", { "d": "M6 6a3 3 0 0 1 6 0", "key": "svg-3" }], ["path", { "d": "M3 16h18v2a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3v-2z", "key": "svg-4" }]]);

var IconFrameOff = createVueComponent("outline", "frame-off", "FrameOff", [["path", { "d": "M4 7h3m4 0h9", "key": "svg-0" }], ["path", { "d": "M4 17h13", "key": "svg-1" }], ["path", { "d": "M7 7v13", "key": "svg-2" }], ["path", { "d": "M17 4v9m0 4v3", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconFrame = createVueComponent("outline", "frame", "Frame", [["path", { "d": "M4 7l16 0", "key": "svg-0" }], ["path", { "d": "M4 17l16 0", "key": "svg-1" }], ["path", { "d": "M7 4l0 16", "key": "svg-2" }], ["path", { "d": "M17 4l0 16", "key": "svg-3" }]]);

var IconFreeRights = createVueComponent("outline", "free-rights", "FreeRights", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M13.867 9.75c-.246 -.48 -.708 -.769 -1.2 -.75h-1.334c-.736 0 -1.333 .67 -1.333 1.5c0 .827 .597 1.499 1.333 1.499h1.334c.736 0 1.333 .671 1.333 1.5c0 .828 -.597 1.499 -1.333 1.499h-1.334c-.492 .019 -.954 -.27 -1.2 -.75", "key": "svg-1" }], ["path", { "d": "M12 7v2", "key": "svg-2" }], ["path", { "d": "M12 15v2", "key": "svg-3" }], ["path", { "d": "M6 6l1.5 1.5", "key": "svg-4" }], ["path", { "d": "M16.5 16.5l1.5 1.5", "key": "svg-5" }]]);

var IconFreezeColumn = createVueComponent("outline", "freeze-column", "FreezeColumn", [["path", { "d": "M9 9.5l-6 6", "key": "svg-0" }], ["path", { "d": "M9 4l-6 6", "key": "svg-1" }], ["path", { "d": "M9 15l-5 5", "key": "svg-2" }], ["path", { "d": "M9 3v18", "key": "svg-3" }], ["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-4" }]]);

var IconFreezeRowColumn = createVueComponent("outline", "freeze-row-column", "FreezeRowColumn", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M15 3l-12 12",