"use strict";Object.defineProperty(exports, "__esModule", { value: true });exports.default = void 0;var _vite = _interopRequireDefault(await jitiImport("@tailwindcss/vite"));function _interopRequireDefault(e) {return e && e.__esModule ? e : { default: e };}var _default = exports.default =

defineNuxtConfig({
  runtimeConfig: {
    public: {
      apiBase: "https://irantarabar-shop.ir/api",
      urlBase: "https://irantarabar-shop.ir",
      uploadsBase: "https://irantarabar-shop.ir/uploads",
      mediaBase: "https://irantarabar-shop.ir/upload/files/products/images/"
    }
  },
  compatibilityDate: "2025-07-15",
  devtools: { enabled: false },

  vite: {
    plugins: [(0, _vite.default)()]
  },

  css: ["~/assets/css/main.css"],

  components: [
  {
    path: "~/components",
    pathPrefix: false
  }],


  imports: {
    dirs: ["utils"]
  },

  app: {
    head: {
      meta: [
      {
        name: "viewport",
        content: "width=device-width, initial-scale=1, maximum-scale=5"
      },
      { name: "mobile-web-app-capable", content: "yes" },
      { name: "apple-mobile-web-app-capable", content: "yes" },
      { name: "apple-mobile-web-app-status-bar-style", content: "default" }]

    }
  },

  modules: [
  "@nuxtjs/color-mode",
  "nuxt-viewport",
  "@pinia/nuxt",
  "pinia-plugin-persistedstate",
  "@vueuse/nuxt"],


  colorMode: {
    preference: "light",
    fallback: "light",
    dataValue: "theme",
    classSuffix: "",
    storageKey: "nuxt-color-mode"
  },
  viewport: {
    breakpoints: {
      mobile: 640,
      tablet: 768,
      laptop: 1024,
      desktop: 1280
    }
  }
}); /* v9-24b6f07df25a6d45 */
