import { _ as __nuxt_component_0 } from "./nuxt-link-DWMZ_O5T.js";
import { t as toPersianDigits } from "./toPersianDigits-DB2ZciTc.js";
import { computed, mergeProps, withCtx, unref, createVNode, toDisplayString, createBlock, createCommentVNode, openBlock, withModifiers, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderClass, ssrInterpolate, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { IconShoppingCartPlus, IconPlus, IconTrash, IconMinus } from "@tabler/icons-vue";
import { u as useCartStore } from "./cart-BfofACZK.js";
import { b as useRuntimeConfig } from "../server.mjs";
const _sfc_main = {
  __name: "ProductCard",
  __ssrInlineRender: true,
  props: {
    product: {
      type: Object,
      required: true
    }
  },
  setup(__props) {
    const props = __props;
    const config = useRuntimeConfig();
    const cartStore = useCartStore();
    const defaultVariation = computed(() => {
      if (props.product.best_variation) {
        return props.product.best_variation;
      }
      return props.product.defualt_variation;
    });
    const currentQuantity = computed(() => {
      return cartStore.getItemQuantity(props.product.id, defaultVariation.value.id);
    });
    const isOutOfStock = computed(() => {
      return defaultVariation.value.quantity === 0;
    });
    const isMaxQuantity = computed(() => {
      return currentQuantity.value >= defaultVariation.value.quantity;
    });
    const handleAddToCart = () => {
      if (isOutOfStock.value) return;
      const cartItem = {
        product_id: props.product.id,
        variation_id: defaultVariation.value.id,
        name: props.product.name,
        image: props.product.primary_image,
        price: defaultVariation.value.price,
        value: defaultVariation.value.value,
        sale_price: defaultVariation.value.sale_price,
        quantity: 1,
        max_quantity: defaultVariation.value.quantity
      };
      cartStore.addItem(cartItem);
    };
    const handleIncrease = () => {
      if (isMaxQuantity.value) return;
      cartStore.increaseQuantity(props.product.id, defaultVariation.value.id);
    };
    const handleDecrease = () => {
      cartStore.decreaseQuantity(props.product.id, defaultVariation.value.id);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_NuxtLink = __nuxt_component_0;
      _push(ssrRenderComponent(_component_NuxtLink, mergeProps({
        to: `/products/${__props.product.id}`,
        class: "shrink-0 w-40"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="card-pr flex flex-col h-full min-h-70"${_scopeId}><div class="aspect-square bg-white rounded-t-2xl overflow-hidden"${_scopeId}><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${__props.product.primary_image}`)}${ssrRenderAttr("alt", __props.product.name)} class="w-full h-full object-contain p-3 md:p-4" loading="lazy"${_scopeId}></div><div class="${ssrRenderClass([
              _ctx.$route.path === "/" ? "bg-white dark:bg-background/80" : "bg-white dark:bg-gray-800",
              "px-2 pb-3 pt-2 flex flex-col grow rounded-b-2xl"
            ])}"${_scopeId}><h3 class="text-sm md:text-base font-bold text-gray-900 dark:text-white mb-3 line-clamp-2 leading-relaxed min-h-10 md:min-h-12"${_scopeId}>${ssrInterpolate(__props.product.name)}</h3><div class="mt-auto space-y-3"${_scopeId}><div class="flex items-start justify-between"${_scopeId}>`);
            if (unref(defaultVariation)?.discount_percent) {
              _push2(`<div class="bg-linear-to-br from-red-500 to-red-600 dark:from-red-400 dark:to-red-500 text-white text-xs font-black px-2 py-1 rounded-lg shadow-lg"${_scopeId}>${ssrInterpolate(unref(defaultVariation).discount_percent)}٪ </div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="w-full flex flex-col items-end"${_scopeId}><div class="flex items-baseline gap-1.5"${_scopeId}><span class="text-base md:text-lg font-black text-gray-900 dark:text-white"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
              unref(defaultVariation).sale_price || unref(defaultVariation).price
            ))}</span><span class="text-[10px] text-gray-500 dark:text-gray-400 font-medium"${_scopeId}> تومان </span></div><div class="ml-7 flex items-center h-4"${_scopeId}>`);
            if (unref(defaultVariation).discount_amount) {
              _push2(`<span class="text-xs text-gray-400 dark:text-gray-300 line-through font-medium"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(defaultVariation).price))}</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div></div><div class="w-full"${_scopeId}>`);
            if (unref(currentQuantity) === 0) {
              _push2(`<button${ssrIncludeBooleanAttr(unref(isOutOfStock)) ? " disabled" : ""} class="${ssrRenderClass([
                unref(isOutOfStock) ? "bg-gray-200 dark:bg-gray-700 text-gray-400 dark:text-gray-500 cursor-not-allowed" : "text-primary bg-primary/20 border border-primary/10 dark:border-primary/20 dark:text-white dark:bg-primary hover:bg-primary/30 dark:hover:bg-primary/90",
                "w-full h-9 md:h-10 flex items-center justify-center gap-2 rounded-lg font-bold text-xs md:text-sm active:scale-[0.98] transition-transform duration-150"
              ])}"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(IconShoppingCartPlus), { class: "w-4.5 h-4.5 md:w-5 md:h-5 shrink-0" }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>${ssrInterpolate(unref(isOutOfStock) ? "ناموجود" : "افزودن به سبد")}</span></button>`);
            } else {
              _push2(`<div class="w-full h-9 md:h-10 flex items-center justify-between gap-2 rounded-lg bg-primary/20 dark:bg-primary border border-primary/10 dark:border-primary/20 px-2"${_scopeId}><button${ssrIncludeBooleanAttr(unref(isMaxQuantity)) ? " disabled" : ""} class="${ssrRenderClass([{
                "opacity-50 cursor-not-allowed": unref(isMaxQuantity)
              }, "w-7 h-7 md:w-8 md:h-8 flex items-center justify-center rounded-lg bg-white dark:bg-primary-dark text-primary active:scale-95 transition-all duration-150"])}"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(IconPlus), { class: "w-4 h-4 md:w-4.5 md:h-4.5 stroke-[2.5]" }, null, _parent2, _scopeId));
              _push2(`</button><span class="text-sm md:text-base font-black text-primary dark:text-white min-w-6 text-center"${_scopeId}>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(currentQuantity)))}</span>`);
              if (unref(currentQuantity) === 1) {
                _push2(`<button class="w-7 h-7 md:w-8 md:h-8 flex items-center justify-center rounded-lg bg-white dark:bg-primary-dark text-red-500 dark:text-red-400 active:scale-95 transition-all duration-150"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(IconTrash), { class: "w-4 h-4 md:w-4.5 md:h-4.5" }, null, _parent2, _scopeId));
                _push2(`</button>`);
              } else {
                _push2(`<button class="w-7 h-7 md:w-8 md:h-8 flex items-center justify-center rounded-lg bg-white dark:bg-primary-dark text-primary active:scale-95 transition-all duration-150"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(IconMinus), { class: "w-4 h-4 md:w-4.5 md:h-4.5 stroke-[2.5]" }, null, _parent2, _scopeId));
                _push2(`</button>`);
              }
              _push2(`</div>`);
            }
            _push2(`</div></div></div></div>`);
          } else {
            return [
              createVNode("div", { class: "card-pr flex flex-col h-full min-h-70" }, [
                createVNode("div", { class: "aspect-square bg-white rounded-t-2xl overflow-hidden" }, [
                  createVNode("img", {
                    src: `${unref(config).public.mediaBase}/${__props.product.primary_image}`,
                    alt: __props.product.name,
                    class: "w-full h-full object-contain p-3 md:p-4",
                    loading: "lazy"
                  }, null, 8, ["src", "alt"])
                ]),
                createVNode("div", {
                  class: [
                    "px-2 pb-3 pt-2 flex flex-col grow rounded-b-2xl",
                    _ctx.$route.path === "/" ? "bg-white dark:bg-background/80" : "bg-white dark:bg-gray-800"
                  ]
                }, [
                  createVNode("h3", { class: "text-sm md:text-base font-bold text-gray-900 dark:text-white mb-3 line-clamp-2 leading-relaxed min-h-10 md:min-h-12" }, toDisplayString(__props.product.name), 1),
                  createVNode("div", { class: "mt-auto space-y-3" }, [
                    createVNode("div", { class: "flex items-start justify-between" }, [
                      unref(defaultVariation)?.discount_percent ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: "bg-linear-to-br from-red-500 to-red-600 dark:from-red-400 dark:to-red-500 text-white text-xs font-black px-2 py-1 rounded-lg shadow-lg"
                      }, toDisplayString(unref(defaultVariation).discount_percent) + "٪ ", 1)) : createCommentVNode("", true),
                      createVNode("div", { class: "w-full flex flex-col items-end" }, [
                        createVNode("div", { class: "flex items-baseline gap-1.5" }, [
                          createVNode("span", { class: "text-base md:text-lg font-black text-gray-900 dark:text-white" }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
                            unref(defaultVariation).sale_price || unref(defaultVariation).price
                          )), 1),
                          createVNode("span", { class: "text-[10px] text-gray-500 dark:text-gray-400 font-medium" }, " تومان ")
                        ]),
                        createVNode("div", { class: "ml-7 flex items-center h-4" }, [
                          unref(defaultVariation).discount_amount ? (openBlock(), createBlock("span", {
                            key: 0,
                            class: "text-xs text-gray-400 dark:text-gray-300 line-through font-medium"
                          }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(defaultVariation).price)), 1)) : createCommentVNode("", true)
                        ])
                      ])
                    ]),
                    createVNode("div", {
                      onClick: withModifiers(() => {
                      }, ["prevent"]),
                      class: "w-full"
                    }, [
                      unref(currentQuantity) === 0 ? (openBlock(), createBlock("button", {
                        key: 0,
                        onClick: handleAddToCart,
                        disabled: unref(isOutOfStock),
                        class: [
                          "w-full h-9 md:h-10 flex items-center justify-center gap-2 rounded-lg font-bold text-xs md:text-sm active:scale-[0.98] transition-transform duration-150",
                          unref(isOutOfStock) ? "bg-gray-200 dark:bg-gray-700 text-gray-400 dark:text-gray-500 cursor-not-allowed" : "text-primary bg-primary/20 border border-primary/10 dark:border-primary/20 dark:text-white dark:bg-primary hover:bg-primary/30 dark:hover:bg-primary/90"
                        ]
                      }, [
                        createVNode(unref(IconShoppingCartPlus), { class: "w-4.5 h-4.5 md:w-5 md:h-5 shrink-0" }),
                        createVNode("span", null, toDisplayString(unref(isOutOfStock) ? "ناموجود" : "افزودن به سبد"), 1)
                      ], 10, ["disabled"])) : (openBlock(), createBlock("div", {
                        key: 1,
                        class: "w-full h-9 md:h-10 flex items-center justify-between gap-2 rounded-lg bg-primary/20 dark:bg-primary border border-primary/10 dark:border-primary/20 px-2"
                      }, [
                        createVNode("button", {
                          onClick: handleIncrease,
                          disabled: unref(isMaxQuantity),
                          class: ["w-7 h-7 md:w-8 md:h-8 flex items-center justify-center rounded-lg bg-white dark:bg-primary-dark text-primary active:scale-95 transition-all duration-150", {
                            "opacity-50 cursor-not-allowed": unref(isMaxQuantity)
                          }]
                        }, [
                          createVNode(unref(IconPlus), { class: "w-4 h-4 md:w-4.5 md:h-4.5 stroke-[2.5]" })
                        ], 10, ["disabled"]),
                        createVNode("span", { class: "text-sm md:text-base font-black text-primary dark:text-white min-w-6 text-center" }, toDisplayString(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(currentQuantity))), 1),
                        unref(currentQuantity) === 1 ? (openBlock(), createBlock("button", {
                          key: 0,
                          onClick: handleDecrease,
                          class: "w-7 h-7 md:w-8 md:h-8 flex items-center justify-center rounded-lg bg-white dark:bg-primary-dark text-red-500 dark:text-red-400 active:scale-95 transition-all duration-150"
                        }, [
                          createVNode(unref(IconTrash), { class: "w-4 h-4 md:w-4.5 md:h-4.5" })
                        ])) : (openBlock(), createBlock("button", {
                          key: 1,
                          onClick: handleDecrease,
                          class: "w-7 h-7 md:w-8 md:h-8 flex items-center justify-center rounded-lg bg-white dark:bg-primary-dark text-primary active:scale-95 transition-all duration-150"
                        }, [
                          createVNode(unref(IconMinus), { class: "w-4 h-4 md:w-4.5 md:h-4.5 stroke-[2.5]" })
                        ]))
                      ]))
                    ], 8, ["onClick"])
                  ])
                ], 2)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ProductCard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=ProductCard-BvqNuvr3.js.map
