import { ref, unref, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate } from "vue/server-renderer";
const _sfc_main = {
  __name: "Toast",
  __ssrInlineRender: true,
  setup(__props, { expose: __expose }) {
    let timer = null;
    const isOpen = ref(false);
    const message = ref("");
    const show = (msg) => {
      message.value = msg;
      isOpen.value = true;
      if (timer) clearTimeout(timer);
      timer = setTimeout(() => {
        isOpen.value = false;
      }, 3e3);
    };
    const close = () => {
      isOpen.value = false;
      if (timer) clearTimeout(timer);
    };
    __expose({
      show,
      close
    });
    return (_ctx, _push, _parent, _attrs) => {
      if (unref(isOpen)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "fixed bottom-20 left-1/2 -translate-x-1/2 py-4 px-3 rounded-md text-white bg-black z-50" }, _attrs))}><div class="flex items-center justify-start whitespace-nowrap"><div class="ml-4">${ssrInterpolate(unref(message))}</div><button class="text-[#19bfd3]">باشه</button></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Toast.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=Toast-BD7HuZap.js.map
