import { _ as _sfc_main$2 } from "./Toast-BD7HuZap.js";
import { t as toPersianDigits } from "./toPersianDigits-DB2ZciTc.js";
import { mergeProps, unref, useSSRContext, ref, computed } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderClass, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { IconMessage, IconChevronLeft, IconStarFilled, IconMessageOff, IconAlertTriangle, IconHeart, IconPalette, IconChevronDown, IconCheck, IconList, IconPackage, IconShoppingCartPlus, IconPlus, IconTrash, IconMinus, IconShoppingBag } from "@tabler/icons-vue";
import { a as useRouter, _ as _export_sfc, c as useState, d as useRoute, b as useRuntimeConfig } from "../server.mjs";
import { _ as _sfc_main$3 } from "./ProductCard-BvqNuvr3.js";
import { u as useCartStore } from "./cart-BfofACZK.js";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
import "./nuxt-link-DWMZ_O5T.js";
const _sfc_main$1 = {
  __name: "CommentsSection",
  __ssrInlineRender: true,
  props: {
    comments: {
      type: Array,
      default: () => []
    },
    avgRate: {
      type: Number,
      default: 0
    },
    productId: {
      type: [String, Number],
      required: true
    }
  },
  setup(__props) {
    useRouter();
    const getInitial = (name) => {
      return name ? name.charAt(0).toUpperCase() : "ک";
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "space-y-2 pt-2" }, _attrs))}><div class="flex items-center justify-between"><div class="flex items-center gap-2">`);
      _push(ssrRenderComponent(unref(IconMessage), { class: "w-5 h-5 sm:w-6 sm:h-6 text-primary" }, null, _parent));
      _push(`<h3 class="text-base sm:text-base font-black text-gray-900 dark:text-white"> دیدگاه کاربرها </h3></div>`);
      if (__props.comments?.length) {
        _push(`<button class="flex items-center text-primary dark:text-primary font-bold text-xs sm:text-sm active:scale-95 transition-transform"> مشاهده دیدگاه ها `);
        _push(ssrRenderComponent(unref(IconChevronLeft), { class: "w-4 h-4" }, null, _parent));
        _push(`</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (__props.avgRate) {
        _push(`<div class="flex items-center gap-1.5 bg-linear-to-br from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-800/20 px-2.5 py-1.5 rounded-lg w-fit"><span class="font-black text-gray-900 dark:text-white text-sm">${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(__props.avgRate.toFixed(1)))}</span>`);
        _push(ssrRenderComponent(unref(IconStarFilled), { class: "w-4 h-4 text-yellow-400" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (!__props.comments?.length) {
        _push(`<div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-6 sm:p-8 text-center border border-gray-100 dark:border-gray-700"><div class="w-12 h-12 sm:w-14 sm:h-14 mx-auto mb-3 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(IconMessageOff), { class: "w-6 h-6 sm:w-7 sm:h-7 text-gray-400" }, null, _parent));
        _push(`</div><p class="text-sm text-gray-500 dark:text-gray-400 font-medium"> دیدگاهی برای این محصول ثبت نشده است. </p></div>`);
      } else {
        _push(`<div class="flex gap-3 overflow-x-auto pb-2 -mx-3 sm:-mx-4 px-3 sm:px-4 scrollbar-hide"><!--[-->`);
        ssrRenderList(__props.comments, (comment) => {
          _push(`<div class="shrink-0 w-72 sm:w-80 bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-4 sm:p-5 shadow-sm snap-start border border-gray-100 dark:border-gray-700"><div class="flex items-center gap-3 mb-3"><div class="w-10 h-10 sm:w-12 sm:h-12 rounded-full overflow-hidden bg-linear-to-br from-primary/20 to-primary/5 flex items-center justify-center shrink-0">`);
          if (comment.user_avatar) {
            _push(`<img${ssrRenderAttr("src", comment.user_avatar)}${ssrRenderAttr("alt", comment.user_name)} class="w-full h-full object-cover">`);
          } else {
            _push(`<span class="text-primary font-black text-lg sm:text-xl">${ssrInterpolate(getInitial(comment.user_name))}</span>`);
          }
          _push(`</div><div class="flex-1 min-w-0"><p class="font-bold text-gray-900 dark:text-white text-sm sm:text-base truncate">${ssrInterpolate(comment.user_name)}</p><p class="text-xs text-gray-500 dark:text-gray-400">${ssrInterpolate(comment.date)}</p></div><div class="flex items-center gap-0.5 shrink-0"><!--[-->`);
          ssrRenderList(5, (star) => {
            _push(ssrRenderComponent(unref(IconStarFilled), {
              key: star,
              class: [
                "w-4 h-4",
                star <= comment.rate ? "text-yellow-400" : "text-gray-300 dark:text-gray-600"
              ]
            }, null, _parent));
          });
          _push(`<!--]--></div></div><p class="text-sm sm:text-base text-gray-700 dark:text-gray-300 leading-relaxed line-clamp-3">${ssrInterpolate(comment.text)}</p></div>`);
        });
        _push(`<!--]--></div>`);
      }
      _push(`<button class="w-full py-2 text-primary border-2 border-primary/30 rounded-lg font-bold text-sm sm:text-base transition-all active:scale-[0.98] flex items-center justify-center"><span>ثبت دیدگاه </span></button></div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/CommentsSection.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {
  __name: "[id]",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "صفحه محصول";
    useRoute();
    const config = useRuntimeConfig();
    const cartStore = useCartStore();
    const toast = ref();
    const loading = ref(true);
    const error = ref(false);
    const product = ref(null);
    const similarProducts = ref([]);
    const selectedVariation = ref(null);
    const selectedImage = ref("");
    const isDropdownOpen = ref(false);
    const currentQuantity = computed(() => {
      if (!product.value || !selectedVariation.value) return 0;
      return cartStore.getItemQuantity(
        product.value.id,
        selectedVariation.value.id
      );
    });
    const isOutOfStock = computed(() => {
      return selectedVariation.value?.quantity === 0;
    });
    const isMaxQuantity = computed(() => {
      if (!selectedVariation.value) return true;
      return currentQuantity.value >= selectedVariation.value.quantity;
    });
    const totalPrice = computed(() => {
      if (!selectedVariation.value) return 0;
      const price = selectedVariation.value.sale_price || selectedVariation.value.price;
      return price * currentQuantity.value;
    });
    const allImages = computed(() => {
      if (!product.value) return [];
      const images = [product.value.primary_image];
      if (product.value.images?.length) {
        images.push(...product.value.images.map((img) => img.image));
      }
      return images;
    });
    const isInWishlist = computed(() => {
      return product.value?.check_user_wishlist;
    });
    useRouter();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Toast = _sfc_main$2;
      const _component_CommentsSection = _sfc_main$1;
      const _component_ProductCard = _sfc_main$3;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Toast, {
        ref_key: "toast",
        ref: toast
      }, null, _parent));
      if (unref(loading)) {
        _push(`<div class="px-3 sm:px-4 py-4 sm:py-6 space-y-4" data-v-5e75b4ce><div class="animate-pulse space-y-4" data-v-5e75b4ce><div class="h-6 sm:h-8 w-3/4 bg-gray-200 dark:bg-gray-800 rounded-lg" data-v-5e75b4ce></div><div class="aspect-square bg-gray-200 dark:bg-gray-800 rounded-xl sm:rounded-2xl" data-v-5e75b4ce></div><div class="h-32 sm:h-40 bg-gray-200 dark:bg-gray-800 rounded-xl sm:rounded-2xl" data-v-5e75b4ce></div><div class="h-16 sm:h-20 bg-gray-200 dark:bg-gray-800 rounded-xl sm:rounded-2xl" data-v-5e75b4ce></div></div></div>`);
      } else if (unref(error)) {
        _push(`<div class="px-3 sm:px-4 py-12 sm:py-20 text-center" data-v-5e75b4ce><div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-6 sm:p-8 shadow-sm" data-v-5e75b4ce><div class="w-12 h-12 sm:w-16 sm:h-16 mx-auto mb-3 sm:mb-4 bg-red-100 dark:bg-red-900/20 rounded-full flex items-center justify-center" data-v-5e75b4ce>`);
        _push(ssrRenderComponent(unref(IconAlertTriangle), { class: "w-6 h-6 sm:w-8 sm:h-8 text-red-500" }, null, _parent));
        _push(`</div><p class="text-base sm:text-lg font-bold text-gray-900 dark:text-white mb-2" data-v-5e75b4ce> خطا در بارگذاری </p><p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mb-4 sm:mb-6" data-v-5e75b4ce> امکان نمایش اطلاعات محصول وجود ندارد </p><button class="px-5 sm:px-6 py-2.5 sm:py-3 bg-primary text-white rounded-lg sm:rounded-xl font-bold text-sm sm:text-base" data-v-5e75b4ce> تلاش مجدد </button></div></div>`);
      } else if (unref(product)) {
        _push(`<div class="pb-32" data-v-5e75b4ce><div class="bg-white dark:bg-gray-800 rounded-2xl p-4 md:p-6 shadow-sm mb-4" data-v-5e75b4ce><div class="relative aspect-square rounded-xl overflow-hidden bg-linear-to-br from-gray-50 via-gray-100 to-gray-50 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 w-full h-55" data-v-5e75b4ce><div class="absolute inset-0 opacity-40 dark:opacity-20 mix-blend-multiply dark:mix-blend-screen pointer-events-none" data-v-5e75b4ce></div><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${unref(selectedImage)}`)}${ssrRenderAttr("alt", unref(product).name)} class="relative w-full h-full object-contain p-4 md:p-8 mix-blend-multiply dark:mix-blend-normal transition-transform duration-300" data-v-5e75b4ce></div></div>`);
        if (unref(allImages).length > 1) {
          _push(`<div class="flex gap-3 overflow-x-auto pb-2 px-3 sm:px-4" data-v-5e75b4ce><!--[-->`);
          ssrRenderList(unref(allImages), (img) => {
            _push(`<button class="${ssrRenderClass([
              unref(selectedImage) === img ? "border-primary shadow-md" : "border-gray-200 dark:border-gray-700 hover:border-primary/50",
              "shrink-0 w-20 h-20 rounded-lg overflow-hidden border-2 transition-all"
            ])}" data-v-5e75b4ce><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${img}`)}${ssrRenderAttr("alt", unref(product).name)} class="w-full h-full object-contain bg-white dark:bg-gray-900 p-2" data-v-5e75b4ce></button>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="px-3 sm:px-4 py-4 sm:py-6 space-y-4 sm:space-y-5" data-v-5e75b4ce><div class="space-y-2" data-v-5e75b4ce><div class="flex items-start gap-1" data-v-5e75b4ce><h2 class="text-lg sm:text-xl font-black text-gray-900 dark:text-white leading-tight flex-1" data-v-5e75b4ce>${ssrInterpolate(unref(product).name)}</h2><button class="p-1.5 sm:p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg sm:rounded-xl transition-all active:scale-95" data-v-5e75b4ce>`);
        _push(ssrRenderComponent(unref(IconHeart), {
          class: [
            "w-5 h-5 sm:w-6 sm:h-6 transition-colors",
            unref(isInWishlist) ? "fill-red-500 text-red-500" : "text-gray-600 dark:text-gray-400"
          ]
        }, null, _parent));
        _push(`</button></div></div><div class="bg-linear-to-br from-primary/5 to-primary/10 dark:from-primary/10 dark:to-primary/20 rounded-xl sm:rounded-2xl p-4 sm:p-5 space-y-2.5 sm:space-y-3" data-v-5e75b4ce>`);
        if (unref(selectedVariation)?.discount_percent) {
          _push(`<div class="flex items-center justify-between" data-v-5e75b4ce><div class="bg-linear-to-br from-red-500 to-red-600 dark:from-red-400 dark:to-red-500 text-white text-xs font-black px-2 py-1 rounded-lg shadow-lg" data-v-5e75b4ce>${ssrInterpolate(unref(selectedVariation)?.discount_percent)}٪ </div><div class="flex items-center gap-2 sm:gap-3" data-v-5e75b4ce><span class="text-gray-400 dark:text-gray-300 line-through text-sm sm:text-base" data-v-5e75b4ce>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(selectedVariation).price))}</span><span class="text-xs sm:text-sm text-gray-600 dark:text-gray-400" data-v-5e75b4ce>تومان</span></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex items-baseline justify-between" data-v-5e75b4ce><span class="text-sm sm:text-base text-gray-700 dark:text-gray-300 font-bold" data-v-5e75b4ce>قیمت</span><div class="flex items-baseline gap-1 sm:gap-1.5" data-v-5e75b4ce><span class="text-2xl sm:text-3xl font-black text-primary dark:text-white" data-v-5e75b4ce>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(
          unref(selectedVariation)?.sale_price || unref(selectedVariation)?.price || unref(product).variations[0].price
        ))}</span><span class="text-xs sm:text-sm text-gray-600 dark:text-gray-400" data-v-5e75b4ce>تومان</span></div></div></div><div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-4 sm:p-5 shadow-sm space-y-3 sm:space-y-4" data-v-5e75b4ce><h3 class="text-sm font-bold text-gray-900 dark:text-white flex items-center gap-2" data-v-5e75b4ce>`);
        _push(ssrRenderComponent(unref(IconPalette), { class: "w-4 h-4 sm:w-5 sm:h-5 text-primary" }, null, _parent));
        _push(` انتخاب نوع محصول </h3><div class="relative" data-v-5e75b4ce><button${ssrIncludeBooleanAttr(unref(product).variations.every((v) => v.quantity === 0)) ? " disabled" : ""} class="${ssrRenderClass([
          unref(isDropdownOpen) ? "border-primary bg-primary/5 dark:bg-primary/10" : "border-gray-200 dark:border-gray-700 hover:border-primary/50",
          "w-full flex items-center justify-between p-3 sm:p-3.5 rounded-lg sm:rounded-xl border-2 transition-all font-bold text-sm sm:text-base disabled:opacity-50 disabled:cursor-not-allowed"
        ])}" data-v-5e75b4ce><span class="text-gray-900 dark:text-white" data-v-5e75b4ce>${ssrInterpolate(unref(selectedVariation)?.value || "انتخاب کنید")}</span>`);
        _push(ssrRenderComponent(unref(IconChevronDown), {
          class: ["w-4 h-4 sm:w-5 sm:h-5 text-gray-600 dark:text-gray-400 transition-transform", unref(isDropdownOpen) ? "rotate-180" : ""]
        }, null, _parent));
        _push(`</button>`);
        if (unref(isDropdownOpen)) {
          _push(`<div class="absolute left-0 right-0 mt-1 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg sm:rounded-xl shadow-xl z-10 max-h-60 overflow-y-auto" data-v-5e75b4ce><!--[-->`);
          ssrRenderList(unref(product).variations, (variation) => {
            _push(`<button${ssrIncludeBooleanAttr(variation.quantity === 0) ? " disabled" : ""} class="${ssrRenderClass([
              unref(selectedVariation)?.id === variation.id ? "bg-primary/5 dark:bg-primary/10" : "",
              "w-full flex items-center justify-between p-3 sm:p-3.5 text-right hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors disabled:opacity-40 disabled:cursor-not-allowed first:rounded-t-lg last:rounded-b-lg text-sm sm:text-base"
            ])}" data-v-5e75b4ce><span class="font-bold text-gray-900 dark:text-white" data-v-5e75b4ce>${ssrInterpolate(variation.value)}</span>`);
            if (unref(selectedVariation)?.id === variation.id) {
              _push(ssrRenderComponent(unref(IconCheck), { class: "w-4 h-4 sm:w-5 sm:h-5 text-primary" }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</button>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
        if (unref(product).attributes?.length) {
          _push(`<div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-4 sm:p-5 shadow-sm space-y-3 sm:space-y-4" data-v-5e75b4ce><h3 class="text-sm font-bold text-gray-900 dark:text-white flex items-center gap-2" data-v-5e75b4ce>`);
          _push(ssrRenderComponent(unref(IconList), { class: "w-4 h-4 sm:w-5 sm:h-5 text-primary" }, null, _parent));
          _push(` مشخصات فنی </h3><div class="space-y-2" data-v-5e75b4ce><!--[-->`);
          ssrRenderList(unref(product).attributes, (attr) => {
            _push(`<div class="flex items-center justify-between text-xs sm:text-sm py-2 sm:py-2.5 border-b border-gray-100 dark:border-gray-700 last:border-0 gap-2" data-v-5e75b4ce><span class="text-gray-600 dark:text-gray-400 shrink-0" data-v-5e75b4ce>${ssrInterpolate(attr.name)}</span><span class="font-bold text-gray-900 dark:text-white text-left" data-v-5e75b4ce>${ssrInterpolate(attr.value)}</span></div>`);
          });
          _push(`<!--]--></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(_component_CommentsSection, {
          comments: unref(product).approvedComments,
          "avg-rate": unref(product).avgRate,
          "product-id": unref(product).id
        }, null, _parent));
        if (unref(similarProducts)?.length) {
          _push(`<div class="space-y-3 sm:space-y-4 pt-2" data-v-5e75b4ce><h3 class="text-base sm:text-base font-black text-gray-900 dark:text-white flex items-center gap-2" data-v-5e75b4ce>`);
          _push(ssrRenderComponent(unref(IconPackage), { class: "w-5 h-5 sm:w-6 sm:h-6 text-primary" }, null, _parent));
          _push(` محصولات مشابه </h3><div class="flex gap-2.5 sm:gap-3 overflow-x-auto pb-2 -mx-3 sm:-mx-4 px-3 sm:px-4 snap-x snap-mandatory scrollbar-hide" data-v-5e75b4ce><!--[-->`);
          ssrRenderList(unref(similarProducts), (item) => {
            _push(ssrRenderComponent(_component_ProductCard, {
              key: item.id,
              product: item,
              class: "w-36 sm:w-40 shrink-0 snap-start"
            }, null, _parent));
          });
          _push(`<!--]--></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="btns-container" data-v-5e75b4ce>`);
      if (unref(currentQuantity) === 0) {
        _push(`<button${ssrIncludeBooleanAttr(!unref(selectedVariation)) ? " disabled" : ""} class="${ssrRenderClass([
          unref(selectedVariation) ? "bg-primary text-white hover:bg-primary/90" : "bg-gray-300 dark:bg-gray-700 text-gray-500 dark:text-gray-400",
          "w-full py-3.5 flex items-center justify-center gap-2 rounded-lg font-black text-base transition-all shadow-lg active:scale-[0.98] disabled:opacity-50 disabled:cursor-not-allowed"
        ])}" data-v-5e75b4ce>`);
        _push(ssrRenderComponent(unref(IconShoppingCartPlus), { class: "w-6 h-6" }, null, _parent));
        _push(`<span data-v-5e75b4ce>${ssrInterpolate(unref(isOutOfStock) ? "ناموجود" : "افزودن به سبد خرید")}</span></button>`);
      } else {
        _push(`<div class="flex flex-col gap-1 w-full" data-v-5e75b4ce><div class="flex items-stretch h-12 bg-white dark:bg-gray-800 rounded-lg shadow-lg border-2 border-gray-200 dark:border-gray-700 overflow-hidden" data-v-5e75b4ce><button${ssrIncludeBooleanAttr(unref(isMaxQuantity)) ? " disabled" : ""} class="w-14 flex items-center justify-center bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 text-primary dark:text-primary transition-colors active:scale-95 disabled:opacity-30 disabled:cursor-not-allowed border-l-2 border-gray-200 dark:border-gray-700" data-v-5e75b4ce>`);
        _push(ssrRenderComponent(unref(IconPlus), { class: "w-6 h-6" }, null, _parent));
        _push(`</button><div class="flex-1 flex items-center justify-between px-4 bg-white dark:bg-gray-800" data-v-5e75b4ce><div class="flex items-center gap-1.5" data-v-5e75b4ce><span class="text-xl font-black text-gray-900 dark:text-white" data-v-5e75b4ce>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(currentQuantity)))}</span><span class="text-xs text-gray-500 dark:text-gray-400" data-v-5e75b4ce>عدد</span></div><div class="flex items-baseline gap-1" data-v-5e75b4ce><span class="text-lg font-black text-gray-900 dark:text-white" data-v-5e75b4ce>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(totalPrice)))}</span><span class="text-xs text-gray-500 dark:text-gray-400" data-v-5e75b4ce>تومان</span></div></div><button class="${ssrRenderClass([
          unref(currentQuantity) === 1 ? "hover:bg-red-50 dark:hover:bg-red-900/20 text-red-500 dark:text-red-400" : "hover:bg-gray-50 dark:hover:bg-gray-700 text-primary dark:text-primary",
          "w-14 flex items-center justify-center bg-white dark:bg-gray-800 transition-colors active:scale-95 border-r-2 border-gray-200 dark:border-gray-700"
        ])}" data-v-5e75b4ce>`);
        if (unref(currentQuantity) === 1) {
          _push(ssrRenderComponent(unref(IconTrash), { class: "w-5 h-5" }, null, _parent));
        } else {
          _push(ssrRenderComponent(unref(IconMinus), { class: "w-6 h-6" }, null, _parent));
        }
        _push(`</button></div><button class="w-full py-3 flex items-center justify-center gap-2 rounded-lg font-black text-base bg-primary text-white shadow-xl transition-all active:scale-[0.97]" data-v-5e75b4ce>`);
        _push(ssrRenderComponent(unref(IconShoppingBag), { class: "w-6 h-6" }, null, _parent));
        _push(`<span data-v-5e75b4ce>رفتن به سبد خرید</span></button></div>`);
      }
      _push(`</div><!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/products/[id].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const _id_ = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-5e75b4ce"]]);
export {
  _id_ as default
};
//# sourceMappingURL=_id_-BFyTl1-H.js.map
