import { _ as _sfc_main$1 } from "./Toast-BD7HuZap.js";
import { _ as _sfc_main$2 } from "./ErrorState-qff2oEvB.js";
import { _ as __nuxt_component_0 } from "./nuxt-link-DWMZ_O5T.js";
import { ref, unref, withCtx, createVNode, createBlock, createCommentVNode, toDisplayString, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import { IconCreditCard, IconCopy, IconClock, IconMapPin, IconTag } from "@tabler/icons-vue";
import { c as useState, d as useRoute, b as useRuntimeConfig } from "../server.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
const _sfc_main = {
  __name: "[orderId]",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "جزئیات سفارش";
    const route = useRoute();
    const config = useRuntimeConfig();
    const toast = ref();
    const orderId = route.params.orderId;
    const order = ref({});
    const loading = ref(false);
    const error = ref(false);
    const fetchSentOrders = async () => {
      try {
        loading.value = true;
        error.value = false;
        const response = await $fetch(
          `${config.public.apiBase}/order/inprogress/${orderId}`,
          {
            headers: {
              Authorization: `Bearer ${localStorage.getItem("shop_token")}`
            }
          }
        );
        if (response.status === "success") {
          order.value = response.data;
          console.log(response.data);
        }
      } catch (err) {
        console.error(err);
        error.value = true;
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Toast = _sfc_main$1;
      const _component_ErrorState = _sfc_main$2;
      const _component_nuxt_link = __nuxt_component_0;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Toast, {
        ref_key: "toast",
        ref: toast
      }, null, _parent));
      if (unref(loading)) {
        _push(`<div class="px-4 py-6 space-y-4"><div class="card-container p-4"><div class="flex items-center gap-3"><div class="w-10 h-10 bg-gray-200 dark:bg-gray-700 rounded-xl animate-pulse"></div><div class="flex-1 space-y-2"><div class="h-3 bg-gray-200 dark:bg-gray-700 rounded w-24 animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-32 animate-pulse"></div></div></div></div><div class="card-container p-4"><div class="space-y-4"><div class="flex items-center gap-3"><div class="w-10 h-10 bg-gray-200 dark:bg-gray-700 rounded-xl animate-pulse"></div><div class="flex-1 space-y-2"><div class="h-3 bg-gray-200 dark:bg-gray-700 rounded w-20 animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-32 animate-pulse"></div></div></div><div class="flex items-start gap-3"><div class="w-10 h-10 bg-gray-200 dark:bg-gray-700 rounded-xl animate-pulse"></div><div class="flex-1 space-y-2"><div class="h-3 bg-gray-200 dark:bg-gray-700 rounded w-24 animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-full animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-3/4 animate-pulse"></div></div></div></div></div><div class="card-container p-4"><div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700"><div class="h-5 bg-gray-200 dark:bg-gray-700 rounded w-32 animate-pulse"></div></div><div class="p-4 space-y-4"><!--[-->`);
        ssrRenderList(2, (i) => {
          _push(`<div class="flex gap-4"><div class="w-20 h-20 bg-gray-200 dark:bg-gray-700 rounded-xl animate-pulse"></div><div class="flex-1 space-y-2"><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-3/4 animate-pulse"></div><div class="h-3 bg-gray-200 dark:bg-gray-700 rounded w-24 animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-28 animate-pulse"></div></div></div>`);
        });
        _push(`<!--]--></div></div><div class="card-container p-4"><div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700"><div class="h-5 bg-gray-200 dark:bg-gray-700 rounded w-28 animate-pulse"></div></div><div class="p-4 space-y-3"><div class="flex justify-between"><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-24 animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-32 animate-pulse"></div></div><div class="flex justify-between"><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-20 animate-pulse"></div><div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-28 animate-pulse"></div></div><div class="border-t border-gray-200 dark:border-gray-700 pt-3 flex justify-between"><div class="h-5 bg-gray-200 dark:bg-gray-700 rounded w-32 animate-pulse"></div><div class="h-6 bg-gray-200 dark:bg-gray-700 rounded w-36 animate-pulse"></div></div></div></div></div>`);
      } else if (unref(error)) {
        _push(`<div class="flex h-[calc(100vh-132px)] justify-center">`);
        _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchSentOrders }, null, _parent));
        _push(`</div>`);
      } else if (unref(order) && unref(order).orderId) {
        _push(`<div class="px-4 py-6 pb-24 space-y-4">`);
        if (unref(order).transactionRefId) {
          _push(`<div class="card-container p-4"><div class="flex items-center justify-between"><div class="flex items-center gap-3"><div class="w-10 h-10 badge-color rounded-xl flex items-center justify-center">`);
          _push(ssrRenderComponent(unref(IconCreditCard), { class: "w-5 h-5 text-primary" }, null, _parent));
          _push(`</div><div><p class="text-xs text-gray-500 dark:text-gray-400"> کد پیگیری تراکنش </p><p class="text-sm font-mono font-semibold text-gray-900 dark:text-white">${ssrInterpolate(unref(order).transactionRefId)}</p></div></div><button class="p-2 rounded-lg">`);
          _push(ssrRenderComponent(unref(IconCopy), { class: "w-5 h-5 text-gray-400" }, null, _parent));
          _push(`</button></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="card-container p-4"><div class="space-y-4"><div class="flex items-center gap-3"><div class="w-10 h-10 badge-color rounded-xl flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(IconClock), { class: "w-5 h-5 text-primary" }, null, _parent));
        _push(`</div><div><p class="text-xs text-gray-500 dark:text-gray-400">زمان تحویل</p><p class="text-sm font-semibold text-gray-900 dark:text-white"></p></div></div>`);
        if (unref(order).address) {
          _push(`<div class="flex items-start gap-3"><div class="w-10 h-10 badge-color rounded-xl flex items-center justify-center flex-shrink-0">`);
          _push(ssrRenderComponent(unref(IconMapPin), { class: "w-5 h-5 text-primary" }, null, _parent));
          _push(`</div><div class="flex-1"><p class="text-xs text-gray-500 dark:text-gray-400 mb-1"> آدرس تحویل </p><p class="text-sm text-gray-900 dark:text-white leading-relaxed">${ssrInterpolate(unref(order).address)}</p></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><div class="bg-white dark:bg-gray-800 rounded-2xl border border-gray-200 dark:border-gray-700"><div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700"><h2 class="text-base font-bold text-gray-900 dark:text-white"> محصولات سفارش </h2></div><div class="divide-y divide-gray-200 dark:divide-gray-700"><!--[-->`);
        ssrRenderList(unref(order).orderItems, (item) => {
          _push(ssrRenderComponent(_component_nuxt_link, {
            to: `/products/${item.product_id}`,
            key: item.id,
            class: "p-4 block"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="flex gap-4"${_scopeId}><div class="relative"${_scopeId}><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${item.primary_image}`)}${ssrRenderAttr("alt", item.product_name)} class="w-20 h-20 rounded-xl object-cover border border-gray-200 dark:border-gray-700"${_scopeId}><div class="absolute -top-2 -right-2 bg-primary text-white text-xs font-bold rounded-2xl flex items-center gap-1 px-2 py-1"${_scopeId}>${ssrInterpolate(item.quantity)} x </div></div><div class="flex-1"${_scopeId}><h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-1"${_scopeId}>${ssrInterpolate(item.product_name)}</h3>`);
                if (item.variationName) {
                  _push2(`<div class="inline-flex items-center gap-1.5 px-2 py-1 bg-gray-100 dark:bg-gray-700 rounded-lg mb-2"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(IconTag), { class: "w-3.5 h-3.5 text-gray-500" }, null, _parent2, _scopeId));
                  _push2(`<span class="text-xs font-medium text-gray-700 dark:text-gray-300"${_scopeId}>${ssrInterpolate(item.variationName)}</span></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<div class="flex items-center gap-3"${_scopeId}><div class="flex items-baseline gap-1"${_scopeId}><span class="text-base font-bold text-gray-900 dark:text-white"${_scopeId}>${ssrInterpolate(item.sale_price?.toLocaleString("fa-IR"))}</span><span class="text-xs text-gray-500"${_scopeId}>تومان</span></div>`);
                if (item.discount_percentage > 0) {
                  _push2(`<div class="flex items-center gap-2"${_scopeId}><span class="text-sm text-gray-400 line-through"${_scopeId}>${ssrInterpolate(item.price?.toLocaleString("fa-IR"))}</span><span class="bg-linear-to-br from-red-500 to-red-600 dark:from-red-400 dark:to-red-500 text-white text-xs font-black px-2 py-1 rounded-lg shadow-lg"${_scopeId}>${ssrInterpolate(item.discount_percentage)}% </span></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div></div></div>`);
                if (item.quantity > 1) {
                  _push2(`<div class="mt-3 pt-3 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between"${_scopeId}><span class="text-sm text-gray-500 dark:text-gray-400"${_scopeId}> قیمت کل (${ssrInterpolate(item.quantity)} عدد) </span><span class="text-sm font-bold text-gray-900 dark:text-white"${_scopeId}>${ssrInterpolate(item.totalPrice?.toLocaleString("fa-IR"))} تومان </span></div>`);
                } else {
                  _push2(`<!---->`);
                }
              } else {
                return [
                  createVNode("div", { class: "flex gap-4" }, [
                    createVNode("div", { class: "relative" }, [
                      createVNode("img", {
                        src: `${unref(config).public.mediaBase}/${item.primary_image}`,
                        alt: item.product_name,
                        class: "w-20 h-20 rounded-xl object-cover border border-gray-200 dark:border-gray-700"
                      }, null, 8, ["src", "alt"]),
                      createVNode("div", { class: "absolute -top-2 -right-2 bg-primary text-white text-xs font-bold rounded-2xl flex items-center gap-1 px-2 py-1" }, toDisplayString(item.quantity) + " x ", 1)
                    ]),
                    createVNode("div", { class: "flex-1" }, [
                      createVNode("h3", { class: "text-sm font-semibold text-gray-900 dark:text-white mb-1" }, toDisplayString(item.product_name), 1),
                      item.variationName ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: "inline-flex items-center gap-1.5 px-2 py-1 bg-gray-100 dark:bg-gray-700 rounded-lg mb-2"
                      }, [
                        createVNode(unref(IconTag), { class: "w-3.5 h-3.5 text-gray-500" }),
                        createVNode("span", { class: "text-xs font-medium text-gray-700 dark:text-gray-300" }, toDisplayString(item.variationName), 1)
                      ])) : createCommentVNode("", true),
                      createVNode("div", { class: "flex items-center gap-3" }, [
                        createVNode("div", { class: "flex items-baseline gap-1" }, [
                          createVNode("span", { class: "text-base font-bold text-gray-900 dark:text-white" }, toDisplayString(item.sale_price?.toLocaleString("fa-IR")), 1),
                          createVNode("span", { class: "text-xs text-gray-500" }, "تومان")
                        ]),
                        item.discount_percentage > 0 ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "flex items-center gap-2"
                        }, [
                          createVNode("span", { class: "text-sm text-gray-400 line-through" }, toDisplayString(item.price?.toLocaleString("fa-IR")), 1),
                          createVNode("span", { class: "bg-linear-to-br from-red-500 to-red-600 dark:from-red-400 dark:to-red-500 text-white text-xs font-black px-2 py-1 rounded-lg shadow-lg" }, toDisplayString(item.discount_percentage) + "% ", 1)
                        ])) : createCommentVNode("", true)
                      ])
                    ])
                  ]),
                  item.quantity > 1 ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "mt-3 pt-3 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between"
                  }, [
                    createVNode("span", { class: "text-sm text-gray-500 dark:text-gray-400" }, " قیمت کل (" + toDisplayString(item.quantity) + " عدد) ", 1),
                    createVNode("span", { class: "text-sm font-bold text-gray-900 dark:text-white" }, toDisplayString(item.totalPrice?.toLocaleString("fa-IR")) + " تومان ", 1)
                  ])) : createCommentVNode("", true)
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div></div><div class="bg-white dark:bg-gray-800 rounded-2xl border border-gray-200 dark:border-gray-700"><div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700"><h2 class="text-base font-bold text-gray-900 dark:text-white"> خلاصه سفارش </h2></div><div class="p-4 space-y-3"><div class="flex items-center justify-between text-sm"><span class="text-gray-600 dark:text-gray-400">جمع محصولات</span><span class="font-medium text-gray-900 dark:text-white">${ssrInterpolate(unref(order).totalAmount.toLocaleString("fa-IR"))} تومان </span></div>`);
        if (unref(order).totalDiscount > 0) {
          _push(`<div class="flex items-center justify-between text-sm"><span class="text-gray-600 dark:text-gray-400">تخفیف</span><span class="font-medium text-red-600 dark:text-red-400"> - ${ssrInterpolate(unref(order).totalDiscount.toLocaleString("fa-IR"))} تومان </span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="border-t border-gray-200 dark:border-gray-700 pt-3"><div class="flex items-center justify-between"><span class="text-base font-semibold text-gray-900 dark:text-white">مبلغ پرداخت شده</span><div class="text-left"><div class="text-xl font-bold text-primary">${ssrInterpolate(unref(order).paidAmount.toLocaleString("fa-IR"))}</div><div class="text-xs text-gray-500">تومان</div></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/orders/in-progress/[orderId].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=_orderId_-Xs5ZJ5hw.js.map
