import { ref, unref, createVNode, resolveDynamicComponent, useSSRContext } from "vue";
import { ssrRenderList, ssrRenderClass, ssrRenderVNode, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import { IconPackage, IconTruck, IconPackageOff, IconMapPin, IconHeart, IconUser, IconLogout, IconChevronLeft } from "@tabler/icons-vue";
import { c as useState } from "../server.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
const _sfc_main = {
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "پروفایل کاربری";
    const orderStats = ref([
      {
        id: "current",
        label: "جاری",
        count: 2,
        icon: IconPackage,
        gradient: "from-blue-100 to-cyan-100 dark:from-blue-900/30 dark:to-cyan-900/30",
        iconColor: "text-blue-600 dark:text-blue-400",
        textColor: "text-blue-700 dark:text-blue-300",
        badgeColor: "text-blue-600 dark:text-blue-400",
        action: "/profile/orders/in-progress"
      },
      {
        id: "delivered",
        label: "تحویل شده",
        count: 28,
        icon: IconTruck,
        gradient: "from-green-100 to-emerald-100 dark:from-green-900/30 dark:to-emerald-900/30",
        iconColor: "text-green-600 dark:text-green-400",
        textColor: "text-green-700 dark:text-green-300",
        badgeColor: "text-green-600 dark:text-green-400",
        action: "/profile/orders/sent"
      },
      {
        id: "cancelled",
        label: "لغو شده",
        count: 3,
        icon: IconPackageOff,
        gradient: "from-amber-100 to-orange-100 dark:from-amber-900/30 dark:to-orange-900/30",
        iconColor: "text-amber-600 dark:text-amber-400",
        textColor: "text-amber-700 dark:text-amber-300",
        badgeColor: "text-amber-600 dark:text-amber-400",
        action: "/profile/orders/cancelled"
      }
    ]);
    const menuItems = ref([
      // {
      //   id: "orders",
      //   label: "سفارش‌های من",
      //   icon: IconPackage,
      //   bgColor: "bg-primary-light dark:bg-primary-light/30",
      //   iconColor: "text-primary ",
      //   action: "orders",
      // },
      {
        id: "addresses",
        label: "آدرس‌ها",
        icon: IconMapPin,
        bgColor: "bg-primary-light dark:bg-primary-light/30",
        iconColor: "text-primary ",
        action: "/profile/addresses"
      },
      {
        id: "favorites",
        label: "لیست‌های من",
        icon: IconHeart,
        bgColor: "bg-primary-light dark:bg-primary-light/30",
        iconColor: "text-primary ",
        action: "/profile/wishlist"
      },
      {
        id: "account",
        label: "اطلاعات حساب کاربری",
        icon: IconUser,
        bgColor: "bg-primary-light dark:bg-primary-light/30",
        iconColor: "text-primary ",
        action: "/profile/account-info"
      },
      {
        id: "logout",
        label: "خروج از حساب",
        icon: IconLogout,
        bgColor: "bg-red-100 dark:bg-red-900/30",
        iconColor: "text-red-600 dark:text-red-400",
        action: "logout"
      }
    ]);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[--><div class="bg-white dark:bg-gray-800 px-4 pt-6 pb-4"><h2 class="text-lg font-bold text-gray-900 dark:text-white mb-4 text-right"> سفارش‌های من </h2><div class="grid grid-cols-3 gap-3"><!--[-->`);
      ssrRenderList(unref(orderStats), (stat) => {
        _push(`<div class="${ssrRenderClass([stat.gradient, "flex flex-col items-center justify-center bg-linear-to-br rounded-2xl p-4 shadow-sm"])}"><div class="relative">`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(stat.icon), {
          size: 40,
          "stroke-width": 1.5,
          class: ["mb-2", stat.iconColor]
        }, null), _parent);
        _push(`<span class="${ssrRenderClass([stat.badgeColor, "absolute -top-1 -right-1 bg-white dark:bg-gray-800 text-xs font-bold rounded-full w-5 h-5 flex items-center justify-center"])}">${ssrInterpolate(stat.count)}</span></div><span class="${ssrRenderClass([stat.textColor, "text-xs font-medium mt-1"])}">${ssrInterpolate(stat.label)}</span></div>`);
      });
      _push(`<!--]--></div></div><div class="mt-4 bg-white dark:bg-gray-800"><!--[-->`);
      ssrRenderList(unref(menuItems), (item, index) => {
        _push(`<div class="border-b border-gray-100 dark:border-gray-700 last:border-b-0"><button class="w-full flex items-center justify-between px-4 py-4 active:bg-gray-50 dark:active:bg-gray-700/50 transition-colors"><div class="flex-1 flex items-center gap-3"><div class="${ssrRenderClass([item.bgColor, "w-10 h-10 rounded-xl flex items-center justify-center"])}">`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(item.icon), {
          size: 22,
          "stroke-width": 2,
          class: item.iconColor
        }, null), _parent);
        _push(`</div><span class="text-sm font-medium text-gray-900 dark:text-white">${ssrInterpolate(item.label)}</span></div>`);
        _push(ssrRenderComponent(unref(IconChevronLeft), {
          size: 20,
          "stroke-width": 2,
          class: "text-gray-400 dark:text-gray-500"
        }, null, _parent));
        _push(`</button></div>`);
      });
      _push(`<!--]--></div><!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=index-BMJxRpYn.js.map
