import { _ as _sfc_main$1 } from "./ErrorState-qff2oEvB.js";
import { _ as __nuxt_component_0 } from "./nuxt-link-DWMZ_O5T.js";
import { ref, computed, unref, mergeProps, withCtx, createVNode, createBlock, openBlock, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrRenderClass, ssrRenderAttr, ssrInterpolate } from "vue/server-renderer";
import { IconCategory } from "@tabler/icons-vue";
import { c as useState, b as useRuntimeConfig } from "../server.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
const _sfc_main = {
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const config = useRuntimeConfig();
    const pageTitle = useState("pageTitle");
    pageTitle.value = "دسته بندی محصولات";
    const cats = ref([]);
    const loading = ref(false);
    const error = ref(false);
    const selectedParent = ref(null);
    const parentCategories = computed(() => {
      return cats.value.filter((cat) => cat.parent_id === 0);
    });
    const currentSubcategories = computed(() => {
      if (!selectedParent.value) return [];
      return getSubcategories(selectedParent.value.id);
    });
    const getSubcategories = (parentId) => {
      return cats.value.filter((cat) => cat.parent_id === parentId);
    };
    const fetchCats = async () => {
      try {
        loading.value = true;
        error.value = false;
        const response = await $fetch(`${config.public.apiBase}/category`, {
          headers: {
            Authorization: `Bearer ${localStorage.getItem("shop_token")}`
          }
        });
        if (response.category) {
          cats.value = response.category;
          if (parentCategories.value.length > 0) {
            selectedParent.value = parentCategories.value[0];
          }
        }
      } catch (err) {
        console.error("Error fetching categories:", err);
        error.value = true;
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ErrorState = _sfc_main$1;
      const _component_NuxtLink = __nuxt_component_0;
      if (unref(loading)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex h-[calc(100vh-132px)]" }, _attrs))}><div class="w-28 bg-white dark:bg-gray-800 border-l border-gray-200 dark:border-gray-700 overflow-y-auto transition-colors duration-200"><!--[-->`);
        ssrRenderList(5, (i) => {
          _push(`<div class="w-full px-3 py-4 flex flex-col items-center gap-2"><div class="w-12 h-12 bg-gray-200 dark:bg-gray-700 rounded-xl animate-pulse"></div><div class="w-16 h-3 bg-gray-200 dark:bg-gray-700 rounded animate-pulse"></div><div class="w-12 h-3 bg-gray-200 dark:bg-gray-700 rounded animate-pulse"></div></div>`);
        });
        _push(`<!--]--></div><div class="flex-1 bg-gray-50 dark:bg-gray-900 overflow-y-auto transition-colors duration-200 p-4"><div class="mb-4"><div class="h-5 w-32 bg-gray-200 dark:bg-gray-700 rounded animate-pulse"></div></div><div class="grid grid-cols-2 gap-3"><!--[-->`);
        ssrRenderList(6, (i) => {
          _push(`<div class="bg-white dark:bg-gray-800 rounded-xl p-4 flex flex-col items-center gap-3 border border-transparent dark:border-gray-700"><div class="w-16 h-16 bg-gray-200 dark:bg-gray-700 rounded-xl animate-pulse"></div><div class="w-20 h-3 bg-gray-200 dark:bg-gray-700 rounded animate-pulse"></div><div class="w-16 h-3 bg-gray-200 dark:bg-gray-700 rounded animate-pulse"></div></div>`);
        });
        _push(`<!--]--></div></div></div>`);
      } else if (unref(error)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex h-[calc(100vh-132px)] justify-center" }, _attrs))}>`);
        _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchCats }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex h-[calc(100vh-132px)]" }, _attrs))}><div class="w-28 bg-white dark:bg-gray-800 border-l border-gray-200 dark:border-gray-700 overflow-y-auto transition-colors duration-200"><!--[-->`);
        ssrRenderList(unref(parentCategories), (parent) => {
          _push(`<button class="${ssrRenderClass([
            "w-full px-3 py-4 flex flex-col items-center gap-2 transition-all relative",
            unref(selectedParent)?.id === parent.id ? "bg-primary/10 dark:bg-primary/20 text-primary dark:text-primary" : "text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700/50 active:bg-gray-100 dark:active:bg-gray-700"
          ])}">`);
          if (unref(selectedParent)?.id === parent.id) {
            _push(`<div class="absolute right-0 top-0 bottom-0 w-1 bg-primary dark:bg-primary rounded-l"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="${ssrRenderClass([
            "w-12 h-12 rounded-xl flex items-center justify-center transition-all",
            unref(selectedParent)?.id === parent.id ? "bg-primary dark:bg-primary text-white" : "bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-400"
          ])}">`);
          if (parent.icon) {
            _push(`<img${ssrRenderAttr("src", `${unref(config).public.urlBase}/${parent.icon}`)}${ssrRenderAttr("alt", parent.name)} class="w-8 h-8 object-contain">`);
          } else {
            _push(ssrRenderComponent(unref(IconCategory), { class: "w-6 h-6" }, null, _parent));
          }
          _push(`</div><span class="text-xs font-medium text-center leading-tight line-clamp-2">${ssrInterpolate(parent.name)}</span></button>`);
        });
        _push(`<!--]--></div><div class="flex-1 bg-gray-50 dark:bg-gray-900 overflow-y-auto transition-colors duration-200">`);
        if (unref(selectedParent)) {
          _push(`<div class="p-4"><div class="mb-4"><h2 class="text-base font-bold text-gray-900 dark:text-white mb-1">${ssrInterpolate(unref(selectedParent).name)}</h2></div>`);
          if (unref(currentSubcategories).length === 0) {
            _push(`<div class="bg-white dark:bg-gray-800 rounded-xl p-6 text-center border border-transparent dark:border-gray-700 transition-colors duration-200"><div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-3"><svg class="w-8 h-8 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path></svg></div><p class="text-sm text-gray-600 dark:text-gray-400"> زیرمجموعه‌ای وجود ندارد </p></div>`);
          } else {
            _push(`<div class="grid grid-cols-2 gap-3"><!--[-->`);
            ssrRenderList(unref(currentSubcategories), (sub) => {
              _push(ssrRenderComponent(_component_NuxtLink, {
                key: sub.id,
                to: `/search/${sub.slug}`,
                class: "bg-white dark:bg-gray-800 rounded-xl p-4 flex flex-col items-center gap-3 hover:shadow-md dark:hover:shadow-gray-900/50 active:scale-[0.98] transition-all border border-transparent dark:border-gray-700"
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="w-16 h-16 bg-linear-to-br from-primary/10 to-primary/20 dark:from-primary/10 dark:to-primary/20 rounded-xl flex items-center justify-center"${_scopeId}>`);
                    if (sub.icon) {
                      _push2(`<img${ssrRenderAttr("src", `${unref(config).public.urlBase}/${sub.icon}`)}${ssrRenderAttr("alt", sub.name)} class="w-10 h-10 object-contain"${_scopeId}>`);
                    } else {
                      _push2(`<svg class="w-8 h-8 text-primary dark:text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"${_scopeId}></path></svg>`);
                    }
                    _push2(`</div><span class="text-sm font-medium text-gray-900 dark:text-white text-center leading-tight line-clamp-2"${_scopeId}>${ssrInterpolate(sub.name)}</span>`);
                  } else {
                    return [
                      createVNode("div", { class: "w-16 h-16 bg-linear-to-br from-primary/10 to-primary/20 dark:from-primary/10 dark:to-primary/20 rounded-xl flex items-center justify-center" }, [
                        sub.icon ? (openBlock(), createBlock("img", {
                          key: 0,
                          src: `${unref(config).public.urlBase}/${sub.icon}`,
                          alt: sub.name,
                          class: "w-10 h-10 object-contain"
                        }, null, 8, ["src", "alt"])) : (openBlock(), createBlock("svg", {
                          key: 1,
                          class: "w-8 h-8 text-primary dark:text-primary",
                          fill: "none",
                          stroke: "currentColor",
                          viewBox: "0 0 24 24"
                        }, [
                          createVNode("path", {
                            "stroke-linecap": "round",
                            "stroke-linejoin": "round",
                            "stroke-width": "2",
                            d: "M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"
                          })
                        ]))
                      ]),
                      createVNode("span", { class: "text-sm font-medium text-gray-900 dark:text-white text-center leading-tight line-clamp-2" }, toDisplayString(sub.name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/categories/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=index-DM5x6fg6.js.map
