
import type { DefineComponent, SlotsType } from 'vue'
type IslandComponent<T> = DefineComponent<{}, {refresh: () => Promise<void>}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, SlotsType<{ fallback: { error: unknown } }>> & T

type HydrationStrategies = {
  hydrateOnVisible?: IntersectionObserverInit | true
  hydrateOnIdle?: number | true
  hydrateOnInteraction?: keyof HTMLElementEventMap | Array<keyof HTMLElementEventMap> | true
  hydrateOnMediaQuery?: string
  hydrateAfter?: number
  hydrateWhen?: boolean
  hydrateNever?: true
}
type LazyComponent<T> = DefineComponent<HydrationStrategies, {}, {}, {}, {}, {}, {}, { hydrated: () => void }> & T

interface _GlobalComponents {
  'AddressModal': typeof import("../../../../../app/components/AddressModal.vue")['default']
  'CardSkeleton': typeof import("../../../../../app/components/CardSkeleton.vue")['default']
  'ChangeReviewModal': typeof import("../../../../../app/components/ChangeReviewModal.vue")['default']
  'CommentsSection': typeof import("../../../../../app/components/CommentsSection.vue")['default']
  'ErrorState': typeof import("../../../../../app/components/ErrorState.vue")['default']
  'Header': typeof import("../../../../../app/components/Header.vue")['default']
  'AmazingSection': typeof import("../../../../../app/components/Home/AmazingSection.vue")['default']
  'BannerSlider': typeof import("../../../../../app/components/Home/BannerSlider.vue")['default']
  'NewestSection': typeof import("../../../../../app/components/Home/NewestSection.vue")['default']
  'SearchBar': typeof import("../../../../../app/components/Home/SearchBar.vue")['default']
  'Navigation': typeof import("../../../../../app/components/Navigation.vue")['default']
  'ProductCard': typeof import("../../../../../app/components/ProductCard.vue")['default']
  'ProductsListPage': typeof import("../../../../../app/components/ProductsListPage.vue")['default']
  'SupportModal': typeof import("../../../../../app/components/SupportModal.vue")['default']
  'Toast': typeof import("../../../../../app/components/Toast.vue")['default']
  'NuxtWelcome': typeof import("../../../../nuxt/dist/app/components/welcome.vue")['default']
  'NuxtLayout': typeof import("../../../../nuxt/dist/app/components/nuxt-layout")['default']
  'NuxtErrorBoundary': typeof import("../../../../nuxt/dist/app/components/nuxt-error-boundary.vue")['default']
  'ClientOnly': typeof import("../../../../nuxt/dist/app/components/client-only")['default']
  'DevOnly': typeof import("../../../../nuxt/dist/app/components/dev-only")['default']
  'ServerPlaceholder': typeof import("../../../../nuxt/dist/app/components/server-placeholder")['default']
  'NuxtLink': typeof import("../../../../nuxt/dist/app/components/nuxt-link")['default']
  'NuxtLoadingIndicator': typeof import("../../../../nuxt/dist/app/components/nuxt-loading-indicator")['default']
  'NuxtTime': typeof import("../../../../nuxt/dist/app/components/nuxt-time.vue")['default']
  'NuxtRouteAnnouncer': typeof import("../../../../nuxt/dist/app/components/nuxt-route-announcer")['default']
  'NuxtImg': typeof import("../../../../nuxt/dist/app/components/nuxt-stubs")['NuxtImg']
  'NuxtPicture': typeof import("../../../../nuxt/dist/app/components/nuxt-stubs")['NuxtPicture']
  'ColorScheme': typeof import("../../../../@nuxtjs/color-mode/dist/runtime/component.vue3.vue")['default']
  'NuxtPage': typeof import("../../../../nuxt/dist/pages/runtime/page")['default']
  'NoScript': typeof import("../../../../nuxt/dist/head/runtime/components")['NoScript']
  'Link': typeof import("../../../../nuxt/dist/head/runtime/components")['Link']
  'Base': typeof import("../../../../nuxt/dist/head/runtime/components")['Base']
  'Title': typeof import("../../../../nuxt/dist/head/runtime/components")['Title']
  'Meta': typeof import("../../../../nuxt/dist/head/runtime/components")['Meta']
  'Style': typeof import("../../../../nuxt/dist/head/runtime/components")['Style']
  'Head': typeof import("../../../../nuxt/dist/head/runtime/components")['Head']
  'Html': typeof import("../../../../nuxt/dist/head/runtime/components")['Html']
  'Body': typeof import("../../../../nuxt/dist/head/runtime/components")['Body']
  'NuxtIsland': typeof import("../../../../nuxt/dist/app/components/nuxt-island")['default']
  'LazyAddressModal': LazyComponent<typeof import("../../../../../app/components/AddressModal.vue")['default']>
  'LazyCardSkeleton': LazyComponent<typeof import("../../../../../app/components/CardSkeleton.vue")['default']>
  'LazyChangeReviewModal': LazyComponent<typeof import("../../../../../app/components/ChangeReviewModal.vue")['default']>
  'LazyCommentsSection': LazyComponent<typeof import("../../../../../app/components/CommentsSection.vue")['default']>
  'LazyErrorState': LazyComponent<typeof import("../../../../../app/components/ErrorState.vue")['default']>
  'LazyHeader': LazyComponent<typeof import("../../../../../app/components/Header.vue")['default']>
  'LazyAmazingSection': LazyComponent<typeof import("../../../../../app/components/Home/AmazingSection.vue")['default']>
  'LazyBannerSlider': LazyComponent<typeof import("../../../../../app/components/Home/BannerSlider.vue")['default']>
  'LazyNewestSection': LazyComponent<typeof import("../../../../../app/components/Home/NewestSection.vue")['default']>
  'LazySearchBar': LazyComponent<typeof import("../../../../../app/components/Home/SearchBar.vue")['default']>
  'LazyNavigation': LazyComponent<typeof import("../../../../../app/components/Navigation.vue")['default']>
  'LazyProductCard': LazyComponent<typeof import("../../../../../app/components/ProductCard.vue")['default']>
  'LazyProductsListPage': LazyComponent<typeof import("../../../../../app/components/ProductsListPage.vue")['default']>
  'LazySupportModal': LazyComponent<typeof import("../../../../../app/components/SupportModal.vue")['default']>
  'LazyToast': LazyComponent<typeof import("../../../../../app/components/Toast.vue")['default']>
  'LazyNuxtWelcome': LazyComponent<typeof import("../../../../nuxt/dist/app/components/welcome.vue")['default']>
  'LazyNuxtLayout': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-layout")['default']>
  'LazyNuxtErrorBoundary': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-error-boundary.vue")['default']>
  'LazyClientOnly': LazyComponent<typeof import("../../../../nuxt/dist/app/components/client-only")['default']>
  'LazyDevOnly': LazyComponent<typeof import("../../../../nuxt/dist/app/components/dev-only")['default']>
  'LazyServerPlaceholder': LazyComponent<typeof import("../../../../nuxt/dist/app/components/server-placeholder")['default']>
  'LazyNuxtLink': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-link")['default']>
  'LazyNuxtLoadingIndicator': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-loading-indicator")['default']>
  'LazyNuxtTime': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-time.vue")['default']>
  'LazyNuxtRouteAnnouncer': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-route-announcer")['default']>
  'LazyNuxtImg': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-stubs")['NuxtImg']>
  'LazyNuxtPicture': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-stubs")['NuxtPicture']>
  'LazyColorScheme': LazyComponent<typeof import("../../../../@nuxtjs/color-mode/dist/runtime/component.vue3.vue")['default']>
  'LazyNuxtPage': LazyComponent<typeof import("../../../../nuxt/dist/pages/runtime/page")['default']>
  'LazyNoScript': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['NoScript']>
  'LazyLink': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Link']>
  'LazyBase': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Base']>
  'LazyTitle': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Title']>
  'LazyMeta': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Meta']>
  'LazyStyle': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Style']>
  'LazyHead': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Head']>
  'LazyHtml': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Html']>
  'LazyBody': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components")['Body']>
  'LazyNuxtIsland': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-island")['default']>
}

declare module 'vue' {
  export interface GlobalComponents extends _GlobalComponents { }
}

export {}
