# ast-kit

[![npm version][npm-version-src]][npm-version-href]
[![npm downloads][npm-downloads-src]][npm-downloads-href]
[![JSR][jsr-src]][jsr-href]
[![Unit Test][unit-test-src]][unit-test-href]
[![codecov][codecov-src]][codecov-href]

A toolkit for easy Babel AST generation and manipulation.

[📖 API Reference](https://jsr.io/@sxzz/ast-kit/doc)

## Features

- **😇 Easy to Use**: Parse and resolve Babel AST with a straightforward API.
- **🦾 Type-Friendly**: Built in TypeScript with complete type definitions.
- **💯 Coverage**: 100% test coverage.
- **🪶 Lightweight**: Tree-shakable with only two dependencies.

## Install

```bash
npm i ast-kit
```

Requires Node.js 20.18.0 or higher.

## AST Explorer

You can explore your code's AST using the [AST Explorer](https://ast.sxzz.moe/).

## Sponsors

<p align="center">
  <a href="https://cdn.jsdelivr.net/gh/sxzz/sponsors/sponsors.svg">
    <img src='https://cdn.jsdelivr.net/gh/sxzz/sponsors/sponsors.svg'/>
  </a>
</p>

## License

[MIT](./LICENSE) License © 2023-PRESENT [Kevin Deng](https://github.com/sxzz)

<!-- Badges -->

[npm-version-src]: https://img.shields.io/npm/v/ast-kit.svg
[npm-version-href]: https://npmjs.com/package/ast-kit
[npm-downloads-src]: https://img.shields.io/npm/dm/ast-kit
[npm-downloads-href]: https://www.npmcharts.com/compare/ast-kit?interval=30
[jsr-src]: https://jsr.io/badges/@sxzz/ast-kit
[jsr-href]: https://jsr.io/@sxzz/ast-kit
[unit-test-src]: https://github.com/sxzz/ast-kit/actions/workflows/unit-test.yml/badge.svg
[unit-test-href]: https://github.com/sxzz/ast-kit/actions/workflows/unit-test.yml
[codecov-src]: https://codecov.io/gh/sxzz/ast-kit/graph/badge.svg?token=MHTCPNMZAK
[codecov-href]: https://codecov.io/gh/sxzz/ast-kit
