import { DEFAULT_OPTIONS } from "./constants.js";
export async function detectBreakpoint(options, input) {
  try {
    if (input.cookie && input.cookie in options.breakpoints) {
      return input.cookie;
    }
    const userAgent = input.headers?.["user-agent"];
    if (!userAgent) {
      return options.fallbackBreakpoint;
    }
    let deviceType = "";
    if (input.headers) {
      if (userAgent === "Amazon CloudFront") {
        const types = {
          "cloudfront-is-android-viewer": "mobile",
          "cloudfront-is-desktop-viewer": "desktop",
          "cloudfront-is-ios-viewer": "mobile",
          "cloudfront-is-mobile-viewer": "mobile",
          "cloudfront-is-smarttv-viewer": "tv",
          "cloudfront-is-tablet-viewer": "tablet"
        };
        for (const key in types) {
          if (input.headers[key] === "true") {
            deviceType = types[key];
            break;
          }
        }
      } else if (input.headers["cf-device-type"]) {
        deviceType = input.headers["cf-device-type"];
      }
    }
    if (!deviceType) {
      const { default: Bowser } = await import(
        /* webpackChunkName: "bowser" */
        "bowser"
      );
      const parser = Bowser.getParser(userAgent);
      deviceType = parser.getPlatformType();
    }
    if (deviceType in options.defaultBreakpoints) {
      return options.defaultBreakpoints[deviceType];
    }
    return options.fallbackBreakpoint;
  } catch (error) {
    console.error(error);
    return options.fallbackBreakpoint;
  }
}
export function parseCookie(input) {
  if (!input.length) {
    return {};
  }
  return Object.fromEntries(input.split(/; */).map((cookie) => cookie.split("=", 2)));
}
export function extendOptions(options = {}, extendFrom = DEFAULT_OPTIONS) {
  return {
    ...extendFrom,
    ...options,
    cookie: {
      ...extendFrom.cookie,
      ...options.cookie
    }
  };
}
