import tailwindcss from "@tailwindcss/vite";

export default defineNuxtConfig({
  runtimeConfig: {
    public: {
      apiBase: "https://irantarabar-shop.ir/api",
      urlBase: "https://irantarabar-shop.ir",
      uploadsBase: "https://irantarabar-shop.ir/uploads",
      mediaBase: "https://irantarabar-shop.ir/upload/files/products/images/",
    },
  },
  compatibilityDate: "2025-07-15",
  devtools: { enabled: false },

  vite: {
    plugins: [tailwindcss()],
  },

  css: ["~/assets/css/main.css"],

  components: [
    {
      path: "~/components",
      pathPrefix: false,
    },
  ],

  imports: {
    dirs: ["utils"],
  },

  app: {
    head: {
      meta: [
        {
          name: "viewport",
          content: "width=device-width, initial-scale=1, maximum-scale=5",
        },
        { name: "mobile-web-app-capable", content: "yes" },
        { name: "apple-mobile-web-app-capable", content: "yes" },
        { name: "apple-mobile-web-app-status-bar-style", content: "default" },
      ],
    },
  },

  modules: [
    "@nuxtjs/color-mode",
    "nuxt-viewport",
    "@pinia/nuxt",
    "pinia-plugin-persistedstate",
    "@vueuse/nuxt",
  ],

  colorMode: {
    preference: "light",
    fallback: "light",
    dataValue: "theme",
    classSuffix: "",
    storageKey: "nuxt-color-mode",
  },
  viewport: {
    breakpoints: {
      mobile: 640,
      tablet: 768,
      laptop: 1024,
      desktop: 1280,
    },
  },
});
